/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.json.simple.JSONObject;

public class TaskPools {
    private static final Logger classLogger = new LoggerImpl(TaskPools.class.getName());
    public static final ExecutorService IO_POOL = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("Global IO pool", false));
    public static final ExecutorService CPU_POOL = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new CustomizableThreadFactory("Global CPU pool", false));
    private static final ScheduledExecutorService DEFAULT_SCHEDULED_POOL;
    public static ScheduledExecutorService SCHEDULED_POOL;

    public static void resetScheduledPool() {
        SCHEDULED_POOL = DEFAULT_SCHEDULED_POOL;
    }

    public static JSONObject getStatsJson(ExecutorService es) {
        JSONObject debugState = new JSONObject();
        debugState.put((Object)"executor_class", (Object)es.getClass().getSimpleName());
        if (es instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor ex = (ThreadPoolExecutor)es;
            debugState.put((Object)"pool_size", (Object)ex.getPoolSize());
            debugState.put((Object)"active_task_count", (Object)ex.getActiveCount());
            debugState.put((Object)"completed_task_count", (Object)ex.getCompletedTaskCount());
            debugState.put((Object)"core_pool_size", (Object)ex.getCorePoolSize());
            debugState.put((Object)"maximum_pool_size", (Object)ex.getMaximumPoolSize());
            debugState.put((Object)"largest_pool_size", (Object)ex.getLargestPoolSize());
            debugState.put((Object)"queue_class", (Object)ex.getQueue().getClass().getSimpleName());
            debugState.put((Object)"pending_task_count", (Object)ex.getQueue().size());
        }
        return debugState;
    }

    public static JSONObject getStatsJson() {
        JSONObject debugState = new JSONObject();
        debugState.put((Object)"IO_POOL", (Object)TaskPools.getStatsJson(IO_POOL));
        debugState.put((Object)"CPU_POOL", (Object)TaskPools.getStatsJson(CPU_POOL));
        return debugState;
    }

    static {
        SCHEDULED_POOL = DEFAULT_SCHEDULED_POOL = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new CustomizableThreadFactory("Global scheduled pool", false));
        classLogger.info((Object)("TaskPools detected " + Runtime.getRuntime().availableProcessors() + " processors, creating the CPU pool with that many threads"));
    }
}

