# Generated by Django 4.0.4 on 2022-05-02 15:56

import django.db.models.deletion
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    dependencies = [
        ("documents", "1018_alter_savedviewfilterrule_value"),
    ]

    operations = [
        migrations.CreateModel(
            name="StoragePath",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=128, unique=True, verbose_name="name"),
                ),
                (
                    "match",
                    models.CharField(blank=True, max_length=256, verbose_name="match"),
                ),
                (
                    "matching_algorithm",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Any word"),
                            (2, "All words"),
                            (3, "Exact match"),
                            (4, "Regular expression"),
                            (5, "Fuzzy word"),
                            (6, "Automatic"),
                        ],
                        default=1,
                        verbose_name="matching algorithm",
                    ),
                ),
                (
                    "is_insensitive",
                    models.BooleanField(default=True, verbose_name="is insensitive"),
                ),
                ("path", models.CharField(max_length=512, verbose_name="path")),
            ],
            options={
                "verbose_name": "storage path",
                "verbose_name_plural": "storage paths",
                "ordering": ("name",),
            },
        ),
        migrations.AddField(
            model_name="document",
            name="storage_path",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="documents",
                to="documents.storagepath",
                verbose_name="storage path",
            ),
        ),
    ]
