# Generated by Django 4.2.13 on 2024-06-28 17:46

import django.db.migrations.operations.special
import django.db.models.deletion
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    replaces = [
        ("paperless_mail", "0001_initial"),
        ("paperless_mail", "0002_auto_20201117_1334"),
        ("paperless_mail", "0003_auto_20201118_1940"),
        ("paperless_mail", "0004_mailrule_order"),
        ("paperless_mail", "0005_help_texts"),
        ("paperless_mail", "0006_auto_20210101_2340"),
        ("paperless_mail", "0007_auto_20210106_0138"),
        ("paperless_mail", "0008_auto_20210516_0940"),
        ("paperless_mail", "0009_mailrule_assign_tags"),
    ]

    dependencies = [
        ("documents", "1002_auto_20201111_1105"),
        ("documents", "1011_auto_20210101_2340"),
    ]

    operations = [
        migrations.CreateModel(
            name="MailAccount",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, unique=True)),
                ("imap_server", models.CharField(max_length=256)),
                ("imap_port", models.IntegerField(blank=True, null=True)),
                (
                    "imap_security",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "No encryption"),
                            (2, "Use SSL"),
                            (3, "Use STARTTLS"),
                        ],
                        default=2,
                    ),
                ),
                ("username", models.CharField(max_length=256)),
                ("password", models.CharField(max_length=256)),
            ],
        ),
        migrations.CreateModel(
            name="MailRule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256)),
                ("folder", models.CharField(default="INBOX", max_length=256)),
                (
                    "filter_from",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                (
                    "filter_subject",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                (
                    "filter_body",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                ("maximum_age", models.PositiveIntegerField(default=30)),
                (
                    "action",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Delete"),
                            (2, "Move to specified folder"),
                            (3, "Mark as read, don't process read mails"),
                            (4, "Flag the mail, don't process flagged mails"),
                        ],
                        default=3,
                        help_text="The action applied to the mail. This action is only performed when documents were consumed from the mail. Mails without attachments will remain entirely untouched.",
                    ),
                ),
                (
                    "action_parameter",
                    models.CharField(
                        blank=True,
                        help_text="Additional parameter for the action selected above, i.e., the target folder of the move to folder action.",
                        max_length=256,
                        null=True,
                    ),
                ),
                (
                    "assign_title_from",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Use subject as title"),
                            (2, "Use attachment filename as title"),
                        ],
                        default=1,
                    ),
                ),
                (
                    "assign_correspondent_from",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Do not assign a correspondent"),
                            (2, "Use mail address"),
                            (3, "Use name (or mail address if not available)"),
                            (4, "Use correspondent selected below"),
                        ],
                        default=1,
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rules",
                        to="paperless_mail.mailaccount",
                    ),
                ),
                (
                    "assign_correspondent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="documents.correspondent",
                    ),
                ),
                (
                    "assign_document_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="documents.documenttype",
                    ),
                ),
                (
                    "assign_tag",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="documents.tag",
                    ),
                ),
            ],
        ),
        migrations.RunPython(
            code=django.db.migrations.operations.special.RunPython.noop,
            reverse_code=django.db.migrations.operations.special.RunPython.noop,
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="imap_port",
            field=models.IntegerField(
                blank=True,
                help_text="This is usually 143 for unencrypted and STARTTLS connections, and 993 for SSL connections.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="name",
            field=models.CharField(max_length=256, unique=True),
        ),
        migrations.AddField(
            model_name="mailrule",
            name="order",
            field=models.IntegerField(default=0),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="action",
            field=models.PositiveIntegerField(
                choices=[
                    (3, "Mark as read, don't process read mails"),
                    (4, "Flag the mail, don't process flagged mails"),
                    (2, "Move to specified folder"),
                    (1, "Delete"),
                ],
                default=3,
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="maximum_age",
            field=models.PositiveIntegerField(
                default=30,
                help_text="Specified in days.",
            ),
        ),
        migrations.AlterModelOptions(
            name="mailaccount",
            options={
                "verbose_name": "mail account",
                "verbose_name_plural": "mail accounts",
            },
        ),
        migrations.AlterModelOptions(
            name="mailrule",
            options={"verbose_name": "mail rule", "verbose_name_plural": "mail rules"},
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="imap_port",
            field=models.IntegerField(
                blank=True,
                help_text="This is usually 143 for unencrypted and STARTTLS connections, and 993 for SSL connections.",
                null=True,
                verbose_name="IMAP port",
            ),
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="imap_security",
            field=models.PositiveIntegerField(
                choices=[(1, "No encryption"), (2, "Use SSL"), (3, "Use STARTTLS")],
                default=2,
                verbose_name="IMAP security",
            ),
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="imap_server",
            field=models.CharField(max_length=256, verbose_name="IMAP server"),
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="name",
            field=models.CharField(max_length=256, unique=True, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="password",
            field=models.CharField(max_length=256, verbose_name="password"),
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="username",
            field=models.CharField(max_length=256, verbose_name="username"),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="account",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="rules",
                to="paperless_mail.mailaccount",
                verbose_name="account",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="action",
            field=models.PositiveIntegerField(
                choices=[
                    (3, "Mark as read, don't process read mails"),
                    (4, "Flag the mail, don't process flagged mails"),
                    (2, "Move to specified folder"),
                    (1, "Delete"),
                ],
                default=3,
                verbose_name="action",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="action_parameter",
            field=models.CharField(
                blank=True,
                help_text="Additional parameter for the action selected above, i.e., the target folder of the move to folder action.",
                max_length=256,
                null=True,
                verbose_name="action parameter",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="assign_correspondent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="documents.correspondent",
                verbose_name="assign this correspondent",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="assign_correspondent_from",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Do not assign a correspondent"),
                    (2, "Use mail address"),
                    (3, "Use name (or mail address if not available)"),
                    (4, "Use correspondent selected below"),
                ],
                default=1,
                verbose_name="assign correspondent from",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="assign_document_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="documents.documenttype",
                verbose_name="assign this document type",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="assign_tag",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="documents.tag",
                verbose_name="assign this tag",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="assign_title_from",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Use subject as title"),
                    (2, "Use attachment filename as title"),
                ],
                default=1,
                verbose_name="assign title from",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="filter_body",
            field=models.CharField(
                blank=True,
                max_length=256,
                null=True,
                verbose_name="filter body",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="filter_from",
            field=models.CharField(
                blank=True,
                max_length=256,
                null=True,
                verbose_name="filter from",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="filter_subject",
            field=models.CharField(
                blank=True,
                max_length=256,
                null=True,
                verbose_name="filter subject",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="folder",
            field=models.CharField(
                default="INBOX",
                max_length=256,
                verbose_name="folder",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="maximum_age",
            field=models.PositiveIntegerField(
                default=30,
                help_text="Specified in days.",
                verbose_name="maximum age",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="name",
            field=models.CharField(max_length=256, unique=True, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="order",
            field=models.IntegerField(default=0, verbose_name="order"),
        ),
        migrations.AddField(
            model_name="mailrule",
            name="attachment_type",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Only process attachments."),
                    (2, "Process all files, including 'inline' attachments."),
                ],
                default=1,
                help_text="Inline attachments include embedded images, so it's best to combine this option with a filename filter.",
                verbose_name="attachment type",
            ),
        ),
        migrations.AddField(
            model_name="mailrule",
            name="filter_attachment_filename",
            field=models.CharField(
                blank=True,
                help_text="Only consume documents which entirely match this filename if specified. Wildcards such as *.pdf or *invoice* are allowed. Case insensitive.",
                max_length=256,
                null=True,
                verbose_name="filter attachment filename",
            ),
        ),
        migrations.AddField(
            model_name="mailaccount",
            name="character_set",
            field=models.CharField(
                default="UTF-8",
                help_text="The character set to use when communicating with the mail server, such as 'UTF-8' or 'US-ASCII'.",
                max_length=256,
                verbose_name="character set",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="action_parameter",
            field=models.CharField(
                blank=True,
                help_text="Additional parameter for the action selected above, i.e., the target folder of the move to folder action. Subfolders must be separated by dots.",
                max_length=256,
                null=True,
                verbose_name="action parameter",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="folder",
            field=models.CharField(
                default="INBOX",
                help_text="Subfolders must be separated by dots.",
                max_length=256,
                verbose_name="folder",
            ),
        ),
        migrations.AddField(
            model_name="mailrule",
            name="assign_tags",
            field=models.ManyToManyField(
                blank=True,
                related_name="mail_rules_multi",
                to="documents.tag",
                verbose_name="assign this tag",
            ),
        ),
    ]
