# Generated by Django 4.2.13 on 2024-06-28 19:39

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    replaces = [
        ("documents", "1045_alter_customfieldinstance_value_monetary"),
        ("documents", "1046_workflowaction_remove_all_correspondents_and_more"),
        ("documents", "1047_savedview_display_mode_and_more"),
        ("documents", "1048_alter_savedviewfilterrule_rule_type"),
        ("documents", "1049_document_deleted_at_document_restored_at"),
    ]

    dependencies = [
        ("documents", "1044_workflow_workflowaction_workflowtrigger_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.AlterField(
            model_name="customfieldinstance",
            name="value_monetary",
            field=models.CharField(max_length=128, null=True),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_all_correspondents",
            field=models.BooleanField(
                default=False,
                verbose_name="remove all correspondents",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_all_custom_fields",
            field=models.BooleanField(
                default=False,
                verbose_name="remove all custom fields",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_all_document_types",
            field=models.BooleanField(
                default=False,
                verbose_name="remove all document types",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_all_owners",
            field=models.BooleanField(default=False, verbose_name="remove all owners"),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_all_permissions",
            field=models.BooleanField(
                default=False,
                verbose_name="remove all permissions",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_all_storage_paths",
            field=models.BooleanField(
                default=False,
                verbose_name="remove all storage paths",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_all_tags",
            field=models.BooleanField(default=False, verbose_name="remove all tags"),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_change_groups",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="auth.group",
                verbose_name="remove change permissions for these groups",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_change_users",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="remove change permissions for these users",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_correspondents",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="documents.correspondent",
                verbose_name="remove these correspondent(s)",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_custom_fields",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="documents.customfield",
                verbose_name="remove these custom fields",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_document_types",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="documents.documenttype",
                verbose_name="remove these document type(s)",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_owners",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="remove these owner(s)",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_storage_paths",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="documents.storagepath",
                verbose_name="remove these storage path(s)",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_tags",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="documents.tag",
                verbose_name="remove these tag(s)",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_view_groups",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="auth.group",
                verbose_name="remove view permissions for these groups",
            ),
        ),
        migrations.AddField(
            model_name="workflowaction",
            name="remove_view_users",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="remove view permissions for these users",
            ),
        ),
        migrations.AlterField(
            model_name="workflowaction",
            name="assign_correspondent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="documents.correspondent",
                verbose_name="assign this correspondent",
            ),
        ),
        migrations.AlterField(
            model_name="workflowaction",
            name="assign_document_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="documents.documenttype",
                verbose_name="assign this document type",
            ),
        ),
        migrations.AlterField(
            model_name="workflowaction",
            name="assign_storage_path",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="documents.storagepath",
                verbose_name="assign this storage path",
            ),
        ),
        migrations.AlterField(
            model_name="workflowaction",
            name="assign_tags",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="documents.tag",
                verbose_name="assign this tag",
            ),
        ),
        migrations.AlterField(
            model_name="workflowaction",
            name="type",
            field=models.PositiveIntegerField(
                choices=[(1, "Assignment"), (2, "Removal")],
                default=1,
                verbose_name="Workflow Action Type",
            ),
        ),
        migrations.AddField(
            model_name="savedview",
            name="display_mode",
            field=models.CharField(
                blank=True,
                choices=[
                    ("table", "Table"),
                    ("smallCards", "Small Cards"),
                    ("largeCards", "Large Cards"),
                ],
                max_length=128,
                null=True,
                verbose_name="View display mode",
            ),
        ),
        migrations.AddField(
            model_name="savedview",
            name="page_size",
            field=models.PositiveIntegerField(
                blank=True,
                null=True,
                validators=[django.core.validators.MinValueValidator(1)],
                verbose_name="View page size",
            ),
        ),
        migrations.AddField(
            model_name="savedview",
            name="display_fields",
            field=models.JSONField(
                blank=True,
                null=True,
                verbose_name="Document display fields",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="rule_type",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "title contains"),
                    (1, "content contains"),
                    (2, "ASN is"),
                    (3, "correspondent is"),
                    (4, "document type is"),
                    (5, "is in inbox"),
                    (6, "has tag"),
                    (7, "has any tag"),
                    (8, "created before"),
                    (9, "created after"),
                    (10, "created year is"),
                    (11, "created month is"),
                    (12, "created day is"),
                    (13, "added before"),
                    (14, "added after"),
                    (15, "modified before"),
                    (16, "modified after"),
                    (17, "does not have tag"),
                    (18, "does not have ASN"),
                    (19, "title or content contains"),
                    (20, "fulltext query"),
                    (21, "more like this"),
                    (22, "has tags in"),
                    (23, "ASN greater than"),
                    (24, "ASN less than"),
                    (25, "storage path is"),
                    (26, "has correspondent in"),
                    (27, "does not have correspondent in"),
                    (28, "has document type in"),
                    (29, "does not have document type in"),
                    (30, "has storage path in"),
                    (31, "does not have storage path in"),
                    (32, "owner is"),
                    (33, "has owner in"),
                    (34, "does not have owner"),
                    (35, "does not have owner in"),
                    (36, "has custom field value"),
                    (37, "is shared by me"),
                    (38, "has custom fields"),
                    (39, "has custom field in"),
                    (40, "does not have custom field in"),
                    (41, "does not have custom field"),
                ],
                verbose_name="rule type",
            ),
        ),
        migrations.AddField(
            model_name="document",
            name="deleted_at",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="document",
            name="restored_at",
            field=models.DateTimeField(blank=True, null=True),
        ),
    ]
