# Generated by Django 5.2.7 on 2026-01-14 16:53

from django.db import migrations
from django.db import models
from django.db.models import F


def populate_action_order(apps, schema_editor):
    WorkflowAction = apps.get_model("documents", "WorkflowAction")
    WorkflowAction.objects.all().update(order=F("id"))


class Migration(migrations.Migration):
    dependencies = [
        ("documents", "1074_workflowrun_deleted_at_workflowrun_restored_at_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="workflowaction",
            name="order",
            field=models.PositiveIntegerField(default=0, verbose_name="order"),
        ),
        migrations.RunPython(
            populate_action_order,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
