/*
 * Decompiled with CFR 0.152.
 */
package org.typelevel.keypool;

import cats.Applicative;
import cats.Applicative$;
import cats.Functor;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Ref$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.syntax.GenSpawnOps$;
import cats.effect.kernel.syntax.package;
import cats.effect.std.Semaphore$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.typelevel.keypool.KeyPool;
import org.typelevel.keypool.KeyPool$;
import org.typelevel.keypool.KeyPoolBuilder$;
import org.typelevel.keypool.Reusable;
import org.typelevel.keypool.internal.PoolMap$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;

public final class KeyPoolBuilder<F, A, B> {
    private final Function1 kpCreate;
    private final Function1 kpDestroy;
    private final Reusable kpDefaultReuseState;
    private final Duration idleTimeAllowedInPool;
    private final Function1 kpMaxPerKey;
    private final int kpMaxIdle;
    private final int kpMaxTotal;
    private final Function1 onReaperException;
    private final GenTemporal<F, Throwable> evidence$1;

    public static <F, A, B> KeyPoolBuilder<F, A, B> apply(Function1<A, Object> function1, Function1<B, Object> function12, GenTemporal<F, Throwable> genTemporal) {
        return KeyPoolBuilder$.MODULE$.apply(function1, function12, genTemporal);
    }

    public KeyPoolBuilder(Function1<A, Object> kpCreate, Function1<B, Object> kpDestroy, Reusable kpDefaultReuseState, Duration idleTimeAllowedInPool, Function1<A, Object> kpMaxPerKey, int kpMaxIdle, int kpMaxTotal, Function1<Throwable, Object> onReaperException, GenTemporal<F, Throwable> evidence$1) {
        this.kpCreate = kpCreate;
        this.kpDestroy = kpDestroy;
        this.kpDefaultReuseState = kpDefaultReuseState;
        this.idleTimeAllowedInPool = idleTimeAllowedInPool;
        this.kpMaxPerKey = kpMaxPerKey;
        this.kpMaxIdle = kpMaxIdle;
        this.kpMaxTotal = kpMaxTotal;
        this.onReaperException = onReaperException;
        this.evidence$1 = evidence$1;
    }

    public Function1<A, F> kpCreate() {
        return this.kpCreate;
    }

    public Function1<B, F> kpDestroy() {
        return this.kpDestroy;
    }

    public Reusable kpDefaultReuseState() {
        return this.kpDefaultReuseState;
    }

    public Duration idleTimeAllowedInPool() {
        return this.idleTimeAllowedInPool;
    }

    public Function1<A, Object> kpMaxPerKey() {
        return this.kpMaxPerKey;
    }

    public int kpMaxIdle() {
        return this.kpMaxIdle;
    }

    public int kpMaxTotal() {
        return this.kpMaxTotal;
    }

    public Function1<Throwable, F> onReaperException() {
        return this.onReaperException;
    }

    private KeyPoolBuilder<F, A, B> copy(Function1<A, F> kpCreate, Function1<B, F> kpDestroy, Reusable kpDefaultReuseState, Duration idleTimeAllowedInPool, Function1<A, Object> kpMaxPerKey, int kpMaxIdle, int kpMaxTotal, Function1<Throwable, F> onReaperException) {
        return new KeyPoolBuilder<F, A, B>(kpCreate, kpDestroy, kpDefaultReuseState, idleTimeAllowedInPool, kpMaxPerKey, kpMaxIdle, kpMaxTotal, onReaperException, this.evidence$1);
    }

    private Function1<A, F> copy$default$1() {
        return this.kpCreate();
    }

    private Function1<B, F> copy$default$2() {
        return this.kpDestroy();
    }

    private Reusable copy$default$3() {
        return this.kpDefaultReuseState();
    }

    private Duration copy$default$4() {
        return this.idleTimeAllowedInPool();
    }

    private Function1<A, Object> copy$default$5() {
        return this.kpMaxPerKey();
    }

    private int copy$default$6() {
        return this.kpMaxIdle();
    }

    private int copy$default$7() {
        return this.kpMaxTotal();
    }

    private Function1<Throwable, F> copy$default$8() {
        return this.onReaperException();
    }

    public KeyPoolBuilder<F, A, B> doOnCreate(Function1<B, F> f) {
        return this.copy((Function1 & Serializable)k -> package.all$.MODULE$.toFlatMapOps(this.kpCreate().apply(k), this.evidence$1).flatMap((Function1 & Serializable)v -> {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(f.apply(v), this.evidence$1);
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.evidence$1), this.evidence$1).void(), this.evidence$1).as(v);
        }), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public KeyPoolBuilder<F, A, B> doOnDestroy(Function1<B, F> f) {
        return this.copy(this.copy$default$1(), (Function1 & Serializable)r -> {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(f.apply(r), this.evidence$1);
            Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.evidence$1), this.evidence$1).void(), this.evidence$1);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.doOnDestroy$$anonfun$1$$anonfun$1(r), this.evidence$1);
        }, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public KeyPoolBuilder<F, A, B> withDefaultReuseState(Reusable defaultReuseState) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), defaultReuseState, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public KeyPoolBuilder<F, A, B> withIdleTimeAllowedInPool(Duration duration) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), duration, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public KeyPoolBuilder<F, A, B> withMaxPerKey(Function1<A, Object> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), f, this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public KeyPoolBuilder<F, A, B> withMaxIdle(int maxIdle) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), maxIdle, this.copy$default$7(), this.copy$default$8());
    }

    public KeyPoolBuilder<F, A, B> withMaxTotal(int total) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), total, this.copy$default$8());
    }

    public KeyPoolBuilder<F, A, B> withOnReaperException(Function1<Throwable, F> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), f);
    }

    public Resource<F, KeyPool<F, A, B>> build() {
        Ref.Make make = Ref$.MODULE$.apply(Ref.Make$.MODULE$.concurrentInstance(this.evidence$1));
        return Resource$.MODULE$.make(Ref.ApplyBuilders$.MODULE$.of$extension(make, PoolMap$.MODULE$.open(0, Predef$.MODULE$.Map().empty())), (Function1 & Serializable)kpVar -> KeyPool$.MODULE$.destroy(kpVar, this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)kpVar -> Resource$.MODULE$.eval(Semaphore$.MODULE$.apply((long)this.kpMaxTotal(), this.evidence$1)).flatMap((Function1 & Serializable)kpMaxTotalSem -> {
            Resource resource;
            Duration duration = this.idleTimeAllowedInPool();
            if (duration instanceof FiniteDuration) {
                FiniteDuration fd = (FiniteDuration)duration;
                FiniteDuration nanos = new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds().max(fd);
                Object object = package.spawn$.MODULE$.genSpawnOps(this.keepRunning$1(KeyPool$.MODULE$.reap(nanos, kpVar, (Function1<Throwable, Object>)this.onReaperException(), this.evidence$1)), this.evidence$1);
                resource = (Resource)package.all$.MODULE$.toFunctorOps((Object)GenSpawnOps$.MODULE$.background$extension(object, this.evidence$1), (Functor)Resource$.MODULE$.catsEffectTemporalForResource(this.evidence$1)).void();
            } else {
                resource = (Resource)Applicative$.MODULE$.apply((Applicative)Resource$.MODULE$.catsEffectTemporalForResource(this.evidence$1)).unit();
            }
            return resource.map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return new KeyPool.KeyPoolConcrete((Function1 & Serializable)a -> Resource$.MODULE$.make(this.kpCreate().apply(a), this.kpDestroy(), this.evidence$1), this.kpDefaultReuseState(), this.kpMaxPerKey(), this.kpMaxIdle(), this.kpMaxTotal(), kpMaxTotalSem, kpVar, this.evidence$1);
            });
        }));
    }

    private final Object doOnDestroy$$anonfun$1$$anonfun$1(Object r$1) {
        return this.kpDestroy().apply(r$1);
    }

    private final Object keepRunning$1$$anonfun$1(Object fa$1) {
        return this.keepRunning$1(fa$1);
    }

    private final Object keepRunning$1(Object fa) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(fa, this.evidence$1);
        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.onError$extension(object, (PartialFunction)new Serializable(this){
            private final /* synthetic */ KeyPoolBuilder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable e = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable e = throwable = x;
                return this.$outer.onReaperException().apply((Object)e);
            }
        }, this.evidence$1), this.evidence$1);
        Object object3 = package.all$.MODULE$.catsSyntaxFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.evidence$1), this.evidence$1);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this.keepRunning$1$$anonfun$1(fa), this.evidence$1);
    }
}

