/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Functor;
import cats.Invariant;
import cats.arrow.FunctionK;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.syntax.MonadCancelOps_$;
import cats.effect.kernel.syntax.package;
import cats.effect.std.Dequeue$;
import cats.effect.std.Dequeue$State$;
import cats.effect.std.DequeueSink;
import cats.effect.std.DequeueSource;
import cats.effect.std.Queue;
import cats.effect.std.internal.BankersQueue;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface Dequeue<F, A>
extends DequeueSource<F, A>,
DequeueSink<F, A> {
    public static <F, A> Object bounded(int n, GenConcurrent<F, ?> genConcurrent) {
        return Dequeue$.MODULE$.bounded(n, genConcurrent);
    }

    public static <F> Invariant<?> catsInvariantForDequeue(Functor<F> functor) {
        return Dequeue$.MODULE$.catsInvariantForDequeue(functor);
    }

    public static <F, A> Object unbounded(GenConcurrent<F, ?> genConcurrent) {
        return Dequeue$.MODULE$.unbounded(genConcurrent);
    }

    public F reverse();

    public static Dequeue mapK$(Dequeue $this, FunctionK f) {
        return $this.mapK(f);
    }

    default public <G> Dequeue<G, A> mapK(FunctionK<F, G> f) {
        return new Dequeue<G, A>(f, this){
            private final FunctionK f$1;
            private final /* synthetic */ Dequeue $outer;
            {
                this.f$1 = f$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object offerBack(Object a) {
                return this.f$1.apply(this.$outer.offerBack(a));
            }

            public Object tryOfferBack(Object a) {
                return this.f$1.apply(this.$outer.tryOfferBack(a));
            }

            public Object takeBack() {
                return this.f$1.apply(this.$outer.takeBack());
            }

            public Object tryTakeBack() {
                return this.f$1.apply(this.$outer.tryTakeBack());
            }

            public Object offerFront(Object a) {
                return this.f$1.apply(this.$outer.offerFront(a));
            }

            public Object tryOfferFront(Object a) {
                return this.f$1.apply(this.$outer.tryOfferFront(a));
            }

            public Object takeFront() {
                return this.f$1.apply(this.$outer.takeFront());
            }

            public Object tryTakeFront() {
                return this.f$1.apply(this.$outer.tryTakeFront());
            }

            public Object reverse() {
                return this.f$1.apply(this.$outer.reverse());
            }

            public Object size() {
                return this.f$1.apply(this.$outer.size());
            }
        };
    }

    public static class BoundedDequeue<F, A>
    extends Queue<F, A>
    implements Dequeue<F, A> {
        private final int capacity;
        private final Ref<F, State<F, A>> state;
        private final GenConcurrent<F, ?> F;
        private final F notifyNextTaker;

        public BoundedDequeue(int capacity, Ref<F, State<F, A>> state, GenConcurrent<F, ?> F) {
            this.capacity = capacity;
            this.state = state;
            this.F = F;
            this.notifyNextTaker = state.modify((Function1 & Serializable)s -> {
                if (s.takers().isEmpty()) {
                    State state = (State)Predef$.MODULE$.ArrowAssoc(s);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, F.unit());
                }
                Tuple2 tuple2 = s.takers().dequeue();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Deferred taker = (Deferred)tuple2._1();
                scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                Deferred taker2 = (Deferred)tuple22._1();
                scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), rest2, s.copy$default$4()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), (Functor)F).void());
            });
        }

        @Override
        public F offerBack(A a) {
            return this._offer(a, (Function1 & Serializable)_$12 -> _$12.pushBack(a));
        }

        @Override
        public F tryOfferBack(A a) {
            return this._tryOffer((Function1 & Serializable)_$13 -> _$13.pushBack(a));
        }

        @Override
        public F takeBack() {
            return this._take((Function1 & Serializable)_$14 -> _$14.tryPopBack());
        }

        @Override
        public F tryTakeBack() {
            return this._tryTake((Function1 & Serializable)_$15 -> _$15.tryPopBack());
        }

        @Override
        public F offerFront(A a) {
            return this._offer(a, (Function1 & Serializable)_$16 -> _$16.pushFront(a));
        }

        @Override
        public F tryOfferFront(A a) {
            return this._tryOffer((Function1 & Serializable)_$17 -> _$17.pushFront(a));
        }

        @Override
        public F takeFront() {
            return this._take((Function1 & Serializable)_$18 -> _$18.tryPopFront());
        }

        @Override
        public F tryTakeFront() {
            return this._tryTake((Function1 & Serializable)_$19 -> _$19.tryPopFront());
        }

        @Override
        public F reverse() {
            return (F)this.state.update((Function1 & Serializable)x$1 -> {
                State state = x$1;
                if (state != null) {
                    State state2 = Dequeue$State$.MODULE$.unapply(state);
                    BankersQueue bankersQueue = state2._1();
                    int n = state2._2();
                    scala.collection.immutable.Queue queue = state2._3();
                    scala.collection.immutable.Queue queue2 = state2._4();
                    BankersQueue queue3 = bankersQueue;
                    int size = n;
                    scala.collection.immutable.Queue takers = queue;
                    scala.collection.immutable.Queue offerers = queue2;
                    return Dequeue$State$.MODULE$.apply(queue3.reverse(), size, takers, offerers);
                }
                throw new MatchError((Object)state);
            });
        }

        private F _offer(A a, Function1<BankersQueue<A>, BankersQueue<A>> update) {
            return (F)this.F.uncancelable((Function1 & Serializable)poll -> package.all$.MODULE$.toFlatMapOps(this.F.deferred(), this.F).flatMap((Function1 & Serializable)offerer -> {
                Object object = package.all$.MODULE$.catsSyntaxFlatten(this.state.modify((Function1 & Serializable)x$1 -> {
                    State s2;
                    State state;
                    State state2 = x$1;
                    if (state2 != null) {
                        State state3 = Dequeue$State$.MODULE$.unapply(state2);
                        BankersQueue bankersQueue = state3._1();
                        int n = state3._2();
                        scala.collection.immutable.Queue queue = state3._3();
                        scala.collection.immutable.Queue queue2 = state3._4();
                        BankersQueue queue3 = bankersQueue;
                        int size = n;
                        scala.collection.immutable.Queue takers = queue;
                        scala.collection.immutable.Queue offerers = queue2;
                        if (takers.nonEmpty()) {
                            Tuple2 tuple2 = takers.dequeue();
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Deferred taker = (Deferred)tuple2._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                            Deferred taker2 = (Deferred)tuple22._1();
                            scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                            State state4 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply((BankersQueue)update.apply(queue3), size, rest2, offerers));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), this.F).void());
                        }
                        BankersQueue queue4 = bankersQueue;
                        int size2 = n;
                        scala.collection.immutable.Queue takers2 = queue;
                        scala.collection.immutable.Queue offerers2 = queue2;
                        if (size2 < this.capacity) {
                            State state5 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply((BankersQueue)update.apply(queue4), size2 + 1, takers2, offerers2));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, this.F.unit());
                        }
                    }
                    if ((state = (s2 = state2)) == null) {
                        throw new MatchError((Object)state);
                    }
                    State state6 = Dequeue$State$.MODULE$.unapply(state);
                    BankersQueue bankersQueue = state6._1();
                    int n = state6._2();
                    scala.collection.immutable.Queue queue = state6._3();
                    scala.collection.immutable.Queue queue5 = state6._4();
                    BankersQueue queue6 = bankersQueue;
                    int size = n;
                    scala.collection.immutable.Queue takers = queue;
                    scala.collection.immutable.Queue offerers = queue5;
                    Tuple4 tuple4 = Tuple4$.MODULE$.apply(queue6, (Object)BoxesRunTime.boxToInteger((int)size), takers, offerers);
                    BankersQueue queue7 = (BankersQueue)tuple4._1();
                    int size3 = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    scala.collection.immutable.Queue takers3 = (scala.collection.immutable.Queue)tuple4._3();
                    scala.collection.immutable.Queue offerers3 = (scala.collection.immutable.Queue)tuple4._4();
                    Object cleanup = this.state.modify((Function1 & Serializable)s -> {
                        scala.collection.immutable.Queue offerers2 = (scala.collection.immutable.Queue)s.offerers().filter((Function1 & Serializable)_$20 -> _$20 != offerer);
                        if (offerers2.isEmpty()) {
                            State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), offerers2));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, this.F.unit());
                        }
                        Tuple2 tuple2 = offerers2.dequeue();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deferred release = (Deferred)tuple2._1();
                        scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)release, (Object)rest);
                        Deferred release2 = (Deferred)tuple22._1();
                        scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                        State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), rest2));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, package.all$.MODULE$.toFunctorOps(release2.complete((Object)BoxedUnit.UNIT), this.F).void());
                    });
                    State state7 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply(queue7, size3, takers3, offerers3.enqueue(offerer)));
                    Object object = package.all$.MODULE$.monadCancelOps_(package.all$.MODULE$.catsSyntaxApply(poll.apply(offerer.get()), this.F).$times$greater(poll.apply(this._offer(a, update))));
                    Object object2 = package.all$.MODULE$.catsSyntaxFlatten(cleanup, this.F);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state7, MonadCancelOps_$.MODULE$.onCancel$extension(object, FlattenOps$.MODULE$.flatten$extension(object2, this.F), this.F));
                }), this.F);
                return FlattenOps$.MODULE$.flatten$extension(object, this.F);
            }));
        }

        private F _tryOffer(Function1<BankersQueue<A>, BankersQueue<A>> update) {
            return (F)this.state.flatModify((Function1 & Serializable)x$1 -> {
                State state = x$1;
                if (state != null) {
                    State state2 = Dequeue$State$.MODULE$.unapply(state);
                    BankersQueue bankersQueue = state2._1();
                    int n = state2._2();
                    scala.collection.immutable.Queue queue = state2._3();
                    scala.collection.immutable.Queue queue2 = state2._4();
                    BankersQueue queue3 = bankersQueue;
                    int size = n;
                    scala.collection.immutable.Queue takers = queue;
                    scala.collection.immutable.Queue offerers = queue2;
                    if (takers.nonEmpty()) {
                        Tuple2 tuple2 = takers.dequeue();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deferred taker = (Deferred)tuple2._1();
                        scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                        Deferred taker2 = (Deferred)tuple22._1();
                        scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                        State state3 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply((BankersQueue)update.apply(queue3), size, rest2, offerers));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), this.F).as((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    }
                    BankersQueue queue4 = bankersQueue;
                    int size2 = n;
                    scala.collection.immutable.Queue takers2 = queue;
                    scala.collection.immutable.Queue offerers2 = queue2;
                    if (size2 < this.capacity) {
                        State state4 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply((BankersQueue)update.apply(queue4), size2 + 1, takers2, offerers2));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    }
                }
                State s = state;
                State state5 = (State)Predef$.MODULE$.ArrowAssoc((Object)s);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)false)));
            }, this.F);
        }

        private F _take(Function1<BankersQueue<A>, Tuple2<BankersQueue<A>, Option<A>>> dequeue) {
            return (F)this.F.uncancelable((Function1 & Serializable)poll -> package.all$.MODULE$.toFlatMapOps(this.F.deferred(), this.F).flatMap((Function1 & Serializable)taker -> {
                Object modificationF = this.state.modify((Function1 & Serializable)x$1 -> {
                    State state = x$1;
                    if (state != null) {
                        Tuple2 tuple2;
                        State state2 = Dequeue$State$.MODULE$.unapply(state);
                        BankersQueue bankersQueue = state2._1();
                        int n = state2._2();
                        scala.collection.immutable.Queue queue = state2._3();
                        scala.collection.immutable.Queue queue2 = state2._4();
                        BankersQueue queue3 = bankersQueue;
                        int size = n;
                        scala.collection.immutable.Queue takers = queue;
                        scala.collection.immutable.Queue offerers = queue2;
                        if (queue3.nonEmpty() && offerers.isEmpty()) {
                            Tuple2 tuple22 = (Tuple2)dequeue.apply(queue3);
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            BankersQueue rest = (BankersQueue)tuple22._1();
                            Option ma = (Option)tuple22._2();
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)rest, (Object)ma);
                            BankersQueue rest2 = (BankersQueue)tuple23._1();
                            Option ma2 = (Option)tuple23._2();
                            Object a = ma2.get();
                            State state3 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply(rest2, size - 1, takers, offerers));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, this.F.pure(a));
                        }
                        BankersQueue queue4 = bankersQueue;
                        int size2 = n;
                        scala.collection.immutable.Queue takers2 = queue;
                        scala.collection.immutable.Queue offerers2 = queue2;
                        if (queue4.nonEmpty()) {
                            Tuple2 tuple24 = (Tuple2)dequeue.apply(queue4);
                            if (tuple24 == null) {
                                throw new MatchError((Object)tuple24);
                            }
                            BankersQueue rest = (BankersQueue)tuple24._1();
                            Option ma = (Option)tuple24._2();
                            Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)rest, (Object)ma);
                            BankersQueue rest3 = (BankersQueue)tuple25._1();
                            Option ma3 = (Option)tuple25._2();
                            Object a = ma3.get();
                            Tuple2 tuple26 = offerers2.dequeue();
                            if (tuple26 == null) {
                                throw new MatchError((Object)tuple26);
                            }
                            Deferred release = (Deferred)tuple26._1();
                            scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple26._2();
                            Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)release, (Object)tail);
                            Deferred release2 = (Deferred)tuple27._1();
                            scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple27._2();
                            State state4 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply(rest3, size2 - 1, takers2, tail2));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, package.all$.MODULE$.toFunctorOps(release2.complete((Object)BoxedUnit.UNIT), this.F).as(a));
                        }
                        BankersQueue queue5 = bankersQueue;
                        int size3 = n;
                        scala.collection.immutable.Queue takers3 = queue;
                        scala.collection.immutable.Queue offerers3 = queue2;
                        Object cleanup = this.state.modify((Function1 & Serializable)s -> {
                            scala.collection.immutable.Queue takers2 = (scala.collection.immutable.Queue)s.takers().filter((Function1 & Serializable)_$21 -> _$21 != taker);
                            if (takers2.isEmpty()) {
                                State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), takers2, s.copy$default$4()));
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, this.F.unit());
                            }
                            Tuple2 tuple2 = takers2.dequeue();
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Deferred taker = (Deferred)tuple2._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                            Deferred taker2 = (Deferred)tuple22._1();
                            scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                            State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), rest2, s.copy$default$4()));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), this.F).void());
                        });
                        Object object = package.all$.MODULE$.monadCancelOps_(poll.apply(taker.get()));
                        Object object2 = package.all$.MODULE$.catsSyntaxFlatten(cleanup, this.F);
                        Object object3 = package.all$.MODULE$.monadCancelOps_(poll.apply(this._take(dequeue)));
                        Object object4 = package.all$.MODULE$.catsSyntaxFlatten(this.notifyNextTaker, this.F);
                        Object await = package.all$.MODULE$.catsSyntaxApply(MonadCancelOps_$.MODULE$.onCancel$extension(object, FlattenOps$.MODULE$.flatten$extension(object2, this.F), this.F), this.F).$times$greater(MonadCancelOps_$.MODULE$.onCancel$extension(object3, FlattenOps$.MODULE$.flatten$extension(object4, this.F), this.F));
                        if (offerers3.isEmpty()) {
                            tuple2 = Tuple2$.MODULE$.apply(await, offerers3);
                        } else {
                            Tuple2 tuple28 = offerers3.dequeue();
                            if (tuple28 == null) {
                                throw new MatchError((Object)tuple28);
                            }
                            Deferred release = (Deferred)tuple28._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple28._2();
                            Tuple2 tuple29 = Tuple2$.MODULE$.apply((Object)release, (Object)rest);
                            Deferred release3 = (Deferred)tuple29._1();
                            scala.collection.immutable.Queue rest4 = (scala.collection.immutable.Queue)tuple29._2();
                            tuple2 = Tuple2$.MODULE$.apply(package.all$.MODULE$.catsSyntaxApply(release3.complete((Object)BoxedUnit.UNIT), this.F).$times$greater(await), (Object)rest4);
                        }
                        Tuple2 tuple210 = tuple2;
                        Object fulfill = tuple210._1();
                        scala.collection.immutable.Queue offerers22 = (scala.collection.immutable.Queue)tuple210._2();
                        State state5 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply(queue5, size3, takers3.enqueue(taker), offerers22));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, fulfill);
                    }
                    throw new MatchError((Object)state);
                });
                Object object = package.all$.MODULE$.catsSyntaxFlatten(modificationF, this.F);
                return FlattenOps$.MODULE$.flatten$extension(object, this.F);
            }));
        }

        private F _tryTake(Function1<BankersQueue<A>, Tuple2<BankersQueue<A>, Option<A>>> dequeue) {
            return (F)this.state.flatModify((Function1 & Serializable)x$1 -> {
                State state = x$1;
                if (state != null) {
                    State state2 = Dequeue$State$.MODULE$.unapply(state);
                    BankersQueue bankersQueue = state2._1();
                    int n = state2._2();
                    scala.collection.immutable.Queue queue = state2._3();
                    scala.collection.immutable.Queue queue2 = state2._4();
                    BankersQueue queue3 = bankersQueue;
                    int size = n;
                    scala.collection.immutable.Queue takers = queue;
                    scala.collection.immutable.Queue offerers = queue2;
                    if (queue3.nonEmpty() && offerers.isEmpty()) {
                        Tuple2 tuple2 = (Tuple2)dequeue.apply(queue3);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        BankersQueue rest = (BankersQueue)tuple2._1();
                        Option ma = (Option)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)rest, (Object)ma);
                        BankersQueue rest2 = (BankersQueue)tuple22._1();
                        Option ma2 = (Option)tuple22._2();
                        State state3 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply(rest2, size - 1, takers, offerers));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, this.F.pure((Object)ma2));
                    }
                    BankersQueue queue4 = bankersQueue;
                    int size2 = n;
                    scala.collection.immutable.Queue takers2 = queue;
                    scala.collection.immutable.Queue offerers2 = queue2;
                    if (queue4.nonEmpty()) {
                        Tuple2 tuple2 = (Tuple2)dequeue.apply(queue4);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        BankersQueue rest = (BankersQueue)tuple2._1();
                        Option ma = (Option)tuple2._2();
                        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)rest, (Object)ma);
                        BankersQueue rest3 = (BankersQueue)tuple23._1();
                        Option ma3 = (Option)tuple23._2();
                        Tuple2 tuple24 = offerers2.dequeue();
                        if (tuple24 == null) {
                            throw new MatchError((Object)tuple24);
                        }
                        Deferred release = (Deferred)tuple24._1();
                        scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple24._2();
                        Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)release, (Object)tail);
                        Deferred release2 = (Deferred)tuple25._1();
                        scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple25._2();
                        State state4 = (State)Predef$.MODULE$.ArrowAssoc(Dequeue$State$.MODULE$.apply(rest3, size2 - 1, takers2, tail2));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, package.all$.MODULE$.toFunctorOps(release2.complete((Object)BoxedUnit.UNIT), this.F).as((Object)ma3));
                    }
                }
                State s = state;
                State state5 = (State)Predef$.MODULE$.ArrowAssoc((Object)s);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, this.F.pure((Object)package.all$.MODULE$.none()));
            }, this.F);
        }

        @Override
        public F size() {
            return (F)package.all$.MODULE$.toFunctorOps(this.state.get(), this.F).map((Function1 & Serializable)_$22 -> _$22.size());
        }
    }

    public static final class State<F, A>
    implements Product,
    Serializable {
        private final BankersQueue queue;
        private final int size;
        private final scala.collection.immutable.Queue takers;
        private final scala.collection.immutable.Queue offerers;

        public static <F, A> State<F, A> apply(BankersQueue<A> bankersQueue, int n, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue2) {
            return Dequeue$State$.MODULE$.apply(bankersQueue, n, queue, queue2);
        }

        public static <F, A> State<F, A> empty() {
            return Dequeue$State$.MODULE$.empty();
        }

        public static State<?, ?> fromProduct(Product product) {
            return Dequeue$State$.MODULE$.fromProduct(product);
        }

        public static <F, A> State<F, A> unapply(State<F, A> state) {
            return Dequeue$State$.MODULE$.unapply(state);
        }

        public State(BankersQueue<A> queue, int size, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers) {
            this.queue = queue;
            this.size = size;
            this.takers = takers;
            this.offerers = offerers;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queue()));
            n = Statics.mix((int)n, (int)this.size());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.takers()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.offerers()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.size() != state.size()) return false;
            BankersQueue<A> bankersQueue = this.queue();
            BankersQueue<A> bankersQueue2 = state.queue();
            if (bankersQueue == null) {
                if (bankersQueue2 != null) {
                    return false;
                }
            } else if (!((Object)bankersQueue).equals(bankersQueue2)) return false;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue = this.takers();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue2 = state.takers();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue3 = this.offerers();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue4 = state.offerers();
            if (queue3 == null) {
                if (queue4 == null) return true;
                return false;
            } else {
                if (!queue3.equals(queue4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "queue";
                }
                case 1: {
                    return "size";
                }
                case 2: {
                    return "takers";
                }
                case 3: {
                    return "offerers";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BankersQueue<A> queue() {
            return this.queue;
        }

        public int size() {
            return this.size;
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers() {
            return this.takers;
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers() {
            return this.offerers;
        }

        public <F, A> State<F, A> copy(BankersQueue<A> queue, int size, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers) {
            return new State<F, A>(queue, size, takers, offerers);
        }

        public <F, A> BankersQueue<A> copy$default$1() {
            return this.queue();
        }

        public int copy$default$2() {
            return this.size();
        }

        public <F, A> scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> copy$default$3() {
            return this.takers();
        }

        public <F, A> scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> copy$default$4() {
            return this.offerers();
        }

        public BankersQueue<A> _1() {
            return this.queue();
        }

        public int _2() {
            return this.size();
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> _3() {
            return this.takers();
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> _4() {
            return this.offerers();
        }
    }
}

