/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.Show;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import com.comcast.ip4s.Dns;
import com.comcast.ip4s.Dns$;
import com.comcast.ip4s.Host$;
import com.comcast.ip4s.HostPlatform;
import com.comcast.ip4s.Hostname;
import com.comcast.ip4s.IDN;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv6Address;
import java.io.Serializable;
import java.net.UnknownHostException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public interface Host
extends HostPlatform,
Ordered<Host> {
    public static Option<Host> fromString(String string) {
        return Host$.MODULE$.fromString(string);
    }

    public static Order<Host> order() {
        return Host$.MODULE$.order();
    }

    public static Ordering<Host> ordering() {
        return Host$.MODULE$.ordering();
    }

    public static Show<Host> show() {
        return Host$.MODULE$.show();
    }

    public static int compare$(Host $this, Host that) {
        return $this.compare(that);
    }

    default public int compare(Host that) {
        Host host = this;
        if (host instanceof Ipv4Address) {
            Ipv4Address x = (Ipv4Address)host;
            Host host2 = that;
            if (host2 instanceof Ipv4Address) {
                Ipv4Address y = (Ipv4Address)host2;
                return IpAddress$.MODULE$.compareBytes(x, y);
            }
            if (host2 instanceof Ipv6Address) {
                Ipv6Address y = (Ipv6Address)host2;
                return IpAddress$.MODULE$.compareBytes(x.toCompatV6(), y);
            }
            return -1;
        }
        if (host instanceof Ipv6Address) {
            Ipv6Address x = (Ipv6Address)host;
            Host host3 = that;
            if (host3 instanceof Ipv4Address) {
                Ipv4Address y = (Ipv4Address)host3;
                return IpAddress$.MODULE$.compareBytes(x, y.toCompatV6());
            }
            if (host3 instanceof Ipv6Address) {
                Ipv6Address y = (Ipv6Address)host3;
                return IpAddress$.MODULE$.compareBytes(x, y);
            }
            return -1;
        }
        if (host instanceof Hostname) {
            Hostname x = (Hostname)host;
            Host host4 = that;
            if (host4 instanceof Ipv4Address) {
                return 1;
            }
            if (host4 instanceof Ipv6Address) {
                return 1;
            }
            if (host4 instanceof Hostname) {
                Hostname y = (Hostname)host4;
                return package.all$.MODULE$.catsSyntaxOrder((Object)x.toString(), (Order)Eq$.MODULE$.catsKernelInstancesForString()).compare((Object)y.toString());
            }
            if (host4 instanceof IDN) {
                IDN y = (IDN)host4;
                return package.all$.MODULE$.catsSyntaxOrder((Object)x.toString(), (Order)Eq$.MODULE$.catsKernelInstancesForString()).compare((Object)y.hostname().toString());
            }
            throw new MatchError((Object)host4);
        }
        if (host instanceof IDN) {
            IDN x = (IDN)host;
            Host host5 = that;
            if (host5 instanceof Ipv4Address) {
                return 1;
            }
            if (host5 instanceof Ipv6Address) {
                return 1;
            }
            if (host5 instanceof Hostname) {
                Hostname y = (Hostname)host5;
                return package.all$.MODULE$.catsSyntaxOrder((Object)x.hostname().toString(), (Order)Eq$.MODULE$.catsKernelInstancesForString()).compare((Object)y.toString());
            }
            if (host5 instanceof IDN) {
                IDN y = (IDN)host5;
                return package.all$.MODULE$.catsSyntaxOrder((Object)x.hostname().toString(), (Order)Eq$.MODULE$.catsKernelInstancesForString()).compare((Object)y.hostname().toString());
            }
            throw new MatchError((Object)host5);
        }
        throw new MatchError((Object)host);
    }

    public static Object resolve$(Host $this, Dns evidence$1, Applicative evidence$2) {
        return $this.resolve(evidence$1, evidence$2);
    }

    default public <F> Object resolve(Dns<F> evidence$1, Applicative<F> evidence$2) {
        Host host = this;
        if (host instanceof IpAddress) {
            IpAddress ip = (IpAddress)host;
            return Applicative$.MODULE$.apply(evidence$2).pure((Object)ip);
        }
        if (host instanceof Hostname) {
            Hostname hostname = (Hostname)host;
            return Dns$.MODULE$.apply(evidence$1).resolve(hostname);
        }
        if (host instanceof IDN) {
            IDN idn = (IDN)host;
            return Dns$.MODULE$.apply(evidence$1).resolve(idn.hostname());
        }
        throw new MatchError((Object)host);
    }

    public static Object resolveOption$(Host $this, Dns evidence$3, ApplicativeError evidence$4) {
        return $this.resolveOption(evidence$3, evidence$4);
    }

    default public <F> Object resolveOption(Dns<F> evidence$3, ApplicativeError<F, Throwable> evidence$4) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(this.resolve(evidence$3, (Applicative<F>)evidence$4), evidence$4).map((Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3)), evidence$4);
        return ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof UnknownHostException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof UnknownHostException) {
                    return None$.MODULE$;
                }
                return function1.apply((Object)x);
            }
        }, evidence$4);
    }

    public static Object resolveAll$(Host $this, Dns evidence$5, Applicative evidence$6) {
        return $this.resolveAll(evidence$5, evidence$6);
    }

    default public <F> Object resolveAll(Dns<F> evidence$5, Applicative<F> evidence$6) {
        Host host = this;
        if (host instanceof IpAddress) {
            IpAddress ip = (IpAddress)host;
            return Applicative$.MODULE$.apply(evidence$6).pure(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IpAddress[]{ip})));
        }
        if (host instanceof Hostname) {
            Hostname hostname = (Hostname)host;
            return Dns$.MODULE$.apply(evidence$5).resolveAll(hostname);
        }
        if (host instanceof IDN) {
            IDN idn = (IDN)host;
            return Dns$.MODULE$.apply(evidence$5).resolveAll(idn.hostname());
        }
        throw new MatchError((Object)host);
    }
}

