/*
 * Decompiled with CFR 0.152.
 */
package sharry.common;

import cats.Functor;
import cats.effect.kernel.Sync;
import cats.implicits$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Right;
import sharry.common.Duration;
import sharry.common.Timestamp;
import sharry.common.Timestamp$;

public final class Duration$
implements Serializable {
    private static final long zero;
    public static final Duration$ MODULE$;

    private Duration$() {
    }

    static {
        MODULE$ = new Duration$();
        zero = 0L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Duration$.class);
    }

    public long zero() {
        return zero;
    }

    public Either<String, Duration> fromString(String s) {
        Option option = StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(s));
        if (option instanceof Some) {
            long n = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return package$.MODULE$.Right().apply((Object)new Duration(this.millis(n)));
        }
        if (None$.MODULE$.equals(option)) {
            Right right;
            try {
                right = package$.MODULE$.Right().apply((Object)new Duration(this.apply(scala.concurrent.duration.Duration$.MODULE$.apply(s))));
            }
            catch (Throwable ex) {
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(21).append("Invalid duration '").append(s).append("': ").append(ex.getMessage()).toString());
            }
            return right;
        }
        throw new MatchError((Object)option);
    }

    public long apply(scala.concurrent.duration.Duration d) {
        return d.toNanos();
    }

    public long apply(java.time.Duration d) {
        return d.toNanos();
    }

    public long seconds(long n) {
        return this.apply(java.time.Duration.ofSeconds(n));
    }

    public long millis(long n) {
        return this.apply(java.time.Duration.ofMillis(n));
    }

    public long minutes(long n) {
        return this.apply(java.time.Duration.ofMinutes(n));
    }

    public long hours(long n) {
        return this.apply(java.time.Duration.ofHours(n));
    }

    public long days(long n) {
        return this.apply(java.time.Duration.ofDays(n));
    }

    public long nanos(long n) {
        return n;
    }

    public <F> Object stopTime(Sync<F> evidence$1) {
        return implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(Timestamp$.MODULE$.current(evidence$1), evidence$1).map((Function1 & Serializable)now -> {
            Object end = Timestamp$.MODULE$.current(evidence$1);
            return Tuple2$.MODULE$.apply(now, end);
        }), evidence$1).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Timestamp now = (Timestamp)tuple2._1();
                Object end = tuple2._2();
                return implicits$.MODULE$.toFunctorOps(end, (Functor)evidence$1).map((Function1 & Serializable)e -> new Duration(Duration$.MODULE$.millis(e.toMillis() - now.toMillis())));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Decoder<Duration> jsonDecoder() {
        return Decoder$.MODULE$.decodeLong().map((Function1 & Serializable)v1 -> new Duration(Duration$.MODULE$.millis(BoxesRunTime.unboxToLong((Object)v1))));
    }

    public Encoder<Duration> jsonEncoder() {
        return Encoder$.MODULE$.encodeLong().contramap((Function1 & Serializable)_$2 -> Duration$.MODULE$.millis$extension(_$2 == null ? BoxesRunTime.unboxToLong(null) : ((Duration)_$2).nanos()));
    }

    public final int hashCode$extension(long $this) {
        return BoxesRunTime.boxToLong((long)$this).hashCode();
    }

    public final boolean equals$extension(long $this, Object x$0) {
        Object object = x$0;
        if (object instanceof Duration) {
            long l = object == null ? BoxesRunTime.unboxToLong(null) : ((Duration)object).nanos();
            return $this == l;
        }
        return false;
    }

    public final boolean $less$eq$extension(long $this, long other) {
        return $this <= other;
    }

    public final boolean $greater$eq$extension(long $this, long other) {
        return $this >= other;
    }

    public final long $plus$extension(long $this, long other) {
        return $this + other;
    }

    public final long millis$extension(long $this) {
        return $this / 1000000L;
    }

    public final long seconds$extension(long $this) {
        return this.millis$extension($this) / 1000L;
    }

    public final long minutes$extension(long $this) {
        return this.seconds$extension($this) / 60L;
    }

    public final FiniteDuration toScala$extension(long $this) {
        return FiniteDuration$.MODULE$.apply($this, TimeUnit.NANOSECONDS);
    }

    public final java.time.Duration toJava$extension(long $this) {
        return java.time.Duration.ofNanos($this);
    }

    public final String formatExact$extension(long $this) {
        return new StringBuilder(3).append(this.millis$extension($this)).append(" ms").toString();
    }

    public final String formatHuman$extension(long $this) {
        List factors = (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1000000), (Object)"millis"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1000), (Object)"seconds"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)60), (Object)"minutes"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)60), (Object)"hours"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)24), (Object)"days"), (List)Nil$.MODULE$)))));
        Tuple2 tuple2 = (Tuple2)factors.foldLeft((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)$this), (Object)"nanos"), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    double r = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                    String runit = (String)tuple22._2();
                    if (tuple23 != null) {
                        int fac = BoxesRunTime.unboxToInt((Object)tuple23._1());
                        String funit = (String)tuple23._2();
                        if (r < (double)fac) {
                            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)r), (Object)runit);
                        }
                        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(r / (double)fac)), (Object)funit);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double value = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        String unit = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)value), (Object)unit);
        double value2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
        String unit2 = (String)tuple22._2();
        return new StringBuilder(1).append(value2).append(" ").append(unit2).toString();
    }

    public final String toString$extension(long $this) {
        return this.formatHuman$extension($this);
    }
}

