/*
 * Decompiled with CFR 0.152.
 */
package sharry.common;

import cats.Functor;
import cats.data.NonEmptyList;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.implicits$;
import cats.syntax.EitherObjectOps$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.text;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.NotGiven$;
import sharry.common.LenientUri$;
import sharry.common.LenientUri$EmptyPath$;
import sharry.common.LenientUri$NonEmptyPath$;
import sharry.common.LenientUri$RootPath$;

public class LenientUri
implements Product,
Serializable {
    private final NonEmptyList<String> scheme;
    private final Option<String> authority;
    private final Path path;
    private final Option<String> query;
    private final Option<String> fragment;

    public static LenientUri apply(NonEmptyList<String> nonEmptyList, Option<String> option, Path path, Option<String> option2, Option<String> option3) {
        return LenientUri$.MODULE$.apply(nonEmptyList, option, path, option2, option3);
    }

    public static Decoder<LenientUri> decodeLenientUri() {
        return LenientUri$.MODULE$.decodeLenientUri();
    }

    public static Encoder<LenientUri> encodeLenientUri() {
        return LenientUri$.MODULE$.encodeLenientUri();
    }

    public static LenientUri fromJava(URL uRL) {
        return LenientUri$.MODULE$.fromJava(uRL);
    }

    public static LenientUri fromProduct(Product product) {
        return LenientUri$.MODULE$.fromProduct(product);
    }

    public static Either<String, LenientUri> parse(String string) {
        return LenientUri$.MODULE$.parse(string);
    }

    public static Option<String> percentDecode(String string) {
        return LenientUri$.MODULE$.percentDecode(string);
    }

    public static String percentEncode(String string) {
        return LenientUri$.MODULE$.percentEncode(string);
    }

    public static LenientUri unapply(LenientUri lenientUri) {
        return LenientUri$.MODULE$.unapply(lenientUri);
    }

    public static LenientUri unsafe(String string) {
        return LenientUri$.MODULE$.unsafe(string);
    }

    public LenientUri(NonEmptyList<String> scheme, Option<String> authority, Path path, Option<String> query, Option<String> fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LenientUri)) return false;
        LenientUri lenientUri = (LenientUri)object;
        NonEmptyList<String> nonEmptyList = this.scheme();
        NonEmptyList<String> nonEmptyList2 = lenientUri.scheme();
        if (nonEmptyList == null) {
            if (nonEmptyList2 != null) {
                return false;
            }
        } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
        Option<String> option = this.authority();
        Option<String> option2 = lenientUri.authority();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Path path = this.path();
        Path path2 = lenientUri.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        Option<String> option3 = this.query();
        Option<String> option4 = lenientUri.query();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.fragment();
        Option<String> option6 = lenientUri.fragment();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!lenientUri.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof LenientUri;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "LenientUri";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "scheme";
            }
            case 1: {
                return "authority";
            }
            case 2: {
                return "path";
            }
            case 3: {
                return "query";
            }
            case 4: {
                return "fragment";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public NonEmptyList<String> scheme() {
        return this.scheme;
    }

    public Option<String> authority() {
        return this.authority;
    }

    public Path path() {
        return this.path;
    }

    public Option<String> query() {
        return this.query;
    }

    public Option<String> fragment() {
        return this.fragment;
    }

    public LenientUri $div(String segment) {
        Path path = this.path().$div(segment);
        NonEmptyList<String> nonEmptyList = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        Option<String> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        return this.copy(nonEmptyList, option, path, option2, option3);
    }

    public LenientUri $plus$plus(Path np) {
        Path path = (Path)np.segments().foldLeft((Object)this.path(), (Function2 & Serializable)(_$1, _$2) -> _$1.$div((String)_$2));
        NonEmptyList<String> nonEmptyList = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        Option<String> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        return this.copy(nonEmptyList, option, path, option2, option3);
    }

    public LenientUri $plus$plus(String np) {
        String rel = LenientUri$.MODULE$.sharry$common$LenientUri$$$stripLeading(np, '/');
        return this.$plus$plus(LenientUri$.MODULE$.unsafe(new StringBuilder(2).append("a:").append(rel).toString()).path());
    }

    public LenientUri withQuery(String name, String value) {
        return this.withQueryPlain(name, URLEncoder.encode(value, "UTF-8"));
    }

    public LenientUri withQueryPlain(String name, String value) {
        Option option = this.query().map((Function1 & Serializable)q -> new StringBuilder(2).append((String)q).append("&").append(name).append("=").append(value).toString()).orElse(() -> LenientUri.$anonfun$3(name, value));
        NonEmptyList<String> nonEmptyList = this.copy$default$1();
        Option<String> option2 = this.copy$default$2();
        Path path = this.copy$default$3();
        Option<String> option3 = this.copy$default$5();
        return this.copy(nonEmptyList, option2, path, (Option<String>)option, option3);
    }

    public LenientUri withFragment(String f) {
        Some some = Some$.MODULE$.apply((Object)f);
        NonEmptyList<String> nonEmptyList = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        Path path = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        return this.copy(nonEmptyList, option, path, option2, (Option<String>)some);
    }

    public LenientUri rootPathToEmpty() {
        Path path = this.path();
        if (LenientUri$RootPath$.MODULE$.equals(path)) {
            LenientUri$EmptyPath$ lenientUri$EmptyPath$ = LenientUri$EmptyPath$.MODULE$;
            NonEmptyList<String> nonEmptyList = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<String> option2 = this.copy$default$4();
            Option<String> option3 = this.copy$default$5();
            return this.copy(nonEmptyList, option, lenientUri$EmptyPath$, option2, option3);
        }
        return this;
    }

    public Either<String, URL> toJavaUrl() {
        return EitherObjectOps$.MODULE$.catchNonFatal$extension(implicits$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), this::toJavaUrl$$anonfun$1).left().map((Function1 & Serializable)_$3 -> _$3.getMessage());
    }

    public <F> Either<String, Resource<F, HttpURLConnection>> open(Sync<F> evidence$1) {
        return this.toJavaUrl().map((Function1 & Serializable)url -> cats.effect.package$.MODULE$.Resource().make(cats.effect.package$.MODULE$.Sync().apply(evidence$1).delay(() -> LenientUri.open$$anonfun$1$$anonfun$1(url)), (Function1 & Serializable)conn -> cats.effect.package$.MODULE$.Sync().apply(evidence$1).delay((Function0 & Serializable)() -> {
            LenientUri.open$$anonfun$1$$anonfun$2$$anonfun$1(conn);
            return BoxedUnit.UNIT;
        }), (Functor)evidence$1));
    }

    public <F> Stream<F, Object> readURL(int chunkSize, Sync<F> evidence$1) {
        Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.emit((Object)EitherObjectOps$.MODULE$.catchNonFatal$extension(implicits$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), this::readURL$$anonfun$1)));
        return Stream.PureOps$.MODULE$.covary$extension(stream).rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), RaiseThrowable$.MODULE$.fromApplicativeError(evidence$1)).flatMap((Function1 & Serializable)url -> fs2.io.package$.MODULE$.readInputStream(cats.effect.package$.MODULE$.Sync().apply(evidence$1).delay(() -> LenientUri.readURL$$anonfun$2$$anonfun$1(url)), chunkSize, true, evidence$1), NotGiven$.MODULE$.value());
    }

    public <F> Object readText(int chunkSize, Sync<F> evidence$1) {
        return this.readURL(chunkSize, evidence$1).through(text.utf8$.MODULE$.decode()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(evidence$1))).foldMonoid(implicits$.MODULE$.catsKernelStdMonoidForString());
    }

    public Option<String> host() {
        return this.authority().map((Function1 & Serializable)a -> {
            int n = a.indexOf(58);
            if (-1 == n) {
                return a;
            }
            int n2 = n;
            return a.substring(0, n2);
        });
    }

    public boolean isLocal() {
        return this.host().exists((Function1 & Serializable)_$7 -> _$7.equalsIgnoreCase("localhost"));
    }

    public String asString() {
        String schemePart = this.scheme().toList().mkString(":");
        String authPart = (String)this.authority().map((Function1 & Serializable)a -> new StringBuilder(2).append("//").append((String)a).toString()).getOrElse(LenientUri::$anonfun$5);
        String pathPart = this.path().asString();
        String queryPart = (String)this.query().map((Function1 & Serializable)q -> new StringBuilder(1).append("?").append((String)q).toString()).getOrElse(LenientUri::$anonfun$7);
        String fragPart = (String)this.fragment().map((Function1 & Serializable)f -> new StringBuilder(1).append("#").append((String)f).toString()).getOrElse(LenientUri::$anonfun$9);
        return new StringBuilder(1).append(schemePart).append(":").append(authPart).append(pathPart).append(queryPart).append(fragPart).toString();
    }

    public String toString() {
        return this.asString();
    }

    public LenientUri copy(NonEmptyList<String> scheme, Option<String> authority, Path path, Option<String> query, Option<String> fragment) {
        return new LenientUri(scheme, authority, path, query, fragment);
    }

    public NonEmptyList<String> copy$default$1() {
        return this.scheme();
    }

    public Option<String> copy$default$2() {
        return this.authority();
    }

    public Path copy$default$3() {
        return this.path();
    }

    public Option<String> copy$default$4() {
        return this.query();
    }

    public Option<String> copy$default$5() {
        return this.fragment();
    }

    public NonEmptyList<String> _1() {
        return this.scheme();
    }

    public Option<String> _2() {
        return this.authority();
    }

    public Path _3() {
        return this.path();
    }

    public Option<String> _4() {
        return this.query();
    }

    public Option<String> _5() {
        return this.fragment();
    }

    private static final Option $anonfun$3(String name$2, String value$2) {
        return Option$.MODULE$.apply((Object)new StringBuilder(1).append(name$2).append("=").append(value$2).toString());
    }

    private final URL toJavaUrl$$anonfun$1() {
        return new URL(this.asString());
    }

    private static final HttpURLConnection open$$anonfun$1$$anonfun$1(URL url$1) {
        return (HttpURLConnection)url$1.openConnection();
    }

    private static final void open$$anonfun$1$$anonfun$2$$anonfun$1(HttpURLConnection conn$1) {
        conn$1.disconnect();
    }

    private final URL readURL$$anonfun$1() {
        return new URL(this.asString());
    }

    private static final InputStream readURL$$anonfun$2$$anonfun$1(URL url$2) {
        return url$2.openStream();
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final String $anonfun$9() {
        return "";
    }

    public static class NonEmptyPath
    implements Path,
    Product,
    Serializable {
        private final NonEmptyList<String> segs;
        private final boolean trailingSlash;
        private final boolean isEmpty;
        private final boolean isRoot;
        private final String slashSuffix;

        public static NonEmptyPath apply(NonEmptyList<String> nonEmptyList, boolean bl) {
            return LenientUri$NonEmptyPath$.MODULE$.apply(nonEmptyList, bl);
        }

        public static NonEmptyPath fromProduct(Product product) {
            return LenientUri$NonEmptyPath$.MODULE$.fromProduct(product);
        }

        public static NonEmptyPath unapply(NonEmptyPath nonEmptyPath) {
            return LenientUri$NonEmptyPath$.MODULE$.unapply(nonEmptyPath);
        }

        public NonEmptyPath(NonEmptyList<String> segs, boolean trailingSlash) {
            this.segs = segs;
            this.trailingSlash = trailingSlash;
            this.isEmpty = false;
            this.isRoot = false;
            this.slashSuffix = trailingSlash ? "/" : "";
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.segs()));
            n = Statics.mix((int)n, (int)(this.trailingSlash() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NonEmptyPath)) return false;
            NonEmptyPath nonEmptyPath = (NonEmptyPath)object;
            if (this.trailingSlash() != nonEmptyPath.trailingSlash()) return false;
            NonEmptyList<String> nonEmptyList = this.segs();
            NonEmptyList<String> nonEmptyList2 = nonEmptyPath.segs();
            if (nonEmptyList == null) {
                if (nonEmptyList2 != null) {
                    return false;
                }
            } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
            if (!nonEmptyPath.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NonEmptyPath;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "NonEmptyPath";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "segs";
            }
            if (1 == n2) {
                return "trailingSlash";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public NonEmptyList<String> segs() {
            return this.segs;
        }

        public boolean trailingSlash() {
            return this.trailingSlash;
        }

        @Override
        public List<String> segments() {
            return this.segs().toList();
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }

        @Override
        public boolean isRoot() {
            return this.isRoot;
        }

        @Override
        public Path $div(String seg) {
            return this.copy((NonEmptyList<String>)this.segs().append((Object)seg), this.copy$default$2());
        }

        @Override
        public String asString() {
            String string = (String)this.segs().head();
            if (".".equals(string)) {
                return new StringBuilder(0).append(this.segments().map(LenientUri$::sharry$common$LenientUri$NonEmptyPath$$_$asString$$anonfun$1).mkString("/")).append(this.slashSuffix).toString();
            }
            if ("..".equals(string)) {
                return new StringBuilder(0).append(this.segments().map(LenientUri$::sharry$common$LenientUri$NonEmptyPath$$_$asString$$anonfun$2).mkString("/")).append(this.slashSuffix).toString();
            }
            return new StringBuilder(1).append("/").append(this.segments().map(LenientUri$::sharry$common$LenientUri$NonEmptyPath$$_$asString$$anonfun$3).mkString("/")).append(this.slashSuffix).toString();
        }

        public NonEmptyPath copy(NonEmptyList<String> segs, boolean trailingSlash) {
            return new NonEmptyPath(segs, trailingSlash);
        }

        public NonEmptyList<String> copy$default$1() {
            return this.segs();
        }

        public boolean copy$default$2() {
            return this.trailingSlash();
        }

        public NonEmptyList<String> _1() {
            return this.segs();
        }

        public boolean _2() {
            return this.trailingSlash();
        }
    }

    public static interface Path {
        public List<String> segments();

        public boolean isRoot();

        public boolean isEmpty();

        public Path $div(String var1);

        public String asString();
    }
}

