/*
 * Decompiled with CFR 0.152.
 */
package sharry.restserver.config;

import cats.Functor;
import cats.Reducible;
import cats.Semigroupal;
import cats.data.NonEmptyChainImpl$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.Port;
import java.io.Serializable;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Product;
import scala.Tuple4$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import sharry.common.ByteSize;
import sharry.common.Duration;
import sharry.common.Duration$;
import sharry.common.LenientUri;
import sharry.logging.LogConfig;
import sharry.restserver.config.Config$;
import sharry.restserver.config.Config$Bind$;
import sharry.restserver.config.Config$FileDownload$;
import sharry.restserver.config.Config$Webapp$;

public class Config
implements Product,
Serializable {
    private final LenientUri baseUrl;
    private final boolean aliasMemberEnabled;
    private final Bind bind;
    private final FileDownload fileDownload;
    private final LogConfig logging;
    private final Webapp webapp;
    private final sharry.backend.config.Config backend;

    public static Config apply(LenientUri lenientUri, boolean bl, Bind bind, FileDownload fileDownload, LogConfig logConfig, Webapp webapp, sharry.backend.config.Config config) {
        return Config$.MODULE$.apply(lenientUri, bl, bind, fileDownload, logConfig, webapp, config);
    }

    public static Config fromProduct(Product product) {
        return Config$.MODULE$.fromProduct(product);
    }

    public static Config unapply(Config config) {
        return Config$.MODULE$.unapply(config);
    }

    public Config(LenientUri baseUrl, boolean aliasMemberEnabled, Bind bind, FileDownload fileDownload, LogConfig logging, Webapp webapp, sharry.backend.config.Config backend) {
        this.baseUrl = baseUrl;
        this.aliasMemberEnabled = aliasMemberEnabled;
        this.bind = bind;
        this.fileDownload = fileDownload;
        this.logging = logging;
        this.webapp = webapp;
        this.backend = backend;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.baseUrl()));
        n = Statics.mix((int)n, (int)(this.aliasMemberEnabled() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.bind()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fileDownload()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.logging()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.webapp()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.backend()));
        return Statics.finalizeHash((int)n, (int)7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Config)) return false;
        Config config = (Config)object;
        if (this.aliasMemberEnabled() != config.aliasMemberEnabled()) return false;
        LenientUri lenientUri = this.baseUrl();
        LenientUri lenientUri2 = config.baseUrl();
        if (lenientUri == null) {
            if (lenientUri2 != null) {
                return false;
            }
        } else if (!lenientUri.equals(lenientUri2)) return false;
        Bind bind = this.bind();
        Bind bind2 = config.bind();
        if (bind == null) {
            if (bind2 != null) {
                return false;
            }
        } else if (!((Object)bind).equals(bind2)) return false;
        FileDownload fileDownload = this.fileDownload();
        FileDownload fileDownload2 = config.fileDownload();
        if (fileDownload == null) {
            if (fileDownload2 != null) {
                return false;
            }
        } else if (!((Object)fileDownload).equals(fileDownload2)) return false;
        LogConfig logConfig = this.logging();
        LogConfig logConfig2 = config.logging();
        if (logConfig == null) {
            if (logConfig2 != null) {
                return false;
            }
        } else if (!logConfig.equals(logConfig2)) return false;
        Webapp webapp = this.webapp();
        Webapp webapp2 = config.webapp();
        if (webapp == null) {
            if (webapp2 != null) {
                return false;
            }
        } else if (!((Object)webapp).equals(webapp2)) return false;
        sharry.backend.config.Config config2 = this.backend();
        sharry.backend.config.Config config3 = config.backend();
        if (config2 == null) {
            if (config3 != null) {
                return false;
            }
        } else if (!config2.equals(config3)) return false;
        if (!config.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Config;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "Config";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "baseUrl";
            }
            case 1: {
                return "aliasMemberEnabled";
            }
            case 2: {
                return "bind";
            }
            case 3: {
                return "fileDownload";
            }
            case 4: {
                return "logging";
            }
            case 5: {
                return "webapp";
            }
            case 6: {
                return "backend";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public LenientUri baseUrl() {
        return this.baseUrl;
    }

    public boolean aliasMemberEnabled() {
        return this.aliasMemberEnabled;
    }

    public Bind bind() {
        return this.bind;
    }

    public FileDownload fileDownload() {
        return this.fileDownload;
    }

    public LogConfig logging() {
        return this.logging;
    }

    public Webapp webapp() {
        return this.webapp;
    }

    public sharry.backend.config.Config backend() {
        return this.backend;
    }

    public Validated<Object, Config> validate() {
        Validated validated;
        long threshold = Duration$.MODULE$.seconds(30L);
        Validated validSession = Duration$.MODULE$.$greater$eq$extension(this.backend().auth().sessionValid(), Duration$.MODULE$.$plus$extension(this.webapp().authRenewal(), threshold)) ? Validated$.MODULE$.validNec((Object)BoxedUnit.UNIT) : Validated$.MODULE$.invalidNec((Object)new StringBuilder(30).append("session-valid time (").append(new Duration(this.backend().auth().sessionValid())).append(") must be ").append(new StringBuilder(48).append("at least 30s greater than webapp.auth-renewal (").append(new Duration(this.webapp().authRenewal())).append(")").toString()).toString());
        Validated validValidity = Duration$.MODULE$.$greater$eq$extension(this.backend().share().maxValidity(), this.webapp().defaultValidity()) ? Validated$.MODULE$.validNec((Object)BoxedUnit.UNIT) : Validated$.MODULE$.invalidNec((Object)new StringBuilder(44).append("Default validity (").append(new Duration(this.webapp().defaultValidity())).append(") is larger than maximum ").append(new Duration(this.backend().share().maxValidity())).append("!").toString());
        String string = Config$.MODULE$.sharry$restserver$config$Config$$$validateTheme(this.webapp().initialTheme());
        if ("".equals(string)) {
            validated = Validated$.MODULE$.validNec((Object)BoxedUnit.UNIT);
        } else {
            String str = string;
            validated = Validated$.MODULE$.invalidNec((Object)str);
        }
        Validated valdidTheme = validated;
        Validated validBackend = this.backend().validate().map((Function1 & Serializable)c -> this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), (sharry.backend.config.Config)c));
        return (Validated)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)validSession, (Object)validValidity, (Object)valdidTheme, (Object)validBackend)).mapN((Function4 & Serializable)(_$1, _$2, _$3, c) -> c, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
    }

    public Config validOrThrow() {
        Validated<Object, Config> validated = this.validate();
        if (validated instanceof Validated.Valid) {
            Config config;
            Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
            Config cfg = config = (Config)valid._1();
            return cfg;
        }
        if (validated instanceof Validated.Invalid) {
            Object object;
            Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
            Object errs = object = invalid._1();
            throw package$.MODULE$.error(new StringBuilder(28).append("Configuration is not valid: ").append(package.all$.MODULE$.toReducibleOps(errs, (Reducible)NonEmptyChainImpl$.MODULE$.catsDataInstancesForNonEmptyChainBinCompat1()).toNonEmptyList().toList().mkString(", ")).toString());
        }
        throw new MatchError(validated);
    }

    public Config copy(LenientUri baseUrl, boolean aliasMemberEnabled, Bind bind, FileDownload fileDownload, LogConfig logging, Webapp webapp, sharry.backend.config.Config backend) {
        return new Config(baseUrl, aliasMemberEnabled, bind, fileDownload, logging, webapp, backend);
    }

    public LenientUri copy$default$1() {
        return this.baseUrl();
    }

    public boolean copy$default$2() {
        return this.aliasMemberEnabled();
    }

    public Bind copy$default$3() {
        return this.bind();
    }

    public FileDownload copy$default$4() {
        return this.fileDownload();
    }

    public LogConfig copy$default$5() {
        return this.logging();
    }

    public Webapp copy$default$6() {
        return this.webapp();
    }

    public sharry.backend.config.Config copy$default$7() {
        return this.backend();
    }

    public LenientUri _1() {
        return this.baseUrl();
    }

    public boolean _2() {
        return this.aliasMemberEnabled();
    }

    public Bind _3() {
        return this.bind();
    }

    public FileDownload _4() {
        return this.fileDownload();
    }

    public LogConfig _5() {
        return this.logging();
    }

    public Webapp _6() {
        return this.webapp();
    }

    public sharry.backend.config.Config _7() {
        return this.backend();
    }

    public static class Bind
    implements Product,
    Serializable {
        private final Host address;
        private final Port port;

        public static Bind apply(Host host, Port port) {
            return Config$Bind$.MODULE$.apply(host, port);
        }

        public static Bind fromProduct(Product product) {
            return Config$Bind$.MODULE$.fromProduct(product);
        }

        public static Bind unapply(Bind bind) {
            return Config$Bind$.MODULE$.unapply(bind);
        }

        public Bind(Host address, Port port) {
            this.address = address;
            this.port = port;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Bind)) return false;
            Bind bind = (Bind)object;
            Host host = this.address();
            Host host2 = bind.address();
            if (host == null) {
                if (host2 != null) {
                    return false;
                }
            } else if (!host.equals(host2)) return false;
            Port port = this.port();
            Port port2 = bind.port();
            if (port == null) {
                if (port2 != null) {
                    return false;
                }
            } else if (!port.equals(port2)) return false;
            if (!bind.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Bind;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Bind";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            if (1 == n2) {
                return "port";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Host address() {
            return this.address;
        }

        public Port port() {
            return this.port;
        }

        public Bind copy(Host address, Port port) {
            return new Bind(address, port);
        }

        public Host copy$default$1() {
            return this.address();
        }

        public Port copy$default$2() {
            return this.port();
        }

        public Host _1() {
            return this.address();
        }

        public Port _2() {
            return this.port();
        }
    }

    public static class FileDownload
    implements Product,
    Serializable {
        private final ByteSize downloadChunkSize;

        public static FileDownload apply(ByteSize byteSize) {
            return Config$FileDownload$.MODULE$.apply(byteSize);
        }

        public static FileDownload fromProduct(Product product) {
            return Config$FileDownload$.MODULE$.fromProduct(product);
        }

        public static FileDownload unapply(FileDownload fileDownload) {
            return Config$FileDownload$.MODULE$.unapply(fileDownload);
        }

        public FileDownload(ByteSize downloadChunkSize) {
            this.downloadChunkSize = downloadChunkSize;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FileDownload)) return false;
            FileDownload fileDownload = (FileDownload)object;
            ByteSize byteSize = this.downloadChunkSize();
            ByteSize byteSize2 = fileDownload.downloadChunkSize();
            if (byteSize == null) {
                if (byteSize2 != null) {
                    return false;
                }
            } else if (!byteSize.equals(byteSize2)) return false;
            if (!fileDownload.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FileDownload;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FileDownload";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "downloadChunkSize";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteSize downloadChunkSize() {
            return this.downloadChunkSize;
        }

        public FileDownload copy(ByteSize downloadChunkSize) {
            return new FileDownload(downloadChunkSize);
        }

        public ByteSize copy$default$1() {
            return this.downloadChunkSize();
        }

        public ByteSize _1() {
            return this.downloadChunkSize();
        }
    }

    public static class Webapp
    implements Product,
    Serializable {
        private final String appName;
        private final String appIcon;
        private final String appIconDark;
        private final String appLogo;
        private final String appLogoDark;
        private final String appFooter;
        private final boolean appFooterVisible;
        private final ByteSize chunkSize;
        private final Seq<Duration> retryDelays;
        private final String welcomeMessage;
        private final String defaultLanguage;
        private final long authRenewal;
        private final String initialPage;
        private final long defaultValidity;
        private final String initialTheme;
        private final boolean oauthAutoRedirect;
        private final String customHead;

        public static Webapp apply(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, ByteSize byteSize, Seq<Duration> seq, String string7, String string8, long l, String string9, long l2, String string10, boolean bl2, String string11) {
            return Config$Webapp$.MODULE$.apply(string, string2, string3, string4, string5, string6, bl, byteSize, seq, string7, string8, l, string9, l2, string10, bl2, string11);
        }

        public static Webapp fromProduct(Product product) {
            return Config$Webapp$.MODULE$.fromProduct(product);
        }

        public static Webapp unapply(Webapp webapp) {
            return Config$Webapp$.MODULE$.unapply(webapp);
        }

        public Webapp(String appName, String appIcon, String appIconDark, String appLogo, String appLogoDark, String appFooter, boolean appFooterVisible, ByteSize chunkSize, Seq<Duration> retryDelays, String welcomeMessage, String defaultLanguage, long authRenewal, String initialPage, long defaultValidity, String initialTheme, boolean oauthAutoRedirect, String customHead) {
            this.appName = appName;
            this.appIcon = appIcon;
            this.appIconDark = appIconDark;
            this.appLogo = appLogo;
            this.appLogoDark = appLogoDark;
            this.appFooter = appFooter;
            this.appFooterVisible = appFooterVisible;
            this.chunkSize = chunkSize;
            this.retryDelays = retryDelays;
            this.welcomeMessage = welcomeMessage;
            this.defaultLanguage = defaultLanguage;
            this.authRenewal = authRenewal;
            this.initialPage = initialPage;
            this.defaultValidity = defaultValidity;
            this.initialTheme = initialTheme;
            this.oauthAutoRedirect = oauthAutoRedirect;
            this.customHead = customHead;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.appName()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.appIcon()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.appIconDark()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.appLogo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.appLogoDark()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.appFooter()));
            n = Statics.mix((int)n, (int)(this.appFooterVisible() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.chunkSize()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.retryDelays()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.welcomeMessage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultLanguage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Duration(this.authRenewal())));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.initialPage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Duration(this.defaultValidity())));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.initialTheme()));
            n = Statics.mix((int)n, (int)(this.oauthAutoRedirect() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.customHead()));
            return Statics.finalizeHash((int)n, (int)17);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Webapp)) return false;
            Webapp webapp = (Webapp)object;
            if (this.appFooterVisible() != webapp.appFooterVisible()) return false;
            if (this.oauthAutoRedirect() != webapp.oauthAutoRedirect()) return false;
            String string = this.appName();
            String string2 = webapp.appName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.appIcon();
            String string4 = webapp.appIcon();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.appIconDark();
            String string6 = webapp.appIconDark();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.appLogo();
            String string8 = webapp.appLogo();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.appLogoDark();
            String string10 = webapp.appLogoDark();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.appFooter();
            String string12 = webapp.appFooter();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            ByteSize byteSize = this.chunkSize();
            ByteSize byteSize2 = webapp.chunkSize();
            if (byteSize == null) {
                if (byteSize2 != null) {
                    return false;
                }
            } else if (!byteSize.equals(byteSize2)) return false;
            Seq<Duration> seq = this.retryDelays();
            Seq<Duration> seq2 = webapp.retryDelays();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            String string13 = this.welcomeMessage();
            String string14 = webapp.welcomeMessage();
            if (string13 == null) {
                if (string14 != null) {
                    return false;
                }
            } else if (!string13.equals(string14)) return false;
            String string15 = this.defaultLanguage();
            String string16 = webapp.defaultLanguage();
            if (string15 == null) {
                if (string16 != null) {
                    return false;
                }
            } else if (!string15.equals(string16)) return false;
            if (this.authRenewal() != webapp.authRenewal()) return false;
            String string17 = this.initialPage();
            String string18 = webapp.initialPage();
            if (string17 == null) {
                if (string18 != null) {
                    return false;
                }
            } else if (!string17.equals(string18)) return false;
            if (this.defaultValidity() != webapp.defaultValidity()) return false;
            String string19 = this.initialTheme();
            String string20 = webapp.initialTheme();
            if (string19 == null) {
                if (string20 != null) {
                    return false;
                }
            } else if (!string19.equals(string20)) return false;
            String string21 = this.customHead();
            String string22 = webapp.customHead();
            if (string21 == null) {
                if (string22 != null) {
                    return false;
                }
            } else if (!string21.equals(string22)) return false;
            if (!webapp.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Webapp;
        }

        public int productArity() {
            return 17;
        }

        public String productPrefix() {
            return "Webapp";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this._7());
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return this._11();
                }
                case 11: {
                    return new Duration(this._12());
                }
                case 12: {
                    return this._13();
                }
                case 13: {
                    return new Duration(this._14());
                }
                case 14: {
                    return this._15();
                }
                case 15: {
                    return BoxesRunTime.boxToBoolean((boolean)this._16());
                }
                case 16: {
                    return this._17();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "appName";
                }
                case 1: {
                    return "appIcon";
                }
                case 2: {
                    return "appIconDark";
                }
                case 3: {
                    return "appLogo";
                }
                case 4: {
                    return "appLogoDark";
                }
                case 5: {
                    return "appFooter";
                }
                case 6: {
                    return "appFooterVisible";
                }
                case 7: {
                    return "chunkSize";
                }
                case 8: {
                    return "retryDelays";
                }
                case 9: {
                    return "welcomeMessage";
                }
                case 10: {
                    return "defaultLanguage";
                }
                case 11: {
                    return "authRenewal";
                }
                case 12: {
                    return "initialPage";
                }
                case 13: {
                    return "defaultValidity";
                }
                case 14: {
                    return "initialTheme";
                }
                case 15: {
                    return "oauthAutoRedirect";
                }
                case 16: {
                    return "customHead";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String appName() {
            return this.appName;
        }

        public String appIcon() {
            return this.appIcon;
        }

        public String appIconDark() {
            return this.appIconDark;
        }

        public String appLogo() {
            return this.appLogo;
        }

        public String appLogoDark() {
            return this.appLogoDark;
        }

        public String appFooter() {
            return this.appFooter;
        }

        public boolean appFooterVisible() {
            return this.appFooterVisible;
        }

        public ByteSize chunkSize() {
            return this.chunkSize;
        }

        public Seq<Duration> retryDelays() {
            return this.retryDelays;
        }

        public String welcomeMessage() {
            return this.welcomeMessage;
        }

        public String defaultLanguage() {
            return this.defaultLanguage;
        }

        public long authRenewal() {
            return this.authRenewal;
        }

        public String initialPage() {
            return this.initialPage;
        }

        public long defaultValidity() {
            return this.defaultValidity;
        }

        public String initialTheme() {
            return this.initialTheme;
        }

        public boolean oauthAutoRedirect() {
            return this.oauthAutoRedirect;
        }

        public String customHead() {
            return this.customHead;
        }

        public Webapp copy(String appName, String appIcon, String appIconDark, String appLogo, String appLogoDark, String appFooter, boolean appFooterVisible, ByteSize chunkSize, Seq<Duration> retryDelays, String welcomeMessage, String defaultLanguage, long authRenewal, String initialPage, long defaultValidity, String initialTheme, boolean oauthAutoRedirect, String customHead) {
            return new Webapp(appName, appIcon, appIconDark, appLogo, appLogoDark, appFooter, appFooterVisible, chunkSize, retryDelays, welcomeMessage, defaultLanguage, authRenewal, initialPage, defaultValidity, initialTheme, oauthAutoRedirect, customHead);
        }

        public String copy$default$1() {
            return this.appName();
        }

        public String copy$default$2() {
            return this.appIcon();
        }

        public String copy$default$3() {
            return this.appIconDark();
        }

        public String copy$default$4() {
            return this.appLogo();
        }

        public String copy$default$5() {
            return this.appLogoDark();
        }

        public String copy$default$6() {
            return this.appFooter();
        }

        public boolean copy$default$7() {
            return this.appFooterVisible();
        }

        public ByteSize copy$default$8() {
            return this.chunkSize();
        }

        public Seq<Duration> copy$default$9() {
            return this.retryDelays();
        }

        public String copy$default$10() {
            return this.welcomeMessage();
        }

        public String copy$default$11() {
            return this.defaultLanguage();
        }

        public long copy$default$12() {
            return this.authRenewal();
        }

        public String copy$default$13() {
            return this.initialPage();
        }

        public long copy$default$14() {
            return this.defaultValidity();
        }

        public String copy$default$15() {
            return this.initialTheme();
        }

        public boolean copy$default$16() {
            return this.oauthAutoRedirect();
        }

        public String copy$default$17() {
            return this.customHead();
        }

        public String _1() {
            return this.appName();
        }

        public String _2() {
            return this.appIcon();
        }

        public String _3() {
            return this.appIconDark();
        }

        public String _4() {
            return this.appLogo();
        }

        public String _5() {
            return this.appLogoDark();
        }

        public String _6() {
            return this.appFooter();
        }

        public boolean _7() {
            return this.appFooterVisible();
        }

        public ByteSize _8() {
            return this.chunkSize();
        }

        public Seq<Duration> _9() {
            return this.retryDelays();
        }

        public String _10() {
            return this.welcomeMessage();
        }

        public String _11() {
            return this.defaultLanguage();
        }

        public long _12() {
            return this.authRenewal();
        }

        public String _13() {
            return this.initialPage();
        }

        public long _14() {
            return this.defaultValidity();
        }

        public String _15() {
            return this.initialTheme();
        }

        public boolean _16() {
            return this.oauthAutoRedirect();
        }

        public String _17() {
            return this.customHead();
        }
    }
}

