/*
 * Decompiled with CFR 0.152.
 */
package sharry.restserver.http4s;

import cats.data.NonEmptyList$;
import cats.implicits$;
import cats.syntax.EitherObjectOps$;
import com.comcast.ip4s.Port;
import java.io.Serializable;
import java.net.InetAddress;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.headers.Host$;
import org.http4s.headers.X$minusForwarded$minusFor$;
import org.typelevel.ci.CIString$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import sharry.common.LenientUri;
import sharry.common.LenientUri$;
import sharry.restserver.config.Config;

public final class ClientRequestInfo$
implements Serializable {
    public static final ClientRequestInfo$ MODULE$ = new ClientRequestInfo$();

    private ClientRequestInfo$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClientRequestInfo$.class);
    }

    public <F> LenientUri getBaseUrl(Config cfg, Request<F> req) {
        if (cfg.baseUrl().isLocal()) {
            return (LenientUri)this.getBaseUrl(req, cfg.bind().port()).getOrElse(() -> ClientRequestInfo$.getBaseUrl$$anonfun$1(cfg));
        }
        return cfg.baseUrl();
    }

    private <F> Option<LenientUri> getBaseUrl(Request<F> req, Port serverPort) {
        return NonEmptyList$.MODULE$.fromList(this.getProtocol(req).toList()).flatMap((Function1 & Serializable)scheme -> MODULE$.getHostname(req).map((Function1 & Serializable)host -> {
            int port = BoxesRunTime.unboxToInt((Object)MODULE$.xForwardedPort(req).getOrElse(() -> ClientRequestInfo$.$anonfun$1(serverPort)));
            String hostPort = port == 80 || port == 443 ? host : new StringBuilder(1).append((String)host).append(":").append(port).toString();
            return Tuple3$.MODULE$.apply(host, (Object)BoxesRunTime.boxToInteger((int)port), (Object)hostPort);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String host = (String)tuple3._1();
                int port = BoxesRunTime.unboxToInt((Object)tuple3._2());
                String hostPort = (String)tuple3._3();
                return LenientUri$.MODULE$.apply(scheme, (Option)Some$.MODULE$.apply((Object)hostPort), (LenientUri.Path)LenientUri.EmptyPath$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            }
            throw new MatchError((Object)tuple3);
        }));
    }

    public <F> Option<String> getHostname(Request<F> req) {
        return this.xForwardedHost(req).orElse(() -> ClientRequestInfo$.getHostname$$anonfun$1(req)).orElse(() -> ClientRequestInfo$.getHostname$$anonfun$2(req));
    }

    public <F> Option<String> getProtocol(Request<F> req) {
        return this.xForwardedProto(req).orElse(() -> ClientRequestInfo$.getProtocol$$anonfun$1(req));
    }

    private <F> Option<String> host(Request<F> req) {
        return Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Host$.MODULE$.headerInstance())).map((Function1 & Serializable)_$6 -> _$6.host());
    }

    private <F> Option<String> xForwardedFor(Request<F> req) {
        return Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(X$minusForwarded$minusFor$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)_$8 -> (Option)_$8.values().head()).map((Function1 & Serializable)_$9 -> _$9.toInetAddress()).flatMap((Function1 & Serializable)inet -> Option$.MODULE$.apply((Object)inet.getHostName()).orElse(() -> ClientRequestInfo$.xForwardedFor$$anonfun$3$$anonfun$1(inet)));
    }

    private <F> Option<String> xForwardedHost(Request<F> req) {
        return Headers$.MODULE$.get$extension(req.headers(), CIString$.MODULE$.apply("X-Forwarded-Host")).map((Function1 & Serializable)_$11 -> ((Header.Raw)_$11.head()).value());
    }

    private <F> Option<String> xForwardedProto(Request<F> req) {
        return Headers$.MODULE$.get$extension(req.headers(), CIString$.MODULE$.apply("X-Forwarded-Proto")).map((Function1 & Serializable)_$13 -> ((Header.Raw)_$13.head()).value());
    }

    private <F> Option<String> clientConnectionProto(Request<F> req) {
        return req.isSecure().map((Function1 & Serializable)x$1 -> ClientRequestInfo$.clientConnectionProto$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)x$1)));
    }

    private <F> Option<Object> xForwardedPort(Request<F> req) {
        return Headers$.MODULE$.get$extension(req.headers(), CIString$.MODULE$.apply("X-Forwarded-Port")).map((Function1 & Serializable)_$16 -> ((Header.Raw)_$16.head()).value()).flatMap((Function1 & Serializable)str -> EitherObjectOps$.MODULE$.catchNonFatal$extension(implicits$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), () -> ClientRequestInfo$.xForwardedPort$$anonfun$2$$anonfun$1(str)).toOption());
    }

    private static final LenientUri getBaseUrl$$anonfun$1(Config cfg$1) {
        return cfg$1.baseUrl();
    }

    private static final int $anonfun$1(Port serverPort$3) {
        return serverPort$3.value();
    }

    private static final Option getHostname$$anonfun$1(Request req$3) {
        return MODULE$.xForwardedFor(req$3);
    }

    private static final Option getHostname$$anonfun$2(Request req$4) {
        return MODULE$.host(req$4);
    }

    private static final Option getProtocol$$anonfun$1(Request req$5) {
        return MODULE$.clientConnectionProto(req$5);
    }

    private static final Option xForwardedFor$$anonfun$3$$anonfun$1(InetAddress inet$1) {
        return Option$.MODULE$.apply((Object)inet$1.getHostAddress());
    }

    private static final /* synthetic */ String clientConnectionProto$$anonfun$1(boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return "https";
        }
        if (!bl) {
            return "http";
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final int xForwardedPort$$anonfun$2$$anonfun$1(String str$1) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str$1));
    }
}

