/*
 * Decompiled with CFR 0.152.
 */
package sharry.restserver.oauth;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import io.circe.Decoder$;
import io.circe.Json;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.MediaRange;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.circe.CirceEntityCodec$;
import org.http4s.client.Client;
import org.http4s.client.dsl.Http4sClientDsl;
import org.http4s.client.dsl.MethodOps$;
import org.http4s.client.middleware.RequestLogger$;
import org.http4s.client.middleware.ResponseLogger$;
import org.http4s.headers.Accept$;
import org.http4s.headers.Authorization$;
import org.http4s.headers.MediaRangeAndQValue;
import org.http4s.headers.MediaRangeAndQValue$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import sharry.backend.auth.AuthConfig;
import sharry.common.Ident;
import sharry.common.Ident$;
import sharry.logging.Logger;
import sharry.logging.package$;
import sharry.restserver.oauth.CodeFlow;
import sharry.restserver.oauth.CodeFlow$UserInfo$;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Pkg$;

public final class CodeFlow$
implements Serializable {
    public static final CodeFlow$UserInfo$ UserInfo;
    public static final CodeFlow$ MODULE$;

    private CodeFlow$() {
    }

    static {
        MODULE$ = new CodeFlow$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CodeFlow$.class);
    }

    public <F> OptionT<F, CodeFlow.UserInfo> apply(Client<F> client, AuthConfig.OAuth cfg, String redirectUri, String code, Async<F> evidence$1) {
        Logger logger = package$.MODULE$.getLogger(evidence$1, Enclosing$.MODULE$.apply("sharry.restserver.oauth.CodeFlow.apply logger"));
        Http4sClientDsl dsl = new Http4sClientDsl<F>(){};
        Client<F> c = this.logRequestResponses(client, logger, evidence$1);
        return OptionT$.MODULE$.liftF(logger.debug(() -> CodeFlow$.apply$$anonfun$1(cfg, code), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("apply"), Line$.MODULE$.apply(36)), evidence$1).flatMap(arg_0 -> CodeFlow$.apply$$anonfun$2(c, (Http4sClientDsl)dsl, cfg, redirectUri, code, evidence$1, logger, arg_0), evidence$1);
    }

    private <F> OptionT<F, String> codeToToken(Client<F> c, Http4sClientDsl<F> dsl, AuthConfig.OAuth cfg, String redirectUri, String code, Async<F> evidence$1) {
        Logger logger = package$.MODULE$.getLogger(evidence$1, Enclosing$.MODULE$.apply("sharry.restserver.oauth.CodeFlow.codeToToken logger"));
        Method method = dsl.http4sClientSyntaxMethod(Method$.MODULE$.POST());
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)cfg.clientId());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_secret");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)cfg.clientSecret());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)code);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"grant_type");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"authorization_code");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"redirect_uri");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)redirectUri);
        Request req = MethodOps$.MODULE$.apply$extension(method, (Object)new UrlForm(UrlForm$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), Uri$.MODULE$.unsafeFromString(cfg.tokenUrl().asString()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), UrlForm$.MODULE$.entityEncoder(UrlForm$.MODULE$.entityEncoder$default$1()));
        return OptionT$.MODULE$.apply(c.run(req).use((Function1 & Serializable)x$1 -> {
            Option option;
            Response response = x$1;
            if (response != null && !(option = Status.Successful$.MODULE$.unapply(response)).isEmpty()) {
                Response response2;
                Response r = response2 = (Response)option.get();
                Object u1 = implicits$.MODULE$.toFunctorOps(r.as((MonadError)evidence$1, UrlForm$.MODULE$.entityDecoder((GenConcurrent)evidence$1, UrlForm$.MODULE$.entityDecoder$default$2())), (Functor)evidence$1).map((Function1 & Serializable)_$3 -> UrlForm$.MODULE$.getFirst$extension(_$3 == null ? null : ((UrlForm)_$3).values(), "access_token"));
                Object u2 = implicits$.MODULE$.toFunctorOps(r.as((MonadError)evidence$1, CirceEntityCodec$.MODULE$.circeEntityDecoder((GenConcurrent)evidence$1, Decoder$.MODULE$.decodeJson())), (Functor)evidence$1).map((Function1 & Serializable)_$4 -> _$4.asObject().flatMap((Function1 & Serializable)_$5 -> _$5.apply("access_token")).flatMap((Function1 & Serializable)_$6 -> _$6.asString()));
                Object object = implicits$.MODULE$.catsSyntaxApplicativeError(u1, (ApplicativeError)evidence$1);
                return implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)new Serializable(u2){
                    private final Object u2$1;
                    {
                        this.u2$1 = u2$2;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        return this.u2$1;
                    }
                }, (ApplicativeError)evidence$1), (FlatMap)evidence$1).flatTap((Function1 & Serializable)at -> logger.info(() -> CodeFlow$.codeToToken$$anonfun$1$$anonfun$1$$anonfun$1(at), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("codeToToken"), Line$.MODULE$.apply(73)));
            }
            Response r = response;
            return implicits$.MODULE$.toFunctorOps(logger.error(() -> CodeFlow$.codeToToken$$anonfun$1$$anonfun$2(r, evidence$1), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("codeToToken"), Line$.MODULE$.apply(76)), (Functor)evidence$1).map((Function1 & Serializable)_$8 -> None$.MODULE$);
        }, evidence$1));
    }

    private <F> OptionT<F, CodeFlow.UserInfo> tokenToUser(Client<F> c, Http4sClientDsl<F> dsl, AuthConfig.OAuth cfg, String token, Async<F> evidence$1) {
        Logger logger = package$.MODULE$.getLogger(evidence$1, Enclosing$.MODULE$.apply("sharry.restserver.oauth.CodeFlow.tokenToUser logger"));
        Method method = dsl.http4sClientSyntaxMethod(Method$.MODULE$.GET());
        Request req = MethodOps$.MODULE$.apply$extension(method, Uri$.MODULE$.unsafeFromString(cfg.userUrl().asString()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Authorization$.MODULE$.apply((Credentials)Credentials.Token$.MODULE$.apply(AuthScheme$.MODULE$.Bearer(), token)), Authorization$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Accept$.MODULE$.apply(MediaRangeAndQValue$.MODULE$.withDefaultQValue((MediaRange)MediaType$.MODULE$.application().json()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MediaRangeAndQValue[0])), Accept$.MODULE$.headerInstance())}));
        Object resp = c.run(req).use((Function1 & Serializable)x$1 -> {
            Option option;
            Response response = x$1;
            if (response != null && !(option = Status.Successful$.MODULE$.unapply(response)).isEmpty()) {
                Response response2;
                Response r = response2 = (Response)option.get();
                return implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFlatMapOps(r.as((MonadError)evidence$1, CirceEntityCodec$.MODULE$.circeEntityDecoder((GenConcurrent)evidence$1, Decoder$.MODULE$.decodeJson())), (FlatMap)evidence$1).flatTap((Function1 & Serializable)j -> logger.trace(() -> CodeFlow$.$anonfun$3$$anonfun$1$$anonfun$1(j), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("resp"), Line$.MODULE$.apply(98))), (Functor)evidence$1).map((Function1 & Serializable)json -> MODULE$.decode(cfg, (Json)json)), (FlatMap)evidence$1).flatTap((Function1 & Serializable)uid -> logger.info(() -> CodeFlow$.$anonfun$3$$anonfun$3$$anonfun$1(uid), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("resp"), Line$.MODULE$.apply(100)));
            }
            Response r = response;
            return implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFlatMapOps(r.as((MonadError)evidence$1, CirceEntityCodec$.MODULE$.circeEntityDecoder((GenConcurrent)evidence$1, Decoder$.MODULE$.decodeString())), (FlatMap)evidence$1).flatMap((Function1 & Serializable)err -> logger.error(() -> CodeFlow$.$anonfun$3$$anonfun$4$$anonfun$1(r, err), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("resp"), Line$.MODULE$.apply(104))), (Functor)evidence$1).map((Function1 & Serializable)_$10 -> None$.MODULE$);
        }, evidence$1);
        return OptionT$.MODULE$.apply(resp);
    }

    private Option<CodeFlow.UserInfo> decode(AuthConfig.OAuth cfg, Json json) {
        return json.findAllByKey(cfg.userIdKey()).find((Function1 & Serializable)_$11 -> _$11.isString()).flatMap((Function1 & Serializable)_$12 -> _$12.asString()).map((Function1 & Serializable)id -> {
            Option email = implicits$.MODULE$.toFoldableOps((Object)cfg.userEmailKey().toList().flatMap((Function1 & Serializable)key -> json.findAllByKey(key)).find((Function1 & Serializable)_$13 -> _$13.isString()).flatMap((Function1 & Serializable)_$14 -> _$14.asString()).map((Function1 & Serializable)_$15 -> _$15.trim()), (Foldable)implicits$.MODULE$.catsStdInstancesForOption()).find((Function1 & Serializable)_$16 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$16)));
            return Tuple2$.MODULE$.apply(id, (Object)email);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Option email = (Option)tuple2._2();
                return CodeFlow$UserInfo$.MODULE$.apply(MODULE$.normalizeUid(id), (Option<String>)email);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Ident normalizeUid(String uid) {
        return Ident$.MODULE$.unsafe(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(uid), (Function1 & Serializable)elem -> CodeFlow$.normalizeUid$$anonfun$1(BoxesRunTime.unboxToChar((Object)elem))));
    }

    private <F> Client<F> logRequestResponses(Client<F> c, Logger<F> logger, Async<F> evidence$1) {
        Some some = Some$.MODULE$.apply((Function1 & Serializable)msg -> logger.trace(() -> CodeFlow$.$anonfun$9$$anonfun$1(msg), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("lreq"), Line$.MODULE$.apply(133)));
        Function1 function1 = RequestLogger$.MODULE$.apply$default$3();
        Function1 & Serializable lreq = (Function1 & Serializable)client -> RequestLogger$.MODULE$.apply(true, true, function1, (Option)some, client, evidence$1);
        Some some2 = Some$.MODULE$.apply((Function1 & Serializable)msg -> logger.trace(() -> CodeFlow$.$anonfun$11$$anonfun$1(msg), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("lres"), Line$.MODULE$.apply(139)));
        Function1 function12 = ResponseLogger$.MODULE$.apply$default$3();
        Function1 & Serializable lres = (Function1 & Serializable)client -> ResponseLogger$.MODULE$.apply(true, true, function12, (Option)some2, client, evidence$1);
        return (Client)lreq.andThen((Function1)lres).apply(c);
    }

    private static final String apply$$anonfun$1(AuthConfig.OAuth cfg$1, String code$1) {
        return new StringBuilder(46).append("Obtaining access_token for provider ").append(cfg$1.id().id()).append(" and code ").append(code$1).toString();
    }

    private static final String apply$$anonfun$2$$anonfun$1$$anonfun$1(AuthConfig.OAuth cfg$4, String token$1) {
        return new StringBuilder(44).append("Obtaining user-info for provider ").append(cfg$4.id().id()).append(" and token ").append(token$1).toString();
    }

    private static final /* synthetic */ OptionT apply$$anonfun$2(Client c$1, Http4sClientDsl dsl$1, AuthConfig.OAuth cfg$2, String redirectUri$1, String code$2, Async evidence$1$1, Logger logger$1, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return MODULE$.codeToToken(c$1, dsl$1, cfg$2, redirectUri$1, code$2, evidence$1$1).flatMap((Function1 & Serializable)token -> OptionT$.MODULE$.liftF(logger$1.debug(() -> CodeFlow$.apply$$anonfun$2$$anonfun$1$$anonfun$1(cfg$2, token), Pkg$.MODULE$.apply("sharry.restserver.oauth"), FileName$.MODULE$.apply("CodeFlow.scala"), Name$.MODULE$.apply("apply"), Line$.MODULE$.apply(42)), (Functor)evidence$1$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.tokenToUser((Client)c$1, (Http4sClientDsl)dsl$1, cfg$2, (String)token, (Async)evidence$1$1).map((Function1 & Serializable)user -> user, (Functor)evidence$1$1);
        }, (Monad)evidence$1$1), (Monad)evidence$1$1);
    }

    private static final String codeToToken$$anonfun$1$$anonfun$1$$anonfun$1(Option at$1) {
        return new StringBuilder(11).append("Got token: ").append(at$1).toString();
    }

    private static final String codeToToken$$anonfun$1$$anonfun$2(Response r$1, Async evidence$1$5) {
        return new StringBuilder(34).append("Error obtaining access token '").append(r$1.status().code()).append("' / ").append(r$1.as((MonadError)evidence$1$5, CirceEntityCodec$.MODULE$.circeEntityDecoder((GenConcurrent)evidence$1$5, Decoder$.MODULE$.decodeString()))).toString();
    }

    private static final String $anonfun$3$$anonfun$1$$anonfun$1(Json j$1) {
        return new StringBuilder(16).append("user structure: ").append(j$1.noSpaces()).toString();
    }

    private static final String $anonfun$3$$anonfun$3$$anonfun$1(Option uid$1) {
        return new StringBuilder(13).append("Got user id: ").append(uid$1).toString();
    }

    private static final String $anonfun$3$$anonfun$4$$anonfun$1(Response r$3, String err$1) {
        return new StringBuilder(28).append("Cannot obtain user info: ").append(r$3.status().code()).append(" / ").append(err$1).toString();
    }

    private static final /* synthetic */ boolean normalizeUid$$anonfun$1(char elem) {
        return Ident$.MODULE$.chars().contains((Object)BoxesRunTime.boxToCharacter((char)elem));
    }

    private static final String $anonfun$9$$anonfun$1(String msg$1) {
        return msg$1;
    }

    private static final String $anonfun$11$$anonfun$1(String msg$2) {
        return msg$2;
    }
}

