/*
 * Decompiled with CFR 0.152.
 */
package sharry.restserver.routes;

import binny.ByteRange;
import binny.ByteRange$;
import cats.Applicative;
import cats.Functor;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Sync;
import cats.implicits$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.EntityEncoder$;
import org.http4s.EntityTag;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.dsl.Http4sDsl;
import org.http4s.dsl.impl.Responses;
import org.http4s.headers.Accept$minusRanges$;
import org.http4s.headers.Content$minusDisposition$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.ETag$;
import org.http4s.headers.If$minusNone$minusMatch$;
import org.http4s.headers.Last$minusModified$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import sharry.backend.BackendApp;
import sharry.backend.share.FileRange;
import sharry.backend.share.ShareId;
import sharry.common.ByteSize;
import sharry.common.Ident;
import sharry.store.records.RFileMeta;

public final class ByteResponse$
implements Serializable {
    public static final ByteResponse$ MODULE$ = new ByteResponse$();

    private ByteResponse$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ByteResponse$.class);
    }

    public <F> Object apply(Http4sDsl<F> dsl, Request<F> req, BackendApp<F> backend, ShareId shareId, Option<String> pass, ByteSize chunkSize, Ident fid, Sync<F> evidence$1) {
        return Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Range$.MODULE$.headerInstance())).map((Function1 & Serializable)_$2 -> (Range.SubRange)_$2.ranges().head()).map((Function1 & Serializable)sr -> MODULE$.range(dsl, req, (Range.SubRange)sr, backend, shareId, pass, chunkSize, fid, evidence$1)).getOrElse(() -> ByteResponse$.apply$$anonfun$3(dsl, req, backend, shareId, pass, fid, evidence$1));
    }

    public <F> Object range(Http4sDsl<F> dsl, Request<F> req, Range.SubRange sr, BackendApp<F> backend, ShareId shareId, Option<String> pass, ByteSize chunkSize, Ident fid, Sync<F> evidence$1) {
        ByteRange rangeDef = this.makeBinnyByteRange(sr, chunkSize);
        return backend.share().loadFile(shareId, fid, pass, rangeDef).flatMap((Function1 & Serializable)file -> OptionT$.MODULE$.liftF(MODULE$.rangeInvalid(file.fileMeta(), sr) ? dsl.http4sRangeNotSatisfiableSyntax(dsl.RangeNotSatisfiable()).apply((Applicative)evidence$1) : (file.fileMeta().length().$less$eq(chunkSize) ? MODULE$.allBytes(dsl, req, (FileRange)file, evidence$1) : MODULE$.partialResponse(dsl, req, (FileRange)file, chunkSize, sr, evidence$1)), (Functor)evidence$1).map((Function1 & Serializable)resp -> resp, (Functor)evidence$1), evidence$1).getOrElseF(() -> ByteResponse$.range$$anonfun$2(dsl, evidence$1), evidence$1);
    }

    public <F> Object all(Http4sDsl<F> dsl, Request<F> req, BackendApp<F> backend, ShareId shareId, Option<String> pass, Ident fid, Sync<F> evidence$1) {
        return backend.share().loadFile(shareId, fid, pass, (ByteRange)ByteRange.All$.MODULE$).flatMap((Function1 & Serializable)file -> OptionT$.MODULE$.liftF(MODULE$.allBytes(dsl, req, (FileRange)file, evidence$1), (Functor)evidence$1).map((Function1 & Serializable)resp -> resp, (Functor)evidence$1), evidence$1).getOrElseF(() -> ByteResponse$.all$$anonfun$2(dsl, evidence$1), evidence$1);
    }

    public <F> Object allBytes(Http4sDsl<F> dsl, Request<F> req, FileRange<F> file, Sync<F> evidence$1) {
        Method method = req.method();
        Method method2 = Method$.MODULE$.HEAD();
        boolean isHead = !(method != null ? !method.equals(method2) : method2 != null);
        Stream data2 = !isHead ? file.data() : Stream$.MODULE$.empty();
        return this.etagResponse(dsl, req, file, evidence$1).getOrElseF(() -> ByteResponse$.allBytes$$anonfun$1(dsl, data2, evidence$1, file), evidence$1);
    }

    private <F> OptionT<F, Response<F>> etagResponse(Http4sDsl<F> dsl, Request<F> req, FileRange<F> file, Sync<F> evidence$1) {
        Option noneMatch = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(If$minusNone$minusMatch$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)_$8 -> _$8.tags()).map((Function1 & Serializable)_$9 -> ((EntityTag)_$9.head()).tag());
        if (noneMatch.contains((Object)file.fileMeta().checksum().toHex())) {
            return OptionT$.MODULE$.liftF(new Responses.NotModifiedOps(dsl.http4sNotModifiedSyntax(dsl.NotModified())).apply(evidence$1), evidence$1);
        }
        return OptionT$.MODULE$.none(evidence$1);
    }

    private <F> Object partialResponse(Http4sDsl<F> dsl, Request<F> req, FileRange<F> file, ByteSize chunkSize, Range.SubRange range, Sync<F> evidence$1) {
        ByteSize fileLen = file.fileMeta().length();
        long respLen = BoxesRunTime.unboxToLong((Object)range.second().map((Function1)(JFunction1.mcJJ.sp & Serializable)until -> until - range.first() + 1L).getOrElse(() -> ByteResponse$.$anonfun$4(chunkSize)));
        Range.SubRange respRange = Range.SubRange$.MODULE$.apply(range.first(), BoxesRunTime.unboxToLong((Object)range.second().getOrElse(() -> ByteResponse$.$anonfun$5(range, chunkSize))));
        Method method = req.method();
        Method method2 = Method$.MODULE$.HEAD();
        boolean isHead = !(method != null ? !method.equals(method2) : method2 != null);
        Stream data2 = isHead ? Stream$.MODULE$.empty() : file.data().take(respLen);
        return implicits$.MODULE$.toFunctorOps(dsl.http4sPartialContentSyntax(dsl.PartialContent()).apply((Object)data2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), evidence$1, EntityEncoder$.MODULE$.entityBodyEncoder()), evidence$1).map((Function1 & Serializable)_$11 -> (Response)_$11.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Accept$minusRanges$.MODULE$.bytes(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusType$.MODULE$.apply(MODULE$.mediaType(file)), Content$minusType$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Last$minusModified$.MODULE$.apply(MODULE$.timestamp(file)), Last$minusModified$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusDisposition$.MODULE$.apply("inline", MODULE$.fileNameMap(file)), Content$minusDisposition$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.rawToRaw(MODULE$.fileSizeHeader(file.fileMeta().length())), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(RangeUnit$.MODULE$.Bytes(), respRange, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)fileLen.bytes()))), Content$minusRange$.MODULE$.headerInstance())})));
    }

    private ByteRange makeBinnyByteRange(Range.SubRange sr, ByteSize chunkSize) {
        return (ByteRange)sr.second().map((Function1 & Serializable)until -> ByteRange$.MODULE$.apply(sr.first(), (int)(BoxesRunTime.unboxToLong((Object)until) - sr.first() + 1L))).getOrElse(() -> ByteResponse$.makeBinnyByteRange$$anonfun$2(sr, chunkSize));
    }

    private <F> Response<F> setETag(RFileMeta fm, Response<F> r) {
        if (fm.checksum().isEmpty()) {
            return r;
        }
        return (Response)r.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)ETag$.MODULE$.apply(fm.checksum().toHex(), ETag$.MODULE$.apply$default$2()), ETag$.MODULE$.headerInstance())}));
    }

    private boolean rangeInvalid(RFileMeta file, Range.SubRange range) {
        return range.first() < 0L || range.second().exists((Function1)(JFunction1.mcZJ.sp & Serializable)t -> t < range.first() || t > file.length().bytes());
    }

    private <F> MediaType mediaType(FileRange<F> file) {
        return MediaType$.MODULE$.unsafeParse(file.fileMeta().mimetype());
    }

    private <F> HttpDate timestamp(FileRange<F> file) {
        return HttpDate$.MODULE$.unsafeFromInstant(file.fileMeta().created().value());
    }

    private <F> Map<CIString, String> fileNameMap(FileRange<F> file) {
        return (Map)file.shareFile().filename().map((Function1 & Serializable)n -> {
            Object[] objectArray = new Tuple2[1];
            CIString cIString = (CIString)Predef$.MODULE$.ArrowAssoc((Object)CIString$.MODULE$.apply("filename"));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)cIString, n);
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }).getOrElse(ByteResponse$::fileNameMap$$anonfun$2);
    }

    private Header.Raw fileSizeHeader(ByteSize sz) {
        return Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply("File-Size"), BoxesRunTime.boxToLong((long)sz.bytes()).toString());
    }

    private static final Object apply$$anonfun$3(Http4sDsl dsl$2, Request req$2, BackendApp backend$2, ShareId shareId$2, Option pass$2, Ident fid$2, Sync evidence$1$2) {
        return MODULE$.all(dsl$2, req$2, backend$2, shareId$2, (Option<String>)pass$2, fid$2, evidence$1$2);
    }

    private static final Object range$$anonfun$2(Http4sDsl dsl$4, Sync evidence$1$4) {
        return dsl$4.http4sNotFoundSyntax(dsl$4.NotFound()).apply((Applicative)evidence$1$4);
    }

    private static final Object all$$anonfun$2(Http4sDsl dsl$6, Sync evidence$1$6) {
        return dsl$6.http4sNotFoundSyntax(dsl$6.NotFound()).apply((Applicative)evidence$1$6);
    }

    private static final Object allBytes$$anonfun$1(Http4sDsl dsl$7, Stream data$1, Sync evidence$1$7, FileRange file$1) {
        return implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(dsl$7.http4sOkSyntax(dsl$7.Ok()).apply((Object)data$1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), (Applicative)evidence$1$7, EntityEncoder$.MODULE$.entityBodyEncoder()), (Functor)evidence$1$7).map((Function1 & Serializable)r -> MODULE$.setETag(file$1.fileMeta(), (Response)r)), (Functor)evidence$1$7).map((Function1 & Serializable)_$6 -> (Response)_$6.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusType$.MODULE$.apply(MODULE$.mediaType(file$1)), Content$minusType$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Accept$minusRanges$.MODULE$.bytes(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Last$minusModified$.MODULE$.apply(MODULE$.timestamp(file$1)), Last$minusModified$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusDisposition$.MODULE$.apply("inline", MODULE$.fileNameMap(file$1)), Content$minusDisposition$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.rawToRaw(MODULE$.fileSizeHeader(file$1.fileMeta().length()))})));
    }

    private static final long $anonfun$4(ByteSize chunkSize$3) {
        return chunkSize$3.bytes();
    }

    private static final long $anonfun$5(Range.SubRange range$2, ByteSize chunkSize$4) {
        return range$2.first() + chunkSize$4.bytes();
    }

    private static final ByteRange makeBinnyByteRange$$anonfun$2(Range.SubRange sr$3, ByteSize chunkSize$5) {
        if (sr$3.first() == 0L) {
            return ByteRange$.MODULE$.apply(0L, (int)chunkSize$5.bytes());
        }
        return ByteRange$.MODULE$.apply(sr$3.first(), (int)chunkSize$5.bytes());
    }

    private static final Map fileNameMap$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }
}

