/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber$;
import cats.effect.Trace;
import cats.effect.tracing.Tracing$;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.TimerSkipList;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import cats.effect.unsafe.WorkerThread;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Right;

public final class WorkStealingThreadPool
implements ExecutionContext,
ExecutionContextExecutor,
Scheduler {
    private final int threadCount;
    private final String threadPrefix;
    private final String blockerThreadPrefix;
    private final Duration runtimeBlockingExpiration;
    private final boolean blockedThreadDetectionEnabled;
    private final Function1<Throwable, BoxedUnit> reportFailure0;
    private final WorkerThread[] workerThreads;
    private final LocalQueue[] localQueues;
    private final TimerSkipList[] sleepers;
    private final AtomicBoolean[] parkedSignals;
    private final WeakBag[] fiberBags;
    private final AtomicBoolean workerThreadPublisher;
    private final ScalQueue<Object> externalQueue;
    private final AtomicInteger state;
    private final ConcurrentSkipListSet cachedThreads;
    private final AtomicBoolean done;
    private final AtomicInteger blockedWorkerThreadCounter;
    private final AtomicInteger blockedWorkerThreadNamingIndex;
    private final Right<Nothing$, BoxedUnit> RightUnit;

    public WorkStealingThreadPool(int threadCount, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, boolean blockedThreadDetectionEnabled, Function1<Throwable, BoxedUnit> reportFailure0) {
        int i;
        this.threadCount = threadCount;
        this.threadPrefix = threadPrefix;
        this.blockerThreadPrefix = blockerThreadPrefix;
        this.runtimeBlockingExpiration = runtimeBlockingExpiration;
        this.blockedThreadDetectionEnabled = blockedThreadDetectionEnabled;
        this.reportFailure0 = reportFailure0;
        ExecutionContext.$init$((ExecutionContext)this);
        this.workerThreads = new WorkerThread[threadCount];
        this.localQueues = new LocalQueue[threadCount];
        this.sleepers = new TimerSkipList[threadCount];
        this.parkedSignals = new AtomicBoolean[threadCount];
        this.fiberBags = new WeakBag[threadCount];
        this.workerThreadPublisher = new AtomicBoolean(false);
        this.externalQueue = new ScalQueue(threadCount << 2);
        this.state = new AtomicInteger(threadCount << 16);
        this.cachedThreads = new ConcurrentSkipListSet<WorkerThread>(Comparator.comparingInt(_$1 -> _$1.nameIndex()));
        this.done = new AtomicBoolean(false);
        this.blockedWorkerThreadCounter = new AtomicInteger(0);
        this.blockedWorkerThreadNamingIndex = new AtomicInteger(0);
        for (i = 0; i < threadCount; ++i) {
            WorkerThread thread;
            AtomicBoolean parkedSignal;
            TimerSkipList sleepersList;
            LocalQueue queue;
            this.localQueues()[i] = queue = new LocalQueue();
            this.sleepers()[i] = sleepersList = new TimerSkipList();
            this.parkedSignals()[i] = parkedSignal = new AtomicBoolean(false);
            int index = i;
            WeakBag<Runnable> fiberBag = new WeakBag<Runnable>();
            this.fiberBags()[i] = fiberBag;
            this.workerThreads[i] = thread = new WorkerThread(index, queue, parkedSignal, this.externalQueue, fiberBag, sleepersList, this);
        }
        this.workerThreadPublisher.set(true);
        for (i = 0; i < threadCount; ++i) {
            this.workerThreads[i].start();
        }
        this.RightUnit = IOFiber$.MODULE$.RightUnit();
    }

    public String threadPrefix() {
        return this.threadPrefix;
    }

    public String blockerThreadPrefix() {
        return this.blockerThreadPrefix;
    }

    public Duration runtimeBlockingExpiration() {
        return this.runtimeBlockingExpiration;
    }

    public boolean blockedThreadDetectionEnabled() {
        return this.blockedThreadDetectionEnabled;
    }

    public LocalQueue[] localQueues() {
        return this.localQueues;
    }

    public TimerSkipList[] sleepers() {
        return this.sleepers;
    }

    public AtomicBoolean[] parkedSignals() {
        return this.parkedSignals;
    }

    public WeakBag<Runnable>[] fiberBags() {
        return this.fiberBags;
    }

    public ConcurrentSkipListSet<WorkerThread> cachedThreads() {
        return this.cachedThreads;
    }

    public AtomicBoolean done() {
        return this.done;
    }

    public AtomicInteger blockedWorkerThreadCounter() {
        return this.blockedWorkerThreadCounter;
    }

    public AtomicInteger blockedWorkerThreadNamingIndex() {
        return this.blockedWorkerThreadNamingIndex;
    }

    public WorkerThread[] getWorkerThreads() {
        return this.workerThreads;
    }

    public Runnable stealFromOtherWorkerThread(int dest, ThreadLocalRandom random, WorkerThread destWorker) {
        LocalQueue destQueue = this.localQueues()[dest];
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            Runnable res;
            int index = (from + i) % this.threadCount;
            if (index == dest || (res = this.localQueues()[index].stealInto(destQueue, destWorker)) == null) continue;
            return res;
        }
        Object element = this.externalQueue.poll(random);
        if (element instanceof Runnable[]) {
            Runnable[] batch = (Runnable[])element;
            return destQueue.enqueueBatch(batch, destWorker);
        }
        if (element instanceof Runnable) {
            Runnable fiber = (Runnable)element;
            if (TracingConstants.isStackTracing) {
                destWorker.active_$eq(fiber);
                this.parkedSignals()[dest].lazySet(false);
            }
            return fiber;
        }
        return null;
    }

    public boolean stealTimers(long now, ThreadLocalRandom random) {
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            TimerSkipList tsl = this.sleepers()[index];
            boolean invoked = false;
            boolean cont = true;
            while (cont) {
                Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb = tsl.pollFirstIfTriggered(now);
                if (cb != null) {
                    cb.apply(this.RightUnit);
                    invoked = true;
                    continue;
                }
                cont = false;
            }
            if (!invoked) continue;
            return true;
        }
        return false;
    }

    public boolean notifyParked(ThreadLocalRandom random) {
        if (!this.notifyShouldWakeup()) {
            return false;
        }
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            AtomicBoolean signal = this.parkedSignals()[index];
            if (!signal.getAndSet(false)) continue;
            this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
            this.workerThreadPublisher.get();
            WorkerThread worker = this.workerThreads[index];
            LockSupport.unpark(worker);
            return true;
        }
        return false;
    }

    private final void notifyForTimer(int index) {
        AtomicBoolean signal = this.parkedSignals()[index];
        if (signal.getAndSet(false)) {
            this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
            this.workerThreadPublisher.get();
            WorkerThread worker = this.workerThreads[index];
            LockSupport.unpark(worker);
            return;
        }
    }

    private boolean notifyShouldWakeup() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.SearchMask) == 0 && (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16 < this.threadCount;
    }

    public void notifyIfWorkPending(ThreadLocalRandom random) {
        for (int i = 0; i < this.threadCount; ++i) {
            if (!this.localQueues()[i].nonEmpty()) continue;
            this.notifyParked(random);
            return;
        }
        if (this.externalQueue.nonEmpty()) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToSearching() {
        int st = this.state.get();
        if (2 * (st & WorkStealingThreadPoolConstants.SearchMask) >= this.threadCount) {
            return false;
        }
        this.state.getAndIncrement();
        return true;
    }

    public void transitionWorkerFromSearching(ThreadLocalRandom random) {
        int prev = this.state.getAndDecrement();
        if (prev == 1) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToParkedWhenSearching() {
        int prev = this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaSearching);
        return (prev & WorkStealingThreadPoolConstants.SearchMask) == 1;
    }

    public void transitionWorkerToParked() {
        this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaNotSearching);
    }

    public void doneSleeping() {
        this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
    }

    public void replaceWorker(int index, WorkerThread newWorker) {
        this.workerThreads[index] = newWorker;
        this.workerThreadPublisher.lazySet(true);
    }

    public void reschedule(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.reschedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public boolean canExecuteBlockingCode() {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            return worker.canExecuteBlockingCodeOn(this);
        }
        return false;
    }

    public void prepareForBlocking() {
        Thread thread = Thread.currentThread();
        WorkerThread worker = (WorkerThread)thread;
        worker.prepareForBlocking();
    }

    private void scheduleExternal(Runnable fiber) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.externalQueue.offer(fiber, random);
        this.notifyParked(random);
    }

    public Tuple3<Map<Runnable, Trace>, Map<WorkerThread, Tuple3<Thread.State, Option<Tuple2<Runnable, Trace>>, Map<Runnable, Trace>>>, Map<Runnable, Trace>> liveTraces() {
        Map externalFibers = this.externalQueue.snapshot().iterator().flatMap((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Runnable[]) {
                Object[] batch = (Runnable[])object;
                Object object2 = Predef$.MODULE$.refArrayOps(batch);
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)r -> Tracing$.MODULE$.captureTrace((Runnable)r), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (object instanceof Runnable) {
                Runnable r2 = (Runnable)object;
                return Option$.MODULE$.option2Iterable(Tracing$.MODULE$.captureTrace(r2)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return Predef$.MODULE$.Map().empty();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map suspended = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        for (int i = 0; i < this.threadCount; ++i) {
            Map localFibers = this.localQueues()[i].snapshot().iterator().flatMap((Function1 & Serializable)r -> Tracing$.MODULE$.captureTrace((Runnable)r)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            WorkerThread worker = this.workerThreads[i];
            boolean bl = this.parkedSignals()[i].get();
            Option active = Option$.MODULE$.apply((Object)worker.active());
            WorkerThread workerThread = (WorkerThread)Predef$.MODULE$.ArrowAssoc((Object)worker);
            map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)workerThread, (Object)Tuple3$.MODULE$.apply((Object)worker.getState(), (Object)active.flatMap((Function1 & Serializable)a -> Tracing$.MODULE$.captureTrace((Runnable)a)), (Object)localFibers)));
            suspended.$plus$plus$eq(worker.suspendedTraces());
        }
        return Tuple3$.MODULE$.apply((Object)externalFibers, (Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)suspended.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void execute(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.schedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public void reportFailure(Throwable cause) {
        this.reportFailure0.apply((Object)cause);
    }

    @Override
    public long monotonicNanos() {
        long back = System.nanoTime();
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            ((WorkerThread)thread).now_$eq(back);
        }
        return back;
    }

    @Override
    public long nowMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nowMicros() {
        Instant now = Instant.now();
        return now.getEpochSecond() * 1000000L + now.getLong(ChronoField.MICRO_OF_SECOND);
    }

    public Runnable sleepInternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(this)) {
                return worker.sleep(delay, callback);
            }
            return this.sleepExternal(delay, callback);
        }
        return this.sleepExternal(delay, callback);
    }

    private final Runnable sleepExternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int idx = random.nextInt(this.threadCount);
        TimerSkipList tsl = this.sleepers()[idx];
        Runnable cancel = tsl.insert(System.nanoTime(), delay.toNanos(), callback, random);
        this.notifyForTimer(idx);
        return cancel;
    }

    @Override
    public Runnable sleep(FiniteDuration delay, Runnable task) {
        return this.sleepInternal(delay, (Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> task.run());
    }

    public void shutdown() {
        boolean interruptCalling = Thread.interrupted();
        if (this.done().compareAndSet(false, true)) {
            this.workerThreadPublisher.get();
            for (int i = 0; i < this.threadCount; ++i) {
                this.workerThreads[i].interrupt();
            }
            Thread.interrupted();
            WorkerThread t = null;
            while ((t = this.cachedThreads().pollFirst()) != null) {
                t.interrupt();
            }
            this.externalQueue.clear();
            if (interruptCalling) {
                Thread.currentThread().interrupt();
                return;
            }
            return;
        }
    }

    public int getWorkerThreadCount() {
        return this.threadCount;
    }

    public int getActiveThreadCount() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16;
    }

    public int getSearchingThreadCount() {
        int st = this.state.get();
        return st & WorkStealingThreadPoolConstants.SearchMask;
    }

    public int getBlockedWorkerThreadCount() {
        return this.blockedWorkerThreadCounter().get();
    }

    public long getLocalQueueFiberCount() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.localQueues());
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.size(), ClassTag$.MODULE$.apply(Long.TYPE))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getSuspendedFiberCount() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.workerThreads);
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$4 -> _$4.getSuspendedFiberCount(), ClassTag$.MODULE$.apply(Long.TYPE))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }
}

