/*
 * Decompiled with CFR 0.152.
 */
package scribe;

import java.io.PrintStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scribe.Level;
import scribe.Level$;
import scribe.Logger;
import scribe.Logger$system$;
import scribe.LoggerId;
import scribe.LoggerId$;
import scribe.MinimumLevel;
import scribe.Platform$;
import scribe.handler.LogHandler;
import scribe.modify.LogModifier;

public final class Logger$
implements Mirror.Product,
Serializable {
    public static final PrintStream scribe$Logger$$$systemOut;
    public static final PrintStream scribe$Logger$$$systemErr;
    private volatile Object DefaultRootMinimumLevel$lzy1;
    public static final Logger$system$ system;
    private static final long RootId;
    public static long scribe$Logger$$$lastChange;
    private static Map<LoggerId, Logger> id2Logger;
    private static Map<String, LoggerId> name2Id;
    public static final Logger$ MODULE$;

    private Logger$() {
    }

    static {
        MODULE$ = new Logger$();
        scribe$Logger$$$systemOut = System.out;
        scribe$Logger$$$systemErr = System.err;
        RootId = LoggerId$.MODULE$.apply(0L);
        scribe$Logger$$$lastChange = 0L;
        id2Logger = Predef$.MODULE$.Map().empty();
        name2Id = Predef$.MODULE$.Map().empty();
        MODULE$.resetRoot();
        Platform$.MODULE$.init();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logger$.class);
    }

    public Logger apply(Option<LoggerId> parentId, List<LogModifier> modifiers, List<LogHandler> handlers, Option<String> overrideClassName, Map<String, Function0<Object>> data, long id) {
        return new Logger(parentId, modifiers, handlers, overrideClassName, data, id);
    }

    public Logger unapply(Logger x$1) {
        return x$1;
    }

    public Option<LoggerId> $lessinit$greater$default$1() {
        return Some$.MODULE$.apply((Object)new LoggerId(this.RootId()));
    }

    public List<LogModifier> $lessinit$greater$default$2() {
        return package$.MODULE$.Nil();
    }

    public List<LogHandler> $lessinit$greater$default$3() {
        return package$.MODULE$.Nil();
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Map<String, Function0<Object>> $lessinit$greater$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public long $lessinit$greater$default$6() {
        return LoggerId$.MODULE$.apply();
    }

    public Level DefaultRootMinimumLevel() {
        Object object = this.DefaultRootMinimumLevel$lzy1;
        if (object instanceof Level) {
            return (Level)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Level)this.DefaultRootMinimumLevel$lzyINIT1();
    }

    private Object DefaultRootMinimumLevel$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DefaultRootMinimumLevel$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Level level = null;
                    try {
                        level = (Level)Option$.MODULE$.apply((Object)System.getenv("SCRIBE_MINIMUM_LEVEL")).flatMap((Function1 & Serializable)name -> Level$.MODULE$.get((String)name)).getOrElse(this::DefaultRootMinimumLevel$lzyINIT1$$anonfun$2);
                        object2 = level == null ? LazyVals.NullValue$.MODULE$ : level;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DefaultRootMinimumLevel$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return level;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public long RootId() {
        return RootId;
    }

    public Logger empty() {
        return this.apply(this.$lessinit$greater$default$1(), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6());
    }

    public Logger root() {
        return this.apply(this.RootId());
    }

    public Map<String, Logger> loggersByName() {
        return (Map)name2Id.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                long id = tuple2._2() == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)tuple2._2()).value();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, id2Logger.apply((Object)new LoggerId(id)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void reset() {
        id2Logger = Predef$.MODULE$.Map().empty();
        name2Id = Predef$.MODULE$.Map().empty();
        this.resetRoot();
    }

    public Logger apply(String name) {
        Option<Logger> option = this.get(name);
        if (option instanceof Some) {
            Logger logger = (Logger)((Some)option).value();
            return logger;
        }
        if (None$.MODULE$.equals(option)) {
            Logger logger;
            Logger$ logger$ = this;
            synchronized (logger$) {
                long l;
                String n = this.fixName(name);
                int dotIndex = n.lastIndexOf(46);
                if (dotIndex > 0) {
                    String parentName = n.substring(0, dotIndex);
                    Logger parent = this.apply(parentName);
                    l = parent.id();
                } else {
                    l = this.RootId();
                }
                long parentId = l;
                Logger logger2 = this.apply((Option<LoggerId>)Some$.MODULE$.apply((Object)new LoggerId(parentId)), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6());
                LoggerId loggerId = (LoggerId)Predef$.MODULE$.ArrowAssoc((Object)new LoggerId(logger2.id()));
                id2Logger = (Map)id2Logger.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)loggerId, (Object)logger2));
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)n);
                name2Id = (Map)name2Id.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new LoggerId(logger2.id())));
                scribe$Logger$$$lastChange = System.currentTimeMillis();
                logger = logger2;
            }
            return logger;
        }
        throw new MatchError(option);
    }

    public Logger apply(long id) {
        Option<Logger> option = this.get(id);
        if (option instanceof Some) {
            Logger logger = (Logger)((Some)option).value();
            return logger;
        }
        if (None$.MODULE$.equals(option)) {
            Logger logger;
            Logger$ logger$ = this;
            synchronized (logger$) {
                Logger logger2 = new Logger(this.$lessinit$greater$default$1(), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), id);
                LoggerId loggerId = (LoggerId)Predef$.MODULE$.ArrowAssoc((Object)new LoggerId(logger2.id()));
                id2Logger = (Map)id2Logger.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)loggerId, (Object)logger2));
                scribe$Logger$$$lastChange = System.currentTimeMillis();
                logger = logger2;
            }
            return logger;
        }
        throw new MatchError(option);
    }

    public void minimumLevels(Seq<MinimumLevel> minimums) {
        minimums.foreach((Function1 & Serializable)m -> {
            Logger logger = m.logger().withMinimumLevel(m.minimumLevel());
            return logger.replace(logger.replace$default$1());
        });
    }

    public <T> Logger apply(ClassTag<T> t) {
        return this.apply(t.runtimeClass().getName());
    }

    public Option<Logger> get(String name) {
        return name2Id.get((Object)this.fixName(name)).flatMap((Function1 & Serializable)id -> this.get$$anonfun$2(id == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)id).value()));
    }

    public Option<Logger> get(long id) {
        return id2Logger.get((Object)new LoggerId(id));
    }

    public <T> Option<Logger> get(ClassTag<T> t) {
        return this.get(t.runtimeClass().getName());
    }

    public Logger replace(Logger logger) {
        Logger logger2;
        Logger$ logger$ = this;
        synchronized (logger$) {
            LoggerId loggerId = (LoggerId)Predef$.MODULE$.ArrowAssoc((Object)new LoggerId(logger.id()));
            id2Logger = (Map)id2Logger.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)loggerId, (Object)logger));
            scribe$Logger$$$lastChange = System.currentTimeMillis();
            logger2 = logger;
        }
        return logger2;
    }

    public Logger replaceByName(String name, Logger logger) {
        Logger logger2;
        Logger$ logger$ = this;
        synchronized (logger$) {
            this.replace(logger);
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.fixName(name));
            name2Id = (Map)name2Id.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new LoggerId(logger.id())));
            logger2 = logger;
        }
        return logger2;
    }

    public void remove(Logger logger) {
        Logger$ logger$ = this;
        synchronized (logger$) {
            id2Logger = (Map)id2Logger.$minus((Object)new LoggerId(logger.id()));
            scribe$Logger$$$lastChange = System.currentTimeMillis();
            Iterable names = (Iterable)name2Id.collect((PartialFunction)new Serializable(logger){
                private final Logger logger$2;
                {
                    this.logger$2 = logger$3;
                }

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        long id;
                        String name = (String)tuple2._1();
                        long l = id = tuple2._2() == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)tuple2._2()).value();
                        if (this.logger$2.id() == id) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        long id;
                        String name = (String)tuple2._1();
                        long l = id = tuple2._2() == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)tuple2._2()).value();
                        if (this.logger$2.id() == id) {
                            return name;
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            name2Id = (Map)name2Id.$minus$minus((IterableOnce)names);
        }
    }

    public Set<String> namesFor(long loggerId) {
        return ((IterableOnceOps)name2Id.collect((PartialFunction)new Serializable(loggerId, this){
            private final long loggerId$3;
            {
                this.loggerId$3 = loggerId$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    long id;
                    String name = (String)tuple2._1();
                    long l = id = tuple2._2() == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)tuple2._2()).value();
                    if (id == this.loggerId$3) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    long id;
                    String name = (String)tuple2._1();
                    long l = id = tuple2._2() == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)tuple2._2()).value();
                    if (id == this.loggerId$3) {
                        return name;
                    }
                }
                return function1.apply((Object)x);
            }
        })).toSet();
    }

    public void resetRoot() {
        Logger logger = this.root().orphan().clearModifiers().withMinimumLevel(this.DefaultRootMinimumLevel()).clearHandlers();
        logger.withHandler(logger.withHandler$default$1(), logger.withHandler$default$2(), logger.withHandler$default$3(), logger.withHandler$default$4(), logger.withHandler$default$5(), logger.withHandler$default$6()).replace((Option<String>)Some$.MODULE$.apply((Object)"root"));
    }

    private String fixName(String name) {
        return name.replace("$", "");
    }

    public Logger fromProduct(Product x$0) {
        Object object;
        return new Logger((Option<LoggerId>)((Option)x$0.productElement(0)), (List<LogModifier>)((List)x$0.productElement(1)), (List<LogHandler>)((List)x$0.productElement(2)), (Option<String>)((Option)x$0.productElement(3)), (Map<String, Function0<Object>>)((Map)x$0.productElement(4)), (object = x$0.productElement(5)) == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)object).value());
    }

    private final Level DefaultRootMinimumLevel$lzyINIT1$$anonfun$2() {
        return Level$.MODULE$.Info();
    }

    private final /* synthetic */ Option get$$anonfun$2(long id) {
        return id2Logger.get((Object)new LoggerId(id));
    }
}

