/*
 * Decompiled with CFR 0.152.
 */
package binny.fs;

import binny.BinaryId;
import binny.fs.EmptyDirectoryRemove$;
import binny.fs.EmptyDirectoryRemove$Dir$;
import binny.fs.FsChunkedStoreConfig;
import binny.fs.FsStoreConfig;
import binny.util.Logger;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class EmptyDirectoryRemove<F> {
    private final Path baseDir;
    private final Function1<String, Path> targetFile;
    private final Logger<F> logger;
    private final Files<F> evidence$1;
    private final Sync<F> evidence$2;

    public static <F> EmptyDirectoryRemove<F> apply(FsChunkedStoreConfig fsChunkedStoreConfig, Files<F> files, Sync<F> sync, Logger<F> logger) {
        return EmptyDirectoryRemove$.MODULE$.apply(fsChunkedStoreConfig, files, sync, logger);
    }

    public static <F> EmptyDirectoryRemove<F> apply(FsStoreConfig fsStoreConfig, Files<F> files, Sync<F> sync, Logger<F> logger) {
        return EmptyDirectoryRemove$.MODULE$.apply(fsStoreConfig, files, sync, logger);
    }

    public EmptyDirectoryRemove(Path baseDir, Function1<String, Path> targetFile, Logger<F> logger, Files<F> evidence$1, Sync<F> evidence$2) {
        this.baseDir = baseDir;
        this.targetFile = targetFile;
        this.logger = logger;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }

    public Path baseDir() {
        return this.baseDir;
    }

    public F removeEmptyDirs(String id) {
        Path file = (Path)this.targetFile.apply((Object)new BinaryId(id));
        Stream stream = this.dirsToRemove(file).evalMap((Function1 & Serializable)p -> package.all$.MODULE$.toFunctorOps(this.isEmptyDirectory((Path)p), this.evidence$2).map((Function1 & Serializable)_$2 -> EmptyDirectoryRemove$Dir$.MODULE$.apply(p, BoxesRunTime.unboxToBoolean((Object)_$2))));
        return (F)stream.takeWhile((Function1 & Serializable)_$3 -> _$3.isEmpty(), stream.takeWhile$default$2()).map((Function1 & Serializable)_$4 -> _$4.path()).evalMap((Function1 & Serializable)p -> package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(this.evidence$1).deleteIfExists(p), this.evidence$2).map((Function1 & Serializable)_$5 -> EmptyDirectoryRemove.removeEmptyDirs$$anonfun$3$$anonfun$1(p, BoxesRunTime.unboxToBoolean((Object)_$5)))).evalTap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path p = (Path)tuple2._1();
                boolean ok = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                if (ok) {
                    return this.logger.debug(() -> EmptyDirectoryRemove.removeEmptyDirs$$anonfun$4$$anonfun$1(p));
                }
                BoxedUnit boxedUnit = (BoxedUnit)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$2);
            }
            throw new MatchError((Object)tuple2);
        }).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(this.evidence$2))).drain();
    }

    private F isEmptyDirectory(Path p) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(this.evidence$1).list(p).head().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(this.evidence$2))).last(), this.evidence$2).map((Function1 & Serializable)_$6 -> _$6.isEmpty()), this.evidence$2);
        return (F)ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchFileException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchFileException) {
                    return BoxesRunTime.boxToBoolean((boolean)false);
                }
                return function1.apply((Object)x);
            }
        }, this.evidence$2);
    }

    private Stream<F, Path> dirsToRemove(Path dir) {
        Path path2 = (Path)package.all$.MODULE$.catsSyntaxOptionId((Object)dir);
        Files files = Files$.MODULE$.apply(this.evidence$1);
        return this.parentStream((Option<Path>)OptionIdOps$.MODULE$.some$extension((Object)path2)).filter((Function1 & Serializable)_$7 -> _$7.startsWith(this.baseDir())).filter((Function1 & Serializable)_$8 -> {
            Path path = _$8;
            Path path2 = this.baseDir();
            return path == null ? path2 != null : !path.equals(path2);
        }).evalFilter((Function1 & Serializable)path -> files.isDirectory(path));
    }

    private Stream<F, Path> parentStream(Option<Path> dir) {
        Option<Path> option = dir;
        if (None$.MODULE$.equals(option)) {
            return Stream$.MODULE$.empty();
        }
        if (option instanceof Some) {
            Path p = (Path)((Some)option).value();
            return Stream$.MODULE$.emit((Object)p).$plus$plus(() -> this.parentStream$$anonfun$1(p));
        }
        throw new MatchError(option);
    }

    private static final /* synthetic */ Tuple2 removeEmptyDirs$$anonfun$3$$anonfun$1(Path p$2, boolean _$5) {
        Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)p$2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)_$5));
    }

    private static final String removeEmptyDirs$$anonfun$4$$anonfun$1(Path p$3) {
        return new StringBuilder(25).append("Removed empty directory: ").append(p$3).toString();
    }

    private final Stream parentStream$$anonfun$1(Path p$4) {
        return this.parentStream((Option<Path>)p$4.parent());
    }

    public static class Dir
    implements Product,
    Serializable {
        private final Path path;
        private final boolean isEmpty;

        public static Dir apply(Path path, boolean bl) {
            return EmptyDirectoryRemove$Dir$.MODULE$.apply(path, bl);
        }

        public static Dir fromProduct(Product product) {
            return EmptyDirectoryRemove$Dir$.MODULE$.fromProduct(product);
        }

        public static Dir unapply(Dir dir) {
            return EmptyDirectoryRemove$Dir$.MODULE$.unapply(dir);
        }

        public Dir(Path path, boolean isEmpty) {
            this.path = path;
            this.isEmpty = isEmpty;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)(this.isEmpty() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Dir)) return false;
            Dir dir = (Dir)object;
            if (this.isEmpty() != dir.isEmpty()) return false;
            Path path = this.path();
            Path path2 = dir.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            if (!dir.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Dir;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Dir";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "isEmpty";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path path() {
            return this.path;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public Dir copy(Path path, boolean isEmpty) {
            return new Dir(path, isEmpty);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public boolean copy$default$2() {
            return this.isEmpty();
        }

        public Path _1() {
            return this.path();
        }

        public boolean _2() {
            return this.isEmpty();
        }
    }
}

