/*
 * Decompiled with CFR 0.152.
 */
package sharry.logging;

import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Product;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import sharry.logging.LazyMap;
import sharry.logging.Level;
import sharry.logging.LogEvent$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class LogEvent
implements Product,
Serializable {
    private final Level level;
    private final Function0<String> msg;
    private final LazyList<Either<String, Throwable>> additional;
    private final LazyMap<String, Json> data;
    private final Pkg pkg;
    private final FileName fileName;
    private final Name name;
    private final Line line;

    public static LogEvent apply(Level level, Function0<String> function0, LazyList<Either<String, Throwable>> lazyList, LazyMap<String, Json> lazyMap, Pkg pkg, FileName fileName, Name name, Line line) {
        return LogEvent$.MODULE$.apply(level, function0, lazyList, lazyMap, pkg, fileName, name, line);
    }

    public static LogEvent fromProduct(Product product) {
        return LogEvent$.MODULE$.fromProduct(product);
    }

    public static LogEvent of(Level level, Function0<String> function0, Pkg pkg, FileName fileName, Name name, Line line) {
        return LogEvent$.MODULE$.of(level, function0, pkg, fileName, name, line);
    }

    public static LogEvent unapply(LogEvent logEvent) {
        return LogEvent$.MODULE$.unapply(logEvent);
    }

    public LogEvent(Level level, Function0<String> msg, LazyList<Either<String, Throwable>> additional, LazyMap<String, Json> data, Pkg pkg, FileName fileName, Name name, Line line) {
        this.level = level;
        this.msg = msg;
        this.additional = additional;
        this.data = data;
        this.pkg = pkg;
        this.fileName = fileName;
        this.name = name;
        this.line = line;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LogEvent)) return false;
        LogEvent logEvent = (LogEvent)object;
        Level level = this.level();
        Level level2 = logEvent.level();
        if (level == null) {
            if (level2 != null) {
                return false;
            }
        } else if (!level.equals(level2)) return false;
        Function0<String> function0 = this.msg();
        Function0<String> function02 = logEvent.msg();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        LazyList<Either<String, Throwable>> lazyList = this.additional();
        LazyList<Either<String, Throwable>> lazyList2 = logEvent.additional();
        if (lazyList == null) {
            if (lazyList2 != null) {
                return false;
            }
        } else if (!lazyList.equals(lazyList2)) return false;
        LazyMap<String, Json> lazyMap = this.data();
        LazyMap<String, Json> lazyMap2 = logEvent.data();
        if (lazyMap == null) {
            if (lazyMap2 != null) {
                return false;
            }
        } else if (!lazyMap.equals(lazyMap2)) return false;
        Pkg pkg = this.pkg();
        Pkg pkg2 = logEvent.pkg();
        if (pkg == null) {
            if (pkg2 != null) {
                return false;
            }
        } else if (!pkg.equals(pkg2)) return false;
        FileName fileName = this.fileName();
        FileName fileName2 = logEvent.fileName();
        if (fileName == null) {
            if (fileName2 != null) {
                return false;
            }
        } else if (!fileName.equals(fileName2)) return false;
        Name name = this.name();
        Name name2 = logEvent.name();
        if (name == null) {
            if (name2 != null) {
                return false;
            }
        } else if (!name.equals(name2)) return false;
        Line line = this.line();
        Line line2 = logEvent.line();
        if (line == null) {
            if (line2 == null) return true;
            return false;
        } else {
            if (!line.equals(line2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LogEvent;
    }

    public int productArity() {
        return 8;
    }

    public String productPrefix() {
        return "LogEvent";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "level";
            }
            case 1: {
                return "msg";
            }
            case 2: {
                return "additional";
            }
            case 3: {
                return "data";
            }
            case 4: {
                return "pkg";
            }
            case 5: {
                return "fileName";
            }
            case 6: {
                return "name";
            }
            case 7: {
                return "line";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Level level() {
        return this.level;
    }

    public Function0<String> msg() {
        return this.msg;
    }

    public LazyList<Either<String, Throwable>> additional() {
        return this.additional;
    }

    public LazyMap<String, Json> data() {
        return this.data;
    }

    public Pkg pkg() {
        return this.pkg;
    }

    public FileName fileName() {
        return this.fileName;
    }

    public Name name() {
        return this.name;
    }

    public Line line() {
        return this.line;
    }

    public String asString() {
        return new StringBuilder(6).append(this.level().name()).append(" ").append(this.name().value()).append("/").append(this.fileName()).append(":").append(this.line().value()).append(" - ").append(this.msg().apply()).toString();
    }

    public <A> LogEvent data(String key, Function0<A> value, Encoder<A> evidence$1) {
        LazyMap<String, Json> lazyMap = this.data().updated(key, (Function0<Json>)((Function0 & Serializable)() -> LogEvent.$anonfun$1(evidence$1, value)));
        Level level = this.copy$default$1();
        Function0<String> function0 = this.copy$default$2();
        LazyList<Either<String, Throwable>> lazyList = this.copy$default$3();
        Pkg pkg = this.copy$default$5();
        FileName fileName = this.copy$default$6();
        Name name = this.copy$default$7();
        Line line = this.copy$default$8();
        return this.copy(level, function0, lazyList, lazyMap, pkg, fileName, name, line);
    }

    public LogEvent addData(Map<String, Json> m) {
        LazyMap<String, Json> lazyMap = this.data().addMap(m);
        Level level = this.copy$default$1();
        Function0<String> function0 = this.copy$default$2();
        LazyList<Either<String, Throwable>> lazyList = this.copy$default$3();
        Pkg pkg = this.copy$default$5();
        FileName fileName = this.copy$default$6();
        Name name = this.copy$default$7();
        Line line = this.copy$default$8();
        return this.copy(level, function0, lazyList, lazyMap, pkg, fileName, name, line);
    }

    public LogEvent addMessage(Function0<String> msg) {
        Function0 function0 = LazyList$.MODULE$.toDeferrer(this::$anonfun$2);
        LazyList lazyList = LazyList.Deferrer$.MODULE$.$hash$colon$colon$extension(function0, () -> LogEvent.$anonfun$3(msg));
        Level level = this.copy$default$1();
        Function0<String> function02 = this.copy$default$2();
        LazyMap<String, Json> lazyMap = this.copy$default$4();
        Pkg pkg = this.copy$default$5();
        FileName fileName = this.copy$default$6();
        Name name = this.copy$default$7();
        Line line = this.copy$default$8();
        return this.copy(level, function02, (LazyList<Either<String, Throwable>>)lazyList, lazyMap, pkg, fileName, name, line);
    }

    public LogEvent addError(Throwable ex) {
        Function0 function0 = LazyList$.MODULE$.toDeferrer(this::$anonfun$4);
        LazyList lazyList = LazyList.Deferrer$.MODULE$.$hash$colon$colon$extension(function0, () -> LogEvent.$anonfun$5(ex));
        Level level = this.copy$default$1();
        Function0<String> function02 = this.copy$default$2();
        LazyMap<String, Json> lazyMap = this.copy$default$4();
        Pkg pkg = this.copy$default$5();
        FileName fileName = this.copy$default$6();
        Name name = this.copy$default$7();
        Line line = this.copy$default$8();
        return this.copy(level, function02, (LazyList<Either<String, Throwable>>)lazyList, lazyMap, pkg, fileName, name, line);
    }

    public List<Throwable> findErrors() {
        return this.additional().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Throwable ex = (Throwable)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Throwable ex = (Throwable)((Right)either).value();
                    return ex;
                }
                return function1.apply((Object)x);
            }
        }).toList();
    }

    public LogEvent copy(Level level, Function0<String> msg, LazyList<Either<String, Throwable>> additional, LazyMap<String, Json> data, Pkg pkg, FileName fileName, Name name, Line line) {
        return new LogEvent(level, msg, additional, data, pkg, fileName, name, line);
    }

    public Level copy$default$1() {
        return this.level();
    }

    public Function0<String> copy$default$2() {
        return this.msg();
    }

    public LazyList<Either<String, Throwable>> copy$default$3() {
        return this.additional();
    }

    public LazyMap<String, Json> copy$default$4() {
        return this.data();
    }

    public Pkg copy$default$5() {
        return this.pkg();
    }

    public FileName copy$default$6() {
        return this.fileName();
    }

    public Name copy$default$7() {
        return this.name();
    }

    public Line copy$default$8() {
        return this.line();
    }

    public Level _1() {
        return this.level();
    }

    public Function0<String> _2() {
        return this.msg();
    }

    public LazyList<Either<String, Throwable>> _3() {
        return this.additional();
    }

    public LazyMap<String, Json> _4() {
        return this.data();
    }

    public Pkg _5() {
        return this.pkg();
    }

    public FileName _6() {
        return this.fileName();
    }

    public Name _7() {
        return this.name();
    }

    public Line _8() {
        return this.line();
    }

    private static final Json $anonfun$1(Encoder evidence$1$1, Function0 value$1) {
        return Encoder$.MODULE$.apply(evidence$1$1).apply(value$1.apply());
    }

    private final LazyList $anonfun$2() {
        return this.additional();
    }

    private static final Either $anonfun$3(Function0 msg$5) {
        return package$.MODULE$.Left().apply(msg$5.apply());
    }

    private final LazyList $anonfun$4() {
        return this.additional();
    }

    private static final Either $anonfun$5(Throwable ex$1) {
        return package$.MODULE$.Right().apply((Object)ex$1);
    }
}

