/*
 * Decompiled with CFR 0.152.
 */
package binny.util;

import binny.ByteRange;
import binny.ByteRange$All$;
import binny.ByteRange$Chunk$;
import binny.util.RangeCalc;
import binny.util.RangeCalc$Offsets$;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class RangeCalc$
implements Serializable {
    public static final RangeCalc$Offsets$ Offsets;
    public static final RangeCalc$ MODULE$;

    private RangeCalc$() {
    }

    static {
        MODULE$ = new RangeCalc$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RangeCalc$.class);
    }

    public RangeCalc.Offsets calcOffset(ByteRange range, int chunkSize) {
        ByteRange byteRange = range;
        if (ByteRange$All$.MODULE$.equals(byteRange)) {
            return RangeCalc$Offsets$.MODULE$.none();
        }
        if (byteRange instanceof ByteRange.Chunk) {
            ByteRange.Chunk chunk = ByteRange$Chunk$.MODULE$.unapply((ByteRange.Chunk)byteRange);
            long l = chunk._1();
            int n = chunk._2();
            long offset = l;
            int length = n;
            int firstChunk = (int)(offset / (long)chunkSize);
            int lastChunk = (int)((offset + (long)length) / (long)chunkSize);
            int startOffset = (int)(offset % (long)chunkSize);
            int endOffset = (int)((offset + (long)length) % (long)chunkSize) - (firstChunk == lastChunk ? startOffset : 0);
            int nChunk = lastChunk - firstChunk + (startOffset == 0 && endOffset == 0 ? 0 : 1);
            return RangeCalc$Offsets$.MODULE$.apply(firstChunk, nChunk, startOffset, endOffset);
        }
        throw new MatchError((Object)byteRange);
    }

    public Chunk<Object> chop(Chunk<Object> ch, RangeCalc.Offsets offsets, int index) {
        Tuple2<Option<Object>, Option<Object>> tuple2 = this.chopOffsets(offsets, index);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                int n;
                int start = n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (option2 instanceof Some) {
                    int end = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return ch.drop(start).take(end);
                }
                int start2 = n;
                if (None$.MODULE$.equals(option2)) {
                    return ch.drop(start2);
                }
            }
            if (None$.MODULE$.equals(option)) {
                if (option2 instanceof Some) {
                    int end = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return ch.take(end);
                }
                if (None$.MODULE$.equals(option2)) {
                    return ch;
                }
            }
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Option<Object>, Option<Object>> chopOffsets(RangeCalc.Offsets offsets, int chunkIndex) {
        None$ end = chunkIndex == offsets.lastChunk() && offsets.takeEnd() > 0 ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offsets.takeEnd())) : None$.MODULE$;
        None$ start = chunkIndex == offsets.firstChunk() && offsets.dropStart() > 0 ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offsets.dropStart())) : None$.MODULE$;
        Option option = (Option)Predef$.MODULE$.ArrowAssoc((Object)start);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option, (Object)end);
    }

    public Stream<Nothing$, ByteRange.Chunk> calcChunks(ByteRange range, int chunkSize) {
        ByteRange byteRange = range;
        if (ByteRange$All$.MODULE$.equals(byteRange)) {
            return this.go$1(chunkSize, 0);
        }
        if (byteRange instanceof ByteRange.Chunk) {
            ByteRange.Chunk chunk = ByteRange$Chunk$.MODULE$.unapply((ByteRange.Chunk)byteRange);
            long l = chunk._1();
            int n = chunk._2();
            long off = l;
            int len = n;
            int rest = len % chunkSize;
            int count = len / chunkSize;
            Stream stream = this.go$1(chunkSize, (int)off).take(Int$.MODULE$.int2long(count));
            if (rest == 0) {
                return stream;
            }
            return stream.$plus$plus(() -> this.calcChunks$$anonfun$1(chunkSize, off, rest, count));
        }
        throw new MatchError((Object)byteRange);
    }

    private final Stream go$1$$anonfun$1(int chunkSize$2, int start$1) {
        return this.go$1(chunkSize$2, start$1 + chunkSize$2).repeat();
    }

    private final Stream go$1(int chunkSize$1, int start) {
        return Stream$.MODULE$.emit((Object)ByteRange$Chunk$.MODULE$.apply(Int$.MODULE$.int2long(start), chunkSize$1)).$plus$plus(() -> this.go$1$$anonfun$1(chunkSize$1, start));
    }

    private final Stream calcChunks$$anonfun$1(int chunkSize$3, long off$1, int rest$1, int count$1) {
        return Stream$.MODULE$.emit((Object)ByteRange$Chunk$.MODULE$.apply(off$1 + (long)(count$1 * chunkSize$3), rest$1));
    }
}

