/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.WaitQueueTimeoutException$;
import org.http4s.headers.Idempotency$minusKey$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RetryPolicy$
implements Serializable {
    private static final Set RetriableStatuses;
    public static final RetryPolicy$ MODULE$;

    private RetryPolicy$() {
    }

    static {
        MODULE$ = new RetryPolicy$();
        RetriableStatuses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Status[]{Status$.MODULE$.RequestTimeout(), Status$.MODULE$.InternalServerError(), Status$.MODULE$.ServiceUnavailable(), Status$.MODULE$.BadGateway(), Status$.MODULE$.GatewayTimeout()}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RetryPolicy$.class);
    }

    public <F> Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> apply(Function1<Object, Option<FiniteDuration>> backoff, Function2<Request<F>, Either<Throwable, Response<F>>, Object> retriable) {
        return (Function3 & Serializable)(req, result, retries) -> this.apply$$anonfun$1(retriable, backoff, (Request)req, (Either)result, BoxesRunTime.unboxToInt((Object)retries));
    }

    public <F> Function2<Request<F>, Either<Throwable, Response<F>>, Object> apply$default$2() {
        return (Function2 & Serializable)(req, result) -> this.defaultRetriable((Request)req, (Either)result);
    }

    public Set<Status> RetriableStatuses() {
        return RetriableStatuses;
    }

    public <F> boolean defaultRetriable(Request<F> req, Either<Throwable, Response<F>> result) {
        return (req.method().isIdempotent() || Headers$.MODULE$.contains$extension(req.headers(), Idempotency$minusKey$.MODULE$.headerInstance())) && this.isErrorOrRetriableStatus(result);
    }

    public <F> boolean recklesslyRetriable(Either<Throwable, Response<F>> result) {
        return this.isErrorOrRetriableStatus(result);
    }

    public <F> boolean isErrorOrRetriableStatus(Either<Throwable, Response<F>> result) {
        return this.isErrorOrStatus(result, this.RetriableStatuses());
    }

    public <F> boolean isErrorOrStatus(Either<Throwable, Response<F>> result, Set<Status> status) {
        Either<Throwable, Response<F>> either = result;
        if (either instanceof Right) {
            Response resp = (Response)((Right)either).value();
            return status.apply((Object)resp.status());
        }
        return !(either instanceof Left) || !WaitQueueTimeoutException$.MODULE$.equals(((Left)either).value());
    }

    public Function1<Object, Option<FiniteDuration>> exponentialBackoff(Duration maxWait, int maxRetry) {
        long maxInMillis = maxWait.toMillis();
        return (Function1 & Serializable)k -> this.exponentialBackoff$$anonfun$1(maxRetry, maxInMillis, BoxesRunTime.unboxToInt((Object)k));
    }

    private FiniteDuration expBackoff(int k, long maxInMillis) {
        double millis = (package$.MODULE$.pow(2.0, (double)k) - 1.0) * 1000.0;
        double interval = package$.MODULE$.min(millis, (double)maxInMillis);
        return FiniteDuration$.MODULE$.apply((long)(package$.MODULE$.random() * interval), scala.concurrent.duration.package$.MODULE$.MILLISECONDS());
    }

    private final /* synthetic */ Option apply$$anonfun$1(Function2 retriable$1, Function1 backoff$1, Request req, Either result, int retries) {
        if (BoxesRunTime.unboxToBoolean((Object)retriable$1.apply((Object)req, (Object)result))) {
            return (Option)backoff$1.apply((Object)BoxesRunTime.boxToInteger((int)retries));
        }
        return None$.MODULE$;
    }

    private final /* synthetic */ Option exponentialBackoff$$anonfun$1(int maxRetry$1, long maxInMillis$1, int k) {
        if (k > maxRetry$1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)this.expBackoff(k, maxInMillis$1));
    }
}

