/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Applicative;
import cats.ApplicativeError;
import cats.UnorderedFoldable;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.SyncIO;
import cats.effect.kernel.GenConcurrent;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.UnorderedFoldableOps$;
import cats.syntax.package;
import fs2.Chunk$;
import fs2.CollectorK;
import fs2.CollectorK$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.Entity;
import org.http4s.EntityEncoder;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.Media;
import org.http4s.Message$;
import org.http4s.Message$EntityStreamException$;
import org.http4s.Message$Keys$;
import org.http4s.TransferCoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.package$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Key;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;

public interface Message<F>
extends Media<F> {
    public static SelfAwareStructuredLogger<SyncIO> logger() {
        return Message$.MODULE$.logger();
    }

    public HttpVersion httpVersion();

    @Override
    public List headers();

    @Override
    public Stream<F, Object> body();

    public Vault attributes();

    public Message change(HttpVersion var1, Stream<F, Object> var2, List var3, Vault var4);

    public static HttpVersion change$default$1$(Message $this) {
        return $this.change$default$1();
    }

    default public HttpVersion change$default$1() {
        return this.httpVersion();
    }

    public static Stream change$default$2$(Message $this) {
        return $this.change$default$2();
    }

    default public Stream<F, Object> change$default$2() {
        return this.body();
    }

    public static List change$default$3$(Message $this) {
        return $this.change$default$3();
    }

    default public List change$default$3() {
        return this.headers();
    }

    public static Vault change$default$4$(Message $this) {
        return $this.change$default$4();
    }

    default public Vault change$default$4() {
        return this.attributes();
    }

    public static Message withHttpVersion$(Message $this, HttpVersion httpVersion) {
        return $this.withHttpVersion(httpVersion);
    }

    default public Message withHttpVersion(HttpVersion httpVersion) {
        return this.change(httpVersion, this.change$default$2(), this.change$default$3(), this.change$default$4());
    }

    public static Message withHeaders$(Message $this, List headers) {
        return $this.withHeaders(headers);
    }

    default public Message withHeaders(List headers) {
        return this.change(this.change$default$1(), this.change$default$2(), headers, this.change$default$4());
    }

    public static Message withHeaders$(Message $this, Seq headers) {
        return $this.withHeaders((Seq<Header.ToRaw>)headers);
    }

    default public Message withHeaders(Seq<Header.ToRaw> headers) {
        return this.withHeaders(Headers$.MODULE$.apply(headers));
    }

    public static Message withAttributes$(Message $this, Vault attributes) {
        return $this.withAttributes(attributes);
    }

    default public Message withAttributes(Vault attributes) {
        return this.change(this.change$default$1(), this.change$default$2(), this.change$default$3(), attributes);
    }

    public static Message withEntity$(Message $this, Object b, EntityEncoder w) {
        return $this.withEntity(b, w);
    }

    default public <T> Message withEntity(T b, EntityEncoder<F, T> w) {
        None$ none$;
        Entity<F> entity = w.toEntity(b);
        List hsBase = Headers$.MODULE$.$plus$plus$extension(this.headers(), w.headers());
        Option<Object> option = entity.length();
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            none$ = (Option)Content$minusLength$.MODULE$.fromLong(l).fold((Function1 & Serializable)_$4 -> {
                ((SyncIO)Message$.MODULE$.logger().warn(() -> Message.$anonfun$1$$anonfun$1(l))).unsafeRunSync();
                return None$.MODULE$;
            }, (Function1 & Serializable)_$5 -> Some$.MODULE$.apply(_$5));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        None$ cl = none$;
        Object object = cl.fold((Function0 & Serializable)() -> new Headers((List<Header.Raw>)Message.$anonfun$3(hsBase)), (Function1 & Serializable)contentLength -> new Headers((List<Header.Raw>)Headers$.MODULE$.withContentLength$extension(hsBase, contentLength)));
        List<Header.Raw> list = object == null ? null : ((Headers)object).headers();
        HttpVersion httpVersion = this.change$default$1();
        Vault vault = this.change$default$4();
        return this.change(httpVersion, entity.body(), list, vault);
    }

    public static Message withBodyStream$(Message $this, Stream body) {
        return $this.withBodyStream(body);
    }

    default public Message withBodyStream(Stream<F, Object> body) {
        return this.change(this.change$default$1(), body, this.change$default$3(), this.change$default$4());
    }

    public static Message withEmptyBody$(Message $this) {
        return $this.withEmptyBody();
    }

    default public Message withEmptyBody() {
        return this.withBodyStream(package$.MODULE$.EmptyBody()).transformHeaders((Function1<List, List>)(Function1 & Serializable)v1 -> new Headers((List<Header.Raw>)Headers$.MODULE$.removePayloadHeaders$extension(v1 == null ? null : ((Headers)v1).headers())));
    }

    public static Message pipeBodyThrough$(Message $this, Function1 pipe) {
        return $this.pipeBodyThrough(pipe);
    }

    default public Message pipeBodyThrough(Function1<Stream<F, Object>, Stream<F, Object>> pipe) {
        return this.withBodyStream((Stream)pipe.apply(this.body()));
    }

    public static Message transformHeaders$(Message $this, Function1 f) {
        return $this.transformHeaders((Function1<List, List>)f);
    }

    default public Message transformHeaders(Function1<List, List> f) {
        Object object = f.apply((Object)new Headers((List<Header.Raw>)this.headers()));
        List<Header.Raw> list = object == null ? null : ((Headers)object).headers();
        HttpVersion httpVersion = this.change$default$1();
        Stream<F, Object> stream = this.change$default$2();
        Vault vault = this.change$default$4();
        return this.change(httpVersion, stream, list, vault);
    }

    public static Message filterHeaders$(Message $this, Function1 f) {
        return $this.filterHeaders((Function1<Header.Raw, Object>)f);
    }

    default public Message filterHeaders(Function1<Header.Raw, Object> f) {
        return this.transformHeaders((Function1<List, List>)(Function1 & Serializable)v1 -> new Headers((List<Header.Raw>)Headers$.MODULE$.transform$extension(v1 == null ? null : ((Headers)v1).headers(), (Function1<List<Header.Raw>, List<Header.Raw>>)(Function1 & Serializable)_$8 -> _$8.filter(f$1))));
    }

    public static Message removeHeader$(Message $this, CIString key) {
        return $this.removeHeader(key);
    }

    default public Message removeHeader(CIString key) {
        return this.transformHeaders((Function1<List, List>)(Function1 & Serializable)v1 -> new Headers((List<Header.Raw>)Headers$.MODULE$.transform$extension(v1 == null ? null : ((Headers)v1).headers(), (Function1<List<Header.Raw>, List<Header.Raw>>)(Function1 & Serializable)_$10 -> _$10.filterNot((Function1 & Serializable)_$11 -> {
            CIString cIString = _$11.name();
            CIString cIString2 = key$1;
            return !(cIString != null ? !cIString.equals(cIString2) : cIString2 != null);
        }))));
    }

    public static Message removeHeader$(Message $this, Header h) {
        return $this.removeHeader(h);
    }

    default public <A> Message removeHeader(Header<A, ?> h) {
        return this.removeHeader(h.name());
    }

    public static Message putHeaders$(Message $this, Seq headers) {
        return $this.putHeaders((Seq<Header.ToRaw>)headers);
    }

    default public Message putHeaders(Seq<Header.ToRaw> headers) {
        return this.transformHeaders((Function1<List, List>)(Function1 & Serializable)v1 -> new Headers((List<Header.Raw>)Headers$.MODULE$.put$extension(v1 == null ? null : ((Headers)v1).headers(), (Seq<Header.ToRaw>)headers)));
    }

    public static Message addHeader$(Message $this, Object h, Header evidence$1) {
        return $this.addHeader(h, evidence$1);
    }

    default public <H> Message addHeader(H h, Header<H, Header.Recurring> evidence$1) {
        return this.transformHeaders((Function1<List, List>)(Function1 & Serializable)v1 -> new Headers((List<Header.Raw>)Headers$.MODULE$.add$extension(v1 == null ? null : ((Headers)v1).headers(), h, evidence$1)));
    }

    public static Message withTrailerHeaders$(Message $this, Object trailerHeaders) {
        return $this.withTrailerHeaders(trailerHeaders);
    }

    default public Message withTrailerHeaders(F trailerHeaders) {
        return this.withAttribute(Message$Keys$.MODULE$.TrailerHeaders(), trailerHeaders);
    }

    public static Message withoutTrailerHeaders$(Message $this) {
        return $this.withoutTrailerHeaders();
    }

    default public Message withoutTrailerHeaders() {
        return this.withoutAttribute(Message$Keys$.MODULE$.TrailerHeaders());
    }

    public static Object trailerHeaders$(Message $this, Applicative F) {
        return $this.trailerHeaders(F);
    }

    default public F trailerHeaders(Applicative<F> F) {
        return (F)this.attributes().lookup(Message$Keys$.MODULE$.TrailerHeaders()).getOrElse(() -> Message.trailerHeaders$$anonfun$1(F));
    }

    public static Message withContentType$(Message $this, Content$minusType contentType) {
        return $this.withContentType(contentType);
    }

    default public Message withContentType(Content$minusType contentType) {
        return this.putHeaders((Seq<Header.ToRaw>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(contentType, Content$minusType$.MODULE$.headerInstance())}));
    }

    public static Message withoutContentType$(Message $this) {
        return $this.withoutContentType();
    }

    default public Message withoutContentType() {
        return this.removeHeader(Content$minusType$.MODULE$.headerInstance());
    }

    public static Message withContentTypeOption$(Message $this, Option contentTypeO) {
        return $this.withContentTypeOption((Option<Content$minusType>)contentTypeO);
    }

    default public Message withContentTypeOption(Option<Content$minusType> contentTypeO) {
        return (Message)contentTypeO.fold(this::withContentTypeOption$$anonfun$1, (Function1 & Serializable)contentType -> this.withContentType((Content$minusType)contentType));
    }

    public static boolean isChunked$(Message $this) {
        return $this.isChunked();
    }

    default public boolean isChunked() {
        return Headers$.MODULE$.get$extension(this.headers(), Header$Select$.MODULE$.recurringHeadersWithMerge(Transfer$minusEncoding$.MODULE$.headerSemigroupInstance(), Transfer$minusEncoding$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$15 -> {
            NonEmptyList nonEmptyList = (NonEmptyList)package.all$.MODULE$.catsSyntaxUnorderedFoldableOps(_$15.values(), (UnorderedFoldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyListBinCompat1());
            return UnorderedFoldableOps$.MODULE$.contains_$extension((Object)nonEmptyList, (Object)TransferCoding$.MODULE$.chunked(), TransferCoding$.MODULE$.http4sOrderForTransferCoding(), (UnorderedFoldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyListBinCompat1());
        });
    }

    public static Message withAttribute$(Message $this, Key key, Object value) {
        return $this.withAttribute(key, value);
    }

    default public <A> Message withAttribute(Key<A> key, A value) {
        Vault vault = this.attributes().insert(key, value);
        HttpVersion httpVersion = this.change$default$1();
        Stream<F, Object> stream = this.change$default$2();
        List list = this.change$default$3();
        return this.change(httpVersion, stream, list, vault);
    }

    public static Message withoutAttribute$(Message $this, Key key) {
        return $this.withoutAttribute(key);
    }

    default public Message withoutAttribute(Key<?> key) {
        Vault vault = this.attributes().delete(key);
        HttpVersion httpVersion = this.change$default$1();
        Stream<F, Object> stream = this.change$default$2();
        List list = this.change$default$3();
        return this.change(httpVersion, stream, list, vault);
    }

    public static Message covary$(Message $this) {
        return $this.covary();
    }

    default public <F2> Message covary() {
        return this;
    }

    public static Object toStrict$(Message $this, Option maxBytes, GenConcurrent F) {
        return $this.toStrict((Option<Object>)maxBytes, F);
    }

    default public F toStrict(Option<Object> maxBytes, GenConcurrent<F, Throwable> F) {
        return (F)package.all$.MODULE$.toFunctorOps(Message.withLimit$1(maxBytes, F, this.body()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(F))).to(CollectorK$.MODULE$.toCollector((CollectorK)Chunk$.MODULE$)), F).map((Function1 & Serializable)chunk -> this.withBodyStream(Stream$.MODULE$.chunk(chunk)).transformHeaders((Function1<List, List>)(Function1 & Serializable)v1 -> new Headers((List<Header.Raw>)Headers$.MODULE$.withContentLength$extension(v1 == null ? null : ((Headers)v1).headers(), Content$minusLength$.MODULE$.unsafeFromLong(chunk.size())))));
    }

    private static String $anonfun$1$$anonfun$1(long l$2) {
        return new StringBuilder(48).append("Attempt to provide a negative content length of ").append(l$2).toString();
    }

    private static List $anonfun$3(List hsBase$1) {
        return hsBase$1;
    }

    private static Object trailerHeaders$$anonfun$1(Applicative F$3) {
        Headers headers = (Headers)package.all$.MODULE$.catsSyntaxApplicativeId((Object)new Headers((List<Header.Raw>)Headers$.MODULE$.empty()));
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)headers, F$3);
    }

    private Message withContentTypeOption$$anonfun$1() {
        return this.withoutContentType();
    }

    private static Stream withLimit$1(Option maxBytes$1, GenConcurrent F$4, Stream entityBody) {
        Option option = maxBytes$1;
        if (option instanceof Some) {
            long limit = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            Stream stream = Stream$.MODULE$.InvariantOps(entityBody);
            Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            Pull pull = Pull$.MODULE$.StreamPullOps(Stream.ToPull$.MODULE$.take$extension(stream2, limit).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    return Pull$.MODULE$.raiseError((Throwable)Message$EntityStreamException$.MODULE$.createWithDefaultMsg(limit), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$4));
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.done();
                }
                throw new MatchError((Object)option);
            }));
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
        }
        if (None$.MODULE$.equals(option)) {
            return entityBody;
        }
        throw new MatchError((Object)option);
    }

    public static final class EntityStreamException
    extends Exception
    implements NoStackTrace,
    Product {
        private final String msg;

        public static EntityStreamException apply(String string) {
            return Message$EntityStreamException$.MODULE$.apply(string);
        }

        public static EntityStreamException createWithDefaultMsg(long l) {
            return Message$EntityStreamException$.MODULE$.createWithDefaultMsg(l);
        }

        public static EntityStreamException fromProduct(Product product) {
            return Message$EntityStreamException$.MODULE$.fromProduct(product);
        }

        public static EntityStreamException unapply(EntityStreamException entityStreamException) {
            return Message$EntityStreamException$.MODULE$.unapply(entityStreamException);
        }

        public EntityStreamException(String msg) {
            this.msg = msg;
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EntityStreamException)) return false;
            EntityStreamException entityStreamException = (EntityStreamException)object;
            String string = this.msg();
            String string2 = entityStreamException.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof EntityStreamException;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EntityStreamException";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public EntityStreamException copy(String msg) {
            return new EntityStreamException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }
}

