/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Applicative;
import cats.Monad;
import cats.arrow.FunctionK;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import com.comcast.ip4s.Dns;
import com.comcast.ip4s.Hostname$;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.IpAddressPlatform;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import fs2.Stream;
import java.io.File;
import java.io.Serializable;
import org.http4s.Charset;
import org.http4s.Charset$;
import org.http4s.EntityDecoder;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.Message;
import org.http4s.Method;
import org.http4s.Request$;
import org.http4s.Request$Connection$;
import org.http4s.Request$Keys$;
import org.http4s.RequestCookie;
import org.http4s.RequestCookie$;
import org.http4s.RequestPrelude;
import org.http4s.RequestPrelude$;
import org.http4s.Response;
import org.http4s.ServerSoftware;
import org.http4s.ServerSoftware$;
import org.http4s.Uri;
import org.http4s.Uri$Path$;
import org.http4s.headers.Authorization$;
import org.http4s.headers.Cookie;
import org.http4s.headers.Cookie$;
import org.http4s.headers.Host$;
import org.http4s.headers.Idempotency$minusKey$;
import org.http4s.headers.X$minusForwarded$minusFor$;
import org.http4s.internal.CurlConverter$;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Vault;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple6;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class Request<F>
implements Message<F>,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Request.class.getDeclaredField("$1$$lzy1"));
    private final Method method;
    private final Uri uri;
    private final HttpVersion httpVersion;
    private final List headers;
    private final Stream body;
    private final Vault attributes;
    private volatile Object $1$$lzy1;

    public static <F> Request<F> apply(Method method, Uri uri, HttpVersion httpVersion, List list, Stream<F, Object> stream, Vault vault) {
        return Request$.MODULE$.apply(method, uri, httpVersion, list, stream, vault);
    }

    public static <F> Option<Tuple6<Method, Uri, HttpVersion, List, Stream<F, Object>, Vault>> unapply(Request<F> request) {
        return Request$.MODULE$.unapply(request);
    }

    public static <F> Method apply$default$1() {
        return Request$.MODULE$.apply$default$1();
    }

    public static <F> Uri apply$default$2() {
        return Request$.MODULE$.apply$default$2();
    }

    public static <F> HttpVersion apply$default$3() {
        return Request$.MODULE$.apply$default$3();
    }

    public static <F> List apply$default$4() {
        return Request$.MODULE$.apply$default$4();
    }

    public static <F> Stream<Nothing$, Object> apply$default$5() {
        return Request$.MODULE$.apply$default$5();
    }

    public static <F> Vault apply$default$6() {
        return Request$.MODULE$.apply$default$6();
    }

    public Request(Method method, Uri uri, HttpVersion httpVersion, List headers, Stream<F, Object> body, Vault attributes) {
        this.method = method;
        this.uri = uri;
        this.httpVersion = httpVersion;
        this.headers = headers;
        this.body = body;
        this.attributes = attributes;
    }

    public Method method() {
        return this.method;
    }

    public Uri uri() {
        return this.uri;
    }

    @Override
    public HttpVersion httpVersion() {
        return this.httpVersion;
    }

    @Override
    public List headers() {
        return this.headers;
    }

    @Override
    public Stream<F, Object> body() {
        return this.body;
    }

    @Override
    public Vault attributes() {
        return this.attributes;
    }

    private Request<F> copy(Method method, Uri uri, HttpVersion httpVersion, List headers, Stream<F, Object> body, Vault attributes) {
        return Request$.MODULE$.apply(method, uri, httpVersion, headers, body, attributes);
    }

    private Method copy$default$1() {
        return this.method();
    }

    private Uri copy$default$2() {
        return this.uri();
    }

    private HttpVersion copy$default$3() {
        return this.httpVersion();
    }

    private List copy$default$4() {
        return this.headers();
    }

    private Stream<F, Object> copy$default$5() {
        return this.body();
    }

    private Vault copy$default$6() {
        return this.attributes();
    }

    public <G> Request<G> mapK(FunctionK<F, G> f) {
        return Request$.MODULE$.apply(this.method(), this.uri(), this.httpVersion(), this.headers(), this.body().translate(f), this.attributes());
    }

    public Request<F> withMethod(Method method) {
        return this.copy(method, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Request<F> withUri(Uri uri) {
        Vault vault = this.attributes().delete(Request$Keys$.MODULE$.PathInfoCaret());
        Method method = this.copy$default$1();
        HttpVersion httpVersion = this.copy$default$3();
        List list = this.copy$default$4();
        Stream<F, Object> stream = this.copy$default$5();
        return this.copy(method, uri, httpVersion, list, stream, vault);
    }

    @Override
    public Request<F> change(HttpVersion httpVersion, Stream<F, Object> body, List headers, Vault attributes) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), httpVersion, headers, body, attributes);
    }

    private Tuple2<Uri.Path, Uri.Path> $1$() {
        Object object = this.$1$$lzy1;
        if (object instanceof Tuple2) {
            return (Tuple2)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Tuple2)this.$1$$lzyINIT1();
    }

    private Object $1$$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.$1$$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Tuple2 tuple2 = null;
                    try {
                        Tuple2<Uri.Path, Uri.Path> tuple22 = this.uri().path().splitAt(this.caret());
                        if (tuple22 == null) {
                            throw new MatchError(tuple22);
                        }
                        Uri.Path l = (Uri.Path)tuple22._1();
                        Uri.Path r = (Uri.Path)tuple22._2();
                        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)l, (Object)r);
                        Uri.Path l2 = (Uri.Path)tuple23._1();
                        Uri.Path r2 = (Uri.Path)tuple23._2();
                        tuple2 = Tuple2$.MODULE$.apply((Object)l2.toAbsolute(), (Object)r2.toAbsolute());
                        object2 = tuple2 == null ? LazyVals.NullValue$.MODULE$ : tuple2;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.$1$$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.$1$$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return tuple2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Uri.Path scriptName() {
        return (Uri.Path)this.$1$()._1();
    }

    public Uri.Path pathInfo() {
        return (Uri.Path)this.$1$()._2();
    }

    private int caret() {
        return BoxesRunTime.unboxToInt((Object)this.attributes().lookup(Request$Keys$.MODULE$.PathInfoCaret()).getOrElse(Request::caret$$anonfun$1));
    }

    public Request<F> withPathInfo(String pi) {
        return this.withPathInfo(Uri$Path$.MODULE$.unsafeFromString(pi));
    }

    public Request<F> withPathInfo(Uri.Path pi) {
        Uri uri = this.uri().withPath(this.scriptName().concat(pi));
        Method method = this.copy$default$1();
        HttpVersion httpVersion = this.copy$default$3();
        List list = this.copy$default$4();
        Stream<F, Object> stream = this.copy$default$5();
        Vault vault = this.copy$default$6();
        return this.copy(method, uri, httpVersion, list, stream, vault);
    }

    public Option<File> pathTranslated() {
        return this.attributes().lookup(Request$Keys$.MODULE$.PathTranslated());
    }

    public String queryString() {
        return this.uri().query().renderString();
    }

    public String asCurl(Function1<CIString, Object> redactHeadersWhen) {
        return CurlConverter$.MODULE$.requestToCurlWithoutBody(this, redactHeadersWhen);
    }

    public Function1<CIString, Object> asCurl$default$1() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public F asCurlWithBody(Function1<CIString, Object> redactHeadersWhen, GenConcurrent<F, Throwable> concurrent, Charset defaultCharset) {
        return (F)CurlConverter$.MODULE$.requestToCurlWithBody(this, redactHeadersWhen, concurrent, defaultCharset);
    }

    public Function1<CIString, Object> asCurlWithBody$default$1() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public Charset asCurlWithBody$default$3(Function1<CIString, Object> redactHeadersWhen) {
        return Charset$.MODULE$.UTF$minus8();
    }

    public Map<String, Seq<String>> multiParams() {
        return this.uri().multiParams();
    }

    public Map<String, String> params() {
        return this.uri().params();
    }

    public List<RequestCookie> cookies() {
        return (List)Headers$.MODULE$.get$extension(this.headers(), Header$Select$.MODULE$.recurringHeadersWithMerge(Cookie$.MODULE$.headerSemigroupInstance(), Cookie$.MODULE$.headerInstance())).fold(Request::cookies$$anonfun$1, (Function1 & Serializable)_$21 -> _$21.values().toList());
    }

    public Request<F> addCookie(RequestCookie cookie) {
        return (Request)this.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(Headers$.MODULE$.get$extension(this.headers(), Header$Select$.MODULE$.recurringHeadersWithMerge(Cookie$.MODULE$.headerSemigroupInstance(), Cookie$.MODULE$.headerInstance())).fold(() -> Request.addCookie$$anonfun$1(cookie), (Function1 & Serializable)preExistingCookie -> Cookie$.MODULE$.apply((NonEmptyList<RequestCookie>)preExistingCookie.values().append((Object)cookie))), Cookie$.MODULE$.headerInstance())}));
    }

    public Request<F> addCookie(String name, String content) {
        return this.addCookie(RequestCookie$.MODULE$.apply(name, content));
    }

    public Option<CIString> authType() {
        return Headers$.MODULE$.get$extension(this.headers(), Header$Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance())).map((Function1 & Serializable)_$22 -> _$22.credentials().authScheme());
    }

    private Option<Connection> connectionInfo() {
        return this.attributes().lookup(Request$Keys$.MODULE$.ConnectionInfo());
    }

    public Option<SocketAddress<IpAddress>> remote() {
        return this.connectionInfo().map((Function1 & Serializable)_$23 -> _$23.remote());
    }

    public Option<IpAddress> from() {
        return (Option)Headers$.MODULE$.get$extension(this.headers(), Header$Select$.MODULE$.singleHeaders(X$minusForwarded$minusFor$.MODULE$.headerInstance())).fold(this::from$$anonfun$1, (Function1 & Serializable)_$25 -> (Option)_$25.values().head());
    }

    public Option<IpAddress> remoteAddr() {
        return this.remote().map((Function1 & Serializable)_$26 -> (IpAddress)_$26.host());
    }

    public F remoteHost(Sync<F> F) {
        Option inetAddress = this.remote().map((Function1 & Serializable)_$27 -> ((IpAddressPlatform)_$27.host()).toInetAddress());
        return (F)F.map(F.blocking(() -> Request.remoteHost$$anonfun$1(inetAddress)), (Function1 & Serializable)_$29 -> _$29.flatMap((Function1 & Serializable)value -> Hostname$.MODULE$.fromString(value)));
    }

    public F remoteHost(Monad<F> F, Dns<F> dns) {
        boolean bl = OptionT$.MODULE$.fromOption();
        return (F)OptionT.FromOptionPartiallyApplied$.MODULE$.apply$extension(bl, this.remote().map((Function1 & Serializable)_$30 -> (IpAddress)_$30.host()), F).flatMapF((Function1 & Serializable)address -> dns.reverseOption(address), F).value();
    }

    public Option<Port> remotePort() {
        return this.remote().map((Function1 & Serializable)_$31 -> _$31.port());
    }

    public Option<String> remoteUser() {
        return None$.MODULE$;
    }

    public Option<SocketAddress<IpAddress>> server() {
        return this.connectionInfo().map((Function1 & Serializable)_$32 -> _$32.local());
    }

    public Option<IpAddress> serverAddr() {
        return this.server().map((Function1 & Serializable)_$33 -> (IpAddress)_$33.host()).orElse(this::serverAddr$$anonfun$2).orElse(this::serverAddr$$anonfun$3);
    }

    public Option<Port> serverPort() {
        return this.server().map((Function1 & Serializable)_$35 -> _$35.port()).orElse(this::serverPort$$anonfun$2).orElse(this::serverPort$$anonfun$3);
    }

    public Option<Object> isSecure() {
        return this.connectionInfo().map((Function1 & Serializable)_$37 -> _$37.secure());
    }

    public ServerSoftware serverSoftware() {
        return (ServerSoftware)this.attributes().lookup(Request$Keys$.MODULE$.ServerSoftware()).getOrElse(Request::serverSoftware$$anonfun$1);
    }

    public boolean isIdempotent() {
        return this.method().isIdempotent() || Headers$.MODULE$.contains$extension(this.headers(), Idempotency$minusKey$.MODULE$.headerInstance());
    }

    public <A> F decodeWith(EntityDecoder<F, A> decoder, boolean strict, Function1<A, F> f, Monad<F> F) {
        Object object = package.all$.MODULE$.catsSyntaxFlatten(decoder.decode(this, strict).fold((Function1 & Serializable)_$38 -> {
            Response response = (Response)package.all$.MODULE$.catsSyntaxApplicativeId(_$38.toHttpResponse(this.httpVersion()));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)response, (Applicative)F);
        }, f, F), F);
        return (F)FlattenOps$.MODULE$.flatten$extension(object, F);
    }

    public <A> F decode(Function1<A, F> f, Monad<F> F, EntityDecoder<F, A> decoder) {
        return this.decodeWith(decoder, false, f, F);
    }

    public <A> F decodeStrict(Function1<A, F> f, Monad<F> F, EntityDecoder<F, A> decoder) {
        return this.decodeWith(decoder, true, f, F);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this);
    }

    public boolean canEqual(Object that) {
        Object object = that;
        return object instanceof Request;
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.method();
            }
            case 1: {
                return this.uri();
            }
            case 2: {
                return this.httpVersion();
            }
            case 3: {
                return new Headers((List<Header.Raw>)this.headers());
            }
            case 4: {
                return this.body();
            }
            case 5: {
                return this.attributes();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public RequestPrelude requestPrelude() {
        return RequestPrelude$.MODULE$.fromRequest(this);
    }

    public String toString() {
        return new StringBuilder(46).append("Request(method=").append(this.method()).append(", uri=").append(this.uri()).append(", httpVersion=").append(this.httpVersion()).append(", headers=").append(new Headers((List<Header.Raw>)Headers$.MODULE$.redactSensitive$extension(this.headers(), Headers$.MODULE$.redactSensitive$default$1$extension(this.headers())))).append(")").toString();
    }

    private static final int caret$$anonfun$1() {
        return -1;
    }

    private static final List cookies$$anonfun$1() {
        return package$.MODULE$.List().empty();
    }

    private static final Cookie addCookie$$anonfun$1(RequestCookie cookie$1) {
        return Cookie$.MODULE$.apply((NonEmptyList<RequestCookie>)NonEmptyList$.MODULE$.of((Object)cookie$1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RequestCookie[0])));
    }

    private final Option from$$anonfun$1() {
        return this.remote().map((Function1 & Serializable)_$24 -> (IpAddress)_$24.host());
    }

    private static final Option remoteHost$$anonfun$1(Option inetAddress$1) {
        return inetAddress$1.map((Function1 & Serializable)_$28 -> _$28.getHostName());
    }

    private final Option serverAddr$$anonfun$2() {
        return this.uri().host().flatMap((Function1 & Serializable)_$34 -> _$34.toIpAddress());
    }

    private final Option serverAddr$$anonfun$3() {
        return Headers$.MODULE$.get$extension(this.headers(), Header$Select$.MODULE$.singleHeaders(Host$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)h -> IpAddress$.MODULE$.fromString(h.host()));
    }

    private final Option serverPort$$anonfun$2() {
        return this.uri().port().flatMap((Function1 & Serializable)value -> Port$.MODULE$.fromInt(BoxesRunTime.unboxToInt((Object)value)));
    }

    private final Option serverPort$$anonfun$3() {
        return Headers$.MODULE$.get$extension(this.headers(), Header$Select$.MODULE$.singleHeaders(Host$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)_$36 -> _$36.port().flatMap((Function1 & Serializable)value -> Port$.MODULE$.fromInt(BoxesRunTime.unboxToInt((Object)value))));
    }

    private static final ServerSoftware serverSoftware$$anonfun$1() {
        return ServerSoftware$.MODULE$.Unknown();
    }

    public static final class Connection
    implements Product,
    Serializable {
        private final SocketAddress local;
        private final SocketAddress remote;
        private final boolean secure;

        public static Connection apply(SocketAddress<IpAddress> socketAddress, SocketAddress<IpAddress> socketAddress2, boolean bl) {
            return Request$Connection$.MODULE$.apply(socketAddress, socketAddress2, bl);
        }

        public static Connection fromProduct(Product product) {
            return Request$Connection$.MODULE$.fromProduct(product);
        }

        public static Connection unapply(Connection connection) {
            return Request$Connection$.MODULE$.unapply(connection);
        }

        public Connection(SocketAddress<IpAddress> local, SocketAddress<IpAddress> remote, boolean secure) {
            this.local = local;
            this.remote = remote;
            this.secure = secure;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.local()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.remote()));
            n = Statics.mix((int)n, (int)(this.secure() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Connection)) return false;
            Connection connection = (Connection)object;
            if (this.secure() != connection.secure()) return false;
            SocketAddress<IpAddress> socketAddress = this.local();
            SocketAddress<IpAddress> socketAddress2 = connection.local();
            if (socketAddress == null) {
                if (socketAddress2 != null) {
                    return false;
                }
            } else if (!socketAddress.equals(socketAddress2)) return false;
            SocketAddress<IpAddress> socketAddress3 = this.remote();
            SocketAddress<IpAddress> socketAddress4 = connection.remote();
            if (socketAddress3 == null) {
                if (socketAddress4 == null) return true;
                return false;
            } else {
                if (!socketAddress3.equals(socketAddress4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Connection;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Connection";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "local";
                }
                case 1: {
                    return "remote";
                }
                case 2: {
                    return "secure";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SocketAddress<IpAddress> local() {
            return this.local;
        }

        public SocketAddress<IpAddress> remote() {
            return this.remote;
        }

        public boolean secure() {
            return this.secure;
        }

        public Connection copy(SocketAddress<IpAddress> local, SocketAddress<IpAddress> remote, boolean secure) {
            return new Connection(local, remote, secure);
        }

        public SocketAddress<IpAddress> copy$default$1() {
            return this.local();
        }

        public SocketAddress<IpAddress> copy$default$2() {
            return this.remote();
        }

        public boolean copy$default$3() {
            return this.secure();
        }

        public SocketAddress<IpAddress> _1() {
            return this.local();
        }

        public SocketAddress<IpAddress> _2() {
            return this.remote();
        }

        public boolean _3() {
            return this.secure();
        }
    }
}

