/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT$;
import cats.effect.SyncIO;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.headers.Access;
import org.http4s.headers.Access$minusControl$minusAllow$minusMethods$;
import org.http4s.headers.Access$minusControl$minusMax$minusAge$;
import org.http4s.headers.Access$minusControl$minusRequest$minusMethod$;
import org.http4s.headers.Origin;
import org.http4s.headers.Origin$;
import org.http4s.server.middleware.CORSConfig;
import org.http4s.server.middleware.CORSConfig$;
import org.http4s.server.middleware.CORSPolicy;
import org.http4s.server.middleware.CORSPolicy$AllowCredentials$Deny$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$Reflect$;
import org.http4s.server.middleware.CORSPolicy$AllowMethods$In$;
import org.http4s.server.middleware.CORSPolicy$AllowOrigin$All$;
import org.http4s.server.middleware.CORSPolicy$ExposeHeaders$None$;
import org.http4s.server.middleware.CORSPolicy$MaxAge$Default$;
import org.http4s.syntax.package;
import org.typelevel.ci.CIString$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class CORS$
implements Serializable {
    private static final SelfAwareStructuredLogger logger;
    private static final CORSPolicy policy;
    private static final Header.Raw defaultVaryHeader;
    public static final CORS$ MODULE$;

    private CORS$() {
    }

    static {
        MODULE$ = new CORS$();
        logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.server.middleware.CORS");
        policy = new CORSPolicy(CORSPolicy$AllowOrigin$All$.MODULE$, CORSPolicy$AllowCredentials$Deny$.MODULE$, CORSPolicy$ExposeHeaders$None$.MODULE$, CORSPolicy$AllowMethods$In$.MODULE$.apply((Set<Method>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Method[]{Method$.MODULE$.GET(), Method$.MODULE$.HEAD(), Method$.MODULE$.PUT(), Method$.MODULE$.PATCH(), Method$.MODULE$.POST(), Method$.MODULE$.DELETE()})))), CORSPolicy$AllowHeaders$Reflect$.MODULE$, CORSPolicy$MaxAge$Default$.MODULE$);
        defaultVaryHeader = Header.Raw$.MODULE$.apply(org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), "Origin,Access-Control-Request-Method");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CORS$.class);
    }

    public SelfAwareStructuredLogger<SyncIO> logger() {
        return logger;
    }

    public CORSPolicy policy() {
        return policy;
    }

    public Header.Raw defaultVaryHeader() {
        return defaultVaryHeader;
    }

    public CORSConfig DefaultCORSConfig() {
        return CORSConfig$.MODULE$.default().withAnyOrigin(true).withAllowCredentials(true).withMaxAge(new package.DurationInt(package$.MODULE$.DurationInt(1)).day());
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, CORSConfig config, Applicative<F> F) {
        if (config.anyOrigin() && config.allowCredentials()) {
            ((SyncIO)this.logger().warn(this::apply$$anonfun$1)).unsafeRunSync();
        }
        return Kleisli$.MODULE$.apply((Function1 & Serializable)req -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)req.method(), (Object)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Origin$.MODULE$.headerInstance())), (Object)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Access$minusControl$minusRequest$minusMethod$.MODULE$.headerInstance())));
            if (tuple3 != null) {
                Option option = (Option)tuple3._2();
                Option option2 = (Option)tuple3._3();
                Method method = Method$.MODULE$.OPTIONS();
                Object object = tuple3._1();
                if (!(method != null ? !method.equals(object) : object != null) && option instanceof Some) {
                    Access.minusControl.minusRequest.minusMethod acrm;
                    Origin origin = (Origin)((Some)option).value();
                    if (option2 instanceof Some && this.allowCORS$1(config, origin, (acrm = (Access.minusControl.minusRequest.minusMethod)((Some)option2).value()).method())) {
                        ((SyncIO)this.logger().debug(() -> this.apply$$anonfun$2$$anonfun$1(acrm, req))).unsafeRunSync();
                        Response response = (Response)package.all$.MODULE$.catsSyntaxApplicativeId((Object)this.createOptionsResponse$1(config, origin, acrm));
                        return ApplicativeIdOps$.MODULE$.pure$extension((Object)response, F);
                    }
                }
                if (option instanceof Some) {
                    Origin origin = (Origin)((Some)option).value();
                    if (this.allowCORS$1(config, origin, req.method())) {
                        return package.all$.MODULE$.toFunctorOps(http.apply(req), (Functor)F).map((Function1 & Serializable)resp -> {
                            ((SyncIO)this.logger().debug(() -> this.apply$$anonfun$2$$anonfun$2$$anonfun$1(req))).unsafeRunSync();
                            return this.corsHeaders$1(config, origin, req.method(), false, (Response)resp);
                        });
                    }
                    ((SyncIO)this.logger().debug(() -> this.apply$$anonfun$2$$anonfun$3(req))).unsafeRunSync();
                    Response response = (Response)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()));
                    return ApplicativeIdOps$.MODULE$.pure$extension((Object)response, F);
                }
            }
            return http.apply(req);
        });
    }

    public <F, G> CORSConfig apply$default$2() {
        return CORSConfig$.MODULE$.default();
    }

    public <F> Kleisli<?, Request<F>, Response<F>> httpRoutes(Kleisli<?, Request<F>, Response<F>> httpRoutes, Monad<F> evidence$1) {
        return this.apply((Kleisli)httpRoutes, CORSConfig$.MODULE$.default(), (Applicative<F>)OptionT$.MODULE$.catsDataMonadErrorMonadForOptionT(evidence$1));
    }

    public <F> Kleisli<F, Request<F>, Response<F>> httpApp(Kleisli<F, Request<F>, Response<F>> httpApp, Applicative<F> evidence$1) {
        return this.apply(httpApp, CORSConfig$.MODULE$.default(), evidence$1);
    }

    private final String apply$$anonfun$1() {
        return "Insecure CORS config detected: `anyOrigin=true` and `allowCredentials=true` are mutually exclusive. `Access-Control-Allow-Credentials` header will not be sent. Change either flag to false to remove this warning.";
    }

    private final Response createOptionsResponse$1(CORSConfig config$9, Origin origin, Access.minusControl.minusRequest.minusMethod acrm) {
        return this.corsHeaders$1(config$9, origin, acrm.method(), true, Response$.MODULE$.apply(Response$.MODULE$.apply$default$1(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()));
    }

    private final Option methodBasedHeader$1(CORSConfig config$2, boolean isPreflight) {
        if (isPreflight) {
            return config$2.allowedHeaders().map((Function1 & Serializable)_$4 -> this.headerFromStrings$1("Access-Control-Allow-Headers", (Set)_$4));
        }
        return config$2.exposedHeaders().map((Function1 & Serializable)_$5 -> this.headerFromStrings$1("Access-Control-Expose-Headers", (Set)_$5));
    }

    private final Response varyHeader$1(Response response) {
        Option option = Headers$.MODULE$.get$extension(response.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
        if (None$.MODULE$.equals(option)) {
            return (Response)response.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(this.defaultVaryHeader())}));
        }
        return response;
    }

    private final Response allowCredentialsHeader$7(CORSConfig config$3, Response resp) {
        if (!config$3.anyOrigin() && config$3.allowCredentials()) {
            Object[] objectArray = new Header.ToRaw[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Credentials");
            objectArray[0] = Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"true"));
            return (Response)resp.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        return resp;
    }

    private final Response $anonfun$1(Response resp$1) {
        return resp$1;
    }

    private final Set corsHeaders$1$$anonfun$1(Method method$2) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Method[]{method$2}));
    }

    private final Response corsHeaders$1(CORSConfig config$4, Origin origin, Method method, boolean isPreflight, Response resp) {
        Response withMethodBasedHeader = (Response)this.methodBasedHeader$1(config$4, isPreflight).fold(() -> this.$anonfun$1(resp), (Function1 & Serializable)h -> (Response)resp.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(h)})));
        Object[] objectArray = new Header.ToRaw[3];
        objectArray[0] = Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Access$minusControl$minusAllow$minusMethods$.MODULE$.apply((Set)config$4.allowedMethods().getOrElse(() -> this.corsHeaders$1$$anonfun$1(method))), Access$minusControl$minusAllow$minusMethods$.MODULE$.headerInstance());
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Origin");
        objectArray[1] = Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin, Origin$.MODULE$.headerInstance()).value()));
        objectArray[2] = Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Access$minusControl$minusMax$minusAge$.MODULE$.unsafeFromLong(BoxesRunTime.unboxToLong((Object)package.all$.MODULE$.catsSyntaxOrder((Object)BoxesRunTime.boxToLong((long)config$4.maxAge().toSeconds()), (Order)Eq$.MODULE$.catsKernelInstancesForLong()).max((Object)BoxesRunTime.boxToLong((long)-1L)))), Access$minusControl$minusMax$minusAge$.MODULE$.headerInstance());
        return (Response)this.varyHeader$1(this.allowCredentialsHeader$7(config$4, withMethodBasedHeader)).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final boolean allowOrigin$14(CORSConfig config$6, Origin origin$1) {
        return config$6.anyOrigin() || BoxesRunTime.unboxToBoolean((Object)config$6.allowedOrigins().apply((Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin$1, Origin$.MODULE$.headerInstance()).value()));
    }

    private final boolean allowMethod$1(CORSConfig config$7, Method method$3) {
        return config$7.anyMethod() || config$7.allowedMethods().exists((Function1 & Serializable)_$6 -> _$6.exists((Function1 & Serializable)_$7 -> package.all$.MODULE$.catsSyntaxEq(_$7, (Eq)Method$.MODULE$.catsInstancesForHttp4sMethod()).$eq$eq$eq((Object)method$3)));
    }

    private final boolean allowCORS$1(CORSConfig config$5, Origin origin, Method method) {
        return this.allowOrigin$14(config$5, origin) && this.allowMethod$1(config$5, method);
    }

    private final Header.Raw headerFromStrings$1(String headerName, Set values) {
        return Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply(headerName), values.mkString("", ", ", ""));
    }

    private final String apply$$anonfun$2$$anonfun$1(Access.minusControl.minusRequest.minusMethod acrm$1, Request req$1) {
        return new StringBuilder(39).append("Serving OPTIONS with CORS headers for ").append(acrm$1).append(" ").append(req$1.uri()).toString();
    }

    private final String apply$$anonfun$2$$anonfun$2$$anonfun$1(Request req$3) {
        return new StringBuilder(24).append("Adding CORS headers to ").append(req$3.method()).append(" ").append(req$3.uri()).toString();
    }

    private final String apply$$anonfun$2$$anonfun$3(Request req$4) {
        return new StringBuilder(30).append("CORS headers were denied for ").append(req$4.method()).append(" ").append(req$4.uri()).toString();
    }
}

