/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.core;

import cats.Applicative;
import cats.ApplicativeError;
import fs2.Chunk$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.ember.core.ChunkedEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Host$;
import org.http4s.internal.CharPredicate;
import org.http4s.internal.CharPredicate$;
import org.http4s.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Encoder$
implements Serializable {
    private static final Set<Method> NoPayloadMethods;
    private static final CharPredicate ForbiddenUriCharacters;
    public static final Encoder$ MODULE$;

    private Encoder$() {
    }

    static {
        MODULE$ = new Encoder$();
        String SPACE = " ";
        String CRLF = "\r\n";
        String chunkedTransferEncodingHeaderRaw = "Transfer-Encoding: chunked";
        String zeroContentLengthRaw = "Content-Length: 0";
        NoPayloadMethods = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Method[]{Method$.MODULE$.GET(), Method$.MODULE$.DELETE(), Method$.MODULE$.CONNECT(), Method$.MODULE$.TRACE()}));
        ForbiddenUriCharacters = CharPredicate$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CharPredicate.ApplyMagnet[]{CharPredicate.ApplyMagnet$.MODULE$.fromChar((char)0), CharPredicate.ApplyMagnet$.MODULE$.fromChar('\r'), CharPredicate.ApplyMagnet$.MODULE$.fromChar('\n')}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Encoder$.class);
    }

    public <F> Stream<F, Object> respToBytes(Response<F> resp, int writeBufferSize, Applicative<F> evidence$1) {
        boolean chunked = resp.isChunked();
        BooleanRef appliedContentLength = BooleanRef.create((boolean)false);
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder();
        stringBuilder.append(resp.httpVersion().renderString()).append(" ").append(resp.status().renderString()).append("\r\n");
        Headers$.MODULE$.foreach$extension(resp.headers(), (Function1)((JProcedure1 & Serializable)arg_0 -> this.$anonfun$1(appliedContentLength, stringBuilder, arg_0)));
        if (!appliedContentLength.elem && this.isEmptyBody$1(resp) && this.isEntityAllowed$1(resp)) {
            stringBuilder.append("Content-Length: 0").append("\r\n");
            chunked = false;
        } else if (!chunked && !appliedContentLength.elem && this.isEntityAllowed$1(resp)) {
            stringBuilder.append("Transfer-Encoding: chunked").append("\r\n");
            chunked = true;
        }
        stringBuilder.append("\r\n");
        byte[] initSection = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        if (chunked) {
            return Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)initSection, ClassTag$.MODULE$.apply(Byte.TYPE))).$plus$plus(() -> this.respToBytes$$anonfun$1(resp, evidence$1));
        }
        Stream stream = Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)initSection, ClassTag$.MODULE$.apply(Byte.TYPE))).$plus$plus(() -> this.$anonfun$2(resp));
        return stream.chunkMin(writeBufferSize, stream.chunkMin$default$2()).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int respToBytes$default$2() {
        return 32768;
    }

    public <F> Stream<F, Object> reqToBytes(Request<F> req, int writeBufferSize, ApplicativeError<F, Throwable> evidence$1) {
        String uriOriginFormString = req.uri().toOriginForm().renderString();
        if (StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(uriOriginFormString), (Function1)ForbiddenUriCharacters)) {
            return Stream$.MODULE$.raiseError((Throwable)new IllegalArgumentException(new StringBuilder(13).append("Invalid URI: ").append(uriOriginFormString).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(evidence$1));
        }
        boolean chunked = req.isChunked();
        BooleanRef appliedContentLength = BooleanRef.create((boolean)false);
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder();
        stringBuilder.append(req.method().renderString()).append(" ").append(uriOriginFormString).append(" ").append(req.httpVersion().renderString()).append("\r\n");
        if (!Headers$.MODULE$.contains$extension(req.headers(), Host$.MODULE$.headerInstance())) {
            req.uri().authority().foreach((Function1 & Serializable)auth -> stringBuilder.append("Host: ").append(auth.renderString()).append("\r\n"));
        }
        Headers$.MODULE$.foreach$extension(req.headers(), (Function1)((JProcedure1 & Serializable)arg_0 -> this.$anonfun$4(appliedContentLength, stringBuilder, arg_0)));
        if (!appliedContentLength.elem && this.isEmptyBody$2(req) && !this.isNoPayloadMethod$1(req)) {
            stringBuilder.append("Content-Length: 0").append("\r\n");
            chunked = false;
        } else if (!(chunked || appliedContentLength.elem || this.isNoPayloadMethod$1(req))) {
            stringBuilder.append("Transfer-Encoding: chunked").append("\r\n");
            chunked = true;
        }
        stringBuilder.append("\r\n");
        byte[] initSection = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        if (chunked) {
            return Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)initSection, ClassTag$.MODULE$.apply(Byte.TYPE))).$plus$plus(() -> this.reqToBytes$$anonfun$1(req, evidence$1));
        }
        Stream stream = Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)initSection, ClassTag$.MODULE$.apply(Byte.TYPE))).$plus$plus(() -> this.$anonfun$5(req));
        return stream.chunkMin(writeBufferSize, stream.chunkMin$default$2()).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int reqToBytes$default$2() {
        return 32768;
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ void $anonfun$1(BooleanRef appliedContentLength$1, scala.collection.mutable.StringBuilder stringBuilder$1, Header.Raw h) {
        block2: {
            if (!h.isNameValid()) break block2;
            if (appliedContentLength$1.elem) ** GOTO lbl-1000
            v0 = h.name();
            var5_4 = Content$minusLength$.MODULE$.name();
            if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            appliedContentLength$1.elem = var4_5 = v1;
            stringBuilder$1.append((Object)h.name()).append(": ");
            org.http4s.internal.package$.MODULE$.appendSanitized(stringBuilder$1, h.value());
            stringBuilder$1.append("\r\n");
            return;
        }
    }

    private final boolean isEmptyBody$1(Response resp$1) {
        return resp$1.body() == package$.MODULE$.EmptyBody();
    }

    private final boolean isEntityAllowed$1(Response resp$2) {
        return resp$2.status().isEntityAllowed();
    }

    private final Stream respToBytes$$anonfun$1(Response resp$3, Applicative evidence$1$1) {
        return resp$3.body().through(ChunkedEncoding$.MODULE$.encode(resp$3.trailerHeaders(evidence$1$1), evidence$1$1));
    }

    private final Stream $anonfun$2(Response resp$4) {
        return resp$4.body();
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ void $anonfun$4(BooleanRef appliedContentLength$2, scala.collection.mutable.StringBuilder stringBuilder$3, Header.Raw h) {
        block2: {
            if (!h.isNameValid()) break block2;
            if (appliedContentLength$2.elem) ** GOTO lbl-1000
            v0 = h.name();
            var5_4 = Content$minusLength$.MODULE$.name();
            if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            appliedContentLength$2.elem = var4_5 = v1;
            stringBuilder$3.append((Object)h.name()).append(": ");
            org.http4s.internal.package$.MODULE$.appendSanitized(stringBuilder$3, h.value());
            stringBuilder$3.append("\r\n");
            return;
        }
    }

    private final boolean isEmptyBody$2(Request req$1) {
        return req$1.body() == package$.MODULE$.EmptyBody();
    }

    private final boolean isNoPayloadMethod$1(Request req$2) {
        return NoPayloadMethods.contains((Object)req$2.method());
    }

    private final Stream reqToBytes$$anonfun$1(Request req$3, ApplicativeError evidence$1$2) {
        return req$3.body().through(ChunkedEncoding$.MODULE$.encode(req$3.trailerHeaders((Applicative)evidence$1$2), evidence$1$2));
    }

    private final Stream $anonfun$5(Request req$4) {
        return req$4.body();
    }
}

