/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.core.h2;

import cats.Applicative$;
import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.effect.std.Queue;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.MonadErrorRethrowOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.SocketAddress;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Channel$;
import fs2.io.net.Socket;
import fs2.io.net.unixsocket.UnixSocketAddress;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.SocketException;
import org.http4s.ember.core.h2.H2Connection$;
import org.http4s.ember.core.h2.H2Connection$ConnectionType$;
import org.http4s.ember.core.h2.H2Connection$ConnectionType$Client$;
import org.http4s.ember.core.h2.H2Connection$ConnectionType$Server$;
import org.http4s.ember.core.h2.H2Connection$KillWithoutMessage$;
import org.http4s.ember.core.h2.H2Connection$State$;
import org.http4s.ember.core.h2.H2Error;
import org.http4s.ember.core.h2.H2Error$FlowControlError$;
import org.http4s.ember.core.h2.H2Error$FrameSizeError$;
import org.http4s.ember.core.h2.H2Error$InternalError$;
import org.http4s.ember.core.h2.H2Error$ProtocolError$;
import org.http4s.ember.core.h2.H2Frame;
import org.http4s.ember.core.h2.H2Frame$;
import org.http4s.ember.core.h2.H2Frame$Continuation$;
import org.http4s.ember.core.h2.H2Frame$Data$;
import org.http4s.ember.core.h2.H2Frame$GoAway$;
import org.http4s.ember.core.h2.H2Frame$Headers$;
import org.http4s.ember.core.h2.H2Frame$Ping$;
import org.http4s.ember.core.h2.H2Frame$Priority$;
import org.http4s.ember.core.h2.H2Frame$PushPromise$;
import org.http4s.ember.core.h2.H2Frame$RawFrame$;
import org.http4s.ember.core.h2.H2Frame$RstStream$;
import org.http4s.ember.core.h2.H2Frame$Settings$;
import org.http4s.ember.core.h2.H2Frame$Unknown$;
import org.http4s.ember.core.h2.H2Frame$WindowUpdate$;
import org.http4s.ember.core.h2.H2Stream;
import org.http4s.ember.core.h2.H2Stream$State$;
import org.http4s.ember.core.h2.H2Stream$StreamState$Idle$;
import org.http4s.ember.core.h2.Hpack;
import org.typelevel.log4cats.Logger;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NoStackTrace;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class H2Connection<F> {
    private final Either<UnixSocketAddress, SocketAddress<Host>> address;
    private final ConnectionType connectionType;
    private final H2Frame.Settings.ConnectionSettings localSettings;
    private final Ref mapRef;
    private final Ref state;
    private final Queue outgoing;
    private final Queue createdStreams;
    private final Queue closedStreams;
    private final Hpack<F> hpack;
    private final Resource streamCreateAndHeaders;
    private final Deferred settingsAck;
    private final ByteVector acc;
    private final Socket<F> socket;
    private final Logger<F> logger;
    public final GenTemporal<F, Throwable> org$http4s$ember$core$h2$H2Connection$$F;

    public static <F> Object initState(H2Frame.Settings.ConnectionSettings connectionSettings, H2Frame.Settings.SettingsInitialWindowSize settingsInitialWindowSize, H2Frame.Settings.SettingsInitialWindowSize settingsInitialWindowSize2, Async<F> async) {
        return H2Connection$.MODULE$.initState(connectionSettings, settingsInitialWindowSize, settingsInitialWindowSize2, async);
    }

    public H2Connection(Either<UnixSocketAddress, SocketAddress<Host>> address, ConnectionType connectionType, H2Frame.Settings.ConnectionSettings localSettings, Ref<F, Map<Object, H2Stream<F>>> mapRef, Ref<F, State<F>> state, Queue<F, Chunk<H2Frame>> outgoing, Queue<F, Object> createdStreams, Queue<F, Object> closedStreams, Hpack<F> hpack, Resource<F, BoxedUnit> streamCreateAndHeaders, Deferred<F, Either<Throwable, H2Frame.Settings.ConnectionSettings>> settingsAck, ByteVector acc, Socket<F> socket, Logger<F> logger, GenTemporal<F, Throwable> F) {
        this.address = address;
        this.connectionType = connectionType;
        this.localSettings = localSettings;
        this.mapRef = mapRef;
        this.state = state;
        this.outgoing = outgoing;
        this.createdStreams = createdStreams;
        this.closedStreams = closedStreams;
        this.hpack = hpack;
        this.streamCreateAndHeaders = streamCreateAndHeaders;
        this.settingsAck = settingsAck;
        this.acc = acc;
        this.socket = socket;
        this.logger = logger;
        this.org$http4s$ember$core$h2$H2Connection$$F = F;
    }

    public Ref<F, Map<Object, H2Stream<F>>> mapRef() {
        return this.mapRef;
    }

    public Ref<F, State<F>> state() {
        return this.state;
    }

    public Queue<F, Chunk<H2Frame>> outgoing() {
        return this.outgoing;
    }

    public Queue<F, Object> createdStreams() {
        return this.createdStreams;
    }

    public Queue<F, Object> closedStreams() {
        return this.closedStreams;
    }

    public Resource<F, BoxedUnit> streamCreateAndHeaders() {
        return this.streamCreateAndHeaders;
    }

    public Deferred<F, Either<Throwable, H2Frame.Settings.ConnectionSettings>> settingsAck() {
        return this.settingsAck;
    }

    private String addrStr() {
        return (String)this.address.fold((Function1 & Serializable)_$2 -> _$2.toString(), (Function1 & Serializable)_$3 -> _$3.toString());
    }

    public F initiateLocalStream() {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.state().modify((Function1 & Serializable)s -> {
            int n;
            boolean highestIsEven = s.highestStream() % 2 == 0;
            ConnectionType connectionType = this.connectionType;
            if (H2Connection$ConnectionType$Server$.MODULE$.equals(connectionType)) {
                n = highestIsEven ? s.highestStream() + 2 : s.highestStream() + 1;
            } else if (H2Connection$ConnectionType$Client$.MODULE$.equals(connectionType)) {
                n = highestIsEven ? s.highestStream() + 1 : s.highestStream() + 2;
            } else {
                throw new MatchError((Object)connectionType);
            }
            int newHighest = n;
            return Tuple2$.MODULE$.apply(s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), newHighest, s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9()), (Object)Tuple2$.MODULE$.apply((Object)s.remoteSettings(), (Object)BoxesRunTime.boxToInteger((int)newHighest)));
        }), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)t -> {
            Tuple2 tuple2 = t;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple2._1();
            int id = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 $1$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)settings, (Object)BoxesRunTime.boxToInteger((int)id));
            Tuple2 $1$2 = (Tuple2)tuple3._1();
            H2Frame.Settings.ConnectionSettings settings2 = (H2Frame.Settings.ConnectionSettings)tuple3._2();
            int id2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
            return Tuple2$.MODULE$.apply(t, (Object)$1$2);
        }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Tuple2 t = (Tuple2)tuple2._1();
                if (tuple22 != null) {
                    H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple22._1();
                    int id = BoxesRunTime.unboxToInt((Object)tuple22._2());
                    return package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)writeBlock -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)request -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)response -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)trailers -> package.all$.MODULE$.toFlatMapOps(Channel$.MODULE$.unbounded(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)body -> package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(package$.MODULE$.Ref().of(H2Stream$State$.MODULE$.apply(H2Stream$StreamState$Idle$.MODULE$, Predef$.MODULE$.Integer2int(settings.initialWindowSize().windowSize()), writeBlock, Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()), request, response, trailers, body, (Option<Tuple2<Object, Object>>)None$.MODULE$), Ref.Make$.MODULE$.concurrentInstance(this.org$http4s$ember$core$h2$H2Connection$$F)), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)refState -> {
                        H2Stream<F> stream = new H2Stream<F>(id, this.localSettings, this.connectionType, package.all$.MODULE$.toFunctorOps(this.state().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$4 -> _$4.remoteSettings()), refState, this.hpack, this.outgoing(), this.closedStreams().offer((Object)BoxesRunTime.boxToInteger((int)id)), (Function1<H2Error, Object>)(Function1 & Serializable)error -> this.goAway((H2Error)error), this.logger, this.org$http4s$ember$core$h2$H2Connection$$F);
                        return Tuple2$.MODULE$.apply(refState, stream);
                    }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                        Tuple2 tuple2 = x$12;
                        if (tuple2 != null) {
                            Ref refState = (Ref)tuple2._1();
                            H2Stream stream = (H2Stream)tuple2._2();
                            return package.all$.MODULE$.toFunctorOps(this.mapRef().update((Function1 & Serializable)m -> {
                                Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id));
                                return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)stream));
                            }), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return stream;
                            });
                        }
                        throw new MatchError((Object)tuple2);
                    }))))));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public F initiateRemoteStreamById(int id) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.state().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)s -> Tuple2$.MODULE$.apply((Object)s.remoteSettings(), (Object)BoxesRunTime.boxToInteger((int)s.remoteHighestStream()))), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)t -> {
            Tuple2 tuple2 = t;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple2._1();
            int highestStream = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 $3$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$3$, (Object)settings, (Object)BoxesRunTime.boxToInteger((int)highestStream));
            Tuple2 $3$2 = (Tuple2)tuple3._1();
            H2Frame.Settings.ConnectionSettings settings2 = (H2Frame.Settings.ConnectionSettings)tuple3._2();
            int highestStream2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
            return Tuple2$.MODULE$.apply(t, (Object)$3$2);
        }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Tuple2 t = (Tuple2)tuple2._1();
                if (tuple22 != null) {
                    H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple22._1();
                    int highestStream = BoxesRunTime.unboxToInt((Object)tuple22._2());
                    return package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)writeBlock -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)request -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)response -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)trailers -> package.all$.MODULE$.toFlatMapOps(Channel$.MODULE$.unbounded(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)body -> package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(package$.MODULE$.Ref().of(H2Stream$State$.MODULE$.apply(H2Stream$StreamState$Idle$.MODULE$, Predef$.MODULE$.Integer2int(settings.initialWindowSize().windowSize()), writeBlock, Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()), request, response, trailers, body, (Option<Tuple2<Object, Object>>)None$.MODULE$), Ref.Make$.MODULE$.concurrentInstance(this.org$http4s$ember$core$h2$H2Connection$$F)), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)refState -> {
                        H2Stream<F> stream = new H2Stream<F>(id, this.localSettings, this.connectionType, package.all$.MODULE$.toFunctorOps(this.state().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$5 -> _$5.remoteSettings()), refState, this.hpack, this.outgoing(), this.closedStreams().offer((Object)BoxesRunTime.boxToInteger((int)id)), (Function1<H2Error, Object>)(Function1 & Serializable)error -> this.goAway((H2Error)error), this.logger, this.org$http4s$ember$core$h2$H2Connection$$F);
                        return Tuple2$.MODULE$.apply(refState, stream);
                    }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Ref refState = (Ref)tuple2._1();
                            H2Stream stream = (H2Stream)tuple2._2();
                            return package.all$.MODULE$.toFlatMapOps(this.mapRef().update((Function1 & Serializable)m -> {
                                Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id));
                                return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)stream));
                            }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return package.all$.MODULE$.toFunctorOps(this.state().update((Function1 & Serializable)s -> {
                                    int n = Math.max(s.highestStream(), id);
                                    int n2 = Math.max(s.remoteHighestStream(), id);
                                    H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                                    int n3 = s.copy$default$2();
                                    Deferred deferred = s.copy$default$3();
                                    int n4 = s.copy$default$4();
                                    boolean bl = s.copy$default$7();
                                    Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = s.copy$default$8();
                                    Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option2 = s.copy$default$9();
                                    return s.copy(connectionSettings, n3, deferred, n4, n, n2, bl, option, option2);
                                }), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return stream;
                                });
                            });
                        }
                        throw new MatchError((Object)tuple2);
                    }))))));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public F goAway(H2Error error) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.state().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$6 -> _$6.remoteHighestStream()), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)i -> this.goAway$$anonfun$2(error, BoxesRunTime.unboxToInt((Object)i))), this.org$http4s$ember$core$h2$H2Connection$$F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, this::goAway$$anonfun$3, this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private F writeChunk(Chunk<H2Frame> chunk) {
        Option firstGoAway = package.all$.MODULE$.toFoldableOps(chunk, (Foldable)Chunk$.MODULE$.instance()).collectFirst((PartialFunction)new Serializable(this){
            private final /* synthetic */ H2Connection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(H2Frame x) {
                H2Frame h2Frame = x;
                if (h2Frame instanceof H2Frame.GoAway) {
                    H2Frame.GoAway g = (H2Frame.GoAway)h2Frame;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(H2Frame x, Function1 function1) {
                H2Frame h2Frame = x;
                if (h2Frame instanceof H2Frame.GoAway) {
                    H2Frame.GoAway g = (H2Frame.GoAway)h2Frame;
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.$outer.mapRef().get(), this.$outer.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)m -> package.all$.MODULE$.toFoldableOps((Object)m.values().toList(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_(arg_0 -> H2Connection.org$http4s$ember$core$h2$H2Connection$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(g, arg_0), this.$outer.org$http4s$ember$core$h2$H2Connection$$F)), this.$outer.org$http4s$ember$core$h2$H2Connection$$F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::applyOrElse$$anonfun$2, this.$outer.org$http4s$ember$core$h2$H2Connection$$F);
                }
                return function1.apply((Object)x);
            }

            private final Object applyOrElse$$anonfun$2() {
                return this.$outer.state().update(H2Connection::org$http4s$ember$core$h2$H2Connection$$anon$1$$_$applyOrElse$$anonfun$2$$anonfun$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.http4s.ember.core.h2.H2Frame$GoAway scala.collection.immutable.Map ), applyOrElse$$anonfun$2(), org$http4s$ember$core$h2$H2Connection$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(org.http4s.ember.core.h2.H2Frame$GoAway org.http4s.ember.core.h2.H2Stream ), org$http4s$ember$core$h2$H2Connection$$anon$1$$_$applyOrElse$$anonfun$2$$anonfun$1(org.http4s.ember.core.h2.H2Connection$State )}, serializedLambda);
            }
        });
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(firstGoAway.getOrElse(this::writeChunk$$anonfun$1), this.org$http4s$ember$core$h2$H2Connection$$F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.writeChunk$$anonfun$2(chunk), this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    public Stream<F, Nothing$> writeLoop() {
        return Stream$.MODULE$.fromQueueUnterminated(this.outgoing(), Integer.MAX_VALUE, this.org$http4s$ember$core$h2$H2Connection$$F).foreach((Function1 & Serializable)chunk -> this.writeChunk((Chunk<H2Frame>)chunk)).handleErrorWith((Function1 & Serializable)ex -> Stream$.MODULE$.exec(this.logger.debug(ex, H2Connection::writeLoop$$anonfun$2$$anonfun$1)));
    }

    public F readLoop() {
        Object readFromSocket = this.socket.read(Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()));
        return (F)this.org$http4s$ember$core$h2$H2Connection$$F.guaranteeCase(this.readLoopAux$1(readFromSocket, this.acc), (Function1 & Serializable)x$1 -> {
            Outcome outcome = x$1;
            if (outcome instanceof Outcome.Errored) {
                Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                Throwable throwable = (Throwable)errored._1();
                if (throwable instanceof KillWithoutMessage && H2Connection$KillWithoutMessage$.MODULE$.unapply((KillWithoutMessage)throwable)) {
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.debug(H2Connection::readLoop$$anonfun$1$$anonfun$1), this.org$http4s$ember$core$h2$H2Connection$$F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::readLoop$$anonfun$1$$anonfun$2, this.org$http4s$ember$core$h2$H2Connection$$F);
                }
                Throwable e = throwable;
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.error(e, H2Connection::readLoop$$anonfun$1$$anonfun$3), this.org$http4s$ember$core$h2$H2Connection$$F);
                Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, this::readLoop$$anonfun$1$$anonfun$4, this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object2, this::readLoop$$anonfun$1$$anonfun$5, this.org$http4s$ember$core$h2$H2Connection$$F);
            }
            return this.state().update((Function1 & Serializable)s -> s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), true, s.copy$default$8(), s.copy$default$9()));
        });
    }

    private final /* synthetic */ Object goAway$$anonfun$2(H2Error error$1, int i) {
        H2Frame.GoAway g = error$1.toGoAway(i);
        return this.outgoing().offer((Object)Chunk$.MODULE$.singleton((Object)g));
    }

    private final Object goAway$$anonfun$3() {
        KillWithoutMessage killWithoutMessage = (KillWithoutMessage)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)H2Connection$KillWithoutMessage$.MODULE$.apply());
        return ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)killWithoutMessage, this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private static final /* synthetic */ int $anonfun$5(int x$1, H2Frame x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            H2Frame h2Frame = (H2Frame)tuple2._2();
            int init = n;
            if (h2Frame instanceof H2Frame.Data) {
                H2Frame.Data data = H2Frame$Data$.MODULE$.unapply((H2Frame.Data)h2Frame);
                int n2 = data._1();
                ByteVector byteVector = data._2();
                Option<ByteVector> option = data._3();
                boolean bl = data._4();
                ByteVector data2 = byteVector;
                return init + (int)data2.size();
            }
            int init2 = n;
            return init2;
        }
        throw new MatchError((Object)tuple2);
    }

    private final String go$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(H2Frame frame$1) {
        return new StringBuilder(9).append(this.addrStr()).append(" Write - ").append(frame$1).toString();
    }

    private final Object go$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Chunk chunk$4) {
        return package.all$.MODULE$.toFoldableOps((Object)chunk$4, (Foldable)Chunk$.MODULE$.instance()).traverse_((Function1 & Serializable)frame -> this.logger.debug(() -> this.go$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(frame)), this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final Object go$1$$anonfun$1$$anonfun$2$$anonfun$1(ByteVector bv$2, Chunk chunk$3) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.socket.write(Chunk$.MODULE$.byteVector(bv$2)), this.org$http4s$ember$core$h2$H2Connection$$F);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.go$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(chunk$3), this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final Object go$1$$anonfun$1$$anonfun$2$$anonfun$2() {
        SocketException socketException = (SocketException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new SocketException("Socket closed when attempting to write"));
        return ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)socketException, this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final Object go$1$$anonfun$1$$anonfun$2(ByteVector bv$1, Chunk chunk$2) {
        Object object = package.all$.MODULE$.catsSyntaxIfM(this.socket.isOpen(), this.org$http4s$ember$core$h2$H2Connection$$F);
        return IfMOps$.MODULE$.ifM$extension(object, () -> this.go$1$$anonfun$1$$anonfun$2$$anonfun$1(bv$1, chunk$2), this::go$1$$anonfun$1$$anonfun$2$$anonfun$2, this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final String go$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(H2Frame frame$2) {
        return new StringBuilder(9).append(this.addrStr()).append(" Write - ").append(frame$2).toString();
    }

    private final Object go$1$$anonfun$1$$anonfun$3$$anonfun$1(Chunk nonData$2) {
        return package.all$.MODULE$.toFoldableOps((Object)nonData$2, (Foldable)Chunk$.MODULE$.instance()).traverse_((Function1 & Serializable)frame -> this.logger.debug(() -> this.go$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(frame)), this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final Object go$1$$anonfun$1$$anonfun$3(ByteVector bv$3, Chunk nonData$1) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.socket.write(Chunk$.MODULE$.byteVector(bv$3)), this.org$http4s$ember$core$h2$H2Connection$$F);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.go$1$$anonfun$1$$anonfun$3$$anonfun$1(nonData$1), this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final Object go$1$$anonfun$1$$anonfun$4() {
        SocketException socketException = (SocketException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new SocketException("Socket closed when attempting to write"));
        return ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)socketException, this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final Object go$1$$anonfun$1$$anonfun$5(State s$1) {
        Object object = package.all$.MODULE$.catsSyntaxMonadErrorRethrow(s$1.writeBlock().get(), this.org$http4s$ember$core$h2$H2Connection$$F);
        return MonadErrorRethrowOps$.MODULE$.rethrow$extension(object, this.org$http4s$ember$core$h2$H2Connection$$F);
    }

    private final Object go$1$$anonfun$1$$anonfun$6(Chunk after$1) {
        return this.go$1(after$1);
    }

    private final Object go$1(Chunk chunk) {
        return package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)s2 -> {
            Tuple2 tuple2;
            int fullDataSize = BoxesRunTime.unboxToInt((Object)chunk.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> H2Connection.$anonfun$5(BoxesRunTime.unboxToInt((Object)x$1), (H2Frame)x$2)));
            if (fullDataSize <= s2.writeWindow() && s2.writeWindow() > 0) {
                ByteVector bv = (ByteVector)chunk.foldLeft((Object)ByteVector$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        ByteVector acc = (ByteVector)tuple2._1();
                        H2Frame frame = (H2Frame)tuple2._2();
                        return acc.$plus$plus(H2Frame$.MODULE$.toByteVector(frame));
                    }
                    throw new MatchError((Object)tuple2);
                });
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.state().update((Function1 & Serializable)s -> {
                    int n = s.writeWindow() - fullDataSize;
                    H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                    Deferred deferred = s.copy$default$3();
                    int n2 = s.copy$default$4();
                    int n3 = s.copy$default$5();
                    int n4 = s.copy$default$6();
                    boolean bl = s.copy$default$7();
                    Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = s.copy$default$8();
                    Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option2 = s.copy$default$9();
                    return s.copy(connectionSettings, n, deferred, n2, n3, n4, bl, option, option2);
                }), this.org$http4s$ember$core$h2$H2Connection$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.go$1$$anonfun$1$$anonfun$2(bv, chunk), this.org$http4s$ember$core$h2$H2Connection$$F);
            }
            Option option = chunk.indexWhere((Function1 & Serializable)_$7 -> _$7 instanceof H2Frame.Data);
            if (None$.MODULE$.equals(option)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)chunk, (Object)Chunk$.MODULE$.empty());
            } else if (option instanceof Some) {
                int ix = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                tuple2 = chunk.splitAt(ix);
            } else {
                throw new MatchError((Object)option);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Chunk nonData = (Chunk)tuple22._1();
            Chunk after = (Chunk)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)nonData, (Object)after);
            Chunk nonData2 = (Chunk)tuple23._1();
            Chunk after2 = (Chunk)tuple23._2();
            ByteVector bv = (ByteVector)nonData2.foldLeft((Object)ByteVector$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    ByteVector acc = (ByteVector)tuple2._1();
                    H2Frame frame = (H2Frame)tuple2._2();
                    return acc.$plus$plus(H2Frame$.MODULE$.toByteVector(frame));
                }
                throw new MatchError((Object)tuple2);
            });
            Object object = package.all$.MODULE$.catsSyntaxIfM(this.socket.isOpen(), this.org$http4s$ember$core$h2$H2Connection$$F);
            Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(IfMOps$.MODULE$.ifM$extension(object, () -> this.go$1$$anonfun$1$$anonfun$3(bv, nonData2), this::go$1$$anonfun$1$$anonfun$4, this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F);
            Object object3 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.go$1$$anonfun$1$$anonfun$5(s2), this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this.go$1$$anonfun$1$$anonfun$6(after2), this.org$http4s$ember$core$h2$H2Connection$$F);
        });
    }

    public static final /* synthetic */ Object org$http4s$ember$core$h2$H2Connection$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(H2Frame.GoAway g$2, H2Stream connection) {
        return connection.receiveGoAway(g$2);
    }

    public static final /* synthetic */ State org$http4s$ember$core$h2$H2Connection$$anon$1$$_$applyOrElse$$anonfun$2$$anonfun$1(State s) {
        return s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), true, s.copy$default$8(), s.copy$default$9());
    }

    private final Object writeChunk$$anonfun$1() {
        return this.org$http4s$ember$core$h2$H2Connection$$F.unit();
    }

    private final Object writeChunk$$anonfun$2(Chunk chunk$5) {
        return this.go$1(chunk$5);
    }

    private static final String writeLoop$$anonfun$2$$anonfun$1() {
        return "writeLoop terminated";
    }

    private final String connectionTerminated$1() {
        return new StringBuilder(31).append("Connection ").append(this.addrStr()).append(" readLoop Terminated").toString();
    }

    private final String readNextFrame$1$$anonfun$1$$anonfun$1() {
        return new StringBuilder(11).append(this.connectionTerminated$1()).append(" with empty").toString();
    }

    private final String readNextFrame$1$$anonfun$2(H2Error e$1) {
        return new StringBuilder(22).append(this.connectionTerminated$1()).append(" invalid Raw to Frame ").append(e$1).toString();
    }

    private final Object readNextFrame$1$$anonfun$3(H2Error e$2) {
        return this.goAway(e$2);
    }

    private final Object readNextFrame$1$$anonfun$4() {
        return this.org$http4s$ember$core$h2$H2Connection$$F.pure((Object)None$.MODULE$);
    }

    private final String readNextFrame$1$$anonfun$5$$anonfun$1(ByteVector acc$2) {
        return new StringBuilder(6).append(this.connectionTerminated$1()).append(" with ").append(acc$2).toString();
    }

    private final Object readNextFrame$1(Object readFromSocket$1, ByteVector acc) {
        Tuple2 tuple2;
        if (acc.isEmpty()) {
            return package.all$.MODULE$.toFlatMapOps(readFromSocket$1, this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Chunk chunk = (Chunk)((Some)option).value();
                    return this.readNextFrame$1(readFromSocket$1, chunk.toByteVector($less$colon$less$.MODULE$.refl()));
                }
                if (None$.MODULE$.equals(option)) {
                    return package.all$.MODULE$.toFunctorOps(this.logger.debug(this::readNextFrame$1$$anonfun$1$$anonfun$1), this.org$http4s$ember$core$h2$H2Connection$$F).as((Object)None$.MODULE$);
                }
                throw new MatchError((Object)option);
            });
        }
        Option<Tuple2<H2Frame.RawFrame, ByteVector>> option = H2Frame$RawFrame$.MODULE$.fromByteVector(acc);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            H2Frame.RawFrame raw = (H2Frame.RawFrame)tuple2._1();
            ByteVector leftover = (ByteVector)tuple2._2();
            Either<H2Error, H2Frame> either = H2Frame$.MODULE$.fromRaw(raw);
            if (either instanceof Right) {
                H2Frame frame = (H2Frame)((Right)either).value();
                return this.org$http4s$ember$core$h2$H2Connection$$F.pure((Object)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)frame, (Object)leftover)));
            }
            if (either instanceof Left) {
                H2Error e = (H2Error)((Left)either).value();
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(() -> this.readNextFrame$1$$anonfun$2(e)), this.org$http4s$ember$core$h2$H2Connection$$F);
                Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.readNextFrame$1$$anonfun$3(e), this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object2, this::readNextFrame$1$$anonfun$4, this.org$http4s$ember$core$h2$H2Connection$$F);
            }
            throw new MatchError(either);
        }
        if (None$.MODULE$.equals(option)) {
            return package.all$.MODULE$.toFlatMapOps(readFromSocket$1, this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Chunk chunk = (Chunk)((Some)option).value();
                    return this.readNextFrame$1(readFromSocket$1, acc.$plus$plus(chunk.toByteVector($less$colon$less$.MODULE$.refl())));
                }
                if (None$.MODULE$.equals(option)) {
                    return package.all$.MODULE$.toFunctorOps(this.logger.debug(() -> this.readNextFrame$1$$anonfun$5$$anonfun$1(acc)), this.org$http4s$ember$core$h2$H2Connection$$F).as((Object)None$.MODULE$);
                }
                throw new MatchError((Object)option);
            });
        }
        throw new MatchError(option);
    }

    private final Object processFrame$1$$anonfun$2(int id$20, H2Frame.Headers h$1, H2Frame.Continuation c$1, List cs$1) {
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$8 -> _$8.get((Object)BoxesRunTime.boxToInteger((int)id$20))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                H2Stream s = (H2Stream)((Some)option).value();
                return s.receiveHeaders(h$1, (Seq<H2Frame.Continuation>)scala.package$.MODULE$.Nil().$colon$colon((Object)c$1).$colon$colon$colon(cs$1));
            }
            if (None$.MODULE$.equals(option)) {
                return this.streamCreateAndHeaders().use((Function1 & Serializable)_$9 -> package.all$.MODULE$.toFlatMapOps(this.initiateRemoteStreamById(id$20), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)stream -> package.all$.MODULE$.toFlatMapOps(this.createdStreams().offer((Object)BoxesRunTime.boxToInteger((int)id$20)), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return package.all$.MODULE$.toFunctorOps(stream.receiveHeaders(h$1, (Seq<H2Frame.Continuation>)scala.package$.MODULE$.Nil().$colon$colon((Object)c$1).$colon$colon$colon(cs$1)), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                })), this.org$http4s$ember$core$h2$H2Connection$$F);
            }
            throw new MatchError((Object)option);
        });
    }

    private static final String processFrame$1$$anonfun$3() {
        return "Invalid Continuation - Protocol Error - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$4() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private final Object processFrame$1$$anonfun$6(int id$25, H2Frame.PushPromise p$1, H2Frame.Continuation c$6, List cs$6) {
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$10 -> _$10.get((Object)BoxesRunTime.boxToInteger((int)id$25))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                H2Stream s = (H2Stream)((Some)option).value();
                return s.receivePushPromise(p$1, (Seq<H2Frame.Continuation>)scala.package$.MODULE$.Nil().$colon$colon((Object)c$6).$colon$colon$colon(cs$6));
            }
            if (None$.MODULE$.equals(option)) {
                return this.streamCreateAndHeaders().use((Function1 & Serializable)_$11 -> package.all$.MODULE$.toFlatMapOps(this.initiateRemoteStreamById(id$25), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)stream -> package.all$.MODULE$.toFlatMapOps(this.createdStreams().offer((Object)BoxesRunTime.boxToInteger((int)id$25)), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return package.all$.MODULE$.toFunctorOps(stream.receivePushPromise(p$1, (Seq<H2Frame.Continuation>)scala.package$.MODULE$.Nil().$colon$colon((Object)c$6).$colon$colon$colon(cs$6)), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                })), this.org$http4s$ember$core$h2$H2Connection$$F);
            }
            throw new MatchError((Object)option);
        });
    }

    private static final String processFrame$1$$anonfun$7() {
        return "Invalid Continuation - Protocol Error - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$8() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$10() {
        return "Invalid Continuation - Protocol Error - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$11() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$13() {
        return "Invalid Continuation - Protocol Error - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$14() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$15(H2Frame f$1) {
        return new StringBuilder(99).append("Continuation for headers in process, retrieved unexpected frame ").append(f$1).append(" -  Protocol Error - Issuing GoAway").toString();
    }

    private final Object processFrame$1$$anonfun$16() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$17(H2Frame f$2) {
        return new StringBuilder(104).append("Continuation for push promise in process, retrieved unexpected frame ").append(f$2).append(" -  Protocol Error - Issuing GoAway").toString();
    }

    private final Object processFrame$1$$anonfun$18() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$19() {
        return "Header Size too large for frame size - FrameSizeError - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$20() {
        return this.goAway(H2Error$FrameSizeError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$23$$anonfun$1(int i$4, boolean isValidToCreate$1, State s$3) {
        return new StringBuilder(66).append("Not Valid Stream to Create ").append(i$4).append(" - ").append(isValidToCreate$1).append(", ").append(s$3.highestStream()).append(" - Protocol Error - Issuing GoAway").toString();
    }

    private final Object processFrame$1$$anonfun$23$$anonfun$2() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$26() {
        return "Encountered Push Promise Frame a a Server - Protocol Error - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$27() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$28() {
        return "Header Size too large for frame size - FrameSizeError - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$29() {
        return this.goAway(H2Error$FrameSizeError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$31$$anonfun$1(int i$10, boolean isValidToCreate$2, State s$5) {
        return new StringBuilder(66).append("Not Valid Stream to Create ").append(i$10).append(" - ").append(isValidToCreate$2).append(", ").append(s$5.remoteHighestStream()).append(" - Protocol Error - Issuing GoAway").toString();
    }

    private final /* synthetic */ Object processFrame$1$$anonfun$33$$anonfun$3$$anonfun$1(int difference$1, H2Frame.Settings.ConnectionSettings settings$13, boolean x$12) {
        boolean bl = x$12;
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)map -> package.all$.MODULE$.toTraverseOps((Object)map.toList(), UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                H2Stream stream = (H2Stream)tuple2._2();
                return stream.modifyWriteWindow(difference$1);
            }
            throw new MatchError((Object)tuple2);
        }, this.org$http4s$ember$core$h2$H2Connection$$F)), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
            List list = x$1;
            return package.all$.MODULE$.toFlatMapOps(this.outgoing().offer((Object)Chunk$.MODULE$.singleton((Object)H2Frame$Settings$.MODULE$.Ack())), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.settingsAck().complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)settings$13)), this.org$http4s$ember$core$h2$H2Connection$$F).void(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    private static final String processFrame$1$$anonfun$34() {
        return "Received Settings Not Oriented at Identifier 0 - Issuing goAway";
    }

    private final Object processFrame$1$$anonfun$35() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private final Object processFrame$1$$anonfun$37() {
        return this.outgoing().offer((Object)Chunk$.MODULE$.singleton((Object)H2Frame$Ping$.MODULE$.ack()));
    }

    private static final String processFrame$1$$anonfun$38() {
        return "Encountered 0 Sized Window Update - Procol Error - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$39() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private final /* synthetic */ Object processFrame$1$$anonfun$40$$anonfun$3$$anonfun$1(boolean valid$1, boolean x$12) {
        boolean bl = x$12;
        return package.all$.MODULE$.toFunctorOps(!valid$1 ? this.goAway(H2Error$FlowControlError$.MODULE$) : Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Connection$$F).unit(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private static final String processFrame$1$$anonfun$42$$anonfun$1(H2Frame.WindowUpdate w$2, int i$14) {
        return new StringBuilder(52).append("Received WindowUpdate for Closed or Idle Stream - ").append(w$2).append(", ").append(i$14).toString();
    }

    private final Object processFrame$1$$anonfun$42$$anonfun$2() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$43() {
        return "Receive Data Size Larger than Allowed Frame Size - Frame Size Error - Issuing GoAway";
    }

    private final Object processFrame$1$$anonfun$44() {
        return this.goAway(H2Error$FrameSizeError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$46$$anonfun$3(int i$17) {
        return new StringBuilder(80).append("Received Data Frame for Idle or Closed Stream ").append(i$17).append(" - Protocol Error - Issuing GoAway").toString();
    }

    private final Object processFrame$1$$anonfun$46$$anonfun$4() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private static final String processFrame$1$$anonfun$48$$anonfun$1(int i$20) {
        return new StringBuilder(79).append("Received RstStream for Idle or Closed Stream ").append(i$20).append(" - Protocol Error - Issuing GoAway").toString();
    }

    private final Object processFrame$1$$anonfun$48$$anonfun$2() {
        return this.goAway(H2Error$ProtocolError$.MODULE$);
    }

    private final Object processFrame$1(H2Frame frame, State s2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)frame, (Object)s2);
        if (tuple2 != null) {
            H2Frame h2Frame = (H2Frame)tuple2._1();
            State state = (State)tuple2._2();
            if (h2Frame instanceof H2Frame.Continuation) {
                H2Frame.Continuation continuation = (H2Frame.Continuation)h2Frame;
                H2Frame.Continuation continuation2 = H2Frame$Continuation$.MODULE$.unapply(continuation);
                int n = continuation2._1();
                boolean bl = continuation2._2();
                ByteVector byteVector = continuation2._3();
                int id = n;
                if (bl) {
                    H2Frame.Continuation c = continuation;
                    if (state != null) {
                        Tuple2 tuple22;
                        Tuple2 tuple23;
                        State state2 = H2Connection$State$.MODULE$.unapply(state);
                        H2Frame.Settings.ConnectionSettings connectionSettings = state2._1();
                        int n2 = state2._2();
                        Deferred deferred = state2._3();
                        int n3 = state2._4();
                        int n4 = state2._5();
                        int n5 = state2._6();
                        boolean bl2 = state2._7();
                        Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = state2._8();
                        Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option2 = state2._9();
                        if (option instanceof Some && (tuple23 = (Tuple2)((Some)option).value()) != null) {
                            H2Frame.Headers h = (H2Frame.Headers)tuple23._1();
                            List cs = (List)tuple23._2();
                            if (None$.MODULE$.equals(option2)) {
                                if (h.identifier() == id) {
                                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.state().update((Function1 & Serializable)s -> {
                                        None$ none$ = None$.MODULE$;
                                        H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                                        int n = s.copy$default$2();
                                        Deferred deferred = s.copy$default$3();
                                        int n2 = s.copy$default$4();
                                        int n3 = s.copy$default$5();
                                        int n4 = s.copy$default$6();
                                        boolean bl = s.copy$default$7();
                                        Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option = s.copy$default$9();
                                        return s.copy(connectionSettings, n, deferred, n2, n3, n4, bl, (Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>>)none$, option);
                                    }), this.org$http4s$ember$core$h2$H2Connection$$F);
                                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.processFrame$1$$anonfun$2(id, h, c, cs), this.org$http4s$ember$core$h2$H2Connection$$F);
                                }
                                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$3), this.org$http4s$ember$core$h2$H2Connection$$F);
                                return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$4, this.org$http4s$ember$core$h2$H2Connection$$F);
                            }
                        }
                        int id2 = n;
                        H2Frame.Continuation c2 = continuation;
                        if (None$.MODULE$.equals(option) && option2 instanceof Some && (tuple22 = (Tuple2)((Some)option2).value()) != null) {
                            H2Frame.PushPromise p = (H2Frame.PushPromise)tuple22._1();
                            List cs = (List)tuple22._2();
                            if (p.promisedStreamId() == id2) {
                                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.state().update((Function1 & Serializable)s -> {
                                    None$ none$ = None$.MODULE$;
                                    H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                                    int n = s.copy$default$2();
                                    Deferred deferred = s.copy$default$3();
                                    int n2 = s.copy$default$4();
                                    int n3 = s.copy$default$5();
                                    int n4 = s.copy$default$6();
                                    boolean bl = s.copy$default$7();
                                    Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option = s.copy$default$9();
                                    return s.copy(connectionSettings, n, deferred, n2, n3, n4, bl, (Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>>)none$, option);
                                }), this.org$http4s$ember$core$h2$H2Connection$$F);
                                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.processFrame$1$$anonfun$6(id2, p, c2, cs), this.org$http4s$ember$core$h2$H2Connection$$F);
                            }
                            Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$7), this.org$http4s$ember$core$h2$H2Connection$$F);
                            return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$8, this.org$http4s$ember$core$h2$H2Connection$$F);
                        }
                    }
                }
                int id3 = n;
                if (!bl) {
                    H2Frame.Continuation c = continuation;
                    if (state != null) {
                        Tuple2 tuple24;
                        Tuple2 tuple25;
                        State state3 = H2Connection$State$.MODULE$.unapply(state);
                        H2Frame.Settings.ConnectionSettings connectionSettings = state3._1();
                        int n6 = state3._2();
                        Deferred deferred = state3._3();
                        int n7 = state3._4();
                        int n8 = state3._5();
                        int n9 = state3._6();
                        boolean bl3 = state3._7();
                        Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = state3._8();
                        Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option3 = state3._9();
                        if (None$.MODULE$.equals(option) && option3 instanceof Some && (tuple25 = (Tuple2)((Some)option3).value()) != null) {
                            H2Frame.PushPromise h = (H2Frame.PushPromise)tuple25._1();
                            List cs = (List)tuple25._2();
                            if (h.identifier() == id3) {
                                return this.state().update((Function1 & Serializable)s -> {
                                    Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxOptionId((Object)Tuple2$.MODULE$.apply((Object)h, (Object)scala.package$.MODULE$.Nil().$colon$colon((Object)c).$colon$colon$colon(cs)));
                                    Option option = OptionIdOps$.MODULE$.some$extension((Object)tuple2);
                                    H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                                    int n = s.copy$default$2();
                                    Deferred deferred = s.copy$default$3();
                                    int n2 = s.copy$default$4();
                                    int n3 = s.copy$default$5();
                                    int n4 = s.copy$default$6();
                                    boolean bl = s.copy$default$7();
                                    Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option2 = s.copy$default$8();
                                    return s.copy(connectionSettings, n, deferred, n2, n3, n4, bl, option2, (Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>>)option);
                                });
                            }
                            Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$10), this.org$http4s$ember$core$h2$H2Connection$$F);
                            return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$11, this.org$http4s$ember$core$h2$H2Connection$$F);
                        }
                        int id4 = n;
                        H2Frame.Continuation c3 = continuation;
                        if (option instanceof Some && (tuple24 = (Tuple2)((Some)option).value()) != null) {
                            H2Frame.Headers h = (H2Frame.Headers)tuple24._1();
                            List cs = (List)tuple24._2();
                            if (None$.MODULE$.equals(option3)) {
                                if (h.identifier() == id4) {
                                    return this.state().update((Function1 & Serializable)s -> {
                                        Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxOptionId((Object)Tuple2$.MODULE$.apply((Object)h, (Object)scala.package$.MODULE$.Nil().$colon$colon((Object)c3).$colon$colon$colon(cs)));
                                        Option option = OptionIdOps$.MODULE$.some$extension((Object)tuple2);
                                        H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                                        int n = s.copy$default$2();
                                        Deferred deferred = s.copy$default$3();
                                        int n2 = s.copy$default$4();
                                        int n3 = s.copy$default$5();
                                        int n4 = s.copy$default$6();
                                        boolean bl = s.copy$default$7();
                                        Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option2 = s.copy$default$9();
                                        return s.copy(connectionSettings, n, deferred, n2, n3, n4, bl, (Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>>)option, option2);
                                    });
                                }
                                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$13), this.org$http4s$ember$core$h2$H2Connection$$F);
                                return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$14, this.org$http4s$ember$core$h2$H2Connection$$F);
                            }
                        }
                    }
                }
            }
            H2Frame f = h2Frame;
            if (state != null) {
                State state4 = H2Connection$State$.MODULE$.unapply(state);
                H2Frame.Settings.ConnectionSettings connectionSettings = state4._1();
                int n = state4._2();
                Deferred deferred = state4._3();
                int n10 = state4._4();
                int n11 = state4._5();
                int n12 = state4._6();
                boolean bl = state4._7();
                Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = state4._8();
                Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option4 = state4._9();
                if (option instanceof Some && None$.MODULE$.equals(option4)) {
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(() -> H2Connection.processFrame$1$$anonfun$15(f)), this.org$http4s$ember$core$h2$H2Connection$$F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$16, this.org$http4s$ember$core$h2$H2Connection$$F);
                }
                H2Frame f2 = h2Frame;
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(() -> H2Connection.processFrame$1$$anonfun$17(f2)), this.org$http4s$ember$core$h2$H2Connection$$F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$18, this.org$http4s$ember$core$h2$H2Connection$$F);
                }
            }
            if (h2Frame instanceof H2Frame.Headers) {
                H2Frame.Headers headers = (H2Frame.Headers)h2Frame;
                H2Frame.Headers headers2 = H2Frame$Headers$.MODULE$.unapply(headers);
                int n = headers2._1();
                Option<H2Frame.Headers.StreamDependency> option = headers2._2();
                boolean bl = headers2._3();
                boolean bl4 = headers2._4();
                ByteVector byteVector = headers2._5();
                Option<ByteVector> option5 = headers2._6();
                int i = n;
                Option<H2Frame.Headers.StreamDependency> sd = option;
                if (bl4) {
                    ByteVector headerBlock = byteVector;
                    H2Frame.Headers h = headers;
                    State s3 = state;
                    int size = (int)headerBlock.size();
                    if (size > s3.remoteSettings().maxFrameSize().frameSize()) {
                        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$19), this.org$http4s$ember$core$h2$H2Connection$$F);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$20, this.org$http4s$ember$core$h2$H2Connection$$F);
                    }
                    if (sd.exists((Function1 & Serializable)s -> s.dependency() == i)) {
                        return this.goAway(H2Error$ProtocolError$.MODULE$);
                    }
                    return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$12 -> _$12.get((Object)BoxesRunTime.boxToInteger((int)i))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            H2Stream s = (H2Stream)((Some)option).value();
                            return s.receiveHeaders(h, (Seq<H2Frame.Continuation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new H2Frame.Continuation[0]));
                        }
                        if (None$.MODULE$.equals(option)) {
                            boolean bl;
                            ConnectionType connectionType = this.connectionType;
                            if (H2Connection$ConnectionType$Server$.MODULE$.equals(connectionType)) {
                                bl = i % 2 != 0;
                            } else if (H2Connection$ConnectionType$Client$.MODULE$.equals(connectionType)) {
                                bl = i % 2 == 0;
                            } else {
                                throw new MatchError((Object)connectionType);
                            }
                            boolean isValidToCreate = bl;
                            if (!isValidToCreate || i <= s3.remoteHighestStream()) {
                                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(() -> H2Connection.processFrame$1$$anonfun$23$$anonfun$1(i, isValidToCreate, s3)), this.org$http4s$ember$core$h2$H2Connection$$F);
                                return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$23$$anonfun$2, this.org$http4s$ember$core$h2$H2Connection$$F);
                            }
                            return this.streamCreateAndHeaders().use((Function1 & Serializable)_$13 -> package.all$.MODULE$.toFlatMapOps(this.initiateRemoteStreamById(i), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)stream -> package.all$.MODULE$.toFlatMapOps(this.createdStreams().offer((Object)BoxesRunTime.boxToInteger((int)i)), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return package.all$.MODULE$.toFunctorOps(stream.receiveHeaders(h, (Seq<H2Frame.Continuation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new H2Frame.Continuation[0])), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                });
                            })), this.org$http4s$ember$core$h2$H2Connection$$F);
                        }
                        throw new MatchError((Object)option);
                    });
                }
                int i2 = n;
                Option<H2Frame.Headers.StreamDependency> sd2 = option;
                if (!bl4) {
                    ByteVector headerBlock = byteVector;
                    H2Frame.Headers h = headers;
                    State s4 = state;
                    int size = (int)headerBlock.size();
                    if (size > s4.remoteSettings().maxFrameSize().frameSize()) {
                        return this.goAway(H2Error$FrameSizeError$.MODULE$);
                    }
                    if (sd2.exists((Function1 & Serializable)s -> s.dependency() == i2)) {
                        return this.goAway(H2Error$ProtocolError$.MODULE$);
                    }
                    return this.state().update((Function1 & Serializable)s -> {
                        Some some = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)h, (Object)scala.package$.MODULE$.List().empty()));
                        H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                        int n = s.copy$default$2();
                        Deferred deferred = s.copy$default$3();
                        int n2 = s.copy$default$4();
                        int n3 = s.copy$default$5();
                        int n4 = s.copy$default$6();
                        boolean bl = s.copy$default$7();
                        Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option = s.copy$default$9();
                        return s.copy(connectionSettings, n, deferred, n2, n3, n4, bl, (Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>>)some, option);
                    });
                }
            }
            if (h2Frame instanceof H2Frame.PushPromise) {
                H2Frame.PushPromise pushPromise = (H2Frame.PushPromise)h2Frame;
                H2Frame.PushPromise pushPromise2 = H2Frame$PushPromise$.MODULE$.unapply(pushPromise);
                int n = pushPromise2._1();
                boolean bl = pushPromise2._2();
                int n13 = pushPromise2._3();
                ByteVector byteVector = pushPromise2._4();
                Option<ByteVector> option = pushPromise2._5();
                if (bl) {
                    int i = n13;
                    ByteVector headerBlock = byteVector;
                    H2Frame.PushPromise h = pushPromise;
                    State s5 = state;
                    int size = (int)headerBlock.size();
                    ConnectionType connectionType = this.connectionType;
                    H2Connection$ConnectionType$Server$ h2Connection$ConnectionType$Server$ = H2Connection$ConnectionType$Server$.MODULE$;
                    if (!(connectionType != null ? !connectionType.equals(h2Connection$ConnectionType$Server$) : h2Connection$ConnectionType$Server$ != null)) {
                        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$26), this.org$http4s$ember$core$h2$H2Connection$$F);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$27, this.org$http4s$ember$core$h2$H2Connection$$F);
                    }
                    if (size > s5.remoteSettings().maxFrameSize().frameSize()) {
                        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$28), this.org$http4s$ember$core$h2$H2Connection$$F);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$29, this.org$http4s$ember$core$h2$H2Connection$$F);
                    }
                    return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$14 -> _$14.get((Object)BoxesRunTime.boxToInteger((int)i))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            H2Stream s = (H2Stream)((Some)option).value();
                            return s.receivePushPromise(h, (Seq<H2Frame.Continuation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new H2Frame.Continuation[0]));
                        }
                        if (None$.MODULE$.equals(option)) {
                            boolean isValidToCreate;
                            boolean bl = isValidToCreate = i % 2 == 0;
                            if (!isValidToCreate || i <= s5.remoteHighestStream()) {
                                this.logger.warn(() -> H2Connection.processFrame$1$$anonfun$31$$anonfun$1(i, isValidToCreate, s5));
                                return this.goAway(H2Error$ProtocolError$.MODULE$);
                            }
                            return this.streamCreateAndHeaders().use((Function1 & Serializable)_$15 -> package.all$.MODULE$.toFlatMapOps(this.initiateRemoteStreamById(i), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)stream -> package.all$.MODULE$.toFlatMapOps(this.createdStreams().offer((Object)BoxesRunTime.boxToInteger((int)i)), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return package.all$.MODULE$.toFunctorOps(stream.receivePushPromise(h, (Seq<H2Frame.Continuation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new H2Frame.Continuation[0])), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                });
                            })), this.org$http4s$ember$core$h2$H2Connection$$F);
                        }
                        throw new MatchError((Object)option);
                    });
                }
                if (!bl) {
                    ByteVector headerBlock = byteVector;
                    H2Frame.PushPromise h = pushPromise;
                    State s6 = state;
                    int size = (int)headerBlock.size();
                    if (size > s6.remoteSettings().maxFrameSize().frameSize()) {
                        return this.goAway(H2Error$FrameSizeError$.MODULE$);
                    }
                    return this.state().update((Function1 & Serializable)s -> {
                        Some some = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)h, (Object)scala.package$.MODULE$.List().empty()));
                        H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                        int n = s.copy$default$2();
                        Deferred deferred = s.copy$default$3();
                        int n2 = s.copy$default$4();
                        int n3 = s.copy$default$5();
                        int n4 = s.copy$default$6();
                        boolean bl = s.copy$default$7();
                        Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = s.copy$default$8();
                        return s.copy(connectionSettings, n, deferred, n2, n3, n4, bl, option, (Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>>)some);
                    });
                }
            }
            if (h2Frame instanceof H2Frame.Continuation) {
                H2Frame.Continuation continuation = H2Frame$Continuation$.MODULE$.unapply((H2Frame.Continuation)h2Frame);
                int n = continuation._1();
                boolean bl = continuation._2();
                ByteVector byteVector = continuation._3();
                return this.goAway(H2Error$ProtocolError$.MODULE$);
            }
            if (h2Frame instanceof H2Frame.Settings) {
                H2Frame.Settings settings = (H2Frame.Settings)h2Frame;
                H2Frame.Settings settings2 = H2Frame$Settings$.MODULE$.unapply(settings);
                int n = settings2._1();
                boolean bl = settings2._2();
                List<H2Frame.Settings.Setting> list = settings2._3();
                if (0 == n) {
                    if (!bl) {
                        H2Frame.Settings settings3 = settings;
                        return package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)newWriteBlock -> package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.state().modify((Function1 & Serializable)s -> {
                            H2Frame.Settings.ConnectionSettings newSettings = H2Frame$Settings$.MODULE$.updateSettings(settings3, s.remoteSettings());
                            int differenceInWindow = Predef$.MODULE$.Integer2int(newSettings.initialWindowSize().windowSize()) - Predef$.MODULE$.Integer2int(s.remoteSettings().initialWindowSize().windowSize());
                            return Tuple2$.MODULE$.apply(s.copy(newSettings, s.writeWindow(), newWriteBlock, s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9()), (Object)Tuple3$.MODULE$.apply((Object)newSettings, (Object)BoxesRunTime.boxToInteger((int)differenceInWindow), s.writeBlock()));
                        }), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)t -> {
                            Tuple3 tuple3 = t;
                            if (tuple3 == null) {
                                throw new MatchError((Object)tuple3);
                            }
                            H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple3._1();
                            int difference = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            Deferred oldWriteBlock = (Deferred)tuple3._3();
                            Tuple3 $6$ = tuple3;
                            Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)$6$, (Object)settings, (Object)BoxesRunTime.boxToInteger((int)difference), (Object)oldWriteBlock);
                            Tuple3 $6$2 = (Tuple3)tuple4._1();
                            H2Frame.Settings.ConnectionSettings settings2 = (H2Frame.Settings.ConnectionSettings)tuple4._2();
                            int difference2 = BoxesRunTime.unboxToInt((Object)tuple4._3());
                            Deferred oldWriteBlock2 = (Deferred)tuple4._4();
                            return Tuple2$.MODULE$.apply(t, (Object)$6$2);
                        }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                            Tuple2 tuple2 = x$12;
                            if (tuple2 != null) {
                                Tuple3 tuple3 = (Tuple3)tuple2._2();
                                Tuple3 t = (Tuple3)tuple2._1();
                                if (tuple3 != null) {
                                    H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple3._1();
                                    int difference = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                    Deferred oldWriteBlock = (Deferred)tuple3._3();
                                    return package.all$.MODULE$.toFlatMapOps(oldWriteBlock.complete((Object)EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> this.processFrame$1$$anonfun$33$$anonfun$3$$anonfun$1(difference, settings, BoxesRunTime.unboxToBoolean((Object)x$1)));
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }));
                    }
                    if (bl) {
                        return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Connection$$F).unit();
                    }
                }
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$34), this.org$http4s$ember$core$h2$H2Connection$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$35, this.org$http4s$ember$core$h2$H2Connection$$F);
            }
            if (h2Frame instanceof H2Frame.GoAway) {
                H2Frame.GoAway goAway = (H2Frame.GoAway)h2Frame;
                H2Frame.GoAway goAway2 = H2Frame$GoAway$.MODULE$.unapply(goAway);
                int n = goAway2._1();
                int n14 = goAway2._2();
                Integer n15 = goAway2._3();
                Option<ByteVector> option = goAway2._4();
                if (0 == n) {
                    H2Frame.GoAway g = goAway;
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)m -> package.all$.MODULE$.toFoldableOps((Object)m.values().toList(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_((Function1 & Serializable)connection -> connection.receiveGoAway(g), this.org$http4s$ember$core$h2$H2Connection$$F)), this.org$http4s$ember$core$h2$H2Connection$$F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$37, this.org$http4s$ember$core$h2$H2Connection$$F);
                }
                return this.goAway(H2Error$ProtocolError$.MODULE$);
            }
            if (h2Frame instanceof H2Frame.Ping) {
                H2Frame.Ping ping = H2Frame$Ping$.MODULE$.unapply((H2Frame.Ping)h2Frame);
                int n = ping._1();
                boolean bl = ping._2();
                ByteVector byteVector = ping._3();
                if (0 == n) {
                    if (!bl) {
                        ByteVector bv = byteVector;
                        return this.outgoing().offer((Object)Chunk$.MODULE$.singleton((Object)H2Frame$Ping$.MODULE$.ack().copy(H2Frame$Ping$.MODULE$.ack().copy$default$1(), H2Frame$Ping$.MODULE$.ack().copy$default$2(), bv)));
                    }
                    if (bl) {
                        return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Connection$$F).unit();
                    }
                }
                return this.goAway(H2Error$ProtocolError$.MODULE$);
            }
            if (h2Frame instanceof H2Frame.WindowUpdate) {
                H2Frame.WindowUpdate windowUpdate = (H2Frame.WindowUpdate)h2Frame;
                H2Frame.WindowUpdate windowUpdate2 = H2Frame$WindowUpdate$.MODULE$.unapply(windowUpdate);
                int n = windowUpdate2._1();
                int n16 = windowUpdate2._2();
                if (0 == n16) {
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$38), this.org$http4s$ember$core$h2$H2Connection$$F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$39, this.org$http4s$ember$core$h2$H2Connection$$F);
                }
                int i = n;
                int size = n16;
                H2Frame.WindowUpdate w = windowUpdate;
                int n17 = i;
                if (0 == n17) {
                    return package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)newWriteBlock -> package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.state().modify((Function1 & Serializable)s -> {
                        int newSize = s.writeWindow() + size;
                        boolean sizeValid = s.writeWindow() >= 0 && newSize >= 0 || s.writeWindow() < 0;
                        int n = s.writeWindow() + size;
                        H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                        int n2 = s.copy$default$4();
                        int n3 = s.copy$default$5();
                        int n4 = s.copy$default$6();
                        boolean bl = s.copy$default$7();
                        Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = s.copy$default$8();
                        Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option2 = s.copy$default$9();
                        return Tuple2$.MODULE$.apply(s.copy(connectionSettings, n, newWriteBlock, n2, n3, n4, bl, option, option2), (Object)Tuple2$.MODULE$.apply(s.writeBlock(), (Object)BoxesRunTime.boxToBoolean((boolean)sizeValid)));
                    }), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)t -> {
                        Tuple2 tuple2 = t;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deferred oldWriteBlock = (Deferred)tuple2._1();
                        boolean valid = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                        Tuple2 $8$ = tuple2;
                        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$8$, (Object)oldWriteBlock, (Object)BoxesRunTime.boxToBoolean((boolean)valid));
                        Tuple2 $8$2 = (Tuple2)tuple3._1();
                        Deferred oldWriteBlock2 = (Deferred)tuple3._2();
                        boolean valid2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                        return Tuple2$.MODULE$.apply(t, (Object)$8$2);
                    }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                        Tuple2 tuple2 = x$12;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            Tuple2 t = (Tuple2)tuple2._1();
                            if (tuple22 != null) {
                                Deferred oldWriteBlock = (Deferred)tuple22._1();
                                boolean valid = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
                                return package.all$.MODULE$.toFlatMapOps(oldWriteBlock.complete((Object)EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> this.processFrame$1$$anonfun$40$$anonfun$3$$anonfun$1(valid, BoxesRunTime.unboxToBoolean((Object)x$1)));
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }));
                }
                int otherwise = n17;
                return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$16 -> _$16.get((Object)BoxesRunTime.boxToInteger((int)otherwise))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        H2Stream s = (H2Stream)((Some)option).value();
                        return s.receiveWindowUpdate(w);
                    }
                    if (None$.MODULE$.equals(option)) {
                        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(() -> H2Connection.processFrame$1$$anonfun$42$$anonfun$1(w, i)), this.org$http4s$ember$core$h2$H2Connection$$F);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$42$$anonfun$2, this.org$http4s$ember$core$h2$H2Connection$$F);
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (h2Frame instanceof H2Frame.Data) {
                H2Frame.Data data = (H2Frame.Data)h2Frame;
                H2Frame.Data data2 = H2Frame$Data$.MODULE$.unapply(data);
                int n = data2._1();
                ByteVector byteVector = data2._2();
                Option<ByteVector> option = data2._3();
                boolean bl = data2._4();
                int i = n;
                ByteVector data3 = byteVector;
                H2Frame.Data d = data;
                int size = (int)data3.size();
                if (size > this.localSettings.maxFrameSize().frameSize()) {
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(H2Connection::processFrame$1$$anonfun$43), this.org$http4s$ember$core$h2$H2Connection$$F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$44, this.org$http4s$ember$core$h2$H2Connection$$F);
                }
                return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$17 -> _$17.get((Object)BoxesRunTime.boxToInteger((int)i))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        H2Stream s = (H2Stream)((Some)option).value();
                        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.state().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)st -> {
                            int newSize = st.readWindow() - (int)d.data().size();
                            boolean needsWindowUpdate = newSize <= Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()) / 2;
                            return Tuple3$.MODULE$.apply(st, (Object)BoxesRunTime.boxToInteger((int)newSize), (Object)BoxesRunTime.boxToBoolean((boolean)needsWindowUpdate));
                        }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                            Tuple3 tuple3 = x$12;
                            if (tuple3 != null) {
                                State st = (State)tuple3._1();
                                int newSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                boolean needsWindowUpdate = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                                return package.all$.MODULE$.toFlatMapOps(this.state().update((Function1 & Serializable)s -> {
                                    int n = needsWindowUpdate ? Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()) : newSize;
                                    H2Frame.Settings.ConnectionSettings connectionSettings = s.copy$default$1();
                                    int n2 = s.copy$default$2();
                                    Deferred deferred = s.copy$default$3();
                                    int n3 = s.copy$default$5();
                                    int n4 = s.copy$default$6();
                                    boolean bl = s.copy$default$7();
                                    Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = s.copy$default$8();
                                    Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option2 = s.copy$default$9();
                                    return s.copy(connectionSettings, n2, deferred, n, n3, n4, bl, option, option2);
                                }), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return package.all$.MODULE$.toFlatMapOps(needsWindowUpdate ? this.outgoing().offer((Object)Chunk$.MODULE$.singleton((Object)H2Frame$WindowUpdate$.MODULE$.apply(0, Predef$.MODULE$.Integer2int(st.remoteSettings().initialWindowSize().windowSize()) - newSize))) : Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Connection$$F).unit(), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$12 -> {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return package.all$.MODULE$.toFunctorOps(s.receiveData(d), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        });
                                    });
                                });
                            }
                            throw new MatchError((Object)tuple3);
                        });
                    }
                    if (None$.MODULE$.equals(option)) {
                        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(() -> H2Connection.processFrame$1$$anonfun$46$$anonfun$3(i)), this.org$http4s$ember$core$h2$H2Connection$$F);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$46$$anonfun$4, this.org$http4s$ember$core$h2$H2Connection$$F);
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (h2Frame instanceof H2Frame.RstStream) {
                H2Frame.RstStream rstStream = (H2Frame.RstStream)h2Frame;
                H2Frame.RstStream rstStream2 = H2Frame$RstStream$.MODULE$.unapply(rstStream);
                int n = rstStream2._1();
                Integer n18 = rstStream2._2();
                int i = n;
                H2Frame.RstStream rst = rstStream;
                return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.mapRef().get(), this.org$http4s$ember$core$h2$H2Connection$$F).map((Function1 & Serializable)_$18 -> _$18.get((Object)BoxesRunTime.boxToInteger((int)i))), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        H2Stream s = (H2Stream)((Some)option).value();
                        return s.receiveRstStream(rst);
                    }
                    if (None$.MODULE$.equals(option)) {
                        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.warn(() -> H2Connection.processFrame$1$$anonfun$48$$anonfun$1(i)), this.org$http4s$ember$core$h2$H2Connection$$F);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::processFrame$1$$anonfun$48$$anonfun$2, this.org$http4s$ember$core$h2$H2Connection$$F);
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (h2Frame instanceof H2Frame.Priority) {
                H2Frame.Priority priority = H2Frame$Priority$.MODULE$.unapply((H2Frame.Priority)h2Frame);
                int n = priority._1();
                boolean bl = priority._2();
                int n19 = priority._3();
                byte by = priority._4();
                int i = n;
                int i2 = n19;
                if (i == i2) {
                    return this.goAway(H2Error$ProtocolError$.MODULE$);
                }
                return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Connection$$F).unit();
            }
            if (h2Frame instanceof H2Frame.Unknown) {
                H2Frame.Unknown unknown = H2Frame$Unknown$.MODULE$.unapply((H2Frame.Unknown)h2Frame);
                H2Frame.RawFrame rawFrame = unknown._1();
                return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Connection$$F).unit();
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final String readLoopAux$1$$anonfun$1$$anonfun$1(H2Frame frame$3) {
        return new StringBuilder(8).append(this.addrStr()).append(" Read - ").append(frame$3).toString();
    }

    private final Object readLoopAux$1$$anonfun$1$$anonfun$2(H2Frame frame$4) {
        return package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)_$19 -> this.processFrame$1(frame$4, (State)_$19));
    }

    private final Object readLoopAux$1$$anonfun$1$$anonfun$3(ByteVector nacc$1, Object readFromSocket$3) {
        return this.readLoopAux$1(readFromSocket$3, nacc$1);
    }

    private final Object readLoopAux$1(Object readFromSocket$5, ByteVector acc) {
        return package.all$.MODULE$.toFlatMapOps(this.readNextFrame$1(readFromSocket$5, acc), this.org$http4s$ember$core$h2$H2Connection$$F).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                H2Frame frame = (H2Frame)tuple2._1();
                ByteVector nacc = (ByteVector)tuple2._2();
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.logger.debug(() -> this.readLoopAux$1$$anonfun$1$$anonfun$1(frame)), this.org$http4s$ember$core$h2$H2Connection$$F);
                Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.readLoopAux$1$$anonfun$1$$anonfun$2(frame), this.org$http4s$ember$core$h2$H2Connection$$F), this.org$http4s$ember$core$h2$H2Connection$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.readLoopAux$1$$anonfun$1$$anonfun$3(nacc, readFromSocket$5), this.org$http4s$ember$core$h2$H2Connection$$F);
            }
            if (None$.MODULE$.equals(option)) {
                return this.org$http4s$ember$core$h2$H2Connection$$F.unit();
            }
            throw new MatchError((Object)option);
        });
    }

    private static final String readLoop$$anonfun$1$$anonfun$1() {
        return "ReadLoop has received that is should kill";
    }

    private final Object readLoop$$anonfun$1$$anonfun$2() {
        return this.state().update((Function1 & Serializable)s -> s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), true, s.copy$default$8(), s.copy$default$9()));
    }

    private static final String readLoop$$anonfun$1$$anonfun$3() {
        return "ReadLoop has errored";
    }

    private final Object readLoop$$anonfun$1$$anonfun$4() {
        return this.goAway(H2Error$InternalError$.MODULE$);
    }

    private final Object readLoop$$anonfun$1$$anonfun$5() {
        return this.state().update((Function1 & Serializable)s -> s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), true, s.copy$default$8(), s.copy$default$9()));
    }

    public static interface ConnectionType {
        public static int ordinal(ConnectionType connectionType) {
            return H2Connection$ConnectionType$.MODULE$.ordinal(connectionType);
        }
    }

    public static final class KillWithoutMessage
    extends RuntimeException
    implements NoStackTrace,
    Product {
        public static KillWithoutMessage apply() {
            return H2Connection$KillWithoutMessage$.MODULE$.apply();
        }

        public static KillWithoutMessage fromProduct(Product product) {
            return H2Connection$KillWithoutMessage$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(KillWithoutMessage killWithoutMessage) {
            return H2Connection$KillWithoutMessage$.MODULE$.unapply(killWithoutMessage);
        }

        public KillWithoutMessage() {
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof KillWithoutMessage)) return false;
            KillWithoutMessage killWithoutMessage = (KillWithoutMessage)object;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof KillWithoutMessage;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "KillWithoutMessage";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KillWithoutMessage copy() {
            return new KillWithoutMessage();
        }
    }

    public static final class State<F>
    implements Product,
    Serializable {
        private final H2Frame.Settings.ConnectionSettings remoteSettings;
        private final int writeWindow;
        private final Deferred writeBlock;
        private final int readWindow;
        private final int highestStream;
        private final int remoteHighestStream;
        private final boolean closed;
        private final Option headersInProgress;
        private final Option pushPromiseInProgress;

        public static <F> State<F> apply(H2Frame.Settings.ConnectionSettings connectionSettings, int n, Deferred<F, Either<Throwable, BoxedUnit>> deferred, int n2, int n3, int n4, boolean bl, Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option, Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option2) {
            return H2Connection$State$.MODULE$.apply(connectionSettings, n, deferred, n2, n3, n4, bl, option, option2);
        }

        public static State<?> fromProduct(Product product) {
            return H2Connection$State$.MODULE$.fromProduct(product);
        }

        public static <F> State<F> unapply(State<F> state) {
            return H2Connection$State$.MODULE$.unapply(state);
        }

        public State(H2Frame.Settings.ConnectionSettings remoteSettings, int writeWindow, Deferred<F, Either<Throwable, BoxedUnit>> writeBlock, int readWindow, int highestStream, int remoteHighestStream, boolean closed, Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> headersInProgress, Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> pushPromiseInProgress) {
            this.remoteSettings = remoteSettings;
            this.writeWindow = writeWindow;
            this.writeBlock = writeBlock;
            this.readWindow = readWindow;
            this.highestStream = highestStream;
            this.remoteHighestStream = remoteHighestStream;
            this.closed = closed;
            this.headersInProgress = headersInProgress;
            this.pushPromiseInProgress = pushPromiseInProgress;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteSettings()));
            n = Statics.mix((int)n, (int)this.writeWindow());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.writeBlock()));
            n = Statics.mix((int)n, (int)this.readWindow());
            n = Statics.mix((int)n, (int)this.highestStream());
            n = Statics.mix((int)n, (int)this.remoteHighestStream());
            n = Statics.mix((int)n, (int)(this.closed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.headersInProgress()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.pushPromiseInProgress()));
            return Statics.finalizeHash((int)n, (int)9);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.writeWindow() != state.writeWindow()) return false;
            if (this.readWindow() != state.readWindow()) return false;
            if (this.highestStream() != state.highestStream()) return false;
            if (this.remoteHighestStream() != state.remoteHighestStream()) return false;
            if (this.closed() != state.closed()) return false;
            H2Frame.Settings.ConnectionSettings connectionSettings = this.remoteSettings();
            H2Frame.Settings.ConnectionSettings connectionSettings2 = state.remoteSettings();
            if (connectionSettings == null) {
                if (connectionSettings2 != null) {
                    return false;
                }
            } else if (!((Object)connectionSettings).equals(connectionSettings2)) return false;
            Deferred<F, Either<Throwable, BoxedUnit>> deferred = this.writeBlock();
            Deferred<F, Either<Throwable, BoxedUnit>> deferred2 = state.writeBlock();
            if (deferred == null) {
                if (deferred2 != null) {
                    return false;
                }
            } else if (!deferred.equals(deferred2)) return false;
            Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option = this.headersInProgress();
            Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> option2 = state.headersInProgress();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option3 = this.pushPromiseInProgress();
            Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> option4 = state.pushPromiseInProgress();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 9;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this._7());
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "remoteSettings";
                }
                case 1: {
                    return "writeWindow";
                }
                case 2: {
                    return "writeBlock";
                }
                case 3: {
                    return "readWindow";
                }
                case 4: {
                    return "highestStream";
                }
                case 5: {
                    return "remoteHighestStream";
                }
                case 6: {
                    return "closed";
                }
                case 7: {
                    return "headersInProgress";
                }
                case 8: {
                    return "pushPromiseInProgress";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public H2Frame.Settings.ConnectionSettings remoteSettings() {
            return this.remoteSettings;
        }

        public int writeWindow() {
            return this.writeWindow;
        }

        public Deferred<F, Either<Throwable, BoxedUnit>> writeBlock() {
            return this.writeBlock;
        }

        public int readWindow() {
            return this.readWindow;
        }

        public int highestStream() {
            return this.highestStream;
        }

        public int remoteHighestStream() {
            return this.remoteHighestStream;
        }

        public boolean closed() {
            return this.closed;
        }

        public Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> headersInProgress() {
            return this.headersInProgress;
        }

        public Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> pushPromiseInProgress() {
            return this.pushPromiseInProgress;
        }

        public <F> State<F> copy(H2Frame.Settings.ConnectionSettings remoteSettings, int writeWindow, Deferred<F, Either<Throwable, BoxedUnit>> writeBlock, int readWindow, int highestStream, int remoteHighestStream, boolean closed, Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> headersInProgress, Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> pushPromiseInProgress) {
            return new State<F>(remoteSettings, writeWindow, writeBlock, readWindow, highestStream, remoteHighestStream, closed, headersInProgress, pushPromiseInProgress);
        }

        public <F> H2Frame.Settings.ConnectionSettings copy$default$1() {
            return this.remoteSettings();
        }

        public int copy$default$2() {
            return this.writeWindow();
        }

        public <F> Deferred<F, Either<Throwable, BoxedUnit>> copy$default$3() {
            return this.writeBlock();
        }

        public int copy$default$4() {
            return this.readWindow();
        }

        public int copy$default$5() {
            return this.highestStream();
        }

        public int copy$default$6() {
            return this.remoteHighestStream();
        }

        public boolean copy$default$7() {
            return this.closed();
        }

        public <F> Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> copy$default$8() {
            return this.headersInProgress();
        }

        public <F> Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> copy$default$9() {
            return this.pushPromiseInProgress();
        }

        public H2Frame.Settings.ConnectionSettings _1() {
            return this.remoteSettings();
        }

        public int _2() {
            return this.writeWindow();
        }

        public Deferred<F, Either<Throwable, BoxedUnit>> _3() {
            return this.writeBlock();
        }

        public int _4() {
            return this.readWindow();
        }

        public int _5() {
            return this.highestStream();
        }

        public int _6() {
            return this.remoteHighestStream();
        }

        public boolean _7() {
            return this.closed();
        }

        public Option<Tuple2<H2Frame.Headers, List<H2Frame.Continuation>>> _8() {
            return this.headersInProgress();
        }

        public Option<Tuple2<H2Frame.PushPromise, List<H2Frame.Continuation>>> _9() {
            return this.pushPromiseInProgress();
        }
    }
}

