/*
 * Decompiled with CFR 0.152.
 */
package sharry.store;

import binny.AttributeName$;
import binny.BinaryId;
import binny.BinaryId$;
import binny.ByteRange;
import binny.ChunkDef;
import binny.ChunkedBinaryStore;
import binny.Hint;
import binny.InsertChunkResult;
import cats.data.OptionT;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import doobie.util.transactor;
import fs2.Chunk;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.io.file.Files;
import java.io.Serializable;
import javax.sql.DataSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.runtime.BoxedUnit;
import sharry.common.Ident;
import sharry.common.Timestamp;
import sharry.store.ComputeChecksum;
import sharry.store.ComputeChecksumConfig;
import sharry.store.FileStore$;
import sharry.store.FileStoreConfig;
import sharry.store.doobie.AttributeStore;
import sharry.store.records.RFileMeta;

public interface FileStore<F> {
    public static <F> Object apply(DataSource dataSource, transactor.Transactor<F> transactor2, int n, ComputeChecksumConfig computeChecksumConfig, FileStoreConfig fileStoreConfig, Async<F> async, Files<F> files) {
        return FileStore$.MODULE$.apply(dataSource, transactor2, n, computeChecksumConfig, fileStoreConfig, async, files);
    }

    public int chunkSize();

    public F delete(Ident var1);

    public OptionT<F, RFileMeta> findMeta(Ident var1);

    public OptionT<F, Stream<F, Object>> findBinary(Ident var1, ByteRange var2);

    public F insert(Stream<F, Object> var1, Hint var2, Timestamp var3);

    public F insertMeta(RFileMeta var1);

    public F updateChecksum(RFileMeta var1);

    public F addChunk(Ident var1, Hint var2, ChunkDef var3, Chunk<Object> var4);

    public ComputeChecksum<F> computeAttributes();

    public Function1<FileStoreConfig, F> createBinaryStore();

    public static final class Impl<F>
    implements FileStore<F> {
        private final ChunkedBinaryStore<F> bs;
        private final AttributeStore<F> attrStore;
        private final int chunkSize;
        private final ComputeChecksum<F> computeAttributes;
        private final Function1<FileStoreConfig, F> createBinaryStore;
        private final Sync<F> evidence$1;

        public Impl(ChunkedBinaryStore<F> bs, AttributeStore<F> attrStore, int chunkSize, ComputeChecksum<F> computeAttributes, Function1<FileStoreConfig, Object> createBinaryStore, Sync<F> evidence$1) {
            this.bs = bs;
            this.attrStore = attrStore;
            this.chunkSize = chunkSize;
            this.computeAttributes = computeAttributes;
            this.createBinaryStore = createBinaryStore;
            this.evidence$1 = evidence$1;
        }

        @Override
        public int chunkSize() {
            return this.chunkSize;
        }

        @Override
        public ComputeChecksum<F> computeAttributes() {
            return this.computeAttributes;
        }

        @Override
        public Function1<FileStoreConfig, F> createBinaryStore() {
            return this.createBinaryStore;
        }

        @Override
        public F delete(Ident id) {
            return (F)this.bs.delete(BinaryId$.MODULE$.apply(id.id()));
        }

        @Override
        public OptionT<F, RFileMeta> findMeta(Ident id) {
            return this.attrStore.findMeta(BinaryId$.MODULE$.apply(id.id()));
        }

        @Override
        public OptionT<F, Stream<F, Object>> findBinary(Ident id, ByteRange range) {
            return this.bs.findBinary(BinaryId$.MODULE$.apply(id.id()), range);
        }

        @Override
        public F insert(Stream<F, Object> data, Hint hint, Timestamp created) {
            return (F)data.through(this.bs.insert()).evalMap((Function1 & Serializable)id -> this.insert$$anonfun$1(hint, id == null ? null : ((BinaryId)id).id())).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(this.evidence$1))).lastOrError(this.evidence$1);
        }

        @Override
        public F insertMeta(RFileMeta meta) {
            return this.attrStore.saveMeta(meta);
        }

        @Override
        public F updateChecksum(RFileMeta meta) {
            return this.attrStore.updateChecksum(meta.id(), meta.checksum());
        }

        @Override
        public F addChunk(Ident id, Hint hint, ChunkDef chunkDef, Chunk<Object> data) {
            return (F)implicits$.MODULE$.toFlatMapOps(this.bs.insertChunk(BinaryId$.MODULE$.apply(id.id()), chunkDef, hint, data.toByteVector($less$colon$less$.MODULE$.refl())), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                InsertChunkResult insertChunkResult = x$1;
                if (InsertChunkResult.Complete$.MODULE$.equals(insertChunkResult)) {
                    Object object = implicits$.MODULE$.catsSyntaxApplyOps(this.computeAttributes().submit(BinaryId$.MODULE$.apply(id.id()), hint));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, implicits$.MODULE$.toFlatMapOps(this.computeAttributes().computeSync(BinaryId$.MODULE$.apply(id.id()), hint, AttributeName$.MODULE$.excludeSha256()), this.evidence$1).flatMap((Function1 & Serializable)meta -> this.insertMeta((RFileMeta)meta)), this.evidence$1);
                }
                if (InsertChunkResult.Incomplete$.MODULE$.equals(insertChunkResult)) {
                    BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
                    return ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$1);
                }
                if (insertChunkResult instanceof InsertChunkResult.Failure) {
                    InsertChunkResult.Failure fail = (InsertChunkResult.Failure)insertChunkResult;
                    return package$.MODULE$.Sync().apply(this.evidence$1).raiseError((Object)new Exception(new StringBuilder(24).append("Inserting chunk failed: ").append(fail).toString()));
                }
                throw new MatchError((Object)insertChunkResult);
            });
        }

        private final /* synthetic */ Object insert$$anonfun$1(Hint hint$1, String id) {
            Object object = implicits$.MODULE$.catsSyntaxApplyOps(this.computeAttributes().submit(id, hint$1));
            return ApplyOps$.MODULE$.$times$greater$extension(object, implicits$.MODULE$.toFlatMapOps(this.computeAttributes().computeSync(id, hint$1, AttributeName$.MODULE$.excludeSha256()), this.evidence$1).flatTap((Function1 & Serializable)meta -> this.insertMeta((RFileMeta)meta)), this.evidence$1);
        }
    }
}

