/*
 * Decompiled with CFR 0.152.
 */
package sharry.backend.account;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.Traverse;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.free.Free;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import fs2.Stream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import sharry.backend.PasswordCrypt$;
import sharry.backend.account.NewAccount;
import sharry.backend.account.OAccount;
import sharry.backend.account.Queries$;
import sharry.common.AccountId;
import sharry.common.AccountSource;
import sharry.common.AccountState;
import sharry.common.CIIdent$;
import sharry.common.Ident;
import sharry.common.Password;
import sharry.common.Timestamp;
import sharry.common.Timestamp$;
import sharry.logging.Logger;
import sharry.store.AddResult;
import sharry.store.AddResult$;
import sharry.store.Store;
import sharry.store.records.ModAccount;
import sharry.store.records.RAccount;
import sharry.store.records.RAccount$;
import sharry.store.records.RShare$;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Pkg$;

public final class OAccount$
implements Serializable {
    public static final OAccount$ MODULE$ = new OAccount$();

    private OAccount$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(OAccount$.class);
    }

    public <F> Resource<F, OAccount<F>> apply(Store<F> store, Async<F> evidence$1) {
        return package$.MODULE$.Resource().pure((Object)new OAccount<F>(evidence$1, store){
            private final Store store$2;
            private final Async evidence$1$2;
            private final Logger logger;
            {
                this.store$2 = store$1;
                this.evidence$1$2 = evidence$1$1;
                this.logger = sharry.logging.package$.MODULE$.getLogger((Sync)evidence$1$1, Enclosing$.MODULE$.apply("sharry.backend.account.OAccount.apply logger"));
            }

            public Object changePassword(Ident id, String oldPw, String newPw) {
                Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.store$2.transact(RAccount$.MODULE$.updatePassword(id, PasswordCrypt$.MODULE$.crypt(newPw))), (ApplicativeError)this.evidence$1$2);
                Object update = implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)this.evidence$1$2), (Functor)this.evidence$1$2).map(OAccount$::sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$1);
                AddResult.Failure wrongPassword = AddResult.Failure$.MODULE$.apply((Throwable)new Exception("Password is wrong."));
                AddResult.Failure notInternal = AddResult.Failure$.MODULE$.apply((Throwable)new Exception("Not an internal account."));
                OptionT change = OptionT$.MODULE$.apply(this.findById(id)).map(arg_0 -> OAccount$.sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$2(oldPw, arg_0), (Functor)this.evidence$1$2).flatMap(arg_0 -> this.$anonfun$3((AddResult)notInternal, (AddResult)wrongPassword, update, arg_0), (Monad)this.evidence$1$2);
                return change.getOrElse(OAccount$::sharry$backend$account$OAccount$$anon$1$$_$changePassword$$anonfun$1, (Functor)this.evidence$1$2);
            }

            public OptionT delete(Ident id) {
                return OptionT$.MODULE$.liftF(this.logger.info(() -> OAccount$.sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$1(id), Pkg$.MODULE$.apply("sharry.backend.account"), FileName$.MODULE$.apply("OAccount.scala"), Name$.MODULE$.apply("delete"), Line$.MODULE$.apply(78)), (Functor)this.evidence$1$2).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return OptionT$.MODULE$.apply(this.store$2.transact(RAccount$.MODULE$.findById(id))).flatMap((Function1 & Serializable)acc -> OptionT$.MODULE$.liftF(this.store$2.transact(RShare$.MODULE$.getAllByAccount(id)), (Functor)this.evidence$1$2).flatMap((Function1 & Serializable)shares -> OptionT$.MODULE$.liftF(this.logger.info(() -> OAccount$.sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(shares, id), Pkg$.MODULE$.apply("sharry.backend.account"), FileName$.MODULE$.apply("OAccount.scala"), Name$.MODULE$.apply("delete"), Line$.MODULE$.apply(81)), (Functor)this.evidence$1$2).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return OptionT$.MODULE$.liftF(implicits$.MODULE$.toTraverseOps(shares, (Traverse)implicits$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)shareId -> sharry.backend.share.Queries$.MODULE$.deleteShare((Ident)shareId, false, this.store$2, this.evidence$1$2), (Applicative)this.evidence$1$2), (Functor)this.evidence$1$2).flatMap((Function1 & Serializable)x$1 -> {
                            Vector vector = x$1;
                            return OptionT$.MODULE$.liftF(this.store$2.transact(RAccount$.MODULE$.delete(id)), (Functor)this.evidence$1$2).map(arg_0 -> OAccount$.sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$adapted$1(acc, arg_0), (Functor)this.evidence$1$2);
                        }, (Monad)this.evidence$1$2);
                    }, (Monad)this.evidence$1$2), (Monad)this.evidence$1$2), (Monad)this.evidence$1$2);
                }, (Monad)this.evidence$1$2);
            }

            public Object setEmail(Ident id, Option email) {
                Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.store$2.transact(RAccount$.MODULE$.setEmail(id, email)), (ApplicativeError)this.evidence$1$2);
                return implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)this.evidence$1$2), (Functor)this.evidence$1$2).map(OAccount$::sharry$backend$account$OAccount$$anon$1$$_$setEmail$$anonfun$1);
            }

            public Object findByLogin(Ident login) {
                return this.store$2.transact(RAccount$.MODULE$.findByLogin(login));
            }

            public Object findById(Ident id) {
                return this.store$2.transact(RAccount$.MODULE$.findById(id));
            }

            public Object findDetailById(Ident id) {
                return this.store$2.transact(Queries$.MODULE$.findById(id));
            }

            public Stream findAccounts(String loginQuery) {
                return this.store$2.transact(Queries$.MODULE$.findAll(loginQuery));
            }

            public Object modify(Ident id, ModAccount acc) {
                Option option = acc.password().map(OAccount$::sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$adapted$1);
                AccountState accountState = acc.copy$default$1();
                boolean bl = acc.copy$default$2();
                Option option2 = acc.copy$default$3();
                Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.store$2.transact(RAccount$.MODULE$.update(id, acc.copy(accountState, bl, option2, option))), (ApplicativeError)this.evidence$1$2);
                return implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)this.evidence$1$2), (Functor)this.evidence$1$2).map(OAccount$::sharry$backend$account$OAccount$$anon$1$$_$modify$$anonfun$1);
            }

            public Object create(NewAccount acc) {
                String pw = PasswordCrypt$.MODULE$.crypt(acc.password());
                Object makeRecord = implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(Timestamp$.MODULE$.current((Sync)this.evidence$1$2), (Functor)this.evidence$1$2).map(arg_0 -> OAccount$.sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$5(acc, pw, arg_0)), (Functor)this.evidence$1$2).map(OAccount$::sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$6);
                return acc.validate().fold((Function1 & Serializable)err -> {
                    AddResult addResult = (AddResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)AddResult.Failure$.MODULE$.apply((Throwable)new Exception((String)err)));
                    return ApplicativeIdOps$.MODULE$.pure$extension((Object)addResult, (Applicative)this.evidence$1$2);
                }, (Function1 & Serializable)_$3 -> {
                    String msg = new StringBuilder(30).append("The account '").append(acc.login().id()).append("' already exists.").toString();
                    return implicits$.MODULE$.toFlatMapOps(makeRecord, (FlatMap)this.evidence$1$2).flatMap((Function1 & Serializable)acc -> implicits$.MODULE$.toFunctorOps(this.store$2.add(OAccount$.sharry$backend$account$OAccount$$anon$1$$_$insert$1(acc), OAccount$.sharry$backend$account$OAccount$$anon$1$$_$accountExists$1(acc)), (Functor)this.evidence$1$2).map(arg_0 -> OAccount$.sharry$backend$account$OAccount$$anon$1$$_$create$$anonfun$2$$anonfun$1$$anonfun$1(msg, arg_0)));
                });
            }

            public Object updateLoginStats(AccountId acc) {
                return implicits$.MODULE$.toFunctorOps(this.store$2.transact(RAccount$.MODULE$.updateStatsById(acc.id())), (Functor)this.evidence$1$2).map((Function1)((JFunction1.mcVI.sp & Serializable)OAccount$::sharry$backend$account$OAccount$$anon$1$$_$updateLoginStats$$anonfun$1));
            }

            public Object createIfMissing(NewAccount acc) {
                return implicits$.MODULE$.toFlatMapOps(this.create(acc), (FlatMap)this.evidence$1$2).flatMap((Function1 & Serializable)x$12 -> {
                    AddResult addResult = x$12;
                    if (AddResult.Success$.MODULE$.equals(addResult)) {
                        return implicits$.MODULE$.toFlatMapOps(this.store$2.transact(RAccount$.MODULE$.findByLogin(acc.login())), (FlatMap)this.evidence$1$2).flatMap((Function1 & Serializable)x$1 -> {
                            Option option = x$1;
                            if (option instanceof Some) {
                                RAccount a = (RAccount)((Some)option).value();
                                RAccount rAccount = (RAccount)implicits$.MODULE$.catsSyntaxApplicativeId((Object)a);
                                return ApplicativeIdOps$.MODULE$.pure$extension((Object)rAccount, (Applicative)this.evidence$1$2);
                            }
                            if (None$.MODULE$.equals(option)) {
                                return package$.MODULE$.Async().apply(this.evidence$1$2).raiseError((Object)new Exception("Currently saved account not found!"));
                            }
                            throw new MatchError((Object)option);
                        });
                    }
                    if (addResult instanceof AddResult.EntityExists) {
                        String string;
                        AddResult.EntityExists entityExists = AddResult.EntityExists$.MODULE$.unapply((AddResult.EntityExists)addResult);
                        String msg = string = entityExists._1();
                        Object object = implicits$.MODULE$.catsSyntaxApplyOps(this.logger.debug(() -> OAccount$.sharry$backend$account$OAccount$$anon$1$$_$createIfMissing$$anonfun$1$$anonfun$2(msg), Pkg$.MODULE$.apply("sharry.backend.account"), FileName$.MODULE$.apply("OAccount.scala"), Name$.MODULE$.apply("createIfMissing"), Line$.MODULE$.apply(164)));
                        return ApplyOps$.MODULE$.$times$greater$extension(object, implicits$.MODULE$.toFlatMapOps(this.store$2.transact(RAccount$.MODULE$.findByLogin(acc.login())), (FlatMap)this.evidence$1$2).flatMap((Function1 & Serializable)x$1 -> {
                            Option option = x$1;
                            if (option instanceof Some) {
                                RAccount a = (RAccount)((Some)option).value();
                                RAccount rAccount = (RAccount)implicits$.MODULE$.catsSyntaxApplicativeId((Object)a);
                                return ApplicativeIdOps$.MODULE$.pure$extension((Object)rAccount, (Applicative)this.evidence$1$2);
                            }
                            if (None$.MODULE$.equals(option)) {
                                return package$.MODULE$.Async().apply(this.evidence$1$2).raiseError((Object)new Exception("Currently saved account not found!"));
                            }
                            throw new MatchError((Object)option);
                        }), (Apply)this.evidence$1$2);
                    }
                    if (addResult instanceof AddResult.Failure) {
                        Throwable throwable;
                        AddResult.Failure failure = AddResult.Failure$.MODULE$.unapply((AddResult.Failure)addResult);
                        Throwable ex = throwable = failure._1();
                        return package$.MODULE$.Async().apply(this.evidence$1$2).raiseError((Object)ex);
                    }
                    throw new MatchError((Object)addResult);
                });
            }

            public OptionT findByAlias(Ident alias) {
                return OptionT$.MODULE$.apply(this.store$2.transact(RAccount$.MODULE$.findByAlias(alias)));
            }

            private final /* synthetic */ OptionT $anonfun$3(AddResult notInternal$1, AddResult wrongPassword$1, Object update$1, Tuple3 x$1) {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    OptionT optionT;
                    RAccount acc = (RAccount)tuple3._1();
                    boolean pwmatch = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                    boolean intern = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                    if (!intern) {
                        boolean bl = OptionT$.MODULE$.some();
                        optionT = OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)notInternal$1, (Applicative)this.evidence$1$2);
                    } else if (!pwmatch) {
                        boolean bl = OptionT$.MODULE$.some();
                        optionT = OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)wrongPassword$1, (Applicative)this.evidence$1$2);
                    } else {
                        optionT = OptionT$.MODULE$.liftF(update$1, (Functor)this.evidence$1$2);
                    }
                    return optionT.map(OAccount$::sharry$backend$account$OAccount$$anon$1$$_$$anonfun$3$$anonfun$1, (Functor)this.evidence$1$2);
                }
                throw new MatchError((Object)tuple3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$1(scala.util.Either ), sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$2(java.lang.String sharry.store.records.RAccount ), $anonfun$3(sharry.store.AddResult sharry.store.AddResult java.lang.Object scala.Tuple3 ), sharry$backend$account$OAccount$$anon$1$$_$changePassword$$anonfun$1(), sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$1(sharry.common.Ident ), delete$$anonfun$2(sharry.common.Ident scala.runtime.BoxedUnit ), sharry$backend$account$OAccount$$anon$1$$_$setEmail$$anonfun$1(scala.util.Either ), sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$adapted$1(java.lang.Object ), sharry$backend$account$OAccount$$anon$1$$_$modify$$anonfun$1(scala.util.Either ), sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$5(sharry.backend.account.NewAccount java.lang.String sharry.common.Timestamp ), sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$6(scala.Tuple2 ), create$$anonfun$1(java.lang.String ), create$$anonfun$2(sharry.backend.account.NewAccount java.lang.Object sharry.backend.account.NewAccount ), sharry$backend$account$OAccount$$anon$1$$_$updateLoginStats$$anonfun$1(int ), createIfMissing$$anonfun$1(sharry.backend.account.NewAccount sharry.store.AddResult ), sharry$backend$account$OAccount$$anon$1$$_$$anonfun$3$$anonfun$1(sharry.store.AddResult ), sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$adapted$1(sharry.store.records.RAccount java.lang.Object ), delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(sharry.common.Ident ), delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(sharry.common.Ident sharry.store.records.RAccount scala.collection.immutable.Vector ), sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.immutable.Vector sharry.common.Ident ), delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(scala.collection.immutable.Vector sharry.common.Ident sharry.store.records.RAccount scala.runtime.BoxedUnit ), delete$$anonfun$2$$anonfun$1$$anonfun$1(sharry.common.Ident sharry.store.records.RAccount scala.collection.immutable.Vector ), delete$$anonfun$2$$anonfun$1(sharry.common.Ident sharry.store.records.RAccount ), sharry$backend$account$OAccount$$anon$1$$_$create$$anonfun$2$$anonfun$1$$anonfun$1(java.lang.String sharry.store.AddResult ), create$$anonfun$2$$anonfun$1(java.lang.String sharry.backend.account.NewAccount sharry.store.records.RAccount ), createIfMissing$$anonfun$1$$anonfun$1(scala.Option ), sharry$backend$account$OAccount$$anon$1$$_$createIfMissing$$anonfun$1$$anonfun$2(java.lang.String ), createIfMissing$$anonfun$1$$anonfun$3(scala.Option )}, serializedLambda);
            }
        });
    }

    private String cryptPw(String pw) {
        return PasswordCrypt$.MODULE$.crypt(pw);
    }

    public static final /* synthetic */ AddResult sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$1(Either e) {
        return AddResult$.MODULE$.fromUpdateExpectChange("Account not found.", e);
    }

    public static final /* synthetic */ Tuple3 sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$2(String oldPw$1, RAccount acc) {
        boolean pwmatch = PasswordCrypt$.MODULE$.check(oldPw$1, acc.password());
        AccountSource accountSource = acc.source();
        AccountSource.Intern$ intern$ = AccountSource.Intern$.MODULE$;
        boolean intern = !(accountSource != null ? !accountSource.equals(intern$) : intern$ != null);
        return Tuple3$.MODULE$.apply((Object)acc, (Object)BoxesRunTime.boxToBoolean((boolean)pwmatch), (Object)BoxesRunTime.boxToBoolean((boolean)intern));
    }

    public static final /* synthetic */ AddResult sharry$backend$account$OAccount$$anon$1$$_$$anonfun$3$$anonfun$1(AddResult res) {
        return res;
    }

    public static final AddResult sharry$backend$account$OAccount$$anon$1$$_$changePassword$$anonfun$1() {
        return AddResult.Failure$.MODULE$.apply((Throwable)new Exception("Account not found"));
    }

    public static final String sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$1(Ident id$1) {
        return new StringBuilder(15).append("Delete account ").append(id$1).toString();
    }

    public static final String sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Vector shares$1, Ident id$4) {
        return new StringBuilder(26).append("Delete ").append(shares$1.size()).append(" shares of account ").append(id$4).toString();
    }

    private static final /* synthetic */ RAccount delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(RAccount acc$4, int x$1) {
        int n = x$1;
        return acc$4;
    }

    public static /* bridge */ /* synthetic */ RAccount sharry$backend$account$OAccount$$anon$1$$_$delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$adapted$1(RAccount acc$10, Object x$1) {
        return OAccount$.delete$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(acc$10, BoxesRunTime.unboxToInt((Object)x$1));
    }

    public static final /* synthetic */ AddResult sharry$backend$account$OAccount$$anon$1$$_$setEmail$$anonfun$1(Either e) {
        return AddResult$.MODULE$.fromEither(e);
    }

    public static /* bridge */ /* synthetic */ Object sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$adapted$1(Object v1) {
        return new Password(OAccount$.MODULE$.cryptPw(v1 == null ? null : ((Password)v1).pass()));
    }

    public static final /* synthetic */ AddResult sharry$backend$account$OAccount$$anon$1$$_$modify$$anonfun$1(Either e) {
        return AddResult$.MODULE$.fromUpdateExpectChange("Account not found.", e);
    }

    public static final /* synthetic */ Tuple2 sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$5(NewAccount acc$5, String pw$1, Timestamp now) {
        RAccount u = RAccount$.MODULE$.apply(acc$5.id(), CIIdent$.MODULE$.apply(acc$5.login()), acc$5.source(), acc$5.state(), pw$1, acc$5.email(), acc$5.admin(), 0, (Option)None$.MODULE$, now);
        return Tuple2$.MODULE$.apply((Object)now, (Object)u);
    }

    public static final /* synthetic */ RAccount sharry$backend$account$OAccount$$anon$1$$_$_$$anonfun$6(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Timestamp now = (Timestamp)tuple2._1();
            RAccount u = (RAccount)tuple2._2();
            return u;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final Free sharry$backend$account$OAccount$$anon$1$$_$insert$1(RAccount user) {
        return RAccount$.MODULE$.insert(user, "trace");
    }

    public static final Free sharry$backend$account$OAccount$$anon$1$$_$accountExists$1(NewAccount acc$6) {
        return RAccount$.MODULE$.existsByLogin(acc$6.login());
    }

    public static final /* synthetic */ AddResult sharry$backend$account$OAccount$$anon$1$$_$create$$anonfun$2$$anonfun$1$$anonfun$1(String msg$2, AddResult save) {
        return (AddResult)save.fold((Function1 & Serializable)x -> (AddResult)Predef$.MODULE$.identity(x), (Function1 & Serializable)_$4 -> _$4.withMsg(msg$2), (Function1 & Serializable)x -> (AddResult)Predef$.MODULE$.identity(x));
    }

    public static final /* synthetic */ void sharry$backend$account$OAccount$$anon$1$$_$updateLoginStats$$anonfun$1(int _$5) {
    }

    public static final String sharry$backend$account$OAccount$$anon$1$$_$createIfMissing$$anonfun$1$$anonfun$2(String msg$4) {
        return msg$4;
    }
}

