/*
 * Decompiled with CFR 0.152.
 */
package sharry.backend.auth;

import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scodec.bits.ByteVector;
import sharry.backend.auth.AuthConfig$;
import sharry.backend.auth.AuthConfig$Command$;
import sharry.backend.auth.AuthConfig$Fixed$;
import sharry.backend.auth.AuthConfig$Http$;
import sharry.backend.auth.AuthConfig$HttpBasic$;
import sharry.backend.auth.AuthConfig$Internal$;
import sharry.backend.auth.AuthConfig$OAuth$;
import sharry.backend.auth.AuthConfig$Proxy$;
import sharry.common.Duration;
import sharry.common.Ident;
import sharry.common.LenientUri;
import sharry.common.Password;

public class AuthConfig
implements Product,
Serializable {
    private final ByteVector serverSecret;
    private final long sessionValid;
    private final Fixed fixed;
    private final Http http;
    private final HttpBasic httpBasic;
    private final Command command;
    private final Proxy proxy;
    private final Internal internal;
    private final Seq<OAuth> oauth;

    public static AuthConfig apply(ByteVector byteVector, long l, Fixed fixed, Http http, HttpBasic httpBasic, Command command, Proxy proxy, Internal internal, Seq<OAuth> seq) {
        return AuthConfig$.MODULE$.apply(byteVector, l, fixed, http, httpBasic, command, proxy, internal, seq);
    }

    public static AuthConfig fromProduct(Product product) {
        return AuthConfig$.MODULE$.fromProduct(product);
    }

    public static AuthConfig unapply(AuthConfig authConfig) {
        return AuthConfig$.MODULE$.unapply(authConfig);
    }

    public AuthConfig(ByteVector serverSecret, long sessionValid, Fixed fixed, Http http, HttpBasic httpBasic, Command command, Proxy proxy, Internal internal, Seq<OAuth> oauth) {
        this.serverSecret = serverSecret;
        this.sessionValid = sessionValid;
        this.fixed = fixed;
        this.http = http;
        this.httpBasic = httpBasic;
        this.command = command;
        this.proxy = proxy;
        this.internal = internal;
        this.oauth = oauth;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AuthConfig)) return false;
        AuthConfig authConfig = (AuthConfig)object;
        ByteVector byteVector = this.serverSecret();
        ByteVector byteVector2 = authConfig.serverSecret();
        if (byteVector == null) {
            if (byteVector2 != null) {
                return false;
            }
        } else if (!byteVector.equals(byteVector2)) return false;
        if (this.sessionValid() != authConfig.sessionValid()) return false;
        Fixed fixed = this.fixed();
        Fixed fixed2 = authConfig.fixed();
        if (fixed == null) {
            if (fixed2 != null) {
                return false;
            }
        } else if (!((Object)fixed).equals(fixed2)) return false;
        Http http = this.http();
        Http http2 = authConfig.http();
        if (http == null) {
            if (http2 != null) {
                return false;
            }
        } else if (!((Object)http).equals(http2)) return false;
        HttpBasic httpBasic = this.httpBasic();
        HttpBasic httpBasic2 = authConfig.httpBasic();
        if (httpBasic == null) {
            if (httpBasic2 != null) {
                return false;
            }
        } else if (!((Object)httpBasic).equals(httpBasic2)) return false;
        Command command = this.command();
        Command command2 = authConfig.command();
        if (command == null) {
            if (command2 != null) {
                return false;
            }
        } else if (!((Object)command).equals(command2)) return false;
        Proxy proxy = this.proxy();
        Proxy proxy2 = authConfig.proxy();
        if (proxy == null) {
            if (proxy2 != null) {
                return false;
            }
        } else if (!((Object)proxy).equals(proxy2)) return false;
        Internal internal = this.internal();
        Internal internal2 = authConfig.internal();
        if (internal == null) {
            if (internal2 != null) {
                return false;
            }
        } else if (!((Object)internal).equals(internal2)) return false;
        Seq<OAuth> seq = this.oauth();
        Seq<OAuth> seq2 = authConfig.oauth();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!authConfig.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AuthConfig;
    }

    public int productArity() {
        return 9;
    }

    public String productPrefix() {
        return "AuthConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return new Duration(this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "serverSecret";
            }
            case 1: {
                return "sessionValid";
            }
            case 2: {
                return "fixed";
            }
            case 3: {
                return "http";
            }
            case 4: {
                return "httpBasic";
            }
            case 5: {
                return "command";
            }
            case 6: {
                return "proxy";
            }
            case 7: {
                return "internal";
            }
            case 8: {
                return "oauth";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ByteVector serverSecret() {
        return this.serverSecret;
    }

    public long sessionValid() {
        return this.sessionValid;
    }

    public Fixed fixed() {
        return this.fixed;
    }

    public Http http() {
        return this.http;
    }

    public HttpBasic httpBasic() {
        return this.httpBasic;
    }

    public Command command() {
        return this.command;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public Internal internal() {
        return this.internal;
    }

    public Seq<OAuth> oauth() {
        return this.oauth;
    }

    public boolean isOAuthOnly() {
        return this.fixed().disabled() && this.http().disabled() && this.httpBasic().disabled() && this.command().disabled() && this.internal().disabled() && this.proxy().disabled() && this.oauth().exists((Function1 & Serializable)_$1 -> _$1.enabled());
    }

    public boolean isProxyAuthOnly() {
        return this.fixed().disabled() && this.http().disabled() && this.httpBasic().disabled() && this.command().disabled() && this.internal().disabled() && !this.oauth().exists((Function1 & Serializable)_$2 -> _$2.enabled()) && this.proxy().enabled();
    }

    public boolean isAutoLogin() {
        return this.fixed().disabled() && this.http().disabled() && this.httpBasic().disabled() && this.command().disabled() && this.internal().disabled() && (this.oauth().exists((Function1 & Serializable)_$3 -> _$3.enabled()) || this.proxy().enabled());
    }

    public AuthConfig copy(ByteVector serverSecret, long sessionValid, Fixed fixed, Http http, HttpBasic httpBasic, Command command, Proxy proxy, Internal internal, Seq<OAuth> oauth) {
        return new AuthConfig(serverSecret, sessionValid, fixed, http, httpBasic, command, proxy, internal, oauth);
    }

    public ByteVector copy$default$1() {
        return this.serverSecret();
    }

    public long copy$default$2() {
        return this.sessionValid();
    }

    public Fixed copy$default$3() {
        return this.fixed();
    }

    public Http copy$default$4() {
        return this.http();
    }

    public HttpBasic copy$default$5() {
        return this.httpBasic();
    }

    public Command copy$default$6() {
        return this.command();
    }

    public Proxy copy$default$7() {
        return this.proxy();
    }

    public Internal copy$default$8() {
        return this.internal();
    }

    public Seq<OAuth> copy$default$9() {
        return this.oauth();
    }

    public ByteVector _1() {
        return this.serverSecret();
    }

    public long _2() {
        return this.sessionValid();
    }

    public Fixed _3() {
        return this.fixed();
    }

    public Http _4() {
        return this.http();
    }

    public HttpBasic _5() {
        return this.httpBasic();
    }

    public Command _6() {
        return this.command();
    }

    public Proxy _7() {
        return this.proxy();
    }

    public Internal _8() {
        return this.internal();
    }

    public Seq<OAuth> _9() {
        return this.oauth();
    }

    public static class Command
    implements Product,
    Serializable {
        private final boolean enabled;
        private final Seq<String> program;
        private final int success;
        private final int order;

        public static Command apply(boolean bl, Seq<String> seq, int n, int n2) {
            return AuthConfig$Command$.MODULE$.apply(bl, seq, n, n2);
        }

        public static Command fromProduct(Product product) {
            return AuthConfig$Command$.MODULE$.fromProduct(product);
        }

        public static Command unapply(Command command) {
            return AuthConfig$Command$.MODULE$.unapply(command);
        }

        public Command(boolean enabled, Seq<String> program, int success, int order) {
            this.enabled = enabled;
            this.program = program;
            this.success = success;
            this.order = order;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.program()));
            n = Statics.mix((int)n, (int)this.success());
            n = Statics.mix((int)n, (int)this.order());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Command)) return false;
            Command command = (Command)object;
            if (this.enabled() != command.enabled()) return false;
            if (this.success() != command.success()) return false;
            if (this.order() != command.order()) return false;
            Seq<String> seq = this.program();
            Seq<String> seq2 = command.program();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!command.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Command;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Command";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "enabled";
                }
                case 1: {
                    return "program";
                }
                case 2: {
                    return "success";
                }
                case 3: {
                    return "order";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Seq<String> program() {
            return this.program;
        }

        public int success() {
            return this.success;
        }

        public int order() {
            return this.order;
        }

        public boolean disabled() {
            return !this.enabled();
        }

        public Command copy(boolean enabled, Seq<String> program, int success, int order) {
            return new Command(enabled, program, success, order);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public Seq<String> copy$default$2() {
            return this.program();
        }

        public int copy$default$3() {
            return this.success();
        }

        public int copy$default$4() {
            return this.order();
        }

        public boolean _1() {
            return this.enabled();
        }

        public Seq<String> _2() {
            return this.program();
        }

        public int _3() {
            return this.success();
        }

        public int _4() {
            return this.order();
        }
    }

    public static class Fixed
    implements Product,
    Serializable {
        private final boolean enabled;
        private final Ident user;
        private final String password;
        private final int order;

        public static Fixed apply(boolean bl, Ident ident, String string, int n) {
            return AuthConfig$Fixed$.MODULE$.apply(bl, ident, string, n);
        }

        public static Fixed fromProduct(Product product) {
            return AuthConfig$Fixed$.MODULE$.fromProduct(product);
        }

        public static Fixed unapply(Fixed fixed) {
            return AuthConfig$Fixed$.MODULE$.unapply(fixed);
        }

        public Fixed(boolean enabled, Ident user, String password, int order) {
            this.enabled = enabled;
            this.user = user;
            this.password = password;
            this.order = order;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Password(this.password())));
            n = Statics.mix((int)n, (int)this.order());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Fixed)) return false;
            Fixed fixed = (Fixed)object;
            if (this.enabled() != fixed.enabled()) return false;
            if (this.order() != fixed.order()) return false;
            Ident ident = this.user();
            Ident ident2 = fixed.user();
            if (ident == null) {
                if (ident2 != null) {
                    return false;
                }
            } else if (!ident.equals(ident2)) return false;
            String string = this.password();
            String string2 = fixed.password();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!fixed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Fixed;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Fixed";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return new Password(this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "enabled";
                }
                case 1: {
                    return "user";
                }
                case 2: {
                    return "password";
                }
                case 3: {
                    return "order";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Ident user() {
            return this.user;
        }

        public String password() {
            return this.password;
        }

        public int order() {
            return this.order;
        }

        public boolean disabled() {
            return !this.enabled();
        }

        public Fixed copy(boolean enabled, Ident user, String password, int order) {
            return new Fixed(enabled, user, password, order);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public Ident copy$default$2() {
            return this.user();
        }

        public String copy$default$3() {
            return this.password();
        }

        public int copy$default$4() {
            return this.order();
        }

        public boolean _1() {
            return this.enabled();
        }

        public Ident _2() {
            return this.user();
        }

        public String _3() {
            return this.password();
        }

        public int _4() {
            return this.order();
        }
    }

    public static class Http
    implements Product,
    Serializable {
        private final boolean enabled;
        private final LenientUri url;
        private final String method;
        private final String body;
        private final String contentType;
        private final int order;

        public static Http apply(boolean bl, LenientUri lenientUri, String string, String string2, String string3, int n) {
            return AuthConfig$Http$.MODULE$.apply(bl, lenientUri, string, string2, string3, n);
        }

        public static Http fromProduct(Product product) {
            return AuthConfig$Http$.MODULE$.fromProduct(product);
        }

        public static Http unapply(Http http) {
            return AuthConfig$Http$.MODULE$.unapply(http);
        }

        public Http(boolean enabled, LenientUri url, String method, String body, String contentType, int order) {
            this.enabled = enabled;
            this.url = url;
            this.method = method;
            this.body = body;
            this.contentType = contentType;
            this.order = order;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.url()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.method()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.body()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.contentType()));
            n = Statics.mix((int)n, (int)this.order());
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Http)) return false;
            Http http = (Http)object;
            if (this.enabled() != http.enabled()) return false;
            if (this.order() != http.order()) return false;
            LenientUri lenientUri = this.url();
            LenientUri lenientUri2 = http.url();
            if (lenientUri == null) {
                if (lenientUri2 != null) {
                    return false;
                }
            } else if (!lenientUri.equals(lenientUri2)) return false;
            String string = this.method();
            String string2 = http.method();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.body();
            String string4 = http.body();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.contentType();
            String string6 = http.contentType();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!http.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Http;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Http";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "enabled";
                }
                case 1: {
                    return "url";
                }
                case 2: {
                    return "method";
                }
                case 3: {
                    return "body";
                }
                case 4: {
                    return "contentType";
                }
                case 5: {
                    return "order";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public LenientUri url() {
            return this.url;
        }

        public String method() {
            return this.method;
        }

        public String body() {
            return this.body;
        }

        public String contentType() {
            return this.contentType;
        }

        public int order() {
            return this.order;
        }

        public boolean disabled() {
            return !this.enabled();
        }

        public Http copy(boolean enabled, LenientUri url, String method, String body, String contentType, int order) {
            return new Http(enabled, url, method, body, contentType, order);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public LenientUri copy$default$2() {
            return this.url();
        }

        public String copy$default$3() {
            return this.method();
        }

        public String copy$default$4() {
            return this.body();
        }

        public String copy$default$5() {
            return this.contentType();
        }

        public int copy$default$6() {
            return this.order();
        }

        public boolean _1() {
            return this.enabled();
        }

        public LenientUri _2() {
            return this.url();
        }

        public String _3() {
            return this.method();
        }

        public String _4() {
            return this.body();
        }

        public String _5() {
            return this.contentType();
        }

        public int _6() {
            return this.order();
        }
    }

    public static class HttpBasic
    implements Product,
    Serializable {
        private final boolean enabled;
        private final LenientUri url;
        private final String method;
        private final int order;

        public static HttpBasic apply(boolean bl, LenientUri lenientUri, String string, int n) {
            return AuthConfig$HttpBasic$.MODULE$.apply(bl, lenientUri, string, n);
        }

        public static HttpBasic fromProduct(Product product) {
            return AuthConfig$HttpBasic$.MODULE$.fromProduct(product);
        }

        public static HttpBasic unapply(HttpBasic httpBasic) {
            return AuthConfig$HttpBasic$.MODULE$.unapply(httpBasic);
        }

        public HttpBasic(boolean enabled, LenientUri url, String method, int order) {
            this.enabled = enabled;
            this.url = url;
            this.method = method;
            this.order = order;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.url()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.method()));
            n = Statics.mix((int)n, (int)this.order());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HttpBasic)) return false;
            HttpBasic httpBasic = (HttpBasic)object;
            if (this.enabled() != httpBasic.enabled()) return false;
            if (this.order() != httpBasic.order()) return false;
            LenientUri lenientUri = this.url();
            LenientUri lenientUri2 = httpBasic.url();
            if (lenientUri == null) {
                if (lenientUri2 != null) {
                    return false;
                }
            } else if (!lenientUri.equals(lenientUri2)) return false;
            String string = this.method();
            String string2 = httpBasic.method();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!httpBasic.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HttpBasic;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "HttpBasic";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "enabled";
                }
                case 1: {
                    return "url";
                }
                case 2: {
                    return "method";
                }
                case 3: {
                    return "order";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public LenientUri url() {
            return this.url;
        }

        public String method() {
            return this.method;
        }

        public int order() {
            return this.order;
        }

        public boolean disabled() {
            return !this.enabled();
        }

        public HttpBasic copy(boolean enabled, LenientUri url, String method, int order) {
            return new HttpBasic(enabled, url, method, order);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public LenientUri copy$default$2() {
            return this.url();
        }

        public String copy$default$3() {
            return this.method();
        }

        public int copy$default$4() {
            return this.order();
        }

        public boolean _1() {
            return this.enabled();
        }

        public LenientUri _2() {
            return this.url();
        }

        public String _3() {
            return this.method();
        }

        public int _4() {
            return this.order();
        }
    }

    public static class Internal
    implements Product,
    Serializable {
        private final boolean enabled;
        private final int order;

        public static Internal apply(boolean bl, int n) {
            return AuthConfig$Internal$.MODULE$.apply(bl, n);
        }

        public static Internal fromProduct(Product product) {
            return AuthConfig$Internal$.MODULE$.fromProduct(product);
        }

        public static Internal unapply(Internal internal) {
            return AuthConfig$Internal$.MODULE$.unapply(internal);
        }

        public Internal(boolean enabled, int order) {
            this.enabled = enabled;
            this.order = order;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.order());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Internal)) return false;
            Internal internal = (Internal)object;
            if (this.enabled() != internal.enabled()) return false;
            if (this.order() != internal.order()) return false;
            if (!internal.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Internal;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Internal";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._1());
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "enabled";
            }
            if (1 == n2) {
                return "order";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public int order() {
            return this.order;
        }

        public boolean disabled() {
            return !this.enabled();
        }

        public Internal copy(boolean enabled, int order) {
            return new Internal(enabled, order);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public int copy$default$2() {
            return this.order();
        }

        public boolean _1() {
            return this.enabled();
        }

        public int _2() {
            return this.order();
        }
    }

    public static class OAuth
    implements Product,
    Serializable {
        private final Ident id;
        private final boolean enabled;
        private final String name;
        private final LenientUri authorizeUrl;
        private final LenientUri tokenUrl;
        private final LenientUri userUrl;
        private final String userIdKey;
        private final Option<String> userEmailKey;
        private final String scope;
        private final String clientId;
        private final String clientSecret;
        private final Option<String> icon;

        public static OAuth apply(Ident ident, boolean bl, String string, LenientUri lenientUri, LenientUri lenientUri2, LenientUri lenientUri3, String string2, Option<String> option, String string3, String string4, String string5, Option<String> option2) {
            return AuthConfig$OAuth$.MODULE$.apply(ident, bl, string, lenientUri, lenientUri2, lenientUri3, string2, option, string3, string4, string5, option2);
        }

        public static OAuth fromProduct(Product product) {
            return AuthConfig$OAuth$.MODULE$.fromProduct(product);
        }

        public static OAuth github(String string, String string2) {
            return AuthConfig$OAuth$.MODULE$.github(string, string2);
        }

        public static OAuth unapply(OAuth oAuth) {
            return AuthConfig$OAuth$.MODULE$.unapply(oAuth);
        }

        public OAuth(Ident id, boolean enabled, String name, LenientUri authorizeUrl, LenientUri tokenUrl, LenientUri userUrl, String userIdKey, Option<String> userEmailKey, String scope, String clientId, String clientSecret, Option<String> icon) {
            this.id = id;
            this.enabled = enabled;
            this.name = name;
            this.authorizeUrl = authorizeUrl;
            this.tokenUrl = tokenUrl;
            this.userUrl = userUrl;
            this.userIdKey = userIdKey;
            this.userEmailKey = userEmailKey;
            this.scope = scope;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.icon = icon;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.id()));
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.authorizeUrl()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tokenUrl()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userUrl()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userIdKey()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.userEmailKey()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.scope()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clientId()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clientSecret()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.icon()));
            return Statics.finalizeHash((int)n, (int)12);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OAuth)) return false;
            OAuth oAuth = (OAuth)object;
            if (this.enabled() != oAuth.enabled()) return false;
            Ident ident = this.id();
            Ident ident2 = oAuth.id();
            if (ident == null) {
                if (ident2 != null) {
                    return false;
                }
            } else if (!ident.equals(ident2)) return false;
            String string = this.name();
            String string2 = oAuth.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            LenientUri lenientUri = this.authorizeUrl();
            LenientUri lenientUri2 = oAuth.authorizeUrl();
            if (lenientUri == null) {
                if (lenientUri2 != null) {
                    return false;
                }
            } else if (!lenientUri.equals(lenientUri2)) return false;
            LenientUri lenientUri3 = this.tokenUrl();
            LenientUri lenientUri4 = oAuth.tokenUrl();
            if (lenientUri3 == null) {
                if (lenientUri4 != null) {
                    return false;
                }
            } else if (!lenientUri3.equals(lenientUri4)) return false;
            LenientUri lenientUri5 = this.userUrl();
            LenientUri lenientUri6 = oAuth.userUrl();
            if (lenientUri5 == null) {
                if (lenientUri6 != null) {
                    return false;
                }
            } else if (!lenientUri5.equals(lenientUri6)) return false;
            String string3 = this.userIdKey();
            String string4 = oAuth.userIdKey();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.userEmailKey();
            Option<String> option2 = oAuth.userEmailKey();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string5 = this.scope();
            String string6 = oAuth.scope();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.clientId();
            String string8 = oAuth.clientId();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.clientSecret();
            String string10 = oAuth.clientSecret();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            Option<String> option3 = this.icon();
            Option<String> option4 = oAuth.icon();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!oAuth.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OAuth;
        }

        public int productArity() {
            return 12;
        }

        public String productPrefix() {
            return "OAuth";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return this._11();
                }
                case 11: {
                    return this._12();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "enabled";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "authorizeUrl";
                }
                case 4: {
                    return "tokenUrl";
                }
                case 5: {
                    return "userUrl";
                }
                case 6: {
                    return "userIdKey";
                }
                case 7: {
                    return "userEmailKey";
                }
                case 8: {
                    return "scope";
                }
                case 9: {
                    return "clientId";
                }
                case 10: {
                    return "clientSecret";
                }
                case 11: {
                    return "icon";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Ident id() {
            return this.id;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public String name() {
            return this.name;
        }

        public LenientUri authorizeUrl() {
            return this.authorizeUrl;
        }

        public LenientUri tokenUrl() {
            return this.tokenUrl;
        }

        public LenientUri userUrl() {
            return this.userUrl;
        }

        public String userIdKey() {
            return this.userIdKey;
        }

        public Option<String> userEmailKey() {
            return this.userEmailKey;
        }

        public String scope() {
            return this.scope;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientSecret() {
            return this.clientSecret;
        }

        public Option<String> icon() {
            return this.icon;
        }

        public OAuth copy(Ident id, boolean enabled, String name, LenientUri authorizeUrl, LenientUri tokenUrl, LenientUri userUrl, String userIdKey, Option<String> userEmailKey, String scope, String clientId, String clientSecret, Option<String> icon) {
            return new OAuth(id, enabled, name, authorizeUrl, tokenUrl, userUrl, userIdKey, userEmailKey, scope, clientId, clientSecret, icon);
        }

        public Ident copy$default$1() {
            return this.id();
        }

        public boolean copy$default$2() {
            return this.enabled();
        }

        public String copy$default$3() {
            return this.name();
        }

        public LenientUri copy$default$4() {
            return this.authorizeUrl();
        }

        public LenientUri copy$default$5() {
            return this.tokenUrl();
        }

        public LenientUri copy$default$6() {
            return this.userUrl();
        }

        public String copy$default$7() {
            return this.userIdKey();
        }

        public Option<String> copy$default$8() {
            return this.userEmailKey();
        }

        public String copy$default$9() {
            return this.scope();
        }

        public String copy$default$10() {
            return this.clientId();
        }

        public String copy$default$11() {
            return this.clientSecret();
        }

        public Option<String> copy$default$12() {
            return this.icon();
        }

        public Ident _1() {
            return this.id();
        }

        public boolean _2() {
            return this.enabled();
        }

        public String _3() {
            return this.name();
        }

        public LenientUri _4() {
            return this.authorizeUrl();
        }

        public LenientUri _5() {
            return this.tokenUrl();
        }

        public LenientUri _6() {
            return this.userUrl();
        }

        public String _7() {
            return this.userIdKey();
        }

        public Option<String> _8() {
            return this.userEmailKey();
        }

        public String _9() {
            return this.scope();
        }

        public String _10() {
            return this.clientId();
        }

        public String _11() {
            return this.clientSecret();
        }

        public Option<String> _12() {
            return this.icon();
        }
    }

    public static final class Proxy
    implements Product,
    Serializable {
        private final boolean enabled;
        private final String userHeader;
        private final Option<String> emailHeader;

        public static Proxy apply(boolean bl, String string, Option<String> option) {
            return AuthConfig$Proxy$.MODULE$.apply(bl, string, option);
        }

        public static Proxy fromProduct(Product product) {
            return AuthConfig$Proxy$.MODULE$.fromProduct(product);
        }

        public static Proxy unapply(Proxy proxy) {
            return AuthConfig$Proxy$.MODULE$.unapply(proxy);
        }

        public Proxy(boolean enabled, String userHeader, Option<String> emailHeader) {
            this.enabled = enabled;
            this.userHeader = userHeader;
            this.emailHeader = emailHeader;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userHeader()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.emailHeader()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Proxy)) return false;
            Proxy proxy = (Proxy)object;
            if (this.enabled() != proxy.enabled()) return false;
            String string = this.userHeader();
            String string2 = proxy.userHeader();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.emailHeader();
            Option<String> option2 = proxy.emailHeader();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Proxy;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Proxy";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "enabled";
                }
                case 1: {
                    return "userHeader";
                }
                case 2: {
                    return "emailHeader";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public String userHeader() {
            return this.userHeader;
        }

        public Option<String> emailHeader() {
            return this.emailHeader;
        }

        public boolean disabled() {
            return !this.enabled();
        }

        public Proxy copy(boolean enabled, String userHeader, Option<String> emailHeader) {
            return new Proxy(enabled, userHeader, emailHeader);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public String copy$default$2() {
            return this.userHeader();
        }

        public Option<String> copy$default$3() {
            return this.emailHeader();
        }

        public boolean _1() {
            return this.enabled();
        }

        public String _2() {
            return this.userHeader();
        }

        public Option<String> _3() {
            return this.emailHeader();
        }
    }
}

