/*
 * Decompiled with CFR 0.152.
 */
package sharry.backend.auth;

import cats.Applicative;
import cats.Apply;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sharry.backend.account.OAccount;
import sharry.backend.auth.AddAccount;
import sharry.backend.auth.AddAccount$AccountOps$;
import sharry.backend.auth.AuthConfig;
import sharry.backend.auth.AuthToken;
import sharry.backend.auth.AuthToken$;
import sharry.backend.auth.CommandAuth$;
import sharry.backend.auth.CommandAuth$RunCommand$;
import sharry.backend.auth.FixedAuth$;
import sharry.backend.auth.HttpAuth$;
import sharry.backend.auth.HttpAuth$RunRequest$;
import sharry.backend.auth.HttpBasicAuth$;
import sharry.backend.auth.HttpBasicAuth$RunRequest$;
import sharry.backend.auth.InternalAuth$;
import sharry.backend.auth.Login;
import sharry.backend.auth.LoginModule$;
import sharry.backend.auth.LoginResult;
import sharry.backend.auth.LoginResult$;
import sharry.backend.auth.UserPassData;
import sharry.common.AccountId;
import sharry.common.Ident;
import sharry.common.Ident$;
import sharry.logging.Logger;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Pkg$;

public final class Login$
implements Serializable {
    public static final Login$ MODULE$ = new Login$();

    private Login$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Login$.class);
    }

    public <F> Resource<F, Login<F>> apply(OAccount<F> oacc, Async<F> evidence$1) {
        return package$.MODULE$.Resource().pure((Object)new Login<F>(evidence$1, oacc){
            private final Async evidence$1$2;
            private final OAccount oacc$2;
            private final Logger logger;
            {
                this.evidence$1$2 = evidence$1$1;
                this.oacc$2 = oacc$1;
                this.logger = sharry.logging.package$.MODULE$.getLogger((Sync)evidence$1$1, Enclosing$.MODULE$.apply("sharry.backend.auth.Login.apply logger"));
            }

            public Object loginSession(AuthConfig config, String sessionKey) {
                Either<String, AuthToken> either = AuthToken$.MODULE$.fromString(sessionKey);
                if (either instanceof Right) {
                    AuthToken at = (AuthToken)((Right)either).value();
                    if (at.sigInvalid(config.serverSecret())) {
                        LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.invalidAuth());
                        return ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, (Applicative)this.evidence$1$2);
                    }
                    if (at.isExpired(config.sessionValid())) {
                        LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.invalidTime());
                        return ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, (Applicative)this.evidence$1$2);
                    }
                    LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.ok(at));
                    return ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, (Applicative)this.evidence$1$2);
                }
                if (either instanceof Left) {
                    LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.invalidAuth());
                    return ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, (Applicative)this.evidence$1$2);
                }
                throw new MatchError(either);
            }

            public Object loginUserPass(AuthConfig config, UserPassData up) {
                Object object = implicits$.MODULE$.catsSyntaxApplyOps(this.logger.debug(() -> Login$.sharry$backend$auth$Login$$anon$1$$_$loginUserPass$$anonfun$1(up), Pkg$.MODULE$.apply("sharry.backend.auth"), FileName$.MODULE$.apply("Login.scala"), Name$.MODULE$.apply("loginUserPass"), Line$.MODULE$.apply(37)));
                return ApplyOps$.MODULE$.$times$greater$extension(object, Login$.MODULE$.createLoginModule(config, this.oacc$2, this.evidence$1$2).run().apply((Object)up), (Apply)this.evidence$1$2);
            }

            public Object loginAlias(AuthConfig config, String alias) {
                boolean bl = OptionT$.MODULE$.fromOption();
                return OptionT.FromOptionPartiallyApplied$.MODULE$.apply$extension(bl, Ident$.MODULE$.fromString(alias).toOption().filter(Login$::sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$1), (Applicative)this.evidence$1$2).flatMap((Function1 & Serializable)aliasId -> this.oacc$2.findByAlias((Ident)aliasId).flatMap((Function1 & Serializable)acc -> {
                    AccountId accountId = acc.accountId((Option)Some$.MODULE$.apply(aliasId));
                    return OptionT$.MODULE$.liftF(AuthToken$.MODULE$.user(accountId.copy(accountId.copy$default$1(), accountId.copy$default$2(), false, accountId.copy$default$4()), config.serverSecret(), this.evidence$1$2), (Functor)this.evidence$1$2).map(Login$::sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$2$$anonfun$1$$anonfun$1, (Functor)this.evidence$1$2).map(Login$::sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$2$$anonfun$1$$anonfun$2, (Functor)this.evidence$1$2);
                }, (Monad)this.evidence$1$2), (Monad)this.evidence$1$2).getOrElse(Login$::sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$3, (Functor)this.evidence$1$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sharry$backend$auth$Login$$anon$1$$_$loginUserPass$$anonfun$1(sharry.backend.auth.UserPassData ), sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$1(sharry.common.Ident ), loginAlias$$anonfun$2(sharry.backend.auth.AuthConfig sharry.common.Ident ), sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$3(), sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$2$$anonfun$1$$anonfun$1(sharry.backend.auth.AuthToken ), sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$2$$anonfun$1$$anonfun$2(scala.Tuple2 ), loginAlias$$anonfun$2$$anonfun$1(sharry.common.Ident sharry.backend.auth.AuthConfig sharry.store.records.RAccount )}, serializedLambda);
            }
        });
    }

    public <F> Kleisli<F, UserPassData, LoginResult> createLoginModule(AuthConfig cfg, OAccount<F> account, Async<F> evidence$1) {
        AddAccount.AccountOps<F> ops = AddAccount$AccountOps$.MODULE$.from(account);
        List modules = ((List)((SeqOps)new .colon.colon(FixedAuth$.MODULE$.apply(cfg, account, evidence$1).withPosition(), (List)new .colon.colon(InternalAuth$.MODULE$.apply(cfg, account, evidence$1).withPosition(), (List)new .colon.colon(HttpBasicAuth$.MODULE$.apply(cfg, ops, HttpBasicAuth$RunRequest$.MODULE$.javaConn(evidence$1), evidence$1).withPosition(), (List)new .colon.colon(HttpAuth$.MODULE$.apply(cfg, ops, HttpAuth$RunRequest$.MODULE$.javaConn(evidence$1), evidence$1).withPosition(), (List)new .colon.colon(CommandAuth$.MODULE$.apply(cfg, ops, CommandAuth$RunCommand$.MODULE$.systemProcess(evidence$1), evidence$1).withPosition(), (List)Nil$.MODULE$)))))).sortBy((Function1 & Serializable)_$5 -> BoxesRunTime.unboxToInt((Object)_$5._1()), implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForInt()))).map((Function1 & Serializable)_$6 -> (Kleisli)_$6._2());
        return LoginModule$.MODULE$.combine(modules, evidence$1);
    }

    public static final String sharry$backend$auth$Login$$anon$1$$_$loginUserPass$$anonfun$1(UserPassData up$1) {
        return new StringBuilder(16).append("Trying to login ").append(up$1).toString();
    }

    public static final /* synthetic */ boolean sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$1(Ident _$3) {
        Ident ident = _$3;
        Ident ident2 = Ident$.MODULE$.empty();
        return ident == null ? ident2 != null : !ident.equals(ident2);
    }

    public static final /* synthetic */ Tuple2 sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$2$$anonfun$1$$anonfun$1(AuthToken tok) {
        LoginResult res = LoginResult$.MODULE$.ok(tok);
        return Tuple2$.MODULE$.apply((Object)tok, (Object)res);
    }

    public static final /* synthetic */ LoginResult sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$2$$anonfun$1$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            AuthToken tok = (AuthToken)tuple2._1();
            LoginResult res = (LoginResult)tuple2._2();
            return res;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final LoginResult sharry$backend$auth$Login$$anon$1$$_$loginAlias$$anonfun$3() {
        return LoginResult$.MODULE$.invalidAuth();
    }
}

