/*
 * Decompiled with CFR 0.152.
 */
package sharry.backend.config;

import cats.data.NonEmptyChainImpl$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.kernel.Monoid;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import cats.syntax.package;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import sharry.backend.config.CopyFilesConfig;
import sharry.backend.config.FilesConfig$;
import sharry.common.Ident;
import sharry.store.FileStoreConfig;

public class FilesConfig
implements Product,
Serializable {
    private final Ident defaultStore;
    private final Map<Ident, FileStoreConfig> stores;
    private final CopyFilesConfig copyFiles;
    private final Map<Ident, FileStoreConfig> enabledStores;

    public static FilesConfig apply(Ident ident, Map<Ident, FileStoreConfig> map, CopyFilesConfig copyFilesConfig) {
        return FilesConfig$.MODULE$.apply(ident, map, copyFilesConfig);
    }

    public static FilesConfig fromProduct(Product product) {
        return FilesConfig$.MODULE$.fromProduct(product);
    }

    public static FilesConfig unapply(FilesConfig filesConfig) {
        return FilesConfig$.MODULE$.unapply(filesConfig);
    }

    public FilesConfig(Ident defaultStore, Map<Ident, FileStoreConfig> stores, CopyFilesConfig copyFiles) {
        this.defaultStore = defaultStore;
        this.stores = stores;
        this.copyFiles = copyFiles;
        this.enabledStores = stores.view().filter((Function1 & Serializable)_$1 -> ((FileStoreConfig)_$1._2()).enabled()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FilesConfig)) return false;
        FilesConfig filesConfig = (FilesConfig)object;
        Ident ident = this.defaultStore();
        Ident ident2 = filesConfig.defaultStore();
        if (ident == null) {
            if (ident2 != null) {
                return false;
            }
        } else if (!ident.equals(ident2)) return false;
        Map<Ident, FileStoreConfig> map = this.stores();
        Map<Ident, FileStoreConfig> map2 = filesConfig.stores();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        CopyFilesConfig copyFilesConfig = this.copyFiles();
        CopyFilesConfig copyFilesConfig2 = filesConfig.copyFiles();
        if (copyFilesConfig == null) {
            if (copyFilesConfig2 != null) {
                return false;
            }
        } else if (!((Object)copyFilesConfig).equals(copyFilesConfig2)) return false;
        if (!filesConfig.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FilesConfig;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "FilesConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "defaultStore";
            }
            case 1: {
                return "stores";
            }
            case 2: {
                return "copyFiles";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Ident defaultStore() {
        return this.defaultStore;
    }

    public Map<Ident, FileStoreConfig> stores() {
        return this.stores;
    }

    public CopyFilesConfig copyFiles() {
        return this.copyFiles;
    }

    public Map<Ident, FileStoreConfig> enabledStores() {
        return this.enabledStores;
    }

    public FileStoreConfig defaultStoreConfig() {
        return (FileStoreConfig)this.enabledStores().getOrElse((Object)this.defaultStore(), this::defaultStoreConfig$$anonfun$1);
    }

    public Validated<Object, FilesConfig> validate() {
        Validated validated;
        Validated validated2;
        Validated storesEmpty = this.enabledStores().isEmpty() ? Validated$.MODULE$.invalidNec((Object)"No file stores defined! Make sure at least one enabled store is present.") : Validated$.MODULE$.validNec((Object)BoxedUnit.UNIT);
        Option option = this.enabledStores().get((Object)this.defaultStore());
        if (option instanceof Some) {
            validated2 = Validated$.MODULE$.validNec((Object)BoxedUnit.UNIT);
        } else if (None$.MODULE$.equals(option)) {
            validated2 = Validated$.MODULE$.invalidNec((Object)new StringBuilder(32).append("Default file store not present: ").append(this.defaultStore()).toString());
        } else {
            throw new MatchError((Object)option);
        }
        Validated defaultStorePresent = validated2;
        if (!this.copyFiles().enable()) {
            validated = Validated$.MODULE$.validNec((Object)BoxedUnit.UNIT);
        } else {
            boolean exist = this.enabledStores().contains((Object)this.copyFiles().source()) && this.enabledStores().contains((Object)this.copyFiles().target());
            validated = exist ? Validated$.MODULE$.validNec((Object)BoxedUnit.UNIT) : Validated$.MODULE$.invalidNec((Object)"The source or target name for the copy-files section doesn't exist in the list of enabled file stores.");
        }
        Validated validCopyStores = validated;
        return ((Validated)package.all$.MODULE$.catsSyntaxSemigroup(package.all$.MODULE$.catsSyntaxSemigroup(package.all$.MODULE$.catsSyntaxSemigroup((Object)storesEmpty, (Semigroup)Validated$.MODULE$.catsDataMonoidForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain(), (Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())).$bar$plus$bar((Object)defaultStorePresent), (Semigroup)Validated$.MODULE$.catsDataMonoidForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain(), (Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())).$bar$plus$bar((Object)validCopyStores), (Semigroup)Validated$.MODULE$.catsDataMonoidForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain(), (Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())).$bar$plus$bar(this.copyFiles().validate())).map((Function1 & Serializable)_$2 -> this);
    }

    public FilesConfig copy(Ident defaultStore, Map<Ident, FileStoreConfig> stores, CopyFilesConfig copyFiles) {
        return new FilesConfig(defaultStore, stores, copyFiles);
    }

    public Ident copy$default$1() {
        return this.defaultStore();
    }

    public Map<Ident, FileStoreConfig> copy$default$2() {
        return this.stores();
    }

    public CopyFilesConfig copy$default$3() {
        return this.copyFiles();
    }

    public Ident _1() {
        return this.defaultStore();
    }

    public Map<Ident, FileStoreConfig> _2() {
        return this.stores();
    }

    public CopyFilesConfig _3() {
        return this.copyFiles();
    }

    private final FileStoreConfig defaultStoreConfig$$anonfun$1() {
        throw package$.MODULE$.error(new StringBuilder(34).append("Store '").append(this.defaultStore().id()).append("' not found. Is it enabled?").toString());
    }
}

