/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.Serializable;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichDouble$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;
import scodec.bits.Bases;
import scodec.bits.BitVector;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;
import scodec.bits.HexDumpFormat$;
import scodec.bits.HexDumpFormat$Ansi$;

public final class HexDumpFormat {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HexDumpFormat.class.getDeclaredField("Ansi$lzy1"));
    private final boolean includeAddressColumn;
    private final int dataColumnCount;
    private final int dataColumnWidthInBytes;
    private final boolean includeAsciiColumn;
    private final Bases.HexAlphabet alphabet;
    private final boolean ansiEnabled;
    private final int addressOffset;
    private final long lengthLimit;
    private volatile Object Ansi$lzy1;
    private final String FaintDot;
    private final String FaintUnmappable;
    private final Regex NonPrintablePattern;

    public static HexDumpFormat Default() {
        return HexDumpFormat$.MODULE$.Default();
    }

    public static HexDumpFormat NoAnsi() {
        return HexDumpFormat$.MODULE$.NoAnsi();
    }

    public static HexDumpFormat NoAscii() {
        return HexDumpFormat$.MODULE$.NoAscii();
    }

    public HexDumpFormat(boolean includeAddressColumn, int dataColumnCount, int dataColumnWidthInBytes, boolean includeAsciiColumn, Bases.HexAlphabet alphabet, boolean ansiEnabled, int addressOffset, long lengthLimit) {
        this.includeAddressColumn = includeAddressColumn;
        this.dataColumnCount = dataColumnCount;
        this.dataColumnWidthInBytes = dataColumnWidthInBytes;
        this.includeAsciiColumn = includeAsciiColumn;
        this.alphabet = alphabet;
        this.ansiEnabled = ansiEnabled;
        this.addressOffset = addressOffset;
        this.lengthLimit = lengthLimit;
        this.FaintDot = new StringBuilder(1).append(this.scodec$bits$HexDumpFormat$$Ansi().Faint()).append(".").append(this.scodec$bits$HexDumpFormat$$Ansi().Normal()).toString();
        this.FaintUnmappable = new StringBuilder(1).append(this.scodec$bits$HexDumpFormat$$Ansi().Faint()).append("\ufffd").append(this.scodec$bits$HexDumpFormat$$Ansi().Normal()).toString();
        this.NonPrintablePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^\ufffd\\p{Print}]"));
    }

    public boolean includeAddressColumn() {
        return this.includeAddressColumn;
    }

    public int dataColumnCount() {
        return this.dataColumnCount;
    }

    public int dataColumnWidthInBytes() {
        return this.dataColumnWidthInBytes;
    }

    public boolean includeAsciiColumn() {
        return this.includeAsciiColumn;
    }

    public Bases.HexAlphabet alphabet() {
        return this.alphabet;
    }

    public boolean ansiEnabled() {
        return this.ansiEnabled;
    }

    public int addressOffset() {
        return this.addressOffset;
    }

    public long lengthLimit() {
        return this.lengthLimit;
    }

    private int numBytesPerLine() {
        return this.dataColumnWidthInBytes() * this.dataColumnCount();
    }

    private long numBitsPerLine() {
        return (long)this.numBytesPerLine() * 8L;
    }

    public HexDumpFormat withIncludeAddressColumn(boolean newIncludeAddressColumn) {
        return new HexDumpFormat(newIncludeAddressColumn, this.dataColumnCount(), this.dataColumnWidthInBytes(), this.includeAsciiColumn(), this.alphabet(), this.ansiEnabled(), this.addressOffset(), this.lengthLimit());
    }

    public HexDumpFormat withDataColumnCount(int newDataColumnCount) {
        return new HexDumpFormat(this.includeAddressColumn(), newDataColumnCount, this.dataColumnWidthInBytes(), this.includeAsciiColumn(), this.alphabet(), this.ansiEnabled(), this.addressOffset(), this.lengthLimit());
    }

    public HexDumpFormat withDataColumnWidthInBytes(int newDataColumnWidthInBytes) {
        return new HexDumpFormat(this.includeAddressColumn(), this.dataColumnCount(), newDataColumnWidthInBytes, this.includeAsciiColumn(), this.alphabet(), this.ansiEnabled(), this.addressOffset(), this.lengthLimit());
    }

    public HexDumpFormat withIncludeAsciiColumn(boolean newIncludeAsciiColumn) {
        return new HexDumpFormat(this.includeAddressColumn(), this.dataColumnCount(), this.dataColumnWidthInBytes(), newIncludeAsciiColumn, this.alphabet(), this.ansiEnabled(), this.addressOffset(), this.lengthLimit());
    }

    public HexDumpFormat withAlphabet(Bases.HexAlphabet newAlphabet) {
        return new HexDumpFormat(this.includeAddressColumn(), this.dataColumnCount(), this.dataColumnWidthInBytes(), this.includeAsciiColumn(), newAlphabet, this.ansiEnabled(), this.addressOffset(), this.lengthLimit());
    }

    public HexDumpFormat withAnsi(boolean newAnsiEnabled) {
        return new HexDumpFormat(this.includeAddressColumn(), this.dataColumnCount(), this.dataColumnWidthInBytes(), this.includeAsciiColumn(), this.alphabet(), newAnsiEnabled, this.addressOffset(), this.lengthLimit());
    }

    public HexDumpFormat withAddressOffset(int newAddressOffset) {
        return new HexDumpFormat(this.includeAddressColumn(), this.dataColumnCount(), this.dataColumnWidthInBytes(), this.includeAsciiColumn(), this.alphabet(), this.ansiEnabled(), newAddressOffset, this.lengthLimit());
    }

    public HexDumpFormat withLengthLimit(long newLengthLimit) {
        return new HexDumpFormat(this.includeAddressColumn(), this.dataColumnCount(), this.dataColumnWidthInBytes(), this.includeAsciiColumn(), this.alphabet(), this.ansiEnabled(), this.addressOffset(), newLengthLimit);
    }

    public String render(ByteVector bytes) {
        return this.render((Function0<BitVector>)((Function0 & Serializable)() -> HexDumpFormat.render$$anonfun$1(bytes)));
    }

    public String render(Function0<BitVector> bits) {
        scala.collection.mutable.StringBuilder bldr = new scala.collection.mutable.StringBuilder();
        this.render(bits, (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)line -> bldr.append(line));
        return bldr.toString();
    }

    public void render(Function0<BitVector> bits, Function1<String, BoxedUnit> onLine) {
        this.render((BitVector)bits.apply(), 0L, onLine);
    }

    private void render(BitVector bits, long position, Function1<String, BoxedUnit> onLine) {
        block1: {
            while (true) {
                long bitsToTake;
                boolean takeFullLine = position + (long)this.numBytesPerLine() <= this.lengthLimit();
                long l = bitsToTake = takeFullLine ? this.numBitsPerLine() : (this.lengthLimit() - position) * 8L;
                if (!bits.nonEmpty() || bitsToTake <= 0L) break block1;
                BitVector bitsInLine = bits.take(bitsToTake);
                String line = this.renderLine(bitsInLine.bytes(), (int)((long)this.addressOffset() + position));
                onLine.apply((Object)line);
                if (!takeFullLine) break;
                BitVector bitVector = bits.drop(this.numBitsPerLine());
                long l2 = position + bitsInLine.size() / 8L;
                bits = bitVector;
                position = l2;
            }
            return;
        }
    }

    public void print(ByteVector bytes) {
        this.print((Function0<BitVector>)((Function0 & Serializable)() -> HexDumpFormat.print$$anonfun$1(bytes)));
    }

    public void print(Function0<BitVector> bits) {
        this.render(bits, (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)line -> Console$.MODULE$.print(line));
    }

    public final HexDumpFormat$Ansi$ scodec$bits$HexDumpFormat$$Ansi() {
        Object object = this.Ansi$lzy1;
        if (object instanceof HexDumpFormat$Ansi$) {
            return (HexDumpFormat$Ansi$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (HexDumpFormat$Ansi$)this.Ansi$lzyINIT1();
    }

    private Object Ansi$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Ansi$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    HexDumpFormat$Ansi$ hexDumpFormat$Ansi$ = null;
                    try {
                        hexDumpFormat$Ansi$ = new HexDumpFormat$Ansi$();
                        object2 = hexDumpFormat$Ansi$ == null ? LazyVals.NullValue$.MODULE$ : hexDumpFormat$Ansi$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Ansi$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return hexDumpFormat$Ansi$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String renderLine(ByteVector bytes, int address) {
        scala.collection.mutable.StringBuilder bldr = new scala.collection.mutable.StringBuilder();
        if (this.includeAddressColumn()) {
            if (this.ansiEnabled()) {
                bldr.append(this.scodec$bits$HexDumpFormat$$Ansi().Faint());
            }
            bldr.append(ByteVector$.MODULE$.fromInt(address, ByteVector$.MODULE$.fromInt$default$2(), ByteVector$.MODULE$.fromInt$default$3()).toHex(this.alphabet()));
            if (this.ansiEnabled()) {
                bldr.append(this.scodec$bits$HexDumpFormat$$Ansi().Normal());
            }
            bldr.append("  ");
        }
        bytes.grouped(this.dataColumnWidthInBytes()).foreach((Function1 & Serializable)columnBytes -> {
            this.renderHex(bldr, (ByteVector)columnBytes);
            return bldr.append(" ");
        });
        if (this.ansiEnabled()) {
            bldr.append(this.scodec$bits$HexDumpFormat$$Ansi().Reset());
        }
        if (this.includeAsciiColumn()) {
            int bytesOnThisLine = (int)bytes.size();
            int dataBytePadding = (this.numBytesPerLine() - bytesOnThisLine) * 3 - 1;
            int numFullDataColumns = (bytesOnThisLine - 1) / this.dataColumnWidthInBytes();
            int numAdditionalColumnSpacers = this.dataColumnCount() - numFullDataColumns;
            int padding = dataBytePadding + numAdditionalColumnSpacers;
            bldr.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), padding));
            bldr.append('\u2502');
            this.renderAsciiBestEffort(bldr, bytes);
            bldr.append('\u2502');
        }
        bldr.append('\n');
        return bldr.toString();
    }

    private void renderHex(scala.collection.mutable.StringBuilder bldr, ByteVector bytes) {
        bytes.foreachS(new ByteVector.F1BU(bldr, this){
            private final scala.collection.mutable.StringBuilder bldr$3;
            private final /* synthetic */ HexDumpFormat $outer;
            {
                this.bldr$3 = bldr$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void apply(byte b) {
                if (this.$outer.ansiEnabled()) {
                    this.$outer.scodec$bits$HexDumpFormat$$Ansi().foregroundColor(this.bldr$3, this.$outer.scodec$bits$HexDumpFormat$$rgbForByte(b));
                }
                this.bldr$3.append(this.$outer.alphabet().toChar((byte)(b >> 4 & 0xF))).append(this.$outer.alphabet().toChar((byte)(b & 0xF))).append(' ');
            }
        });
    }

    public Tuple3<Object, Object, Object> scodec$bits$HexDumpFormat$$rgbForByte(byte b) {
        double saturation = 0.4;
        double value = 0.75;
        double hue = (double)(b & 0xFF) / 256.0 * 360.0;
        return this.hsvToRgb(hue, saturation, value);
    }

    private Tuple3<Object, Object, Object> hsvToRgb(double hue, double saturation, double value) {
        Tuple3 tuple3;
        double c = saturation * value;
        double h = hue / (double)60;
        double x = c * (1.0 - RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(h % (double)2 - 1.0)));
        double z = 0.0;
        int n = (int)h;
        switch (n) {
            case 0: {
                tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)c), (Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)z));
                break;
            }
            case 1: {
                tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)c), (Object)BoxesRunTime.boxToDouble((double)z));
                break;
            }
            case 2: {
                tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)z), (Object)BoxesRunTime.boxToDouble((double)c), (Object)BoxesRunTime.boxToDouble((double)x));
                break;
            }
            case 3: {
                tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)z), (Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)c));
                break;
            }
            case 4: {
                tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)z), (Object)BoxesRunTime.boxToDouble((double)c));
                break;
            }
            case 5: {
                tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)c), (Object)BoxesRunTime.boxToDouble((double)z), (Object)BoxesRunTime.boxToDouble((double)x));
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        Tuple3 tuple32 = tuple3;
        double r1 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double g1 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double b1 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        double m = value - c;
        Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(r1 + m)), (Object)BoxesRunTime.boxToDouble((double)(g1 + m)), (Object)BoxesRunTime.boxToDouble((double)(b1 + m)));
        double r = BoxesRunTime.unboxToDouble((Object)tuple33._1());
        double g = BoxesRunTime.unboxToDouble((Object)tuple33._2());
        double b = BoxesRunTime.unboxToDouble((Object)tuple33._3());
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)HexDumpFormat.scale$1(r)), (Object)BoxesRunTime.boxToInteger((int)HexDumpFormat.scale$1(g)), (Object)BoxesRunTime.boxToInteger((int)HexDumpFormat.scale$1(b)));
    }

    private void renderAsciiBestEffort(scala.collection.mutable.StringBuilder bldr, ByteVector bytes) {
        String decoded = bytes.decodeAsciiLenient();
        String nonPrintableReplacement = this.ansiEnabled() ? this.FaintDot : ".";
        String printable = this.NonPrintablePattern.replaceAllIn((CharSequence)decoded, nonPrintableReplacement);
        String colorized = this.ansiEnabled() ? printable.replaceAll("\ufffd", this.FaintUnmappable) : printable;
        bldr.append(colorized);
    }

    private static final BitVector render$$anonfun$1(ByteVector bytes$1) {
        return bytes$1.bits();
    }

    private static final BitVector print$$anonfun$1(ByteVector bytes$2) {
        return bytes$2.bits();
    }

    private static final int scale$1(double v) {
        return (int)(v * (double)256);
    }
}

