(function(scope){
'use strict';

function F(arity, fun, wrapper) {
  wrapper.a = arity;
  wrapper.f = fun;
  return wrapper;
}

function F2(fun) {
  return F(2, fun, function(a) { return function(b) { return fun(a,b); }; })
}
function F3(fun) {
  return F(3, fun, function(a) {
    return function(b) { return function(c) { return fun(a, b, c); }; };
  });
}
function F4(fun) {
  return F(4, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return fun(a, b, c, d); }; }; };
  });
}
function F5(fun) {
  return F(5, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return fun(a, b, c, d, e); }; }; }; };
  });
}
function F6(fun) {
  return F(6, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return fun(a, b, c, d, e, f); }; }; }; }; };
  });
}
function F7(fun) {
  return F(7, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return function(g) { return fun(a, b, c, d, e, f, g); }; }; }; }; }; };
  });
}
function F8(fun) {
  return F(8, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return function(g) { return function(h) {
    return fun(a, b, c, d, e, f, g, h); }; }; }; }; }; }; };
  });
}
function F9(fun) {
  return F(9, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return function(g) { return function(h) { return function(i) {
    return fun(a, b, c, d, e, f, g, h, i); }; }; }; }; }; }; }; };
  });
}

function A2(fun, a, b) {
  return fun.a === 2 ? fun.f(a, b) : fun(a)(b);
}
function A3(fun, a, b, c) {
  return fun.a === 3 ? fun.f(a, b, c) : fun(a)(b)(c);
}
function A4(fun, a, b, c, d) {
  return fun.a === 4 ? fun.f(a, b, c, d) : fun(a)(b)(c)(d);
}
function A5(fun, a, b, c, d, e) {
  return fun.a === 5 ? fun.f(a, b, c, d, e) : fun(a)(b)(c)(d)(e);
}
function A6(fun, a, b, c, d, e, f) {
  return fun.a === 6 ? fun.f(a, b, c, d, e, f) : fun(a)(b)(c)(d)(e)(f);
}
function A7(fun, a, b, c, d, e, f, g) {
  return fun.a === 7 ? fun.f(a, b, c, d, e, f, g) : fun(a)(b)(c)(d)(e)(f)(g);
}
function A8(fun, a, b, c, d, e, f, g, h) {
  return fun.a === 8 ? fun.f(a, b, c, d, e, f, g, h) : fun(a)(b)(c)(d)(e)(f)(g)(h);
}
function A9(fun, a, b, c, d, e, f, g, h, i) {
  return fun.a === 9 ? fun.f(a, b, c, d, e, f, g, h, i) : fun(a)(b)(c)(d)(e)(f)(g)(h)(i);
}




var _JsArray_empty = [];

function _JsArray_singleton(value)
{
    return [value];
}

function _JsArray_length(array)
{
    return array.length;
}

var _JsArray_initialize = F3(function(size, offset, func)
{
    var result = new Array(size);

    for (var i = 0; i < size; i++)
    {
        result[i] = func(offset + i);
    }

    return result;
});

var _JsArray_initializeFromList = F2(function (max, ls)
{
    var result = new Array(max);

    for (var i = 0; i < max && ls.b; i++)
    {
        result[i] = ls.a;
        ls = ls.b;
    }

    result.length = i;
    return _Utils_Tuple2(result, ls);
});

var _JsArray_unsafeGet = F2(function(index, array)
{
    return array[index];
});

var _JsArray_unsafeSet = F3(function(index, value, array)
{
    var length = array.length;
    var result = new Array(length);

    for (var i = 0; i < length; i++)
    {
        result[i] = array[i];
    }

    result[index] = value;
    return result;
});

var _JsArray_push = F2(function(value, array)
{
    var length = array.length;
    var result = new Array(length + 1);

    for (var i = 0; i < length; i++)
    {
        result[i] = array[i];
    }

    result[length] = value;
    return result;
});

var _JsArray_foldl = F3(function(func, acc, array)
{
    var length = array.length;

    for (var i = 0; i < length; i++)
    {
        acc = A2(func, array[i], acc);
    }

    return acc;
});

var _JsArray_foldr = F3(function(func, acc, array)
{
    for (var i = array.length - 1; i >= 0; i--)
    {
        acc = A2(func, array[i], acc);
    }

    return acc;
});

var _JsArray_map = F2(function(func, array)
{
    var length = array.length;
    var result = new Array(length);

    for (var i = 0; i < length; i++)
    {
        result[i] = func(array[i]);
    }

    return result;
});

var _JsArray_indexedMap = F3(function(func, offset, array)
{
    var length = array.length;
    var result = new Array(length);

    for (var i = 0; i < length; i++)
    {
        result[i] = A2(func, offset + i, array[i]);
    }

    return result;
});

var _JsArray_slice = F3(function(from, to, array)
{
    return array.slice(from, to);
});

var _JsArray_appendN = F3(function(n, dest, source)
{
    var destLen = dest.length;
    var itemsToCopy = n - destLen;

    if (itemsToCopy > source.length)
    {
        itemsToCopy = source.length;
    }

    var size = destLen + itemsToCopy;
    var result = new Array(size);

    for (var i = 0; i < destLen; i++)
    {
        result[i] = dest[i];
    }

    for (var i = 0; i < itemsToCopy; i++)
    {
        result[i + destLen] = source[i];
    }

    return result;
});



// LOG

var _Debug_log = F2(function(tag, value)
{
	return value;
});

var _Debug_log_UNUSED = F2(function(tag, value)
{
	console.log(tag + ': ' + _Debug_toString(value));
	return value;
});


// TODOS

function _Debug_todo(moduleName, region)
{
	return function(message) {
		_Debug_crash(8, moduleName, region, message);
	};
}

function _Debug_todoCase(moduleName, region, value)
{
	return function(message) {
		_Debug_crash(9, moduleName, region, value, message);
	};
}


// TO STRING

function _Debug_toString(value)
{
	return '<internals>';
}

function _Debug_toString_UNUSED(value)
{
	return _Debug_toAnsiString(false, value);
}

function _Debug_toAnsiString(ansi, value)
{
	if (typeof value === 'function')
	{
		return _Debug_internalColor(ansi, '<function>');
	}

	if (typeof value === 'boolean')
	{
		return _Debug_ctorColor(ansi, value ? 'True' : 'False');
	}

	if (typeof value === 'number')
	{
		return _Debug_numberColor(ansi, value + '');
	}

	if (value instanceof String)
	{
		return _Debug_charColor(ansi, "'" + _Debug_addSlashes(value, true) + "'");
	}

	if (typeof value === 'string')
	{
		return _Debug_stringColor(ansi, '"' + _Debug_addSlashes(value, false) + '"');
	}

	if (typeof value === 'object' && '$' in value)
	{
		var tag = value.$;

		if (typeof tag === 'number')
		{
			return _Debug_internalColor(ansi, '<internals>');
		}

		if (tag[0] === '#')
		{
			var output = [];
			for (var k in value)
			{
				if (k === '$') continue;
				output.push(_Debug_toAnsiString(ansi, value[k]));
			}
			return '(' + output.join(',') + ')';
		}

		if (tag === 'Set_elm_builtin')
		{
			return _Debug_ctorColor(ansi, 'Set')
				+ _Debug_fadeColor(ansi, '.fromList') + ' '
				+ _Debug_toAnsiString(ansi, $elm$core$Set$toList(value));
		}

		if (tag === 'RBNode_elm_builtin' || tag === 'RBEmpty_elm_builtin')
		{
			return _Debug_ctorColor(ansi, 'Dict')
				+ _Debug_fadeColor(ansi, '.fromList') + ' '
				+ _Debug_toAnsiString(ansi, $elm$core$Dict$toList(value));
		}

		if (tag === 'Array_elm_builtin')
		{
			return _Debug_ctorColor(ansi, 'Array')
				+ _Debug_fadeColor(ansi, '.fromList') + ' '
				+ _Debug_toAnsiString(ansi, $elm$core$Array$toList(value));
		}

		if (tag === '::' || tag === '[]')
		{
			var output = '[';

			value.b && (output += _Debug_toAnsiString(ansi, value.a), value = value.b)

			for (; value.b; value = value.b) // WHILE_CONS
			{
				output += ',' + _Debug_toAnsiString(ansi, value.a);
			}
			return output + ']';
		}

		var output = '';
		for (var i in value)
		{
			if (i === '$') continue;
			var str = _Debug_toAnsiString(ansi, value[i]);
			var c0 = str[0];
			var parenless = c0 === '{' || c0 === '(' || c0 === '[' || c0 === '<' || c0 === '"' || str.indexOf(' ') < 0;
			output += ' ' + (parenless ? str : '(' + str + ')');
		}
		return _Debug_ctorColor(ansi, tag) + output;
	}

	if (typeof DataView === 'function' && value instanceof DataView)
	{
		return _Debug_stringColor(ansi, '<' + value.byteLength + ' bytes>');
	}

	if (typeof File !== 'undefined' && value instanceof File)
	{
		return _Debug_internalColor(ansi, '<' + value.name + '>');
	}

	if (typeof value === 'object')
	{
		var output = [];
		for (var key in value)
		{
			var field = key[0] === '_' ? key.slice(1) : key;
			output.push(_Debug_fadeColor(ansi, field) + ' = ' + _Debug_toAnsiString(ansi, value[key]));
		}
		if (output.length === 0)
		{
			return '{}';
		}
		return '{ ' + output.join(', ') + ' }';
	}

	return _Debug_internalColor(ansi, '<internals>');
}

function _Debug_addSlashes(str, isChar)
{
	var s = str
		.replace(/\\/g, '\\\\')
		.replace(/\n/g, '\\n')
		.replace(/\t/g, '\\t')
		.replace(/\r/g, '\\r')
		.replace(/\v/g, '\\v')
		.replace(/\0/g, '\\0');

	if (isChar)
	{
		return s.replace(/\'/g, '\\\'');
	}
	else
	{
		return s.replace(/\"/g, '\\"');
	}
}

function _Debug_ctorColor(ansi, string)
{
	return ansi ? '\x1b[96m' + string + '\x1b[0m' : string;
}

function _Debug_numberColor(ansi, string)
{
	return ansi ? '\x1b[95m' + string + '\x1b[0m' : string;
}

function _Debug_stringColor(ansi, string)
{
	return ansi ? '\x1b[93m' + string + '\x1b[0m' : string;
}

function _Debug_charColor(ansi, string)
{
	return ansi ? '\x1b[92m' + string + '\x1b[0m' : string;
}

function _Debug_fadeColor(ansi, string)
{
	return ansi ? '\x1b[37m' + string + '\x1b[0m' : string;
}

function _Debug_internalColor(ansi, string)
{
	return ansi ? '\x1b[36m' + string + '\x1b[0m' : string;
}

function _Debug_toHexDigit(n)
{
	return String.fromCharCode(n < 10 ? 48 + n : 55 + n);
}


// CRASH


function _Debug_crash(identifier)
{
	throw new Error('https://github.com/elm/core/blob/1.0.0/hints/' + identifier + '.md');
}


function _Debug_crash_UNUSED(identifier, fact1, fact2, fact3, fact4)
{
	switch(identifier)
	{
		case 0:
			throw new Error('What node should I take over? In JavaScript I need something like:\n\n    Elm.Main.init({\n        node: document.getElementById("elm-node")\n    })\n\nYou need to do this with any Browser.sandbox or Browser.element program.');

		case 1:
			throw new Error('Browser.application programs cannot handle URLs like this:\n\n    ' + document.location.href + '\n\nWhat is the root? The root of your file system? Try looking at this program with `elm reactor` or some other server.');

		case 2:
			var jsonErrorString = fact1;
			throw new Error('Problem with the flags given to your Elm program on initialization.\n\n' + jsonErrorString);

		case 3:
			var portName = fact1;
			throw new Error('There can only be one port named `' + portName + '`, but your program has multiple.');

		case 4:
			var portName = fact1;
			var problem = fact2;
			throw new Error('Trying to send an unexpected type of value through port `' + portName + '`:\n' + problem);

		case 5:
			throw new Error('Trying to use `(==)` on functions.\nThere is no way to know if functions are "the same" in the Elm sense.\nRead more about this at https://package.elm-lang.org/packages/elm/core/latest/Basics#== which describes why it is this way and what the better version will look like.');

		case 6:
			var moduleName = fact1;
			throw new Error('Your page is loading multiple Elm scripts with a module named ' + moduleName + '. Maybe a duplicate script is getting loaded accidentally? If not, rename one of them so I know which is which!');

		case 8:
			var moduleName = fact1;
			var region = fact2;
			var message = fact3;
			throw new Error('TODO in module `' + moduleName + '` ' + _Debug_regionToString(region) + '\n\n' + message);

		case 9:
			var moduleName = fact1;
			var region = fact2;
			var value = fact3;
			var message = fact4;
			throw new Error(
				'TODO in module `' + moduleName + '` from the `case` expression '
				+ _Debug_regionToString(region) + '\n\nIt received the following value:\n\n    '
				+ _Debug_toString(value).replace('\n', '\n    ')
				+ '\n\nBut the branch that handles it says:\n\n    ' + message.replace('\n', '\n    ')
			);

		case 10:
			throw new Error('Bug in https://github.com/elm/virtual-dom/issues');

		case 11:
			throw new Error('Cannot perform mod 0. Division by zero error.');
	}
}

function _Debug_regionToString(region)
{
	if (region.it.cg === region.hg.cg)
	{
		return 'on line ' + region.it.cg;
	}
	return 'on lines ' + region.it.cg + ' through ' + region.hg.cg;
}



// EQUALITY

function _Utils_eq(x, y)
{
	for (
		var pair, stack = [], isEqual = _Utils_eqHelp(x, y, 0, stack);
		isEqual && (pair = stack.pop());
		isEqual = _Utils_eqHelp(pair.a, pair.b, 0, stack)
		)
	{}

	return isEqual;
}

function _Utils_eqHelp(x, y, depth, stack)
{
	if (x === y)
	{
		return true;
	}

	if (typeof x !== 'object' || x === null || y === null)
	{
		typeof x === 'function' && _Debug_crash(5);
		return false;
	}

	if (depth > 100)
	{
		stack.push(_Utils_Tuple2(x,y));
		return true;
	}

	/**_UNUSED/
	if (x.$ === 'Set_elm_builtin')
	{
		x = $elm$core$Set$toList(x);
		y = $elm$core$Set$toList(y);
	}
	if (x.$ === 'RBNode_elm_builtin' || x.$ === 'RBEmpty_elm_builtin')
	{
		x = $elm$core$Dict$toList(x);
		y = $elm$core$Dict$toList(y);
	}
	//*/

	/**/
	if (x.$ < 0)
	{
		x = $elm$core$Dict$toList(x);
		y = $elm$core$Dict$toList(y);
	}
	//*/

	for (var key in x)
	{
		if (!_Utils_eqHelp(x[key], y[key], depth + 1, stack))
		{
			return false;
		}
	}
	return true;
}

var _Utils_equal = F2(_Utils_eq);
var _Utils_notEqual = F2(function(a, b) { return !_Utils_eq(a,b); });



// COMPARISONS

// Code in Generate/JavaScript.hs, Basics.js, and List.js depends on
// the particular integer values assigned to LT, EQ, and GT.

function _Utils_cmp(x, y, ord)
{
	if (typeof x !== 'object')
	{
		return x === y ? /*EQ*/ 0 : x < y ? /*LT*/ -1 : /*GT*/ 1;
	}

	/**_UNUSED/
	if (x instanceof String)
	{
		var a = x.valueOf();
		var b = y.valueOf();
		return a === b ? 0 : a < b ? -1 : 1;
	}
	//*/

	/**/
	if (typeof x.$ === 'undefined')
	//*/
	/**_UNUSED/
	if (x.$[0] === '#')
	//*/
	{
		return (ord = _Utils_cmp(x.a, y.a))
			? ord
			: (ord = _Utils_cmp(x.b, y.b))
				? ord
				: _Utils_cmp(x.c, y.c);
	}

	// traverse conses until end of a list or a mismatch
	for (; x.b && y.b && !(ord = _Utils_cmp(x.a, y.a)); x = x.b, y = y.b) {} // WHILE_CONSES
	return ord || (x.b ? /*GT*/ 1 : y.b ? /*LT*/ -1 : /*EQ*/ 0);
}

var _Utils_lt = F2(function(a, b) { return _Utils_cmp(a, b) < 0; });
var _Utils_le = F2(function(a, b) { return _Utils_cmp(a, b) < 1; });
var _Utils_gt = F2(function(a, b) { return _Utils_cmp(a, b) > 0; });
var _Utils_ge = F2(function(a, b) { return _Utils_cmp(a, b) >= 0; });

var _Utils_compare = F2(function(x, y)
{
	var n = _Utils_cmp(x, y);
	return n < 0 ? $elm$core$Basics$LT : n ? $elm$core$Basics$GT : $elm$core$Basics$EQ;
});


// COMMON VALUES

var _Utils_Tuple0 = 0;
var _Utils_Tuple0_UNUSED = { $: '#0' };

function _Utils_Tuple2(a, b) { return { a: a, b: b }; }
function _Utils_Tuple2_UNUSED(a, b) { return { $: '#2', a: a, b: b }; }

function _Utils_Tuple3(a, b, c) { return { a: a, b: b, c: c }; }
function _Utils_Tuple3_UNUSED(a, b, c) { return { $: '#3', a: a, b: b, c: c }; }

function _Utils_chr(c) { return c; }
function _Utils_chr_UNUSED(c) { return new String(c); }


// RECORDS

function _Utils_update(oldRecord, updatedFields)
{
	var newRecord = {};

	for (var key in oldRecord)
	{
		newRecord[key] = oldRecord[key];
	}

	for (var key in updatedFields)
	{
		newRecord[key] = updatedFields[key];
	}

	return newRecord;
}


// APPEND

var _Utils_append = F2(_Utils_ap);

function _Utils_ap(xs, ys)
{
	// append Strings
	if (typeof xs === 'string')
	{
		return xs + ys;
	}

	// append Lists
	if (!xs.b)
	{
		return ys;
	}
	var root = _List_Cons(xs.a, ys);
	xs = xs.b
	for (var curr = root; xs.b; xs = xs.b) // WHILE_CONS
	{
		curr = curr.b = _List_Cons(xs.a, ys);
	}
	return root;
}



var _List_Nil = { $: 0 };
var _List_Nil_UNUSED = { $: '[]' };

function _List_Cons(hd, tl) { return { $: 1, a: hd, b: tl }; }
function _List_Cons_UNUSED(hd, tl) { return { $: '::', a: hd, b: tl }; }


var _List_cons = F2(_List_Cons);

function _List_fromArray(arr)
{
	var out = _List_Nil;
	for (var i = arr.length; i--; )
	{
		out = _List_Cons(arr[i], out);
	}
	return out;
}

function _List_toArray(xs)
{
	for (var out = []; xs.b; xs = xs.b) // WHILE_CONS
	{
		out.push(xs.a);
	}
	return out;
}

var _List_map2 = F3(function(f, xs, ys)
{
	for (var arr = []; xs.b && ys.b; xs = xs.b, ys = ys.b) // WHILE_CONSES
	{
		arr.push(A2(f, xs.a, ys.a));
	}
	return _List_fromArray(arr);
});

var _List_map3 = F4(function(f, xs, ys, zs)
{
	for (var arr = []; xs.b && ys.b && zs.b; xs = xs.b, ys = ys.b, zs = zs.b) // WHILE_CONSES
	{
		arr.push(A3(f, xs.a, ys.a, zs.a));
	}
	return _List_fromArray(arr);
});

var _List_map4 = F5(function(f, ws, xs, ys, zs)
{
	for (var arr = []; ws.b && xs.b && ys.b && zs.b; ws = ws.b, xs = xs.b, ys = ys.b, zs = zs.b) // WHILE_CONSES
	{
		arr.push(A4(f, ws.a, xs.a, ys.a, zs.a));
	}
	return _List_fromArray(arr);
});

var _List_map5 = F6(function(f, vs, ws, xs, ys, zs)
{
	for (var arr = []; vs.b && ws.b && xs.b && ys.b && zs.b; vs = vs.b, ws = ws.b, xs = xs.b, ys = ys.b, zs = zs.b) // WHILE_CONSES
	{
		arr.push(A5(f, vs.a, ws.a, xs.a, ys.a, zs.a));
	}
	return _List_fromArray(arr);
});

var _List_sortBy = F2(function(f, xs)
{
	return _List_fromArray(_List_toArray(xs).sort(function(a, b) {
		return _Utils_cmp(f(a), f(b));
	}));
});

var _List_sortWith = F2(function(f, xs)
{
	return _List_fromArray(_List_toArray(xs).sort(function(a, b) {
		var ord = A2(f, a, b);
		return ord === $elm$core$Basics$EQ ? 0 : ord === $elm$core$Basics$LT ? -1 : 1;
	}));
});



// MATH

var _Basics_add = F2(function(a, b) { return a + b; });
var _Basics_sub = F2(function(a, b) { return a - b; });
var _Basics_mul = F2(function(a, b) { return a * b; });
var _Basics_fdiv = F2(function(a, b) { return a / b; });
var _Basics_idiv = F2(function(a, b) { return (a / b) | 0; });
var _Basics_pow = F2(Math.pow);

var _Basics_remainderBy = F2(function(b, a) { return a % b; });

// https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/divmodnote-letter.pdf
var _Basics_modBy = F2(function(modulus, x)
{
	var answer = x % modulus;
	return modulus === 0
		? _Debug_crash(11)
		:
	((answer > 0 && modulus < 0) || (answer < 0 && modulus > 0))
		? answer + modulus
		: answer;
});


// TRIGONOMETRY

var _Basics_pi = Math.PI;
var _Basics_e = Math.E;
var _Basics_cos = Math.cos;
var _Basics_sin = Math.sin;
var _Basics_tan = Math.tan;
var _Basics_acos = Math.acos;
var _Basics_asin = Math.asin;
var _Basics_atan = Math.atan;
var _Basics_atan2 = F2(Math.atan2);


// MORE MATH

function _Basics_toFloat(x) { return x; }
function _Basics_truncate(n) { return n | 0; }
function _Basics_isInfinite(n) { return n === Infinity || n === -Infinity; }

var _Basics_ceiling = Math.ceil;
var _Basics_floor = Math.floor;
var _Basics_round = Math.round;
var _Basics_sqrt = Math.sqrt;
var _Basics_log = Math.log;
var _Basics_isNaN = isNaN;


// BOOLEANS

function _Basics_not(bool) { return !bool; }
var _Basics_and = F2(function(a, b) { return a && b; });
var _Basics_or  = F2(function(a, b) { return a || b; });
var _Basics_xor = F2(function(a, b) { return a !== b; });



var _String_cons = F2(function(chr, str)
{
	return chr + str;
});

function _String_uncons(string)
{
	var word = string.charCodeAt(0);
	return !isNaN(word)
		? $elm$core$Maybe$Just(
			0xD800 <= word && word <= 0xDBFF
				? _Utils_Tuple2(_Utils_chr(string[0] + string[1]), string.slice(2))
				: _Utils_Tuple2(_Utils_chr(string[0]), string.slice(1))
		)
		: $elm$core$Maybe$Nothing;
}

var _String_append = F2(function(a, b)
{
	return a + b;
});

function _String_length(str)
{
	return str.length;
}

var _String_map = F2(function(func, string)
{
	var len = string.length;
	var array = new Array(len);
	var i = 0;
	while (i < len)
	{
		var word = string.charCodeAt(i);
		if (0xD800 <= word && word <= 0xDBFF)
		{
			array[i] = func(_Utils_chr(string[i] + string[i+1]));
			i += 2;
			continue;
		}
		array[i] = func(_Utils_chr(string[i]));
		i++;
	}
	return array.join('');
});

var _String_filter = F2(function(isGood, str)
{
	var arr = [];
	var len = str.length;
	var i = 0;
	while (i < len)
	{
		var char = str[i];
		var word = str.charCodeAt(i);
		i++;
		if (0xD800 <= word && word <= 0xDBFF)
		{
			char += str[i];
			i++;
		}

		if (isGood(_Utils_chr(char)))
		{
			arr.push(char);
		}
	}
	return arr.join('');
});

function _String_reverse(str)
{
	var len = str.length;
	var arr = new Array(len);
	var i = 0;
	while (i < len)
	{
		var word = str.charCodeAt(i);
		if (0xD800 <= word && word <= 0xDBFF)
		{
			arr[len - i] = str[i + 1];
			i++;
			arr[len - i] = str[i - 1];
			i++;
		}
		else
		{
			arr[len - i] = str[i];
			i++;
		}
	}
	return arr.join('');
}

var _String_foldl = F3(function(func, state, string)
{
	var len = string.length;
	var i = 0;
	while (i < len)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		i++;
		if (0xD800 <= word && word <= 0xDBFF)
		{
			char += string[i];
			i++;
		}
		state = A2(func, _Utils_chr(char), state);
	}
	return state;
});

var _String_foldr = F3(function(func, state, string)
{
	var i = string.length;
	while (i--)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		if (0xDC00 <= word && word <= 0xDFFF)
		{
			i--;
			char = string[i] + char;
		}
		state = A2(func, _Utils_chr(char), state);
	}
	return state;
});

var _String_split = F2(function(sep, str)
{
	return str.split(sep);
});

var _String_join = F2(function(sep, strs)
{
	return strs.join(sep);
});

var _String_slice = F3(function(start, end, str) {
	return str.slice(start, end);
});

function _String_trim(str)
{
	return str.trim();
}

function _String_trimLeft(str)
{
	return str.replace(/^\s+/, '');
}

function _String_trimRight(str)
{
	return str.replace(/\s+$/, '');
}

function _String_words(str)
{
	return _List_fromArray(str.trim().split(/\s+/g));
}

function _String_lines(str)
{
	return _List_fromArray(str.split(/\r\n|\r|\n/g));
}

function _String_toUpper(str)
{
	return str.toUpperCase();
}

function _String_toLower(str)
{
	return str.toLowerCase();
}

var _String_any = F2(function(isGood, string)
{
	var i = string.length;
	while (i--)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		if (0xDC00 <= word && word <= 0xDFFF)
		{
			i--;
			char = string[i] + char;
		}
		if (isGood(_Utils_chr(char)))
		{
			return true;
		}
	}
	return false;
});

var _String_all = F2(function(isGood, string)
{
	var i = string.length;
	while (i--)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		if (0xDC00 <= word && word <= 0xDFFF)
		{
			i--;
			char = string[i] + char;
		}
		if (!isGood(_Utils_chr(char)))
		{
			return false;
		}
	}
	return true;
});

var _String_contains = F2(function(sub, str)
{
	return str.indexOf(sub) > -1;
});

var _String_startsWith = F2(function(sub, str)
{
	return str.indexOf(sub) === 0;
});

var _String_endsWith = F2(function(sub, str)
{
	return str.length >= sub.length &&
		str.lastIndexOf(sub) === str.length - sub.length;
});

var _String_indexes = F2(function(sub, str)
{
	var subLen = sub.length;

	if (subLen < 1)
	{
		return _List_Nil;
	}

	var i = 0;
	var is = [];

	while ((i = str.indexOf(sub, i)) > -1)
	{
		is.push(i);
		i = i + subLen;
	}

	return _List_fromArray(is);
});


// TO STRING

function _String_fromNumber(number)
{
	return number + '';
}


// INT CONVERSIONS

function _String_toInt(str)
{
	var total = 0;
	var code0 = str.charCodeAt(0);
	var start = code0 == 0x2B /* + */ || code0 == 0x2D /* - */ ? 1 : 0;

	for (var i = start; i < str.length; ++i)
	{
		var code = str.charCodeAt(i);
		if (code < 0x30 || 0x39 < code)
		{
			return $elm$core$Maybe$Nothing;
		}
		total = 10 * total + code - 0x30;
	}

	return i == start
		? $elm$core$Maybe$Nothing
		: $elm$core$Maybe$Just(code0 == 0x2D ? -total : total);
}


// FLOAT CONVERSIONS

function _String_toFloat(s)
{
	// check if it is a hex, octal, or binary number
	if (s.length === 0 || /[\sxbo]/.test(s))
	{
		return $elm$core$Maybe$Nothing;
	}
	var n = +s;
	// faster isNaN check
	return n === n ? $elm$core$Maybe$Just(n) : $elm$core$Maybe$Nothing;
}

function _String_fromList(chars)
{
	return _List_toArray(chars).join('');
}




function _Char_toCode(char)
{
	var code = char.charCodeAt(0);
	if (0xD800 <= code && code <= 0xDBFF)
	{
		return (code - 0xD800) * 0x400 + char.charCodeAt(1) - 0xDC00 + 0x10000
	}
	return code;
}

function _Char_fromCode(code)
{
	return _Utils_chr(
		(code < 0 || 0x10FFFF < code)
			? '\uFFFD'
			:
		(code <= 0xFFFF)
			? String.fromCharCode(code)
			:
		(code -= 0x10000,
			String.fromCharCode(Math.floor(code / 0x400) + 0xD800, code % 0x400 + 0xDC00)
		)
	);
}

function _Char_toUpper(char)
{
	return _Utils_chr(char.toUpperCase());
}

function _Char_toLower(char)
{
	return _Utils_chr(char.toLowerCase());
}

function _Char_toLocaleUpper(char)
{
	return _Utils_chr(char.toLocaleUpperCase());
}

function _Char_toLocaleLower(char)
{
	return _Utils_chr(char.toLocaleLowerCase());
}



/**_UNUSED/
function _Json_errorToString(error)
{
	return $elm$json$Json$Decode$errorToString(error);
}
//*/


// CORE DECODERS

function _Json_succeed(msg)
{
	return {
		$: 0,
		a: msg
	};
}

function _Json_fail(msg)
{
	return {
		$: 1,
		a: msg
	};
}

function _Json_decodePrim(decoder)
{
	return { $: 2, b: decoder };
}

var _Json_decodeInt = _Json_decodePrim(function(value) {
	return (typeof value !== 'number')
		? _Json_expecting('an INT', value)
		:
	(-2147483647 < value && value < 2147483647 && (value | 0) === value)
		? $elm$core$Result$Ok(value)
		:
	(isFinite(value) && !(value % 1))
		? $elm$core$Result$Ok(value)
		: _Json_expecting('an INT', value);
});

var _Json_decodeBool = _Json_decodePrim(function(value) {
	return (typeof value === 'boolean')
		? $elm$core$Result$Ok(value)
		: _Json_expecting('a BOOL', value);
});

var _Json_decodeFloat = _Json_decodePrim(function(value) {
	return (typeof value === 'number')
		? $elm$core$Result$Ok(value)
		: _Json_expecting('a FLOAT', value);
});

var _Json_decodeValue = _Json_decodePrim(function(value) {
	return $elm$core$Result$Ok(_Json_wrap(value));
});

var _Json_decodeString = _Json_decodePrim(function(value) {
	return (typeof value === 'string')
		? $elm$core$Result$Ok(value)
		: (value instanceof String)
			? $elm$core$Result$Ok(value + '')
			: _Json_expecting('a STRING', value);
});

function _Json_decodeList(decoder) { return { $: 3, b: decoder }; }
function _Json_decodeArray(decoder) { return { $: 4, b: decoder }; }

function _Json_decodeNull(value) { return { $: 5, c: value }; }

var _Json_decodeField = F2(function(field, decoder)
{
	return {
		$: 6,
		d: field,
		b: decoder
	};
});

var _Json_decodeIndex = F2(function(index, decoder)
{
	return {
		$: 7,
		e: index,
		b: decoder
	};
});

function _Json_decodeKeyValuePairs(decoder)
{
	return {
		$: 8,
		b: decoder
	};
}

function _Json_mapMany(f, decoders)
{
	return {
		$: 9,
		f: f,
		g: decoders
	};
}

var _Json_andThen = F2(function(callback, decoder)
{
	return {
		$: 10,
		b: decoder,
		h: callback
	};
});

function _Json_oneOf(decoders)
{
	return {
		$: 11,
		g: decoders
	};
}


// DECODING OBJECTS

var _Json_map1 = F2(function(f, d1)
{
	return _Json_mapMany(f, [d1]);
});

var _Json_map2 = F3(function(f, d1, d2)
{
	return _Json_mapMany(f, [d1, d2]);
});

var _Json_map3 = F4(function(f, d1, d2, d3)
{
	return _Json_mapMany(f, [d1, d2, d3]);
});

var _Json_map4 = F5(function(f, d1, d2, d3, d4)
{
	return _Json_mapMany(f, [d1, d2, d3, d4]);
});

var _Json_map5 = F6(function(f, d1, d2, d3, d4, d5)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5]);
});

var _Json_map6 = F7(function(f, d1, d2, d3, d4, d5, d6)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5, d6]);
});

var _Json_map7 = F8(function(f, d1, d2, d3, d4, d5, d6, d7)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5, d6, d7]);
});

var _Json_map8 = F9(function(f, d1, d2, d3, d4, d5, d6, d7, d8)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5, d6, d7, d8]);
});


// DECODE

var _Json_runOnString = F2(function(decoder, string)
{
	try
	{
		var value = JSON.parse(string);
		return _Json_runHelp(decoder, value);
	}
	catch (e)
	{
		return $elm$core$Result$Err(A2($elm$json$Json$Decode$Failure, 'This is not valid JSON! ' + e.message, _Json_wrap(string)));
	}
});

var _Json_run = F2(function(decoder, value)
{
	return _Json_runHelp(decoder, _Json_unwrap(value));
});

function _Json_runHelp(decoder, value)
{
	switch (decoder.$)
	{
		case 2:
			return decoder.b(value);

		case 5:
			return (value === null)
				? $elm$core$Result$Ok(decoder.c)
				: _Json_expecting('null', value);

		case 3:
			if (!_Json_isArray(value))
			{
				return _Json_expecting('a LIST', value);
			}
			return _Json_runArrayDecoder(decoder.b, value, _List_fromArray);

		case 4:
			if (!_Json_isArray(value))
			{
				return _Json_expecting('an ARRAY', value);
			}
			return _Json_runArrayDecoder(decoder.b, value, _Json_toElmArray);

		case 6:
			var field = decoder.d;
			if (typeof value !== 'object' || value === null || !(field in value))
			{
				return _Json_expecting('an OBJECT with a field named `' + field + '`', value);
			}
			var result = _Json_runHelp(decoder.b, value[field]);
			return ($elm$core$Result$isOk(result)) ? result : $elm$core$Result$Err(A2($elm$json$Json$Decode$Field, field, result.a));

		case 7:
			var index = decoder.e;
			if (!_Json_isArray(value))
			{
				return _Json_expecting('an ARRAY', value);
			}
			if (index >= value.length)
			{
				return _Json_expecting('a LONGER array. Need index ' + index + ' but only see ' + value.length + ' entries', value);
			}
			var result = _Json_runHelp(decoder.b, value[index]);
			return ($elm$core$Result$isOk(result)) ? result : $elm$core$Result$Err(A2($elm$json$Json$Decode$Index, index, result.a));

		case 8:
			if (typeof value !== 'object' || value === null || _Json_isArray(value))
			{
				return _Json_expecting('an OBJECT', value);
			}

			var keyValuePairs = _List_Nil;
			// TODO test perf of Object.keys and switch when support is good enough
			for (var key in value)
			{
				if (value.hasOwnProperty(key))
				{
					var result = _Json_runHelp(decoder.b, value[key]);
					if (!$elm$core$Result$isOk(result))
					{
						return $elm$core$Result$Err(A2($elm$json$Json$Decode$Field, key, result.a));
					}
					keyValuePairs = _List_Cons(_Utils_Tuple2(key, result.a), keyValuePairs);
				}
			}
			return $elm$core$Result$Ok($elm$core$List$reverse(keyValuePairs));

		case 9:
			var answer = decoder.f;
			var decoders = decoder.g;
			for (var i = 0; i < decoders.length; i++)
			{
				var result = _Json_runHelp(decoders[i], value);
				if (!$elm$core$Result$isOk(result))
				{
					return result;
				}
				answer = answer(result.a);
			}
			return $elm$core$Result$Ok(answer);

		case 10:
			var result = _Json_runHelp(decoder.b, value);
			return (!$elm$core$Result$isOk(result))
				? result
				: _Json_runHelp(decoder.h(result.a), value);

		case 11:
			var errors = _List_Nil;
			for (var temp = decoder.g; temp.b; temp = temp.b) // WHILE_CONS
			{
				var result = _Json_runHelp(temp.a, value);
				if ($elm$core$Result$isOk(result))
				{
					return result;
				}
				errors = _List_Cons(result.a, errors);
			}
			return $elm$core$Result$Err($elm$json$Json$Decode$OneOf($elm$core$List$reverse(errors)));

		case 1:
			return $elm$core$Result$Err(A2($elm$json$Json$Decode$Failure, decoder.a, _Json_wrap(value)));

		case 0:
			return $elm$core$Result$Ok(decoder.a);
	}
}

function _Json_runArrayDecoder(decoder, value, toElmValue)
{
	var len = value.length;
	var array = new Array(len);
	for (var i = 0; i < len; i++)
	{
		var result = _Json_runHelp(decoder, value[i]);
		if (!$elm$core$Result$isOk(result))
		{
			return $elm$core$Result$Err(A2($elm$json$Json$Decode$Index, i, result.a));
		}
		array[i] = result.a;
	}
	return $elm$core$Result$Ok(toElmValue(array));
}

function _Json_isArray(value)
{
	return Array.isArray(value) || (typeof FileList !== 'undefined' && value instanceof FileList);
}

function _Json_toElmArray(array)
{
	return A2($elm$core$Array$initialize, array.length, function(i) { return array[i]; });
}

function _Json_expecting(type, value)
{
	return $elm$core$Result$Err(A2($elm$json$Json$Decode$Failure, 'Expecting ' + type, _Json_wrap(value)));
}


// EQUALITY

function _Json_equality(x, y)
{
	if (x === y)
	{
		return true;
	}

	if (x.$ !== y.$)
	{
		return false;
	}

	switch (x.$)
	{
		case 0:
		case 1:
			return x.a === y.a;

		case 2:
			return x.b === y.b;

		case 5:
			return x.c === y.c;

		case 3:
		case 4:
		case 8:
			return _Json_equality(x.b, y.b);

		case 6:
			return x.d === y.d && _Json_equality(x.b, y.b);

		case 7:
			return x.e === y.e && _Json_equality(x.b, y.b);

		case 9:
			return x.f === y.f && _Json_listEquality(x.g, y.g);

		case 10:
			return x.h === y.h && _Json_equality(x.b, y.b);

		case 11:
			return _Json_listEquality(x.g, y.g);
	}
}

function _Json_listEquality(aDecoders, bDecoders)
{
	var len = aDecoders.length;
	if (len !== bDecoders.length)
	{
		return false;
	}
	for (var i = 0; i < len; i++)
	{
		if (!_Json_equality(aDecoders[i], bDecoders[i]))
		{
			return false;
		}
	}
	return true;
}


// ENCODE

var _Json_encode = F2(function(indentLevel, value)
{
	return JSON.stringify(_Json_unwrap(value), null, indentLevel) + '';
});

function _Json_wrap_UNUSED(value) { return { $: 0, a: value }; }
function _Json_unwrap_UNUSED(value) { return value.a; }

function _Json_wrap(value) { return value; }
function _Json_unwrap(value) { return value; }

function _Json_emptyArray() { return []; }
function _Json_emptyObject() { return {}; }

var _Json_addField = F3(function(key, value, object)
{
	object[key] = _Json_unwrap(value);
	return object;
});

function _Json_addEntry(func)
{
	return F2(function(entry, array)
	{
		array.push(_Json_unwrap(func(entry)));
		return array;
	});
}

var _Json_encodeNull = _Json_wrap(null);



// TASKS

function _Scheduler_succeed(value)
{
	return {
		$: 0,
		a: value
	};
}

function _Scheduler_fail(error)
{
	return {
		$: 1,
		a: error
	};
}

function _Scheduler_binding(callback)
{
	return {
		$: 2,
		b: callback,
		c: null
	};
}

var _Scheduler_andThen = F2(function(callback, task)
{
	return {
		$: 3,
		b: callback,
		d: task
	};
});

var _Scheduler_onError = F2(function(callback, task)
{
	return {
		$: 4,
		b: callback,
		d: task
	};
});

function _Scheduler_receive(callback)
{
	return {
		$: 5,
		b: callback
	};
}


// PROCESSES

var _Scheduler_guid = 0;

function _Scheduler_rawSpawn(task)
{
	var proc = {
		$: 0,
		e: _Scheduler_guid++,
		f: task,
		g: null,
		h: []
	};

	_Scheduler_enqueue(proc);

	return proc;
}

function _Scheduler_spawn(task)
{
	return _Scheduler_binding(function(callback) {
		callback(_Scheduler_succeed(_Scheduler_rawSpawn(task)));
	});
}

function _Scheduler_rawSend(proc, msg)
{
	proc.h.push(msg);
	_Scheduler_enqueue(proc);
}

var _Scheduler_send = F2(function(proc, msg)
{
	return _Scheduler_binding(function(callback) {
		_Scheduler_rawSend(proc, msg);
		callback(_Scheduler_succeed(_Utils_Tuple0));
	});
});

function _Scheduler_kill(proc)
{
	return _Scheduler_binding(function(callback) {
		var task = proc.f;
		if (task.$ === 2 && task.c)
		{
			task.c();
		}

		proc.f = null;

		callback(_Scheduler_succeed(_Utils_Tuple0));
	});
}


/* STEP PROCESSES

type alias Process =
  { $ : tag
  , id : unique_id
  , root : Task
  , stack : null | { $: SUCCEED | FAIL, a: callback, b: stack }
  , mailbox : [msg]
  }

*/


var _Scheduler_working = false;
var _Scheduler_queue = [];


function _Scheduler_enqueue(proc)
{
	_Scheduler_queue.push(proc);
	if (_Scheduler_working)
	{
		return;
	}
	_Scheduler_working = true;
	while (proc = _Scheduler_queue.shift())
	{
		_Scheduler_step(proc);
	}
	_Scheduler_working = false;
}


function _Scheduler_step(proc)
{
	while (proc.f)
	{
		var rootTag = proc.f.$;
		if (rootTag === 0 || rootTag === 1)
		{
			while (proc.g && proc.g.$ !== rootTag)
			{
				proc.g = proc.g.i;
			}
			if (!proc.g)
			{
				return;
			}
			proc.f = proc.g.b(proc.f.a);
			proc.g = proc.g.i;
		}
		else if (rootTag === 2)
		{
			proc.f.c = proc.f.b(function(newRoot) {
				proc.f = newRoot;
				_Scheduler_enqueue(proc);
			});
			return;
		}
		else if (rootTag === 5)
		{
			if (proc.h.length === 0)
			{
				return;
			}
			proc.f = proc.f.b(proc.h.shift());
		}
		else // if (rootTag === 3 || rootTag === 4)
		{
			proc.g = {
				$: rootTag === 3 ? 0 : 1,
				b: proc.f.b,
				i: proc.g
			};
			proc.f = proc.f.d;
		}
	}
}



function _Process_sleep(time)
{
	return _Scheduler_binding(function(callback) {
		var id = setTimeout(function() {
			callback(_Scheduler_succeed(_Utils_Tuple0));
		}, time);

		return function() { clearTimeout(id); };
	});
}




// PROGRAMS


var _Platform_worker = F4(function(impl, flagDecoder, debugMetadata, args)
{
	return _Platform_initialize(
		flagDecoder,
		args,
		impl.hv,
		impl.iM,
		impl.iz,
		function() { return function() {} }
	);
});



// INITIALIZE A PROGRAM


function _Platform_initialize(flagDecoder, args, init, update, subscriptions, stepperBuilder)
{
	var result = A2(_Json_run, flagDecoder, _Json_wrap(args ? args['flags'] : undefined));
	$elm$core$Result$isOk(result) || _Debug_crash(2 /**_UNUSED/, _Json_errorToString(result.a) /**/);
	var managers = {};
	var initPair = init(result.a);
	var model = initPair.a;
	var stepper = stepperBuilder(sendToApp, model);
	var ports = _Platform_setupEffects(managers, sendToApp);

	function sendToApp(msg, viewMetadata)
	{
		var pair = A2(update, msg, model);
		stepper(model = pair.a, viewMetadata);
		_Platform_enqueueEffects(managers, pair.b, subscriptions(model));
	}

	_Platform_enqueueEffects(managers, initPair.b, subscriptions(model));

	return ports ? { ports: ports } : {};
}



// TRACK PRELOADS
//
// This is used by code in elm/browser and elm/http
// to register any HTTP requests that are triggered by init.
//


var _Platform_preload;


function _Platform_registerPreload(url)
{
	_Platform_preload.add(url);
}



// EFFECT MANAGERS


var _Platform_effectManagers = {};


function _Platform_setupEffects(managers, sendToApp)
{
	var ports;

	// setup all necessary effect managers
	for (var key in _Platform_effectManagers)
	{
		var manager = _Platform_effectManagers[key];

		if (manager.a)
		{
			ports = ports || {};
			ports[key] = manager.a(key, sendToApp);
		}

		managers[key] = _Platform_instantiateManager(manager, sendToApp);
	}

	return ports;
}


function _Platform_createManager(init, onEffects, onSelfMsg, cmdMap, subMap)
{
	return {
		b: init,
		c: onEffects,
		d: onSelfMsg,
		e: cmdMap,
		f: subMap
	};
}


function _Platform_instantiateManager(info, sendToApp)
{
	var router = {
		g: sendToApp,
		h: undefined
	};

	var onEffects = info.c;
	var onSelfMsg = info.d;
	var cmdMap = info.e;
	var subMap = info.f;

	function loop(state)
	{
		return A2(_Scheduler_andThen, loop, _Scheduler_receive(function(msg)
		{
			var value = msg.a;

			if (msg.$ === 0)
			{
				return A3(onSelfMsg, router, value, state);
			}

			return cmdMap && subMap
				? A4(onEffects, router, value.i, value.j, state)
				: A3(onEffects, router, cmdMap ? value.i : value.j, state);
		}));
	}

	return router.h = _Scheduler_rawSpawn(A2(_Scheduler_andThen, loop, info.b));
}



// ROUTING


var _Platform_sendToApp = F2(function(router, msg)
{
	return _Scheduler_binding(function(callback)
	{
		router.g(msg);
		callback(_Scheduler_succeed(_Utils_Tuple0));
	});
});


var _Platform_sendToSelf = F2(function(router, msg)
{
	return A2(_Scheduler_send, router.h, {
		$: 0,
		a: msg
	});
});



// BAGS


function _Platform_leaf(home)
{
	return function(value)
	{
		return {
			$: 1,
			k: home,
			l: value
		};
	};
}


function _Platform_batch(list)
{
	return {
		$: 2,
		m: list
	};
}


var _Platform_map = F2(function(tagger, bag)
{
	return {
		$: 3,
		n: tagger,
		o: bag
	}
});



// PIPE BAGS INTO EFFECT MANAGERS
//
// Effects must be queued!
//
// Say your init contains a synchronous command, like Time.now or Time.here
//
//   - This will produce a batch of effects (FX_1)
//   - The synchronous task triggers the subsequent `update` call
//   - This will produce a batch of effects (FX_2)
//
// If we just start dispatching FX_2, subscriptions from FX_2 can be processed
// before subscriptions from FX_1. No good! Earlier versions of this code had
// this problem, leading to these reports:
//
//   https://github.com/elm/core/issues/980
//   https://github.com/elm/core/pull/981
//   https://github.com/elm/compiler/issues/1776
//
// The queue is necessary to avoid ordering issues for synchronous commands.


// Why use true/false here? Why not just check the length of the queue?
// The goal is to detect "are we currently dispatching effects?" If we
// are, we need to bail and let the ongoing while loop handle things.
//
// Now say the queue has 1 element. When we dequeue the final element,
// the queue will be empty, but we are still actively dispatching effects.
// So you could get queue jumping in a really tricky category of cases.
//
var _Platform_effectsQueue = [];
var _Platform_effectsActive = false;


function _Platform_enqueueEffects(managers, cmdBag, subBag)
{
	_Platform_effectsQueue.push({ p: managers, q: cmdBag, r: subBag });

	if (_Platform_effectsActive) return;

	_Platform_effectsActive = true;
	for (var fx; fx = _Platform_effectsQueue.shift(); )
	{
		_Platform_dispatchEffects(fx.p, fx.q, fx.r);
	}
	_Platform_effectsActive = false;
}


function _Platform_dispatchEffects(managers, cmdBag, subBag)
{
	var effectsDict = {};
	_Platform_gatherEffects(true, cmdBag, effectsDict, null);
	_Platform_gatherEffects(false, subBag, effectsDict, null);

	for (var home in managers)
	{
		_Scheduler_rawSend(managers[home], {
			$: 'fx',
			a: effectsDict[home] || { i: _List_Nil, j: _List_Nil }
		});
	}
}


function _Platform_gatherEffects(isCmd, bag, effectsDict, taggers)
{
	switch (bag.$)
	{
		case 1:
			var home = bag.k;
			var effect = _Platform_toEffect(isCmd, home, taggers, bag.l);
			effectsDict[home] = _Platform_insert(isCmd, effect, effectsDict[home]);
			return;

		case 2:
			for (var list = bag.m; list.b; list = list.b) // WHILE_CONS
			{
				_Platform_gatherEffects(isCmd, list.a, effectsDict, taggers);
			}
			return;

		case 3:
			_Platform_gatherEffects(isCmd, bag.o, effectsDict, {
				s: bag.n,
				t: taggers
			});
			return;
	}
}


function _Platform_toEffect(isCmd, home, taggers, value)
{
	function applyTaggers(x)
	{
		for (var temp = taggers; temp; temp = temp.t)
		{
			x = temp.s(x);
		}
		return x;
	}

	var map = isCmd
		? _Platform_effectManagers[home].e
		: _Platform_effectManagers[home].f;

	return A2(map, applyTaggers, value)
}


function _Platform_insert(isCmd, newEffect, effects)
{
	effects = effects || { i: _List_Nil, j: _List_Nil };

	isCmd
		? (effects.i = _List_Cons(newEffect, effects.i))
		: (effects.j = _List_Cons(newEffect, effects.j));

	return effects;
}



// PORTS


function _Platform_checkPortName(name)
{
	if (_Platform_effectManagers[name])
	{
		_Debug_crash(3, name)
	}
}



// OUTGOING PORTS


function _Platform_outgoingPort(name, converter)
{
	_Platform_checkPortName(name);
	_Platform_effectManagers[name] = {
		e: _Platform_outgoingPortMap,
		u: converter,
		a: _Platform_setupOutgoingPort
	};
	return _Platform_leaf(name);
}


var _Platform_outgoingPortMap = F2(function(tagger, value) { return value; });


function _Platform_setupOutgoingPort(name)
{
	var subs = [];
	var converter = _Platform_effectManagers[name].u;

	// CREATE MANAGER

	var init = _Process_sleep(0);

	_Platform_effectManagers[name].b = init;
	_Platform_effectManagers[name].c = F3(function(router, cmdList, state)
	{
		for ( ; cmdList.b; cmdList = cmdList.b) // WHILE_CONS
		{
			// grab a separate reference to subs in case unsubscribe is called
			var currentSubs = subs;
			var value = _Json_unwrap(converter(cmdList.a));
			for (var i = 0; i < currentSubs.length; i++)
			{
				currentSubs[i](value);
			}
		}
		return init;
	});

	// PUBLIC API

	function subscribe(callback)
	{
		subs.push(callback);
	}

	function unsubscribe(callback)
	{
		// copy subs into a new array in case unsubscribe is called within a
		// subscribed callback
		subs = subs.slice();
		var index = subs.indexOf(callback);
		if (index >= 0)
		{
			subs.splice(index, 1);
		}
	}

	return {
		subscribe: subscribe,
		unsubscribe: unsubscribe
	};
}



// INCOMING PORTS


function _Platform_incomingPort(name, converter)
{
	_Platform_checkPortName(name);
	_Platform_effectManagers[name] = {
		f: _Platform_incomingPortMap,
		u: converter,
		a: _Platform_setupIncomingPort
	};
	return _Platform_leaf(name);
}


var _Platform_incomingPortMap = F2(function(tagger, finalTagger)
{
	return function(value)
	{
		return tagger(finalTagger(value));
	};
});


function _Platform_setupIncomingPort(name, sendToApp)
{
	var subs = _List_Nil;
	var converter = _Platform_effectManagers[name].u;

	// CREATE MANAGER

	var init = _Scheduler_succeed(null);

	_Platform_effectManagers[name].b = init;
	_Platform_effectManagers[name].c = F3(function(router, subList, state)
	{
		subs = subList;
		return init;
	});

	// PUBLIC API

	function send(incomingValue)
	{
		var result = A2(_Json_run, converter, _Json_wrap(incomingValue));

		$elm$core$Result$isOk(result) || _Debug_crash(4, name, result.a);

		var value = result.a;
		for (var temp = subs; temp.b; temp = temp.b) // WHILE_CONS
		{
			sendToApp(temp.a(value));
		}
	}

	return { send: send };
}



// EXPORT ELM MODULES
//
// Have DEBUG and PROD versions so that we can (1) give nicer errors in
// debug mode and (2) not pay for the bits needed for that in prod mode.
//


function _Platform_export(exports)
{
	scope['Elm']
		? _Platform_mergeExportsProd(scope['Elm'], exports)
		: scope['Elm'] = exports;
}


function _Platform_mergeExportsProd(obj, exports)
{
	for (var name in exports)
	{
		(name in obj)
			? (name == 'init')
				? _Debug_crash(6)
				: _Platform_mergeExportsProd(obj[name], exports[name])
			: (obj[name] = exports[name]);
	}
}


function _Platform_export_UNUSED(exports)
{
	scope['Elm']
		? _Platform_mergeExportsDebug('Elm', scope['Elm'], exports)
		: scope['Elm'] = exports;
}


function _Platform_mergeExportsDebug(moduleName, obj, exports)
{
	for (var name in exports)
	{
		(name in obj)
			? (name == 'init')
				? _Debug_crash(6, moduleName)
				: _Platform_mergeExportsDebug(moduleName + '.' + name, obj[name], exports[name])
			: (obj[name] = exports[name]);
	}
}




// HELPERS


var _VirtualDom_divertHrefToApp;

var _VirtualDom_doc = typeof document !== 'undefined' ? document : {};


function _VirtualDom_appendChild(parent, child)
{
	parent.appendChild(child);
}

var _VirtualDom_init = F4(function(virtualNode, flagDecoder, debugMetadata, args)
{
	// NOTE: this function needs _Platform_export available to work

	/**/
	var node = args['node'];
	//*/
	/**_UNUSED/
	var node = args && args['node'] ? args['node'] : _Debug_crash(0);
	//*/

	node.parentNode.replaceChild(
		_VirtualDom_render(virtualNode, function() {}),
		node
	);

	return {};
});



// TEXT


function _VirtualDom_text(string)
{
	return {
		$: 0,
		a: string
	};
}



// NODE


var _VirtualDom_nodeNS = F2(function(namespace, tag)
{
	return F2(function(factList, kidList)
	{
		for (var kids = [], descendantsCount = 0; kidList.b; kidList = kidList.b) // WHILE_CONS
		{
			var kid = kidList.a;
			descendantsCount += (kid.b || 0);
			kids.push(kid);
		}
		descendantsCount += kids.length;

		return {
			$: 1,
			c: tag,
			d: _VirtualDom_organizeFacts(factList),
			e: kids,
			f: namespace,
			b: descendantsCount
		};
	});
});


var _VirtualDom_node = _VirtualDom_nodeNS(undefined);



// KEYED NODE


var _VirtualDom_keyedNodeNS = F2(function(namespace, tag)
{
	return F2(function(factList, kidList)
	{
		for (var kids = [], descendantsCount = 0; kidList.b; kidList = kidList.b) // WHILE_CONS
		{
			var kid = kidList.a;
			descendantsCount += (kid.b.b || 0);
			kids.push(kid);
		}
		descendantsCount += kids.length;

		return {
			$: 2,
			c: tag,
			d: _VirtualDom_organizeFacts(factList),
			e: kids,
			f: namespace,
			b: descendantsCount
		};
	});
});


var _VirtualDom_keyedNode = _VirtualDom_keyedNodeNS(undefined);



// CUSTOM


function _VirtualDom_custom(factList, model, render, diff)
{
	return {
		$: 3,
		d: _VirtualDom_organizeFacts(factList),
		g: model,
		h: render,
		i: diff
	};
}



// MAP


var _VirtualDom_map = F2(function(tagger, node)
{
	return {
		$: 4,
		j: tagger,
		k: node,
		b: 1 + (node.b || 0)
	};
});



// LAZY


function _VirtualDom_thunk(refs, thunk)
{
	return {
		$: 5,
		l: refs,
		m: thunk,
		k: undefined
	};
}

var _VirtualDom_lazy = F2(function(func, a)
{
	return _VirtualDom_thunk([func, a], function() {
		return func(a);
	});
});

var _VirtualDom_lazy2 = F3(function(func, a, b)
{
	return _VirtualDom_thunk([func, a, b], function() {
		return A2(func, a, b);
	});
});

var _VirtualDom_lazy3 = F4(function(func, a, b, c)
{
	return _VirtualDom_thunk([func, a, b, c], function() {
		return A3(func, a, b, c);
	});
});

var _VirtualDom_lazy4 = F5(function(func, a, b, c, d)
{
	return _VirtualDom_thunk([func, a, b, c, d], function() {
		return A4(func, a, b, c, d);
	});
});

var _VirtualDom_lazy5 = F6(function(func, a, b, c, d, e)
{
	return _VirtualDom_thunk([func, a, b, c, d, e], function() {
		return A5(func, a, b, c, d, e);
	});
});

var _VirtualDom_lazy6 = F7(function(func, a, b, c, d, e, f)
{
	return _VirtualDom_thunk([func, a, b, c, d, e, f], function() {
		return A6(func, a, b, c, d, e, f);
	});
});

var _VirtualDom_lazy7 = F8(function(func, a, b, c, d, e, f, g)
{
	return _VirtualDom_thunk([func, a, b, c, d, e, f, g], function() {
		return A7(func, a, b, c, d, e, f, g);
	});
});

var _VirtualDom_lazy8 = F9(function(func, a, b, c, d, e, f, g, h)
{
	return _VirtualDom_thunk([func, a, b, c, d, e, f, g, h], function() {
		return A8(func, a, b, c, d, e, f, g, h);
	});
});



// FACTS


var _VirtualDom_on = F2(function(key, handler)
{
	return {
		$: 'a0',
		n: key,
		o: handler
	};
});
var _VirtualDom_style = F2(function(key, value)
{
	return {
		$: 'a1',
		n: key,
		o: value
	};
});
var _VirtualDom_property = F2(function(key, value)
{
	return {
		$: 'a2',
		n: key,
		o: value
	};
});
var _VirtualDom_attribute = F2(function(key, value)
{
	return {
		$: 'a3',
		n: key,
		o: value
	};
});
var _VirtualDom_attributeNS = F3(function(namespace, key, value)
{
	return {
		$: 'a4',
		n: key,
		o: { f: namespace, o: value }
	};
});



// XSS ATTACK VECTOR CHECKS


function _VirtualDom_noScript(tag)
{
	return tag == 'script' ? 'p' : tag;
}

function _VirtualDom_noOnOrFormAction(key)
{
	return /^(on|formAction$)/i.test(key) ? 'data-' + key : key;
}

function _VirtualDom_noInnerHtmlOrFormAction(key)
{
	return key == 'innerHTML' || key == 'formAction' ? 'data-' + key : key;
}

function _VirtualDom_noJavaScriptUri(value)
{
	return /^javascript:/i.test(value.replace(/\s/g,'')) ? '' : value;
}

function _VirtualDom_noJavaScriptUri_UNUSED(value)
{
	return /^javascript:/i.test(value.replace(/\s/g,''))
		? 'javascript:alert("This is an XSS vector. Please use ports or web components instead.")'
		: value;
}

function _VirtualDom_noJavaScriptOrHtmlUri(value)
{
	return /^\s*(javascript:|data:text\/html)/i.test(value) ? '' : value;
}

function _VirtualDom_noJavaScriptOrHtmlUri_UNUSED(value)
{
	return /^\s*(javascript:|data:text\/html)/i.test(value)
		? 'javascript:alert("This is an XSS vector. Please use ports or web components instead.")'
		: value;
}



// MAP FACTS


var _VirtualDom_mapAttribute = F2(function(func, attr)
{
	return (attr.$ === 'a0')
		? A2(_VirtualDom_on, attr.n, _VirtualDom_mapHandler(func, attr.o))
		: attr;
});

function _VirtualDom_mapHandler(func, handler)
{
	var tag = $elm$virtual_dom$VirtualDom$toHandlerInt(handler);

	// 0 = Normal
	// 1 = MayStopPropagation
	// 2 = MayPreventDefault
	// 3 = Custom

	return {
		$: handler.$,
		a:
			!tag
				? A2($elm$json$Json$Decode$map, func, handler.a)
				:
			A3($elm$json$Json$Decode$map2,
				tag < 3
					? _VirtualDom_mapEventTuple
					: _VirtualDom_mapEventRecord,
				$elm$json$Json$Decode$succeed(func),
				handler.a
			)
	};
}

var _VirtualDom_mapEventTuple = F2(function(func, tuple)
{
	return _Utils_Tuple2(func(tuple.a), tuple.b);
});

var _VirtualDom_mapEventRecord = F2(function(func, record)
{
	return {
		dU: func(record.dU),
		ew: record.ew,
		d6: record.d6
	}
});



// ORGANIZE FACTS


function _VirtualDom_organizeFacts(factList)
{
	for (var facts = {}; factList.b; factList = factList.b) // WHILE_CONS
	{
		var entry = factList.a;

		var tag = entry.$;
		var key = entry.n;
		var value = entry.o;

		if (tag === 'a2')
		{
			(key === 'className')
				? _VirtualDom_addClass(facts, key, _Json_unwrap(value))
				: facts[key] = _Json_unwrap(value);

			continue;
		}

		var subFacts = facts[tag] || (facts[tag] = {});
		(tag === 'a3' && key === 'class')
			? _VirtualDom_addClass(subFacts, key, value)
			: subFacts[key] = value;
	}

	return facts;
}

function _VirtualDom_addClass(object, key, newClass)
{
	var classes = object[key];
	object[key] = classes ? classes + ' ' + newClass : newClass;
}



// RENDER


function _VirtualDom_render(vNode, eventNode)
{
	var tag = vNode.$;

	if (tag === 5)
	{
		return _VirtualDom_render(vNode.k || (vNode.k = vNode.m()), eventNode);
	}

	if (tag === 0)
	{
		return _VirtualDom_doc.createTextNode(vNode.a);
	}

	if (tag === 4)
	{
		var subNode = vNode.k;
		var tagger = vNode.j;

		while (subNode.$ === 4)
		{
			typeof tagger !== 'object'
				? tagger = [tagger, subNode.j]
				: tagger.push(subNode.j);

			subNode = subNode.k;
		}

		var subEventRoot = { j: tagger, p: eventNode };
		var domNode = _VirtualDom_render(subNode, subEventRoot);
		domNode.elm_event_node_ref = subEventRoot;
		return domNode;
	}

	if (tag === 3)
	{
		var domNode = vNode.h(vNode.g);
		_VirtualDom_applyFacts(domNode, eventNode, vNode.d);
		return domNode;
	}

	// at this point `tag` must be 1 or 2

	var domNode = vNode.f
		? _VirtualDom_doc.createElementNS(vNode.f, vNode.c)
		: _VirtualDom_doc.createElement(vNode.c);

	if (_VirtualDom_divertHrefToApp && vNode.c == 'a')
	{
		domNode.addEventListener('click', _VirtualDom_divertHrefToApp(domNode));
	}

	_VirtualDom_applyFacts(domNode, eventNode, vNode.d);

	for (var kids = vNode.e, i = 0; i < kids.length; i++)
	{
		_VirtualDom_appendChild(domNode, _VirtualDom_render(tag === 1 ? kids[i] : kids[i].b, eventNode));
	}

	return domNode;
}



// APPLY FACTS


function _VirtualDom_applyFacts(domNode, eventNode, facts)
{
	for (var key in facts)
	{
		var value = facts[key];

		key === 'a1'
			? _VirtualDom_applyStyles(domNode, value)
			:
		key === 'a0'
			? _VirtualDom_applyEvents(domNode, eventNode, value)
			:
		key === 'a3'
			? _VirtualDom_applyAttrs(domNode, value)
			:
		key === 'a4'
			? _VirtualDom_applyAttrsNS(domNode, value)
			:
		((key !== 'value' && key !== 'checked') || domNode[key] !== value) && (domNode[key] = value);
	}
}



// APPLY STYLES


function _VirtualDom_applyStyles(domNode, styles)
{
	var domNodeStyle = domNode.style;

	for (var key in styles)
	{
		domNodeStyle[key] = styles[key];
	}
}



// APPLY ATTRS


function _VirtualDom_applyAttrs(domNode, attrs)
{
	for (var key in attrs)
	{
		var value = attrs[key];
		typeof value !== 'undefined'
			? domNode.setAttribute(key, value)
			: domNode.removeAttribute(key);
	}
}



// APPLY NAMESPACED ATTRS


function _VirtualDom_applyAttrsNS(domNode, nsAttrs)
{
	for (var key in nsAttrs)
	{
		var pair = nsAttrs[key];
		var namespace = pair.f;
		var value = pair.o;

		typeof value !== 'undefined'
			? domNode.setAttributeNS(namespace, key, value)
			: domNode.removeAttributeNS(namespace, key);
	}
}



// APPLY EVENTS


function _VirtualDom_applyEvents(domNode, eventNode, events)
{
	var allCallbacks = domNode.elmFs || (domNode.elmFs = {});

	for (var key in events)
	{
		var newHandler = events[key];
		var oldCallback = allCallbacks[key];

		if (!newHandler)
		{
			domNode.removeEventListener(key, oldCallback);
			allCallbacks[key] = undefined;
			continue;
		}

		if (oldCallback)
		{
			var oldHandler = oldCallback.q;
			if (oldHandler.$ === newHandler.$)
			{
				oldCallback.q = newHandler;
				continue;
			}
			domNode.removeEventListener(key, oldCallback);
		}

		oldCallback = _VirtualDom_makeCallback(eventNode, newHandler);
		domNode.addEventListener(key, oldCallback,
			_VirtualDom_passiveSupported
			&& { passive: $elm$virtual_dom$VirtualDom$toHandlerInt(newHandler) < 2 }
		);
		allCallbacks[key] = oldCallback;
	}
}



// PASSIVE EVENTS


var _VirtualDom_passiveSupported;

try
{
	window.addEventListener('t', null, Object.defineProperty({}, 'passive', {
		get: function() { _VirtualDom_passiveSupported = true; }
	}));
}
catch(e) {}



// EVENT HANDLERS


function _VirtualDom_makeCallback(eventNode, initialHandler)
{
	function callback(event)
	{
		var handler = callback.q;
		var result = _Json_runHelp(handler.a, event);

		if (!$elm$core$Result$isOk(result))
		{
			return;
		}

		var tag = $elm$virtual_dom$VirtualDom$toHandlerInt(handler);

		// 0 = Normal
		// 1 = MayStopPropagation
		// 2 = MayPreventDefault
		// 3 = Custom

		var value = result.a;
		var message = !tag ? value : tag < 3 ? value.a : value.dU;
		var stopPropagation = tag == 1 ? value.b : tag == 3 && value.ew;
		var currentEventNode = (
			stopPropagation && event.stopPropagation(),
			(tag == 2 ? value.b : tag == 3 && value.d6) && event.preventDefault(),
			eventNode
		);
		var tagger;
		var i;
		while (tagger = currentEventNode.j)
		{
			if (typeof tagger == 'function')
			{
				message = tagger(message);
			}
			else
			{
				for (var i = tagger.length; i--; )
				{
					message = tagger[i](message);
				}
			}
			currentEventNode = currentEventNode.p;
		}
		currentEventNode(message, stopPropagation); // stopPropagation implies isSync
	}

	callback.q = initialHandler;

	return callback;
}

function _VirtualDom_equalEvents(x, y)
{
	return x.$ == y.$ && _Json_equality(x.a, y.a);
}



// DIFF


// TODO: Should we do patches like in iOS?
//
// type Patch
//   = At Int Patch
//   | Batch (List Patch)
//   | Change ...
//
// How could it not be better?
//
function _VirtualDom_diff(x, y)
{
	var patches = [];
	_VirtualDom_diffHelp(x, y, patches, 0);
	return patches;
}


function _VirtualDom_pushPatch(patches, type, index, data)
{
	var patch = {
		$: type,
		r: index,
		s: data,
		t: undefined,
		u: undefined
	};
	patches.push(patch);
	return patch;
}


function _VirtualDom_diffHelp(x, y, patches, index)
{
	if (x === y)
	{
		return;
	}

	var xType = x.$;
	var yType = y.$;

	// Bail if you run into different types of nodes. Implies that the
	// structure has changed significantly and it's not worth a diff.
	if (xType !== yType)
	{
		if (xType === 1 && yType === 2)
		{
			y = _VirtualDom_dekey(y);
			yType = 1;
		}
		else
		{
			_VirtualDom_pushPatch(patches, 0, index, y);
			return;
		}
	}

	// Now we know that both nodes are the same $.
	switch (yType)
	{
		case 5:
			var xRefs = x.l;
			var yRefs = y.l;
			var i = xRefs.length;
			var same = i === yRefs.length;
			while (same && i--)
			{
				same = xRefs[i] === yRefs[i];
			}
			if (same)
			{
				y.k = x.k;
				return;
			}
			y.k = y.m();
			var subPatches = [];
			_VirtualDom_diffHelp(x.k, y.k, subPatches, 0);
			subPatches.length > 0 && _VirtualDom_pushPatch(patches, 1, index, subPatches);
			return;

		case 4:
			// gather nested taggers
			var xTaggers = x.j;
			var yTaggers = y.j;
			var nesting = false;

			var xSubNode = x.k;
			while (xSubNode.$ === 4)
			{
				nesting = true;

				typeof xTaggers !== 'object'
					? xTaggers = [xTaggers, xSubNode.j]
					: xTaggers.push(xSubNode.j);

				xSubNode = xSubNode.k;
			}

			var ySubNode = y.k;
			while (ySubNode.$ === 4)
			{
				nesting = true;

				typeof yTaggers !== 'object'
					? yTaggers = [yTaggers, ySubNode.j]
					: yTaggers.push(ySubNode.j);

				ySubNode = ySubNode.k;
			}

			// Just bail if different numbers of taggers. This implies the
			// structure of the virtual DOM has changed.
			if (nesting && xTaggers.length !== yTaggers.length)
			{
				_VirtualDom_pushPatch(patches, 0, index, y);
				return;
			}

			// check if taggers are "the same"
			if (nesting ? !_VirtualDom_pairwiseRefEqual(xTaggers, yTaggers) : xTaggers !== yTaggers)
			{
				_VirtualDom_pushPatch(patches, 2, index, yTaggers);
			}

			// diff everything below the taggers
			_VirtualDom_diffHelp(xSubNode, ySubNode, patches, index + 1);
			return;

		case 0:
			if (x.a !== y.a)
			{
				_VirtualDom_pushPatch(patches, 3, index, y.a);
			}
			return;

		case 1:
			_VirtualDom_diffNodes(x, y, patches, index, _VirtualDom_diffKids);
			return;

		case 2:
			_VirtualDom_diffNodes(x, y, patches, index, _VirtualDom_diffKeyedKids);
			return;

		case 3:
			if (x.h !== y.h)
			{
				_VirtualDom_pushPatch(patches, 0, index, y);
				return;
			}

			var factsDiff = _VirtualDom_diffFacts(x.d, y.d);
			factsDiff && _VirtualDom_pushPatch(patches, 4, index, factsDiff);

			var patch = y.i(x.g, y.g);
			patch && _VirtualDom_pushPatch(patches, 5, index, patch);

			return;
	}
}

// assumes the incoming arrays are the same length
function _VirtualDom_pairwiseRefEqual(as, bs)
{
	for (var i = 0; i < as.length; i++)
	{
		if (as[i] !== bs[i])
		{
			return false;
		}
	}

	return true;
}

function _VirtualDom_diffNodes(x, y, patches, index, diffKids)
{
	// Bail if obvious indicators have changed. Implies more serious
	// structural changes such that it's not worth it to diff.
	if (x.c !== y.c || x.f !== y.f)
	{
		_VirtualDom_pushPatch(patches, 0, index, y);
		return;
	}

	var factsDiff = _VirtualDom_diffFacts(x.d, y.d);
	factsDiff && _VirtualDom_pushPatch(patches, 4, index, factsDiff);

	diffKids(x, y, patches, index);
}



// DIFF FACTS


// TODO Instead of creating a new diff object, it's possible to just test if
// there *is* a diff. During the actual patch, do the diff again and make the
// modifications directly. This way, there's no new allocations. Worth it?
function _VirtualDom_diffFacts(x, y, category)
{
	var diff;

	// look for changes and removals
	for (var xKey in x)
	{
		if (xKey === 'a1' || xKey === 'a0' || xKey === 'a3' || xKey === 'a4')
		{
			var subDiff = _VirtualDom_diffFacts(x[xKey], y[xKey] || {}, xKey);
			if (subDiff)
			{
				diff = diff || {};
				diff[xKey] = subDiff;
			}
			continue;
		}

		// remove if not in the new facts
		if (!(xKey in y))
		{
			diff = diff || {};
			diff[xKey] =
				!category
					? (typeof x[xKey] === 'string' ? '' : null)
					:
				(category === 'a1')
					? ''
					:
				(category === 'a0' || category === 'a3')
					? undefined
					:
				{ f: x[xKey].f, o: undefined };

			continue;
		}

		var xValue = x[xKey];
		var yValue = y[xKey];

		// reference equal, so don't worry about it
		if (xValue === yValue && xKey !== 'value' && xKey !== 'checked'
			|| category === 'a0' && _VirtualDom_equalEvents(xValue, yValue))
		{
			continue;
		}

		diff = diff || {};
		diff[xKey] = yValue;
	}

	// add new stuff
	for (var yKey in y)
	{
		if (!(yKey in x))
		{
			diff = diff || {};
			diff[yKey] = y[yKey];
		}
	}

	return diff;
}



// DIFF KIDS


function _VirtualDom_diffKids(xParent, yParent, patches, index)
{
	var xKids = xParent.e;
	var yKids = yParent.e;

	var xLen = xKids.length;
	var yLen = yKids.length;

	// FIGURE OUT IF THERE ARE INSERTS OR REMOVALS

	if (xLen > yLen)
	{
		_VirtualDom_pushPatch(patches, 6, index, {
			v: yLen,
			i: xLen - yLen
		});
	}
	else if (xLen < yLen)
	{
		_VirtualDom_pushPatch(patches, 7, index, {
			v: xLen,
			e: yKids
		});
	}

	// PAIRWISE DIFF EVERYTHING ELSE

	for (var minLen = xLen < yLen ? xLen : yLen, i = 0; i < minLen; i++)
	{
		var xKid = xKids[i];
		_VirtualDom_diffHelp(xKid, yKids[i], patches, ++index);
		index += xKid.b || 0;
	}
}



// KEYED DIFF


function _VirtualDom_diffKeyedKids(xParent, yParent, patches, rootIndex)
{
	var localPatches = [];

	var changes = {}; // Dict String Entry
	var inserts = []; // Array { index : Int, entry : Entry }
	// type Entry = { tag : String, vnode : VNode, index : Int, data : _ }

	var xKids = xParent.e;
	var yKids = yParent.e;
	var xLen = xKids.length;
	var yLen = yKids.length;
	var xIndex = 0;
	var yIndex = 0;

	var index = rootIndex;

	while (xIndex < xLen && yIndex < yLen)
	{
		var x = xKids[xIndex];
		var y = yKids[yIndex];

		var xKey = x.a;
		var yKey = y.a;
		var xNode = x.b;
		var yNode = y.b;

		var newMatch = undefined;
		var oldMatch = undefined;

		// check if keys match

		if (xKey === yKey)
		{
			index++;
			_VirtualDom_diffHelp(xNode, yNode, localPatches, index);
			index += xNode.b || 0;

			xIndex++;
			yIndex++;
			continue;
		}

		// look ahead 1 to detect insertions and removals.

		var xNext = xKids[xIndex + 1];
		var yNext = yKids[yIndex + 1];

		if (xNext)
		{
			var xNextKey = xNext.a;
			var xNextNode = xNext.b;
			oldMatch = yKey === xNextKey;
		}

		if (yNext)
		{
			var yNextKey = yNext.a;
			var yNextNode = yNext.b;
			newMatch = xKey === yNextKey;
		}


		// swap x and y
		if (newMatch && oldMatch)
		{
			index++;
			_VirtualDom_diffHelp(xNode, yNextNode, localPatches, index);
			_VirtualDom_insertNode(changes, localPatches, xKey, yNode, yIndex, inserts);
			index += xNode.b || 0;

			index++;
			_VirtualDom_removeNode(changes, localPatches, xKey, xNextNode, index);
			index += xNextNode.b || 0;

			xIndex += 2;
			yIndex += 2;
			continue;
		}

		// insert y
		if (newMatch)
		{
			index++;
			_VirtualDom_insertNode(changes, localPatches, yKey, yNode, yIndex, inserts);
			_VirtualDom_diffHelp(xNode, yNextNode, localPatches, index);
			index += xNode.b || 0;

			xIndex += 1;
			yIndex += 2;
			continue;
		}

		// remove x
		if (oldMatch)
		{
			index++;
			_VirtualDom_removeNode(changes, localPatches, xKey, xNode, index);
			index += xNode.b || 0;

			index++;
			_VirtualDom_diffHelp(xNextNode, yNode, localPatches, index);
			index += xNextNode.b || 0;

			xIndex += 2;
			yIndex += 1;
			continue;
		}

		// remove x, insert y
		if (xNext && xNextKey === yNextKey)
		{
			index++;
			_VirtualDom_removeNode(changes, localPatches, xKey, xNode, index);
			_VirtualDom_insertNode(changes, localPatches, yKey, yNode, yIndex, inserts);
			index += xNode.b || 0;

			index++;
			_VirtualDom_diffHelp(xNextNode, yNextNode, localPatches, index);
			index += xNextNode.b || 0;

			xIndex += 2;
			yIndex += 2;
			continue;
		}

		break;
	}

	// eat up any remaining nodes with removeNode and insertNode

	while (xIndex < xLen)
	{
		index++;
		var x = xKids[xIndex];
		var xNode = x.b;
		_VirtualDom_removeNode(changes, localPatches, x.a, xNode, index);
		index += xNode.b || 0;
		xIndex++;
	}

	while (yIndex < yLen)
	{
		var endInserts = endInserts || [];
		var y = yKids[yIndex];
		_VirtualDom_insertNode(changes, localPatches, y.a, y.b, undefined, endInserts);
		yIndex++;
	}

	if (localPatches.length > 0 || inserts.length > 0 || endInserts)
	{
		_VirtualDom_pushPatch(patches, 8, rootIndex, {
			w: localPatches,
			x: inserts,
			y: endInserts
		});
	}
}



// CHANGES FROM KEYED DIFF


var _VirtualDom_POSTFIX = '_elmW6BL';


function _VirtualDom_insertNode(changes, localPatches, key, vnode, yIndex, inserts)
{
	var entry = changes[key];

	// never seen this key before
	if (!entry)
	{
		entry = {
			c: 0,
			z: vnode,
			r: yIndex,
			s: undefined
		};

		inserts.push({ r: yIndex, A: entry });
		changes[key] = entry;

		return;
	}

	// this key was removed earlier, a match!
	if (entry.c === 1)
	{
		inserts.push({ r: yIndex, A: entry });

		entry.c = 2;
		var subPatches = [];
		_VirtualDom_diffHelp(entry.z, vnode, subPatches, entry.r);
		entry.r = yIndex;
		entry.s.s = {
			w: subPatches,
			A: entry
		};

		return;
	}

	// this key has already been inserted or moved, a duplicate!
	_VirtualDom_insertNode(changes, localPatches, key + _VirtualDom_POSTFIX, vnode, yIndex, inserts);
}


function _VirtualDom_removeNode(changes, localPatches, key, vnode, index)
{
	var entry = changes[key];

	// never seen this key before
	if (!entry)
	{
		var patch = _VirtualDom_pushPatch(localPatches, 9, index, undefined);

		changes[key] = {
			c: 1,
			z: vnode,
			r: index,
			s: patch
		};

		return;
	}

	// this key was inserted earlier, a match!
	if (entry.c === 0)
	{
		entry.c = 2;
		var subPatches = [];
		_VirtualDom_diffHelp(vnode, entry.z, subPatches, index);

		_VirtualDom_pushPatch(localPatches, 9, index, {
			w: subPatches,
			A: entry
		});

		return;
	}

	// this key has already been removed or moved, a duplicate!
	_VirtualDom_removeNode(changes, localPatches, key + _VirtualDom_POSTFIX, vnode, index);
}



// ADD DOM NODES
//
// Each DOM node has an "index" assigned in order of traversal. It is important
// to minimize our crawl over the actual DOM, so these indexes (along with the
// descendantsCount of virtual nodes) let us skip touching entire subtrees of
// the DOM if we know there are no patches there.


function _VirtualDom_addDomNodes(domNode, vNode, patches, eventNode)
{
	_VirtualDom_addDomNodesHelp(domNode, vNode, patches, 0, 0, vNode.b, eventNode);
}


// assumes `patches` is non-empty and indexes increase monotonically.
function _VirtualDom_addDomNodesHelp(domNode, vNode, patches, i, low, high, eventNode)
{
	var patch = patches[i];
	var index = patch.r;

	while (index === low)
	{
		var patchType = patch.$;

		if (patchType === 1)
		{
			_VirtualDom_addDomNodes(domNode, vNode.k, patch.s, eventNode);
		}
		else if (patchType === 8)
		{
			patch.t = domNode;
			patch.u = eventNode;

			var subPatches = patch.s.w;
			if (subPatches.length > 0)
			{
				_VirtualDom_addDomNodesHelp(domNode, vNode, subPatches, 0, low, high, eventNode);
			}
		}
		else if (patchType === 9)
		{
			patch.t = domNode;
			patch.u = eventNode;

			var data = patch.s;
			if (data)
			{
				data.A.s = domNode;
				var subPatches = data.w;
				if (subPatches.length > 0)
				{
					_VirtualDom_addDomNodesHelp(domNode, vNode, subPatches, 0, low, high, eventNode);
				}
			}
		}
		else
		{
			patch.t = domNode;
			patch.u = eventNode;
		}

		i++;

		if (!(patch = patches[i]) || (index = patch.r) > high)
		{
			return i;
		}
	}

	var tag = vNode.$;

	if (tag === 4)
	{
		var subNode = vNode.k;

		while (subNode.$ === 4)
		{
			subNode = subNode.k;
		}

		return _VirtualDom_addDomNodesHelp(domNode, subNode, patches, i, low + 1, high, domNode.elm_event_node_ref);
	}

	// tag must be 1 or 2 at this point

	var vKids = vNode.e;
	var childNodes = domNode.childNodes;
	for (var j = 0; j < vKids.length; j++)
	{
		low++;
		var vKid = tag === 1 ? vKids[j] : vKids[j].b;
		var nextLow = low + (vKid.b || 0);
		if (low <= index && index <= nextLow)
		{
			i = _VirtualDom_addDomNodesHelp(childNodes[j], vKid, patches, i, low, nextLow, eventNode);
			if (!(patch = patches[i]) || (index = patch.r) > high)
			{
				return i;
			}
		}
		low = nextLow;
	}
	return i;
}



// APPLY PATCHES


function _VirtualDom_applyPatches(rootDomNode, oldVirtualNode, patches, eventNode)
{
	if (patches.length === 0)
	{
		return rootDomNode;
	}

	_VirtualDom_addDomNodes(rootDomNode, oldVirtualNode, patches, eventNode);
	return _VirtualDom_applyPatchesHelp(rootDomNode, patches);
}

function _VirtualDom_applyPatchesHelp(rootDomNode, patches)
{
	for (var i = 0; i < patches.length; i++)
	{
		var patch = patches[i];
		var localDomNode = patch.t
		var newNode = _VirtualDom_applyPatch(localDomNode, patch);
		if (localDomNode === rootDomNode)
		{
			rootDomNode = newNode;
		}
	}
	return rootDomNode;
}

function _VirtualDom_applyPatch(domNode, patch)
{
	switch (patch.$)
	{
		case 0:
			return _VirtualDom_applyPatchRedraw(domNode, patch.s, patch.u);

		case 4:
			_VirtualDom_applyFacts(domNode, patch.u, patch.s);
			return domNode;

		case 3:
			domNode.replaceData(0, domNode.length, patch.s);
			return domNode;

		case 1:
			return _VirtualDom_applyPatchesHelp(domNode, patch.s);

		case 2:
			if (domNode.elm_event_node_ref)
			{
				domNode.elm_event_node_ref.j = patch.s;
			}
			else
			{
				domNode.elm_event_node_ref = { j: patch.s, p: patch.u };
			}
			return domNode;

		case 6:
			var data = patch.s;
			for (var i = 0; i < data.i; i++)
			{
				domNode.removeChild(domNode.childNodes[data.v]);
			}
			return domNode;

		case 7:
			var data = patch.s;
			var kids = data.e;
			var i = data.v;
			var theEnd = domNode.childNodes[i];
			for (; i < kids.length; i++)
			{
				domNode.insertBefore(_VirtualDom_render(kids[i], patch.u), theEnd);
			}
			return domNode;

		case 9:
			var data = patch.s;
			if (!data)
			{
				domNode.parentNode.removeChild(domNode);
				return domNode;
			}
			var entry = data.A;
			if (typeof entry.r !== 'undefined')
			{
				domNode.parentNode.removeChild(domNode);
			}
			entry.s = _VirtualDom_applyPatchesHelp(domNode, data.w);
			return domNode;

		case 8:
			return _VirtualDom_applyPatchReorder(domNode, patch);

		case 5:
			return patch.s(domNode);

		default:
			_Debug_crash(10); // 'Ran into an unknown patch!'
	}
}


function _VirtualDom_applyPatchRedraw(domNode, vNode, eventNode)
{
	var parentNode = domNode.parentNode;
	var newNode = _VirtualDom_render(vNode, eventNode);

	if (!newNode.elm_event_node_ref)
	{
		newNode.elm_event_node_ref = domNode.elm_event_node_ref;
	}

	if (parentNode && newNode !== domNode)
	{
		parentNode.replaceChild(newNode, domNode);
	}
	return newNode;
}


function _VirtualDom_applyPatchReorder(domNode, patch)
{
	var data = patch.s;

	// remove end inserts
	var frag = _VirtualDom_applyPatchReorderEndInsertsHelp(data.y, patch);

	// removals
	domNode = _VirtualDom_applyPatchesHelp(domNode, data.w);

	// inserts
	var inserts = data.x;
	for (var i = 0; i < inserts.length; i++)
	{
		var insert = inserts[i];
		var entry = insert.A;
		var node = entry.c === 2
			? entry.s
			: _VirtualDom_render(entry.z, patch.u);
		domNode.insertBefore(node, domNode.childNodes[insert.r]);
	}

	// add end inserts
	if (frag)
	{
		_VirtualDom_appendChild(domNode, frag);
	}

	return domNode;
}


function _VirtualDom_applyPatchReorderEndInsertsHelp(endInserts, patch)
{
	if (!endInserts)
	{
		return;
	}

	var frag = _VirtualDom_doc.createDocumentFragment();
	for (var i = 0; i < endInserts.length; i++)
	{
		var insert = endInserts[i];
		var entry = insert.A;
		_VirtualDom_appendChild(frag, entry.c === 2
			? entry.s
			: _VirtualDom_render(entry.z, patch.u)
		);
	}
	return frag;
}


function _VirtualDom_virtualize(node)
{
	// TEXT NODES

	if (node.nodeType === 3)
	{
		return _VirtualDom_text(node.textContent);
	}


	// WEIRD NODES

	if (node.nodeType !== 1)
	{
		return _VirtualDom_text('');
	}


	// ELEMENT NODES

	var attrList = _List_Nil;
	var attrs = node.attributes;
	for (var i = attrs.length; i--; )
	{
		var attr = attrs[i];
		var name = attr.name;
		var value = attr.value;
		attrList = _List_Cons( A2(_VirtualDom_attribute, name, value), attrList );
	}

	var tag = node.tagName.toLowerCase();
	var kidList = _List_Nil;
	var kids = node.childNodes;

	for (var i = kids.length; i--; )
	{
		kidList = _List_Cons(_VirtualDom_virtualize(kids[i]), kidList);
	}
	return A3(_VirtualDom_node, tag, attrList, kidList);
}

function _VirtualDom_dekey(keyedNode)
{
	var keyedKids = keyedNode.e;
	var len = keyedKids.length;
	var kids = new Array(len);
	for (var i = 0; i < len; i++)
	{
		kids[i] = keyedKids[i].b;
	}

	return {
		$: 1,
		c: keyedNode.c,
		d: keyedNode.d,
		e: kids,
		f: keyedNode.f,
		b: keyedNode.b
	};
}




// ELEMENT


var _Debugger_element;

var _Browser_element = _Debugger_element || F4(function(impl, flagDecoder, debugMetadata, args)
{
	return _Platform_initialize(
		flagDecoder,
		args,
		impl.hv,
		impl.iM,
		impl.iz,
		function(sendToApp, initialModel) {
			var view = impl.iR;
			/**/
			var domNode = args['node'];
			//*/
			/**_UNUSED/
			var domNode = args && args['node'] ? args['node'] : _Debug_crash(0);
			//*/
			var currNode = _VirtualDom_virtualize(domNode);

			return _Browser_makeAnimator(initialModel, function(model)
			{
				var nextNode = view(model);
				var patches = _VirtualDom_diff(currNode, nextNode);
				domNode = _VirtualDom_applyPatches(domNode, currNode, patches, sendToApp);
				currNode = nextNode;
			});
		}
	);
});



// DOCUMENT


var _Debugger_document;

var _Browser_document = _Debugger_document || F4(function(impl, flagDecoder, debugMetadata, args)
{
	return _Platform_initialize(
		flagDecoder,
		args,
		impl.hv,
		impl.iM,
		impl.iz,
		function(sendToApp, initialModel) {
			var divertHrefToApp = impl.ek && impl.ek(sendToApp)
			var view = impl.iR;
			var title = _VirtualDom_doc.title;
			var bodyNode = _VirtualDom_doc.body;
			var currNode = _VirtualDom_virtualize(bodyNode);
			return _Browser_makeAnimator(initialModel, function(model)
			{
				_VirtualDom_divertHrefToApp = divertHrefToApp;
				var doc = view(model);
				var nextNode = _VirtualDom_node('body')(_List_Nil)(doc.g);
				var patches = _VirtualDom_diff(currNode, nextNode);
				bodyNode = _VirtualDom_applyPatches(bodyNode, currNode, patches, sendToApp);
				currNode = nextNode;
				_VirtualDom_divertHrefToApp = 0;
				(title !== doc.eA) && (_VirtualDom_doc.title = title = doc.eA);
			});
		}
	);
});



// ANIMATION


var _Browser_cancelAnimationFrame =
	typeof cancelAnimationFrame !== 'undefined'
		? cancelAnimationFrame
		: function(id) { clearTimeout(id); };

var _Browser_requestAnimationFrame =
	typeof requestAnimationFrame !== 'undefined'
		? requestAnimationFrame
		: function(callback) { return setTimeout(callback, 1000 / 60); };


function _Browser_makeAnimator(model, draw)
{
	draw(model);

	var state = 0;

	function updateIfNeeded()
	{
		state = state === 1
			? 0
			: ( _Browser_requestAnimationFrame(updateIfNeeded), draw(model), 1 );
	}

	return function(nextModel, isSync)
	{
		model = nextModel;

		isSync
			? ( draw(model),
				state === 2 && (state = 1)
				)
			: ( state === 0 && _Browser_requestAnimationFrame(updateIfNeeded),
				state = 2
				);
	};
}



// APPLICATION


function _Browser_application(impl)
{
	var onUrlChange = impl.h_;
	var onUrlRequest = impl.h$;
	var key = function() { key.a(onUrlChange(_Browser_getUrl())); };

	return _Browser_document({
		ek: function(sendToApp)
		{
			key.a = sendToApp;
			_Browser_window.addEventListener('popstate', key);
			_Browser_window.navigator.userAgent.indexOf('Trident') < 0 || _Browser_window.addEventListener('hashchange', key);

			return F2(function(domNode, event)
			{
				if (!event.ctrlKey && !event.metaKey && !event.shiftKey && event.button < 1 && !domNode.target && !domNode.hasAttribute('download'))
				{
					event.preventDefault();
					var href = domNode.href;
					var curr = _Browser_getUrl();
					var next = $elm$url$Url$fromString(href).a;
					sendToApp(onUrlRequest(
						(next
							&& curr.f9 === next.f9
							&& curr.fo === next.fo
							&& curr.f5.a === next.f5.a
						)
							? $elm$browser$Browser$Internal(next)
							: $elm$browser$Browser$External(href)
					));
				}
			});
		},
		hv: function(flags)
		{
			return A3(impl.hv, flags, _Browser_getUrl(), key);
		},
		iR: impl.iR,
		iM: impl.iM,
		iz: impl.iz
	});
}

function _Browser_getUrl()
{
	return $elm$url$Url$fromString(_VirtualDom_doc.location.href).a || _Debug_crash(1);
}

var _Browser_go = F2(function(key, n)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function() {
		n && history.go(n);
		key();
	}));
});

var _Browser_pushUrl = F2(function(key, url)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function() {
		history.pushState({}, '', url);
		key();
	}));
});

var _Browser_replaceUrl = F2(function(key, url)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function() {
		history.replaceState({}, '', url);
		key();
	}));
});



// GLOBAL EVENTS


var _Browser_fakeNode = { addEventListener: function() {}, removeEventListener: function() {} };
var _Browser_doc = typeof document !== 'undefined' ? document : _Browser_fakeNode;
var _Browser_window = typeof window !== 'undefined' ? window : _Browser_fakeNode;

var _Browser_on = F3(function(node, eventName, sendToSelf)
{
	return _Scheduler_spawn(_Scheduler_binding(function(callback)
	{
		function handler(event)	{ _Scheduler_rawSpawn(sendToSelf(event)); }
		node.addEventListener(eventName, handler, _VirtualDom_passiveSupported && { passive: true });
		return function() { node.removeEventListener(eventName, handler); };
	}));
});

var _Browser_decodeEvent = F2(function(decoder, event)
{
	var result = _Json_runHelp(decoder, event);
	return $elm$core$Result$isOk(result) ? $elm$core$Maybe$Just(result.a) : $elm$core$Maybe$Nothing;
});



// PAGE VISIBILITY


function _Browser_visibilityInfo()
{
	return (typeof _VirtualDom_doc.hidden !== 'undefined')
		? { hr: 'hidden', g$: 'visibilitychange' }
		:
	(typeof _VirtualDom_doc.mozHidden !== 'undefined')
		? { hr: 'mozHidden', g$: 'mozvisibilitychange' }
		:
	(typeof _VirtualDom_doc.msHidden !== 'undefined')
		? { hr: 'msHidden', g$: 'msvisibilitychange' }
		:
	(typeof _VirtualDom_doc.webkitHidden !== 'undefined')
		? { hr: 'webkitHidden', g$: 'webkitvisibilitychange' }
		: { hr: 'hidden', g$: 'visibilitychange' };
}



// ANIMATION FRAMES


function _Browser_rAF()
{
	return _Scheduler_binding(function(callback)
	{
		var id = _Browser_requestAnimationFrame(function() {
			callback(_Scheduler_succeed(Date.now()));
		});

		return function() {
			_Browser_cancelAnimationFrame(id);
		};
	});
}


function _Browser_now()
{
	return _Scheduler_binding(function(callback)
	{
		callback(_Scheduler_succeed(Date.now()));
	});
}



// DOM STUFF


function _Browser_withNode(id, doStuff)
{
	return _Scheduler_binding(function(callback)
	{
		_Browser_requestAnimationFrame(function() {
			var node = document.getElementById(id);
			callback(node
				? _Scheduler_succeed(doStuff(node))
				: _Scheduler_fail($elm$browser$Browser$Dom$NotFound(id))
			);
		});
	});
}


function _Browser_withWindow(doStuff)
{
	return _Scheduler_binding(function(callback)
	{
		_Browser_requestAnimationFrame(function() {
			callback(_Scheduler_succeed(doStuff()));
		});
	});
}


// FOCUS and BLUR


var _Browser_call = F2(function(functionName, id)
{
	return _Browser_withNode(id, function(node) {
		node[functionName]();
		return _Utils_Tuple0;
	});
});



// WINDOW VIEWPORT


function _Browser_getViewport()
{
	return {
		gh: _Browser_getScene(),
		gG: {
			gI: _Browser_window.pageXOffset,
			gJ: _Browser_window.pageYOffset,
			gH: _Browser_doc.documentElement.clientWidth,
			fl: _Browser_doc.documentElement.clientHeight
		}
	};
}

function _Browser_getScene()
{
	var body = _Browser_doc.body;
	var elem = _Browser_doc.documentElement;
	return {
		gH: Math.max(body.scrollWidth, body.offsetWidth, elem.scrollWidth, elem.offsetWidth, elem.clientWidth),
		fl: Math.max(body.scrollHeight, body.offsetHeight, elem.scrollHeight, elem.offsetHeight, elem.clientHeight)
	};
}

var _Browser_setViewport = F2(function(x, y)
{
	return _Browser_withWindow(function()
	{
		_Browser_window.scroll(x, y);
		return _Utils_Tuple0;
	});
});



// ELEMENT VIEWPORT


function _Browser_getViewportOf(id)
{
	return _Browser_withNode(id, function(node)
	{
		return {
			gh: {
				gH: node.scrollWidth,
				fl: node.scrollHeight
			},
			gG: {
				gI: node.scrollLeft,
				gJ: node.scrollTop,
				gH: node.clientWidth,
				fl: node.clientHeight
			}
		};
	});
}


var _Browser_setViewportOf = F3(function(id, x, y)
{
	return _Browser_withNode(id, function(node)
	{
		node.scrollLeft = x;
		node.scrollTop = y;
		return _Utils_Tuple0;
	});
});



// ELEMENT


function _Browser_getElement(id)
{
	return _Browser_withNode(id, function(node)
	{
		var rect = node.getBoundingClientRect();
		var x = _Browser_window.pageXOffset;
		var y = _Browser_window.pageYOffset;
		return {
			gh: _Browser_getScene(),
			gG: {
				gI: x,
				gJ: y,
				gH: _Browser_doc.documentElement.clientWidth,
				fl: _Browser_doc.documentElement.clientHeight
			},
			hf: {
				gI: x + rect.left,
				gJ: y + rect.top,
				gH: rect.width,
				fl: rect.height
			}
		};
	});
}



// LOAD and RELOAD


function _Browser_reload(skipCache)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function(callback)
	{
		_VirtualDom_doc.location.reload(skipCache);
	}));
}

function _Browser_load(url)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function(callback)
	{
		try
		{
			_Browser_window.location = url;
		}
		catch(err)
		{
			// Only Firefox can throw a NS_ERROR_MALFORMED_URI exception here.
			// Other browsers reload the page, so let's be consistent about that.
			_VirtualDom_doc.location.reload(false);
		}
	}));
}


function _Url_percentEncode(string)
{
	return encodeURIComponent(string);
}

function _Url_percentDecode(string)
{
	try
	{
		return $elm$core$Maybe$Just(decodeURIComponent(string));
	}
	catch (e)
	{
		return $elm$core$Maybe$Nothing;
	}
}


// SEND REQUEST

var _Http_toTask = F3(function(router, toTask, request)
{
	return _Scheduler_binding(function(callback)
	{
		function done(response) {
			callback(toTask(request.e.a(response)));
		}

		var xhr = new XMLHttpRequest();
		xhr.addEventListener('error', function() { done($elm$http$Http$NetworkError_); });
		xhr.addEventListener('timeout', function() { done($elm$http$Http$Timeout_); });
		xhr.addEventListener('load', function() { done(_Http_toResponse(request.e.b, xhr)); });
		$elm$core$Maybe$isJust(request.A) && _Http_track(router, xhr, request.A.a);

		try {
			xhr.open(request.hL, request.d, true);
		} catch (e) {
			return done($elm$http$Http$BadUrl_(request.d));
		}

		_Http_configureRequest(xhr, request);

		request.g.a && xhr.setRequestHeader('Content-Type', request.g.a);
		xhr.send(request.g.b);

		return function() { xhr.c = true; xhr.abort(); };
	});
});


// CONFIGURE

function _Http_configureRequest(xhr, request)
{
	for (var headers = request.fk; headers.b; headers = headers.b) // WHILE_CONS
	{
		xhr.setRequestHeader(headers.a.a, headers.a.b);
	}
	xhr.timeout = request.iE.a || 0;
	xhr.responseType = request.e.d;
	xhr.withCredentials = request.gU;
}


// RESPONSES

function _Http_toResponse(toBody, xhr)
{
	return A2(
		200 <= xhr.status && xhr.status < 300 ? $elm$http$Http$GoodStatus_ : $elm$http$Http$BadStatus_,
		_Http_toMetadata(xhr),
		toBody(xhr.response)
	);
}


// METADATA

function _Http_toMetadata(xhr)
{
	return {
		d: xhr.responseURL,
		iu: xhr.status,
		iv: xhr.statusText,
		fk: _Http_parseHeaders(xhr.getAllResponseHeaders())
	};
}


// HEADERS

function _Http_parseHeaders(rawHeaders)
{
	if (!rawHeaders)
	{
		return $elm$core$Dict$empty;
	}

	var headers = $elm$core$Dict$empty;
	var headerPairs = rawHeaders.split('\r\n');
	for (var i = headerPairs.length; i--; )
	{
		var headerPair = headerPairs[i];
		var index = headerPair.indexOf(': ');
		if (index > 0)
		{
			var key = headerPair.substring(0, index);
			var value = headerPair.substring(index + 2);

			headers = A3($elm$core$Dict$update, key, function(oldValue) {
				return $elm$core$Maybe$Just($elm$core$Maybe$isJust(oldValue)
					? value + ', ' + oldValue.a
					: value
				);
			}, headers);
		}
	}
	return headers;
}


// EXPECT

var _Http_expect = F3(function(type, toBody, toValue)
{
	return {
		$: 0,
		d: type,
		b: toBody,
		a: toValue
	};
});

var _Http_mapExpect = F2(function(func, expect)
{
	return {
		$: 0,
		d: expect.d,
		b: expect.b,
		a: function(x) { return func(expect.a(x)); }
	};
});

function _Http_toDataView(arrayBuffer)
{
	return new DataView(arrayBuffer);
}


// BODY and PARTS

var _Http_emptyBody = { $: 0 };
var _Http_pair = F2(function(a, b) { return { $: 0, a: a, b: b }; });

function _Http_toFormData(parts)
{
	for (var formData = new FormData(); parts.b; parts = parts.b) // WHILE_CONS
	{
		var part = parts.a;
		formData.append(part.a, part.b);
	}
	return formData;
}

var _Http_bytesToBlob = F2(function(mime, bytes)
{
	return new Blob([bytes], { type: mime });
});


// PROGRESS

function _Http_track(router, xhr, tracker)
{
	// TODO check out lengthComputable on loadstart event

	xhr.upload.addEventListener('progress', function(event) {
		if (xhr.c) { return; }
		_Scheduler_rawSpawn(A2($elm$core$Platform$sendToSelf, router, _Utils_Tuple2(tracker, $elm$http$Http$Sending({
			io: event.loaded,
			en: event.total
		}))));
	});
	xhr.addEventListener('progress', function(event) {
		if (xhr.c) { return; }
		_Scheduler_rawSpawn(A2($elm$core$Platform$sendToSelf, router, _Utils_Tuple2(tracker, $elm$http$Http$Receiving({
			h8: event.loaded,
			en: event.lengthComputable ? $elm$core$Maybe$Just(event.total) : $elm$core$Maybe$Nothing
		}))));
	});
}


// DECODER

var _File_decoder = _Json_decodePrim(function(value) {
	// NOTE: checks if `File` exists in case this is run on node
	return (typeof File !== 'undefined' && value instanceof File)
		? $elm$core$Result$Ok(value)
		: _Json_expecting('a FILE', value);
});


// METADATA

function _File_name(file) { return file.name; }
function _File_mime(file) { return file.type; }
function _File_size(file) { return file.size; }

function _File_lastModified(file)
{
	return $elm$time$Time$millisToPosix(file.lastModified);
}


// DOWNLOAD

var _File_downloadNode;

function _File_getDownloadNode()
{
	return _File_downloadNode || (_File_downloadNode = document.createElement('a'));
}

var _File_download = F3(function(name, mime, content)
{
	return _Scheduler_binding(function(callback)
	{
		var blob = new Blob([content], {type: mime});

		// for IE10+
		if (navigator.msSaveOrOpenBlob)
		{
			navigator.msSaveOrOpenBlob(blob, name);
			return;
		}

		// for HTML5
		var node = _File_getDownloadNode();
		var objectUrl = URL.createObjectURL(blob);
		node.href = objectUrl;
		node.download = name;
		_File_click(node);
		URL.revokeObjectURL(objectUrl);
	});
});

function _File_downloadUrl(href)
{
	return _Scheduler_binding(function(callback)
	{
		var node = _File_getDownloadNode();
		node.href = href;
		node.download = '';
		node.origin === location.origin || (node.target = '_blank');
		_File_click(node);
	});
}


// IE COMPATIBILITY

function _File_makeBytesSafeForInternetExplorer(bytes)
{
	// only needed by IE10 and IE11 to fix https://github.com/elm/file/issues/10
	// all other browsers can just run `new Blob([bytes])` directly with no problem
	//
	return new Uint8Array(bytes.buffer, bytes.byteOffset, bytes.byteLength);
}

function _File_click(node)
{
	// only needed by IE10 and IE11 to fix https://github.com/elm/file/issues/11
	// all other browsers have MouseEvent and do not need this conditional stuff
	//
	if (typeof MouseEvent === 'function')
	{
		node.dispatchEvent(new MouseEvent('click'));
	}
	else
	{
		var event = document.createEvent('MouseEvents');
		event.initMouseEvent('click', true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
		document.body.appendChild(node);
		node.dispatchEvent(event);
		document.body.removeChild(node);
	}
}


// UPLOAD

var _File_node;

function _File_uploadOne(mimes)
{
	return _Scheduler_binding(function(callback)
	{
		_File_node = document.createElement('input');
		_File_node.type = 'file';
		_File_node.accept = A2($elm$core$String$join, ',', mimes);
		_File_node.addEventListener('change', function(event)
		{
			callback(_Scheduler_succeed(event.target.files[0]));
		});
		_File_click(_File_node);
	});
}

function _File_uploadOneOrMore(mimes)
{
	return _Scheduler_binding(function(callback)
	{
		_File_node = document.createElement('input');
		_File_node.type = 'file';
		_File_node.multiple = true;
		_File_node.accept = A2($elm$core$String$join, ',', mimes);
		_File_node.addEventListener('change', function(event)
		{
			var elmFiles = _List_fromArray(event.target.files);
			callback(_Scheduler_succeed(_Utils_Tuple2(elmFiles.a, elmFiles.b)));
		});
		_File_click(_File_node);
	});
}


// CONTENT

function _File_toString(blob)
{
	return _Scheduler_binding(function(callback)
	{
		var reader = new FileReader();
		reader.addEventListener('loadend', function() {
			callback(_Scheduler_succeed(reader.result));
		});
		reader.readAsText(blob);
		return function() { reader.abort(); };
	});
}

function _File_toBytes(blob)
{
	return _Scheduler_binding(function(callback)
	{
		var reader = new FileReader();
		reader.addEventListener('loadend', function() {
			callback(_Scheduler_succeed(new DataView(reader.result)));
		});
		reader.readAsArrayBuffer(blob);
		return function() { reader.abort(); };
	});
}

function _File_toUrl(blob)
{
	return _Scheduler_binding(function(callback)
	{
		var reader = new FileReader();
		reader.addEventListener('loadend', function() {
			callback(_Scheduler_succeed(reader.result));
		});
		reader.readAsDataURL(blob);
		return function() { reader.abort(); };
	});
}





// VIRTUAL-DOM WIDGETS


var _Markdown_toHtml = F3(function(options, factList, rawMarkdown)
{
	return _VirtualDom_custom(
		factList,
		{
			a: options,
			b: rawMarkdown
		},
		_Markdown_render,
		_Markdown_diff
	);
});



// WIDGET IMPLEMENTATION


function _Markdown_render(model)
{
	return A2(_Markdown_replace, model, _VirtualDom_doc.createElement('div'));
}


function _Markdown_diff(x, y)
{
	return x.b === y.b && x.a === y.a
		? false
		: _Markdown_replace(y);
}


var _Markdown_replace = F2(function(model, div)
{
	div.innerHTML = _Markdown_marked(model.b, _Markdown_formatOptions(model.a));
	return div;
});



// ACTUAL MARKDOWN PARSER


var _Markdown_marked = function() {
	// catch the `marked` object regardless of the outer environment.
	// (ex. a CommonJS module compatible environment.)
	// note that this depends on marked's implementation of environment detection.
	var module = {};
	var exports = module.exports = {};

	/**
	 * marked - a markdown parser
	 * Copyright (c) 2011-2014, Christopher Jeffrey. (MIT Licensed)
	 * https://github.com/chjj/marked
	 * commit cd2f6f5b7091154c5526e79b5f3bfb4d15995a51
	 */
	(function(){var block={newline:/^\n+/,code:/^( {4}[^\n]+\n*)+/,fences:noop,hr:/^( *[-*_]){3,} *(?:\n+|$)/,heading:/^ *(#{1,6}) *([^\n]+?) *#* *(?:\n+|$)/,nptable:noop,lheading:/^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,blockquote:/^( *>[^\n]+(\n(?!def)[^\n]+)*\n*)+/,list:/^( *)(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,html:/^ *(?:comment *(?:\n|\s*$)|closed *(?:\n{2,}|\s*$)|closing *(?:\n{2,}|\s*$))/,def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +["(]([^\n]+)[")])? *(?:\n+|$)/,table:noop,paragraph:/^((?:[^\n]+\n?(?!hr|heading|lheading|blockquote|tag|def))+)\n*/,text:/^[^\n]+/};block.bullet=/(?:[*+-]|\d+\.)/;block.item=/^( *)(bull) [^\n]*(?:\n(?!\1bull )[^\n]*)*/;block.item=replace(block.item,"gm")(/bull/g,block.bullet)();block.list=replace(block.list)(/bull/g,block.bullet)("hr","\\n+(?=\\1?(?:[-*_] *){3,}(?:\\n+|$))")("def","\\n+(?="+block.def.source+")")();block.blockquote=replace(block.blockquote)("def",block.def)();block._tag="(?!(?:"+"a|em|strong|small|s|cite|q|dfn|abbr|data|time|code"+"|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo"+"|span|br|wbr|ins|del|img)\\b)\\w+(?!:/|[^\\w\\s@]*@)\\b";block.html=replace(block.html)("comment",/<!--[\s\S]*?-->/)("closed",/<(tag)[\s\S]+?<\/\1>/)("closing",/<tag(?:"[^"]*"|'[^']*'|[^'">])*?>/)(/tag/g,block._tag)();block.paragraph=replace(block.paragraph)("hr",block.hr)("heading",block.heading)("lheading",block.lheading)("blockquote",block.blockquote)("tag","<"+block._tag)("def",block.def)();block.normal=merge({},block);block.gfm=merge({},block.normal,{fences:/^ *(`{3,}|~{3,})[ \.]*(\S+)? *\n([\s\S]*?)\s*\1 *(?:\n+|$)/,paragraph:/^/,heading:/^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/});block.gfm.paragraph=replace(block.paragraph)("(?!","(?!"+block.gfm.fences.source.replace("\\1","\\2")+"|"+block.list.source.replace("\\1","\\3")+"|")();block.tables=merge({},block.gfm,{nptable:/^ *(\S.*\|.*)\n *([-:]+ *\|[-| :]*)\n((?:.*\|.*(?:\n|$))*)\n*/,table:/^ *\|(.+)\n *\|( *[-:]+[-| :]*)\n((?: *\|.*(?:\n|$))*)\n*/});function Lexer(options){this.tokens=[];this.tokens.links={};this.options=options||marked.defaults;this.rules=block.normal;if(this.options.gfm){if(this.options.tables){this.rules=block.tables}else{this.rules=block.gfm}}}Lexer.rules=block;Lexer.lex=function(src,options){var lexer=new Lexer(options);return lexer.lex(src)};Lexer.prototype.lex=function(src){src=src.replace(/\r\n|\r/g,"\n").replace(/\t/g,"    ").replace(/\u00a0/g," ").replace(/\u2424/g,"\n");return this.token(src,true)};Lexer.prototype.token=function(src,top,bq){var src=src.replace(/^ +$/gm,""),next,loose,cap,bull,b,item,space,i,l;while(src){if(cap=this.rules.newline.exec(src)){src=src.substring(cap[0].length);if(cap[0].length>1){this.tokens.push({type:"space"})}}if(cap=this.rules.code.exec(src)){src=src.substring(cap[0].length);cap=cap[0].replace(/^ {4}/gm,"");this.tokens.push({type:"code",text:!this.options.pedantic?cap.replace(/\n+$/,""):cap});continue}if(cap=this.rules.fences.exec(src)){src=src.substring(cap[0].length);this.tokens.push({type:"code",lang:cap[2],text:cap[3]||""});continue}if(cap=this.rules.heading.exec(src)){src=src.substring(cap[0].length);this.tokens.push({type:"heading",depth:cap[1].length,text:cap[2]});continue}if(top&&(cap=this.rules.nptable.exec(src))){src=src.substring(cap[0].length);item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/\n$/,"").split("\n")};for(i=0;i<item.align.length;i++){if(/^ *-+: *$/.test(item.align[i])){item.align[i]="right"}else if(/^ *:-+: *$/.test(item.align[i])){item.align[i]="center"}else if(/^ *:-+ *$/.test(item.align[i])){item.align[i]="left"}else{item.align[i]=null}}for(i=0;i<item.cells.length;i++){item.cells[i]=item.cells[i].split(/ *\| */)}this.tokens.push(item);continue}if(cap=this.rules.lheading.exec(src)){src=src.substring(cap[0].length);this.tokens.push({type:"heading",depth:cap[2]==="="?1:2,text:cap[1]});continue}if(cap=this.rules.hr.exec(src)){src=src.substring(cap[0].length);this.tokens.push({type:"hr"});continue}if(cap=this.rules.blockquote.exec(src)){src=src.substring(cap[0].length);this.tokens.push({type:"blockquote_start"});cap=cap[0].replace(/^ *> ?/gm,"");this.token(cap,top,true);this.tokens.push({type:"blockquote_end"});continue}if(cap=this.rules.list.exec(src)){src=src.substring(cap[0].length);bull=cap[2];this.tokens.push({type:"list_start",ordered:bull.length>1});cap=cap[0].match(this.rules.item);next=false;l=cap.length;i=0;for(;i<l;i++){item=cap[i];space=item.length;item=item.replace(/^ *([*+-]|\d+\.) +/,"");if(~item.indexOf("\n ")){space-=item.length;item=!this.options.pedantic?item.replace(new RegExp("^ {1,"+space+"}","gm"),""):item.replace(/^ {1,4}/gm,"")}if(this.options.smartLists&&i!==l-1){b=block.bullet.exec(cap[i+1])[0];if(bull!==b&&!(bull.length>1&&b.length>1)){src=cap.slice(i+1).join("\n")+src;i=l-1}}loose=next||/\n\n(?!\s*$)/.test(item);if(i!==l-1){next=item.charAt(item.length-1)==="\n";if(!loose)loose=next}this.tokens.push({type:loose?"loose_item_start":"list_item_start"});this.token(item,false,bq);this.tokens.push({type:"list_item_end"})}this.tokens.push({type:"list_end"});continue}if(cap=this.rules.html.exec(src)){src=src.substring(cap[0].length);this.tokens.push({type:this.options.sanitize?"paragraph":"html",pre:!this.options.sanitizer&&(cap[1]==="pre"||cap[1]==="script"||cap[1]==="style"),text:cap[0]});continue}if(!bq&&top&&(cap=this.rules.def.exec(src))){src=src.substring(cap[0].length);this.tokens.links[cap[1].toLowerCase()]={href:cap[2],title:cap[3]};continue}if(top&&(cap=this.rules.table.exec(src))){src=src.substring(cap[0].length);item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/(?: *\| *)?\n$/,"").split("\n")};for(i=0;i<item.align.length;i++){if(/^ *-+: *$/.test(item.align[i])){item.align[i]="right"}else if(/^ *:-+: *$/.test(item.align[i])){item.align[i]="center"}else if(/^ *:-+ *$/.test(item.align[i])){item.align[i]="left"}else{item.align[i]=null}}for(i=0;i<item.cells.length;i++){item.cells[i]=item.cells[i].replace(/^ *\| *| *\| *$/g,"").split(/ *\| */)}this.tokens.push(item);continue}if(top&&(cap=this.rules.paragraph.exec(src))){src=src.substring(cap[0].length);this.tokens.push({type:"paragraph",text:cap[1].charAt(cap[1].length-1)==="\n"?cap[1].slice(0,-1):cap[1]});continue}if(cap=this.rules.text.exec(src)){src=src.substring(cap[0].length);this.tokens.push({type:"text",text:cap[0]});continue}if(src){throw new Error("Infinite loop on byte: "+src.charCodeAt(0))}}return this.tokens};var inline={escape:/^\\([\\`*{}\[\]()#+\-.!_>])/,autolink:/^<([^ >]+(@|:\/)[^ >]+)>/,url:noop,tag:/^<!--[\s\S]*?-->|^<\/?\w+(?:"[^"]*"|'[^']*'|[^'">])*?>/,link:/^!?\[(inside)\]\(href\)/,reflink:/^!?\[(inside)\]\s*\[([^\]]*)\]/,nolink:/^!?\[((?:\[[^\]]*\]|[^\[\]])*)\]/,strong:/^_\_([\s\S]+?)_\_(?!_)|^\*\*([\s\S]+?)\*\*(?!\*)/,em:/^\b_((?:[^_]|_\_)+?)_\b|^\*((?:\*\*|[\s\S])+?)\*(?!\*)/,code:/^(`+)\s*([\s\S]*?[^`])\s*\1(?!`)/,br:/^ {2,}\n(?!\s*$)/,del:noop,text:/^[\s\S]+?(?=[\\<!\[_*`]| {2,}\n|$)/};inline._inside=/(?:\[[^\]]*\]|[^\[\]]|\](?=[^\[]*\]))*/;inline._href=/\s*<?([\s\S]*?)>?(?:\s+['"]([\s\S]*?)['"])?\s*/;inline.link=replace(inline.link)("inside",inline._inside)("href",inline._href)();inline.reflink=replace(inline.reflink)("inside",inline._inside)();inline.normal=merge({},inline);inline.pedantic=merge({},inline.normal,{strong:/^_\_(?=\S)([\s\S]*?\S)_\_(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,em:/^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/});inline.gfm=merge({},inline.normal,{escape:replace(inline.escape)("])","~|])")(),url:/^(https?:\/\/[^\s<]+[^<.,:;"')\]\s])/,del:/^~~(?=\S)([\s\S]*?\S)~~/,text:replace(inline.text)("]|","~]|")("|","|https?://|")()});inline.breaks=merge({},inline.gfm,{br:replace(inline.br)("{2,}","*")(),text:replace(inline.gfm.text)("{2,}","*")()});function InlineLexer(links,options){this.options=options||marked.defaults;this.links=links;this.rules=inline.normal;this.renderer=this.options.renderer||new Renderer;this.renderer.options=this.options;if(!this.links){throw new Error("Tokens array requires a `links` property.")}if(this.options.gfm){if(this.options.breaks){this.rules=inline.breaks}else{this.rules=inline.gfm}}else if(this.options.pedantic){this.rules=inline.pedantic}}InlineLexer.rules=inline;InlineLexer.output=function(src,links,options){var inline=new InlineLexer(links,options);return inline.output(src)};InlineLexer.prototype.output=function(src){var out="",link,text,href,cap;while(src){if(cap=this.rules.escape.exec(src)){src=src.substring(cap[0].length);out+=cap[1];continue}if(cap=this.rules.autolink.exec(src)){src=src.substring(cap[0].length);if(cap[2]==="@"){text=cap[1].charAt(6)===":"?this.mangle(cap[1].substring(7)):this.mangle(cap[1]);href=this.mangle("mailto:")+text}else{text=escape(cap[1]);href=text}out+=this.renderer.link(href,null,text);continue}if(!this.inLink&&(cap=this.rules.url.exec(src))){src=src.substring(cap[0].length);text=escape(cap[1]);href=text;out+=this.renderer.link(href,null,text);continue}if(cap=this.rules.tag.exec(src)){if(!this.inLink&&/^<a /i.test(cap[0])){this.inLink=true}else if(this.inLink&&/^<\/a>/i.test(cap[0])){this.inLink=false}src=src.substring(cap[0].length);out+=this.options.sanitize?this.options.sanitizer?this.options.sanitizer(cap[0]):escape(cap[0]):cap[0];continue}if(cap=this.rules.link.exec(src)){src=src.substring(cap[0].length);this.inLink=true;out+=this.outputLink(cap,{href:cap[2],title:cap[3]});this.inLink=false;continue}if((cap=this.rules.reflink.exec(src))||(cap=this.rules.nolink.exec(src))){src=src.substring(cap[0].length);link=(cap[2]||cap[1]).replace(/\s+/g," ");link=this.links[link.toLowerCase()];if(!link||!link.href){out+=cap[0].charAt(0);src=cap[0].substring(1)+src;continue}this.inLink=true;out+=this.outputLink(cap,link);this.inLink=false;continue}if(cap=this.rules.strong.exec(src)){src=src.substring(cap[0].length);out+=this.renderer.strong(this.output(cap[2]||cap[1]));continue}if(cap=this.rules.em.exec(src)){src=src.substring(cap[0].length);out+=this.renderer.em(this.output(cap[2]||cap[1]));continue}if(cap=this.rules.code.exec(src)){src=src.substring(cap[0].length);out+=this.renderer.codespan(escape(cap[2],true));continue}if(cap=this.rules.br.exec(src)){src=src.substring(cap[0].length);out+=this.renderer.br();continue}if(cap=this.rules.del.exec(src)){src=src.substring(cap[0].length);out+=this.renderer.del(this.output(cap[1]));continue}if(cap=this.rules.text.exec(src)){src=src.substring(cap[0].length);out+=this.renderer.text(escape(this.smartypants(cap[0])));continue}if(src){throw new Error("Infinite loop on byte: "+src.charCodeAt(0))}}return out};InlineLexer.prototype.outputLink=function(cap,link){var href=escape(link.href),title=link.title?escape(link.title):null;return cap[0].charAt(0)!=="!"?this.renderer.link(href,title,this.output(cap[1])):this.renderer.image(href,title,escape(cap[1]))};InlineLexer.prototype.smartypants=function(text){if(!this.options.smartypants)return text;return text.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014\/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014\/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…")};InlineLexer.prototype.mangle=function(text){if(!this.options.mangle)return text;var out="",l=text.length,i=0,ch;for(;i<l;i++){ch=text.charCodeAt(i);if(Math.random()>.5){ch="x"+ch.toString(16)}out+="&#"+ch+";"}return out};function Renderer(options){this.options=options||{}}Renderer.prototype.code=function(code,lang,escaped){if(this.options.highlight){var out=this.options.highlight(code,lang);if(out!=null&&out!==code){escaped=true;code=out}}if(!lang){return"<pre><code>"+(escaped?code:escape(code,true))+"\n</code></pre>"}return'<pre><code class="'+this.options.langPrefix+escape(lang,true)+'">'+(escaped?code:escape(code,true))+"\n</code></pre>\n"};Renderer.prototype.blockquote=function(quote){return"<blockquote>\n"+quote+"</blockquote>\n"};Renderer.prototype.html=function(html){return html};Renderer.prototype.heading=function(text,level,raw){return"<h"+level+' id="'+this.options.headerPrefix+raw.toLowerCase().replace(/[^\w]+/g,"-")+'">'+text+"</h"+level+">\n"};Renderer.prototype.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"};Renderer.prototype.list=function(body,ordered){var type=ordered?"ol":"ul";return"<"+type+">\n"+body+"</"+type+">\n"};Renderer.prototype.listitem=function(text){return"<li>"+text+"</li>\n"};Renderer.prototype.paragraph=function(text){return"<p>"+text+"</p>\n"};Renderer.prototype.table=function(header,body){return"<table>\n"+"<thead>\n"+header+"</thead>\n"+"<tbody>\n"+body+"</tbody>\n"+"</table>\n"};Renderer.prototype.tablerow=function(content){return"<tr>\n"+content+"</tr>\n"};Renderer.prototype.tablecell=function(content,flags){var type=flags.header?"th":"td";var tag=flags.align?"<"+type+' style="text-align:'+flags.align+'">':"<"+type+">";return tag+content+"</"+type+">\n"};Renderer.prototype.strong=function(text){return"<strong>"+text+"</strong>"};Renderer.prototype.em=function(text){return"<em>"+text+"</em>"};Renderer.prototype.codespan=function(text){return"<code>"+text+"</code>"};Renderer.prototype.br=function(){return this.options.xhtml?"<br/>":"<br>"};Renderer.prototype.del=function(text){return"<del>"+text+"</del>"};Renderer.prototype.link=function(href,title,text){if(this.options.sanitize){try{var prot=decodeURIComponent(unescape(href)).replace(/[^\w:]/g,"").toLowerCase()}catch(e){return""}if(prot.indexOf("javascript:")===0||prot.indexOf("vbscript:")===0||prot.indexOf("data:")===0){return""}}var out='<a href="'+href+'"';if(title){out+=' title="'+title+'"'}out+=">"+text+"</a>";return out};Renderer.prototype.image=function(href,title,text){var out='<img src="'+href+'" alt="'+text+'"';if(title){out+=' title="'+title+'"'}out+=this.options.xhtml?"/>":">";return out};Renderer.prototype.text=function(text){return text};function Parser(options){this.tokens=[];this.token=null;this.options=options||marked.defaults;this.options.renderer=this.options.renderer||new Renderer;this.renderer=this.options.renderer;this.renderer.options=this.options}Parser.parse=function(src,options,renderer){var parser=new Parser(options,renderer);return parser.parse(src)};Parser.prototype.parse=function(src){this.inline=new InlineLexer(src.links,this.options,this.renderer);this.tokens=src.reverse();var out="";while(this.next()){out+=this.tok()}return out};Parser.prototype.next=function(){return this.token=this.tokens.pop()};Parser.prototype.peek=function(){return this.tokens[this.tokens.length-1]||0};Parser.prototype.parseText=function(){var body=this.token.text;while(this.peek().type==="text"){body+="\n"+this.next().text}return this.inline.output(body)};Parser.prototype.tok=function(){switch(this.token.type){case"space":{return""}case"hr":{return this.renderer.hr()}case"heading":{return this.renderer.heading(this.inline.output(this.token.text),this.token.depth,this.token.text)}case"code":{return this.renderer.code(this.token.text,this.token.lang,this.token.escaped)}case"table":{var header="",body="",i,row,cell,flags,j;cell="";for(i=0;i<this.token.header.length;i++){flags={header:true,align:this.token.align[i]};cell+=this.renderer.tablecell(this.inline.output(this.token.header[i]),{header:true,align:this.token.align[i]})}header+=this.renderer.tablerow(cell);for(i=0;i<this.token.cells.length;i++){row=this.token.cells[i];cell="";for(j=0;j<row.length;j++){cell+=this.renderer.tablecell(this.inline.output(row[j]),{header:false,align:this.token.align[j]})}body+=this.renderer.tablerow(cell)}return this.renderer.table(header,body)}case"blockquote_start":{var body="";while(this.next().type!=="blockquote_end"){body+=this.tok()}return this.renderer.blockquote(body)}case"list_start":{var body="",ordered=this.token.ordered;while(this.next().type!=="list_end"){body+=this.tok()}return this.renderer.list(body,ordered)}case"list_item_start":{var body="";while(this.next().type!=="list_item_end"){body+=this.token.type==="text"?this.parseText():this.tok()}return this.renderer.listitem(body)}case"loose_item_start":{var body="";while(this.next().type!=="list_item_end"){body+=this.tok()}return this.renderer.listitem(body)}case"html":{var html=!this.token.pre&&!this.options.pedantic?this.inline.output(this.token.text):this.token.text;return this.renderer.html(html)}case"paragraph":{return this.renderer.paragraph(this.inline.output(this.token.text))}case"text":{return this.renderer.paragraph(this.parseText())}}};function escape(html,encode){return html.replace(!encode?/&(?!#?\w+;)/g:/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}function unescape(html){return html.replace(/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/g,function(_,n){n=n.toLowerCase();if(n==="colon")return":";if(n.charAt(0)==="#"){return n.charAt(1)==="x"?String.fromCharCode(parseInt(n.substring(2),16)):String.fromCharCode(+n.substring(1))}return""})}function replace(regex,opt){regex=regex.source;opt=opt||"";return function self(name,val){if(!name)return new RegExp(regex,opt);val=val.source||val;val=val.replace(/(^|[^\[])\^/g,"$1");regex=regex.replace(name,val);return self}}function noop(){}noop.exec=noop;function merge(obj){var i=1,target,key;for(;i<arguments.length;i++){target=arguments[i];for(key in target){if(Object.prototype.hasOwnProperty.call(target,key)){obj[key]=target[key]}}}return obj}function marked(src,opt,callback){if(callback||typeof opt==="function"){if(!callback){callback=opt;opt=null}opt=merge({},marked.defaults,opt||{});var highlight=opt.highlight,tokens,pending,i=0;try{tokens=Lexer.lex(src,opt)}catch(e){return callback(e)}pending=tokens.length;var done=function(err){if(err){opt.highlight=highlight;return callback(err)}var out;try{out=Parser.parse(tokens,opt)}catch(e){err=e}opt.highlight=highlight;return err?callback(err):callback(null,out)};if(!highlight||highlight.length<3){return done()}delete opt.highlight;if(!pending)return done();for(;i<tokens.length;i++){(function(token){if(token.type!=="code"){return--pending||done()}return highlight(token.text,token.lang,function(err,code){if(err)return done(err);if(code==null||code===token.text){return--pending||done()}token.text=code;token.escaped=true;--pending||done()})})(tokens[i])}return}try{if(opt)opt=merge({},marked.defaults,opt);return Parser.parse(Lexer.lex(src,opt),opt)}catch(e){e.message+="\nPlease report this to https://github.com/chjj/marked.";if((opt||marked.defaults).silent){return"<p>An error occured:</p><pre>"+escape(e.message+"",true)+"</pre>"}throw e}}marked.options=marked.setOptions=function(opt){merge(marked.defaults,opt);return marked};marked.defaults={gfm:true,tables:true,breaks:false,pedantic:false,sanitize:false,sanitizer:null,mangle:true,smartLists:false,silent:false,highlight:null,langPrefix:"lang-",smartypants:false,headerPrefix:"",renderer:new Renderer,xhtml:false};marked.Parser=Parser;marked.parser=Parser.parse;marked.Renderer=Renderer;marked.Lexer=Lexer;marked.lexer=Lexer.lex;marked.InlineLexer=InlineLexer;marked.inlineLexer=InlineLexer.output;marked.parse=marked;if(typeof module!=="undefined"&&typeof exports==="object"){module.exports=marked}else if(typeof define==="function"&&define.amd){define(function(){return marked})}else{this.marked=marked}}).call(function(){return this||(typeof window!=="undefined"?window:global)}());

	return module.exports;
}();


// FORMAT OPTIONS FOR MARKED IMPLEMENTATION

function _Markdown_formatOptions(options)
{
	function toHighlight(code, lang)
	{
		if (!lang && $elm$core$Maybe$isJust(options.e$))
		{
			lang = options.e$.a;
		}

		if (typeof hljs !== 'undefined' && lang && hljs.listLanguages().indexOf(lang) >= 0)
		{
			return hljs.highlight(lang, code, true).value;
		}

		return code;
	}

	var gfm = options.ho.a;

	return {
		highlight: toHighlight,
		gfm: gfm,
		tables: gfm && gfm.iC,
		breaks: gfm && gfm.gY,
		sanitize: options.ig,
		smartypants: options.is
	};
}



var _Bitwise_and = F2(function(a, b)
{
	return a & b;
});

var _Bitwise_or = F2(function(a, b)
{
	return a | b;
});

var _Bitwise_xor = F2(function(a, b)
{
	return a ^ b;
});

function _Bitwise_complement(a)
{
	return ~a;
};

var _Bitwise_shiftLeftBy = F2(function(offset, a)
{
	return a << offset;
});

var _Bitwise_shiftRightBy = F2(function(offset, a)
{
	return a >> offset;
});

var _Bitwise_shiftRightZfBy = F2(function(offset, a)
{
	return a >>> offset;
});


// BYTES

function _Bytes_width(bytes)
{
	return bytes.byteLength;
}

var _Bytes_getHostEndianness = F2(function(le, be)
{
	return _Scheduler_binding(function(callback)
	{
		callback(_Scheduler_succeed(new Uint8Array(new Uint32Array([1]))[0] === 1 ? le : be));
	});
});


// ENCODERS

function _Bytes_encode(encoder)
{
	var mutableBytes = new DataView(new ArrayBuffer($elm$bytes$Bytes$Encode$getWidth(encoder)));
	$elm$bytes$Bytes$Encode$write(encoder)(mutableBytes)(0);
	return mutableBytes;
}


// SIGNED INTEGERS

var _Bytes_write_i8  = F3(function(mb, i, n) { mb.setInt8(i, n); return i + 1; });
var _Bytes_write_i16 = F4(function(mb, i, n, isLE) { mb.setInt16(i, n, isLE); return i + 2; });
var _Bytes_write_i32 = F4(function(mb, i, n, isLE) { mb.setInt32(i, n, isLE); return i + 4; });


// UNSIGNED INTEGERS

var _Bytes_write_u8  = F3(function(mb, i, n) { mb.setUint8(i, n); return i + 1 ;});
var _Bytes_write_u16 = F4(function(mb, i, n, isLE) { mb.setUint16(i, n, isLE); return i + 2; });
var _Bytes_write_u32 = F4(function(mb, i, n, isLE) { mb.setUint32(i, n, isLE); return i + 4; });


// FLOATS

var _Bytes_write_f32 = F4(function(mb, i, n, isLE) { mb.setFloat32(i, n, isLE); return i + 4; });
var _Bytes_write_f64 = F4(function(mb, i, n, isLE) { mb.setFloat64(i, n, isLE); return i + 8; });


// BYTES

var _Bytes_write_bytes = F3(function(mb, offset, bytes)
{
	for (var i = 0, len = bytes.byteLength, limit = len - 4; i <= limit; i += 4)
	{
		mb.setUint32(offset + i, bytes.getUint32(i));
	}
	for (; i < len; i++)
	{
		mb.setUint8(offset + i, bytes.getUint8(i));
	}
	return offset + len;
});


// STRINGS

function _Bytes_getStringWidth(string)
{
	for (var width = 0, i = 0; i < string.length; i++)
	{
		var code = string.charCodeAt(i);
		width +=
			(code < 0x80) ? 1 :
			(code < 0x800) ? 2 :
			(code < 0xD800 || 0xDBFF < code) ? 3 : (i++, 4);
	}
	return width;
}

var _Bytes_write_string = F3(function(mb, offset, string)
{
	for (var i = 0; i < string.length; i++)
	{
		var code = string.charCodeAt(i);
		offset +=
			(code < 0x80)
				? (mb.setUint8(offset, code)
				, 1
				)
				:
			(code < 0x800)
				? (mb.setUint16(offset, 0xC080 /* 0b1100000010000000 */
					| (code >>> 6 & 0x1F /* 0b00011111 */) << 8
					| code & 0x3F /* 0b00111111 */)
				, 2
				)
				:
			(code < 0xD800 || 0xDBFF < code)
				? (mb.setUint16(offset, 0xE080 /* 0b1110000010000000 */
					| (code >>> 12 & 0xF /* 0b00001111 */) << 8
					| code >>> 6 & 0x3F /* 0b00111111 */)
				, mb.setUint8(offset + 2, 0x80 /* 0b10000000 */
					| code & 0x3F /* 0b00111111 */)
				, 3
				)
				:
			(code = (code - 0xD800) * 0x400 + string.charCodeAt(++i) - 0xDC00 + 0x10000
			, mb.setUint32(offset, 0xF0808080 /* 0b11110000100000001000000010000000 */
				| (code >>> 18 & 0x7 /* 0b00000111 */) << 24
				| (code >>> 12 & 0x3F /* 0b00111111 */) << 16
				| (code >>> 6 & 0x3F /* 0b00111111 */) << 8
				| code & 0x3F /* 0b00111111 */)
			, 4
			);
	}
	return offset;
});


// DECODER

var _Bytes_decode = F2(function(decoder, bytes)
{
	try {
		return $elm$core$Maybe$Just(A2(decoder, bytes, 0).b);
	} catch(e) {
		return $elm$core$Maybe$Nothing;
	}
});

var _Bytes_read_i8  = F2(function(      bytes, offset) { return _Utils_Tuple2(offset + 1, bytes.getInt8(offset)); });
var _Bytes_read_i16 = F3(function(isLE, bytes, offset) { return _Utils_Tuple2(offset + 2, bytes.getInt16(offset, isLE)); });
var _Bytes_read_i32 = F3(function(isLE, bytes, offset) { return _Utils_Tuple2(offset + 4, bytes.getInt32(offset, isLE)); });
var _Bytes_read_u8  = F2(function(      bytes, offset) { return _Utils_Tuple2(offset + 1, bytes.getUint8(offset)); });
var _Bytes_read_u16 = F3(function(isLE, bytes, offset) { return _Utils_Tuple2(offset + 2, bytes.getUint16(offset, isLE)); });
var _Bytes_read_u32 = F3(function(isLE, bytes, offset) { return _Utils_Tuple2(offset + 4, bytes.getUint32(offset, isLE)); });
var _Bytes_read_f32 = F3(function(isLE, bytes, offset) { return _Utils_Tuple2(offset + 4, bytes.getFloat32(offset, isLE)); });
var _Bytes_read_f64 = F3(function(isLE, bytes, offset) { return _Utils_Tuple2(offset + 8, bytes.getFloat64(offset, isLE)); });

var _Bytes_read_bytes = F3(function(len, bytes, offset)
{
	return _Utils_Tuple2(offset + len, new DataView(bytes.buffer, bytes.byteOffset + offset, len));
});

var _Bytes_read_string = F3(function(len, bytes, offset)
{
	var string = '';
	var end = offset + len;
	for (; offset < end;)
	{
		var byte = bytes.getUint8(offset++);
		string +=
			(byte < 128)
				? String.fromCharCode(byte)
				:
			((byte & 0xE0 /* 0b11100000 */) === 0xC0 /* 0b11000000 */)
				? String.fromCharCode((byte & 0x1F /* 0b00011111 */) << 6 | bytes.getUint8(offset++) & 0x3F /* 0b00111111 */)
				:
			((byte & 0xF0 /* 0b11110000 */) === 0xE0 /* 0b11100000 */)
				? String.fromCharCode(
					(byte & 0xF /* 0b00001111 */) << 12
					| (bytes.getUint8(offset++) & 0x3F /* 0b00111111 */) << 6
					| bytes.getUint8(offset++) & 0x3F /* 0b00111111 */
				)
				:
				(byte =
					((byte & 0x7 /* 0b00000111 */) << 18
						| (bytes.getUint8(offset++) & 0x3F /* 0b00111111 */) << 12
						| (bytes.getUint8(offset++) & 0x3F /* 0b00111111 */) << 6
						| bytes.getUint8(offset++) & 0x3F /* 0b00111111 */
					) - 0x10000
				, String.fromCharCode(Math.floor(byte / 0x400) + 0xD800, byte % 0x400 + 0xDC00)
				);
	}
	return _Utils_Tuple2(offset, string);
});

var _Bytes_decodeFailure = F2(function() { throw 0; });


// CREATE

var _Regex_never = /.^/;

var _Regex_fromStringWith = F2(function(options, string)
{
	var flags = 'g';
	if (options.hN) { flags += 'm'; }
	if (options.g_) { flags += 'i'; }

	try
	{
		return $elm$core$Maybe$Just(new RegExp(string, flags));
	}
	catch(error)
	{
		return $elm$core$Maybe$Nothing;
	}
});


// USE

var _Regex_contains = F2(function(re, string)
{
	return string.match(re) !== null;
});


var _Regex_findAtMost = F3(function(n, re, str)
{
	var out = [];
	var number = 0;
	var string = str;
	var lastIndex = re.lastIndex;
	var prevLastIndex = -1;
	var result;
	while (number++ < n && (result = re.exec(string)))
	{
		if (prevLastIndex == re.lastIndex) break;
		var i = result.length - 1;
		var subs = new Array(i);
		while (i > 0)
		{
			var submatch = result[i];
			subs[--i] = submatch
				? $elm$core$Maybe$Just(submatch)
				: $elm$core$Maybe$Nothing;
		}
		out.push(A4($elm$regex$Regex$Match, result[0], result.index, number, _List_fromArray(subs)));
		prevLastIndex = re.lastIndex;
	}
	re.lastIndex = lastIndex;
	return _List_fromArray(out);
});


var _Regex_replaceAtMost = F4(function(n, re, replacer, string)
{
	var count = 0;
	function jsReplacer(match)
	{
		if (count++ >= n)
		{
			return match;
		}
		var i = arguments.length - 3;
		var submatches = new Array(i);
		while (i > 0)
		{
			var submatch = arguments[i];
			submatches[--i] = submatch
				? $elm$core$Maybe$Just(submatch)
				: $elm$core$Maybe$Nothing;
		}
		return replacer(A4($elm$regex$Regex$Match, match, arguments[arguments.length - 2], count, _List_fromArray(submatches)));
	}
	return string.replace(re, jsReplacer);
});

var _Regex_splitAtMost = F3(function(n, re, str)
{
	var string = str;
	var out = [];
	var start = re.lastIndex;
	var restoreLastIndex = re.lastIndex;
	while (n--)
	{
		var result = re.exec(string);
		if (!result) break;
		out.push(string.slice(start, result.index));
		start = re.lastIndex;
	}
	out.push(string.slice(start));
	re.lastIndex = restoreLastIndex;
	return _List_fromArray(out);
});

var _Regex_infinity = Infinity;
var $elm$core$Maybe$Just = function (a) {
	return {$: 0, a: a};
};
var $author$project$App$Data$NavChange = function (a) {
	return {$: 1, a: a};
};
var $author$project$App$Data$NavRequest = function (a) {
	return {$: 0, a: a};
};
var $elm$core$Maybe$Nothing = {$: 1};
var $elm$core$List$cons = _List_cons;
var $elm$core$Elm$JsArray$foldr = _JsArray_foldr;
var $elm$core$Array$foldr = F3(
	function (func, baseCase, _v0) {
		var tree = _v0.c;
		var tail = _v0.d;
		var helper = F2(
			function (node, acc) {
				if (!node.$) {
					var subTree = node.a;
					return A3($elm$core$Elm$JsArray$foldr, helper, acc, subTree);
				} else {
					var values = node.a;
					return A3($elm$core$Elm$JsArray$foldr, func, acc, values);
				}
			});
		return A3(
			$elm$core$Elm$JsArray$foldr,
			helper,
			A3($elm$core$Elm$JsArray$foldr, func, baseCase, tail),
			tree);
	});
var $elm$core$Array$toList = function (array) {
	return A3($elm$core$Array$foldr, $elm$core$List$cons, _List_Nil, array);
};
var $elm$core$Dict$foldr = F3(
	function (func, acc, t) {
		foldr:
		while (true) {
			if (t.$ === -2) {
				return acc;
			} else {
				var key = t.b;
				var value = t.c;
				var left = t.d;
				var right = t.e;
				var $temp$func = func,
					$temp$acc = A3(
					func,
					key,
					value,
					A3($elm$core$Dict$foldr, func, acc, right)),
					$temp$t = left;
				func = $temp$func;
				acc = $temp$acc;
				t = $temp$t;
				continue foldr;
			}
		}
	});
var $elm$core$Dict$toList = function (dict) {
	return A3(
		$elm$core$Dict$foldr,
		F3(
			function (key, value, list) {
				return A2(
					$elm$core$List$cons,
					_Utils_Tuple2(key, value),
					list);
			}),
		_List_Nil,
		dict);
};
var $elm$core$Dict$keys = function (dict) {
	return A3(
		$elm$core$Dict$foldr,
		F3(
			function (key, value, keyList) {
				return A2($elm$core$List$cons, key, keyList);
			}),
		_List_Nil,
		dict);
};
var $elm$core$Set$toList = function (_v0) {
	var dict = _v0;
	return $elm$core$Dict$keys(dict);
};
var $elm$core$Basics$EQ = 1;
var $elm$core$Basics$GT = 2;
var $elm$core$Basics$LT = 0;
var $elm$core$Result$Err = function (a) {
	return {$: 1, a: a};
};
var $elm$json$Json$Decode$Failure = F2(
	function (a, b) {
		return {$: 3, a: a, b: b};
	});
var $elm$json$Json$Decode$Field = F2(
	function (a, b) {
		return {$: 0, a: a, b: b};
	});
var $elm$json$Json$Decode$Index = F2(
	function (a, b) {
		return {$: 1, a: a, b: b};
	});
var $elm$core$Result$Ok = function (a) {
	return {$: 0, a: a};
};
var $elm$json$Json$Decode$OneOf = function (a) {
	return {$: 2, a: a};
};
var $elm$core$Basics$False = 1;
var $elm$core$Basics$add = _Basics_add;
var $elm$core$String$all = _String_all;
var $elm$core$Basics$and = _Basics_and;
var $elm$core$Basics$append = _Utils_append;
var $elm$json$Json$Encode$encode = _Json_encode;
var $elm$core$String$fromInt = _String_fromNumber;
var $elm$core$String$join = F2(
	function (sep, chunks) {
		return A2(
			_String_join,
			sep,
			_List_toArray(chunks));
	});
var $elm$core$String$split = F2(
	function (sep, string) {
		return _List_fromArray(
			A2(_String_split, sep, string));
	});
var $elm$json$Json$Decode$indent = function (str) {
	return A2(
		$elm$core$String$join,
		'\n    ',
		A2($elm$core$String$split, '\n', str));
};
var $elm$core$List$foldl = F3(
	function (func, acc, list) {
		foldl:
		while (true) {
			if (!list.b) {
				return acc;
			} else {
				var x = list.a;
				var xs = list.b;
				var $temp$func = func,
					$temp$acc = A2(func, x, acc),
					$temp$list = xs;
				func = $temp$func;
				acc = $temp$acc;
				list = $temp$list;
				continue foldl;
			}
		}
	});
var $elm$core$List$length = function (xs) {
	return A3(
		$elm$core$List$foldl,
		F2(
			function (_v0, i) {
				return i + 1;
			}),
		0,
		xs);
};
var $elm$core$List$map2 = _List_map2;
var $elm$core$Basics$le = _Utils_le;
var $elm$core$Basics$sub = _Basics_sub;
var $elm$core$List$rangeHelp = F3(
	function (lo, hi, list) {
		rangeHelp:
		while (true) {
			if (_Utils_cmp(lo, hi) < 1) {
				var $temp$lo = lo,
					$temp$hi = hi - 1,
					$temp$list = A2($elm$core$List$cons, hi, list);
				lo = $temp$lo;
				hi = $temp$hi;
				list = $temp$list;
				continue rangeHelp;
			} else {
				return list;
			}
		}
	});
var $elm$core$List$range = F2(
	function (lo, hi) {
		return A3($elm$core$List$rangeHelp, lo, hi, _List_Nil);
	});
var $elm$core$List$indexedMap = F2(
	function (f, xs) {
		return A3(
			$elm$core$List$map2,
			f,
			A2(
				$elm$core$List$range,
				0,
				$elm$core$List$length(xs) - 1),
			xs);
	});
var $elm$core$Char$toCode = _Char_toCode;
var $elm$core$Char$isLower = function (_char) {
	var code = $elm$core$Char$toCode(_char);
	return (97 <= code) && (code <= 122);
};
var $elm$core$Char$isUpper = function (_char) {
	var code = $elm$core$Char$toCode(_char);
	return (code <= 90) && (65 <= code);
};
var $elm$core$Basics$or = _Basics_or;
var $elm$core$Char$isAlpha = function (_char) {
	return $elm$core$Char$isLower(_char) || $elm$core$Char$isUpper(_char);
};
var $elm$core$Char$isDigit = function (_char) {
	var code = $elm$core$Char$toCode(_char);
	return (code <= 57) && (48 <= code);
};
var $elm$core$Char$isAlphaNum = function (_char) {
	return $elm$core$Char$isLower(_char) || ($elm$core$Char$isUpper(_char) || $elm$core$Char$isDigit(_char));
};
var $elm$core$List$reverse = function (list) {
	return A3($elm$core$List$foldl, $elm$core$List$cons, _List_Nil, list);
};
var $elm$core$String$uncons = _String_uncons;
var $elm$json$Json$Decode$errorOneOf = F2(
	function (i, error) {
		return '\n\n(' + ($elm$core$String$fromInt(i + 1) + (') ' + $elm$json$Json$Decode$indent(
			$elm$json$Json$Decode$errorToString(error))));
	});
var $elm$json$Json$Decode$errorToString = function (error) {
	return A2($elm$json$Json$Decode$errorToStringHelp, error, _List_Nil);
};
var $elm$json$Json$Decode$errorToStringHelp = F2(
	function (error, context) {
		errorToStringHelp:
		while (true) {
			switch (error.$) {
				case 0:
					var f = error.a;
					var err = error.b;
					var isSimple = function () {
						var _v1 = $elm$core$String$uncons(f);
						if (_v1.$ === 1) {
							return false;
						} else {
							var _v2 = _v1.a;
							var _char = _v2.a;
							var rest = _v2.b;
							return $elm$core$Char$isAlpha(_char) && A2($elm$core$String$all, $elm$core$Char$isAlphaNum, rest);
						}
					}();
					var fieldName = isSimple ? ('.' + f) : ('[\'' + (f + '\']'));
					var $temp$error = err,
						$temp$context = A2($elm$core$List$cons, fieldName, context);
					error = $temp$error;
					context = $temp$context;
					continue errorToStringHelp;
				case 1:
					var i = error.a;
					var err = error.b;
					var indexName = '[' + ($elm$core$String$fromInt(i) + ']');
					var $temp$error = err,
						$temp$context = A2($elm$core$List$cons, indexName, context);
					error = $temp$error;
					context = $temp$context;
					continue errorToStringHelp;
				case 2:
					var errors = error.a;
					if (!errors.b) {
						return 'Ran into a Json.Decode.oneOf with no possibilities' + function () {
							if (!context.b) {
								return '!';
							} else {
								return ' at json' + A2(
									$elm$core$String$join,
									'',
									$elm$core$List$reverse(context));
							}
						}();
					} else {
						if (!errors.b.b) {
							var err = errors.a;
							var $temp$error = err,
								$temp$context = context;
							error = $temp$error;
							context = $temp$context;
							continue errorToStringHelp;
						} else {
							var starter = function () {
								if (!context.b) {
									return 'Json.Decode.oneOf';
								} else {
									return 'The Json.Decode.oneOf at json' + A2(
										$elm$core$String$join,
										'',
										$elm$core$List$reverse(context));
								}
							}();
							var introduction = starter + (' failed in the following ' + ($elm$core$String$fromInt(
								$elm$core$List$length(errors)) + ' ways:'));
							return A2(
								$elm$core$String$join,
								'\n\n',
								A2(
									$elm$core$List$cons,
									introduction,
									A2($elm$core$List$indexedMap, $elm$json$Json$Decode$errorOneOf, errors)));
						}
					}
				default:
					var msg = error.a;
					var json = error.b;
					var introduction = function () {
						if (!context.b) {
							return 'Problem with the given value:\n\n';
						} else {
							return 'Problem with the value at json' + (A2(
								$elm$core$String$join,
								'',
								$elm$core$List$reverse(context)) + ':\n\n    ');
						}
					}();
					return introduction + ($elm$json$Json$Decode$indent(
						A2($elm$json$Json$Encode$encode, 4, json)) + ('\n\n' + msg));
			}
		}
	});
var $elm$core$Array$branchFactor = 32;
var $elm$core$Array$Array_elm_builtin = F4(
	function (a, b, c, d) {
		return {$: 0, a: a, b: b, c: c, d: d};
	});
var $elm$core$Elm$JsArray$empty = _JsArray_empty;
var $elm$core$Basics$ceiling = _Basics_ceiling;
var $elm$core$Basics$fdiv = _Basics_fdiv;
var $elm$core$Basics$logBase = F2(
	function (base, number) {
		return _Basics_log(number) / _Basics_log(base);
	});
var $elm$core$Basics$toFloat = _Basics_toFloat;
var $elm$core$Array$shiftStep = $elm$core$Basics$ceiling(
	A2($elm$core$Basics$logBase, 2, $elm$core$Array$branchFactor));
var $elm$core$Array$empty = A4($elm$core$Array$Array_elm_builtin, 0, $elm$core$Array$shiftStep, $elm$core$Elm$JsArray$empty, $elm$core$Elm$JsArray$empty);
var $elm$core$Elm$JsArray$initialize = _JsArray_initialize;
var $elm$core$Array$Leaf = function (a) {
	return {$: 1, a: a};
};
var $elm$core$Basics$apL = F2(
	function (f, x) {
		return f(x);
	});
var $elm$core$Basics$apR = F2(
	function (x, f) {
		return f(x);
	});
var $elm$core$Basics$eq = _Utils_equal;
var $elm$core$Basics$floor = _Basics_floor;
var $elm$core$Elm$JsArray$length = _JsArray_length;
var $elm$core$Basics$gt = _Utils_gt;
var $elm$core$Basics$max = F2(
	function (x, y) {
		return (_Utils_cmp(x, y) > 0) ? x : y;
	});
var $elm$core$Basics$mul = _Basics_mul;
var $elm$core$Array$SubTree = function (a) {
	return {$: 0, a: a};
};
var $elm$core$Elm$JsArray$initializeFromList = _JsArray_initializeFromList;
var $elm$core$Array$compressNodes = F2(
	function (nodes, acc) {
		compressNodes:
		while (true) {
			var _v0 = A2($elm$core$Elm$JsArray$initializeFromList, $elm$core$Array$branchFactor, nodes);
			var node = _v0.a;
			var remainingNodes = _v0.b;
			var newAcc = A2(
				$elm$core$List$cons,
				$elm$core$Array$SubTree(node),
				acc);
			if (!remainingNodes.b) {
				return $elm$core$List$reverse(newAcc);
			} else {
				var $temp$nodes = remainingNodes,
					$temp$acc = newAcc;
				nodes = $temp$nodes;
				acc = $temp$acc;
				continue compressNodes;
			}
		}
	});
var $elm$core$Tuple$first = function (_v0) {
	var x = _v0.a;
	return x;
};
var $elm$core$Array$treeFromBuilder = F2(
	function (nodeList, nodeListSize) {
		treeFromBuilder:
		while (true) {
			var newNodeSize = $elm$core$Basics$ceiling(nodeListSize / $elm$core$Array$branchFactor);
			if (newNodeSize === 1) {
				return A2($elm$core$Elm$JsArray$initializeFromList, $elm$core$Array$branchFactor, nodeList).a;
			} else {
				var $temp$nodeList = A2($elm$core$Array$compressNodes, nodeList, _List_Nil),
					$temp$nodeListSize = newNodeSize;
				nodeList = $temp$nodeList;
				nodeListSize = $temp$nodeListSize;
				continue treeFromBuilder;
			}
		}
	});
var $elm$core$Array$builderToArray = F2(
	function (reverseNodeList, builder) {
		if (!builder.h) {
			return A4(
				$elm$core$Array$Array_elm_builtin,
				$elm$core$Elm$JsArray$length(builder.j),
				$elm$core$Array$shiftStep,
				$elm$core$Elm$JsArray$empty,
				builder.j);
		} else {
			var treeLen = builder.h * $elm$core$Array$branchFactor;
			var depth = $elm$core$Basics$floor(
				A2($elm$core$Basics$logBase, $elm$core$Array$branchFactor, treeLen - 1));
			var correctNodeList = reverseNodeList ? $elm$core$List$reverse(builder.l) : builder.l;
			var tree = A2($elm$core$Array$treeFromBuilder, correctNodeList, builder.h);
			return A4(
				$elm$core$Array$Array_elm_builtin,
				$elm$core$Elm$JsArray$length(builder.j) + treeLen,
				A2($elm$core$Basics$max, 5, depth * $elm$core$Array$shiftStep),
				tree,
				builder.j);
		}
	});
var $elm$core$Basics$idiv = _Basics_idiv;
var $elm$core$Basics$lt = _Utils_lt;
var $elm$core$Array$initializeHelp = F5(
	function (fn, fromIndex, len, nodeList, tail) {
		initializeHelp:
		while (true) {
			if (fromIndex < 0) {
				return A2(
					$elm$core$Array$builderToArray,
					false,
					{l: nodeList, h: (len / $elm$core$Array$branchFactor) | 0, j: tail});
			} else {
				var leaf = $elm$core$Array$Leaf(
					A3($elm$core$Elm$JsArray$initialize, $elm$core$Array$branchFactor, fromIndex, fn));
				var $temp$fn = fn,
					$temp$fromIndex = fromIndex - $elm$core$Array$branchFactor,
					$temp$len = len,
					$temp$nodeList = A2($elm$core$List$cons, leaf, nodeList),
					$temp$tail = tail;
				fn = $temp$fn;
				fromIndex = $temp$fromIndex;
				len = $temp$len;
				nodeList = $temp$nodeList;
				tail = $temp$tail;
				continue initializeHelp;
			}
		}
	});
var $elm$core$Basics$remainderBy = _Basics_remainderBy;
var $elm$core$Array$initialize = F2(
	function (len, fn) {
		if (len <= 0) {
			return $elm$core$Array$empty;
		} else {
			var tailLen = len % $elm$core$Array$branchFactor;
			var tail = A3($elm$core$Elm$JsArray$initialize, tailLen, len - tailLen, fn);
			var initialFromIndex = (len - tailLen) - $elm$core$Array$branchFactor;
			return A5($elm$core$Array$initializeHelp, fn, initialFromIndex, len, _List_Nil, tail);
		}
	});
var $elm$core$Basics$True = 0;
var $elm$core$Result$isOk = function (result) {
	if (!result.$) {
		return true;
	} else {
		return false;
	}
};
var $elm$json$Json$Decode$andThen = _Json_andThen;
var $elm$json$Json$Decode$map = _Json_map1;
var $elm$json$Json$Decode$map2 = _Json_map2;
var $elm$json$Json$Decode$succeed = _Json_succeed;
var $elm$virtual_dom$VirtualDom$toHandlerInt = function (handler) {
	switch (handler.$) {
		case 0:
			return 0;
		case 1:
			return 1;
		case 2:
			return 2;
		default:
			return 3;
	}
};
var $elm$browser$Browser$External = function (a) {
	return {$: 1, a: a};
};
var $elm$browser$Browser$Internal = function (a) {
	return {$: 0, a: a};
};
var $elm$core$Basics$identity = function (x) {
	return x;
};
var $elm$browser$Browser$Dom$NotFound = $elm$core$Basics$identity;
var $elm$url$Url$Http = 0;
var $elm$url$Url$Https = 1;
var $elm$url$Url$Url = F6(
	function (protocol, host, port_, path, query, fragment) {
		return {hn: fragment, fo: host, h3: path, f5: port_, f9: protocol, h7: query};
	});
var $elm$core$String$contains = _String_contains;
var $elm$core$String$length = _String_length;
var $elm$core$String$slice = _String_slice;
var $elm$core$String$dropLeft = F2(
	function (n, string) {
		return (n < 1) ? string : A3(
			$elm$core$String$slice,
			n,
			$elm$core$String$length(string),
			string);
	});
var $elm$core$String$indexes = _String_indexes;
var $elm$core$String$isEmpty = function (string) {
	return string === '';
};
var $elm$core$String$left = F2(
	function (n, string) {
		return (n < 1) ? '' : A3($elm$core$String$slice, 0, n, string);
	});
var $elm$core$String$toInt = _String_toInt;
var $elm$url$Url$chompBeforePath = F5(
	function (protocol, path, params, frag, str) {
		if ($elm$core$String$isEmpty(str) || A2($elm$core$String$contains, '@', str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, ':', str);
			if (!_v0.b) {
				return $elm$core$Maybe$Just(
					A6($elm$url$Url$Url, protocol, str, $elm$core$Maybe$Nothing, path, params, frag));
			} else {
				if (!_v0.b.b) {
					var i = _v0.a;
					var _v1 = $elm$core$String$toInt(
						A2($elm$core$String$dropLeft, i + 1, str));
					if (_v1.$ === 1) {
						return $elm$core$Maybe$Nothing;
					} else {
						var port_ = _v1;
						return $elm$core$Maybe$Just(
							A6(
								$elm$url$Url$Url,
								protocol,
								A2($elm$core$String$left, i, str),
								port_,
								path,
								params,
								frag));
					}
				} else {
					return $elm$core$Maybe$Nothing;
				}
			}
		}
	});
var $elm$url$Url$chompBeforeQuery = F4(
	function (protocol, params, frag, str) {
		if ($elm$core$String$isEmpty(str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, '/', str);
			if (!_v0.b) {
				return A5($elm$url$Url$chompBeforePath, protocol, '/', params, frag, str);
			} else {
				var i = _v0.a;
				return A5(
					$elm$url$Url$chompBeforePath,
					protocol,
					A2($elm$core$String$dropLeft, i, str),
					params,
					frag,
					A2($elm$core$String$left, i, str));
			}
		}
	});
var $elm$url$Url$chompBeforeFragment = F3(
	function (protocol, frag, str) {
		if ($elm$core$String$isEmpty(str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, '?', str);
			if (!_v0.b) {
				return A4($elm$url$Url$chompBeforeQuery, protocol, $elm$core$Maybe$Nothing, frag, str);
			} else {
				var i = _v0.a;
				return A4(
					$elm$url$Url$chompBeforeQuery,
					protocol,
					$elm$core$Maybe$Just(
						A2($elm$core$String$dropLeft, i + 1, str)),
					frag,
					A2($elm$core$String$left, i, str));
			}
		}
	});
var $elm$url$Url$chompAfterProtocol = F2(
	function (protocol, str) {
		if ($elm$core$String$isEmpty(str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, '#', str);
			if (!_v0.b) {
				return A3($elm$url$Url$chompBeforeFragment, protocol, $elm$core$Maybe$Nothing, str);
			} else {
				var i = _v0.a;
				return A3(
					$elm$url$Url$chompBeforeFragment,
					protocol,
					$elm$core$Maybe$Just(
						A2($elm$core$String$dropLeft, i + 1, str)),
					A2($elm$core$String$left, i, str));
			}
		}
	});
var $elm$core$String$startsWith = _String_startsWith;
var $elm$url$Url$fromString = function (str) {
	return A2($elm$core$String$startsWith, 'http://', str) ? A2(
		$elm$url$Url$chompAfterProtocol,
		0,
		A2($elm$core$String$dropLeft, 7, str)) : (A2($elm$core$String$startsWith, 'https://', str) ? A2(
		$elm$url$Url$chompAfterProtocol,
		1,
		A2($elm$core$String$dropLeft, 8, str)) : $elm$core$Maybe$Nothing);
};
var $elm$core$Basics$never = function (_v0) {
	never:
	while (true) {
		var nvr = _v0;
		var $temp$_v0 = nvr;
		_v0 = $temp$_v0;
		continue never;
	}
};
var $elm$core$Task$Perform = $elm$core$Basics$identity;
var $elm$core$Task$succeed = _Scheduler_succeed;
var $elm$core$Task$init = $elm$core$Task$succeed(0);
var $elm$core$List$foldrHelper = F4(
	function (fn, acc, ctr, ls) {
		if (!ls.b) {
			return acc;
		} else {
			var a = ls.a;
			var r1 = ls.b;
			if (!r1.b) {
				return A2(fn, a, acc);
			} else {
				var b = r1.a;
				var r2 = r1.b;
				if (!r2.b) {
					return A2(
						fn,
						a,
						A2(fn, b, acc));
				} else {
					var c = r2.a;
					var r3 = r2.b;
					if (!r3.b) {
						return A2(
							fn,
							a,
							A2(
								fn,
								b,
								A2(fn, c, acc)));
					} else {
						var d = r3.a;
						var r4 = r3.b;
						var res = (ctr > 500) ? A3(
							$elm$core$List$foldl,
							fn,
							acc,
							$elm$core$List$reverse(r4)) : A4($elm$core$List$foldrHelper, fn, acc, ctr + 1, r4);
						return A2(
							fn,
							a,
							A2(
								fn,
								b,
								A2(
									fn,
									c,
									A2(fn, d, res))));
					}
				}
			}
		}
	});
var $elm$core$List$foldr = F3(
	function (fn, acc, ls) {
		return A4($elm$core$List$foldrHelper, fn, acc, 0, ls);
	});
var $elm$core$List$map = F2(
	function (f, xs) {
		return A3(
			$elm$core$List$foldr,
			F2(
				function (x, acc) {
					return A2(
						$elm$core$List$cons,
						f(x),
						acc);
				}),
			_List_Nil,
			xs);
	});
var $elm$core$Task$andThen = _Scheduler_andThen;
var $elm$core$Task$map = F2(
	function (func, taskA) {
		return A2(
			$elm$core$Task$andThen,
			function (a) {
				return $elm$core$Task$succeed(
					func(a));
			},
			taskA);
	});
var $elm$core$Task$map2 = F3(
	function (func, taskA, taskB) {
		return A2(
			$elm$core$Task$andThen,
			function (a) {
				return A2(
					$elm$core$Task$andThen,
					function (b) {
						return $elm$core$Task$succeed(
							A2(func, a, b));
					},
					taskB);
			},
			taskA);
	});
var $elm$core$Task$sequence = function (tasks) {
	return A3(
		$elm$core$List$foldr,
		$elm$core$Task$map2($elm$core$List$cons),
		$elm$core$Task$succeed(_List_Nil),
		tasks);
};
var $elm$core$Platform$sendToApp = _Platform_sendToApp;
var $elm$core$Task$spawnCmd = F2(
	function (router, _v0) {
		var task = _v0;
		return _Scheduler_spawn(
			A2(
				$elm$core$Task$andThen,
				$elm$core$Platform$sendToApp(router),
				task));
	});
var $elm$core$Task$onEffects = F3(
	function (router, commands, state) {
		return A2(
			$elm$core$Task$map,
			function (_v0) {
				return 0;
			},
			$elm$core$Task$sequence(
				A2(
					$elm$core$List$map,
					$elm$core$Task$spawnCmd(router),
					commands)));
	});
var $elm$core$Task$onSelfMsg = F3(
	function (_v0, _v1, _v2) {
		return $elm$core$Task$succeed(0);
	});
var $elm$core$Task$cmdMap = F2(
	function (tagger, _v0) {
		var task = _v0;
		return A2($elm$core$Task$map, tagger, task);
	});
_Platform_effectManagers['Task'] = _Platform_createManager($elm$core$Task$init, $elm$core$Task$onEffects, $elm$core$Task$onSelfMsg, $elm$core$Task$cmdMap);
var $elm$core$Task$command = _Platform_leaf('Task');
var $elm$core$Task$perform = F2(
	function (toMessage, task) {
		return $elm$core$Task$command(
			A2($elm$core$Task$map, toMessage, task));
	});
var $elm$browser$Browser$application = _Browser_application;
var $elm$json$Json$Decode$bool = _Json_decodeBool;
var $elm$json$Json$Decode$field = _Json_decodeField;
var $author$project$App$Data$SessionCheckResp = function (a) {
	return {$: 18, a: a};
};
var $author$project$App$Data$VersionResp = function (a) {
	return {$: 2, a: a};
};
var $elm$core$Platform$Cmd$batch = _Platform_batch;
var $author$project$Page$InfoPage = function (a) {
	return {$: 4, a: a};
};
var $author$project$Util$Maybe$filter = F2(
	function (pred, ma) {
		if (!ma.$) {
			var v = ma.a;
			return pred(v) ? ma : $elm$core$Maybe$Nothing;
		} else {
			return $elm$core$Maybe$Nothing;
		}
	});
var $elm$core$Maybe$map = F2(
	function (f, maybe) {
		if (!maybe.$) {
			var value = maybe.a;
			return $elm$core$Maybe$Just(
				f(value));
		} else {
			return $elm$core$Maybe$Nothing;
		}
	});
var $elm$core$Maybe$withDefault = F2(
	function (_default, maybe) {
		if (!maybe.$) {
			var value = maybe.a;
			return value;
		} else {
			return _default;
		}
	});
var $author$project$App$Data$isAdmin = function (flags) {
	return A2(
		$elm$core$Maybe$withDefault,
		false,
		A2(
			$elm$core$Maybe$map,
			function ($) {
				return $.cK;
			},
			A2(
				$author$project$Util$Maybe$filter,
				function ($) {
					return $.iA;
				},
				flags.f)));
};
var $author$project$Page$isAdmin = function (page) {
	switch (page.$) {
		case 3:
			return true;
		case 5:
			return true;
		default:
			return false;
	}
};
var $author$project$Page$isSecured = function (page) {
	switch (page.$) {
		case 0:
			return true;
		case 1:
			return false;
		case 2:
			return false;
		case 3:
			return true;
		case 4:
			return false;
		case 5:
			return true;
		case 6:
			return true;
		case 7:
			return true;
		case 8:
			return true;
		case 9:
			return false;
		case 10:
			return true;
		case 11:
			return true;
		default:
			return false;
	}
};
var $elm$core$Basics$not = _Basics_not;
var $author$project$Page$isOpen = function (page) {
	return !($author$project$Page$isSecured(page) || $author$project$Page$isAdmin(page));
};
var $author$project$App$Data$isSignedIn = function (flags) {
	return A2(
		$elm$core$Maybe$withDefault,
		false,
		A2(
			$elm$core$Maybe$map,
			function ($) {
				return $.iA;
			},
			flags.f));
};
var $author$project$Page$LoginPage = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$pageToString = function (page) {
	switch (page.$) {
		case 0:
			return '/app/home';
		case 1:
			var _v1 = page.a;
			var referer = _v1.a;
			return '/app/login' + A2(
				$elm$core$Maybe$withDefault,
				'',
				A2(
					$elm$core$Maybe$map,
					function (p) {
						return '?r=' + p;
					},
					referer));
		case 2:
			return '/app/register';
		case 3:
			return '/app/newinvite';
		case 4:
			var n = page.a;
			return '/app/info/' + $elm$core$String$fromInt(n);
		case 5:
			var mid = page.a;
			var path = '/app/account';
			return A2(
				$elm$core$Maybe$withDefault,
				path,
				A2(
					$elm$core$Maybe$map,
					function (id) {
						return path + ('/' + id);
					},
					mid));
		case 6:
			var mid = page.a;
			var path = '/app/alias';
			return A2(
				$elm$core$Maybe$withDefault,
				path,
				A2(
					$elm$core$Maybe$map,
					function (id) {
						return path + ('/' + id);
					},
					mid));
		case 7:
			return '/app/uploads';
		case 8:
			return '/app/share';
		case 9:
			var id = page.a;
			return '/app/share/' + id;
		case 10:
			return '/app/settings';
		case 11:
			var id = page.a;
			return '/app/upload/' + id;
		default:
			var id = page.a;
			var initialView = page.b;
			var viewParam = function () {
				if (!initialView.$) {
					var n = initialView.a;
					return '?view=' + $elm$core$String$fromInt(n);
				} else {
					return '';
				}
			}();
			return '/app/open/' + (id + viewParam);
	}
};
var $author$project$Page$loginPage = function (p) {
	if (p.$ === 1) {
		return $author$project$Page$LoginPage(
			_Utils_Tuple2($elm$core$Maybe$Nothing, false));
	} else {
		return $author$project$Page$LoginPage(
			_Utils_Tuple2(
				$elm$core$Maybe$Just(
					$author$project$Page$pageToString(p)),
				false));
	}
};
var $author$project$App$Data$checkPage = F2(
	function (flags, page) {
		return ($author$project$Page$isAdmin(page) && (!$author$project$App$Data$isAdmin(flags))) ? $author$project$Page$InfoPage(0) : (($author$project$Page$isSecured(page) && $author$project$App$Data$isSignedIn(flags)) ? page : ($author$project$Page$isOpen(page) ? page : $author$project$Page$loginPage(page)));
	});
var $elm$browser$Browser$Navigation$load = _Browser_load;
var $author$project$Page$goto = function (page) {
	return $elm$browser$Browser$Navigation$load(
		$author$project$Page$pageToString(page));
};
var $author$project$Page$HomePage = {$: 0};
var $author$project$Data$UiTheme$Light = 0;
var $elm$core$Maybe$andThen = F2(
	function (callback, maybeValue) {
		if (!maybeValue.$) {
			var value = maybeValue.a;
			return callback(value);
		} else {
			return $elm$core$Maybe$Nothing;
		}
	});
var $author$project$Api$Model$VersionInfo$empty = {cT: 0, cU: '', dl: '', dm: '', eH: ''};
var $author$project$Language$Czech = 4;
var $author$project$Language$English = 0;
var $author$project$Language$French = 2;
var $author$project$Language$German = 1;
var $author$project$Language$Japanese = 3;
var $author$project$Language$allLanguages = _List_fromArray(
	[0, 1, 2, 3, 4]);
var $author$project$Comp$FixedDropdown$Item = function (id) {
	return {hs: id};
};
var $author$project$Comp$FixedDropdown$initItems = function (options) {
	return {k: false, h1: options, cG: $elm$core$Maybe$Nothing};
};
var $author$project$Comp$FixedDropdown$init = function (els) {
	return $author$project$Comp$FixedDropdown$initItems(
		A2($elm$core$List$map, $author$project$Comp$FixedDropdown$Item, els));
};
var $author$project$Comp$LanguageChoose$init = $author$project$Comp$FixedDropdown$init($author$project$Language$allLanguages);
var $author$project$Page$Login$Data$empty = {fx: $author$project$Comp$LanguageChoose$init, d4: '', P: $elm$core$Maybe$Nothing, b6: ''};
var $author$project$Comp$AccountTable$init = {cG: $elm$core$Maybe$Nothing};
var $author$project$Data$AccountState$Active = 0;
var $author$project$Data$AccountState$Disabled = 1;
var $author$project$Data$AccountState$all = _List_fromArray(
	[0, 1]);
var $author$project$Comp$PasswordInput$init = {ir: false};
var $author$project$Comp$AccountForm$initNew = {
	R: false,
	aR: false,
	ag: $elm$core$Maybe$Nothing,
	V: $elm$core$Maybe$Nothing,
	W: '',
	Z: $elm$core$Maybe$Nothing,
	ci: $author$project$Comp$PasswordInput$init,
	ab: 0,
	cj: $author$project$Comp$FixedDropdown$init($author$project$Data$AccountState$all)
};
var $author$project$Page$Account$Data$emptyModel = {fh: $author$project$Comp$AccountForm$initNew, h7: '', gg: $elm$core$Maybe$Nothing, gi: _List_Nil, cG: $elm$core$Maybe$Nothing, gw: $author$project$Comp$AccountTable$init};
var $author$project$Comp$AliasTable$init = {cG: $elm$core$Maybe$Nothing};
var $author$project$Data$ValidityValue$Days = function (a) {
	return {$: 3, a: a};
};
var $elm$core$List$filter = F2(
	function (isGood, list) {
		return A3(
			$elm$core$List$foldr,
			F2(
				function (x, xs) {
					return isGood(x) ? A2($elm$core$List$cons, x, xs) : xs;
				}),
			_List_Nil,
			list);
	});
var $elm$core$List$head = function (list) {
	if (list.b) {
		var x = list.a;
		var xs = list.b;
		return $elm$core$Maybe$Just(x);
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $author$project$Data$ValidityValue$hourToMillis = (60 * 60) * 1000;
var $author$project$Data$ValidityValue$dayToMillis = 24 * $author$project$Data$ValidityValue$hourToMillis;
var $author$project$Data$ValidityValue$minutesToMillis = 60 * 1000;
var $author$project$Data$ValidityValue$toMillis = function (v) {
	switch (v.$) {
		case 0:
			var n = v.a;
			return n;
		case 1:
			var n = v.a;
			return n * $author$project$Data$ValidityValue$minutesToMillis;
		case 2:
			var n = v.a;
			return n * $author$project$Data$ValidityValue$hourToMillis;
		default:
			var n = v.a;
			return n * $author$project$Data$ValidityValue$dayToMillis;
	}
};
var $author$project$Data$ValidityValue$Hours = function (a) {
	return {$: 2, a: a};
};
var $author$project$Data$ValidityValue$Minutes = function (a) {
	return {$: 1, a: a};
};
var $author$project$Data$ValidityOptions$allValidityOptions = function (texts) {
	return _List_fromArray(
		[
			_Utils_Tuple2(
			'1/2 ' + texts.fp,
			$author$project$Data$ValidityValue$Minutes(30)),
			_Utils_Tuple2(
			'1 ' + texts.fp,
			$author$project$Data$ValidityValue$Hours(1)),
			_Utils_Tuple2(
			'2 ' + texts.cy,
			$author$project$Data$ValidityValue$Hours(2)),
			_Utils_Tuple2(
			'4 ' + texts.cy,
			$author$project$Data$ValidityValue$Hours(4)),
			_Utils_Tuple2(
			'8 ' + texts.cy,
			$author$project$Data$ValidityValue$Hours(8)),
			_Utils_Tuple2(
			'16 ' + texts.cy,
			$author$project$Data$ValidityValue$Hours(16)),
			_Utils_Tuple2(
			'1 ' + texts.g5,
			$author$project$Data$ValidityValue$Days(1)),
			_Utils_Tuple2(
			'2 ' + texts.e_,
			$author$project$Data$ValidityValue$Days(2)),
			_Utils_Tuple2(
			'4 ' + texts.e_,
			$author$project$Data$ValidityValue$Days(4)),
			_Utils_Tuple2(
			'1 ' + texts.iS,
			$author$project$Data$ValidityValue$Days(7)),
			_Utils_Tuple2(
			'2 ' + texts.iT,
			$author$project$Data$ValidityValue$Days(14)),
			_Utils_Tuple2(
			'1 ' + texts.hM,
			$author$project$Data$ValidityValue$Days(30)),
			_Utils_Tuple2(
			'2 ' + texts.cD,
			$author$project$Data$ValidityValue$Days(60)),
			_Utils_Tuple2(
			'4 ' + texts.cD,
			$author$project$Data$ValidityValue$Days(4 * 30)),
			_Utils_Tuple2(
			'8 ' + texts.cD,
			$author$project$Data$ValidityValue$Days(8 * 30)),
			_Utils_Tuple2(
			'12 ' + texts.cD,
			$author$project$Data$ValidityValue$Days(365))
		]);
};
var $author$project$Messages$FixedDropdown$cz = {ii: 'Vybrat…'};
var $author$project$Messages$YesNoDimmer$cz = {gZ: 'Ne', g2: 'Ano, prosím!', dU: 'Smazat trvale tuto položku?'};
var $author$project$Messages$AccountForm$cz = {cK: 'Admin', eP: 'Zpět', e0: 'Smazat', hc: $author$project$Messages$FixedDropdown$cz, c9: 'E-Mail', hs: 'Id', dK: 'Uživatelské jméno', d4: 'Heslo', ev: 'Status', gt: 'Odeslat', eK: $author$project$Messages$YesNoDimmer$cz};
var $elm$time$Time$flooredDiv = F2(
	function (numerator, denominator) {
		return $elm$core$Basics$floor(numerator / denominator);
	});
var $elm$core$Basics$modBy = _Basics_modBy;
var $elm$time$Time$posixToMillis = function (_v0) {
	var millis = _v0;
	return millis;
};
var $elm$time$Time$toAdjustedMinutesHelp = F3(
	function (defaultOffset, posixMinutes, eras) {
		toAdjustedMinutesHelp:
		while (true) {
			if (!eras.b) {
				return posixMinutes + defaultOffset;
			} else {
				var era = eras.a;
				var olderEras = eras.b;
				if (_Utils_cmp(era.it, posixMinutes) < 0) {
					return posixMinutes + era.fU;
				} else {
					var $temp$defaultOffset = defaultOffset,
						$temp$posixMinutes = posixMinutes,
						$temp$eras = olderEras;
					defaultOffset = $temp$defaultOffset;
					posixMinutes = $temp$posixMinutes;
					eras = $temp$eras;
					continue toAdjustedMinutesHelp;
				}
			}
		}
	});
var $elm$time$Time$toAdjustedMinutes = F2(
	function (_v0, time) {
		var defaultOffset = _v0.a;
		var eras = _v0.b;
		return A3(
			$elm$time$Time$toAdjustedMinutesHelp,
			defaultOffset,
			A2(
				$elm$time$Time$flooredDiv,
				$elm$time$Time$posixToMillis(time),
				60000),
			eras);
	});
var $elm$time$Time$toHour = F2(
	function (zone, time) {
		return A2(
			$elm$core$Basics$modBy,
			24,
			A2(
				$elm$time$Time$flooredDiv,
				A2($elm$time$Time$toAdjustedMinutes, zone, time),
				60));
	});
var $ryan_haskell$date_format$DateFormat$amPm = F3(
	function (language, zone, posix) {
		return language.iF(
			A2($elm$time$Time$toHour, zone, posix));
	});
var $elm$core$Basics$ge = _Utils_ge;
var $elm$core$Basics$negate = function (n) {
	return -n;
};
var $elm$time$Time$toCivil = function (minutes) {
	var rawDay = A2($elm$time$Time$flooredDiv, minutes, 60 * 24) + 719468;
	var era = (((rawDay >= 0) ? rawDay : (rawDay - 146096)) / 146097) | 0;
	var dayOfEra = rawDay - (era * 146097);
	var yearOfEra = ((((dayOfEra - ((dayOfEra / 1460) | 0)) + ((dayOfEra / 36524) | 0)) - ((dayOfEra / 146096) | 0)) / 365) | 0;
	var dayOfYear = dayOfEra - (((365 * yearOfEra) + ((yearOfEra / 4) | 0)) - ((yearOfEra / 100) | 0));
	var mp = (((5 * dayOfYear) + 2) / 153) | 0;
	var month = mp + ((mp < 10) ? 3 : (-9));
	var year = yearOfEra + (era * 400);
	return {
		g5: (dayOfYear - ((((153 * mp) + 2) / 5) | 0)) + 1,
		hM: month,
		gK: year + ((month <= 2) ? 1 : 0)
	};
};
var $elm$time$Time$toDay = F2(
	function (zone, time) {
		return $elm$time$Time$toCivil(
			A2($elm$time$Time$toAdjustedMinutes, zone, time)).g5;
	});
var $ryan_haskell$date_format$DateFormat$dayOfMonth = $elm$time$Time$toDay;
var $elm$time$Time$Sun = 6;
var $elm$time$Time$Fri = 4;
var $elm$time$Time$Mon = 0;
var $elm$time$Time$Sat = 5;
var $elm$time$Time$Thu = 3;
var $elm$time$Time$Tue = 1;
var $elm$time$Time$Wed = 2;
var $ryan_haskell$date_format$DateFormat$days = _List_fromArray(
	[6, 0, 1, 2, 3, 4, 5]);
var $elm$time$Time$toWeekday = F2(
	function (zone, time) {
		var _v0 = A2(
			$elm$core$Basics$modBy,
			7,
			A2(
				$elm$time$Time$flooredDiv,
				A2($elm$time$Time$toAdjustedMinutes, zone, time),
				60 * 24));
		switch (_v0) {
			case 0:
				return 3;
			case 1:
				return 4;
			case 2:
				return 5;
			case 3:
				return 6;
			case 4:
				return 0;
			case 5:
				return 1;
			default:
				return 2;
		}
	});
var $ryan_haskell$date_format$DateFormat$dayOfWeek = F2(
	function (zone, posix) {
		return function (_v1) {
			var i = _v1.a;
			return i;
		}(
			A2(
				$elm$core$Maybe$withDefault,
				_Utils_Tuple2(0, 6),
				$elm$core$List$head(
					A2(
						$elm$core$List$filter,
						function (_v0) {
							var day = _v0.b;
							return _Utils_eq(
								day,
								A2($elm$time$Time$toWeekday, zone, posix));
						},
						A2(
							$elm$core$List$indexedMap,
							F2(
								function (i, day) {
									return _Utils_Tuple2(i, day);
								}),
							$ryan_haskell$date_format$DateFormat$days)))));
	});
var $elm$core$Basics$neq = _Utils_notEqual;
var $ryan_haskell$date_format$DateFormat$isLeapYear = function (year_) {
	return (!(!A2($elm$core$Basics$modBy, 4, year_))) ? false : ((!(!A2($elm$core$Basics$modBy, 100, year_))) ? true : ((!(!A2($elm$core$Basics$modBy, 400, year_))) ? false : true));
};
var $ryan_haskell$date_format$DateFormat$daysInMonth = F2(
	function (year_, month) {
		switch (month) {
			case 0:
				return 31;
			case 1:
				return $ryan_haskell$date_format$DateFormat$isLeapYear(year_) ? 29 : 28;
			case 2:
				return 31;
			case 3:
				return 30;
			case 4:
				return 31;
			case 5:
				return 30;
			case 6:
				return 31;
			case 7:
				return 31;
			case 8:
				return 30;
			case 9:
				return 31;
			case 10:
				return 30;
			default:
				return 31;
		}
	});
var $elm$time$Time$Jan = 0;
var $elm$time$Time$Apr = 3;
var $elm$time$Time$Aug = 7;
var $elm$time$Time$Dec = 11;
var $elm$time$Time$Feb = 1;
var $elm$time$Time$Jul = 6;
var $elm$time$Time$Jun = 5;
var $elm$time$Time$Mar = 2;
var $elm$time$Time$May = 4;
var $elm$time$Time$Nov = 10;
var $elm$time$Time$Oct = 9;
var $elm$time$Time$Sep = 8;
var $ryan_haskell$date_format$DateFormat$months = _List_fromArray(
	[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]);
var $elm$time$Time$toMonth = F2(
	function (zone, time) {
		var _v0 = $elm$time$Time$toCivil(
			A2($elm$time$Time$toAdjustedMinutes, zone, time)).hM;
		switch (_v0) {
			case 1:
				return 0;
			case 2:
				return 1;
			case 3:
				return 2;
			case 4:
				return 3;
			case 5:
				return 4;
			case 6:
				return 5;
			case 7:
				return 6;
			case 8:
				return 7;
			case 9:
				return 8;
			case 10:
				return 9;
			case 11:
				return 10;
			default:
				return 11;
		}
	});
var $ryan_haskell$date_format$DateFormat$monthPair = F2(
	function (zone, posix) {
		return A2(
			$elm$core$Maybe$withDefault,
			_Utils_Tuple2(0, 0),
			$elm$core$List$head(
				A2(
					$elm$core$List$filter,
					function (_v0) {
						var i = _v0.a;
						var m = _v0.b;
						return _Utils_eq(
							m,
							A2($elm$time$Time$toMonth, zone, posix));
					},
					A2(
						$elm$core$List$indexedMap,
						F2(
							function (a, b) {
								return _Utils_Tuple2(a, b);
							}),
						$ryan_haskell$date_format$DateFormat$months))));
	});
var $ryan_haskell$date_format$DateFormat$monthNumber_ = F2(
	function (zone, posix) {
		return 1 + function (_v0) {
			var i = _v0.a;
			var m = _v0.b;
			return i;
		}(
			A2($ryan_haskell$date_format$DateFormat$monthPair, zone, posix));
	});
var $elm$core$List$sum = function (numbers) {
	return A3($elm$core$List$foldl, $elm$core$Basics$add, 0, numbers);
};
var $elm$core$List$takeReverse = F3(
	function (n, list, kept) {
		takeReverse:
		while (true) {
			if (n <= 0) {
				return kept;
			} else {
				if (!list.b) {
					return kept;
				} else {
					var x = list.a;
					var xs = list.b;
					var $temp$n = n - 1,
						$temp$list = xs,
						$temp$kept = A2($elm$core$List$cons, x, kept);
					n = $temp$n;
					list = $temp$list;
					kept = $temp$kept;
					continue takeReverse;
				}
			}
		}
	});
var $elm$core$List$takeTailRec = F2(
	function (n, list) {
		return $elm$core$List$reverse(
			A3($elm$core$List$takeReverse, n, list, _List_Nil));
	});
var $elm$core$List$takeFast = F3(
	function (ctr, n, list) {
		if (n <= 0) {
			return _List_Nil;
		} else {
			var _v0 = _Utils_Tuple2(n, list);
			_v0$1:
			while (true) {
				_v0$5:
				while (true) {
					if (!_v0.b.b) {
						return list;
					} else {
						if (_v0.b.b.b) {
							switch (_v0.a) {
								case 1:
									break _v0$1;
								case 2:
									var _v2 = _v0.b;
									var x = _v2.a;
									var _v3 = _v2.b;
									var y = _v3.a;
									return _List_fromArray(
										[x, y]);
								case 3:
									if (_v0.b.b.b.b) {
										var _v4 = _v0.b;
										var x = _v4.a;
										var _v5 = _v4.b;
										var y = _v5.a;
										var _v6 = _v5.b;
										var z = _v6.a;
										return _List_fromArray(
											[x, y, z]);
									} else {
										break _v0$5;
									}
								default:
									if (_v0.b.b.b.b && _v0.b.b.b.b.b) {
										var _v7 = _v0.b;
										var x = _v7.a;
										var _v8 = _v7.b;
										var y = _v8.a;
										var _v9 = _v8.b;
										var z = _v9.a;
										var _v10 = _v9.b;
										var w = _v10.a;
										var tl = _v10.b;
										return (ctr > 1000) ? A2(
											$elm$core$List$cons,
											x,
											A2(
												$elm$core$List$cons,
												y,
												A2(
													$elm$core$List$cons,
													z,
													A2(
														$elm$core$List$cons,
														w,
														A2($elm$core$List$takeTailRec, n - 4, tl))))) : A2(
											$elm$core$List$cons,
											x,
											A2(
												$elm$core$List$cons,
												y,
												A2(
													$elm$core$List$cons,
													z,
													A2(
														$elm$core$List$cons,
														w,
														A3($elm$core$List$takeFast, ctr + 1, n - 4, tl)))));
									} else {
										break _v0$5;
									}
							}
						} else {
							if (_v0.a === 1) {
								break _v0$1;
							} else {
								break _v0$5;
							}
						}
					}
				}
				return list;
			}
			var _v1 = _v0.b;
			var x = _v1.a;
			return _List_fromArray(
				[x]);
		}
	});
var $elm$core$List$take = F2(
	function (n, list) {
		return A3($elm$core$List$takeFast, 0, n, list);
	});
var $elm$time$Time$toYear = F2(
	function (zone, time) {
		return $elm$time$Time$toCivil(
			A2($elm$time$Time$toAdjustedMinutes, zone, time)).gK;
	});
var $ryan_haskell$date_format$DateFormat$dayOfYear = F2(
	function (zone, posix) {
		var monthsBeforeThisOne = A2(
			$elm$core$List$take,
			A2($ryan_haskell$date_format$DateFormat$monthNumber_, zone, posix) - 1,
			$ryan_haskell$date_format$DateFormat$months);
		var daysBeforeThisMonth = $elm$core$List$sum(
			A2(
				$elm$core$List$map,
				$ryan_haskell$date_format$DateFormat$daysInMonth(
					A2($elm$time$Time$toYear, zone, posix)),
				monthsBeforeThisOne));
		return daysBeforeThisMonth + A2($ryan_haskell$date_format$DateFormat$dayOfMonth, zone, posix);
	});
var $ryan_haskell$date_format$DateFormat$quarter = F2(
	function (zone, posix) {
		return (A2($ryan_haskell$date_format$DateFormat$monthNumber_, zone, posix) / 4) | 0;
	});
var $elm$core$String$right = F2(
	function (n, string) {
		return (n < 1) ? '' : A3(
			$elm$core$String$slice,
			-n,
			$elm$core$String$length(string),
			string);
	});
var $ryan_haskell$date_format$DateFormat$toFixedLength = F2(
	function (totalChars, num) {
		var numStr = $elm$core$String$fromInt(num);
		var numZerosNeeded = totalChars - $elm$core$String$length(numStr);
		var zeros = A2(
			$elm$core$String$join,
			'',
			A2(
				$elm$core$List$map,
				function (_v0) {
					return '0';
				},
				A2($elm$core$List$range, 1, numZerosNeeded)));
		return _Utils_ap(zeros, numStr);
	});
var $elm$core$String$toLower = _String_toLower;
var $elm$time$Time$toMillis = F2(
	function (_v0, time) {
		return A2(
			$elm$core$Basics$modBy,
			1000,
			$elm$time$Time$posixToMillis(time));
	});
var $elm$time$Time$toMinute = F2(
	function (zone, time) {
		return A2(
			$elm$core$Basics$modBy,
			60,
			A2($elm$time$Time$toAdjustedMinutes, zone, time));
	});
var $ryan_haskell$date_format$DateFormat$toNonMilitary = function (num) {
	return (!num) ? 12 : ((num <= 12) ? num : (num - 12));
};
var $elm$time$Time$toSecond = F2(
	function (_v0, time) {
		return A2(
			$elm$core$Basics$modBy,
			60,
			A2(
				$elm$time$Time$flooredDiv,
				$elm$time$Time$posixToMillis(time),
				1000));
	});
var $elm$core$String$toUpper = _String_toUpper;
var $elm$time$Time$Posix = $elm$core$Basics$identity;
var $elm$time$Time$millisToPosix = $elm$core$Basics$identity;
var $elm$core$Basics$round = _Basics_round;
var $ryan_haskell$date_format$DateFormat$millisecondsPerYear = $elm$core$Basics$round((((1000 * 60) * 60) * 24) * 365.25);
var $ryan_haskell$date_format$DateFormat$firstDayOfYear = F2(
	function (zone, time) {
		return $elm$time$Time$millisToPosix(
			$ryan_haskell$date_format$DateFormat$millisecondsPerYear * A2($elm$time$Time$toYear, zone, time));
	});
var $ryan_haskell$date_format$DateFormat$weekOfYear = F2(
	function (zone, posix) {
		var firstDay = A2($ryan_haskell$date_format$DateFormat$firstDayOfYear, zone, posix);
		var firstDayOffset = A2($ryan_haskell$date_format$DateFormat$dayOfWeek, zone, firstDay);
		var daysSoFar = A2($ryan_haskell$date_format$DateFormat$dayOfYear, zone, posix);
		return (((daysSoFar + firstDayOffset) / 7) | 0) + 1;
	});
var $ryan_haskell$date_format$DateFormat$year = F2(
	function (zone, time) {
		return $elm$core$String$fromInt(
			A2($elm$time$Time$toYear, zone, time));
	});
var $ryan_haskell$date_format$DateFormat$piece = F4(
	function (language, zone, posix, token) {
		switch (token.$) {
			case 0:
				return $elm$core$String$fromInt(
					A2($ryan_haskell$date_format$DateFormat$monthNumber_, zone, posix));
			case 1:
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.b2(num));
				}(
					A2($ryan_haskell$date_format$DateFormat$monthNumber_, zone, posix));
			case 2:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					A2($ryan_haskell$date_format$DateFormat$monthNumber_, zone, posix));
			case 3:
				return language.iG(
					A2($elm$time$Time$toMonth, zone, posix));
			case 4:
				return language.iH(
					A2($elm$time$Time$toMonth, zone, posix));
			case 17:
				return $elm$core$String$fromInt(
					1 + A2($ryan_haskell$date_format$DateFormat$quarter, zone, posix));
			case 18:
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.b2(num));
				}(
					1 + A2($ryan_haskell$date_format$DateFormat$quarter, zone, posix));
			case 5:
				return $elm$core$String$fromInt(
					A2($ryan_haskell$date_format$DateFormat$dayOfMonth, zone, posix));
			case 6:
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.b2(num));
				}(
					A2($ryan_haskell$date_format$DateFormat$dayOfMonth, zone, posix));
			case 7:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					A2($ryan_haskell$date_format$DateFormat$dayOfMonth, zone, posix));
			case 8:
				return $elm$core$String$fromInt(
					A2($ryan_haskell$date_format$DateFormat$dayOfYear, zone, posix));
			case 9:
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.b2(num));
				}(
					A2($ryan_haskell$date_format$DateFormat$dayOfYear, zone, posix));
			case 10:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					3,
					A2($ryan_haskell$date_format$DateFormat$dayOfYear, zone, posix));
			case 11:
				return $elm$core$String$fromInt(
					A2($ryan_haskell$date_format$DateFormat$dayOfWeek, zone, posix));
			case 12:
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.b2(num));
				}(
					A2($ryan_haskell$date_format$DateFormat$dayOfWeek, zone, posix));
			case 13:
				return language.iI(
					A2($elm$time$Time$toWeekday, zone, posix));
			case 14:
				return language.iJ(
					A2($elm$time$Time$toWeekday, zone, posix));
			case 19:
				return $elm$core$String$fromInt(
					A2($ryan_haskell$date_format$DateFormat$weekOfYear, zone, posix));
			case 20:
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.b2(num));
				}(
					A2($ryan_haskell$date_format$DateFormat$weekOfYear, zone, posix));
			case 21:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					A2($ryan_haskell$date_format$DateFormat$weekOfYear, zone, posix));
			case 15:
				return A2(
					$elm$core$String$right,
					2,
					A2($ryan_haskell$date_format$DateFormat$year, zone, posix));
			case 16:
				return A2($ryan_haskell$date_format$DateFormat$year, zone, posix);
			case 22:
				return $elm$core$String$toUpper(
					A3($ryan_haskell$date_format$DateFormat$amPm, language, zone, posix));
			case 23:
				return $elm$core$String$toLower(
					A3($ryan_haskell$date_format$DateFormat$amPm, language, zone, posix));
			case 24:
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toHour, zone, posix));
			case 25:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					A2($elm$time$Time$toHour, zone, posix));
			case 26:
				return $elm$core$String$fromInt(
					$ryan_haskell$date_format$DateFormat$toNonMilitary(
						A2($elm$time$Time$toHour, zone, posix)));
			case 27:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					$ryan_haskell$date_format$DateFormat$toNonMilitary(
						A2($elm$time$Time$toHour, zone, posix)));
			case 28:
				return $elm$core$String$fromInt(
					1 + A2($elm$time$Time$toHour, zone, posix));
			case 29:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					1 + A2($elm$time$Time$toHour, zone, posix));
			case 30:
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toMinute, zone, posix));
			case 31:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					A2($elm$time$Time$toMinute, zone, posix));
			case 32:
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toSecond, zone, posix));
			case 33:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					2,
					A2($elm$time$Time$toSecond, zone, posix));
			case 34:
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toMillis, zone, posix));
			case 35:
				return A2(
					$ryan_haskell$date_format$DateFormat$toFixedLength,
					3,
					A2($elm$time$Time$toMillis, zone, posix));
			default:
				var string = token.a;
				return string;
		}
	});
var $ryan_haskell$date_format$DateFormat$formatWithLanguage = F4(
	function (language, tokens, zone, time) {
		return A2(
			$elm$core$String$join,
			'',
			A2(
				$elm$core$List$map,
				A3($ryan_haskell$date_format$DateFormat$piece, language, zone, time),
				tokens));
	});
var $ryan_haskell$date_format$DateFormat$Language$Language = F6(
	function (toMonthName, toMonthAbbreviation, toWeekdayName, toWeekdayAbbreviation, toAmPm, toOrdinalSuffix) {
		return {iF: toAmPm, iG: toMonthAbbreviation, iH: toMonthName, b2: toOrdinalSuffix, iI: toWeekdayAbbreviation, iJ: toWeekdayName};
	});
var $elm$core$Basics$composeR = F3(
	function (f, g, x) {
		return g(
			f(x));
	});
var $author$project$Messages$DateFormat$toCzechMonthName = function (month) {
	switch (month) {
		case 0:
			return 'Leden';
		case 1:
			return 'Únor';
		case 2:
			return 'Březen';
		case 3:
			return 'Duben';
		case 4:
			return 'Květen';
		case 5:
			return 'Červen';
		case 6:
			return 'Červenec';
		case 7:
			return 'Srpen';
		case 8:
			return 'Září';
		case 9:
			return 'Říjen';
		case 10:
			return 'Listopad';
		default:
			return 'Prosinec';
	}
};
var $author$project$Messages$DateFormat$toCzechWeekdayName = function (weekday) {
	switch (weekday) {
		case 0:
			return 'Pondělí';
		case 1:
			return 'Úterý';
		case 2:
			return 'Středa';
		case 3:
			return 'Čtvrtek';
		case 4:
			return 'Pátek';
		case 5:
			return 'Sobota';
		default:
			return 'Neděle';
	}
};
var $author$project$Messages$DateFormat$toEnglishAmPm = function (hour) {
	return (hour > 11) ? 'pm' : 'am';
};
var $author$project$Messages$DateFormat$czech = function () {
	var withDot = function (str) {
		return str + '.';
	};
	return A6(
		$ryan_haskell$date_format$DateFormat$Language$Language,
		$author$project$Messages$DateFormat$toCzechMonthName,
		A2(
			$elm$core$Basics$composeR,
			$author$project$Messages$DateFormat$toCzechMonthName,
			A2(
				$elm$core$Basics$composeR,
				$elm$core$String$left(3),
				withDot)),
		$author$project$Messages$DateFormat$toCzechWeekdayName,
		A2(
			$elm$core$Basics$composeR,
			$author$project$Messages$DateFormat$toCzechWeekdayName,
			A2(
				$elm$core$Basics$composeR,
				$elm$core$String$left(2),
				withDot)),
		$author$project$Messages$DateFormat$toEnglishAmPm,
		function (_v0) {
			return '.';
		});
}();
var $ryan_haskell$date_format$DateFormat$DayOfMonthSuffix = {$: 6};
var $ryan_haskell$date_format$DateFormat$dayOfMonthSuffix = $ryan_haskell$date_format$DateFormat$DayOfMonthSuffix;
var $ryan_haskell$date_format$DateFormat$DayOfWeekNameAbbreviated = {$: 13};
var $ryan_haskell$date_format$DateFormat$dayOfWeekNameAbbreviated = $ryan_haskell$date_format$DateFormat$DayOfWeekNameAbbreviated;
var $ryan_haskell$date_format$DateFormat$HourMilitaryNumber = {$: 24};
var $ryan_haskell$date_format$DateFormat$hourMilitaryNumber = $ryan_haskell$date_format$DateFormat$HourMilitaryNumber;
var $ryan_haskell$date_format$DateFormat$MinuteFixed = {$: 31};
var $ryan_haskell$date_format$DateFormat$minuteFixed = $ryan_haskell$date_format$DateFormat$MinuteFixed;
var $ryan_haskell$date_format$DateFormat$MonthNameFull = {$: 4};
var $ryan_haskell$date_format$DateFormat$monthNameFull = $ryan_haskell$date_format$DateFormat$MonthNameFull;
var $ryan_haskell$date_format$DateFormat$Text = function (a) {
	return {$: 36, a: a};
};
var $ryan_haskell$date_format$DateFormat$text = $ryan_haskell$date_format$DateFormat$Text;
var $ryan_haskell$date_format$DateFormat$YearNumber = {$: 16};
var $ryan_haskell$date_format$DateFormat$yearNumber = $ryan_haskell$date_format$DateFormat$YearNumber;
var $author$project$Messages$DateFormat$cz = {
	ai: _List_fromArray(
		[
			$ryan_haskell$date_format$DateFormat$dayOfWeekNameAbbreviated,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$dayOfMonthSuffix,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$monthNameFull,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$yearNumber,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$hourMilitaryNumber,
			$ryan_haskell$date_format$DateFormat$text(':'),
			$ryan_haskell$date_format$DateFormat$minuteFixed
		]),
	hA: $author$project$Messages$DateFormat$czech
};
var $author$project$Messages$DateFormat$toGermanMonthName = function (month) {
	switch (month) {
		case 0:
			return 'Januar';
		case 1:
			return 'Februar';
		case 2:
			return 'März';
		case 3:
			return 'April';
		case 4:
			return 'Mai';
		case 5:
			return 'Juni';
		case 6:
			return 'Juli';
		case 7:
			return 'August';
		case 8:
			return 'September';
		case 9:
			return 'Oktober';
		case 10:
			return 'November';
		default:
			return 'Dezember';
	}
};
var $author$project$Messages$DateFormat$toGermanWeekdayName = function (weekday) {
	switch (weekday) {
		case 0:
			return 'Montag';
		case 1:
			return 'Dienstag';
		case 2:
			return 'Mittwoch';
		case 3:
			return 'Donnerstag';
		case 4:
			return 'Freitag';
		case 5:
			return 'Samstag';
		default:
			return 'Sonntag';
	}
};
var $author$project$Messages$DateFormat$german = function () {
	var withDot = function (str) {
		return str + '.';
	};
	return A6(
		$ryan_haskell$date_format$DateFormat$Language$Language,
		$author$project$Messages$DateFormat$toGermanMonthName,
		A2(
			$elm$core$Basics$composeR,
			$author$project$Messages$DateFormat$toGermanMonthName,
			A2(
				$elm$core$Basics$composeR,
				$elm$core$String$left(3),
				withDot)),
		$author$project$Messages$DateFormat$toGermanWeekdayName,
		A2(
			$elm$core$Basics$composeR,
			$author$project$Messages$DateFormat$toGermanWeekdayName,
			A2(
				$elm$core$Basics$composeR,
				$elm$core$String$left(2),
				withDot)),
		$author$project$Messages$DateFormat$toEnglishAmPm,
		function (_v0) {
			return '.';
		});
}();
var $author$project$Messages$DateFormat$de = {
	ai: _List_fromArray(
		[
			$ryan_haskell$date_format$DateFormat$dayOfWeekNameAbbreviated,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$dayOfMonthSuffix,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$monthNameFull,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$yearNumber,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$hourMilitaryNumber,
			$ryan_haskell$date_format$DateFormat$text(':'),
			$ryan_haskell$date_format$DateFormat$minuteFixed
		]),
	hA: $author$project$Messages$DateFormat$german
};
var $author$project$Messages$DateFormat$toFrenchMonthAbbreviation = function (month) {
	switch (month) {
		case 0:
			return 'janv';
		case 1:
			return 'févr';
		case 2:
			return 'mars';
		case 3:
			return 'avr';
		case 4:
			return 'mai';
		case 5:
			return 'juin';
		case 6:
			return 'juil';
		case 7:
			return 'août';
		case 8:
			return 'sept';
		case 9:
			return 'oct';
		case 10:
			return 'nov';
		default:
			return 'déc';
	}
};
var $author$project$Messages$DateFormat$toFrenchMonthName = function (month) {
	switch (month) {
		case 0:
			return 'janvier';
		case 1:
			return 'février';
		case 2:
			return 'mars';
		case 3:
			return 'avril';
		case 4:
			return 'mai';
		case 5:
			return 'juin';
		case 6:
			return 'juillet';
		case 7:
			return 'août';
		case 8:
			return 'septembre';
		case 9:
			return 'octobre';
		case 10:
			return 'novembre';
		default:
			return 'décembre';
	}
};
var $author$project$Messages$DateFormat$toFrenchOrdinalSuffix = function (n) {
	return (n === 1) ? 'er' : '';
};
var $author$project$Messages$DateFormat$toFrenchWeekdayName = function (weekday) {
	switch (weekday) {
		case 0:
			return 'lundi';
		case 1:
			return 'mardi';
		case 2:
			return 'mercredi';
		case 3:
			return 'jeudi';
		case 4:
			return 'vendredi';
		case 5:
			return 'samedi';
		default:
			return 'dimanche';
	}
};
var $author$project$Messages$DateFormat$french = A6(
	$ryan_haskell$date_format$DateFormat$Language$Language,
	$author$project$Messages$DateFormat$toFrenchMonthName,
	$author$project$Messages$DateFormat$toFrenchMonthAbbreviation,
	$author$project$Messages$DateFormat$toFrenchWeekdayName,
	A2(
		$elm$core$Basics$composeR,
		$author$project$Messages$DateFormat$toFrenchWeekdayName,
		$elm$core$String$left(3)),
	$author$project$Messages$DateFormat$toEnglishAmPm,
	$author$project$Messages$DateFormat$toFrenchOrdinalSuffix);
var $author$project$Messages$DateFormat$fr = {
	ai: _List_fromArray(
		[
			$ryan_haskell$date_format$DateFormat$dayOfWeekNameAbbreviated,
			$ryan_haskell$date_format$DateFormat$text('. '),
			$ryan_haskell$date_format$DateFormat$dayOfMonthSuffix,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$monthNameFull,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$yearNumber,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$hourMilitaryNumber,
			$ryan_haskell$date_format$DateFormat$text(':'),
			$ryan_haskell$date_format$DateFormat$minuteFixed
		]),
	hA: $author$project$Messages$DateFormat$french
};
var $ryan_haskell$date_format$DateFormat$Language$toEnglishAmPm = function (hour) {
	return (hour > 11) ? 'pm' : 'am';
};
var $ryan_haskell$date_format$DateFormat$Language$toEnglishMonthName = function (month) {
	switch (month) {
		case 0:
			return 'January';
		case 1:
			return 'February';
		case 2:
			return 'March';
		case 3:
			return 'April';
		case 4:
			return 'May';
		case 5:
			return 'June';
		case 6:
			return 'July';
		case 7:
			return 'August';
		case 8:
			return 'September';
		case 9:
			return 'October';
		case 10:
			return 'November';
		default:
			return 'December';
	}
};
var $ryan_haskell$date_format$DateFormat$Language$toEnglishSuffix = function (num) {
	var _v0 = A2($elm$core$Basics$modBy, 100, num);
	switch (_v0) {
		case 11:
			return 'th';
		case 12:
			return 'th';
		case 13:
			return 'th';
		default:
			var _v1 = A2($elm$core$Basics$modBy, 10, num);
			switch (_v1) {
				case 1:
					return 'st';
				case 2:
					return 'nd';
				case 3:
					return 'rd';
				default:
					return 'th';
			}
	}
};
var $ryan_haskell$date_format$DateFormat$Language$toEnglishWeekdayName = function (weekday) {
	switch (weekday) {
		case 0:
			return 'Monday';
		case 1:
			return 'Tuesday';
		case 2:
			return 'Wednesday';
		case 3:
			return 'Thursday';
		case 4:
			return 'Friday';
		case 5:
			return 'Saturday';
		default:
			return 'Sunday';
	}
};
var $ryan_haskell$date_format$DateFormat$Language$english = A6(
	$ryan_haskell$date_format$DateFormat$Language$Language,
	$ryan_haskell$date_format$DateFormat$Language$toEnglishMonthName,
	A2(
		$elm$core$Basics$composeR,
		$ryan_haskell$date_format$DateFormat$Language$toEnglishMonthName,
		$elm$core$String$left(3)),
	$ryan_haskell$date_format$DateFormat$Language$toEnglishWeekdayName,
	A2(
		$elm$core$Basics$composeR,
		$ryan_haskell$date_format$DateFormat$Language$toEnglishWeekdayName,
		$elm$core$String$left(3)),
	$ryan_haskell$date_format$DateFormat$Language$toEnglishAmPm,
	$ryan_haskell$date_format$DateFormat$Language$toEnglishSuffix);
var $author$project$Messages$DateFormat$gb = {
	ai: _List_fromArray(
		[
			$ryan_haskell$date_format$DateFormat$dayOfWeekNameAbbreviated,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$monthNameFull,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$dayOfMonthSuffix,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$yearNumber,
			$ryan_haskell$date_format$DateFormat$text(', '),
			$ryan_haskell$date_format$DateFormat$hourMilitaryNumber,
			$ryan_haskell$date_format$DateFormat$text(':'),
			$ryan_haskell$date_format$DateFormat$minuteFixed
		]),
	hA: $ryan_haskell$date_format$DateFormat$Language$english
};
var $ryan_haskell$date_format$DateFormat$DayOfMonthNumber = {$: 5};
var $ryan_haskell$date_format$DateFormat$dayOfMonthNumber = $ryan_haskell$date_format$DateFormat$DayOfMonthNumber;
var $author$project$Messages$DateFormat$toJapaneseMonthName = function (month) {
	switch (month) {
		case 0:
			return '1月';
		case 1:
			return '2月';
		case 2:
			return '3月';
		case 3:
			return '4月';
		case 4:
			return '5月';
		case 5:
			return '6月';
		case 6:
			return '7月';
		case 7:
			return '8月';
		case 8:
			return '9月';
		case 9:
			return '10月';
		case 10:
			return '11月';
		default:
			return '12月';
	}
};
var $author$project$Messages$DateFormat$toJapaneseWeekdayName = function (weekday) {
	switch (weekday) {
		case 0:
			return '(月)';
		case 1:
			return '(火)';
		case 2:
			return '(水)';
		case 3:
			return '(木)';
		case 4:
			return '(金)';
		case 5:
			return '(土)';
		default:
			return '(日)';
	}
};
var $author$project$Messages$DateFormat$japanese = function () {
	var withoutDot = function (str) {
		return str + '';
	};
	return A6(
		$ryan_haskell$date_format$DateFormat$Language$Language,
		$author$project$Messages$DateFormat$toJapaneseMonthName,
		A2(
			$elm$core$Basics$composeR,
			$author$project$Messages$DateFormat$toJapaneseMonthName,
			A2(
				$elm$core$Basics$composeR,
				$elm$core$String$left(3),
				withoutDot)),
		$author$project$Messages$DateFormat$toJapaneseWeekdayName,
		A2(
			$elm$core$Basics$composeR,
			$author$project$Messages$DateFormat$toJapaneseWeekdayName,
			A2(
				$elm$core$Basics$composeR,
				$elm$core$String$left(3),
				withoutDot)),
		$author$project$Messages$DateFormat$toEnglishAmPm,
		function (_v0) {
			return '.';
		});
}();
var $author$project$Messages$DateFormat$ja = {
	ai: _List_fromArray(
		[
			$ryan_haskell$date_format$DateFormat$yearNumber,
			$ryan_haskell$date_format$DateFormat$text('年 '),
			$ryan_haskell$date_format$DateFormat$monthNameFull,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$dayOfMonthNumber,
			$ryan_haskell$date_format$DateFormat$text('日'),
			$ryan_haskell$date_format$DateFormat$dayOfWeekNameAbbreviated,
			$ryan_haskell$date_format$DateFormat$text(' '),
			$ryan_haskell$date_format$DateFormat$hourMilitaryNumber,
			$ryan_haskell$date_format$DateFormat$text(':'),
			$ryan_haskell$date_format$DateFormat$minuteFixed
		]),
	hA: $author$project$Messages$DateFormat$japanese
};
var $author$project$Messages$DateFormat$get = function (lang) {
	switch (lang) {
		case 0:
			return $author$project$Messages$DateFormat$gb;
		case 1:
			return $author$project$Messages$DateFormat$de;
		case 2:
			return $author$project$Messages$DateFormat$fr;
		case 3:
			return $author$project$Messages$DateFormat$ja;
		default:
			return $author$project$Messages$DateFormat$cz;
	}
};
var $elm$time$Time$Zone = F2(
	function (a, b) {
		return {$: 0, a: a, b: b};
	});
var $elm$time$Time$utc = A2($elm$time$Time$Zone, 0, _List_Nil);
var $author$project$Messages$DateFormat$formatDateTime = F2(
	function (lang, millis) {
		var msg = $author$project$Messages$DateFormat$get(lang);
		var fmt = A2($ryan_haskell$date_format$DateFormat$formatWithLanguage, msg.hA, msg.ai);
		return A2(
			fmt,
			$elm$time$Time$utc,
			$elm$time$Time$millisToPosix(millis));
	});
var $author$project$Messages$AccountTable$cz = {
	cK: 'Admin',
	c0: 'Založeno',
	eZ: $author$project$Messages$DateFormat$formatDateTime(4),
	he: 'Editovat',
	dJ: 'Poslední přihlášení',
	dK: 'Uživatelské jméno',
	hX: '#Přihlášení',
	hY: '#Sdílení',
	eu: 'Zdroj',
	ev: 'Stav'
};
var $author$project$Messages$AccountPage$cz = {au: $author$project$Messages$AccountForm$cz, av: $author$project$Messages$AccountTable$cz, gN: 'Účty', aL: 'Vytvořit interní účet', be: 'Nový účet', ih: 'Hledat…'};
var $author$project$Messages$ValidityField$cz = {g5: 'den', e_: 'dní', hc: $author$project$Messages$FixedDropdown$cz, fp: 'hodina', cy: 'hodiny', hM: 'měsíc', cD: 'měsíců', iS: 'týden', iT: 'týdnů'};
var $elm$html$Html$em = _VirtualDom_node('em');
var $elm$html$Html$p = _VirtualDom_node('p');
var $elm$virtual_dom$VirtualDom$text = _VirtualDom_text;
var $elm$html$Html$text = $elm$virtual_dom$VirtualDom$text;
var $author$project$Messages$AliasForm$cz = {
	eP: 'Zpět',
	e0: 'Smazat',
	da: 'Povoleno',
	hs: 'ID',
	hK: 'Členové tohoto prostoru jej mohou zobrazit a sdílet. Dále uvidí všechny soubory, které byly do tohoto prostoru nahrány.',
	dT: 'Členové',
	dX: 'Název',
	hV: A2(
		$elm$html$Html$p,
		_List_Nil,
		_List_fromArray(
			[
				$elm$html$Html$text('Toto ID je součástí URL adresy, na které mohou '),
				A2(
				$elm$html$Html$em,
				_List_Nil,
				_List_fromArray(
					[
						$elm$html$Html$text('všichni')
					])),
				$elm$html$Html$text(' uživatelé nahrát soubory. Je doporučeno použít'),
				$elm$html$Html$text(' automatiky generované ID. Může být změněno na '),
				$elm$html$Html$text('jakoukoliv hodnotu, ale nesmí být prázdné. ')
			])),
	hW: 'Poznámka k ID',
	ih: 'Hledat…',
	gt: 'Odeslat',
	eF: 'Platnost',
	ad: $author$project$Messages$ValidityField$cz,
	eK: $author$project$Messages$YesNoDimmer$cz
};
var $author$project$Messages$AliasTable$cz = {
	c0: 'Vytvořen',
	eZ: $author$project$Messages$DateFormat$formatDateTime(4),
	he: 'Upravit',
	da: 'Povoleno',
	dX: 'Jméno',
	d3: 'Vlastník',
	ir: 'Zobrazit',
	eF: 'Platnost',
	ad: $author$project$Messages$ValidityField$cz
};
var $author$project$Messages$MailForm$cz = {g: 'Tělo', cV: 'Storno', h9: 'Příjemce(i)', im: 'Odeslat', ip: 'Více příjemců oddělte čárkou', ey: 'Předmět'};
var $author$project$Messages$MailSend$cz = {hD: 'Nahrát šablonu ...', X: $author$project$Messages$MailForm$cz, $9: 'Odeslat mail ...'};
var $author$project$Messages$AliasPage$cz = {ax: $author$project$Messages$AliasForm$cz, gS: 'Prostor pro sdílení: ', ay: 'Tento prostor pro sdílení je nyní dostupný na webové adrese: ', az: 'Prostory pro sdílení', aA: $author$project$Messages$AliasTable$cz, aK: ' Kopírovat odkaz', aN: 'Vytvořit prostor pro sdílení', aZ: 'Chyba při načítání QR kódu.', ba: $author$project$Messages$MailSend$cz, bf: 'Nový prostor pro sdílení', bm: 'Tento prostor je sdílen jiným uživatelem a sdílený Vámi. Nemůžete měnit jeho vlastnosti.', d3: 'Vlastník', ih: 'Vyhledat…', bF: 'Odeslat E-Mail', bT: 'Sdílet tento odkaz', bU: 'Tuto URL nebo QR kód níže můžete sdílet s ostatními.'};
var $author$project$Messages$App$cz = {
	gN: 'Účty',
	gT: 'Prostory pro sdílení',
	fm: 'Domů',
	hC: 'Světlý/Tmavý režim',
	dK: 'Přihlášení',
	hE: function (user) {
		return 'Odhlásit (' + (user + ')');
	},
	hF: 'Odhlásit u poskytovatele ověření',
	hG: 'Odhlásit',
	hT: 'Pozvánky',
	ia: 'Registrace',
	gk: 'Nastavení',
	el: 'Sdílené soubory'
};
var $author$project$Messages$Dropzone2$cz = {hb: 'Sem přetáhněte soubory', hl: ' vybrané soubory (', h2: 'nebo', ij: 'vyberte soubory ...'};
var $author$project$Messages$MarkdownInput$cz = {he: 'Editovat', f6: 'Náhled', gs: 'Rozdělit', iB: 'Podporuje Markdown'};
var $author$project$Messages$ShareFileList$cz = {e1: 'Smazat soubor.', c7: 'Stáhnout na disk', hj: 'Soubor nebyl nahrán celý (', h6: 'Náhled není podporován', iL: '%). Nahrajte jej prosím znovu.', gE: 'Zobrazit v prohlížeči', eK: $author$project$Messages$YesNoDimmer$cz};
var $author$project$Messages$DetailPage$cz = {
	aw: 'Přidat soubory',
	gR: 'Prostor',
	cV: 'Zrušit',
	aF: 'Zobrazené karet',
	aI: 'Smazat formulář',
	aK: 'Kopírovat odkaz',
	c0: 'Vytvořeno',
	eZ: $author$project$Messages$DateFormat$formatDateTime(4),
	e0: 'Smazat',
	aT: 'Detaily',
	aV: $author$project$Messages$Dropzone2$cz,
	he: 'Editovat',
	aW: 'Upravit popis',
	aZ: 'Chyba při generování QR kódu.',
	a1: 'Výchozí zobrazení: ',
	a2: function (iv) {
		switch (iv) {
			case 0:
				return 'Seznam';
			case 1:
				return 'Karty';
			default:
				return 'Náhled';
		}
	},
	dI: 'Poslední přístup',
	a5: 'Zobrazení seznamu',
	a6: 'Nahrávám soubory...',
	ba: $author$project$Messages$MailSend$cz,
	bb: $author$project$Messages$MarkdownInput$cz,
	dS: 'Max. počet zobrazení',
	dX: 'Název',
	h2: 'Nebo',
	d4: 'Heslo',
	bo: 'Chybějící heslo',
	bp: 'Žádné',
	br: 'Chráněno heslem',
	bt: 'Heslo vyžadováno',
	bu: 'Pozastavit',
	bv: 'Publikovat',
	bw: 'Zveřejnit s novým odkazem',
	bx: 'Zveřejněno dne',
	by: 'Zveřejněno do',
	bB: 'Pokračovat',
	bC: 'Uložit',
	bF: 'Odeslat E-Mail',
	bJ: 'Tento odkaz můžete sdílet se všemi, kteří mají mít přístup k těmto datům.',
	bK: $author$project$Messages$ShareFileList$cz,
	bM: 'Sdílení bylo publikováno, ale jeho platnost již vypršelo. Musíte jej ' + 'nejprve zrušit a poté znovu publikovat.',
	bN: 'Sdílet odkaz',
	bO: 'Abyste mohli tuto položku sdílet s ostatními, musíte ji zveřejnit. ' + ('Poté budou mít k těmto datům přístup všichni, ' + 'kterým vygenerovaný odkaz pošlete.'),
	bP: 'Soubory jsou dostupné přes QR kód níže, nebo na webové adrese:',
	bQ: 'Sdílení bylo publikováno, ale bylo dosaženo jejího maximálního počtu zobrazení. Tuto ' + 'vlastnost můžete zvýšit, pokud chcete, aby byla tato položka zveřejněna ještě nějakou dobu..',
	bR: '#/Velikost',
	gt: 'Nahrát',
	b3: 'Zrušit pubikování',
	b4: function (size) {
		return 'Soubory nesmí být větší než ' + (size + '.');
	},
	eF: 'Platnost',
	ad: $author$project$Messages$ValidityField$cz,
	eI: 'Zobrazení',
	cb: 'Mazání. Čekejte prosím.',
	eK: $author$project$Messages$YesNoDimmer$cz,
	cc: 'Sdílené soubory'
};
var $author$project$Messages$HomePage$cz = {aM: 'Vytvořit prostor pro sdílení', aP: 'Sdílet soubor', aU: 'Dokumentace', bL: 'Sdílení souborů', b9: 'Zobrazit prostory pro sdílení', ca: 'Zobrazit soubory'};
var $author$project$Messages$LoginPage$cz = {hc: $author$project$Messages$FixedDropdown$cz, a7: 'Přihlásit se', a8: 'Uživatelské jméno', a9: 'Přihlášení bylo úspěšné', bl: 'Nemáte účet?', h2: 'Nebo', d4: 'Heslo', bq: 'Heslo', bX: 'Zaregistrovat se', b6: 'Uživatelské jméno', b8: 'via'};
var $author$project$Messages$NewInvitePage$cz = {
	aO: 'Vytvořit novou pozvánku',
	M: 'Chyba',
	a4: 'Klíč k pozvánce:',
	dU: _List_fromArray(
		[
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Sharry vyžaduje při registraci pozvánku. Tyto \n             pozvánky můžete vytvářet zde a následně je zaslat uživatelům,\n              aby se mohli zaregistrovat v Sharry.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Každou pozvánku lze použít pouze jednou. Musíte\n             vytvořit jeden klíč pro každou osobu, kterou chcete pozvat.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Vytvoření pozvánky vyžaduje zadání hesla\n             z konfigurace.')
				]))
		]),
	bi: 'Heslo k nové pozvánce',
	bA: 'Reset',
	gt: 'Odeslat',
	iA: 'Pozvánka úspěšně vygenerována'
};
var $author$project$Messages$RegisterPage$cz = {aD: 'Jste již zaregistrován?', hc: $author$project$Messages$FixedDropdown$cz, a4: 'Klíč z pozvánky', d4: 'Heslo', bs: 'Heslo (znovu)', bz: 'Registrace byla úspěšná.', bV: 'Přihlásit se', bW: 'Registrace', b0: 'Odeslat', b5: 'Uživatelské jméno'};
var $author$project$Messages$SettingsPage$cz = {aG: 'Změnit E-Mail', aH: 'Změnit heslo', aQ: 'Stávající heslo', bg: 'Nový E-Mail', bh: 'E-Mailová adresa', dY: 'Nové heslo', bj: 'Nové heslo (znovu)', bI: 'Nastavení', gt: 'Odeslat', b1: 'Odesláním prázdného formuláře smažete E-Mailovou adresu.'};
var $author$project$Messages$IntField$cz = {
	hO: 'Číslo musí být >= ',
	hP: 'Číslo musí být <= ',
	hU: function (str) {
		return '\'' + (str + '\' není povolená hodnota!');
	}
};
var $author$project$Messages$SharePage$cz = {
	aB: 'Všechny soubory byly úspěšně nahrány',
	aJ: 'Smazat formulář',
	aP: 'Vytvořit nové sdílení',
	c5: 'Popis',
	aS: 'Detaily',
	aV: $author$project$Messages$Dropzone2$cz,
	dh: 'Soubory',
	a$: 'Přejít na právě vytvořené sdílení',
	a3: $author$project$Messages$IntField$cz,
	bb: $author$project$Messages$MarkdownInput$cz,
	bc: 'Maximální počet zobrazení',
	dX: 'Název',
	bd: 'Volitelný název',
	bk: 'Nové sdílení',
	d4: 'Heslo',
	bu: 'Pozastavit',
	bB: 'Pokračovat',
	bG: 'Odeslat soubory',
	bH: 'Odeslat další soubory',
	bZ: 'Nahrání některých souborů se nezdařilo',
	b_: 'Nahrání některých souborů se nezdařilo…. Nahrajte soubory znovu. ',
	b$: 'Přejděte do sdílení souborů a akci opakujte.',
	gt: 'Odeslat',
	iP: function (size) {
		return 'Velikost souborů je maximálně ' + (size + '.');
	},
	eF: 'Platnost',
	ad: $author$project$Messages$ValidityField$cz
};
var $author$project$Messages$ShareTable$cz = {
	gR: 'Prostor',
	c0: 'Vytvořeno',
	eZ: $author$project$Messages$DateFormat$formatDateTime(4),
	dS: 'Max počet zobrazení',
	hQ: '#Souborů',
	hR: 'Název/ID',
	h0: 'Otevřít',
	ec: 'Veřejné',
	en: 'Velikost'
};
var $author$project$Messages$UploadPage$cz = {bk: 'Nové sdílení', bD: 'Hledat…', bS: $author$project$Messages$ShareTable$cz, cd: 'Sdílené soubory'};
var $author$project$Messages$cz = {f: $author$project$Messages$AccountPage$cz, gS: $author$project$Messages$AliasPage$cz, E: $author$project$Messages$App$cz, e5: $author$project$Messages$DetailPage$cz, ff: 'fi fi-cz', fm: $author$project$Messages$HomePage$cz, al: 'cz', hx: 'Čeština', hA: 4, dK: $author$project$Messages$LoginPage$cz, hS: $author$project$Messages$NewInvitePage$cz, ia: $author$project$Messages$RegisterPage$cz, gk: $author$project$Messages$SettingsPage$cz, gm: $author$project$Messages$SharePage$cz, iN: $author$project$Messages$UploadPage$cz};
var $author$project$Messages$FixedDropdown$de = {ii: 'Auswahl…'};
var $author$project$Messages$YesNoDimmer$de = {gZ: 'Nein', g2: 'Ja, bitte!', dU: 'Dauerhaft entfernen?'};
var $author$project$Messages$AccountForm$de = {cK: 'Admin', eP: 'Zurück', e0: 'Löschen', hc: $author$project$Messages$FixedDropdown$de, c9: 'E-Mail', hs: 'Id', dK: 'Benutzer', d4: 'Passwort', ev: 'Status', gt: 'Speichern', eK: $author$project$Messages$YesNoDimmer$de};
var $author$project$Messages$AccountTable$de = {
	cK: 'Admin',
	c0: 'Erstellt',
	eZ: $author$project$Messages$DateFormat$formatDateTime(1),
	he: 'Editieren',
	dJ: 'Letzte Anmeldung',
	dK: 'Benutzer',
	hX: '#Anmeldungen',
	hY: '#Freigaben',
	eu: 'Quelle',
	ev: 'Status'
};
var $author$project$Messages$AccountPage$de = {au: $author$project$Messages$AccountForm$de, av: $author$project$Messages$AccountTable$de, gN: 'Konten', aL: 'Neues internes Konto erstellen', be: 'Neues Konto', ih: 'Suche…'};
var $author$project$Messages$ValidityField$de = {g5: 'Tag', e_: 'Tage', hc: $author$project$Messages$FixedDropdown$de, fp: 'Stunde', cy: 'Stunden', hM: 'Monat', cD: 'Monate', iS: 'Woche', iT: 'Wochen'};
var $author$project$Messages$AliasForm$de = {
	eP: 'Zurück',
	e0: 'Löschen',
	da: 'Aktiv',
	hs: 'Id',
	hK: 'Zugehörige Benutzer können den Alias sehen und teilen, sowie alle Uploads einsehen, die durch diesen Alias empfangen wurden.',
	dT: 'Zugehörige Benutzer',
	dX: 'Name',
	hV: A2(
		$elm$html$Html$p,
		_List_Nil,
		_List_fromArray(
			[
				$elm$html$Html$text('Die ID ist Teil der URL, über welche '),
				A2(
				$elm$html$Html$em,
				_List_Nil,
				_List_fromArray(
					[
						$elm$html$Html$text('jeder')
					])),
				$elm$html$Html$text(' Dateien hochladen kann. Es ist empfohlen hier'),
				$elm$html$Html$text(' etwas Zufälliges zu nehmen. Die ID kann zwar zu  '),
				$elm$html$Html$text(' irgendeinen Wert geändert werden, ist das Feld aber leer,'),
				$elm$html$Html$text(' wird eine zufällige ID erzeugt.')
			])),
	hW: 'Zu IDs',
	ih: 'Suche…',
	gt: 'Speichern',
	eF: 'Gültigkeit',
	ad: $author$project$Messages$ValidityField$de,
	eK: $author$project$Messages$YesNoDimmer$de
};
var $author$project$Messages$AliasTable$de = {
	c0: 'Erstellt',
	eZ: $author$project$Messages$DateFormat$formatDateTime(1),
	he: 'Editieren',
	da: 'Aktiv',
	dX: 'Name',
	d3: 'Eigentümer',
	ir: 'Anzeigen',
	eF: 'Gültigkeit',
	ad: $author$project$Messages$ValidityField$de
};
var $author$project$Messages$MailForm$de = {g: 'E-Mail Text', cV: 'Abbrechen', h9: 'Empfänger', im: 'Absenden', ip: 'Mehrere Empfänger durch Komma trennen', ey: 'Betreff'};
var $author$project$Messages$MailSend$de = {hD: 'Lade Template ...', X: $author$project$Messages$MailForm$de, $9: 'Sende E-Mail ...'};
var $author$project$Messages$AliasPage$de = {ax: $author$project$Messages$AliasForm$de, gS: 'Alias Seite: ', ay: 'Die Alias Seite ist nun hier: ', az: 'Alias Seiten', aA: $author$project$Messages$AliasTable$de, aK: 'Link kopieren', aN: 'Neue Alias Seite erstellen', aZ: 'Fehler beim Erstellen des QR-Code.', ba: $author$project$Messages$MailSend$de, bf: 'Neue Alias Seite', bm: 'Diese Alias-Seite gehört einen anderen Benutzer. Du kannst die Eigenschaften nicht bearbeiten.', d3: 'Eigentümer', ih: 'Suche…', bF: 'Sende E-Mail', bT: 'Teile diesen Link', bU: 'Du kannst diese URL mit anderen teilen, um von ihnen Dateien zu erhalten.'};
var $author$project$Messages$App$de = {
	gN: 'Konten',
	gT: 'Aliase',
	fm: 'Home',
	hC: 'Hell/Dunkel',
	dK: 'Anmelden',
	hE: function (user) {
		return 'Abmelden (' + (user + ')');
	},
	hF: 'Abmelden nur über den Authentifizierungs-Provider möglich',
	hG: 'Von Sharry abmelden',
	hT: 'Einladungen',
	ia: 'Registrieren',
	gk: 'Einstellungen',
	el: 'Freigaben'
};
var $author$project$Messages$Dropzone2$de = {hb: 'Dateien hier reinziehen', hl: ' Dateien ausgewählt (', h2: 'Oder', ij: 'Dateien wählen ...'};
var $author$project$Messages$MarkdownInput$de = {he: 'Editieren', f6: 'Vorschau', gs: 'Geteilt', iB: 'Unterstützt Markdown'};
var $author$project$Messages$ShareFileList$de = {e1: 'Datei löschen.', c7: 'Herunterladen', hj: 'Die Datei ist unvollständig (', h6: 'Vorschau nicht unterstützt', iL: '%). Versuchen Sie erneut hochzuladen.', gE: 'Im Browser ansehen', eK: $author$project$Messages$YesNoDimmer$de};
var $author$project$Messages$DetailPage$de = {
	aw: 'Dateien hinzufügen',
	gR: 'Alias',
	cV: 'Abbrechen',
	aF: 'Kachel Ansicht',
	aI: 'Zurücksetzen',
	aK: 'Link kopieren',
	c0: 'Erstellt',
	eZ: $author$project$Messages$DateFormat$formatDateTime(1),
	e0: 'Löschen',
	aT: 'Details',
	aV: $author$project$Messages$Dropzone2$de,
	he: 'Ändern',
	aW: 'Beschreibung ändern',
	aZ: 'Fehler beim Erzeugen des QR-Codes.',
	a1: 'Anfangsansicht',
	a2: function (iv) {
		switch (iv) {
			case 0:
				return 'Liste';
			case 1:
				return 'Kacheln';
			default:
				return 'Vorschau';
		}
	},
	dI: 'Letzter Zugriff',
	a5: 'Listen Ansicht',
	a6: 'Lade Daten ...',
	ba: $author$project$Messages$MailSend$de,
	bb: $author$project$Messages$MarkdownInput$de,
	dS: 'Max. Ansichten',
	dX: 'Name',
	h2: 'Oder',
	d4: 'Passwort',
	bo: 'Passwort ungültig',
	bp: 'Keins',
	br: 'Passwortgeschützt',
	bt: 'Passwort erforderlich',
	bu: 'Pause',
	bv: 'Veröffentlichen',
	bw: 'Neuen Link veröffentlichen',
	bx: 'Veröffentlicht am',
	by: 'Veröffentlicht bis',
	bB: 'Fortfahren',
	bC: 'Speichern',
	bF: 'Sende E-Mail',
	bJ: 'Sie können diesen Link mit denen teilen, die Zugriff auf diese Dateien bekommen sollen.',
	bK: $author$project$Messages$ShareFileList$de,
	bM: 'Die Datei-Freigabe wurde veröffentlicht, aber die Gültigkeit ist abgelaufen. Sie können ' + ('sie erneut veröffentlichen, indem sie zuerts „Veröffentlichung zurückziehen” klicken ' + 'und danach wieder „Veröffentlichen”.'),
	bN: 'Link teilen',
	bO: 'Sie müssen diese Datei-Freigabe veröffentlichen, damit andere Zugriff erhalten können. ' + ('Den damit erzeugten Link können Sie mit anderen teilen, die damit dann die ' + 'Dateien einsehen können.'),
	bP: 'Die Datei-Freigabe ist hier öffentlich verfügbar:',
	bQ: 'Die Dateien sind veröffentlicht, aber das Limit für die maximale Ansicht wurde erreicht.' + ' Sie können das Limit erhöhen, um die Veröffentlichung zu verlängern.',
	bR: '#/Größe',
	gt: 'Absenden',
	b3: 'Veröffentlichung zurückziehen',
	b4: function (size) {
		return 'Alle Dateien dürfen nicht größer sein als ' + (size + '.');
	},
	eF: 'Gültigkeit',
	ad: $author$project$Messages$ValidityField$de,
	eI: 'Ansichten',
	cb: 'Datei-Freigabe wird gelöscht. Bitte warten.',
	eK: $author$project$Messages$YesNoDimmer$de,
	cc: 'Deine Datei-Freigabe'
};
var $author$project$Messages$HomePage$de = {aM: 'Neue Alias Seite', aP: 'Neue Datei-Freigabe erstellen', aU: 'Dokumentation (Englisch)', bL: 'Dateien mit anderen teilen', b9: 'Alias Seiten anzeigen', ca: 'Datei-Freigaben ansehen'};
var $author$project$Messages$LoginPage$de = {hc: $author$project$Messages$FixedDropdown$de, a7: 'Anmelden', a8: 'Benutzer', a9: 'Anmeldung erfolgreich', bl: 'Kein Konto?', h2: 'Oder', d4: 'Passwort', bq: 'Passwort', bX: 'Hier registrieren!', b6: 'Benutzer', b8: 'via'};
var $author$project$Messages$NewInvitePage$de = {
	aO: 'Neue Einladungen erstellen',
	M: 'Fehler',
	a4: 'Einladungs-Code:',
	dU: _List_fromArray(
		[
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Sharry erfordert einen Code zum Registrieren. Sie können\n             diese Codes hier erzeugen und ihn Freunden zukommen lassen, die\n             sich dann hier registrieren können.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Jeder Code kann genau einmal verwendet werden. Sie müssen\n              für jede Person einen separaten Code erzeugen.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Um einen Einladungs-Code zu erzeugen, ist ein Passwort aus\n                 der Konfiguration erforderlich.')
				]))
		]),
	bi: 'Password zum Erstellen neuer Einladungen',
	bA: 'Zurücksetzen',
	gt: 'Code erzeugen',
	iA: 'Erfolg'
};
var $author$project$Messages$RegisterPage$de = {aD: 'Schon registriert?', hc: $author$project$Messages$FixedDropdown$de, a4: 'Einladungscode', d4: 'Passwort', bs: 'Passwort (Wiederholung)', bz: 'Registrierung erfolgreich.', bV: 'Anmelden', bW: 'Registrierung', b0: 'Absenden', b5: 'Benutzername'};
var $author$project$Messages$SettingsPage$de = {aG: 'E-Mail ändern', aH: 'Passwort ändern', aQ: 'Aktuelles Passwort', bg: 'Neue E-Mail', bh: 'E-Mail Addresse', dY: 'Neues Passwort', bj: 'Neues Passwort (Wiederholung)', bI: 'Einstellungen', gt: 'Speichern', b1: 'Abschicken eines leeren Formulars löscht die E-Mail Addresse.'};
var $author$project$Messages$IntField$de = {
	hO: 'Zahl muss >= ',
	hP: 'Zahl muss <= ',
	hU: function (str) {
		return '\'' + (str + '\' ist keine Zahl!');
	}
};
var $author$project$Messages$SharePage$de = {
	aB: 'Alle Dateien hochgeladen',
	aJ: 'Dateien entfernen',
	aP: 'Neue Datei-Freigabe erstellen',
	c5: 'Beschreibung',
	aS: 'Details',
	aV: $author$project$Messages$Dropzone2$de,
	dh: 'Dateien',
	a$: 'Zur Freigabe',
	a3: $author$project$Messages$IntField$de,
	bb: $author$project$Messages$MarkdownInput$de,
	bc: 'Maximale Ansichten',
	dX: 'Name',
	bd: 'Optionaler Name',
	bk: 'Neue Freigabe',
	d4: 'Passwort',
	bu: 'Pause',
	bB: 'Fortfahren',
	bG: 'Dateien versenden',
	bH: 'Weitere Dateien versenden',
	bZ: 'Einige Dateien fehlerhaft',
	b_: 'Einigen Dateien konnten nicht hochgeladen werden. ' + 'Sie können versuchen, sie erneut hochzuladen. ',
	b$: 'Gehen Sie zur Datei-Freigabe und laden Sie die gleiche Datei nochmal hoch.',
	gt: 'Hochladen',
	iP: function (size) {
		return 'Es kann bis zu ' + (size + ' hochgeladen werden.');
	},
	eF: 'Gültigkeit',
	ad: $author$project$Messages$ValidityField$de
};
var $author$project$Messages$ShareTable$de = {
	gR: 'Alias',
	c0: 'Erstellt',
	eZ: $author$project$Messages$DateFormat$formatDateTime(1),
	dS: 'Max. Ansichten',
	hQ: '#Dateien',
	hR: 'Name/Id',
	h0: 'Öffnen',
	ec: 'Veröffentlicht',
	en: 'Größe'
};
var $author$project$Messages$UploadPage$de = {bk: 'Neue Freigabe', bD: 'Suche…', bS: $author$project$Messages$ShareTable$de, cd: 'Deine Freigaben'};
var $author$project$Messages$de = {f: $author$project$Messages$AccountPage$de, gS: $author$project$Messages$AliasPage$de, E: $author$project$Messages$App$de, e5: $author$project$Messages$DetailPage$de, ff: 'fi fi-de', fm: $author$project$Messages$HomePage$de, al: 'de', hx: 'Deutsch', hA: 1, dK: $author$project$Messages$LoginPage$de, hS: $author$project$Messages$NewInvitePage$de, ia: $author$project$Messages$RegisterPage$de, gk: $author$project$Messages$SettingsPage$de, gm: $author$project$Messages$SharePage$de, iN: $author$project$Messages$UploadPage$de};
var $author$project$Messages$FixedDropdown$fr = {ii: 'Selectionner…'};
var $author$project$Messages$YesNoDimmer$gb = {gZ: 'No', g2: 'Yes, do it!', dU: 'Delete this item permanently?'};
var $author$project$Messages$AccountForm$fr = {cK: 'Admin', eP: 'Retour', e0: 'Supprimer', hc: $author$project$Messages$FixedDropdown$fr, c9: 'e-mail', hs: 'Id', dK: 'Identifiant', d4: 'Mot de passe', ev: 'État', gt: 'Envoyer', eK: $author$project$Messages$YesNoDimmer$gb};
var $author$project$Messages$AccountTable$fr = {
	cK: 'Admin',
	c0: 'Créé',
	eZ: $author$project$Messages$DateFormat$formatDateTime(2),
	he: 'Éditer',
	dJ: 'Dernière connexion',
	dK: 'Identifiant',
	hX: '#Connexions',
	hY: '#Partages',
	eu: 'Source',
	ev: 'État'
};
var $author$project$Messages$AccountPage$fr = {au: $author$project$Messages$AccountForm$fr, av: $author$project$Messages$AccountTable$fr, gN: 'Comptes', aL: 'Créer un nouveau compte local', be: 'Nouveau compte', ih: 'Recherche…'};
var $author$project$Messages$ValidityField$fr = {g5: 'jour', e_: 'jours', hc: $author$project$Messages$FixedDropdown$fr, fp: 'heure', cy: 'heures', hM: 'mois', cD: 'mois', iS: 'semaine', iT: 'semaines'};
var $author$project$Messages$YesNoDimmer$fr = {gZ: 'Non', g2: 'Oui, Allons-y !', dU: 'Supprimer définitivement ?'};
var $author$project$Messages$FixedDropdown$gb = {ii: 'Select…'};
var $author$project$Messages$ValidityField$gb = {g5: 'day', e_: 'days', hc: $author$project$Messages$FixedDropdown$gb, fp: 'hour', cy: 'hours', hM: 'month', cD: 'months', iS: 'week', iT: 'weeks'};
var $author$project$Messages$AliasForm$gb = {
	eP: 'Back',
	e0: 'Delete',
	da: 'Enabled',
	hs: 'Id',
	hK: 'Members of your alias can see and share this alias and can see all uploads that were received via this alias.',
	dT: 'Members',
	dX: 'Name',
	hV: A2(
		$elm$html$Html$p,
		_List_Nil,
		_List_fromArray(
			[
				$elm$html$Html$text('This ID is part of the url where '),
				A2(
				$elm$html$Html$em,
				_List_Nil,
				_List_fromArray(
					[
						$elm$html$Html$text('everyone')
					])),
				$elm$html$Html$text(' can upload files. It is recommended to use'),
				$elm$html$Html$text(' something random. The id can be changed to '),
				$elm$html$Html$text('any value, but if it is left empty, a random '),
				$elm$html$Html$text('one will be generated.')
			])),
	hW: 'Note to Ids',
	ih: 'Search…',
	gt: 'Submit',
	eF: 'Validity',
	ad: $author$project$Messages$ValidityField$gb,
	eK: $author$project$Messages$YesNoDimmer$gb
};
var $author$project$Messages$AliasForm$fr = {
	eP: 'Retour',
	e0: 'Supprimer',
	da: 'Activé',
	hs: 'Id',
	hK: $author$project$Messages$AliasForm$gb.hK,
	dT: 'Membre',
	dX: 'Nom',
	hV: A2(
		$elm$html$Html$p,
		_List_Nil,
		_List_fromArray(
			[
				$elm$html$Html$text('L\'Id fait partie de l\'url où '),
				A2(
				$elm$html$Html$em,
				_List_Nil,
				_List_fromArray(
					[
						$elm$html$Html$text('quiconque')
					])),
				$elm$html$Html$text(' peut envoyer des fichiers. Il est recommandé d\'utiliser '),
				$elm$html$Html$text(' quelque chose d\'aléatoire. L\'Id peut être modifiée à '),
				$elm$html$Html$text('n\'importe quelle valeur, mais si elle est laissée vide, '),
				$elm$html$Html$text('une valeur aléatoire sera générée.')
			])),
	hW: 'À propos des Ids',
	ih: 'Recherche…',
	gt: 'Envoyer',
	eF: 'Validité',
	ad: $author$project$Messages$ValidityField$fr,
	eK: $author$project$Messages$YesNoDimmer$fr
};
var $author$project$Messages$AliasTable$fr = {
	c0: 'Créé',
	eZ: $author$project$Messages$DateFormat$formatDateTime(2),
	he: 'Éditer',
	da: 'Activé',
	dX: 'Nom',
	d3: 'Owner',
	ir: 'Show',
	eF: 'Validité',
	ad: $author$project$Messages$ValidityField$fr
};
var $author$project$Messages$MailForm$fr = {g: 'Corps', cV: 'Annulation', h9: 'Destinataire(s)', im: 'Envoi', ip: 'Séparez de multiples destinataires par une virgule', ey: 'Sujet'};
var $author$project$Messages$MailSend$fr = {hD: 'Chargement du modèle ...', X: $author$project$Messages$MailForm$fr, $9: 'Envoi de l\'email ...'};
var $author$project$Messages$AliasPage$fr = {ax: $author$project$Messages$AliasForm$fr, gS: 'Page d\'Alias: ', ay: 'La page d\'alias est maintenant à: ', az: 'Pages d\'Alias', aA: $author$project$Messages$AliasTable$fr, aK: 'Copier le lien', aN: 'Créer une nouvelle page d\'Alias', aZ: 'Erreur lors de l\'encodage en QR Code.', ba: $author$project$Messages$MailSend$fr, bf: 'Nouvelle page d\'Alias', bm: 'This alias is owned by another user and shared with you. You cannot edit its properties.', d3: 'Owner', ih: 'Recherche…', bF: 'Envoyer un email', bT: 'Partager ce lien', bU: 'Vous pouvez partager cette URL avec d\'autres personnes pour recevoir des fichiers de leur part.'};
var $author$project$Messages$App$gb = {
	gN: 'Accounts',
	gT: 'Aliases',
	fm: 'Home',
	hC: 'Light/Dark',
	dK: 'Login',
	hE: function (user) {
		return 'Logout (' + (user + ')');
	},
	hF: 'Logout at your authentication provider',
	hG: 'Logout from Sharry',
	hT: 'New Invites',
	ia: 'Register',
	gk: 'Settings',
	el: 'Shares'
};
var $author$project$Messages$App$fr = {
	gN: 'Comptes',
	gT: 'Alias',
	fm: 'Accueil',
	hC: $author$project$Messages$App$gb.hC,
	dK: 'Connexion',
	hE: function (user) {
		return 'Déconnexion (' + (user + ')');
	},
	hF: 'Déconnexion de votre fournisseur d\'authentification',
	hG: 'Déconnexion de Sharry',
	hT: 'Invitations',
	ia: 'Inscription',
	gk: 'Paramètres',
	el: 'Partages'
};
var $author$project$Messages$Dropzone2$fr = {hb: 'Glisser des fichiers ici', hl: ' fichiers sélectionnés (', h2: 'Ou', ij: 'Sélectionner des fichiers ...'};
var $author$project$Messages$MarkdownInput$fr = {he: 'Éditer', f6: 'Prévisualiser', gs: 'Vue séparée', iB: 'Supporte le Markdown'};
var $author$project$Messages$ShareFileList$fr = {e1: 'Supprimer le fichier.', c7: 'Télécharger', hj: 'Le fichier est incomplet (', h6: 'Prévisualisation non supportée', iL: '%). Essayer à nouveau.', gE: 'Prévisualisation', eK: $author$project$Messages$YesNoDimmer$fr};
var $author$project$Messages$DetailPage$fr = {
	aw: 'Ajouter des fichiers',
	gR: 'Alias',
	cV: 'Annulation',
	aF: 'Miniatures',
	aI: 'Nettoyer',
	aK: 'Copier le lien',
	c0: 'Créé le',
	eZ: $author$project$Messages$DateFormat$formatDateTime(2),
	e0: 'Supprimer',
	aT: 'Détails',
	aV: $author$project$Messages$Dropzone2$fr,
	he: 'Éditer',
	aW: 'Modifier la description',
	aZ: 'Erreur lors de l\'encodage en QR Code.',
	a1: 'Initial view',
	a2: function (iv) {
		switch (iv) {
			case 0:
				return 'Listing';
			case 1:
				return 'Cards';
			default:
				return 'Preview';
		}
	},
	dI: 'Dernier accès',
	a5: 'Liste',
	a6: 'Chargement...',
	ba: $author$project$Messages$MailSend$fr,
	bb: $author$project$Messages$MarkdownInput$fr,
	dS: 'Vues max.',
	dX: 'Nom',
	h2: 'Ou',
	d4: 'Mot de passe',
	bo: 'Mot de passe invalide',
	bp: 'Sans',
	br: 'Protégé',
	bt: 'Mot de passe requis',
	bu: 'Pause',
	bv: 'Publier',
	bw: 'Publier avec un nouveau lien',
	bx: 'Publié le',
	by: 'Expiration',
	bB: 'Reprendre',
	bC: 'Sauver',
	bF: 'Envoyer un email',
	bJ: 'Vous pouvez partager ce lien avec tous ceux qui souhaitent accéder à ces données.',
	bK: $author$project$Messages$ShareFileList$fr,
	bM: 'Le partage est publié mais il a expiré. Vous pouvez  ' + 'premièrement le dépublier pour le publier à nouveau.',
	bN: 'Lien de partage',
	bO: 'Afin de partager ceci avec d\'autres, vous devez publier ' + ('ce partage. Ensuite, envoyez le lien généré à chaque ' + 'personne pour qu’elle y accède.'),
	bP: 'Ce partage est accessible au public à l\'adresse suivante',
	bQ: 'Le partage a été publié mais le nombre de vues maximal a été atteint. Vous pouvez ' + 'augmenter cette propriété si vous souhaitez le publier pendant un certain temps encore.',
	bR: '#/Taille',
	gt: 'Envoyer',
	b3: 'Dépublier',
	b4: function (size) {
		return 'Chaque téléversement ne doit pas dépasser ' + (size + '.');
	},
	eF: 'Durée de validité',
	ad: $author$project$Messages$ValidityField$fr,
	eI: 'Vues',
	cb: 'Suppresion du partage. Patientez.',
	eK: $author$project$Messages$YesNoDimmer$fr,
	cc: 'Votre partage'
};
var $author$project$Messages$HomePage$fr = {aM: 'Nouvelle page d\'Alias', aP: 'Créer un partage', aU: 'Documentation', bL: 'Partager des fichiers', b9: 'Pages d\'Alias', ca: 'Voir les partages'};
var $author$project$Messages$LoginPage$fr = {hc: $author$project$Messages$FixedDropdown$fr, a7: 'Connexion', a8: 'Utilisateur', a9: 'Identification réussie', bl: 'Pas de compte ?', h2: 'Ou', d4: 'Mot de passe', bq: 'Mot de passe', bX: 'S\'inscrire', b6: 'Identifiant', b8: 'via'};
var $author$project$Messages$NewInvitePage$fr = {
	aO: 'Créer des invitations',
	M: 'Erreur',
	a4: 'Clé d\'invitation:',
	dU: _List_fromArray(
		[
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Sharry exige une invitation lors de l\'inscription. \n             Vous pouvez créer ces invitations ici et les envoyer à \n             vos amis afin qu\'ils puissent s\'inscrire.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Chaque invitation ne peut être utilisée qu\'une seule fois.\n             Vous devrez créer une clé pour chaque personne que vous souhaitez inviter.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Pour créer une invitation, il faut fournir le mot de passe choisi lors de la configuration.')
				]))
		]),
	bi: 'Mot de passe d\'invitation',
	bA: 'Réinitialiser',
	gt: 'Envoyer',
	iA: 'Succès'
};
var $author$project$Messages$RegisterPage$fr = {aD: 'Déjà inscrit ?', hc: $author$project$Messages$FixedDropdown$fr, a4: 'Clé d\'invitation', d4: 'Mot de passe', bs: 'Mot de passe (bis)', bz: 'Inscription réussie.', bV: 'Connexion', bW: 'Inscription', b0: 'Envoyer', b5: 'Identifiant'};
var $author$project$Messages$SettingsPage$fr = {aG: 'Changer votre email', aH: 'Changer de mot de passe', aQ: 'Mot de passe actuel', bg: ' Nouvel email', bh: 'Addresse email', dY: 'Nouveau mot de passe', bj: 'Nouveau mot de passe (bis)', bI: 'Paramètres', gt: 'Envoyer', b1: 'Soumettre un formulaire vide supprime l\'adresse email.'};
var $author$project$Messages$IntField$fr = {
	hO: 'Le nombre doit être >= ',
	hP: 'Le nombre doit être <= ',
	hU: function (str) {
		return '\'' + (str + '\' n\'est pas un nombre valide !');
	}
};
var $author$project$Messages$SharePage$fr = {
	aB: 'Tous les fichiers sont téléversés',
	aJ: 'Nettoyer les fichiers',
	aP: 'Créer un partage',
	c5: 'Description',
	aS: 'Détails',
	aV: $author$project$Messages$Dropzone2$fr,
	dh: 'Fichiers',
	a$: 'Voir le partage',
	a3: $author$project$Messages$IntField$fr,
	bb: $author$project$Messages$MarkdownInput$fr,
	bc: 'Nombre maximum de vues',
	dX: 'Nom',
	bd: 'Nom facultatif',
	bk: 'Nouveau partage',
	d4: 'Mot de passe',
	bu: 'Pause',
	bB: 'Reprendre',
	bG: 'Envoyer des fichiers',
	bH: 'Envoyer plus de fichiers',
	bZ: 'Certains téléversements ont échoué',
	b_: 'Certains téléversements ont échoué…. Vous pouvez essayer à nouveau. ',
	b$: 'Retournez dans votre partage et envoyez le même fichier à nouveau.',
	gt: 'Envoyer',
	iP: function (size) {
		return 'Téléversements possibles jusqu\'à ' + (size + '.');
	},
	eF: 'Validité',
	ad: $author$project$Messages$ValidityField$fr
};
var $author$project$Messages$ShareTable$fr = {
	gR: 'Alias',
	c0: 'Créé',
	eZ: $author$project$Messages$DateFormat$formatDateTime(2),
	dS: 'Vues max.',
	hQ: '#Fichiers',
	hR: 'Nom/Id',
	h0: 'Ouvrir',
	ec: 'Publié',
	en: 'Taille'
};
var $author$project$Messages$UploadPage$fr = {bk: 'Nouveau partage', bD: 'Recherche…', bS: $author$project$Messages$ShareTable$fr, cd: 'Vos partages'};
var $author$project$Messages$fr = {f: $author$project$Messages$AccountPage$fr, gS: $author$project$Messages$AliasPage$fr, E: $author$project$Messages$App$fr, e5: $author$project$Messages$DetailPage$fr, ff: 'fi fi-fr', fm: $author$project$Messages$HomePage$fr, al: 'fr', hx: 'Français', hA: 2, dK: $author$project$Messages$LoginPage$fr, hS: $author$project$Messages$NewInvitePage$fr, ia: $author$project$Messages$RegisterPage$fr, gk: $author$project$Messages$SettingsPage$fr, gm: $author$project$Messages$SharePage$fr, iN: $author$project$Messages$UploadPage$fr};
var $author$project$Messages$AccountForm$gb = {cK: 'Admin', eP: 'Back', e0: 'Delete', hc: $author$project$Messages$FixedDropdown$gb, c9: 'E-Mail', hs: 'Id', dK: 'Login', d4: 'Password', ev: 'State', gt: 'Submit', eK: $author$project$Messages$YesNoDimmer$gb};
var $author$project$Messages$AccountTable$gb = {
	cK: 'Admin',
	c0: 'Created',
	eZ: $author$project$Messages$DateFormat$formatDateTime(0),
	he: 'Edit',
	dJ: 'Last Login',
	dK: 'Login',
	hX: '#Logins',
	hY: '#Shares',
	eu: 'Source',
	ev: 'State'
};
var $author$project$Messages$AccountPage$gb = {au: $author$project$Messages$AccountForm$gb, av: $author$project$Messages$AccountTable$gb, gN: 'Accounts', aL: 'Create a new internal account', be: 'New Account', ih: 'Search…'};
var $author$project$Messages$AliasTable$gb = {
	c0: 'Created',
	eZ: $author$project$Messages$DateFormat$formatDateTime(0),
	he: 'Edit',
	da: 'Enabled',
	dX: 'Name',
	d3: 'Owner',
	ir: 'Show',
	eF: 'Validity',
	ad: $author$project$Messages$ValidityField$gb
};
var $author$project$Messages$MailForm$gb = {g: 'Body', cV: 'Cancel', h9: 'Receiver(s)', im: 'Send', ip: 'Separate multiple recipients by comma', ey: 'Subject'};
var $author$project$Messages$MailSend$gb = {hD: 'Loading template ...', X: $author$project$Messages$MailForm$gb, $9: 'Sending mail ...'};
var $author$project$Messages$AliasPage$gb = {ax: $author$project$Messages$AliasForm$gb, gS: 'Alias Page: ', ay: 'The alias page is now at: ', az: 'Alias Pages', aA: $author$project$Messages$AliasTable$gb, aK: 'Copy Link', aN: 'Create New Alias Page', aZ: 'Error while encoding to QRCode.', ba: $author$project$Messages$MailSend$gb, bf: 'New Alias Page', bm: 'This alias is owned by another user and shared with you. You cannot edit its properties.', d3: 'Owner', ih: 'Search…', bF: 'Send E-Mail', bT: 'Share this link', bU: 'You can share this URL with others to receive files from them.'};
var $author$project$Messages$Dropzone2$gb = {hb: 'Drop files here', hl: ' files selected (', h2: 'Or', ij: 'Select Files ...'};
var $author$project$Messages$MarkdownInput$gb = {he: 'Edit', f6: 'Preview', gs: 'Split', iB: 'Supports Markdown'};
var $author$project$Messages$ShareFileList$gb = {e1: 'Delete the file.', c7: 'Download to disk', hj: 'The file is incomplete (', h6: 'Preview not supported', iL: '%). Try uploading again.', gE: 'View in browser', eK: $author$project$Messages$YesNoDimmer$gb};
var $author$project$Messages$DetailPage$gb = {
	aw: 'Add files',
	gR: 'Alias',
	cV: 'Cancel',
	aF: 'Card View',
	aI: 'Clear',
	aK: 'Copy Link',
	c0: 'Created',
	eZ: $author$project$Messages$DateFormat$formatDateTime(0),
	e0: 'Delete',
	aT: 'Details',
	aV: $author$project$Messages$Dropzone2$gb,
	he: 'Edit',
	aW: 'Edit description',
	aZ: 'Error while encoding to QRCode.',
	a1: 'Initial view',
	a2: function (iv) {
		switch (iv) {
			case 0:
				return 'Listing';
			case 1:
				return 'Cards';
			default:
				return 'Preview';
		}
	},
	dI: 'Last Access',
	a5: 'List View',
	a6: 'Loading data...',
	ba: $author$project$Messages$MailSend$gb,
	bb: $author$project$Messages$MarkdownInput$gb,
	dS: 'Max. Views',
	dX: 'Name',
	h2: 'Or',
	d4: 'Password',
	bo: 'Password invalid',
	bp: 'None',
	br: 'Password Protected',
	bt: 'Password required',
	bu: 'Pause',
	bv: 'Publish',
	bw: 'Publish with new Link',
	bx: 'Published on',
	by: 'Published until',
	bB: 'Resume',
	bC: 'Save',
	bF: 'Send E-Mail',
	bJ: 'You can share this link to all you\'d like to access this data.',
	bK: $author$project$Messages$ShareFileList$gb,
	bM: 'The share has been published, but it is now expired. You can ' + 'first unpublish and then publish it again.',
	bN: 'Share Link',
	bO: 'In order to share this with others, you need to publish ' + ('this share. Then everyone you\'ll send the generated link ' + 'can access this data.'),
	bP: 'The share is publicly available at',
	bQ: 'The share has been published, but its max-views has been reached. You can ' + 'increase this property if you want to have this published for another while.',
	bR: '#/Size',
	gt: 'Submit',
	b3: 'Unpublish',
	b4: function (size) {
		return 'All uploads must not be greater than ' + (size + '.');
	},
	eF: 'Validity Time',
	ad: $author$project$Messages$ValidityField$gb,
	eI: 'Views',
	cb: 'Deleting share. Please wait.',
	eK: $author$project$Messages$YesNoDimmer$gb,
	cc: 'Your Share'
};
var $author$project$Messages$HomePage$gb = {aM: 'Create Alias', aP: 'Create Share', aU: 'Documentation', bL: 'Share files with others', b9: 'View Aliases', ca: 'View Shares'};
var $author$project$Messages$LoginPage$gb = {hc: $author$project$Messages$FixedDropdown$gb, a7: 'Login', a8: 'Login', a9: 'Login successful', bl: 'No account?', h2: 'Or', d4: 'Password', bq: 'Password', bX: 'Sign up!', b6: 'Username', b8: 'via'};
var $author$project$Messages$NewInvitePage$gb = {
	aO: 'Create new invitations',
	M: 'Error',
	a4: 'Invitation Key:',
	dU: _List_fromArray(
		[
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Sharry requires an invite when signing up. You can\n             create these invites here and send them to friends so\n             they can signup with Sharry.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Each invite can only be used once. You\'ll need to\n             create one key for each person you want to invite.')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('Creating an invite requires providing the password\n             from the configuration.')
				]))
		]),
	bi: 'New Invitation Password',
	bA: 'Reset',
	gt: 'Submit',
	iA: 'Success'
};
var $author$project$Messages$RegisterPage$gb = {aD: 'Already signed up?', hc: $author$project$Messages$FixedDropdown$gb, a4: 'Invitation Key', d4: 'Password', bs: 'Password (repeat)', bz: 'Registration successful.', bV: 'Sign in', bW: 'Sign up', b0: 'Submit', b5: 'User Login'};
var $author$project$Messages$SettingsPage$gb = {aG: 'Change your E-Mail', aH: 'Change Password', aQ: 'Current Password', bg: 'New E-Mail', bh: 'E-Mail address', dY: 'New Password', bj: 'New Password (Repeat)', bI: 'Settings', gt: 'Submit', b1: 'Submitting an empty form deletes the E-Mail address.'};
var $author$project$Messages$IntField$gb = {
	hO: 'Number must be >= ',
	hP: 'Number must be <= ',
	hU: function (str) {
		return '\'' + (str + '\' is not a valid number!');
	}
};
var $author$project$Messages$SharePage$gb = {
	aB: 'All files uploaded',
	aJ: 'Clear Files',
	aP: 'Create a Share',
	c5: 'Description',
	aS: 'Details',
	aV: $author$project$Messages$Dropzone2$gb,
	dh: 'Files',
	a$: 'Goto Share',
	a3: $author$project$Messages$IntField$gb,
	bb: $author$project$Messages$MarkdownInput$gb,
	bc: 'Maximum Public Views',
	dX: 'Name',
	bd: 'Optional Name',
	bk: 'New Share',
	d4: 'Password',
	bu: 'Pause',
	bB: 'Resume',
	bG: 'Send files',
	bH: 'Send more files',
	bZ: 'Some files failed',
	b_: 'Some files failed to upload…. You can try uploading them again. ',
	b$: 'Go to the share and submit the same file again.',
	gt: 'Submit',
	iP: function (size) {
		return 'Uploads are possible up to ' + (size + '.');
	},
	eF: 'Validity',
	ad: $author$project$Messages$ValidityField$gb
};
var $author$project$Messages$ShareTable$gb = {
	gR: 'Alias',
	c0: 'Created',
	eZ: $author$project$Messages$DateFormat$formatDateTime(0),
	dS: 'Max Views',
	hQ: '#Files',
	hR: 'Name/Id',
	h0: 'Open',
	ec: 'Published',
	en: 'Size'
};
var $author$project$Messages$UploadPage$gb = {bk: 'New Share', bD: 'Search…', bS: $author$project$Messages$ShareTable$gb, cd: 'Your Shares'};
var $author$project$Messages$gb = {f: $author$project$Messages$AccountPage$gb, gS: $author$project$Messages$AliasPage$gb, E: $author$project$Messages$App$gb, e5: $author$project$Messages$DetailPage$gb, ff: 'fi fi-gb', fm: $author$project$Messages$HomePage$gb, al: 'gb', hx: 'English', hA: 0, dK: $author$project$Messages$LoginPage$gb, hS: $author$project$Messages$NewInvitePage$gb, ia: $author$project$Messages$RegisterPage$gb, gk: $author$project$Messages$SettingsPage$gb, gm: $author$project$Messages$SharePage$gb, iN: $author$project$Messages$UploadPage$gb};
var $author$project$Messages$FixedDropdown$ja = {ii: '選択…'};
var $author$project$Messages$YesNoDimmer$ja = {gZ: 'いいえ', g2: 'はい、削除してください。', dU: 'このアイテムを完全に削除します。よろしいですか ?'};
var $author$project$Messages$AccountForm$ja = {cK: '管理者', eP: '戻る', e0: '削除', hc: $author$project$Messages$FixedDropdown$ja, c9: 'メール', hs: 'ID', dK: 'ログイン', d4: 'パスワード', ev: '状態', gt: '保存', eK: $author$project$Messages$YesNoDimmer$ja};
var $author$project$Messages$AccountTable$ja = {
	cK: '管理者',
	c0: '作成日時',
	eZ: $author$project$Messages$DateFormat$formatDateTime(3),
	he: '編集',
	dJ: '最終ログイン',
	dK: 'ログイン',
	hX: 'ログイン回数',
	hY: '共有数',
	eu: 'ソース',
	ev: '状態'
};
var $author$project$Messages$AccountPage$ja = {au: $author$project$Messages$AccountForm$ja, av: $author$project$Messages$AccountTable$ja, gN: 'アカウント', aL: 'アカウントの新規作成', be: 'アカウントの新規作成', ih: '検索…'};
var $author$project$Messages$ValidityField$ja = {g5: '日間', e_: '日間', hc: $author$project$Messages$FixedDropdown$ja, fp: '時間', cy: '時間', hM: 'カ月間', cD: 'カ月間', iS: '週間', iT: '週間'};
var $author$project$Messages$AliasForm$ja = {
	eP: '戻る',
	e0: '削除',
	da: '有効',
	hs: 'ID',
	hK: 'この受信箱を共同作業するユーザーです。この受信箱を共有したり、ここにアップロードされたファイルのすべてを見ることができます。',
	dT: '共同編集ユーザー',
	dX: '受信箱名',
	hV: A2(
		$elm$html$Html$p,
		_List_Nil,
		_List_fromArray(
			[
				$elm$html$Html$text('ID は、だれもがファイルをアップロードできる URL の一部になります。'),
				$elm$html$Html$text('無作為なものを使うことをおすすめします。'),
				$elm$html$Html$text('空欄にしておくことで自動生成します。')
			])),
	hW: 'ID について',
	ih: '検索…',
	gt: '保存',
	eF: '有効期限',
	ad: $author$project$Messages$ValidityField$ja,
	eK: $author$project$Messages$YesNoDimmer$ja
};
var $author$project$Messages$AliasTable$ja = {
	c0: '作成日時',
	eZ: $author$project$Messages$DateFormat$formatDateTime(3),
	he: '編集',
	da: '有効',
	dX: '受信箱名',
	d3: '所有者',
	ir: '表示',
	eF: '有効期限',
	ad: $author$project$Messages$ValidityField$ja
};
var $author$project$Messages$MailForm$ja = {g: '本文', cV: 'キャンセル', h9: '受信者', im: '送信', ip: '複数の受信者を設定する場合は、コンマで区切る', ey: '件名'};
var $author$project$Messages$MailSend$ja = {hD: 'テンプレートを読み込んでいます...', X: $author$project$Messages$MailForm$ja, $9: 'メールを送信しています...'};
var $author$project$Messages$AliasPage$ja = {ax: $author$project$Messages$AliasForm$ja, gS: '受信箱 : ', ay: 'この受信箱への URL : ', az: 'あなたの受信箱', aA: $author$project$Messages$AliasTable$ja, aK: 'リンクをコピー', aN: '受信箱の新規作成', aZ: 'QR コードの生成でエラーが発生しました。', ba: $author$project$Messages$MailSend$ja, bf: '受信箱の新規作成', bm: 'この受信箱はほかのユーザーが所有していますが、あなたと共同作業しています。情報の変更は所有者でなければできません。', d3: '所有者', ih: '検索...', bF: 'メール送信', bT: 'このリンクを共有', bU: 'この URL を共有することで、相手からファイルを受信できます。'};
var $author$project$Messages$App$ja = {
	gN: 'アカウント',
	gT: '受信箱',
	fm: 'ホーム',
	hC: 'ライト / ダーク',
	dK: 'ログイン',
	hE: function (user) {
		return 'ログアウト (' + (user + ')');
	},
	hF: '認証プロバイダーからログアウト',
	hG: 'ログアウト',
	hT: '招待',
	ia: '登録',
	gk: '設定',
	el: '共有'
};
var $author$project$Messages$Dropzone2$ja = {hb: 'ここにファイルをドロップ', hl: ' 選択ファイル (', h2: 'または', ij: 'ファイルを選択...'};
var $author$project$Messages$MarkdownInput$ja = {he: '編集', f6: 'プレビュー', gs: '分割', iB: 'マークダウン サポート'};
var $author$project$Messages$ShareFileList$ja = {e1: 'ファイルを削除', c7: 'ダウンロード', hj: 'ファイルが不完全です。 ( ', h6: 'プレビュー未対応', iL: '% )。再度アップロードしてください。', gE: 'ブラウザで表示', eK: $author$project$Messages$YesNoDimmer$ja};
var $author$project$Messages$DetailPage$ja = {
	aw: 'ファイルを追加',
	gR: '受信箱',
	cV: 'キャンセル',
	aF: 'カード表示',
	aI: 'クリアー',
	aK: 'リンクをコピー',
	c0: '作成日時',
	eZ: $author$project$Messages$DateFormat$formatDateTime(3),
	e0: '削除',
	aT: '詳細',
	aV: $author$project$Messages$Dropzone2$ja,
	he: '編集',
	aW: '説明を編集',
	aZ: 'QR コードの生成でエラーが発生しました。',
	a1: '表示の初期状態',
	a2: function (iv) {
		switch (iv) {
			case 0:
				return 'リスト表示';
			case 1:
				return 'カード表示';
			default:
				return 'プレビュー';
		}
	},
	dI: '最終アクセス',
	a5: 'リスト表示',
	a6: 'データを読み込んでいます...',
	ba: $author$project$Messages$MailSend$ja,
	bb: $author$project$Messages$MarkdownInput$ja,
	dS: '最大表示回数',
	dX: '名前',
	h2: 'または',
	d4: 'パスワード',
	bo: 'パスワードが無効',
	bp: 'なし',
	br: 'パスワード付',
	bt: '要パスワード',
	bu: '一時停止',
	bv: '公開する',
	bw: '新しいリンクで公開する',
	bx: '公開日時',
	by: '公開期限',
	bB: '再開',
	bC: '保存',
	bF: 'メールを送る',
	bJ: 'このファイルを共有したい相手に、この URL を知らせてください。',
	bK: $author$project$Messages$ShareFileList$ja,
	bM: '共有を公開しましたが、現在期限切れです。' + '一度「未公開」にしてから、再度「公開」できます。',
	bN: 'リンクをシェア',
	bO: 'このファイルをだれかと共有する場合は、次に「公開」をしてください。' + '生成されるリンクを受け取った人はだれでもこのファイルにアクセスできます。',
	bP: 'この共有の公開 URL : ',
	bQ: '共有は公開中ですが、最大表示回数に達しました。' + 'この値を増やすことで、さらに表示・ダウンロードできるようにすることができます。',
	bR: 'ファイル数/サイズ',
	gt: '送信',
	b3: '未公開に戻す',
	b4: function (size) {
		return '共有するファイルの合計が ' + (size + ' より大きくならないようにしてください。');
	},
	eF: '有効期限',
	ad: $author$project$Messages$ValidityField$ja,
	eI: '表示回数',
	cb: '共有を削除しています。お待ちください。',
	eK: $author$project$Messages$YesNoDimmer$ja,
	cc: '共有 (名前なし)'
};
var $author$project$Messages$HomePage$ja = {aM: '受信箱の新規作成', aP: '共有の新規作成', aU: 'ヘルプ', bL: 'ファイルの共有 ( 配布 ) と受信', b9: '受信箱を表示', ca: '共有を表示'};
var $author$project$Messages$LoginPage$ja = {hc: $author$project$Messages$FixedDropdown$ja, a7: 'ログイン', a8: 'username', a9: 'ログインしました', bl: '未登録 ?', h2: 'または', d4: 'パスワード', bq: 'Password', bX: 'ユーザー登録', b6: 'ユーザー名', b8: 'via'};
var $author$project$Messages$NewInvitePage$ja = {
	aO: '招待キーの新規作成',
	M: 'エラー',
	a4: '招待パスワード : ',
	dU: _List_fromArray(
		[
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('このシステムは、招待を受けた方だけがユーザー登録可能です。\n                ここで招待キーを作成することができます。\n                必要な方に招待キーを知らせることで、その方はユーザー登録を進めることができます。')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('招待キーは 1 回 ( 1 人のユーザー登録 ) のみ有効です。\n                招待したい方 1 人ずつに招待コードを作る必要があります。')
				])),
			A2(
			$elm$html$Html$p,
			_List_Nil,
			_List_fromArray(
				[
					$elm$html$Html$text('招待キーの作成には、設定された「招待パスワード」が必要です。')
				]))
		]),
	bi: 'キー',
	bA: 'リセット',
	gt: '保存',
	iA: '成功'
};
var $author$project$Messages$RegisterPage$ja = {aD: '登録が済んでいるなら…', hc: $author$project$Messages$FixedDropdown$ja, a4: '招待キー', d4: 'パスワード', bs: 'パスワード ( 確認 )', bz: '登録が完了しました。', bV: 'ログイン', bW: 'ユーザー登録', b0: '登録', b5: 'ユーザー名'};
var $author$project$Messages$SettingsPage$ja = {aG: 'メールアドレスの変更', aH: 'パスワードの変更', aQ: '現在のパスワード', bg: '新しいメールアドレス', bh: '新しいメールアドレス', dY: '新しいパスワード', bj: '新しいパスワード ( 確認 )', bI: '設定', gt: '保存', b1: '空のままにすると、メールアドレスを削除します。'};
var $author$project$Messages$IntField$ja = {
	hO: '最小値 : ',
	hP: '最大値 : ',
	hU: function (str) {
		return '「' + (str + '」は有効な数値ではありません！');
	}
};
var $author$project$Messages$SharePage$ja = {
	aB: 'すべてのファイルをアップロードしました',
	aJ: 'ファイルをクリアー',
	aP: '共有の作成',
	c5: '説明',
	aS: '詳細',
	aV: $author$project$Messages$Dropzone2$ja,
	dh: 'ファイル',
	a$: '共有へ',
	a3: $author$project$Messages$IntField$ja,
	bb: $author$project$Messages$MarkdownInput$ja,
	bc: '最大表示回数',
	dX: '共有名',
	bd: '共有の名前 (任意)',
	bk: '共有の新規作成',
	d4: 'パスワード',
	bu: '一時停止',
	bB: '再開',
	bG: 'ファイルアップロード',
	bH: 'さらにファイルを追加',
	bZ: 'いくつかのファイルで失敗',
	b_: 'いくつかのファイルのアップロードに失敗しました。再度アップロードすることもできます。',
	b$: '共有画面に戻って、同じファイルを再度アップロードしてください。',
	gt: '保存',
	iP: function (size) {
		return 'アップロードは最大 ' + (size + ' までです。');
	},
	eF: '共有期限',
	ad: $author$project$Messages$ValidityField$ja
};
var $author$project$Messages$ShareTable$ja = {
	gR: '受信箱',
	c0: '作成日時',
	eZ: $author$project$Messages$DateFormat$formatDateTime(3),
	dS: '最大表示回数',
	hQ: 'ファイル数',
	hR: '共有名・ID',
	h0: '開く',
	ec: '公開 ?',
	en: 'サイズ'
};
var $author$project$Messages$UploadPage$ja = {bk: '共有の新規作成', bD: '検索…', bS: $author$project$Messages$ShareTable$ja, cd: 'あなたの共有'};
var $author$project$Messages$ja = {f: $author$project$Messages$AccountPage$ja, gS: $author$project$Messages$AliasPage$ja, E: $author$project$Messages$App$ja, e5: $author$project$Messages$DetailPage$ja, ff: 'fi fi-jp', fm: $author$project$Messages$HomePage$ja, al: 'ja', hx: '日本語', hA: 3, dK: $author$project$Messages$LoginPage$ja, hS: $author$project$Messages$NewInvitePage$ja, ia: $author$project$Messages$RegisterPage$ja, gk: $author$project$Messages$SettingsPage$ja, gm: $author$project$Messages$SharePage$ja, iN: $author$project$Messages$UploadPage$ja};
var $author$project$Messages$get = function (lang) {
	switch (lang) {
		case 0:
			return $author$project$Messages$gb;
		case 1:
			return $author$project$Messages$de;
		case 2:
			return $author$project$Messages$fr;
		case 3:
			return $author$project$Messages$ja;
		default:
			return $author$project$Messages$cz;
	}
};
var $author$project$Messages$toIso2 = function (lang) {
	return $author$project$Messages$get(lang).al;
};
var $author$project$Messages$readIso2 = function (iso) {
	var isIso = function (lang) {
		return _Utils_eq(
			iso,
			$author$project$Messages$toIso2(lang));
	};
	return $elm$core$List$head(
		A2($elm$core$List$filter, isIso, $author$project$Language$allLanguages));
};
var $author$project$Messages$fromIso2 = function (iso) {
	return A2(
		$elm$core$Maybe$withDefault,
		0,
		$author$project$Messages$readIso2(iso));
};
var $author$project$Messages$fromFlags = function (flags) {
	var iso = function () {
		var _v0 = flags.hB;
		if (!_v0.$) {
			var lang = _v0.a;
			return lang;
		} else {
			return flags.b.c3;
		}
	}();
	return $author$project$Messages$get(
		$author$project$Messages$fromIso2(iso));
};
var $author$project$Data$ValidityOptions$validityOptions = function (flags) {
	var m = $author$project$Messages$fromFlags(flags);
	var texts = m.e5.ad;
	var fun = function (_v0) {
		var v = _v0.b;
		return _Utils_cmp(
			$author$project$Data$ValidityValue$toMillis(v),
			flags.b.dQ) < 1;
	};
	return A2(
		$elm$core$List$filter,
		fun,
		$author$project$Data$ValidityOptions$allValidityOptions(texts));
};
var $author$project$Data$ValidityOptions$defaultValidity = function (flags) {
	var findDefault = function (_v0) {
		var v = _v0.b;
		return _Utils_eq(
			$author$project$Data$ValidityValue$toMillis(v),
			flags.b.c4);
	};
	return A2(
		$elm$core$Maybe$withDefault,
		_Utils_Tuple2(
			'2x days',
			$author$project$Data$ValidityValue$Days(2)),
		$elm$core$List$head(
			A2(
				$elm$core$List$filter,
				findDefault,
				$author$project$Data$ValidityOptions$validityOptions(flags))));
};
var $elm$core$Tuple$second = function (_v0) {
	var y = _v0.b;
	return y;
};
var $author$project$Comp$ValidityField$init = function (flags) {
	return $author$project$Comp$FixedDropdown$init(
		A2(
			$elm$core$List$map,
			$elm$core$Tuple$second,
			$author$project$Data$ValidityOptions$validityOptions(flags)));
};
var $author$project$Comp$Dropdown$makeModel = function (input) {
	return {n: _List_Nil, a_: '', k: false, D: input.D, bE: input.bE, cG: _List_Nil};
};
var $author$project$Comp$Dropdown$makeMultiple = $author$project$Comp$Dropdown$makeModel(
	{
		D: true,
		bE: function (n) {
			return n > 0;
		}
	});
var $author$project$Comp$Dropdown$deselectItem = F2(
	function (model, item) {
		var value = item.eG;
		var show = function (e) {
			return _Utils_eq(e.eG, value) ? _Utils_update(
				e,
				{cG: false}) : e;
		};
		var sel = model.D ? A2(
			$elm$core$List$filter,
			function (e) {
				return !_Utils_eq(e.eG, value);
			},
			model.cG) : _List_Nil;
		var avail = A2($elm$core$List$map, show, model.n);
		return _Utils_update(
			model,
			{n: avail, cG: sel});
	});
var $elm$core$List$any = F2(
	function (isOkay, list) {
		any:
		while (true) {
			if (!list.b) {
				return false;
			} else {
				var x = list.a;
				var xs = list.b;
				if (isOkay(x)) {
					return true;
				} else {
					var $temp$isOkay = isOkay,
						$temp$list = xs;
					isOkay = $temp$isOkay;
					list = $temp$list;
					continue any;
				}
			}
		}
	});
var $author$project$Comp$Dropdown$makeItem = F2(
	function (model, val) {
		return {
			gO: false,
			cG: A2(
				$elm$core$List$any,
				function (i) {
					return _Utils_eq(i.eG, val);
				},
				model.cG),
			eG: val,
			cq: true
		};
	});
var $elm$core$List$append = F2(
	function (xs, ys) {
		if (!ys.b) {
			return xs;
		} else {
			return A3($elm$core$List$foldr, $elm$core$List$cons, ys, xs);
		}
	});
var $elm$core$List$concat = function (lists) {
	return A3($elm$core$List$foldr, $elm$core$List$append, _List_Nil, lists);
};
var $author$project$Comp$Dropdown$selectItem = F2(
	function (model, item) {
		var value = item.eG;
		var sel = model.D ? $elm$core$List$concat(
			_List_fromArray(
				[
					model.cG,
					_List_fromArray(
					[item])
				])) : _List_fromArray(
			[item]);
		var hide = function (e) {
			return _Utils_eq(e.eG, value) ? _Utils_update(
				e,
				{cG: true}) : (model.D ? e : _Utils_update(
				e,
				{cG: false}));
		};
		var avail = A2($elm$core$List$map, hide, model.n);
		return _Utils_update(
			model,
			{n: avail, cG: sel});
	});
var $author$project$Comp$Dropdown$setOptions = F3(
	function (model, avail, selected) {
		var m0 = _Utils_update(
			model,
			{
				n: A2(
					$elm$core$List$map,
					$author$project$Comp$Dropdown$makeItem(model),
					avail)
			});
		var m1 = A3(
			$elm$core$List$foldl,
			function (item) {
				return function (m) {
					return A2($author$project$Comp$Dropdown$deselectItem, m, item);
				};
			},
			m0,
			m0.cG);
		var m2 = A3(
			$elm$core$List$foldl,
			function (item) {
				return function (m) {
					return A2($author$project$Comp$Dropdown$selectItem, m, item);
				};
			},
			m1,
			A2(
				$elm$core$List$map,
				$author$project$Comp$Dropdown$makeItem(model),
				selected));
		return m2;
	});
var $author$project$Comp$AliasForm$initNew = F2(
	function (flags, accounts) {
		return {
			S: A3($author$project$Comp$Dropdown$setOptions, $author$project$Comp$Dropdown$makeMultiple, accounts, _List_Nil),
			aR: false,
			ah: true,
			V: $elm$core$Maybe$Nothing,
			a0: $elm$core$Maybe$Nothing,
			Y: '',
			ad: $author$project$Data$ValidityOptions$defaultValidity(flags).b,
			cp: $author$project$Comp$ValidityField$init(flags)
		};
	});
var $author$project$Page$Alias$Data$emptyModel = function (flags) {
	return {
		gN: _List_Nil,
		fh: A2($author$project$Comp$AliasForm$initNew, flags, _List_Nil),
		X: $elm$core$Maybe$Nothing,
		h7: '',
		gg: $elm$core$Maybe$Nothing,
		gi: _List_Nil,
		cG: $elm$core$Maybe$Nothing,
		gw: $author$project$Comp$AliasTable$init
	};
};
var $author$project$Api$Model$BasicResult$BasicResult = F2(
	function (success, message) {
		return {dU: message, iA: success};
	});
var $author$project$Page$Detail$Data$DeleteNone = 0;
var $author$project$Page$Detail$Data$TopClosed = 0;
var $author$project$Comp$ShareFileList$ViewList = 0;
var $author$project$Data$InitialView$Listing = 0;
var $author$project$Data$InitialView$default = 0;
var $author$project$Api$Model$ShareDetail$empty = {eN: $elm$core$Maybe$Nothing, cN: $elm$core$Maybe$Nothing, c0: 0, c5: $elm$core$Maybe$Nothing, c6: $elm$core$Maybe$Nothing, dh: _List_Nil, hs: '', dS: 0, dX: $elm$core$Maybe$Nothing, d4: false, ea: $elm$core$Maybe$Nothing, eF: 0};
var $elm$core$Dict$RBEmpty_elm_builtin = {$: -2};
var $elm$core$Dict$empty = $elm$core$Dict$RBEmpty_elm_builtin;
var $author$project$Data$UploadDict$empty = {il: _List_Nil, iO: $elm$core$Dict$empty};
var $author$project$Comp$Dropzone2$init = {ds: false};
var $elm$core$Set$Set_elm_builtin = $elm$core$Basics$identity;
var $elm$core$Set$empty = $elm$core$Dict$empty;
var $author$project$Comp$ShareFileList$init = {aY: $elm$core$Set$empty, aa: $elm$core$Maybe$Nothing};
var $author$project$Page$Detail$Data$emptyModel = {
	e2: 0,
	e3: $elm$core$Maybe$Nothing,
	aV: $author$project$Comp$Dropzone2$init,
	c8: $elm$core$Maybe$Nothing,
	fd: $author$project$Comp$ShareFileList$init,
	fe: 0,
	X: $elm$core$Maybe$Nothing,
	dU: $elm$core$Maybe$Nothing,
	gm: $author$project$Api$Model$ShareDetail$empty,
	gp: $author$project$Data$InitialView$default,
	gz: 0,
	gA: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
	gC: true,
	gD: false,
	iO: $author$project$Data$UploadDict$empty,
	gM: $elm$core$Maybe$Nothing
};
var $author$project$Page$Home$Data$emptyModel = {};
var $author$project$Page$Info$Data$emptyModel = _List_fromArray(
	[
		{$7: 'Forbidden', iD: '\nYou don\'t have enough permission to access this site.\n'},
		{$7: 'Expired', iD: 'This resource is expired or doesn\'t exist.'}
	]);
var $author$project$Page$NewInvite$Data$Empty = {$: 0};
var $author$project$Page$NewInvite$Data$emptyModel = {d4: '', P: $author$project$Page$NewInvite$Data$Empty};
var $author$project$Page$OpenDetail$Data$emptyPassModel = {eQ: false, da: false, fc: $elm$core$Maybe$Nothing, fL: $author$project$Comp$PasswordInput$init};
var $author$project$Page$OpenDetail$Data$emptyModel = {fd: $author$project$Comp$ShareFileList$init, fe: 0, dU: $elm$core$Maybe$Nothing, d4: $author$project$Page$OpenDetail$Data$emptyPassModel, gm: $author$project$Api$Model$ShareDetail$empty, gM: $elm$core$Maybe$Nothing};
var $author$project$Comp$MarkdownInput$Edit = 0;
var $author$project$Comp$MarkdownInput$init = {cX: 'https://www.markdownguide.org/cheat-sheet', g9: 0};
var $author$project$Page$OpenShare$Data$emptyModel = {
	g7: '',
	e4: $author$project$Comp$MarkdownInput$init,
	e7: $author$project$Comp$Dropzone2$init,
	fi: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
	gn: $elm$core$Maybe$Nothing,
	gC: false,
	gD: false,
	iO: $author$project$Data$UploadDict$empty
};
var $author$project$Page$Register$Data$emptyModel = {e9: _List_Nil, dF: $elm$core$Maybe$Nothing, fx: $author$project$Comp$LanguageChoose$init, fF: false, dK: '', f1: '', f2: '', P: $elm$core$Maybe$Nothing, gq: false, gr: false, gv: ''};
var $author$project$Page$Settings$Data$emptyModel = {eR: $elm$core$Maybe$Nothing, eX: $elm$core$Maybe$Nothing, ag: $elm$core$Maybe$Nothing, fP: $elm$core$Maybe$Nothing, fQ: $elm$core$Maybe$Nothing, fR: $author$project$Comp$PasswordInput$init, fS: $author$project$Comp$PasswordInput$init, fV: $elm$core$Maybe$Nothing, fW: $author$project$Comp$PasswordInput$init, f3: $elm$core$Maybe$Nothing};
var $author$project$Comp$IntField$init = F2(
	function (min, max) {
		return {M: $elm$core$Maybe$Nothing, cz: '', cA: max, cB: min};
	});
var $author$project$Page$Share$Data$emptyModel = function (flags) {
	return {
		g7: '',
		e4: $author$project$Comp$MarkdownInput$init,
		e7: $author$project$Comp$Dropzone2$init,
		fi: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
		dR: $elm$core$Maybe$Just(30),
		fI: A2(
			$author$project$Comp$IntField$init,
			$elm$core$Maybe$Just(1),
			$elm$core$Maybe$Nothing),
		Y: $elm$core$Maybe$Nothing,
		Z: $elm$core$Maybe$Nothing,
		ci: $author$project$Comp$PasswordInput$init,
		gn: $elm$core$Maybe$Nothing,
		gC: false,
		gD: false,
		iO: $author$project$Data$UploadDict$empty,
		ad: $author$project$Data$ValidityOptions$defaultValidity(flags).b,
		cp: $author$project$Comp$ValidityField$init(flags)
	};
};
var $author$project$Comp$ShareTable$init = {cG: $elm$core$Maybe$Nothing};
var $author$project$Page$Upload$Data$emptyModel = {h7: '', gi: _List_Nil, cG: $elm$core$Maybe$Nothing, gw: $author$project$Comp$ShareTable$init};
var $author$project$Data$UiTheme$Dark = 1;
var $author$project$Data$UiTheme$fromString = function (str) {
	var _v0 = $elm$core$String$toLower(str);
	switch (_v0) {
		case 'light':
			return $elm$core$Maybe$Just(0);
		case 'dark':
			return $elm$core$Maybe$Just(1);
		default:
			return $elm$core$Maybe$Nothing;
	}
};
var $elm$url$Url$Parser$State = F5(
	function (visited, unvisited, params, frag, value) {
		return {aj: frag, an: params, ac: unvisited, eG: value, at: visited};
	});
var $elm$url$Url$Parser$getFirstMatch = function (states) {
	getFirstMatch:
	while (true) {
		if (!states.b) {
			return $elm$core$Maybe$Nothing;
		} else {
			var state = states.a;
			var rest = states.b;
			var _v1 = state.ac;
			if (!_v1.b) {
				return $elm$core$Maybe$Just(state.eG);
			} else {
				if ((_v1.a === '') && (!_v1.b.b)) {
					return $elm$core$Maybe$Just(state.eG);
				} else {
					var $temp$states = rest;
					states = $temp$states;
					continue getFirstMatch;
				}
			}
		}
	}
};
var $elm$url$Url$Parser$removeFinalEmpty = function (segments) {
	if (!segments.b) {
		return _List_Nil;
	} else {
		if ((segments.a === '') && (!segments.b.b)) {
			return _List_Nil;
		} else {
			var segment = segments.a;
			var rest = segments.b;
			return A2(
				$elm$core$List$cons,
				segment,
				$elm$url$Url$Parser$removeFinalEmpty(rest));
		}
	}
};
var $elm$url$Url$Parser$preparePath = function (path) {
	var _v0 = A2($elm$core$String$split, '/', path);
	if (_v0.b && (_v0.a === '')) {
		var segments = _v0.b;
		return $elm$url$Url$Parser$removeFinalEmpty(segments);
	} else {
		var segments = _v0;
		return $elm$url$Url$Parser$removeFinalEmpty(segments);
	}
};
var $elm$url$Url$Parser$addToParametersHelp = F2(
	function (value, maybeList) {
		if (maybeList.$ === 1) {
			return $elm$core$Maybe$Just(
				_List_fromArray(
					[value]));
		} else {
			var list = maybeList.a;
			return $elm$core$Maybe$Just(
				A2($elm$core$List$cons, value, list));
		}
	});
var $elm$url$Url$percentDecode = _Url_percentDecode;
var $elm$core$Basics$compare = _Utils_compare;
var $elm$core$Dict$get = F2(
	function (targetKey, dict) {
		get:
		while (true) {
			if (dict.$ === -2) {
				return $elm$core$Maybe$Nothing;
			} else {
				var key = dict.b;
				var value = dict.c;
				var left = dict.d;
				var right = dict.e;
				var _v1 = A2($elm$core$Basics$compare, targetKey, key);
				switch (_v1) {
					case 0:
						var $temp$targetKey = targetKey,
							$temp$dict = left;
						targetKey = $temp$targetKey;
						dict = $temp$dict;
						continue get;
					case 1:
						return $elm$core$Maybe$Just(value);
					default:
						var $temp$targetKey = targetKey,
							$temp$dict = right;
						targetKey = $temp$targetKey;
						dict = $temp$dict;
						continue get;
				}
			}
		}
	});
var $elm$core$Dict$Black = 1;
var $elm$core$Dict$RBNode_elm_builtin = F5(
	function (a, b, c, d, e) {
		return {$: -1, a: a, b: b, c: c, d: d, e: e};
	});
var $elm$core$Dict$Red = 0;
var $elm$core$Dict$balance = F5(
	function (color, key, value, left, right) {
		if ((right.$ === -1) && (!right.a)) {
			var _v1 = right.a;
			var rK = right.b;
			var rV = right.c;
			var rLeft = right.d;
			var rRight = right.e;
			if ((left.$ === -1) && (!left.a)) {
				var _v3 = left.a;
				var lK = left.b;
				var lV = left.c;
				var lLeft = left.d;
				var lRight = left.e;
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					0,
					key,
					value,
					A5($elm$core$Dict$RBNode_elm_builtin, 1, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, 1, rK, rV, rLeft, rRight));
			} else {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					color,
					rK,
					rV,
					A5($elm$core$Dict$RBNode_elm_builtin, 0, key, value, left, rLeft),
					rRight);
			}
		} else {
			if ((((left.$ === -1) && (!left.a)) && (left.d.$ === -1)) && (!left.d.a)) {
				var _v5 = left.a;
				var lK = left.b;
				var lV = left.c;
				var _v6 = left.d;
				var _v7 = _v6.a;
				var llK = _v6.b;
				var llV = _v6.c;
				var llLeft = _v6.d;
				var llRight = _v6.e;
				var lRight = left.e;
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					0,
					lK,
					lV,
					A5($elm$core$Dict$RBNode_elm_builtin, 1, llK, llV, llLeft, llRight),
					A5($elm$core$Dict$RBNode_elm_builtin, 1, key, value, lRight, right));
			} else {
				return A5($elm$core$Dict$RBNode_elm_builtin, color, key, value, left, right);
			}
		}
	});
var $elm$core$Dict$insertHelp = F3(
	function (key, value, dict) {
		if (dict.$ === -2) {
			return A5($elm$core$Dict$RBNode_elm_builtin, 0, key, value, $elm$core$Dict$RBEmpty_elm_builtin, $elm$core$Dict$RBEmpty_elm_builtin);
		} else {
			var nColor = dict.a;
			var nKey = dict.b;
			var nValue = dict.c;
			var nLeft = dict.d;
			var nRight = dict.e;
			var _v1 = A2($elm$core$Basics$compare, key, nKey);
			switch (_v1) {
				case 0:
					return A5(
						$elm$core$Dict$balance,
						nColor,
						nKey,
						nValue,
						A3($elm$core$Dict$insertHelp, key, value, nLeft),
						nRight);
				case 1:
					return A5($elm$core$Dict$RBNode_elm_builtin, nColor, nKey, value, nLeft, nRight);
				default:
					return A5(
						$elm$core$Dict$balance,
						nColor,
						nKey,
						nValue,
						nLeft,
						A3($elm$core$Dict$insertHelp, key, value, nRight));
			}
		}
	});
var $elm$core$Dict$insert = F3(
	function (key, value, dict) {
		var _v0 = A3($elm$core$Dict$insertHelp, key, value, dict);
		if ((_v0.$ === -1) && (!_v0.a)) {
			var _v1 = _v0.a;
			var k = _v0.b;
			var v = _v0.c;
			var l = _v0.d;
			var r = _v0.e;
			return A5($elm$core$Dict$RBNode_elm_builtin, 1, k, v, l, r);
		} else {
			var x = _v0;
			return x;
		}
	});
var $elm$core$Dict$getMin = function (dict) {
	getMin:
	while (true) {
		if ((dict.$ === -1) && (dict.d.$ === -1)) {
			var left = dict.d;
			var $temp$dict = left;
			dict = $temp$dict;
			continue getMin;
		} else {
			return dict;
		}
	}
};
var $elm$core$Dict$moveRedLeft = function (dict) {
	if (((dict.$ === -1) && (dict.d.$ === -1)) && (dict.e.$ === -1)) {
		if ((dict.e.d.$ === -1) && (!dict.e.d.a)) {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v1 = dict.d;
			var lClr = _v1.a;
			var lK = _v1.b;
			var lV = _v1.c;
			var lLeft = _v1.d;
			var lRight = _v1.e;
			var _v2 = dict.e;
			var rClr = _v2.a;
			var rK = _v2.b;
			var rV = _v2.c;
			var rLeft = _v2.d;
			var _v3 = rLeft.a;
			var rlK = rLeft.b;
			var rlV = rLeft.c;
			var rlL = rLeft.d;
			var rlR = rLeft.e;
			var rRight = _v2.e;
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				0,
				rlK,
				rlV,
				A5(
					$elm$core$Dict$RBNode_elm_builtin,
					1,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, 0, lK, lV, lLeft, lRight),
					rlL),
				A5($elm$core$Dict$RBNode_elm_builtin, 1, rK, rV, rlR, rRight));
		} else {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v4 = dict.d;
			var lClr = _v4.a;
			var lK = _v4.b;
			var lV = _v4.c;
			var lLeft = _v4.d;
			var lRight = _v4.e;
			var _v5 = dict.e;
			var rClr = _v5.a;
			var rK = _v5.b;
			var rV = _v5.c;
			var rLeft = _v5.d;
			var rRight = _v5.e;
			if (clr === 1) {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					1,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, 0, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, 0, rK, rV, rLeft, rRight));
			} else {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					1,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, 0, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, 0, rK, rV, rLeft, rRight));
			}
		}
	} else {
		return dict;
	}
};
var $elm$core$Dict$moveRedRight = function (dict) {
	if (((dict.$ === -1) && (dict.d.$ === -1)) && (dict.e.$ === -1)) {
		if ((dict.d.d.$ === -1) && (!dict.d.d.a)) {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v1 = dict.d;
			var lClr = _v1.a;
			var lK = _v1.b;
			var lV = _v1.c;
			var _v2 = _v1.d;
			var _v3 = _v2.a;
			var llK = _v2.b;
			var llV = _v2.c;
			var llLeft = _v2.d;
			var llRight = _v2.e;
			var lRight = _v1.e;
			var _v4 = dict.e;
			var rClr = _v4.a;
			var rK = _v4.b;
			var rV = _v4.c;
			var rLeft = _v4.d;
			var rRight = _v4.e;
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				0,
				lK,
				lV,
				A5($elm$core$Dict$RBNode_elm_builtin, 1, llK, llV, llLeft, llRight),
				A5(
					$elm$core$Dict$RBNode_elm_builtin,
					1,
					k,
					v,
					lRight,
					A5($elm$core$Dict$RBNode_elm_builtin, 0, rK, rV, rLeft, rRight)));
		} else {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v5 = dict.d;
			var lClr = _v5.a;
			var lK = _v5.b;
			var lV = _v5.c;
			var lLeft = _v5.d;
			var lRight = _v5.e;
			var _v6 = dict.e;
			var rClr = _v6.a;
			var rK = _v6.b;
			var rV = _v6.c;
			var rLeft = _v6.d;
			var rRight = _v6.e;
			if (clr === 1) {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					1,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, 0, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, 0, rK, rV, rLeft, rRight));
			} else {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					1,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, 0, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, 0, rK, rV, rLeft, rRight));
			}
		}
	} else {
		return dict;
	}
};
var $elm$core$Dict$removeHelpPrepEQGT = F7(
	function (targetKey, dict, color, key, value, left, right) {
		if ((left.$ === -1) && (!left.a)) {
			var _v1 = left.a;
			var lK = left.b;
			var lV = left.c;
			var lLeft = left.d;
			var lRight = left.e;
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				color,
				lK,
				lV,
				lLeft,
				A5($elm$core$Dict$RBNode_elm_builtin, 0, key, value, lRight, right));
		} else {
			_v2$2:
			while (true) {
				if ((right.$ === -1) && (right.a === 1)) {
					if (right.d.$ === -1) {
						if (right.d.a === 1) {
							var _v3 = right.a;
							var _v4 = right.d;
							var _v5 = _v4.a;
							return $elm$core$Dict$moveRedRight(dict);
						} else {
							break _v2$2;
						}
					} else {
						var _v6 = right.a;
						var _v7 = right.d;
						return $elm$core$Dict$moveRedRight(dict);
					}
				} else {
					break _v2$2;
				}
			}
			return dict;
		}
	});
var $elm$core$Dict$removeMin = function (dict) {
	if ((dict.$ === -1) && (dict.d.$ === -1)) {
		var color = dict.a;
		var key = dict.b;
		var value = dict.c;
		var left = dict.d;
		var lColor = left.a;
		var lLeft = left.d;
		var right = dict.e;
		if (lColor === 1) {
			if ((lLeft.$ === -1) && (!lLeft.a)) {
				var _v3 = lLeft.a;
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					color,
					key,
					value,
					$elm$core$Dict$removeMin(left),
					right);
			} else {
				var _v4 = $elm$core$Dict$moveRedLeft(dict);
				if (_v4.$ === -1) {
					var nColor = _v4.a;
					var nKey = _v4.b;
					var nValue = _v4.c;
					var nLeft = _v4.d;
					var nRight = _v4.e;
					return A5(
						$elm$core$Dict$balance,
						nColor,
						nKey,
						nValue,
						$elm$core$Dict$removeMin(nLeft),
						nRight);
				} else {
					return $elm$core$Dict$RBEmpty_elm_builtin;
				}
			}
		} else {
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				color,
				key,
				value,
				$elm$core$Dict$removeMin(left),
				right);
		}
	} else {
		return $elm$core$Dict$RBEmpty_elm_builtin;
	}
};
var $elm$core$Dict$removeHelp = F2(
	function (targetKey, dict) {
		if (dict.$ === -2) {
			return $elm$core$Dict$RBEmpty_elm_builtin;
		} else {
			var color = dict.a;
			var key = dict.b;
			var value = dict.c;
			var left = dict.d;
			var right = dict.e;
			if (_Utils_cmp(targetKey, key) < 0) {
				if ((left.$ === -1) && (left.a === 1)) {
					var _v4 = left.a;
					var lLeft = left.d;
					if ((lLeft.$ === -1) && (!lLeft.a)) {
						var _v6 = lLeft.a;
						return A5(
							$elm$core$Dict$RBNode_elm_builtin,
							color,
							key,
							value,
							A2($elm$core$Dict$removeHelp, targetKey, left),
							right);
					} else {
						var _v7 = $elm$core$Dict$moveRedLeft(dict);
						if (_v7.$ === -1) {
							var nColor = _v7.a;
							var nKey = _v7.b;
							var nValue = _v7.c;
							var nLeft = _v7.d;
							var nRight = _v7.e;
							return A5(
								$elm$core$Dict$balance,
								nColor,
								nKey,
								nValue,
								A2($elm$core$Dict$removeHelp, targetKey, nLeft),
								nRight);
						} else {
							return $elm$core$Dict$RBEmpty_elm_builtin;
						}
					}
				} else {
					return A5(
						$elm$core$Dict$RBNode_elm_builtin,
						color,
						key,
						value,
						A2($elm$core$Dict$removeHelp, targetKey, left),
						right);
				}
			} else {
				return A2(
					$elm$core$Dict$removeHelpEQGT,
					targetKey,
					A7($elm$core$Dict$removeHelpPrepEQGT, targetKey, dict, color, key, value, left, right));
			}
		}
	});
var $elm$core$Dict$removeHelpEQGT = F2(
	function (targetKey, dict) {
		if (dict.$ === -1) {
			var color = dict.a;
			var key = dict.b;
			var value = dict.c;
			var left = dict.d;
			var right = dict.e;
			if (_Utils_eq(targetKey, key)) {
				var _v1 = $elm$core$Dict$getMin(right);
				if (_v1.$ === -1) {
					var minKey = _v1.b;
					var minValue = _v1.c;
					return A5(
						$elm$core$Dict$balance,
						color,
						minKey,
						minValue,
						left,
						$elm$core$Dict$removeMin(right));
				} else {
					return $elm$core$Dict$RBEmpty_elm_builtin;
				}
			} else {
				return A5(
					$elm$core$Dict$balance,
					color,
					key,
					value,
					left,
					A2($elm$core$Dict$removeHelp, targetKey, right));
			}
		} else {
			return $elm$core$Dict$RBEmpty_elm_builtin;
		}
	});
var $elm$core$Dict$remove = F2(
	function (key, dict) {
		var _v0 = A2($elm$core$Dict$removeHelp, key, dict);
		if ((_v0.$ === -1) && (!_v0.a)) {
			var _v1 = _v0.a;
			var k = _v0.b;
			var v = _v0.c;
			var l = _v0.d;
			var r = _v0.e;
			return A5($elm$core$Dict$RBNode_elm_builtin, 1, k, v, l, r);
		} else {
			var x = _v0;
			return x;
		}
	});
var $elm$core$Dict$update = F3(
	function (targetKey, alter, dictionary) {
		var _v0 = alter(
			A2($elm$core$Dict$get, targetKey, dictionary));
		if (!_v0.$) {
			var value = _v0.a;
			return A3($elm$core$Dict$insert, targetKey, value, dictionary);
		} else {
			return A2($elm$core$Dict$remove, targetKey, dictionary);
		}
	});
var $elm$url$Url$Parser$addParam = F2(
	function (segment, dict) {
		var _v0 = A2($elm$core$String$split, '=', segment);
		if ((_v0.b && _v0.b.b) && (!_v0.b.b.b)) {
			var rawKey = _v0.a;
			var _v1 = _v0.b;
			var rawValue = _v1.a;
			var _v2 = $elm$url$Url$percentDecode(rawKey);
			if (_v2.$ === 1) {
				return dict;
			} else {
				var key = _v2.a;
				var _v3 = $elm$url$Url$percentDecode(rawValue);
				if (_v3.$ === 1) {
					return dict;
				} else {
					var value = _v3.a;
					return A3(
						$elm$core$Dict$update,
						key,
						$elm$url$Url$Parser$addToParametersHelp(value),
						dict);
				}
			}
		} else {
			return dict;
		}
	});
var $elm$url$Url$Parser$prepareQuery = function (maybeQuery) {
	if (maybeQuery.$ === 1) {
		return $elm$core$Dict$empty;
	} else {
		var qry = maybeQuery.a;
		return A3(
			$elm$core$List$foldr,
			$elm$url$Url$Parser$addParam,
			$elm$core$Dict$empty,
			A2($elm$core$String$split, '&', qry));
	}
};
var $elm$url$Url$Parser$parse = F2(
	function (_v0, url) {
		var parser = _v0;
		return $elm$url$Url$Parser$getFirstMatch(
			parser(
				A5(
					$elm$url$Url$Parser$State,
					_List_Nil,
					$elm$url$Url$Parser$preparePath(url.h3),
					$elm$url$Url$Parser$prepareQuery(url.h7),
					url.hn,
					$elm$core$Basics$identity)));
	});
var $author$project$Page$AccountPage = function (a) {
	return {$: 5, a: a};
};
var $author$project$Page$AliasPage = function (a) {
	return {$: 6, a: a};
};
var $author$project$Page$DetailPage = function (a) {
	return {$: 11, a: a};
};
var $author$project$Page$NewInvitePage = {$: 3};
var $author$project$Page$OpenDetailPage = F2(
	function (a, b) {
		return {$: 12, a: a, b: b};
	});
var $author$project$Page$OpenSharePage = function (a) {
	return {$: 9, a: a};
};
var $author$project$Page$RegisterPage = {$: 2};
var $author$project$Page$SettingsPage = {$: 10};
var $author$project$Page$SharePage = {$: 8};
var $author$project$Page$UploadPage = {$: 7};
var $elm$url$Url$Parser$Parser = $elm$core$Basics$identity;
var $elm$url$Url$Parser$custom = F2(
	function (tipe, stringToSomething) {
		return function (_v0) {
			var visited = _v0.at;
			var unvisited = _v0.ac;
			var params = _v0.an;
			var frag = _v0.aj;
			var value = _v0.eG;
			if (!unvisited.b) {
				return _List_Nil;
			} else {
				var next = unvisited.a;
				var rest = unvisited.b;
				var _v2 = stringToSomething(next);
				if (!_v2.$) {
					var nextValue = _v2.a;
					return _List_fromArray(
						[
							A5(
							$elm$url$Url$Parser$State,
							A2($elm$core$List$cons, next, visited),
							rest,
							params,
							frag,
							value(nextValue))
						]);
				} else {
					return _List_Nil;
				}
			}
		};
	});
var $elm$url$Url$Parser$int = A2($elm$url$Url$Parser$custom, 'NUMBER', $elm$core$String$toInt);
var $elm$url$Url$Parser$Internal$Parser = $elm$core$Basics$identity;
var $elm$url$Url$Parser$Query$custom = F2(
	function (key, func) {
		return function (dict) {
			return func(
				A2(
					$elm$core$Maybe$withDefault,
					_List_Nil,
					A2($elm$core$Dict$get, key, dict)));
		};
	});
var $elm$url$Url$Parser$Query$int = function (key) {
	return A2(
		$elm$url$Url$Parser$Query$custom,
		key,
		function (stringList) {
			if (stringList.b && (!stringList.b.b)) {
				var str = stringList.a;
				return $elm$core$String$toInt(str);
			} else {
				return $elm$core$Maybe$Nothing;
			}
		});
};
var $elm$url$Url$Parser$Query$map = F2(
	function (func, _v0) {
		var a = _v0;
		return function (dict) {
			return func(
				a(dict));
		};
	});
var $author$project$Util$Maybe$nonEmpty = function (ma) {
	return !_Utils_eq(ma, $elm$core$Maybe$Nothing);
};
var $elm$url$Url$Parser$Query$string = function (key) {
	return A2(
		$elm$url$Url$Parser$Query$custom,
		key,
		function (stringList) {
			if (stringList.b && (!stringList.b.b)) {
				var str = stringList.a;
				return $elm$core$Maybe$Just(str);
			} else {
				return $elm$core$Maybe$Nothing;
			}
		});
};
var $author$project$Page$loginPageOAuthQuery = A2(
	$elm$url$Url$Parser$Query$map,
	$author$project$Util$Maybe$nonEmpty,
	$elm$url$Url$Parser$Query$string('oauth'));
var $author$project$Page$loginPageReferrerQuery = $elm$url$Url$Parser$Query$string('r');
var $elm$url$Url$Parser$Query$map2 = F3(
	function (func, _v0, _v1) {
		var a = _v0;
		var b = _v1;
		return function (dict) {
			return A2(
				func,
				a(dict),
				b(dict));
		};
	});
var $elm$core$Tuple$pair = F2(
	function (a, b) {
		return _Utils_Tuple2(a, b);
	});
var $author$project$Page$loginPageParser = A3($elm$url$Url$Parser$Query$map2, $elm$core$Tuple$pair, $author$project$Page$loginPageReferrerQuery, $author$project$Page$loginPageOAuthQuery);
var $elm$url$Url$Parser$mapState = F2(
	function (func, _v0) {
		var visited = _v0.at;
		var unvisited = _v0.ac;
		var params = _v0.an;
		var frag = _v0.aj;
		var value = _v0.eG;
		return A5(
			$elm$url$Url$Parser$State,
			visited,
			unvisited,
			params,
			frag,
			func(value));
	});
var $elm$url$Url$Parser$map = F2(
	function (subValue, _v0) {
		var parseArg = _v0;
		return function (_v1) {
			var visited = _v1.at;
			var unvisited = _v1.ac;
			var params = _v1.an;
			var frag = _v1.aj;
			var value = _v1.eG;
			return A2(
				$elm$core$List$map,
				$elm$url$Url$Parser$mapState(value),
				parseArg(
					A5($elm$url$Url$Parser$State, visited, unvisited, params, frag, subValue)));
		};
	});
var $elm$core$List$concatMap = F2(
	function (f, list) {
		return $elm$core$List$concat(
			A2($elm$core$List$map, f, list));
	});
var $elm$url$Url$Parser$oneOf = function (parsers) {
	return function (state) {
		return A2(
			$elm$core$List$concatMap,
			function (_v0) {
				var parser = _v0;
				return parser(state);
			},
			parsers);
	};
};
var $author$project$Page$pathPrefix = 'app';
var $elm$url$Url$Parser$query = function (_v0) {
	var queryParser = _v0;
	return function (_v1) {
		var visited = _v1.at;
		var unvisited = _v1.ac;
		var params = _v1.an;
		var frag = _v1.aj;
		var value = _v1.eG;
		return _List_fromArray(
			[
				A5(
				$elm$url$Url$Parser$State,
				visited,
				unvisited,
				params,
				frag,
				value(
					queryParser(params)))
			]);
	};
};
var $elm$url$Url$Parser$slash = F2(
	function (_v0, _v1) {
		var parseBefore = _v0;
		var parseAfter = _v1;
		return function (state) {
			return A2(
				$elm$core$List$concatMap,
				parseAfter,
				parseBefore(state));
		};
	});
var $elm$url$Url$Parser$questionMark = F2(
	function (parser, queryParser) {
		return A2(
			$elm$url$Url$Parser$slash,
			parser,
			$elm$url$Url$Parser$query(queryParser));
	});
var $elm$url$Url$Parser$s = function (str) {
	return function (_v0) {
		var visited = _v0.at;
		var unvisited = _v0.ac;
		var params = _v0.an;
		var frag = _v0.aj;
		var value = _v0.eG;
		if (!unvisited.b) {
			return _List_Nil;
		} else {
			var next = unvisited.a;
			var rest = unvisited.b;
			return _Utils_eq(next, str) ? _List_fromArray(
				[
					A5(
					$elm$url$Url$Parser$State,
					A2($elm$core$List$cons, next, visited),
					rest,
					params,
					frag,
					value)
				]) : _List_Nil;
		}
	};
};
var $elm$url$Url$Parser$string = A2($elm$url$Url$Parser$custom, 'STRING', $elm$core$Maybe$Just);
var $elm$url$Url$Parser$top = function (state) {
	return _List_fromArray(
		[state]);
};
var $author$project$Page$parser = $elm$url$Url$Parser$oneOf(
	_List_fromArray(
		[
			A2($elm$url$Url$Parser$map, $author$project$Page$HomePage, $elm$url$Url$Parser$top),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$HomePage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('home'))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$LoginPage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				A2(
					$elm$url$Url$Parser$questionMark,
					$elm$url$Url$Parser$s('login'),
					$author$project$Page$loginPageParser))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$RegisterPage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('register'))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$NewInvitePage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('newinvite'))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$InfoPage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				A2(
					$elm$url$Url$Parser$slash,
					$elm$url$Url$Parser$s('info'),
					$elm$url$Url$Parser$int))),
			A2(
			$elm$url$Url$Parser$map,
			function (s) {
				return $author$project$Page$AccountPage(
					$elm$core$Maybe$Just(s));
			},
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				A2(
					$elm$url$Url$Parser$slash,
					$elm$url$Url$Parser$s('account'),
					$elm$url$Url$Parser$string))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$AccountPage($elm$core$Maybe$Nothing),
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('account'))),
			A2(
			$elm$url$Url$Parser$map,
			function (s) {
				return $author$project$Page$AliasPage(
					$elm$core$Maybe$Just(s));
			},
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				A2(
					$elm$url$Url$Parser$slash,
					$elm$url$Url$Parser$s('alias'),
					$elm$url$Url$Parser$string))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$AliasPage($elm$core$Maybe$Nothing),
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('alias'))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$UploadPage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('uploads'))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$DetailPage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				A2(
					$elm$url$Url$Parser$slash,
					$elm$url$Url$Parser$s('upload'),
					$elm$url$Url$Parser$string))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$OpenSharePage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				A2(
					$elm$url$Url$Parser$slash,
					$elm$url$Url$Parser$s('share'),
					$elm$url$Url$Parser$string))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$SharePage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('share'))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$SettingsPage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				$elm$url$Url$Parser$s('settings'))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Page$OpenDetailPage,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s($author$project$Page$pathPrefix),
				A2(
					$elm$url$Url$Parser$slash,
					$elm$url$Url$Parser$s('open'),
					A2(
						$elm$url$Url$Parser$questionMark,
						$elm$url$Url$Parser$string,
						$elm$url$Url$Parser$Query$int('view')))))
		]));
var $author$project$Page$fromUrl = function (url) {
	return A2($elm$url$Url$Parser$parse, $author$project$Page$parser, url);
};
var $elm$url$Url$addPort = F2(
	function (maybePort, starter) {
		if (maybePort.$ === 1) {
			return starter;
		} else {
			var port_ = maybePort.a;
			return starter + (':' + $elm$core$String$fromInt(port_));
		}
	});
var $elm$url$Url$addPrefixed = F3(
	function (prefix, maybeSegment, starter) {
		if (maybeSegment.$ === 1) {
			return starter;
		} else {
			var segment = maybeSegment.a;
			return _Utils_ap(
				starter,
				_Utils_ap(prefix, segment));
		}
	});
var $elm$url$Url$toString = function (url) {
	var http = function () {
		var _v0 = url.f9;
		if (!_v0) {
			return 'http://';
		} else {
			return 'https://';
		}
	}();
	return A3(
		$elm$url$Url$addPrefixed,
		'#',
		url.hn,
		A3(
			$elm$url$Url$addPrefixed,
			'?',
			url.h7,
			_Utils_ap(
				A2(
					$elm$url$Url$addPort,
					url.f5,
					_Utils_ap(http, url.fo)),
				url.h3)));
};
var $author$project$App$Data$initBaseUrl = F2(
	function (url, flags_) {
		var cfg = flags_.b;
		var baseUrl = (cfg.c === '') ? $elm$url$Url$toString(
			_Utils_update(
				url,
				{hn: $elm$core$Maybe$Nothing, h3: '', h7: $elm$core$Maybe$Nothing})) : cfg.c;
		var cfgNew = _Utils_update(
			cfg,
			{c: baseUrl});
		return _Utils_update(
			flags_,
			{b: cfgNew});
	});
var $author$project$App$Data$init = F3(
	function (key, url, flags_) {
		var page = A2(
			$elm$core$Maybe$withDefault,
			$author$project$Page$HomePage,
			$author$project$Page$fromUrl(url));
		var flags = A2($author$project$App$Data$initBaseUrl, url, flags_);
		return {
			eL: $author$project$Page$Account$Data$emptyModel,
			eO: $author$project$Page$Alias$Data$emptyModel(flags),
			e6: $author$project$Page$Detail$Data$emptyModel,
			fg: flags,
			fn: $author$project$Page$Home$Data$emptyModel,
			ft: $author$project$Page$Info$Data$emptyModel,
			dH: key,
			fy: false,
			fG: $author$project$Page$Login$Data$empty,
			fN: false,
			fO: $author$project$Page$NewInvite$Data$emptyModel,
			fX: $author$project$Page$OpenDetail$Data$emptyModel,
			fY: $author$project$Page$OpenShare$Data$emptyModel,
			f$: page,
			gb: $author$project$Page$Register$Data$emptyModel,
			gl: $author$project$Page$Settings$Data$emptyModel,
			go: $author$project$Page$Share$Data$emptyModel(flags),
			eC: A2(
				$elm$core$Maybe$withDefault,
				0,
				A2($elm$core$Maybe$andThen, $author$project$Data$UiTheme$fromString, flags.eC)),
			gB: $author$project$Page$Upload$Data$emptyModel,
			eH: $author$project$Api$Model$VersionInfo$empty
		};
	});
var $author$project$Page$Account$Data$Init = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Alias$Data$Init = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Detail$Data$Init = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Login$Data$Init = {$: 5};
var $author$project$Page$OpenDetail$Data$Init = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Settings$Data$Init = {$: 0};
var $author$project$Page$Upload$Data$Init = {$: 3};
var $author$project$Data$InitialView$Cards = 1;
var $author$project$Data$InitialView$Zoom = 2;
var $author$project$Data$InitialView$all = _List_fromArray(
	[0, 1, 2]);
var $author$project$Data$InitialView$toInt = function (view) {
	switch (view) {
		case 0:
			return 1;
		case 1:
			return 2;
		default:
			return 3;
	}
};
var $author$project$Data$InitialView$fromInt = function (n) {
	return $elm$core$List$head(
		A2(
			$elm$core$List$filter,
			function (e) {
				return _Utils_eq(
					$author$project$Data$InitialView$toInt(e),
					n);
			},
			$author$project$Data$InitialView$all));
};
var $author$project$Data$InitialView$get = function (n) {
	return A2(
		$elm$core$Maybe$withDefault,
		$author$project$Data$InitialView$default,
		A2($elm$core$Maybe$andThen, $author$project$Data$InitialView$fromInt, n));
};
var $elm$core$Platform$Cmd$none = $elm$core$Platform$Cmd$batch(_List_Nil);
var $author$project$App$Data$AccountMsg = function (a) {
	return {$: 12, a: a};
};
var $elm$core$Platform$Cmd$map = _Platform_map;
var $author$project$Page$Account$Data$DeleteResp = function (a) {
	return {$: 7, a: a};
};
var $author$project$Page$Account$Data$LoadResp = function (a) {
	return {$: 2, a: a};
};
var $author$project$Page$Account$Data$SaveResp = function (a) {
	return {$: 6, a: a};
};
var $author$project$Page$Account$Data$SearchResp = function (a) {
	return {$: 1, a: a};
};
var $elm$http$Http$Header = F2(
	function (a, b) {
		return {$: 0, a: a, b: b};
	});
var $elm$http$Http$header = $elm$http$Http$Header;
var $elm$http$Http$Request = function (a) {
	return {$: 1, a: a};
};
var $elm$http$Http$State = F2(
	function (reqs, subs) {
		return {gd: reqs, gu: subs};
	});
var $elm$http$Http$init = $elm$core$Task$succeed(
	A2($elm$http$Http$State, $elm$core$Dict$empty, _List_Nil));
var $elm$http$Http$BadStatus_ = F2(
	function (a, b) {
		return {$: 3, a: a, b: b};
	});
var $elm$http$Http$BadUrl_ = function (a) {
	return {$: 0, a: a};
};
var $elm$http$Http$GoodStatus_ = F2(
	function (a, b) {
		return {$: 4, a: a, b: b};
	});
var $elm$http$Http$NetworkError_ = {$: 2};
var $elm$http$Http$Receiving = function (a) {
	return {$: 1, a: a};
};
var $elm$http$Http$Sending = function (a) {
	return {$: 0, a: a};
};
var $elm$http$Http$Timeout_ = {$: 1};
var $elm$core$Maybe$isJust = function (maybe) {
	if (!maybe.$) {
		return true;
	} else {
		return false;
	}
};
var $elm$core$Platform$sendToSelf = _Platform_sendToSelf;
var $elm$core$Process$kill = _Scheduler_kill;
var $elm$core$Process$spawn = _Scheduler_spawn;
var $elm$http$Http$updateReqs = F3(
	function (router, cmds, reqs) {
		updateReqs:
		while (true) {
			if (!cmds.b) {
				return $elm$core$Task$succeed(reqs);
			} else {
				var cmd = cmds.a;
				var otherCmds = cmds.b;
				if (!cmd.$) {
					var tracker = cmd.a;
					var _v2 = A2($elm$core$Dict$get, tracker, reqs);
					if (_v2.$ === 1) {
						var $temp$router = router,
							$temp$cmds = otherCmds,
							$temp$reqs = reqs;
						router = $temp$router;
						cmds = $temp$cmds;
						reqs = $temp$reqs;
						continue updateReqs;
					} else {
						var pid = _v2.a;
						return A2(
							$elm$core$Task$andThen,
							function (_v3) {
								return A3(
									$elm$http$Http$updateReqs,
									router,
									otherCmds,
									A2($elm$core$Dict$remove, tracker, reqs));
							},
							$elm$core$Process$kill(pid));
					}
				} else {
					var req = cmd.a;
					return A2(
						$elm$core$Task$andThen,
						function (pid) {
							var _v4 = req.A;
							if (_v4.$ === 1) {
								return A3($elm$http$Http$updateReqs, router, otherCmds, reqs);
							} else {
								var tracker = _v4.a;
								return A3(
									$elm$http$Http$updateReqs,
									router,
									otherCmds,
									A3($elm$core$Dict$insert, tracker, pid, reqs));
							}
						},
						$elm$core$Process$spawn(
							A3(
								_Http_toTask,
								router,
								$elm$core$Platform$sendToApp(router),
								req)));
				}
			}
		}
	});
var $elm$http$Http$onEffects = F4(
	function (router, cmds, subs, state) {
		return A2(
			$elm$core$Task$andThen,
			function (reqs) {
				return $elm$core$Task$succeed(
					A2($elm$http$Http$State, reqs, subs));
			},
			A3($elm$http$Http$updateReqs, router, cmds, state.gd));
	});
var $elm$core$List$maybeCons = F3(
	function (f, mx, xs) {
		var _v0 = f(mx);
		if (!_v0.$) {
			var x = _v0.a;
			return A2($elm$core$List$cons, x, xs);
		} else {
			return xs;
		}
	});
var $elm$core$List$filterMap = F2(
	function (f, xs) {
		return A3(
			$elm$core$List$foldr,
			$elm$core$List$maybeCons(f),
			_List_Nil,
			xs);
	});
var $elm$http$Http$maybeSend = F4(
	function (router, desiredTracker, progress, _v0) {
		var actualTracker = _v0.a;
		var toMsg = _v0.b;
		return _Utils_eq(desiredTracker, actualTracker) ? $elm$core$Maybe$Just(
			A2(
				$elm$core$Platform$sendToApp,
				router,
				toMsg(progress))) : $elm$core$Maybe$Nothing;
	});
var $elm$http$Http$onSelfMsg = F3(
	function (router, _v0, state) {
		var tracker = _v0.a;
		var progress = _v0.b;
		return A2(
			$elm$core$Task$andThen,
			function (_v1) {
				return $elm$core$Task$succeed(state);
			},
			$elm$core$Task$sequence(
				A2(
					$elm$core$List$filterMap,
					A3($elm$http$Http$maybeSend, router, tracker, progress),
					state.gu)));
	});
var $elm$http$Http$Cancel = function (a) {
	return {$: 0, a: a};
};
var $elm$http$Http$cmdMap = F2(
	function (func, cmd) {
		if (!cmd.$) {
			var tracker = cmd.a;
			return $elm$http$Http$Cancel(tracker);
		} else {
			var r = cmd.a;
			return $elm$http$Http$Request(
				{
					gU: r.gU,
					g: r.g,
					e: A2(_Http_mapExpect, func, r.e),
					fk: r.fk,
					hL: r.hL,
					iE: r.iE,
					A: r.A,
					d: r.d
				});
		}
	});
var $elm$http$Http$MySub = F2(
	function (a, b) {
		return {$: 0, a: a, b: b};
	});
var $elm$http$Http$subMap = F2(
	function (func, _v0) {
		var tracker = _v0.a;
		var toMsg = _v0.b;
		return A2(
			$elm$http$Http$MySub,
			tracker,
			A2($elm$core$Basics$composeR, toMsg, func));
	});
_Platform_effectManagers['Http'] = _Platform_createManager($elm$http$Http$init, $elm$http$Http$onEffects, $elm$http$Http$onSelfMsg, $elm$http$Http$cmdMap, $elm$http$Http$subMap);
var $elm$http$Http$command = _Platform_leaf('Http');
var $elm$http$Http$subscription = _Platform_leaf('Http');
var $elm$http$Http$request = function (r) {
	return $elm$http$Http$command(
		$elm$http$Http$Request(
			{gU: false, g: r.g, e: r.e, fk: r.fk, hL: r.hL, iE: r.iE, A: r.A, d: r.d}));
};
var $author$project$Util$Http$authReq = function (req) {
	return $elm$http$Http$request(
		{
			g: req.g,
			e: req.e,
			fk: A2(
				$elm$core$List$cons,
				A2(
					$elm$http$Http$header,
					'Sharry-Auth',
					A2($elm$core$Maybe$withDefault, '', req.f.eB)),
				req.fk),
			hL: req.hL,
			iE: $elm$core$Maybe$Nothing,
			A: req.A,
			d: req.d
		});
};
var $author$project$Util$Http$authPost = function (req) {
	return $author$project$Util$Http$authReq(
		{f: req.f, g: req.g, e: req.e, fk: _List_Nil, hL: 'POST', A: $elm$core$Maybe$Nothing, d: req.d});
};
var $NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$custom = $elm$json$Json$Decode$map2($elm$core$Basics$apR);
var $NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required = F3(
	function (key, valDecoder, decoder) {
		return A2(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$custom,
			A2($elm$json$Json$Decode$field, key, valDecoder),
			decoder);
	});
var $elm$json$Json$Decode$string = _Json_decodeString;
var $author$project$Api$Model$BasicResult$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'message',
	$elm$json$Json$Decode$string,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'success',
		$elm$json$Json$Decode$bool,
		$elm$json$Json$Decode$succeed($author$project$Api$Model$BasicResult$BasicResult)));
var $elm$json$Json$Encode$bool = _Json_wrap;
var $elm$json$Json$Encode$null = _Json_encodeNull;
var $elm$json$Json$Encode$object = function (pairs) {
	return _Json_wrap(
		A3(
			$elm$core$List$foldl,
			F2(
				function (_v0, obj) {
					var k = _v0.a;
					var v = _v0.b;
					return A3(_Json_addField, k, v, obj);
				}),
			_Json_emptyObject(0),
			pairs));
};
var $elm$json$Json$Encode$string = _Json_wrap;
var $author$project$Api$Model$AccountCreate$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'login',
				$elm$json$Json$Encode$string(value.dK)),
				_Utils_Tuple2(
				'state',
				$elm$json$Json$Encode$string(value.ev)),
				_Utils_Tuple2(
				'admin',
				$elm$json$Json$Encode$bool(value.cK)),
				_Utils_Tuple2(
				'password',
				$elm$json$Json$Encode$string(value.d4)),
				_Utils_Tuple2(
				'email',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.c9))
			]));
};
var $elm$json$Json$Decode$decodeString = _Json_runOnString;
var $elm$http$Http$expectStringResponse = F2(
	function (toMsg, toResult) {
		return A3(
			_Http_expect,
			'',
			$elm$core$Basics$identity,
			A2($elm$core$Basics$composeR, toResult, toMsg));
	});
var $elm$core$Result$mapError = F2(
	function (f, result) {
		if (!result.$) {
			var v = result.a;
			return $elm$core$Result$Ok(v);
		} else {
			var e = result.a;
			return $elm$core$Result$Err(
				f(e));
		}
	});
var $elm$http$Http$BadBody = function (a) {
	return {$: 4, a: a};
};
var $elm$http$Http$BadStatus = function (a) {
	return {$: 3, a: a};
};
var $elm$http$Http$BadUrl = function (a) {
	return {$: 0, a: a};
};
var $elm$http$Http$NetworkError = {$: 2};
var $elm$http$Http$Timeout = {$: 1};
var $elm$http$Http$resolve = F2(
	function (toResult, response) {
		switch (response.$) {
			case 0:
				var url = response.a;
				return $elm$core$Result$Err(
					$elm$http$Http$BadUrl(url));
			case 1:
				return $elm$core$Result$Err($elm$http$Http$Timeout);
			case 2:
				return $elm$core$Result$Err($elm$http$Http$NetworkError);
			case 3:
				var metadata = response.a;
				return $elm$core$Result$Err(
					$elm$http$Http$BadStatus(metadata.iu));
			default:
				var body = response.b;
				return A2(
					$elm$core$Result$mapError,
					$elm$http$Http$BadBody,
					toResult(body));
		}
	});
var $elm$http$Http$expectJson = F2(
	function (toMsg, decoder) {
		return A2(
			$elm$http$Http$expectStringResponse,
			toMsg,
			$elm$http$Http$resolve(
				function (string) {
					return A2(
						$elm$core$Result$mapError,
						$elm$json$Json$Decode$errorToString,
						A2($elm$json$Json$Decode$decodeString, decoder, string));
				}));
	});
var $author$project$Api$Model$AuthResult$empty = {cK: false, hs: '', dU: '', iA: false, eB: $elm$core$Maybe$Nothing, eD: '', eE: 0};
var $author$project$Api$getAccount = function (flags) {
	return A2($elm$core$Maybe$withDefault, $author$project$Api$Model$AuthResult$empty, flags.f);
};
var $elm$http$Http$jsonBody = function (value) {
	return A2(
		_Http_pair,
		'application/json',
		A2($elm$json$Json$Encode$encode, 0, value));
};
var $author$project$Api$createAccount = F3(
	function (flags, input, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$AccountCreate$encode(input)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + '/api/v2/admin/account'
			});
	});
var $elm$http$Http$emptyBody = _Http_emptyBody;
var $author$project$Util$Http$authDelete = function (req) {
	return $author$project$Util$Http$authReq(
		{f: req.f, g: $elm$http$Http$emptyBody, e: req.e, fk: _List_Nil, hL: 'DELETE', A: $elm$core$Maybe$Nothing, d: req.d});
};
var $author$project$Api$deleteAccount = F3(
	function (flags, id, receive) {
		return $author$project$Util$Http$authDelete(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/admin/account/' + id)
			});
	});
var $author$project$Util$Http$errorToStringStatus = F2(
	function (error, statusString) {
		switch (error.$) {
			case 0:
				var url = error.a;
				return 'There is something wrong with this url: ' + url;
			case 1:
				return 'There was a network timeout.';
			case 2:
				return 'There was a network error.';
			case 3:
				var status = error.a;
				return statusString(status);
			default:
				var str = error.a;
				return 'There was an error decoding the response: ' + str;
		}
	});
var $author$project$Util$Http$errorToString = function (error) {
	var f = function (sc) {
		if (sc === 404) {
			return 'The requested resource doesn\'t exist.';
		} else {
			return 'There was an invalid response status: ' + $elm$core$String$fromInt(sc);
		}
	};
	return A2($author$project$Util$Http$errorToStringStatus, error, f);
};
var $author$project$Data$AccountState$fromString = function (str) {
	var _v0 = $elm$core$String$toLower(str);
	switch (_v0) {
		case 'active':
			return $elm$core$Maybe$Just(0);
		case 'disabled':
			return $elm$core$Maybe$Just(1);
		default:
			return $elm$core$Maybe$Nothing;
	}
};
var $author$project$Data$AccountState$fromStringDefault = F2(
	function (_default, str) {
		return A2(
			$elm$core$Maybe$withDefault,
			_default,
			$author$project$Data$AccountState$fromString(str));
	});
var $author$project$Data$AccountState$fromStringOrActive = function (str) {
	return A2($author$project$Data$AccountState$fromStringDefault, 0, str);
};
var $author$project$Comp$AccountForm$initModify = function (acc) {
	return _Utils_update(
		$author$project$Comp$AccountForm$initNew,
		{
			R: acc.cK,
			ag: acc.c9,
			V: $elm$core$Maybe$Just(acc),
			W: acc.dK,
			ab: $author$project$Data$AccountState$fromStringOrActive(acc.ev)
		});
};
var $author$project$Comp$AccountForm$init = function (ma) {
	return A2(
		$elm$core$Maybe$withDefault,
		$author$project$Comp$AccountForm$initNew,
		A2($elm$core$Maybe$map, $author$project$Comp$AccountForm$initModify, ma));
};
var $author$project$Util$Http$authGet = function (req) {
	return $author$project$Util$Http$authReq(
		{f: req.f, g: $elm$http$Http$emptyBody, e: req.e, fk: _List_Nil, hL: 'GET', A: $elm$core$Maybe$Nothing, d: req.d});
};
var $author$project$Api$Model$AccountList$AccountList = function (items) {
	return {dG: items};
};
var $author$project$Api$Model$AccountDetail$AccountDetail = function (id) {
	return function (login) {
		return function (source) {
			return function (state) {
				return function (admin) {
					return function (email) {
						return function (loginCount) {
							return function (shares) {
								return function (lastLogin) {
									return function (created) {
										return {cK: admin, c0: created, c9: email, hs: id, dJ: lastLogin, dK: login, dL: loginCount, el: shares, eu: source, ev: state};
									};
								};
							};
						};
					};
				};
			};
		};
	};
};
var $elm$json$Json$Decode$int = _Json_decodeInt;
var $elm$json$Json$Decode$oneOf = _Json_oneOf;
var $elm$json$Json$Decode$maybe = function (decoder) {
	return $elm$json$Json$Decode$oneOf(
		_List_fromArray(
			[
				A2($elm$json$Json$Decode$map, $elm$core$Maybe$Just, decoder),
				$elm$json$Json$Decode$succeed($elm$core$Maybe$Nothing)
			]));
};
var $elm$json$Json$Decode$decodeValue = _Json_run;
var $elm$json$Json$Decode$fail = _Json_fail;
var $elm$json$Json$Decode$null = _Json_decodeNull;
var $elm$json$Json$Decode$value = _Json_decodeValue;
var $NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optionalDecoder = F3(
	function (pathDecoder, valDecoder, fallback) {
		var nullOr = function (decoder) {
			return $elm$json$Json$Decode$oneOf(
				_List_fromArray(
					[
						decoder,
						$elm$json$Json$Decode$null(fallback)
					]));
		};
		var handleResult = function (input) {
			var _v0 = A2($elm$json$Json$Decode$decodeValue, pathDecoder, input);
			if (!_v0.$) {
				var rawValue = _v0.a;
				var _v1 = A2(
					$elm$json$Json$Decode$decodeValue,
					nullOr(valDecoder),
					rawValue);
				if (!_v1.$) {
					var finalResult = _v1.a;
					return $elm$json$Json$Decode$succeed(finalResult);
				} else {
					var finalErr = _v1.a;
					return $elm$json$Json$Decode$fail(
						$elm$json$Json$Decode$errorToString(finalErr));
				}
			} else {
				return $elm$json$Json$Decode$succeed(fallback);
			}
		};
		return A2($elm$json$Json$Decode$andThen, handleResult, $elm$json$Json$Decode$value);
	});
var $NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional = F4(
	function (key, valDecoder, fallback, decoder) {
		return A2(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$custom,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optionalDecoder,
				A2($elm$json$Json$Decode$field, key, $elm$json$Json$Decode$value),
				valDecoder,
				fallback),
			decoder);
	});
var $author$project$Api$Model$AccountDetail$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'created',
	$elm$json$Json$Decode$int,
	A4(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
		'lastLogin',
		$elm$json$Json$Decode$maybe($elm$json$Json$Decode$int),
		$elm$core$Maybe$Nothing,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'shares',
			$elm$json$Json$Decode$int,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
				'loginCount',
				$elm$json$Json$Decode$int,
				A4(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
					'email',
					$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
					$elm$core$Maybe$Nothing,
					A3(
						$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
						'admin',
						$elm$json$Json$Decode$bool,
						A3(
							$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
							'state',
							$elm$json$Json$Decode$string,
							A3(
								$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
								'source',
								$elm$json$Json$Decode$string,
								A3(
									$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
									'login',
									$elm$json$Json$Decode$string,
									A3(
										$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
										'id',
										$elm$json$Json$Decode$string,
										$elm$json$Json$Decode$succeed($author$project$Api$Model$AccountDetail$AccountDetail)))))))))));
var $elm$json$Json$Decode$list = _Json_decodeList;
var $author$project$Api$Model$AccountList$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'items',
	$elm$json$Json$Decode$list($author$project$Api$Model$AccountDetail$decoder),
	$elm$json$Json$Decode$succeed($author$project$Api$Model$AccountList$AccountList));
var $elm$url$Url$percentEncode = _Url_percentEncode;
var $author$project$Api$listAccounts = F3(
	function (flags, q, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AccountList$decoder),
				d: flags.b.c + ('/api/v2/admin/account?q=' + $elm$url$Url$percentEncode(q))
			});
	});
var $author$project$Api$loadAccount = F3(
	function (flags, id, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AccountDetail$decoder),
				d: flags.b.c + ('/api/v2/admin/account/' + id)
			});
	});
var $author$project$Api$Model$AccountModify$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'state',
				$elm$json$Json$Encode$string(value.ev)),
				_Utils_Tuple2(
				'admin',
				$elm$json$Json$Encode$bool(value.cK)),
				_Utils_Tuple2(
				'email',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.c9)),
				_Utils_Tuple2(
				'password',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.d4))
			]));
};
var $author$project$Api$modifyAccount = F4(
	function (flags, id, input, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$AccountModify$encode(input)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/admin/account/' + id)
			});
	});
var $elm$browser$Browser$Navigation$pushUrl = _Browser_pushUrl;
var $author$project$Page$set = F2(
	function (key, page) {
		return A2(
			$elm$browser$Browser$Navigation$pushUrl,
			key,
			$author$project$Page$pageToString(page));
	});
var $author$project$Comp$AccountForm$FormCancelled = {$: 2};
var $author$project$Comp$AccountForm$FormCreated = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$AccountForm$FormDelete = function (a) {
	return {$: 4, a: a};
};
var $author$project$Comp$AccountForm$FormModified = F2(
	function (a, b) {
		return {$: 0, a: a, b: b};
	});
var $author$project$Comp$AccountForm$FormNone = {$: 3};
var $author$project$Comp$AccountForm$isCreate = function (model) {
	return _Utils_eq(model.V, $elm$core$Maybe$Nothing);
};
var $author$project$Comp$AccountForm$formInvalid = function (model) {
	return $elm$core$String$isEmpty(model.W) || ($author$project$Comp$AccountForm$isCreate(model) && _Utils_eq(model.Z, $elm$core$Maybe$Nothing));
};
var $elm$core$String$trim = _String_trim;
var $author$project$Util$Maybe$fromString = function (str) {
	var s = $elm$core$String$trim(str);
	return (s === '') ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(str);
};
var $author$project$Data$AccountState$toString = function (state) {
	if (!state) {
		return 'Active';
	} else {
		return 'Disabled';
	}
};
var $author$project$Comp$FixedDropdown$ToggleMenu = {$: 1};
var $author$project$Util$List$findIndexed1 = F3(
	function (pred, list, index) {
		findIndexed1:
		while (true) {
			if (!list.b) {
				return $elm$core$Maybe$Nothing;
			} else {
				var x = list.a;
				var xs = list.b;
				if (pred(x)) {
					return $elm$core$Maybe$Just(
						_Utils_Tuple2(x, index));
				} else {
					var $temp$pred = pred,
						$temp$list = xs,
						$temp$index = index + 1;
					pred = $temp$pred;
					list = $temp$list;
					index = $temp$index;
					continue findIndexed1;
				}
			}
		}
	});
var $author$project$Util$List$findIndexed = F2(
	function (pred, list) {
		return A3($author$project$Util$List$findIndexed1, pred, list, 0);
	});
var $author$project$Util$List$find = F2(
	function (pred, list) {
		return A2(
			$elm$core$Maybe$map,
			$elm$core$Tuple$first,
			A2($author$project$Util$List$findIndexed, pred, list));
	});
var $author$project$Comp$FixedDropdown$isSelected = F2(
	function (model, item) {
		return _Utils_eq(
			model.cG,
			$elm$core$Maybe$Just(item.hs));
	});
var $author$project$Util$List$get = F2(
	function (list, index) {
		get:
		while (true) {
			if (index < 0) {
				return $elm$core$Maybe$Nothing;
			} else {
				if (!list.b) {
					return $elm$core$Maybe$Nothing;
				} else {
					var x = list.a;
					var xs = list.b;
					if (!index) {
						return $elm$core$Maybe$Just(x);
					} else {
						var $temp$list = xs,
							$temp$index = index - 1;
						list = $temp$list;
						index = $temp$index;
						continue get;
					}
				}
			}
		}
	});
var $author$project$Util$List$findNext = F2(
	function (pred, list) {
		return A2(
			$elm$core$Maybe$andThen,
			$author$project$Util$List$get(list),
			A2(
				$elm$core$Maybe$map,
				function (i) {
					return i + 1;
				},
				A2(
					$elm$core$Maybe$map,
					$elm$core$Tuple$second,
					A2($author$project$Util$List$findIndexed, pred, list))));
	});
var $author$project$Comp$FixedDropdown$moveNext = function (model) {
	var next = A2(
		$author$project$Util$List$findNext,
		$author$project$Comp$FixedDropdown$isSelected(model),
		model.h1);
	if (!next.$) {
		var n = next.a;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					k: true,
					cG: $elm$core$Maybe$Just(n.hs)
				}),
			$elm$core$Maybe$Nothing);
	} else {
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					k: true,
					cG: A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.hs;
						},
						$elm$core$List$head(model.h1))
				}),
			$elm$core$Maybe$Nothing);
	}
};
var $author$project$Util$List$findPrev = F2(
	function (pred, list) {
		return A2(
			$elm$core$Maybe$andThen,
			$author$project$Util$List$get(list),
			A2(
				$elm$core$Maybe$map,
				function (i) {
					return i - 1;
				},
				A2(
					$elm$core$Maybe$map,
					$elm$core$Tuple$second,
					A2($author$project$Util$List$findIndexed, pred, list))));
	});
var $author$project$Comp$FixedDropdown$movePrevious = function (model) {
	var prev = A2(
		$author$project$Util$List$findPrev,
		$author$project$Comp$FixedDropdown$isSelected(model),
		model.h1);
	if (!prev.$) {
		var p = prev.a;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					k: true,
					cG: $elm$core$Maybe$Just(p.hs)
				}),
			$elm$core$Maybe$Nothing);
	} else {
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					k: true,
					cG: A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.hs;
						},
						$elm$core$List$head(
							$elm$core$List$reverse(model.h1)))
				}),
			$elm$core$Maybe$Nothing);
	}
};
var $author$project$Comp$FixedDropdown$update = F2(
	function (msg, model) {
		update:
		while (true) {
			_v0$11:
			while (true) {
				switch (msg.$) {
					case 1:
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{k: !model.k}),
							$elm$core$Maybe$Nothing);
					case 0:
						var item = msg.a;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{k: false}),
							$elm$core$Maybe$Just(item.hs));
					default:
						if (!msg.a.$) {
							switch (msg.a.a.$) {
								case 5:
									var _v1 = msg.a.a;
									var $temp$msg = $author$project$Comp$FixedDropdown$ToggleMenu,
										$temp$model = model;
									msg = $temp$msg;
									model = $temp$model;
									continue update;
								case 4:
									var _v2 = msg.a.a;
									var selected = A2(
										$author$project$Util$List$find,
										$author$project$Comp$FixedDropdown$isSelected(model),
										model.h1);
									if (!selected.$) {
										var i = selected.a;
										return _Utils_Tuple2(
											_Utils_update(
												model,
												{k: false}),
											$elm$core$Maybe$Just(i.hs));
									} else {
										return _Utils_Tuple2(model, $elm$core$Maybe$Nothing);
									}
								case 0:
									var _v4 = msg.a.a;
									return $author$project$Comp$FixedDropdown$movePrevious(model);
								case 9:
									var _v5 = msg.a.a;
									return $author$project$Comp$FixedDropdown$movePrevious(model);
								case 12:
									var _v6 = msg.a.a;
									return $author$project$Comp$FixedDropdown$movePrevious(model);
								case 1:
									var _v7 = msg.a.a;
									return $author$project$Comp$FixedDropdown$moveNext(model);
								case 8:
									var _v8 = msg.a.a;
									return $author$project$Comp$FixedDropdown$moveNext(model);
								case 11:
									var _v9 = msg.a.a;
									return $author$project$Comp$FixedDropdown$moveNext(model);
								case 6:
									var _v10 = msg.a.a;
									return _Utils_Tuple2(
										_Utils_update(
											model,
											{k: false}),
										$elm$core$Maybe$Nothing);
								default:
									break _v0$11;
							}
						} else {
							break _v0$11;
						}
				}
			}
			return _Utils_Tuple2(model, $elm$core$Maybe$Nothing);
		}
	});
var $author$project$Comp$PasswordInput$update = F2(
	function (msg, model) {
		if (!msg.$) {
			var pw = msg.a;
			return _Utils_Tuple2(
				_Utils_update(
					model,
					{ir: !model.ir}),
				pw);
		} else {
			var str = msg.a;
			var pw = $author$project$Util$Maybe$fromString(str);
			return _Utils_Tuple2(model, pw);
		}
	});
var $author$project$Comp$AccountForm$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 0:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{W: str}),
					$author$project$Comp$AccountForm$FormNone);
			case 1:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							ag: $author$project$Util$Maybe$fromString(str)
						}),
					$author$project$Comp$AccountForm$FormNone);
			case 2:
				var lmsg = msg.a;
				var _v1 = A2($author$project$Comp$PasswordInput$update, lmsg, model.ci);
				var m = _v1.a;
				var pw = _v1.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{Z: pw, ci: m}),
					$author$project$Comp$AccountForm$FormNone);
			case 3:
				var lmsg = msg.a;
				var _v2 = A2($author$project$Comp$FixedDropdown$update, lmsg, model.cj);
				var m = _v2.a;
				var sel = _v2.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							ab: A2($elm$core$Maybe$withDefault, model.ab, sel),
							cj: m
						}),
					$author$project$Comp$AccountForm$FormNone);
			case 4:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{R: !model.R}),
					$author$project$Comp$AccountForm$FormNone);
			case 5:
				return _Utils_Tuple2(model, $author$project$Comp$AccountForm$FormCancelled);
			case 6:
				if ($author$project$Comp$AccountForm$formInvalid(model)) {
					return _Utils_Tuple2(model, $author$project$Comp$AccountForm$FormNone);
				} else {
					var _v3 = A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.hs;
						},
						model.V);
					if (!_v3.$) {
						var id = _v3.a;
						return _Utils_Tuple2(
							model,
							A2(
								$author$project$Comp$AccountForm$FormModified,
								id,
								{
									cK: model.R,
									c9: model.ag,
									d4: model.Z,
									ev: $author$project$Data$AccountState$toString(model.ab)
								}));
					} else {
						return _Utils_Tuple2(
							model,
							$author$project$Comp$AccountForm$FormCreated(
								{
									cK: model.R,
									c9: model.ag,
									dK: model.W,
									d4: A2($elm$core$Maybe$withDefault, '', model.Z),
									ev: $author$project$Data$AccountState$toString(model.ab)
								}));
					}
				}
			case 7:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{aR: true}),
					$author$project$Comp$AccountForm$FormNone);
			case 8:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{aR: false}),
					A2(
						$elm$core$Maybe$withDefault,
						$author$project$Comp$AccountForm$FormNone,
						A2(
							$elm$core$Maybe$map,
							$author$project$Comp$AccountForm$FormDelete,
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.hs;
								},
								model.V))));
			default:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{aR: false}),
					$author$project$Comp$AccountForm$FormNone);
		}
	});
var $author$project$Comp$AccountTable$update = F2(
	function (msg, model) {
		var acc = msg;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					cG: $elm$core$Maybe$Just(acc)
				}),
			$elm$core$Maybe$Just(acc));
	});
var $author$project$Page$Account$Update$update = F4(
	function (key, flags, msg, model) {
		switch (msg.$) {
			case 0:
				if (!msg.a.$) {
					var id = msg.a.a;
					var current = A2(
						$elm$core$Maybe$withDefault,
						false,
						A2(
							$elm$core$Maybe$map,
							$elm$core$Basics$eq(id),
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.hs;
								},
								model.cG)));
					return (id === 'new') ? _Utils_Tuple2(
						_Utils_update(
							model,
							{fh: $author$project$Comp$AccountForm$initNew, cG: $elm$core$Maybe$Nothing}),
						$elm$core$Platform$Cmd$none) : (current ? _Utils_Tuple2(model, $elm$core$Platform$Cmd$none) : _Utils_Tuple2(
						model,
						A3($author$project$Api$loadAccount, flags, id, $author$project$Page$Account$Data$LoadResp)));
				} else {
					var _v1 = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{fh: $author$project$Comp$AccountForm$initNew, cG: $elm$core$Maybe$Nothing}),
						A3($author$project$Api$listAccounts, flags, model.h7, $author$project$Page$Account$Data$SearchResp));
				}
			case 1:
				if (!msg.a.$) {
					var list = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{gi: list.dG}),
						$elm$core$Platform$Cmd$none);
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 2:
				if (!msg.a.$) {
					var acc = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fh: $author$project$Comp$AccountForm$initModify(acc),
								cG: $elm$core$Maybe$Just(acc)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 3:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{h7: str}),
					A3($author$project$Api$listAccounts, flags, str, $author$project$Page$Account$Data$SearchResp));
			case 4:
				var lmsg = msg.a;
				var _v2 = A2($author$project$Comp$AccountTable$update, lmsg, model.gw);
				var m = _v2.a;
				var sel = _v2.b;
				var cmd = A2(
					$author$project$Page$set,
					key,
					$author$project$Page$AccountPage(
						A2(
							$elm$core$Maybe$map,
							function ($) {
								return $.hs;
							},
							sel)));
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							fh: $author$project$Comp$AccountForm$init(sel),
							cG: sel,
							gw: m
						}),
					cmd);
			case 5:
				var lmsg = msg.a;
				var _v3 = A2($author$project$Comp$AccountForm$update, lmsg, model.fh);
				var m = _v3.a;
				var action = _v3.b;
				var cmd = function () {
					switch (action.$) {
						case 1:
							var ac = action.a;
							return A3($author$project$Api$createAccount, flags, ac, $author$project$Page$Account$Data$SaveResp);
						case 0:
							var id = action.a;
							var am = action.b;
							return A4($author$project$Api$modifyAccount, flags, id, am, $author$project$Page$Account$Data$SaveResp);
						case 2:
							return A2(
								$author$project$Page$set,
								key,
								$author$project$Page$AccountPage($elm$core$Maybe$Nothing));
						case 4:
							var id = action.a;
							return A3($author$project$Api$deleteAccount, flags, id, $author$project$Page$Account$Data$DeleteResp);
						default:
							return $elm$core$Platform$Cmd$none;
					}
				}();
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{fh: m, gg: $elm$core$Maybe$Nothing}),
					cmd);
			case 6:
				if (!msg.a.$) {
					var r = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(r)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					var errmsg = $author$project$Util$Http$errorToString(err);
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(
									A2($author$project$Api$Model$BasicResult$BasicResult, false, errmsg))
							}),
						$elm$core$Platform$Cmd$none);
				}
			case 7:
				if (!msg.a.$) {
					var r = msg.a.a;
					return r.iA ? _Utils_Tuple2(
						model,
						A2(
							$author$project$Page$set,
							key,
							$author$project$Page$AccountPage($elm$core$Maybe$Nothing))) : _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(r)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					var errmsg = $author$project$Util$Http$errorToString(err);
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(
									A2($author$project$Api$Model$BasicResult$BasicResult, false, errmsg))
							}),
						$elm$core$Platform$Cmd$none);
				}
			default:
				return _Utils_Tuple2(
					model,
					A2(
						$author$project$Page$set,
						key,
						$author$project$Page$AccountPage(
							$elm$core$Maybe$Just('new'))));
		}
	});
var $author$project$App$Update$updateAccount = F2(
	function (lmsg, model) {
		var _v0 = A4($author$project$Page$Account$Update$update, model.dH, model.fg, lmsg, model.eL);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{eL: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$AccountMsg, lc));
	});
var $author$project$App$Data$AliasMsg = function (a) {
	return {$: 9, a: a};
};
var $author$project$Page$Alias$Data$AliasMemberResp = function (a) {
	return {$: 11, a: a};
};
var $author$project$Page$Alias$Data$DeleteResp = function (a) {
	return {$: 7, a: a};
};
var $author$project$Page$Alias$Data$LoadResp = function (a) {
	return {$: 2, a: a};
};
var $author$project$Page$Alias$Data$MailFormMsg = function (a) {
	return {$: 8, a: a};
};
var $author$project$Page$Alias$Data$SaveResp = function (a) {
	return {$: 6, a: a};
};
var $author$project$Page$Alias$Data$SearchResp = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Alias$Data$clipboardData = _Utils_Tuple2('Alias', '#alias-copy-to-clipboard-btn');
var $author$project$Api$Model$IdResult$IdResult = F3(
	function (success, message, id) {
		return {hs: id, dU: message, iA: success};
	});
var $author$project$Api$Model$IdResult$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'id',
	$elm$json$Json$Decode$string,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'message',
		$elm$json$Json$Decode$string,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'success',
			$elm$json$Json$Decode$bool,
			$elm$json$Json$Decode$succeed($author$project$Api$Model$IdResult$IdResult))));
var $elm$json$Json$Encode$int = _Json_wrap;
var $elm$json$Json$Encode$list = F2(
	function (func, entries) {
		return _Json_wrap(
			A3(
				$elm$core$List$foldl,
				_Json_addEntry(func),
				_Json_emptyArray(0),
				entries));
	});
var $author$project$Api$Model$AliasChange$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'id',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.hs)),
				_Utils_Tuple2(
				'name',
				$elm$json$Json$Encode$string(value.dX)),
				_Utils_Tuple2(
				'validity',
				$elm$json$Json$Encode$int(value.eF)),
				_Utils_Tuple2(
				'enabled',
				$elm$json$Json$Encode$bool(value.da)),
				_Utils_Tuple2(
				'members',
				$elm$json$Json$Encode$list($elm$json$Json$Encode$string)(value.dT))
			]));
};
var $author$project$Api$createAlias = F3(
	function (flags, ac, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$AliasChange$encode(ac)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$IdResult$decoder),
				d: flags.b.c + '/api/v2/sec/alias'
			});
	});
var $author$project$Api$deleteAlias = F3(
	function (flags, id, receive) {
		return $author$project$Util$Http$authDelete(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/alias/' + id)
			});
	});
var $author$project$Api$Model$AliasDetail$AliasDetail = F7(
	function (id, name, validity, owner, enabled, members, created) {
		return {c0: created, da: enabled, hs: id, dT: members, dX: name, d3: owner, eF: validity};
	});
var $author$project$Api$Model$AccountLightList$AccountLightList = function (items) {
	return {dG: items};
};
var $author$project$Api$Model$AccountLight$AccountLight = F2(
	function (id, login) {
		return {hs: id, dK: login};
	});
var $author$project$Api$Model$AccountLight$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'login',
	$elm$json$Json$Decode$string,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'id',
		$elm$json$Json$Decode$string,
		$elm$json$Json$Decode$succeed($author$project$Api$Model$AccountLight$AccountLight)));
var $author$project$Api$Model$AccountLightList$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'items',
	$elm$json$Json$Decode$list($author$project$Api$Model$AccountLight$decoder),
	$elm$json$Json$Decode$succeed($author$project$Api$Model$AccountLightList$AccountLightList));
var $author$project$Api$Model$AliasDetail$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'created',
	$elm$json$Json$Decode$int,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'members',
		$author$project$Api$Model$AccountLightList$decoder,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'enabled',
			$elm$json$Json$Decode$bool,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
				'owner',
				$elm$json$Json$Decode$string,
				A3(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
					'validity',
					$elm$json$Json$Decode$int,
					A3(
						$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
						'name',
						$elm$json$Json$Decode$string,
						A3(
							$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
							'id',
							$elm$json$Json$Decode$string,
							$elm$json$Json$Decode$succeed($author$project$Api$Model$AliasDetail$AliasDetail))))))));
var $author$project$Api$getAlias = F3(
	function (flags, id, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AliasDetail$decoder),
				d: flags.b.c + ('/api/v2/sec/alias/' + id)
			});
	});
var $author$project$Api$Model$MailTemplate$MailTemplate = F2(
	function (subject, body) {
		return {g: body, ey: subject};
	});
var $author$project$Api$Model$MailTemplate$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'body',
	$elm$json$Json$Decode$string,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'subject',
		$elm$json$Json$Decode$string,
		$elm$json$Json$Decode$succeed($author$project$Api$Model$MailTemplate$MailTemplate)));
var $author$project$Api$getAliasTemplate = F3(
	function (flags, aliasId, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$MailTemplate$decoder),
				d: flags.b.c + ('/api/v2/sec/mail/template/alias/' + aliasId)
			});
	});
var $author$project$Data$ValidityValue$Millis = function (a) {
	return {$: 0, a: a};
};
var $author$project$Comp$AliasForm$initModify = F3(
	function (flags, accounts, alias_) {
		var m = A2($author$project$Comp$AliasForm$initNew, flags, accounts);
		return _Utils_update(
			m,
			{
				S: A3($author$project$Comp$Dropdown$setOptions, $author$project$Comp$Dropdown$makeMultiple, accounts, alias_.dT.dG),
				ah: alias_.da,
				V: $elm$core$Maybe$Just(alias_),
				a0: $elm$core$Maybe$Just(alias_.hs),
				Y: alias_.dX,
				ad: $author$project$Data$ValidityValue$Millis(alias_.eF)
			});
	});
var $author$project$Comp$AliasForm$init = F3(
	function (flags, accounts, ma) {
		return A2(
			$elm$core$Maybe$withDefault,
			A2($author$project$Comp$AliasForm$initNew, flags, accounts),
			A2(
				$elm$core$Maybe$map,
				A2($author$project$Comp$AliasForm$initModify, flags, accounts),
				ma));
	});
var $author$project$Comp$MailSend$MailTplResp = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$MailForm$init = {g: '', ao: '', ey: ''};
var $author$project$Comp$MailSend$noLoader = {
	gO: false,
	dU: function (_v0) {
		return '';
	}
};
var $author$project$Comp$MailSend$emptyModel = {I: $author$project$Comp$MailSend$noLoader, X: $author$project$Comp$MailForm$init, P: $elm$core$Maybe$Nothing};
var $author$project$Comp$MailSend$templateLoader = {
	gO: true,
	dU: function (texts) {
		return texts.hD;
	}
};
var $author$project$Comp$MailSend$init = function (getTpl) {
	return _Utils_Tuple2(
		_Utils_update(
			$author$project$Comp$MailSend$emptyModel,
			{I: $author$project$Comp$MailSend$templateLoader}),
		getTpl($author$project$Comp$MailSend$MailTplResp));
};
var $author$project$Comp$AliasForm$initAccounts = F2(
	function (model, accounts) {
		return _Utils_update(
			model,
			{
				S: A3(
					$author$project$Comp$Dropdown$setOptions,
					$author$project$Comp$Dropdown$makeMultiple,
					accounts,
					A2(
						$elm$core$Maybe$withDefault,
						_List_Nil,
						A2(
							$elm$core$Maybe$map,
							A2(
								$elm$core$Basics$composeR,
								function ($) {
									return $.dT;
								},
								function ($) {
									return $.dG;
								}),
							model.V)))
			});
	});
var $author$project$Ports$initClipboard = _Platform_outgoingPort(
	'initClipboard',
	function ($) {
		var a = $.a;
		var b = $.b;
		return A2(
			$elm$json$Json$Encode$list,
			$elm$core$Basics$identity,
			_List_fromArray(
				[
					$elm$json$Json$Encode$string(a),
					$elm$json$Json$Encode$string(b)
				]));
	});
var $author$project$Api$Model$AliasList$AliasList = function (items) {
	return {dG: items};
};
var $author$project$Api$Model$AliasList$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'items',
	$elm$json$Json$Decode$list($author$project$Api$Model$AliasDetail$decoder),
	$elm$json$Json$Decode$succeed($author$project$Api$Model$AliasList$AliasList));
var $author$project$Api$listAlias = F3(
	function (flags, q, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AliasList$decoder),
				d: flags.b.c + ('/api/v2/sec/alias?q=' + $elm$url$Url$percentEncode(q))
			});
	});
var $author$project$Api$listAliasMember = F3(
	function (flags, q, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AccountLightList$decoder),
				d: flags.b.c + ('/api/v2/sec/alias-member?q=' + $elm$url$Url$percentEncode(q))
			});
	});
var $author$project$Api$modifyAlias = F4(
	function (flags, id, ac, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$AliasChange$encode(ac)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$IdResult$decoder),
				d: flags.b.c + ('/api/v2/sec/alias/' + id)
			});
	});
var $author$project$Comp$AliasForm$FormCancelled = {$: 2};
var $author$project$Comp$AliasForm$FormCreated = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$AliasForm$FormDelete = function (a) {
	return {$: 3, a: a};
};
var $author$project$Comp$AliasForm$FormModified = F2(
	function (a, b) {
		return {$: 0, a: a, b: b};
	});
var $author$project$Comp$AliasForm$FormNone = {$: 4};
var $author$project$Comp$AliasForm$formInvalid = function (model) {
	return _Utils_eq(
		$author$project$Util$Maybe$fromString(model.Y),
		$elm$core$Maybe$Nothing);
};
var $author$project$Comp$Dropdown$getSelected = function (model) {
	return A2(
		$elm$core$List$map,
		function ($) {
			return $.eG;
		},
		model.cG);
};
var $author$project$Comp$AliasForm$isCreate = function (model) {
	return _Utils_eq(model.V, $elm$core$Maybe$Nothing);
};
var $author$project$Comp$Dropdown$RemoveItem2 = function (a) {
	return {$: 4, a: a};
};
var $author$project$Comp$Dropdown$ToggleMenu = {$: 2};
var $elm$core$String$foldl = _String_foldl;
var $NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$isJust = function (maybeThing) {
	if (!maybeThing.$) {
		return true;
	} else {
		return false;
	}
};
var $elm$core$String$filter = _String_filter;
var $NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$root = function (string) {
	return A2(
		$elm$core$String$filter,
		function (c) {
			return $elm$core$Char$isLower(c) || $elm$core$Char$isDigit(c);
		},
		$elm$core$String$toLower(string));
};
var $elm$core$String$cons = _String_cons;
var $elm$core$String$fromChar = function (_char) {
	return A2($elm$core$String$cons, _char, '');
};
var $NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$searchHelper = F2(
	function (letter, restOfWord) {
		if (!restOfWord.$) {
			var string = restOfWord.a;
			var _v1 = A2(
				$elm$core$String$indexes,
				$elm$core$String$fromChar(letter),
				string);
			if (!_v1.b) {
				return $elm$core$Maybe$Nothing;
			} else {
				var found = _v1.a;
				return $elm$core$Maybe$Just(
					A2($elm$core$String$dropLeft, found + 1, string));
			}
		} else {
			return $elm$core$Maybe$Nothing;
		}
	});
var $NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$match = F2(
	function (needle, haystack) {
		return $NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$isJust(
			A3(
				$elm$core$String$foldl,
				$NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$searchHelper,
				$elm$core$Maybe$Just(
					$NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$root(haystack)),
				$NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$root(needle)));
	});
var $author$project$Comp$Dropdown$filterOptions = F3(
	function (str, mkText, list) {
		return A2(
			$elm$core$List$map,
			function (e) {
				return _Utils_update(
					e,
					{
						gO: false,
						cq: A2(
							$NoRedInk$elm_simple_fuzzy$Simple$Fuzzy$match,
							str,
							mkText(e.eG))
					});
			},
			list);
	});
var $author$project$Comp$Dropdown$applyFilter = F3(
	function (str, mkText, model) {
		var selected = ((str !== '') && (!model.D)) ? _List_Nil : model.cG;
		return _Utils_update(
			model,
			{
				n: A3($author$project$Comp$Dropdown$filterOptions, str, mkText, model.n),
				a_: str,
				cG: selected
			});
	});
var $author$project$Comp$Dropdown$clearFilter = function (model) {
	return _Utils_update(
		model,
		{a_: ''});
};
var $author$project$Comp$Dropdown$isSearchable = function (model) {
	return model.bE(
		$elm$core$List$length(model.n));
};
var $author$project$Comp$Dropdown$getOptions = function (model) {
	return ((!model.D) && ($author$project$Comp$Dropdown$isSearchable(model) && model.k)) ? A2(
		$elm$core$List$filter,
		function ($) {
			return $.cq;
		},
		model.n) : A2(
		$elm$core$List$filter,
		function (e) {
			return e.cq && (!e.cG);
		},
		model.n);
};
var $author$project$Comp$Dropdown$makeNextActive = F2(
	function (nextEl, model) {
		var opts = $author$project$Comp$Dropdown$getOptions(model);
		var merge = F2(
			function (item1, item2) {
				return _Utils_update(
					item2,
					{
						gO: _Utils_eq(item1.eG, item2.eG)
					});
			});
		var updateModel = function (item) {
			return _Utils_update(
				model,
				{
					n: A2(
						$elm$core$List$map,
						merge(item),
						model.n),
					k: true
				});
		};
		var current = A2(
			$author$project$Util$List$findIndexed,
			function ($) {
				return $.gO;
			},
			opts);
		var next = A2(
			$elm$core$Maybe$andThen,
			$author$project$Util$List$get(opts),
			A2(
				$elm$core$Maybe$map,
				nextEl,
				A2($elm$core$Maybe$map, $elm$core$Tuple$second, current)));
		if (!next.$) {
			var item = next.a;
			return updateModel(item);
		} else {
			var _v1 = $elm$core$List$head(opts);
			if (!_v1.$) {
				var item = _v1.a;
				return updateModel(item);
			} else {
				return model;
			}
		}
	});
var $author$project$Comp$Dropdown$selectActive = function (model) {
	var current = A2(
		$author$project$Util$List$find,
		function ($) {
			return $.gO;
		},
		$author$project$Comp$Dropdown$getOptions(model));
	if (!current.$) {
		var item = current.a;
		return $author$project$Comp$Dropdown$clearFilter(
			A2($author$project$Comp$Dropdown$selectItem, model, item));
	} else {
		return model;
	}
};
var $author$project$Comp$Dropdown$update = F2(
	function (msg, model) {
		update:
		while (true) {
			switch (msg.$) {
				case 0:
					var list = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								n: A2(
									$elm$core$List$map,
									$author$project$Comp$Dropdown$makeItem(model),
									list)
							}),
						$elm$core$Platform$Cmd$none);
				case 1:
					var list = msg.a;
					var m0 = A3(
						$elm$core$List$foldl,
						function (item) {
							return function (m) {
								return A2($author$project$Comp$Dropdown$deselectItem, m, item);
							};
						},
						model,
						model.cG);
					var m1 = A3(
						$elm$core$List$foldl,
						function (item) {
							return function (m) {
								return A2($author$project$Comp$Dropdown$selectItem, m, item);
							};
						},
						m0,
						A2(
							$elm$core$List$map,
							$author$project$Comp$Dropdown$makeItem(model),
							list));
					return _Utils_Tuple2(m1, $elm$core$Platform$Cmd$none);
				case 2:
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{k: !model.k}),
						$elm$core$Platform$Cmd$none);
				case 3:
					var e = msg.a;
					var m = $author$project$Comp$Dropdown$clearFilter(
						A2($author$project$Comp$Dropdown$selectItem, model, e));
					return _Utils_Tuple2(
						_Utils_update(
							m,
							{k: false}),
						$elm$core$Platform$Cmd$none);
				case 4:
					var e = msg.a;
					var m = $author$project$Comp$Dropdown$clearFilter(
						A2($author$project$Comp$Dropdown$deselectItem, model, e));
					return _Utils_Tuple2(m, $elm$core$Platform$Cmd$none);
				case 5:
					var f = msg.a;
					var str = msg.b;
					var m = A3($author$project$Comp$Dropdown$applyFilter, str, f, model);
					return _Utils_Tuple2(
						_Utils_update(
							m,
							{k: true}),
						$elm$core$Platform$Cmd$none);
				case 6:
					var flag = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{k: flag}),
						$elm$core$Platform$Cmd$none);
				default:
					var code = msg.a;
					_v1$9:
					while (true) {
						if (!code.$) {
							switch (code.a.$) {
								case 0:
									var _v2 = code.a;
									return _Utils_Tuple2(
										A2(
											$author$project$Comp$Dropdown$makeNextActive,
											function (n) {
												return n - 1;
											},
											model),
										$elm$core$Platform$Cmd$none);
								case 9:
									var _v3 = code.a;
									return _Utils_Tuple2(
										A2(
											$author$project$Comp$Dropdown$makeNextActive,
											function (n) {
												return n - 1;
											},
											model),
										$elm$core$Platform$Cmd$none);
								case 12:
									var _v4 = code.a;
									return _Utils_Tuple2(
										A2(
											$author$project$Comp$Dropdown$makeNextActive,
											function (n) {
												return n - 1;
											},
											model),
										$elm$core$Platform$Cmd$none);
								case 1:
									var _v5 = code.a;
									return _Utils_Tuple2(
										A2(
											$author$project$Comp$Dropdown$makeNextActive,
											$elm$core$Basics$add(1),
											model),
										$elm$core$Platform$Cmd$none);
								case 8:
									var _v6 = code.a;
									return _Utils_Tuple2(
										A2(
											$author$project$Comp$Dropdown$makeNextActive,
											$elm$core$Basics$add(1),
											model),
										$elm$core$Platform$Cmd$none);
								case 11:
									var _v7 = code.a;
									return _Utils_Tuple2(
										A2(
											$author$project$Comp$Dropdown$makeNextActive,
											$elm$core$Basics$add(1),
											model),
										$elm$core$Platform$Cmd$none);
								case 6:
									var _v8 = code.a;
									if (model.k) {
										return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
									} else {
										var _v9 = model.cG;
										if (_v9.b && (!_v9.b.b)) {
											var e = _v9.a;
											var _v10 = A2(
												$author$project$Comp$Dropdown$update,
												$author$project$Comp$Dropdown$RemoveItem2(e),
												model);
											var m_ = _v10.a;
											var c_ = _v10.b;
											return _Utils_Tuple2(
												_Utils_update(
													m_,
													{k: false}),
												c_);
										} else {
											return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
										}
									}
								case 5:
									var _v11 = code.a;
									var $temp$msg = $author$project$Comp$Dropdown$ToggleMenu,
										$temp$model = model;
									msg = $temp$msg;
									model = $temp$model;
									continue update;
								case 4:
									var _v12 = code.a;
									var m = $author$project$Comp$Dropdown$selectActive(model);
									return _Utils_Tuple2(
										_Utils_update(
											m,
											{k: false}),
										$elm$core$Platform$Cmd$none);
								default:
									break _v1$9;
							}
						} else {
							break _v1$9;
						}
					}
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			}
		}
	});
var $author$project$Comp$ValidityField$update = F2(
	function (msg, model) {
		var lmsg = msg;
		var _v1 = A2($author$project$Comp$FixedDropdown$update, lmsg, model);
		var m = _v1.a;
		var sel = _v1.b;
		return _Utils_Tuple2(m, sel);
	});
var $author$project$Comp$AliasForm$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 0:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{Y: str}),
					$author$project$Comp$AliasForm$FormNone);
			case 1:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							a0: $author$project$Util$Maybe$fromString(str)
						}),
					$author$project$Comp$AliasForm$FormNone);
			case 2:
				var lmsg = msg.a;
				var _v1 = A2($author$project$Comp$ValidityField$update, lmsg, model.cp);
				var m = _v1.a;
				var sel = _v1.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							ad: A2($elm$core$Maybe$withDefault, model.ad, sel),
							cp: m
						}),
					$author$project$Comp$AliasForm$FormNone);
			case 3:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{ah: !model.ah}),
					$author$project$Comp$AliasForm$FormNone);
			case 7:
				var _v2 = A2(
					$elm$core$Maybe$map,
					function ($) {
						return $.hs;
					},
					model.V);
				if (!_v2.$) {
					var id = _v2.a;
					return _Utils_Tuple2(
						model,
						$author$project$Comp$AliasForm$FormDelete(id));
				} else {
					return _Utils_Tuple2(model, $author$project$Comp$AliasForm$FormNone);
				}
			case 8:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{aR: false}),
					$author$project$Comp$AliasForm$FormNone);
			case 6:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{aR: true}),
					$author$project$Comp$AliasForm$FormNone);
			case 4:
				return _Utils_Tuple2(model, $author$project$Comp$AliasForm$FormCancelled);
			case 5:
				if ($author$project$Comp$AliasForm$formInvalid(model)) {
					return _Utils_Tuple2(model, $author$project$Comp$AliasForm$FormNone);
				} else {
					var ac = {
						da: model.ah,
						hs: $author$project$Comp$AliasForm$isCreate(model) ? $elm$core$Maybe$Nothing : model.a0,
						dT: A2(
							$elm$core$List$map,
							function ($) {
								return $.hs;
							},
							$author$project$Comp$Dropdown$getSelected(model.S)),
						dX: model.Y,
						eF: $author$project$Data$ValidityValue$toMillis(model.ad)
					};
					var _v3 = A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.hs;
						},
						model.V);
					if (!_v3.$) {
						var id = _v3.a;
						return _Utils_Tuple2(
							model,
							A2($author$project$Comp$AliasForm$FormModified, id, ac));
					} else {
						return _Utils_Tuple2(
							model,
							$author$project$Comp$AliasForm$FormCreated(ac));
					}
				}
			default:
				var lm = msg.a;
				var _v4 = A2($author$project$Comp$Dropdown$update, lm, model.S);
				var mm_ = _v4.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{S: mm_}),
					$author$project$Comp$AliasForm$FormNone);
		}
	});
var $author$project$Comp$AliasTable$update = F2(
	function (msg, model) {
		var alias_ = msg;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					cG: $elm$core$Maybe$Just(alias_)
				}),
			$elm$core$Maybe$Just(alias_));
	});
var $author$project$Comp$MailSend$Cancelled = {$: 1};
var $author$project$Comp$MailSend$MailSendResp = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$MailSend$Run = function (a) {
	return {$: 0, a: a};
};
var $author$project$Comp$MailSend$Sent = {$: 2};
var $author$project$Comp$MailForm$initWith = function (tpl) {
	return {g: tpl.g, ao: '', ey: tpl.ey};
};
var $author$project$Api$Model$SimpleMail$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'recipients',
				$elm$json$Json$Encode$list($elm$json$Json$Encode$string)(value.ed)),
				_Utils_Tuple2(
				'subject',
				$elm$json$Json$Encode$string(value.ey)),
				_Utils_Tuple2(
				'body',
				$elm$json$Json$Encode$string(value.g))
			]));
};
var $author$project$Api$sendMail = F3(
	function (flags, mail, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$SimpleMail$encode(mail)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + '/api/v2/sec/mail/send'
			});
	});
var $author$project$Comp$MailSend$sendingLoader = {
	gO: true,
	dU: function (texts) {
		return texts.$9;
	}
};
var $author$project$Comp$MailForm$FormCancel = {$: 1};
var $author$project$Comp$MailForm$FormNone = {$: 2};
var $author$project$Comp$MailForm$FormSend = function (a) {
	return {$: 0, a: a};
};
var $author$project$Api$Model$SimpleMail$SimpleMail = F3(
	function (recipients, subject, body) {
		return {g: body, ed: recipients, ey: subject};
	});
var $author$project$Comp$MailForm$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 0:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{ey: str}),
					$author$project$Comp$MailForm$FormNone);
			case 1:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{g: str}),
					$author$project$Comp$MailForm$FormNone);
			case 2:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{ao: str}),
					$author$project$Comp$MailForm$FormNone);
			case 3:
				return _Utils_Tuple2(model, $author$project$Comp$MailForm$FormCancel);
			default:
				var rec = A2($elm$core$String$split, ',', model.ao);
				var sm = A3($author$project$Api$Model$SimpleMail$SimpleMail, rec, model.ey, model.g);
				return _Utils_Tuple2(
					model,
					$author$project$Comp$MailForm$FormSend(sm));
		}
	});
var $author$project$Comp$MailSend$update = F3(
	function (flags, msg, model) {
		switch (msg.$) {
			case 0:
				var lmsg = msg.a;
				var _v1 = A2($author$project$Comp$MailForm$update, lmsg, model.X);
				var mm = _v1.a;
				var act = _v1.b;
				switch (act.$) {
					case 2:
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{X: mm}),
							$author$project$Comp$MailSend$Run($elm$core$Platform$Cmd$none));
					case 1:
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{P: $elm$core$Maybe$Nothing}),
							$author$project$Comp$MailSend$Cancelled);
					default:
						var mail = act.a;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{I: $author$project$Comp$MailSend$sendingLoader, X: mm}),
							$author$project$Comp$MailSend$Run(
								A3($author$project$Api$sendMail, flags, mail, $author$project$Comp$MailSend$MailSendResp)));
				}
			case 1:
				if (!msg.a.$) {
					var templ = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								I: $author$project$Comp$MailSend$noLoader,
								X: $author$project$Comp$MailForm$initWith(templ)
							}),
						$author$project$Comp$MailSend$Run($elm$core$Platform$Cmd$none));
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								I: $author$project$Comp$MailSend$noLoader,
								P: $elm$core$Maybe$Just(
									A2(
										$author$project$Api$Model$BasicResult$BasicResult,
										false,
										$author$project$Util$Http$errorToString(err)))
							}),
						$author$project$Comp$MailSend$Run($elm$core$Platform$Cmd$none));
				}
			default:
				if (!msg.a.$) {
					var br = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								I: $author$project$Comp$MailSend$noLoader,
								P: br.iA ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(br)
							}),
						br.iA ? $author$project$Comp$MailSend$Sent : $author$project$Comp$MailSend$Run($elm$core$Platform$Cmd$none));
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								I: $author$project$Comp$MailSend$noLoader,
								P: $elm$core$Maybe$Just(
									A2(
										$author$project$Api$Model$BasicResult$BasicResult,
										false,
										$author$project$Util$Http$errorToString(err)))
							}),
						$author$project$Comp$MailSend$Run($elm$core$Platform$Cmd$none));
				}
		}
	});
var $author$project$Page$Alias$Update$update = F4(
	function (key, flags, msg, model) {
		switch (msg.$) {
			case 0:
				if (!msg.a.$) {
					var id = msg.a.a;
					var current = A2(
						$elm$core$Maybe$withDefault,
						false,
						A2(
							$elm$core$Maybe$map,
							$elm$core$Basics$eq(id),
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.hs;
								},
								model.cG)));
					var clipboardInit = $author$project$Ports$initClipboard($author$project$Page$Alias$Data$clipboardData);
					return (id === 'new') ? _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fh: A2($author$project$Comp$AliasForm$initNew, flags, model.gN),
								cG: $elm$core$Maybe$Nothing
							}),
						clipboardInit) : (current ? _Utils_Tuple2(model, clipboardInit) : _Utils_Tuple2(
						model,
						$elm$core$Platform$Cmd$batch(
							_List_fromArray(
								[
									A3($author$project$Api$getAlias, flags, id, $author$project$Page$Alias$Data$LoadResp),
									clipboardInit,
									A3($author$project$Api$listAliasMember, flags, '', $author$project$Page$Alias$Data$AliasMemberResp)
								]))));
				} else {
					var _v1 = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fh: A2($author$project$Comp$AliasForm$initNew, flags, model.gN),
								cG: $elm$core$Maybe$Nothing
							}),
						$elm$core$Platform$Cmd$batch(
							_List_fromArray(
								[
									A3($author$project$Api$listAlias, flags, model.h7, $author$project$Page$Alias$Data$SearchResp),
									A3($author$project$Api$listAliasMember, flags, '', $author$project$Page$Alias$Data$AliasMemberResp)
								])));
				}
			case 1:
				if (!msg.a.$) {
					var list = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{gi: list.dG}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(
									A2(
										$author$project$Api$Model$BasicResult$BasicResult,
										false,
										$author$project$Util$Http$errorToString(err)))
							}),
						$elm$core$Platform$Cmd$none);
				}
			case 2:
				if (!msg.a.$) {
					var alias_ = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fh: A3($author$project$Comp$AliasForm$initModify, flags, model.gN, alias_),
								cG: $elm$core$Maybe$Just(alias_)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 11:
				if (!msg.a.$) {
					var ams = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gN: ams.dG,
								fh: A2($author$project$Comp$AliasForm$initAccounts, model.fh, ams.dG)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 3:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{h7: str}),
					A3($author$project$Api$listAlias, flags, str, $author$project$Page$Alias$Data$SearchResp));
			case 4:
				var lmsg = msg.a;
				var _v2 = A2($author$project$Comp$AliasTable$update, lmsg, model.gw);
				var m = _v2.a;
				var sel = _v2.b;
				var cmd = A2(
					$author$project$Page$set,
					key,
					$author$project$Page$AliasPage(
						A2(
							$elm$core$Maybe$map,
							function ($) {
								return $.hs;
							},
							sel)));
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							fh: A3($author$project$Comp$AliasForm$init, flags, model.gN, sel),
							cG: sel,
							gw: m
						}),
					cmd);
			case 5:
				var lmsg = msg.a;
				var _v3 = A2($author$project$Comp$AliasForm$update, lmsg, model.fh);
				var m = _v3.a;
				var action = _v3.b;
				var cmd = function () {
					switch (action.$) {
						case 1:
							var ac = action.a;
							return A3($author$project$Api$createAlias, flags, ac, $author$project$Page$Alias$Data$SaveResp);
						case 0:
							var id = action.a;
							var am = action.b;
							return A4($author$project$Api$modifyAlias, flags, id, am, $author$project$Page$Alias$Data$SaveResp);
						case 2:
							return A2(
								$author$project$Page$set,
								key,
								$author$project$Page$AliasPage($elm$core$Maybe$Nothing));
						case 3:
							var id = action.a;
							return A3($author$project$Api$deleteAlias, flags, id, $author$project$Page$Alias$Data$DeleteResp);
						default:
							return $elm$core$Platform$Cmd$none;
					}
				}();
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{fh: m, gg: $elm$core$Maybe$Nothing}),
					cmd);
			case 6:
				if (!msg.a.$) {
					var r = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(
									A2($author$project$Api$Model$BasicResult$BasicResult, r.iA, r.dU))
							}),
						((!_Utils_eq(
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.hs;
								},
								model.cG),
							$elm$core$Maybe$Just(r.hs))) && r.iA) ? $author$project$Page$goto(
							$author$project$Page$AliasPage(
								$elm$core$Maybe$Just(r.hs))) : $elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					var errmsg = $author$project$Util$Http$errorToString(err);
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(
									A2($author$project$Api$Model$BasicResult$BasicResult, false, errmsg))
							}),
						$elm$core$Platform$Cmd$none);
				}
			case 7:
				if (!msg.a.$) {
					var r = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(r)
							}),
						r.iA ? $author$project$Page$goto(
							$author$project$Page$AliasPage($elm$core$Maybe$Nothing)) : $elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					var errmsg = $author$project$Util$Http$errorToString(err);
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gg: $elm$core$Maybe$Just(
									A2($author$project$Api$Model$BasicResult$BasicResult, false, errmsg))
							}),
						$elm$core$Platform$Cmd$none);
				}
			case 8:
				var lmsg = msg.a;
				var _v5 = model.X;
				if (_v5.$ === 1) {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				} else {
					var msm = _v5.a;
					var _v6 = A3($author$project$Comp$MailSend$update, flags, lmsg, msm);
					var mm = _v6.a;
					var act = _v6.b;
					switch (act.$) {
						case 0:
							var c = act.a;
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{
										X: $elm$core$Maybe$Just(mm)
									}),
								A2($elm$core$Platform$Cmd$map, $author$project$Page$Alias$Data$MailFormMsg, c));
						case 1:
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{X: $elm$core$Maybe$Nothing}),
								$elm$core$Platform$Cmd$none);
						default:
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{X: $elm$core$Maybe$Nothing}),
								$elm$core$Platform$Cmd$none);
					}
				}
			case 9:
				var aliasId = A2(
					$elm$core$Maybe$withDefault,
					'',
					A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.hs;
						},
						model.cG));
				var getTpl = A2($author$project$Api$getAliasTemplate, flags, aliasId);
				var _v8 = $author$project$Comp$MailSend$init(getTpl);
				var mm = _v8.a;
				var mc = _v8.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							X: $elm$core$Maybe$Just(mm)
						}),
					A2($elm$core$Platform$Cmd$map, $author$project$Page$Alias$Data$MailFormMsg, mc));
			default:
				return _Utils_Tuple2(
					model,
					A2(
						$author$project$Page$set,
						key,
						$author$project$Page$AliasPage(
							$elm$core$Maybe$Just('new'))));
		}
	});
var $author$project$App$Update$updateAlias = F2(
	function (lmsg, model) {
		var _v0 = A4($author$project$Page$Alias$Update$update, model.dH, model.fg, lmsg, model.eO);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{eO: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$AliasMsg, lc));
	});
var $author$project$App$Data$DetailMsg = function (a) {
	return {$: 14, a: a};
};
var $author$project$Page$Detail$Data$BasicResp = function (a) {
	return {$: 4, a: a};
};
var $author$project$Page$Detail$Data$DeleteInProgress = 2;
var $author$project$Page$Detail$Data$DeleteRequested = 1;
var $author$project$Page$Detail$Data$DeleteResp = function (a) {
	return {$: 12, a: a};
};
var $author$project$Page$Detail$Data$DetailResp = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Detail$Data$DropzoneMsg = function (a) {
	return {$: 23, a: a};
};
var $author$project$Page$Detail$Data$EditMaxViews = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Detail$Data$EditName = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Detail$Data$EditPassword = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$Detail$Data$EditValidity = function (a) {
	return {$: 2, a: a};
};
var $author$project$Page$Detail$Data$MailFormMsg = function (a) {
	return {$: 29, a: a};
};
var $author$project$Api$Model$PublishData$PublishData = function (reuseId) {
	return {eh: reuseId};
};
var $author$project$Page$Detail$Data$SaveEdit = {$: 21};
var $author$project$Data$UploadData$UploadData = F4(
	function (url, id, files, aliasId) {
		return {eN: aliasId, dh: files, hs: id, d: url};
	});
var $author$project$Data$UploadDict$countDone = function (_v0) {
	var selectedFiles = _v0.il;
	var uploads = _v0.iO;
	var tupleAdd = F2(
		function (t1, t2) {
			return _Utils_Tuple2(t1.a + t2.a, t1.b + t2.b);
		});
	var count = F2(
		function (index, _v2) {
			return A2(
				$elm$core$Maybe$withDefault,
				_Utils_Tuple2(0, 0),
				A2(
					$elm$core$Maybe$map,
					function (s) {
						switch (s.$) {
							case 0:
								return _Utils_Tuple2(1, 0);
							case 1:
								return _Utils_Tuple2(0, 0);
							default:
								return _Utils_Tuple2(0, 1);
						}
					},
					A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.ev;
						},
						A2($elm$core$Dict$get, index, uploads))));
		});
	return A3(
		$elm$core$List$foldl,
		tupleAdd,
		_Utils_Tuple2(0, 0),
		A2($elm$core$List$indexedMap, count, selectedFiles));
};
var $author$project$Data$UploadDict$allDone = function (up) {
	var _v0 = $author$project$Data$UploadDict$countDone(up);
	var succ = _v0.a;
	var err = _v0.b;
	return _Utils_eq(
		succ + err,
		$elm$core$List$length(up.il));
};
var $author$project$Page$Detail$Data$clipboardData = _Utils_Tuple2('Detail', '#share-copy-to-clipboard-btn');
var $author$project$Api$deleteFile = F4(
	function (flags, share, file, receive) {
		return $author$project$Util$Http$authDelete(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + (share + ('/file/' + file)))
			});
	});
var $author$project$Api$deleteShare = F3(
	function (flags, id, receive) {
		return $author$project$Util$Http$authDelete(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + id)
			});
	});
var $author$project$Data$UploadData$encode = function (data) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'url',
				$elm$json$Json$Encode$string(data.d)),
				_Utils_Tuple2(
				'id',
				$elm$json$Json$Encode$string(data.hs)),
				_Utils_Tuple2(
				'files',
				A2($elm$json$Json$Encode$list, $elm$core$Basics$identity, data.dh)),
				_Utils_Tuple2(
				'aliasId',
				A2(
					$elm$core$Maybe$withDefault,
					$elm$json$Json$Encode$null,
					A2($elm$core$Maybe$map, $elm$json$Json$Encode$string, data.eN)))
			]));
};
var $author$project$Api$Model$ShareDetail$ShareDetail = function (id) {
	return function (name) {
		return function (aliasId) {
			return function (aliasName) {
				return function (validity) {
					return function (maxViews) {
						return function (password) {
							return function (descriptionRaw) {
								return function (description) {
									return function (created) {
										return function (publishInfo) {
											return function (files) {
												return {eN: aliasId, cN: aliasName, c0: created, c5: description, c6: descriptionRaw, dh: files, hs: id, dS: maxViews, dX: name, d4: password, ea: publishInfo, eF: validity};
											};
										};
									};
								};
							};
						};
					};
				};
			};
		};
	};
};
var $author$project$Api$Model$ShareFile$ShareFile = F6(
	function (id, filename, size, mimetype, checksum, storedSize) {
		return {cY: checksum, dg: filename, hs: id, dW: mimetype, en: size, ex: storedSize};
	});
var $author$project$Api$Model$ShareFile$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'storedSize',
	$elm$json$Json$Decode$int,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'checksum',
		$elm$json$Json$Decode$string,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'mimetype',
			$elm$json$Json$Decode$string,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
				'size',
				$elm$json$Json$Decode$int,
				A3(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
					'filename',
					$elm$json$Json$Decode$string,
					A3(
						$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
						'id',
						$elm$json$Json$Decode$string,
						$elm$json$Json$Decode$succeed($author$project$Api$Model$ShareFile$ShareFile)))))));
var $author$project$Api$Model$SharePublish$SharePublish = F7(
	function (id, enabled, views, publishDate, publishUntil, expired, lastAccess) {
		return {da: enabled, dc: expired, hs: id, dI: lastAccess, d9: publishDate, eb: publishUntil, eI: views};
	});
var $author$project$Api$Model$SharePublish$decoder = A4(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
	'lastAccess',
	$elm$json$Json$Decode$maybe($elm$json$Json$Decode$int),
	$elm$core$Maybe$Nothing,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'expired',
		$elm$json$Json$Decode$bool,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'publishUntil',
			$elm$json$Json$Decode$int,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
				'publishDate',
				$elm$json$Json$Decode$int,
				A3(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
					'views',
					$elm$json$Json$Decode$int,
					A3(
						$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
						'enabled',
						$elm$json$Json$Decode$bool,
						A3(
							$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
							'id',
							$elm$json$Json$Decode$string,
							$elm$json$Json$Decode$succeed($author$project$Api$Model$SharePublish$SharePublish))))))));
var $author$project$Api$Model$ShareDetail$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'files',
	$elm$json$Json$Decode$list($author$project$Api$Model$ShareFile$decoder),
	A4(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
		'publishInfo',
		$elm$json$Json$Decode$maybe($author$project$Api$Model$SharePublish$decoder),
		$elm$core$Maybe$Nothing,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'created',
			$elm$json$Json$Decode$int,
			A4(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
				'description',
				$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
				$elm$core$Maybe$Nothing,
				A4(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
					'descriptionRaw',
					$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
					$elm$core$Maybe$Nothing,
					A3(
						$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
						'password',
						$elm$json$Json$Decode$bool,
						A3(
							$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
							'maxViews',
							$elm$json$Json$Decode$int,
							A3(
								$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
								'validity',
								$elm$json$Json$Decode$int,
								A4(
									$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
									'aliasName',
									$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
									$elm$core$Maybe$Nothing,
									A4(
										$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
										'aliasId',
										$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
										$elm$core$Maybe$Nothing,
										A4(
											$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
											'name',
											$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
											$elm$core$Maybe$Nothing,
											A3(
												$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
												'id',
												$elm$json$Json$Decode$string,
												$elm$json$Json$Decode$succeed($author$project$Api$Model$ShareDetail$ShareDetail)))))))))))));
var $author$project$Api$getShare = F3(
	function (flags, id, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$ShareDetail$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + id)
			});
	});
var $author$project$Api$getShareTemplate = F3(
	function (flags, shareId, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$MailTemplate$decoder),
				d: flags.b.c + ('/api/v2/sec/mail/template/share/' + shareId)
			});
	});
var $author$project$Page$Detail$Data$isEdit = F2(
	function (model, prop) {
		return A2(
			$elm$core$Maybe$andThen,
			function (t) {
				return _Utils_eq(t.a, prop) ? $elm$core$Maybe$Just(t.b) : $elm$core$Maybe$Nothing;
			},
			model.c8);
	});
var $author$project$Page$Detail$Data$MaxViewsExceeded = 3;
var $author$project$Page$Detail$Data$PublishExpired = 2;
var $author$project$Page$Detail$Data$PublishOk = 1;
var $author$project$Page$Detail$Data$Unpublished = 0;
var $author$project$Page$Detail$Data$isPublished = function (share) {
	var _v0 = share.ea;
	if (_v0.$ === 1) {
		return 0;
	} else {
		var info = _v0.a;
		return (!info.da) ? 0 : (info.dc ? 2 : ((_Utils_cmp(info.eI, share.dS) > -1) ? 3 : 1));
	}
};
var $author$project$Comp$IntInput$init = F2(
	function (min, max) {
		return {ak: false, cz: '', cA: max, cB: min};
	});
var $author$project$Page$Detail$Data$mkEditField = F3(
	function (flags, model, prop) {
		switch (prop) {
			case 0:
				return $author$project$Page$Detail$Data$EditName(model.gm.dX);
			case 1:
				return $author$project$Page$Detail$Data$EditMaxViews(
					_Utils_Tuple2(
						A2(
							$author$project$Comp$IntInput$init,
							$elm$core$Maybe$Just(1),
							$elm$core$Maybe$Nothing),
						$elm$core$Maybe$Just(model.gm.dS)));
			case 2:
				return $author$project$Page$Detail$Data$EditValidity(
					_Utils_Tuple2(
						$author$project$Comp$ValidityField$init(flags),
						$author$project$Data$ValidityValue$Millis(model.gm.eF)));
			default:
				return $author$project$Page$Detail$Data$EditPassword(
					_Utils_Tuple2($author$project$Comp$PasswordInput$init, $elm$core$Maybe$Nothing));
		}
	});
var $author$project$Api$Model$PublishData$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'reuseId',
				$elm$json$Json$Encode$bool(value.eh))
			]));
};
var $author$project$Api$publishShare = F4(
	function (flags, id, pd, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$PublishData$encode(pd)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + (id + '/publish'))
			});
	});
var $author$project$Comp$ShareFileList$reset = function (model) {
	return _Utils_update(
		model,
		{aY: $elm$core$Set$empty});
};
var $author$project$Ports$scrollToElem = _Platform_outgoingPort('scrollToElem', $elm$json$Json$Encode$string);
var $author$project$Ports$scrollTop = _Platform_outgoingPort(
	'scrollTop',
	function ($) {
		return $elm$json$Json$Encode$null;
	});
var $author$project$Api$Model$SingleString$SingleString = function (value) {
	return {eG: value};
};
var $author$project$Api$Model$SingleString$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'value',
				$elm$json$Json$Encode$string(value.eG))
			]));
};
var $author$project$Api$setDescription = F4(
	function (flags, id, value, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$SingleString$encode(
						$author$project$Api$Model$SingleString$SingleString(value))),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + (id + '/description'))
			});
	});
var $author$project$Api$Model$SingleNumber$SingleNumber = function (value) {
	return {eG: value};
};
var $author$project$Api$Model$SingleNumber$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'value',
				$elm$json$Json$Encode$int(value.eG))
			]));
};
var $author$project$Api$setMaxViews = F4(
	function (flags, id, value, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$SingleNumber$encode(
						$author$project$Api$Model$SingleNumber$SingleNumber(value))),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + (id + '/maxviews'))
			});
	});
var $author$project$Api$setName = F4(
	function (flags, id, value, receive) {
		if (!value.$) {
			var name = value.a;
			return $author$project$Util$Http$authPost(
				{
					f: $author$project$Api$getAccount(flags),
					g: $elm$http$Http$jsonBody(
						$author$project$Api$Model$SingleString$encode(
							$author$project$Api$Model$SingleString$SingleString(name))),
					e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
					d: flags.b.c + ('/api/v2/sec/share/' + (id + '/name'))
				});
		} else {
			return $author$project$Util$Http$authDelete(
				{
					f: $author$project$Api$getAccount(flags),
					e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
					d: flags.b.c + ('/api/v2/sec/share/' + (id + '/name'))
				});
		}
	});
var $author$project$Api$setPassword = F4(
	function (flags, id, value, receive) {
		if (!value.$) {
			var name = value.a;
			return $author$project$Util$Http$authPost(
				{
					f: $author$project$Api$getAccount(flags),
					g: $elm$http$Http$jsonBody(
						$author$project$Api$Model$SingleString$encode(
							$author$project$Api$Model$SingleString$SingleString(name))),
					e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
					d: flags.b.c + ('/api/v2/sec/share/' + (id + '/password'))
				});
		} else {
			return $author$project$Util$Http$authDelete(
				{
					f: $author$project$Api$getAccount(flags),
					e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
					d: flags.b.c + ('/api/v2/sec/share/' + (id + '/password'))
				});
		}
	});
var $author$project$Api$setValidity = F4(
	function (flags, id, value, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$SingleNumber$encode(
						$author$project$Api$Model$SingleNumber$SingleNumber(value))),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + (id + '/validity'))
			});
	});
var $author$project$Ports$startUpload = _Platform_outgoingPort('startUpload', $elm$json$Json$Encode$string);
var $author$project$Ports$stopUpload = _Platform_outgoingPort('stopUpload', $elm$json$Json$Encode$string);
var $author$project$Ports$submitFiles = _Platform_outgoingPort('submitFiles', $elm$core$Basics$identity);
var $author$project$Data$UploadDict$trackUpload = F2(
	function (model, state) {
		var next = A3($elm$core$Dict$insert, state.hi, state, model.iO);
		return _Utils_update(
			model,
			{iO: next});
	});
var $author$project$Page$Detail$Update$trackUpload = F2(
	function (model, state) {
		var next = A2($author$project$Data$UploadDict$trackUpload, model.iO, state);
		var infoMsg = function () {
			var _v0 = state.ev;
			if (_v0.$ === 2) {
				var em = _v0.a;
				return A2($author$project$Api$Model$BasicResult$BasicResult, false, em);
			} else {
				return model.gA;
			}
		}();
		return _Utils_update(
			model,
			{gA: infoMsg, gC: false, iO: next});
	});
var $author$project$Api$unpublishShare = F3(
	function (flags, id, receive) {
		return $author$project$Util$Http$authDelete(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/sec/share/' + (id + '/publish'))
			});
	});
var $elm$core$List$unzip = function (pairs) {
	var step = F2(
		function (_v0, _v1) {
			var x = _v0.a;
			var y = _v0.b;
			var xs = _v1.a;
			var ys = _v1.b;
			return _Utils_Tuple2(
				A2($elm$core$List$cons, x, xs),
				A2($elm$core$List$cons, y, ys));
		});
	return A3(
		$elm$core$List$foldr,
		step,
		_Utils_Tuple2(_List_Nil, _List_Nil),
		pairs);
};
var $author$project$Util$List$remove = F2(
	function (index, list) {
		return A2(
			$elm$core$List$map,
			$elm$core$Tuple$second,
			A2(
				$elm$core$List$filter,
				function (t) {
					return !_Utils_eq(index, t.a);
				},
				A2($elm$core$List$indexedMap, $elm$core$Tuple$pair, list)));
	});
var $author$project$Comp$Dropzone2$update = F3(
	function (current, msg, model) {
		switch (msg.$) {
			case 0:
				return _Utils_Tuple3(
					_Utils_update(
						model,
						{ds: true}),
					$elm$core$Platform$Cmd$none,
					current);
			case 1:
				return _Utils_Tuple3(
					_Utils_update(
						model,
						{ds: false}),
					$elm$core$Platform$Cmd$none,
					current);
			case 2:
				var list = msg.a;
				return _Utils_Tuple3(
					_Utils_update(
						model,
						{ds: false}),
					$elm$core$Platform$Cmd$none,
					_Utils_ap(current, list));
			default:
				var index = msg.a;
				return _Utils_Tuple3(
					model,
					$elm$core$Platform$Cmd$none,
					A2($author$project$Util$List$remove, index, current));
		}
	});
var $author$project$Comp$IntInput$tooHigh = F2(
	function (model, n) {
		return A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$gt(n),
				model.cA));
	});
var $author$project$Comp$IntInput$tooLow = F2(
	function (model, n) {
		return A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$lt(n),
				model.cB));
	});
var $author$project$Comp$IntInput$update = F2(
	function (msg, model) {
		var str = msg;
		var m = _Utils_update(
			model,
			{cz: str});
		var _v1 = $elm$core$String$toInt(str);
		if (!_v1.$) {
			var n = _v1.a;
			return A2($author$project$Comp$IntInput$tooLow, model, n) ? _Utils_Tuple2(
				_Utils_update(
					m,
					{ak: true}),
				$elm$core$Maybe$Nothing) : (A2($author$project$Comp$IntInput$tooHigh, model, n) ? _Utils_Tuple2(
				_Utils_update(
					m,
					{ak: true}),
				$elm$core$Maybe$Nothing) : _Utils_Tuple2(
				_Utils_update(
					m,
					{ak: false}),
				$elm$core$Maybe$Just(n)));
		} else {
			return _Utils_Tuple2(
				_Utils_update(
					m,
					{ak: true}),
				$elm$core$Maybe$Nothing);
		}
	});
var $author$project$Comp$MarkdownInput$update = F3(
	function (txt, msg, model) {
		if (!msg.$) {
			var str = msg.a;
			return _Utils_Tuple2(model, str);
		} else {
			var dsp = msg.a;
			return _Utils_Tuple2(
				_Utils_update(
					model,
					{g9: dsp}),
				txt);
		}
	});
var $author$project$Comp$ShareFileList$FileClick = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$ShareFileList$FileDelete = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$ShareFileList$FileNone = {$: 0};
var $elm$core$Set$insert = F2(
	function (key, _v0) {
		var dict = _v0;
		return A3($elm$core$Dict$insert, key, 0, dict);
	});
var $author$project$Comp$ShareFileList$previewDeferred = _List_fromArray(
	['video/', 'audio/']);
var $author$project$Comp$ShareFileList$previewDirect = _List_fromArray(
	['text/', 'application/pdf']);
var $author$project$Comp$ShareFileList$previewFor = F2(
	function (mimeList, mime) {
		return A2(
			$elm$core$List$any,
			function (x) {
				return A2($elm$core$String$startsWith, x, mime);
			},
			mimeList);
	});
var $author$project$Comp$ShareFileList$previewPossible = function (mime) {
	return A2(
		$author$project$Comp$ShareFileList$previewFor,
		_Utils_ap(
			$author$project$Comp$ShareFileList$previewDeferred,
			_Utils_ap(
				$author$project$Comp$ShareFileList$previewDirect,
				_List_fromArray(
					['image/']))),
		mime);
};
var $author$project$Comp$ShareFileList$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 0:
				var sf = msg.a;
				return _Utils_Tuple2(
					model,
					$author$project$Comp$ShareFileList$previewPossible(sf.dW) ? $author$project$Comp$ShareFileList$FileClick(sf) : $author$project$Comp$ShareFileList$FileNone);
			case 1:
				var sf = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							aY: A2($elm$core$Set$insert, sf.hs, model.aY)
						}),
					$author$project$Comp$ShareFileList$FileNone);
			case 2:
				var sf = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							aa: $elm$core$Maybe$Just(sf)
						}),
					$author$project$Comp$ShareFileList$FileNone);
			case 4:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{aa: $elm$core$Maybe$Nothing}),
					$author$project$Comp$ShareFileList$FileNone);
			default:
				var _v1 = model.aa;
				if (!_v1.$) {
					var sf = _v1.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{aa: $elm$core$Maybe$Nothing}),
						$author$project$Comp$ShareFileList$FileDelete(sf));
				} else {
					return _Utils_Tuple2(model, $author$project$Comp$ShareFileList$FileNone);
				}
		}
	});
var $author$project$Data$UploadDict$updateFiles = F2(
	function (model, files) {
		return _Utils_update(
			model,
			{il: files});
	});
var $elm$file$File$size = _File_size;
var $author$project$Data$UploadDict$size = function (up) {
	return $elm$core$List$sum(
		A2(
			$elm$core$List$map,
			$elm$file$File$size,
			A2($elm$core$List$map, $elm$core$Tuple$second, up.il)));
};
var $author$project$Util$Share$validate = F3(
	function (flags, mshare, model) {
		if ((model.g7 === '') && _Utils_eq(model.iO.il, _List_Nil)) {
			return A2($author$project$Api$Model$BasicResult$BasicResult, false, 'Either some files or a description must be provided.');
		} else {
			var nsz = $author$project$Data$UploadDict$size(model.iO);
			var esz = $elm$core$List$sum(
				A2(
					$elm$core$List$map,
					function ($) {
						return $.en;
					},
					A2(
						$elm$core$Maybe$withDefault,
						_List_Nil,
						A2(
							$elm$core$Maybe$map,
							function ($) {
								return $.dh;
							},
							mshare))));
			return (_Utils_cmp(nsz + esz, flags.b.dP) > 0) ? A2($author$project$Api$Model$BasicResult$BasicResult, false, 'Upload is too large.') : A2($author$project$Api$Model$BasicResult$BasicResult, true, '');
		}
	});
var $author$project$Page$Detail$Update$update = F3(
	function (flags, msg, model) {
		update:
		while (true) {
			switch (msg.$) {
				case 0:
					var id = msg.a;
					return _Utils_Tuple2(
						model,
						$elm$core$Platform$Cmd$batch(
							_List_fromArray(
								[
									A3($author$project$Api$getShare, flags, id, $author$project$Page$Detail$Data$DetailResp),
									$author$project$Ports$initClipboard($author$project$Page$Detail$Data$clipboardData)
								])));
				case 1:
					if (!msg.a.$) {
						var details = msg.a.a;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{e2: 0, e3: $elm$core$Maybe$Nothing, dU: $elm$core$Maybe$Nothing, gm: details}),
							$elm$core$Platform$Cmd$none);
					} else {
						var err = msg.a.a;
						var m = $author$project$Util$Http$errorToString(err);
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									e2: 0,
									dU: $elm$core$Maybe$Just(
										A2($author$project$Api$Model$BasicResult$BasicResult, false, m))
								}),
							$elm$core$Platform$Cmd$none);
					}
				case 2:
					var state = msg.a;
					var newState = _Utils_eq(model.gz, state) ? 0 : state;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{e3: $elm$core$Maybe$Nothing, dU: $elm$core$Maybe$Nothing, gz: newState}),
						$elm$core$Platform$Cmd$none);
				case 3:
					var flag = msg.a;
					var cmd = function () {
						var _v1 = $author$project$Page$Detail$Data$isPublished(model.gm);
						if (!_v1) {
							return A4(
								$author$project$Api$publishShare,
								flags,
								model.gm.hs,
								$author$project$Api$Model$PublishData$PublishData(flag),
								$author$project$Page$Detail$Data$BasicResp);
						} else {
							return A3($author$project$Api$unpublishShare, flags, model.gm.hs, $author$project$Page$Detail$Data$BasicResp);
						}
					}();
					return _Utils_Tuple2(model, cmd);
				case 4:
					if (!msg.a.$) {
						var res = msg.a.a;
						if (res.iA) {
							var $temp$flags = flags,
								$temp$msg = $author$project$Page$Detail$Data$Init(model.gm.hs),
								$temp$model = model;
							flags = $temp$flags;
							msg = $temp$msg;
							model = $temp$model;
							continue update;
						} else {
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{
										dU: $elm$core$Maybe$Just(res)
									}),
								$elm$core$Platform$Cmd$none);
						}
					} else {
						var err = msg.a.a;
						var m = $author$project$Util$Http$errorToString(err);
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									dU: $elm$core$Maybe$Just(
										A2($author$project$Api$Model$BasicResult$BasicResult, false, m))
								}),
							$elm$core$Platform$Cmd$none);
					}
				case 5:
					var lmsg = msg.a;
					var _v2 = A2($author$project$Comp$ShareFileList$update, lmsg, model.fd);
					var m = _v2.a;
					var action = _v2.b;
					switch (action.$) {
						case 1:
							var sf = action.a;
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{
										fd: m,
										gM: $elm$core$Maybe$Just(sf)
									}),
								$author$project$Ports$scrollTop(0));
						case 2:
							var sf = action.a;
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{fd: m, gM: $elm$core$Maybe$Nothing}),
								A4($author$project$Api$deleteFile, flags, model.gm.hs, sf.hs, $author$project$Page$Detail$Data$BasicResp));
						default:
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{fd: m}),
								$elm$core$Platform$Cmd$none);
					}
				case 6:
					var mode = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fd: $author$project$Comp$ShareFileList$reset(model.fd),
								fe: mode
							}),
						$elm$core$Platform$Cmd$none);
				case 7:
					var _v4 = model.gM;
					if (!_v4.$) {
						var file = _v4.a;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{gM: $elm$core$Maybe$Nothing}),
							$author$project$Ports$scrollToElem(file.hs));
					} else {
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{gM: $elm$core$Maybe$Nothing}),
							$elm$core$Platform$Cmd$none);
					}
				case 8:
					var sf = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gM: $elm$core$Maybe$Just(sf)
							}),
						$elm$core$Platform$Cmd$none);
				case 9:
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{e2: 1}),
						$elm$core$Platform$Cmd$none);
				case 10:
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{e2: 2}),
						A3($author$project$Api$deleteShare, flags, model.gm.hs, $author$project$Page$Detail$Data$DeleteResp));
				case 11:
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{e2: 0}),
						$elm$core$Platform$Cmd$none);
				case 12:
					if (!msg.a.$) {
						var res = msg.a.a;
						return res.iA ? _Utils_Tuple2(
							_Utils_update(
								model,
								{e2: 0}),
							$author$project$Page$goto($author$project$Page$UploadPage)) : _Utils_Tuple2(
							_Utils_update(
								model,
								{
									e2: 0,
									dU: $elm$core$Maybe$Just(res)
								}),
							$elm$core$Platform$Cmd$none);
					} else {
						var err = msg.a.a;
						var m = $author$project$Util$Http$errorToString(err);
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									e2: 0,
									dU: $elm$core$Maybe$Just(
										A2($author$project$Api$Model$BasicResult$BasicResult, false, m))
								}),
							$elm$core$Platform$Cmd$none);
					}
				case 13:
					var _v5 = model.e3;
					if (!_v5.$) {
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{e3: $elm$core$Maybe$Nothing}),
							$elm$core$Platform$Cmd$none);
					} else {
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									e3: $elm$core$Maybe$Just(
										_Utils_Tuple2(
											$author$project$Comp$MarkdownInput$init,
											A2($elm$core$Maybe$withDefault, '', model.gm.c6))),
									gz: 0
								}),
							$elm$core$Platform$Cmd$none);
					}
				case 14:
					var lmsg = msg.a;
					var _v6 = model.e3;
					if (!_v6.$) {
						var _v7 = _v6.a;
						var dm = _v7.a;
						var txt = _v7.b;
						var _v8 = A3($author$project$Comp$MarkdownInput$update, txt, lmsg, dm);
						var m = _v8.a;
						var str = _v8.b;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									e3: $elm$core$Maybe$Just(
										_Utils_Tuple2(m, str))
								}),
							$elm$core$Platform$Cmd$none);
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 15:
					var _v9 = model.e3;
					if (!_v9.$) {
						var _v10 = _v9.a;
						var str = _v10.b;
						return _Utils_Tuple2(
							model,
							A4($author$project$Api$setDescription, flags, model.gm.hs, str, $author$project$Page$Detail$Data$BasicResp));
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 16:
					var prop = msg.a;
					var next = (!_Utils_eq(
						A2($author$project$Page$Detail$Data$isEdit, model, prop),
						$elm$core$Maybe$Nothing)) ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(
						_Utils_Tuple2(
							prop,
							A3($author$project$Page$Detail$Data$mkEditField, flags, model, prop)));
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{c8: next}),
						$elm$core$Platform$Cmd$none);
				case 17:
					var str = msg.a;
					var _v11 = model.c8;
					if ((!_v11.$) && (!_v11.a.b.$)) {
						var _v12 = _v11.a;
						var p = _v12.a;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									c8: $elm$core$Maybe$Just(
										_Utils_Tuple2(
											p,
											$author$project$Page$Detail$Data$EditName(
												$author$project$Util$Maybe$fromString(str))))
								}),
							$elm$core$Platform$Cmd$none);
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 18:
					var lmsg = msg.a;
					var _v13 = model.c8;
					if ((!_v13.$) && (_v13.a.b.$ === 1)) {
						var _v14 = _v13.a;
						var p = _v14.a;
						var _v15 = _v14.b.a;
						var im = _v15.a;
						var _v16 = A2($author$project$Comp$IntInput$update, lmsg, im);
						var m = _v16.a;
						var mi = _v16.b;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									c8: $elm$core$Maybe$Just(
										_Utils_Tuple2(
											p,
											$author$project$Page$Detail$Data$EditMaxViews(
												_Utils_Tuple2(m, mi))))
								}),
							$elm$core$Platform$Cmd$none);
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 19:
					var lmsg = msg.a;
					var _v17 = model.c8;
					if ((!_v17.$) && (_v17.a.b.$ === 2)) {
						var _v18 = _v17.a;
						var p = _v18.a;
						var _v19 = _v18.b.a;
						var m = _v19.a;
						var v = _v19.b;
						var _v20 = A2($author$project$Comp$ValidityField$update, lmsg, m);
						var nm = _v20.a;
						var nv = _v20.b;
						var dv = A2($elm$core$Maybe$withDefault, v, nv);
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									c8: $elm$core$Maybe$Just(
										_Utils_Tuple2(
											p,
											$author$project$Page$Detail$Data$EditValidity(
												_Utils_Tuple2(nm, dv))))
								}),
							$elm$core$Platform$Cmd$none);
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 20:
					var lmsg = msg.a;
					var _v21 = model.c8;
					if ((!_v21.$) && (_v21.a.b.$ === 3)) {
						var _v22 = _v21.a;
						var p = _v22.a;
						var _v23 = _v22.b.a;
						var m = _v23.a;
						var _v24 = A2($author$project$Comp$PasswordInput$update, lmsg, m);
						var nm = _v24.a;
						var nv = _v24.b;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									c8: $elm$core$Maybe$Just(
										_Utils_Tuple2(
											p,
											$author$project$Page$Detail$Data$EditPassword(
												_Utils_Tuple2(nm, nv))))
								}),
							$elm$core$Platform$Cmd$none);
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 22:
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{c8: $elm$core$Maybe$Nothing}),
						$elm$core$Platform$Cmd$none);
				case 32:
					var code = msg.a;
					if ((!code.$) && (code.a.$ === 4)) {
						var _v26 = code.a;
						var $temp$flags = flags,
							$temp$msg = $author$project$Page$Detail$Data$SaveEdit,
							$temp$model = model;
						flags = $temp$flags;
						msg = $temp$msg;
						model = $temp$model;
						continue update;
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 21:
					var nm = _Utils_update(
						model,
						{c8: $elm$core$Maybe$Nothing});
					var _v27 = model.c8;
					if (!_v27.$) {
						switch (_v27.a.b.$) {
							case 0:
								var _v28 = _v27.a;
								var name = _v28.b.a;
								return _Utils_Tuple2(
									nm,
									A4($author$project$Api$setName, flags, model.gm.hs, name, $author$project$Page$Detail$Data$BasicResp));
							case 1:
								if (!_v27.a.b.a.b.$) {
									var _v29 = _v27.a;
									var _v30 = _v29.b.a;
									var value = _v30.b.a;
									return _Utils_Tuple2(
										nm,
										A4($author$project$Api$setMaxViews, flags, model.gm.hs, value, $author$project$Page$Detail$Data$BasicResp));
								} else {
									var _v31 = _v27.a;
									var _v32 = _v31.b.a;
									var _v33 = _v32.b;
									return _Utils_Tuple2(nm, $elm$core$Platform$Cmd$none);
								}
							case 2:
								var _v34 = _v27.a;
								var _v35 = _v34.b.a;
								var value = _v35.b;
								return _Utils_Tuple2(
									nm,
									A4(
										$author$project$Api$setValidity,
										flags,
										model.gm.hs,
										$author$project$Data$ValidityValue$toMillis(value),
										$author$project$Page$Detail$Data$BasicResp));
							default:
								var _v36 = _v27.a;
								var _v37 = _v36.b.a;
								var pw = _v37.b;
								return _Utils_Tuple2(
									nm,
									A4($author$project$Api$setPassword, flags, model.gm.hs, pw, $author$project$Page$Detail$Data$BasicResp));
						}
					} else {
						return _Utils_Tuple2(nm, $elm$core$Platform$Cmd$none);
					}
				case 23:
					var lmsg = msg.a;
					var _v38 = A3($author$project$Comp$Dropzone2$update, model.iO.il, lmsg, model.aV);
					var m = _v38.a;
					var c = _v38.b;
					var fs = _v38.c;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								aV: m,
								gA: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
								iO: A2($author$project$Data$UploadDict$updateFiles, model.iO, fs)
							}),
						$elm$core$Platform$Cmd$batch(
							_List_fromArray(
								[
									A2($elm$core$Platform$Cmd$map, $author$project$Page$Detail$Data$DropzoneMsg, c)
								])));
				case 24:
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								aV: $author$project$Comp$Dropzone2$init,
								gA: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
								gD: false,
								iO: $author$project$Data$UploadDict$empty
							}),
						$elm$core$Platform$Cmd$none);
				case 25:
					var valid = A3(
						$author$project$Util$Share$validate,
						flags,
						$elm$core$Maybe$Just(model.gm),
						{g7: '', iO: model.iO});
					var uploadUrl = flags.b.c + ('/api/v2/sec/upload/' + (model.gm.hs + '/files/tus'));
					var _v39 = $elm$core$List$unzip(model.iO.il);
					var _native = _v39.a;
					var submit = _Utils_eq(_native, _List_Nil) ? $elm$core$Platform$Cmd$none : $author$project$Ports$submitFiles(
						$author$project$Data$UploadData$encode(
							A4($author$project$Data$UploadData$UploadData, uploadUrl, model.gm.hs, _native, $elm$core$Maybe$Nothing)));
					return _Utils_eq(_native, _List_Nil) ? _Utils_Tuple2(model, $elm$core$Platform$Cmd$none) : (valid.iA ? _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gA: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
								gD: true
							}),
						submit) : _Utils_Tuple2(
						_Utils_update(
							model,
							{gA: valid}),
						$elm$core$Platform$Cmd$none));
				case 26:
					var state = msg.a;
					if (_Utils_eq(state.hs, model.gm.hs)) {
						var nm = A2($author$project$Page$Detail$Update$trackUpload, model, state);
						var rm = _Utils_update(
							nm,
							{aV: $author$project$Comp$Dropzone2$init, gD: false, iO: $author$project$Data$UploadDict$empty});
						var _v40 = A3(
							$author$project$Page$Detail$Update$update,
							flags,
							$author$project$Page$Detail$Data$Init(model.gm.hs),
							rm);
						var im = _v40.a;
						var ic = _v40.b;
						var _v41 = $author$project$Data$UploadDict$countDone(nm.iO);
						var err = _v41.b;
						return $author$project$Data$UploadDict$allDone(nm.iO) ? ((!err) ? _Utils_Tuple2(im, ic) : _Utils_Tuple2(rm, $elm$core$Platform$Cmd$none)) : _Utils_Tuple2(nm, $elm$core$Platform$Cmd$none);
					} else {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					}
				case 27:
					var err = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gC: _Utils_eq(err, $elm$core$Maybe$Nothing)
							}),
						$elm$core$Platform$Cmd$none);
				case 28:
					return _Utils_Tuple2(
						model,
						model.gC ? $author$project$Ports$startUpload(model.gm.hs) : $author$project$Ports$stopUpload(model.gm.hs));
				case 29:
					var lmsg = msg.a;
					var _v42 = model.X;
					if (_v42.$ === 1) {
						return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
					} else {
						var msm = _v42.a;
						var _v43 = A3($author$project$Comp$MailSend$update, flags, lmsg, msm);
						var mm = _v43.a;
						var act = _v43.b;
						switch (act.$) {
							case 0:
								var c = act.a;
								return _Utils_Tuple2(
									_Utils_update(
										model,
										{
											X: $elm$core$Maybe$Just(mm)
										}),
									A2($elm$core$Platform$Cmd$map, $author$project$Page$Detail$Data$MailFormMsg, c));
							case 1:
								return _Utils_Tuple2(
									_Utils_update(
										model,
										{X: $elm$core$Maybe$Nothing}),
									$elm$core$Platform$Cmd$none);
							default:
								return _Utils_Tuple2(
									_Utils_update(
										model,
										{X: $elm$core$Maybe$Nothing}),
									$elm$core$Platform$Cmd$none);
						}
					}
				case 30:
					var getTpl = A2($author$project$Api$getShareTemplate, flags, model.gm.hs);
					var _v45 = $author$project$Comp$MailSend$init(getTpl);
					var mm = _v45.a;
					var mc = _v45.b;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								X: $elm$core$Maybe$Just(mm)
							}),
						A2($elm$core$Platform$Cmd$map, $author$project$Page$Detail$Data$MailFormMsg, mc));
				case 31:
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				default:
					var iv = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{gp: iv}),
						$elm$core$Platform$Cmd$none);
			}
		}
	});
var $author$project$App$Update$updateDetail = F2(
	function (lmsg, model) {
		var _v0 = A3($author$project$Page$Detail$Update$update, model.fg, lmsg, model.e6);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{e6: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$DetailMsg, lc));
	});
var $author$project$App$Data$LoginMsg = function (a) {
	return {$: 4, a: a};
};
var $author$project$Page$pageFromString = function (str) {
	var urlNormed = A2($elm$core$String$startsWith, str, 'http') ? str : ('http://somehost' + str);
	var url = $elm$url$Url$fromString(urlNormed);
	return A2(
		$elm$core$Maybe$andThen,
		$elm$url$Url$Parser$parse($author$project$Page$parser),
		url);
};
var $author$project$Page$loginPageReferrer = function (page) {
	if (page.$ === 1) {
		var _v1 = page.a;
		var r = _v1.a;
		var flag = _v1.b;
		return _Utils_Tuple2(
			A2($elm$core$Maybe$andThen, $author$project$Page$pageFromString, r),
			flag);
	} else {
		return _Utils_Tuple2($elm$core$Maybe$Nothing, false);
	}
};
var $author$project$Page$Login$Data$AuthResp = function (a) {
	return {$: 4, a: a};
};
var $author$project$Api$Model$UserPass$UserPass = F2(
	function (account, password) {
		return {f: account, d4: password};
	});
var $author$project$Data$Flags$isOAuthAutoRedirect = function (flags) {
	return flags.b.dZ && flags.b.d$;
};
var $author$project$Data$Flags$isProxyAutoRedirect = function (flags) {
	return flags.b.dZ && flags.b.d8;
};
var $author$project$Api$Model$AuthResult$AuthResult = F7(
	function (id, user, admin, success, message, token, validMs) {
		return {cK: admin, hs: id, dU: message, iA: success, eB: token, eD: user, eE: validMs};
	});
var $author$project$Api$Model$AuthResult$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'validMs',
	$elm$json$Json$Decode$int,
	A4(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
		'token',
		$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
		$elm$core$Maybe$Nothing,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'message',
			$elm$json$Json$Decode$string,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
				'success',
				$elm$json$Json$Decode$bool,
				A3(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
					'admin',
					$elm$json$Json$Decode$bool,
					A3(
						$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
						'user',
						$elm$json$Json$Decode$string,
						A3(
							$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
							'id',
							$elm$json$Json$Decode$string,
							$elm$json$Json$Decode$succeed($author$project$Api$Model$AuthResult$AuthResult))))))));
var $author$project$Api$Model$UserPass$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'account',
				$elm$json$Json$Encode$string(value.f)),
				_Utils_Tuple2(
				'password',
				$elm$json$Json$Encode$string(value.d4))
			]));
};
var $elm$http$Http$post = function (r) {
	return $elm$http$Http$request(
		{g: r.g, e: r.e, fk: _List_Nil, hL: 'POST', iE: $elm$core$Maybe$Nothing, A: $elm$core$Maybe$Nothing, d: r.d});
};
var $author$project$Api$login = F3(
	function (flags, up, receive) {
		return $elm$http$Http$post(
			{
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$UserPass$encode(up)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AuthResult$decoder),
				d: flags.b.c + '/api/v2/open/auth/login'
			});
	});
var $author$project$Api$loginProxy = F2(
	function (flags, receive) {
		return $elm$http$Http$post(
			{
				g: $elm$http$Http$emptyBody,
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AuthResult$decoder),
				d: flags.b.c + '/api/v2/open/auth/proxy'
			});
	});
var $author$project$Api$loginSession = F2(
	function (flags, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$emptyBody,
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$AuthResult$decoder),
				d: flags.b.c + '/api/v2/sec/auth/session'
			});
	});
var $author$project$Data$Flags$initialPage = function (flags) {
	return A2(
		$elm$core$Maybe$withDefault,
		$author$project$Page$HomePage,
		$author$project$Page$pageFromString('/app/' + flags.b.dC));
};
var $author$project$Ports$removeAccount = _Platform_outgoingPort(
	'removeAccount',
	function ($) {
		return $elm$json$Json$Encode$null;
	});
var $elm$core$Maybe$destruct = F3(
	function (_default, func, maybe) {
		if (!maybe.$) {
			var a = maybe.a;
			return func(a);
		} else {
			return _default;
		}
	});
var $author$project$Ports$setAccount = _Platform_outgoingPort(
	'setAccount',
	function ($) {
		return $elm$json$Json$Encode$object(
			_List_fromArray(
				[
					_Utils_Tuple2(
					'admin',
					$elm$json$Json$Encode$bool($.cK)),
					_Utils_Tuple2(
					'id',
					$elm$json$Json$Encode$string($.hs)),
					_Utils_Tuple2(
					'message',
					$elm$json$Json$Encode$string($.dU)),
					_Utils_Tuple2(
					'success',
					$elm$json$Json$Encode$bool($.iA)),
					_Utils_Tuple2(
					'token',
					function ($) {
						return A3($elm$core$Maybe$destruct, $elm$json$Json$Encode$null, $elm$json$Json$Encode$string, $);
					}($.eB)),
					_Utils_Tuple2(
					'user',
					$elm$json$Json$Encode$string($.eD)),
					_Utils_Tuple2(
					'validMs',
					$elm$json$Json$Encode$int($.eE))
				]));
	});
var $author$project$Page$Login$Update$setAccount = function (result) {
	return result.iA ? $author$project$Ports$setAccount(result) : $author$project$Ports$removeAccount(0);
};
var $author$project$Page$Login$Update$loginSuccess = F4(
	function (referrer, flags, res, model) {
		var defaultPage = $author$project$Data$Flags$initialPage(flags);
		var gotoRef = $author$project$Page$goto(
			A2($elm$core$Maybe$withDefault, defaultPage, referrer));
		var ar = $elm$core$Maybe$Just(res);
		return _Utils_Tuple3(
			_Utils_update(
				model,
				{d4: '', P: ar}),
			$elm$core$Platform$Cmd$batch(
				_List_fromArray(
					[
						$author$project$Page$Login$Update$setAccount(res),
						gotoRef
					])),
			ar);
	});
var $elm$core$List$isEmpty = function (xs) {
	if (!xs.b) {
		return true;
	} else {
		return false;
	}
};
var $author$project$Util$List$nonEmpty = function (list) {
	return !$elm$core$List$isEmpty(list);
};
var $author$project$Api$oauthUrl = F2(
	function (flags, item) {
		return flags.b.c + ('/api/v2/open/auth/oauth/' + item.hs);
	});
var $author$project$Ports$setLanguage = _Platform_outgoingPort('setLanguage', $elm$json$Json$Encode$string);
var $author$project$Ports$setLang = function (lang) {
	return $author$project$Ports$setLanguage(
		$author$project$Messages$toIso2(lang));
};
var $author$project$Comp$LanguageChoose$update = F2(
	function (msg, model) {
		return A2($author$project$Comp$FixedDropdown$update, msg, model);
	});
var $author$project$Page$Login$Update$update = F5(
	function (_v0, flags, key, msg, model) {
		var referrer = _v0.a;
		var oauth = _v0.b;
		switch (msg.$) {
			case 5:
				if (oauth && $author$project$Util$List$nonEmpty(flags.b.d_)) {
					return _Utils_Tuple3(
						model,
						A2($author$project$Api$loginSession, flags, $author$project$Page$Login$Data$AuthResp),
						$elm$core$Maybe$Nothing);
				} else {
					if ((!oauth) && ($author$project$Data$Flags$isOAuthAutoRedirect(flags) && _Utils_eq(flags.f, $elm$core$Maybe$Nothing))) {
						var _v2 = flags.b.d_;
						if (_v2.b && (!_v2.b.b)) {
							var first = _v2.a;
							return _Utils_Tuple3(
								model,
								$elm$browser$Browser$Navigation$load(
									A2($author$project$Api$oauthUrl, flags, first)),
								$elm$core$Maybe$Nothing);
						} else {
							return _Utils_Tuple3(model, $elm$core$Platform$Cmd$none, $elm$core$Maybe$Nothing);
						}
					} else {
						if ((!oauth) && ($author$project$Data$Flags$isProxyAutoRedirect(flags) && _Utils_eq(flags.f, $elm$core$Maybe$Nothing))) {
							return _Utils_Tuple3(
								model,
								A2($author$project$Api$loginProxy, flags, $author$project$Page$Login$Data$AuthResp),
								$elm$core$Maybe$Nothing);
						} else {
							return _Utils_Tuple3(model, $elm$core$Platform$Cmd$none, $elm$core$Maybe$Nothing);
						}
					}
				}
			case 0:
				var str = msg.a;
				return _Utils_Tuple3(
					_Utils_update(
						model,
						{b6: str}),
					$elm$core$Platform$Cmd$none,
					$elm$core$Maybe$Nothing);
			case 1:
				var str = msg.a;
				return _Utils_Tuple3(
					_Utils_update(
						model,
						{d4: str}),
					$elm$core$Platform$Cmd$none,
					$elm$core$Maybe$Nothing);
			case 2:
				return _Utils_Tuple3(
					model,
					A3(
						$author$project$Api$login,
						flags,
						A2($author$project$Api$Model$UserPass$UserPass, model.b6, model.d4),
						$author$project$Page$Login$Data$AuthResp),
					$elm$core$Maybe$Nothing);
			case 3:
				return _Utils_Tuple3(
					model,
					A2($author$project$Api$loginProxy, flags, $author$project$Page$Login$Data$AuthResp),
					$elm$core$Maybe$Nothing);
			case 4:
				if (!msg.a.$) {
					var lr = msg.a.a;
					return lr.iA ? A4($author$project$Page$Login$Update$loginSuccess, referrer, flags, lr, model) : _Utils_Tuple3(
						_Utils_update(
							model,
							{
								d4: '',
								P: $elm$core$Maybe$Just(lr)
							}),
						$author$project$Ports$removeAccount(0),
						$elm$core$Maybe$Just(lr));
				} else {
					var err = msg.a.a;
					var empty = $author$project$Api$Model$AuthResult$empty;
					var lr = _Utils_update(
						empty,
						{
							dU: $author$project$Util$Http$errorToString(err)
						});
					return _Utils_Tuple3(
						_Utils_update(
							model,
							{
								d4: '',
								P: $elm$core$Maybe$Just(lr)
							}),
						$author$project$Ports$removeAccount(0),
						$elm$core$Maybe$Just(empty));
				}
			default:
				var lmsg = msg.a;
				var _v3 = A2($author$project$Comp$LanguageChoose$update, lmsg, model.fx);
				var lm = _v3.a;
				var ll = _v3.b;
				var cmd = function () {
					if (!ll.$) {
						var lang = ll.a;
						return $author$project$Ports$setLang(lang);
					} else {
						return $elm$core$Platform$Cmd$none;
					}
				}();
				return _Utils_Tuple3(
					_Utils_update(
						model,
						{fx: lm}),
					cmd,
					$elm$core$Maybe$Nothing);
		}
	});
var $author$project$Data$Flags$withAccount = F2(
	function (flags, acc) {
		return _Utils_update(
			flags,
			{
				f: $elm$core$Maybe$Just(acc)
			});
	});
var $author$project$App$Update$updateLogin = F2(
	function (lmsg, model) {
		var _v0 = A5(
			$author$project$Page$Login$Update$update,
			$author$project$Page$loginPageReferrer(model.f$),
			model.fg,
			model.dH,
			lmsg,
			model.fG);
		var lm = _v0.a;
		var lc = _v0.b;
		var ar = _v0.c;
		var newFlags = A2(
			$elm$core$Maybe$withDefault,
			model.fg,
			A2(
				$elm$core$Maybe$map,
				$author$project$Data$Flags$withAccount(model.fg),
				ar));
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{fg: newFlags, fG: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$LoginMsg, lc));
	});
var $author$project$App$Data$OpenDetailMsg = function (a) {
	return {$: 15, a: a};
};
var $author$project$Page$OpenDetail$Data$DetailResp = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$ShareFileList$ViewCard = 1;
var $author$project$Util$Http$getH = function (req) {
	return $elm$http$Http$request(
		{g: $elm$http$Http$emptyBody, e: req.e, fk: req.fk, hL: 'GET', iE: $elm$core$Maybe$Nothing, A: $elm$core$Maybe$Nothing, d: req.d});
};
var $author$project$Api$getOpenShare = F4(
	function (flags, id, pass, receive) {
		return $author$project$Util$Http$getH(
			{
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$ShareDetail$decoder),
				fk: function () {
					if (!pass.$) {
						var pw = pass.a;
						return _List_fromArray(
							[
								A2(
								$elm$http$Http$header,
								'Sharry-Password',
								$elm$url$Url$percentEncode(pw))
							]);
					} else {
						return _List_Nil;
					}
				}(),
				d: flags.b.c + ('/api/v2/open/share/' + id)
			});
	});
var $elm$core$List$sortBy = _List_sortBy;
var $author$project$Page$OpenDetail$Update$update = F4(
	function (flags, initialView, msg, model) {
		update:
		while (true) {
			switch (msg.$) {
				case 0:
					var id = msg.a;
					var share = model.gm;
					var withId = _Utils_update(
						share,
						{hs: id});
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{gm: withId}),
						A4($author$project$Api$getOpenShare, flags, id, model.d4.fc, $author$project$Page$OpenDetail$Data$DetailResp));
				case 1:
					if (!msg.a.$) {
						var details = msg.a.a;
						var setView = function (m) {
							switch (initialView) {
								case 0:
									return _Utils_update(
										m,
										{fe: 0});
								case 1:
									return _Utils_update(
										m,
										{fe: 1});
								default:
									return _Utils_update(
										m,
										{
											fe: 0,
											gM: $elm$core$List$head(
												A2(
													$elm$core$List$sortBy,
													function ($) {
														return $.dg;
													},
													details.dh))
										});
							}
						};
						return _Utils_Tuple2(
							setView(
								_Utils_update(
									model,
									{
										fd: $author$project$Comp$ShareFileList$reset(model.fd),
										dU: $elm$core$Maybe$Nothing,
										d4: $author$project$Page$OpenDetail$Data$emptyPassModel,
										gm: details
									})),
							$elm$core$Platform$Cmd$none);
					} else {
						var err = msg.a.a;
						var pwm = model.d4;
						var m = $author$project$Util$Http$errorToString(err);
						_v2$2:
						while (true) {
							if (err.$ === 3) {
								switch (err.a) {
									case 401:
										return _Utils_Tuple2(
											_Utils_update(
												model,
												{
													d4: _Utils_update(
														pwm,
														{eQ: false, da: true})
												}),
											$elm$core$Platform$Cmd$none);
									case 403:
										return _Utils_Tuple2(
											_Utils_update(
												model,
												{
													d4: _Utils_update(
														pwm,
														{eQ: true, da: true})
												}),
											$elm$core$Platform$Cmd$none);
									default:
										break _v2$2;
								}
							} else {
								break _v2$2;
							}
						}
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									dU: $elm$core$Maybe$Just(
										A2($author$project$Api$Model$BasicResult$BasicResult, false, m))
								}),
							$elm$core$Platform$Cmd$none);
					}
				case 2:
					var lmsg = msg.a;
					var _v3 = A2($author$project$Comp$ShareFileList$update, lmsg, model.fd);
					var m = _v3.a;
					var action = _v3.b;
					switch (action.$) {
						case 1:
							var sf = action.a;
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{
										fd: m,
										gM: $elm$core$Maybe$Just(sf)
									}),
								$author$project$Ports$scrollTop(0));
						case 2:
							var sf = action.a;
							return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
						default:
							return _Utils_Tuple2(
								_Utils_update(
									model,
									{fd: m}),
								$elm$core$Platform$Cmd$none);
					}
				case 3:
					var mode = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fd: $author$project$Comp$ShareFileList$reset(model.fd),
								fe: mode
							}),
						$elm$core$Platform$Cmd$none);
				case 4:
					var _v5 = model.gM;
					if (!_v5.$) {
						var file = _v5.a;
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{gM: $elm$core$Maybe$Nothing}),
							$author$project$Ports$scrollToElem(file.hs));
					} else {
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{gM: $elm$core$Maybe$Nothing}),
							$elm$core$Platform$Cmd$none);
					}
				case 5:
					var sf = msg.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gM: $elm$core$Maybe$Just(sf)
							}),
						$elm$core$Platform$Cmd$none);
				case 6:
					var lmsg = msg.a;
					var current = model.d4;
					var _v6 = A2($author$project$Comp$PasswordInput$update, lmsg, current.fL);
					var pm = _v6.a;
					var pw = _v6.b;
					var next = _Utils_update(
						current,
						{fc: pw, fL: pm});
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{d4: next}),
						$elm$core$Platform$Cmd$none);
				default:
					var $temp$flags = flags,
						$temp$initialView = initialView,
						$temp$msg = $author$project$Page$OpenDetail$Data$Init(model.gm.hs),
						$temp$model = model;
					flags = $temp$flags;
					initialView = $temp$initialView;
					msg = $temp$msg;
					model = $temp$model;
					continue update;
			}
		}
	});
var $author$project$App$Update$updateOpenDetail = F3(
	function (initialView, lmsg, model) {
		var _v0 = A4($author$project$Page$OpenDetail$Update$update, model.fg, initialView, lmsg, model.fX);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{fX: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$OpenDetailMsg, lc));
	});
var $author$project$App$Data$SettingsMsg = function (a) {
	return {$: 13, a: a};
};
var $author$project$Page$Settings$Data$Banner = F2(
	function (success, text) {
		return {iA: success, iD: text};
	});
var $author$project$Page$Settings$Data$CheckPassResp = function (a) {
	return {$: 9, a: a};
};
var $author$project$Page$Settings$Data$GetEmailResp = function (a) {
	return {$: 7, a: a};
};
var $author$project$Api$Model$PasswordChange$PasswordChange = F2(
	function (oldPassword, newPassword) {
		return {dY: newPassword, d0: oldPassword};
	});
var $author$project$Page$Settings$Data$SaveResp = function (a) {
	return {$: 8, a: a};
};
var $author$project$Api$Model$PasswordChange$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'oldPassword',
				$elm$json$Json$Encode$string(value.d0)),
				_Utils_Tuple2(
				'newPassword',
				$elm$json$Json$Encode$string(value.dY))
			]));
};
var $author$project$Api$changePassword = F3(
	function (flags, pwc, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$PasswordChange$encode(pwc)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + '/api/v2/sec/settings/password'
			});
	});
var $author$project$Api$checkPassword = F2(
	function (flags, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + '/api/v2/sec/settings/password'
			});
	});
var $author$project$Api$Model$EmailInfo$EmailInfo = function (email) {
	return {c9: email};
};
var $author$project$Api$Model$EmailInfo$decoder = A4(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
	'email',
	$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
	$elm$core$Maybe$Nothing,
	$elm$json$Json$Decode$succeed($author$project$Api$Model$EmailInfo$EmailInfo));
var $author$project$Api$getEmail = F2(
	function (flags, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$EmailInfo$decoder),
				d: flags.b.c + '/api/v2/sec/settings/email'
			});
	});
var $elm$core$Result$map = F2(
	function (func, ra) {
		if (!ra.$) {
			var a = ra.a;
			return $elm$core$Result$Ok(
				func(a));
		} else {
			var e = ra.a;
			return $elm$core$Result$Err(e);
		}
	});
var $author$project$Api$Model$EmailChange$EmailChange = function (email) {
	return {c9: email};
};
var $author$project$Api$Model$EmailChange$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'email',
				$elm$json$Json$Encode$string(value.c9))
			]));
};
var $author$project$Api$setEmail = F3(
	function (flags, memail, receive) {
		var url = flags.b.c + '/api/v2/sec/settings/email';
		var exp = A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder);
		var acc = $author$project$Api$getAccount(flags);
		if (!memail.$) {
			var email = memail.a;
			return $author$project$Util$Http$authPost(
				{
					f: acc,
					g: $elm$http$Http$jsonBody(
						$author$project$Api$Model$EmailChange$encode(
							$author$project$Api$Model$EmailChange$EmailChange(email))),
					e: exp,
					d: url
				});
		} else {
			return $author$project$Util$Http$authDelete(
				{f: acc, e: exp, d: url});
		}
	});
var $elm$core$Result$withDefault = F2(
	function (def, result) {
		if (!result.$) {
			var a = result.a;
			return a;
		} else {
			return def;
		}
	});
var $author$project$Page$Settings$Update$update = F3(
	function (flags, msg, model) {
		switch (msg.$) {
			case 0:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{eR: $elm$core$Maybe$Nothing}),
					$elm$core$Platform$Cmd$batch(
						_List_fromArray(
							[
								A2($author$project$Api$getEmail, flags, $author$project$Page$Settings$Data$GetEmailResp),
								A2($author$project$Api$checkPassword, flags, $author$project$Page$Settings$Data$CheckPassResp)
							])));
			case 9:
				var res = msg.a;
				var flag = A2(
					$elm$core$Result$withDefault,
					false,
					A2(
						$elm$core$Result$map,
						function ($) {
							return $.iA;
						},
						res));
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							f3: $elm$core$Maybe$Just(flag)
						}),
					$elm$core$Platform$Cmd$none);
			case 7:
				if (!msg.a.$) {
					var r = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								eX: r.c9,
								ag: _Utils_eq(model.ag, $elm$core$Maybe$Nothing) ? r.c9 : model.ag
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								eR: $elm$core$Maybe$Just(
									A2(
										$author$project$Page$Settings$Data$Banner,
										false,
										'Error retrieving current email: ' + $author$project$Util$Http$errorToString(err)))
							}),
						$elm$core$Platform$Cmd$none);
				}
			case 1:
				var str = msg.a;
				var em = $author$project$Util$Maybe$fromString(str);
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{eR: $elm$core$Maybe$Nothing, ag: em}),
					$elm$core$Platform$Cmd$none);
			case 2:
				return _Utils_eq(model.eX, model.ag) ? _Utils_Tuple2(
					_Utils_update(
						model,
						{
							eR: $elm$core$Maybe$Just(
								A2($author$project$Page$Settings$Data$Banner, false, 'E-Mail has not changed.'))
						}),
					$elm$core$Platform$Cmd$none) : _Utils_Tuple2(
					model,
					A3($author$project$Api$setEmail, flags, model.ag, $author$project$Page$Settings$Data$SaveResp));
			case 8:
				if (!msg.a.$) {
					var r = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								eR: $elm$core$Maybe$Just(
									A2($author$project$Page$Settings$Data$Banner, r.iA, r.dU))
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								eR: $elm$core$Maybe$Just(
									A2(
										$author$project$Page$Settings$Data$Banner,
										false,
										'Error on submit: ' + $author$project$Util$Http$errorToString(err)))
							}),
						$elm$core$Platform$Cmd$none);
				}
			case 3:
				var lmsg = msg.a;
				var _v1 = A2($author$project$Comp$PasswordInput$update, lmsg, model.fW);
				var m = _v1.a;
				var pw = _v1.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{eR: $elm$core$Maybe$Nothing, fV: pw, fW: m}),
					$elm$core$Platform$Cmd$none);
			case 4:
				var lmsg = msg.a;
				var _v2 = A2($author$project$Comp$PasswordInput$update, lmsg, model.fR);
				var m = _v2.a;
				var pw = _v2.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{eR: $elm$core$Maybe$Nothing, fP: pw, fR: m}),
					$elm$core$Platform$Cmd$none);
			case 5:
				var lmsg = msg.a;
				var _v3 = A2($author$project$Comp$PasswordInput$update, lmsg, model.fS);
				var m = _v3.a;
				var pw = _v3.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{eR: $elm$core$Maybe$Nothing, fQ: pw, fS: m}),
					$elm$core$Platform$Cmd$none);
			default:
				var pwc = A2(
					$author$project$Api$Model$PasswordChange$PasswordChange,
					A2($elm$core$Maybe$withDefault, '', model.fV),
					A2($elm$core$Maybe$withDefault, '', model.fP));
				var bothEqual = _Utils_eq(model.fP, model.fQ) && (!_Utils_eq(model.fP, $elm$core$Maybe$Nothing));
				return bothEqual ? _Utils_Tuple2(
					model,
					A3($author$project$Api$changePassword, flags, pwc, $author$project$Page$Settings$Data$SaveResp)) : _Utils_Tuple2(
					_Utils_update(
						model,
						{
							eR: $elm$core$Maybe$Just(
								A2($author$project$Page$Settings$Data$Banner, false, 'Passwords don\'t match.'))
						}),
					$elm$core$Platform$Cmd$none);
		}
	});
var $author$project$App$Update$updateSettings = F2(
	function (lmsg, model) {
		var _v0 = A3($author$project$Page$Settings$Update$update, model.fg, lmsg, model.gl);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{gl: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$SettingsMsg, lc));
	});
var $author$project$App$Data$UploadMsg = function (a) {
	return {$: 8, a: a};
};
var $author$project$Page$Upload$Data$SearchResp = function (a) {
	return {$: 2, a: a};
};
var $author$project$Api$Model$ShareList$ShareList = function (items) {
	return {dG: items};
};
var $author$project$Api$Model$ShareListItem$ShareListItem = function (id) {
	return function (name) {
		return function (aliasInfo) {
			return function (validity) {
				return function (maxViews) {
					return function (password) {
						return function (created) {
							return function (files) {
								return function (size) {
									return function (published) {
										return {cL: aliasInfo, c0: created, dh: files, hs: id, dS: maxViews, dX: name, d4: password, ec: published, en: size, eF: validity};
									};
								};
							};
						};
					};
				};
			};
		};
	};
};
var $author$project$Api$Model$AliasIdName$AliasIdName = F2(
	function (id, name) {
		return {hs: id, dX: name};
	});
var $author$project$Api$Model$AliasIdName$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'name',
	$elm$json$Json$Decode$string,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'id',
		$elm$json$Json$Decode$string,
		$elm$json$Json$Decode$succeed($author$project$Api$Model$AliasIdName$AliasIdName)));
var $author$project$Api$Model$ShareListItem$decoder = A4(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
	'published',
	$elm$json$Json$Decode$maybe($elm$json$Json$Decode$bool),
	$elm$core$Maybe$Nothing,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'size',
		$elm$json$Json$Decode$int,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'files',
			$elm$json$Json$Decode$int,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
				'created',
				$elm$json$Json$Decode$int,
				A3(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
					'password',
					$elm$json$Json$Decode$bool,
					A3(
						$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
						'maxViews',
						$elm$json$Json$Decode$int,
						A3(
							$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
							'validity',
							$elm$json$Json$Decode$int,
							A4(
								$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
								'aliasInfo',
								$elm$json$Json$Decode$maybe($author$project$Api$Model$AliasIdName$decoder),
								$elm$core$Maybe$Nothing,
								A4(
									$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
									'name',
									$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
									$elm$core$Maybe$Nothing,
									A3(
										$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
										'id',
										$elm$json$Json$Decode$string,
										$elm$json$Json$Decode$succeed($author$project$Api$Model$ShareListItem$ShareListItem)))))))))));
var $author$project$Api$Model$ShareList$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'items',
	$elm$json$Json$Decode$list($author$project$Api$Model$ShareListItem$decoder),
	$elm$json$Json$Decode$succeed($author$project$Api$Model$ShareList$ShareList));
var $author$project$Api$findShares = F3(
	function (flags, query, receive) {
		return $author$project$Util$Http$authGet(
			{
				f: $author$project$Api$getAccount(flags),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$ShareList$decoder),
				d: flags.b.c + ('/api/v2/sec/share/search?q=' + $elm$url$Url$percentEncode(query))
			});
	});
var $author$project$Comp$ShareTable$update = F2(
	function (msg, model) {
		var acc = msg;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					cG: $elm$core$Maybe$Just(acc)
				}),
			$elm$core$Maybe$Just(acc));
	});
var $author$project$Page$Upload$Update$update = F4(
	function (key, flags, msg, model) {
		switch (msg.$) {
			case 3:
				return _Utils_Tuple2(
					model,
					A3($author$project$Api$findShares, flags, model.h7, $author$project$Page$Upload$Data$SearchResp));
			case 1:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{h7: str}),
					A3($author$project$Api$findShares, flags, str, $author$project$Page$Upload$Data$SearchResp));
			case 0:
				var lmsg = msg.a;
				var _v1 = A2($author$project$Comp$ShareTable$update, lmsg, model.gw);
				var lm = _v1.a;
				var selected = _v1.b;
				var cmd = function () {
					if (!selected.$) {
						var id = selected.a;
						return A2(
							$author$project$Page$set,
							key,
							$author$project$Page$DetailPage(id.hs));
					} else {
						return $elm$core$Platform$Cmd$none;
					}
				}();
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{cG: selected, gw: lm}),
					cmd);
			case 2:
				if (!msg.a.$) {
					var list = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{gi: list.dG}),
						$elm$core$Platform$Cmd$none);
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			default:
				return _Utils_Tuple2(
					model,
					A2($author$project$Page$set, key, $author$project$Page$SharePage));
		}
	});
var $author$project$App$Update$updateUpload = F2(
	function (lmsg, model) {
		var _v0 = A4($author$project$Page$Upload$Update$update, model.dH, model.fg, lmsg, model.gB);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{gB: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$UploadMsg, lc));
	});
var $author$project$App$Update$initPage = F2(
	function (model, page) {
		switch (page.$) {
			case 0:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 1:
				return A2($author$project$App$Update$updateLogin, $author$project$Page$Login$Data$Init, model);
			case 2:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 3:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 4:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 5:
				var aid = page.a;
				return A2(
					$author$project$App$Update$updateAccount,
					$author$project$Page$Account$Data$Init(aid),
					model);
			case 6:
				var aid = page.a;
				return A2(
					$author$project$App$Update$updateAlias,
					$author$project$Page$Alias$Data$Init(aid),
					model);
			case 7:
				return A2($author$project$App$Update$updateUpload, $author$project$Page$Upload$Data$Init, model);
			case 8:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 9:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 10:
				return A2($author$project$App$Update$updateSettings, $author$project$Page$Settings$Data$Init, model);
			case 11:
				var id = page.a;
				return A2(
					$author$project$App$Update$updateDetail,
					$author$project$Page$Detail$Data$Init(id),
					model);
			default:
				var id = page.a;
				var initialView = page.b;
				return A3(
					$author$project$App$Update$updateOpenDetail,
					$author$project$Data$InitialView$get(initialView),
					$author$project$Page$OpenDetail$Data$Init(id),
					model);
		}
	});
var $author$project$Api$Model$VersionInfo$VersionInfo = F5(
	function (version, builtAtMillis, builtAtString, gitCommit, gitVersion) {
		return {cT: builtAtMillis, cU: builtAtString, dl: gitCommit, dm: gitVersion, eH: version};
	});
var $author$project$Api$Model$VersionInfo$decoder = A3(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
	'gitVersion',
	$elm$json$Json$Decode$string,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'gitCommit',
		$elm$json$Json$Decode$string,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'builtAtString',
			$elm$json$Json$Decode$string,
			A3(
				$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
				'builtAtMillis',
				$elm$json$Json$Decode$int,
				A3(
					$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
					'version',
					$elm$json$Json$Decode$string,
					$elm$json$Json$Decode$succeed($author$project$Api$Model$VersionInfo$VersionInfo))))));
var $elm$http$Http$get = function (r) {
	return $elm$http$Http$request(
		{g: $elm$http$Http$emptyBody, e: r.e, fk: _List_Nil, hL: 'GET', iE: $elm$core$Maybe$Nothing, A: $elm$core$Maybe$Nothing, d: r.d});
};
var $author$project$Api$versionInfo = F2(
	function (flags, receive) {
		return $elm$http$Http$get(
			{
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$VersionInfo$decoder),
				d: flags.b.c + '/api/v2/open/info/version'
			});
	});
var $author$project$Main$init = F3(
	function (flags, url, key) {
		var im = A3($author$project$App$Data$init, key, url, flags);
		var page = A2($author$project$App$Data$checkPage, flags, im.f$);
		var _v0 = _Utils_eq(im.f$, page) ? A2($author$project$App$Update$initPage, im, page) : _Utils_Tuple2(
			im,
			$author$project$Page$goto(page));
		var m = _v0.a;
		var cmd = _v0.b;
		var sessionCheck = function () {
			var _v1 = m.fg.f;
			if (!_v1.$) {
				return A2($author$project$Api$loginSession, flags, $author$project$App$Data$SessionCheckResp);
			} else {
				return $elm$core$Platform$Cmd$none;
			}
		}();
		return _Utils_Tuple2(
			m,
			$elm$core$Platform$Cmd$batch(
				_List_fromArray(
					[
						cmd,
						A2($author$project$Api$versionInfo, flags, $author$project$App$Data$VersionResp),
						sessionCheck
					])));
	});
var $author$project$App$Data$ReceiveLanguage = function (a) {
	return {$: 23, a: a};
};
var $elm$core$Platform$Sub$batch = _Platform_batch;
var $author$project$Ports$receiveLanguage = _Platform_incomingPort('receiveLanguage', $elm$json$Json$Decode$string);
var $author$project$App$Data$UploadStateMsg = function (a) {
	return {$: 21, a: a};
};
var $author$project$Data$UploadState$UploadState = F3(
	function (id, file, state) {
		return {hi: file, hs: id, ev: state};
	});
var $elm$json$Json$Decode$map3 = _Json_map3;
var $author$project$Data$UploadState$Complete = {$: 0};
var $author$project$Data$UploadState$Failed = function (a) {
	return {$: 2, a: a};
};
var $author$project$Data$UploadState$Progress = F2(
	function (a, b) {
		return {$: 1, a: a, b: b};
	});
var $author$project$Data$UploadState$constant = function (str) {
	var check = function (s) {
		return _Utils_eq(
			$elm$core$String$toLower(str),
			s) ? $elm$json$Json$Decode$succeed(0) : $elm$json$Json$Decode$fail('Expected ' + (str + (' but got: ' + s)));
	};
	return A2(
		$elm$json$Json$Decode$andThen,
		check,
		A2($elm$json$Json$Decode$map, $elm$core$String$toLower, $elm$json$Json$Decode$string));
};
var $author$project$Data$UploadState$convertErrorMessage = function (str) {
	return A2($elm$core$String$contains, 'response code: 422', str) ? A2(
		$elm$core$Maybe$withDefault,
		str,
		A2(
			$elm$core$Maybe$map,
			$elm$core$String$trim,
			A2(
				$elm$core$Maybe$map,
				function (n) {
					return A3(
						$elm$core$String$slice,
						n,
						$elm$core$String$length(str) - 1,
						str);
				},
				A2(
					$elm$core$Maybe$map,
					$elm$core$Basics$add(14),
					$elm$core$List$head(
						A2($elm$core$String$indexes, 'response text:', str)))))) : str;
};
var $author$project$Data$UploadState$progressDecoder = function () {
	var progress = A4(
		$elm$json$Json$Decode$map3,
		function (a) {
			return function (b) {
				return function (_v2) {
					return A2($author$project$Data$UploadState$Progress, a, b);
				};
			};
		},
		A2($elm$json$Json$Decode$field, 'uploaded', $elm$json$Json$Decode$int),
		A2($elm$json$Json$Decode$field, 'total', $elm$json$Json$Decode$int),
		A2(
			$elm$json$Json$Decode$field,
			'state',
			$author$project$Data$UploadState$constant('progress')));
	var failed = A3(
		$elm$json$Json$Decode$map2,
		function (e) {
			return function (_v1) {
				return $author$project$Data$UploadState$Failed(e);
			};
		},
		A2(
			$elm$json$Json$Decode$map,
			$author$project$Data$UploadState$convertErrorMessage,
			A2($elm$json$Json$Decode$field, 'error', $elm$json$Json$Decode$string)),
		A2(
			$elm$json$Json$Decode$field,
			'state',
			$author$project$Data$UploadState$constant('failed')));
	var complete = A2(
		$elm$json$Json$Decode$map,
		function (_v0) {
			return $author$project$Data$UploadState$Complete;
		},
		A2(
			$elm$json$Json$Decode$field,
			'state',
			$author$project$Data$UploadState$constant('complete')));
	return $elm$json$Json$Decode$oneOf(
		_List_fromArray(
			[complete, failed, progress]));
}();
var $author$project$Data$UploadState$decoder = A4(
	$elm$json$Json$Decode$map3,
	$author$project$Data$UploadState$UploadState,
	A2($elm$json$Json$Decode$field, 'id', $elm$json$Json$Decode$string),
	A2($elm$json$Json$Decode$field, 'file', $elm$json$Json$Decode$int),
	A2($elm$json$Json$Decode$field, 'progress', $author$project$Data$UploadState$progressDecoder));
var $author$project$Data$UploadState$decode = function (json) {
	return A2(
		$elm$core$Result$mapError,
		$elm$json$Json$Decode$errorToString,
		A2($elm$json$Json$Decode$decodeValue, $author$project$Data$UploadState$decoder, json));
};
var $author$project$Ports$uploadState = _Platform_incomingPort('uploadState', $elm$json$Json$Decode$value);
var $author$project$Main$uploadStateSub = $author$project$Ports$uploadState(
	A2($elm$core$Basics$composeR, $author$project$Data$UploadState$decode, $author$project$App$Data$UploadStateMsg));
var $author$project$App$Data$UploadStoppedMsg = function (a) {
	return {$: 22, a: a};
};
var $author$project$Ports$uploadStopped = _Platform_incomingPort(
	'uploadStopped',
	$elm$json$Json$Decode$oneOf(
		_List_fromArray(
			[
				$elm$json$Json$Decode$null($elm$core$Maybe$Nothing),
				A2($elm$json$Json$Decode$map, $elm$core$Maybe$Just, $elm$json$Json$Decode$string)
			])));
var $author$project$Main$uploadStopped = $author$project$Ports$uploadStopped($author$project$App$Data$UploadStoppedMsg);
var $author$project$Main$subscriptions = function (model) {
	var uploadSubs = $elm$core$Platform$Sub$batch(
		_List_fromArray(
			[$author$project$Main$uploadStateSub, $author$project$Main$uploadStopped]));
	var langSub = $author$project$Ports$receiveLanguage($author$project$App$Data$ReceiveLanguage);
	var _v0 = model.f$;
	switch (_v0.$) {
		case 8:
			return $elm$core$Platform$Sub$batch(
				_List_fromArray(
					[uploadSubs, langSub]));
		case 9:
			return $elm$core$Platform$Sub$batch(
				_List_fromArray(
					[uploadSubs, langSub]));
		case 11:
			return $elm$core$Platform$Sub$batch(
				_List_fromArray(
					[uploadSubs, langSub]));
		default:
			return langSub;
	}
};
var $author$project$App$Data$LogoutResp = function (a) {
	return {$: 17, a: a};
};
var $author$project$Page$Detail$Data$UploadStopped = function (a) {
	return {$: 27, a: a};
};
var $author$project$Page$OpenShare$Data$UploadStopped = function (a) {
	return {$: 7, a: a};
};
var $author$project$Page$Share$Data$UploadStopped = function (a) {
	return {$: 11, a: a};
};
var $author$project$Page$Detail$Data$Uploading = function (a) {
	return {$: 26, a: a};
};
var $author$project$Page$OpenShare$Data$Uploading = function (a) {
	return {$: 5, a: a};
};
var $author$project$Page$Share$Data$Uploading = function (a) {
	return {$: 9, a: a};
};
var $elm$core$Tuple$mapSecond = F2(
	function (func, _v0) {
		var x = _v0.a;
		var y = _v0.b;
		return _Utils_Tuple2(
			x,
			func(y));
	});
var $author$project$Util$Update$andThen1 = F2(
	function (fs, a) {
		var update = F2(
			function (el, tuple) {
				var _v0 = el(tuple.a);
				var a2 = _v0.a;
				var c2 = _v0.b;
				return _Utils_Tuple2(
					a2,
					A2($elm$core$List$cons, c2, tuple.b));
			});
		var init = _Utils_Tuple2(a, _List_Nil);
		return A2(
			$elm$core$Tuple$mapSecond,
			$elm$core$Platform$Cmd$batch,
			A3($elm$core$List$foldl, update, init, fs));
	});
var $author$project$Data$UiTheme$cycle = function (current) {
	if (!current) {
		return 1;
	} else {
		return 0;
	}
};
var $elm$http$Http$expectBytesResponse = F2(
	function (toMsg, toResult) {
		return A3(
			_Http_expect,
			'arraybuffer',
			_Http_toDataView,
			A2($elm$core$Basics$composeR, toResult, toMsg));
	});
var $elm$http$Http$expectWhatever = function (toMsg) {
	return A2(
		$elm$http$Http$expectBytesResponse,
		toMsg,
		$elm$http$Http$resolve(
			function (_v0) {
				return $elm$core$Result$Ok(0);
			}));
};
var $author$project$Api$logout = F2(
	function (flags, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$emptyBody,
				e: $elm$http$Http$expectWhatever(receive),
				d: flags.b.c + '/api/v2/sec/auth/logout'
			});
	});
var $elm$core$Basics$composeL = F3(
	function (g, f, x) {
		return g(
			f(x));
	});
var $elm$core$Task$onError = _Scheduler_onError;
var $elm$core$Task$attempt = F2(
	function (resultToMessage, task) {
		return $elm$core$Task$command(
			A2(
				$elm$core$Task$onError,
				A2(
					$elm$core$Basics$composeL,
					A2($elm$core$Basics$composeL, $elm$core$Task$succeed, resultToMessage),
					$elm$core$Result$Err),
				A2(
					$elm$core$Task$andThen,
					A2(
						$elm$core$Basics$composeL,
						A2($elm$core$Basics$composeL, $elm$core$Task$succeed, resultToMessage),
						$elm$core$Result$Ok),
					task)));
	});
var $elm$core$Process$sleep = _Process_sleep;
var $author$project$Util$Http$executeIn = F3(
	function (delay, receive, task) {
		return A2(
			$elm$core$Task$attempt,
			receive,
			A2(
				$elm$core$Task$andThen,
				function (_v0) {
					return task;
				},
				$elm$core$Process$sleep(delay)));
	});
var $elm$core$Task$fail = _Scheduler_fail;
var $elm$http$Http$resultToTask = function (result) {
	if (!result.$) {
		var a = result.a;
		return $elm$core$Task$succeed(a);
	} else {
		var x = result.a;
		return $elm$core$Task$fail(x);
	}
};
var $elm$http$Http$task = function (r) {
	return A3(
		_Http_toTask,
		0,
		$elm$http$Http$resultToTask,
		{gU: false, g: r.g, e: r.ib, fk: r.fk, hL: r.hL, iE: r.iE, A: $elm$core$Maybe$Nothing, d: r.d});
};
var $author$project$Util$Http$authTask = function (req) {
	return $elm$http$Http$task(
		{
			g: req.g,
			fk: A2(
				$elm$core$List$cons,
				A2(
					$elm$http$Http$header,
					'Sharry-Auth',
					A2($elm$core$Maybe$withDefault, '', req.f.eB)),
				req.fk),
			hL: req.hL,
			ib: req.ib,
			iE: req.iE,
			d: req.d
		});
};
var $elm$http$Http$stringResolver = A2(_Http_expect, '', $elm$core$Basics$identity);
var $author$project$Util$Http$jsonResolver = function (decoder) {
	return $elm$http$Http$stringResolver(
		function (response) {
			switch (response.$) {
				case 0:
					var url = response.a;
					return $elm$core$Result$Err(
						$elm$http$Http$BadUrl(url));
				case 1:
					return $elm$core$Result$Err($elm$http$Http$Timeout);
				case 2:
					return $elm$core$Result$Err($elm$http$Http$NetworkError);
				case 3:
					var metadata = response.a;
					return $elm$core$Result$Err(
						$elm$http$Http$BadStatus(metadata.iu));
				default:
					var body = response.b;
					var _v1 = A2($elm$json$Json$Decode$decodeString, decoder, body);
					if (!_v1.$) {
						var value = _v1.a;
						return $elm$core$Result$Ok(value);
					} else {
						var err = _v1.a;
						return $elm$core$Result$Err(
							$elm$http$Http$BadBody(
								$elm$json$Json$Decode$errorToString(err)));
					}
			}
		});
};
var $author$project$Api$refreshSessionTask = function (flags) {
	return $author$project$Util$Http$authTask(
		{
			f: $author$project$Api$getAccount(flags),
			g: $elm$http$Http$emptyBody,
			fk: _List_Nil,
			hL: 'POST',
			ib: $author$project$Util$Http$jsonResolver($author$project$Api$Model$AuthResult$decoder),
			iE: $elm$core$Maybe$Nothing,
			d: flags.b.c + '/api/v2/sec/auth/session'
		});
};
var $author$project$Api$refreshSession = F2(
	function (flags, receive) {
		var _v0 = flags.f;
		if (!_v0.$) {
			var acc = _v0.a;
			if (acc.iA) {
				var delay = flags.b.gW;
				return A3(
					$author$project$Util$Http$executeIn,
					delay,
					receive,
					$author$project$Api$refreshSessionTask(flags));
			} else {
				return $elm$core$Platform$Cmd$none;
			}
		} else {
			return $elm$core$Platform$Cmd$none;
		}
	});
var $author$project$Ports$internalSetUiTheme = _Platform_outgoingPort('internalSetUiTheme', $elm$json$Json$Encode$string);
var $author$project$Data$UiTheme$toString = function (theme) {
	if (!theme) {
		return 'Light';
	} else {
		return 'Dark';
	}
};
var $author$project$Ports$setUiTheme = function (theme) {
	return $author$project$Ports$internalSetUiTheme(
		$author$project$Data$UiTheme$toString(theme));
};
var $author$project$App$Data$HomeMsg = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$Home$Update$update = F3(
	function (flags, msg, model) {
		return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
	});
var $author$project$App$Update$updateHome = F2(
	function (lmsg, model) {
		var _v0 = A3($author$project$Page$Home$Update$update, model.fg, lmsg, model.fn);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{fn: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$HomeMsg, lc));
	});
var $author$project$App$Data$InfoMsg = function (a) {
	return {$: 7, a: a};
};
var $author$project$Page$Info$Update$update = F3(
	function (flags, msg, model) {
		return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
	});
var $author$project$App$Update$updateInfo = F2(
	function (lmsg, model) {
		var _v0 = A3($author$project$Page$Info$Update$update, model.fg, lmsg, model.ft);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{ft: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$InfoMsg, lc));
	});
var $author$project$App$Data$NewInviteMsg = function (a) {
	return {$: 6, a: a};
};
var $author$project$Page$NewInvite$Data$Failed = function (a) {
	return {$: 1, a: a};
};
var $author$project$Api$Model$GenInvite$GenInvite = function (password) {
	return {d4: password};
};
var $author$project$Page$NewInvite$Data$InviteResp = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$NewInvite$Data$Success = function (a) {
	return {$: 2, a: a};
};
var $author$project$Api$Model$InviteResult$InviteResult = F3(
	function (success, message, key) {
		return {dH: key, dU: message, iA: success};
	});
var $author$project$Api$Model$InviteResult$decoder = A4(
	$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$optional,
	'key',
	$elm$json$Json$Decode$maybe($elm$json$Json$Decode$string),
	$elm$core$Maybe$Nothing,
	A3(
		$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
		'message',
		$elm$json$Json$Decode$string,
		A3(
			$NoRedInk$elm_json_decode_pipeline$Json$Decode$Pipeline$required,
			'success',
			$elm$json$Json$Decode$bool,
			$elm$json$Json$Decode$succeed($author$project$Api$Model$InviteResult$InviteResult))));
var $author$project$Api$Model$GenInvite$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'password',
				$elm$json$Json$Encode$string(value.d4))
			]));
};
var $author$project$Api$newInvite = F3(
	function (flags, req, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$GenInvite$encode(req)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$InviteResult$decoder),
				d: flags.b.c + '/api/v2/admin/signup/newinvite'
			});
	});
var $author$project$Page$NewInvite$Update$update = F3(
	function (flags, msg, model) {
		switch (msg.$) {
			case 0:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{d4: str}),
					$elm$core$Platform$Cmd$none);
			case 2:
				return _Utils_Tuple2($author$project$Page$NewInvite$Data$emptyModel, $elm$core$Platform$Cmd$none);
			case 1:
				return _Utils_Tuple2(
					model,
					A3(
						$author$project$Api$newInvite,
						flags,
						$author$project$Api$Model$GenInvite$GenInvite(model.d4),
						$author$project$Page$NewInvite$Data$InviteResp));
			default:
				if (!msg.a.$) {
					var res = msg.a.a;
					return res.iA ? _Utils_Tuple2(
						_Utils_update(
							model,
							{
								P: $author$project$Page$NewInvite$Data$Success(res)
							}),
						$elm$core$Platform$Cmd$none) : _Utils_Tuple2(
						_Utils_update(
							model,
							{
								P: $author$project$Page$NewInvite$Data$Failed(res.dU)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								P: $author$project$Page$NewInvite$Data$Failed(
									$author$project$Util$Http$errorToString(err))
							}),
						$elm$core$Platform$Cmd$none);
				}
		}
	});
var $author$project$App$Update$updateNewInvite = F2(
	function (lmsg, model) {
		var _v0 = A3($author$project$Page$NewInvite$Update$update, model.fg, lmsg, model.fO);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{fO: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$NewInviteMsg, lc));
	});
var $author$project$App$Data$OpenShareMsg = function (a) {
	return {$: 11, a: a};
};
var $author$project$Page$OpenShare$Data$CreateShareResp = function (a) {
	return {$: 4, a: a};
};
var $author$project$Page$OpenShare$Data$DropzoneMsg = function (a) {
	return {$: 0, a: a};
};
var $author$project$Util$Http$aliasReq = function (req) {
	return $elm$http$Http$request(
		{
			g: req.g,
			e: req.e,
			fk: A2(
				$elm$core$List$cons,
				A2($elm$http$Http$header, 'Sharry-Alias', req.eN),
				req.fk),
			hL: req.hL,
			iE: $elm$core$Maybe$Nothing,
			A: req.A,
			d: req.d
		});
};
var $author$project$Util$Http$aliasPost = function (req) {
	return $author$project$Util$Http$aliasReq(
		{eN: req.eN, g: req.g, e: req.e, fk: _List_Nil, hL: 'POST', A: $elm$core$Maybe$Nothing, d: req.d});
};
var $author$project$Api$Model$ShareProperties$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'name',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.dX)),
				_Utils_Tuple2(
				'validity',
				$elm$json$Json$Encode$int(value.eF)),
				_Utils_Tuple2(
				'description',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.c5)),
				_Utils_Tuple2(
				'maxViews',
				$elm$json$Json$Encode$int(value.dS)),
				_Utils_Tuple2(
				'password',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.d4))
			]));
};
var $author$project$Api$createEmptyShareAlias = F4(
	function (flags, aliasId, props, receive) {
		return $author$project$Util$Http$aliasPost(
			{
				eN: aliasId,
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$ShareProperties$encode(props)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$IdResult$decoder),
				d: flags.b.c + '/api/v2/alias/upload/new'
			});
	});
var $author$project$Page$OpenShare$Update$makeProps = function (model) {
	return {
		c5: $elm$core$Maybe$Just(model.g7),
		dS: 10,
		dX: $elm$core$Maybe$Nothing,
		d4: $elm$core$Maybe$Nothing,
		eF: 0
	};
};
var $author$project$Page$OpenShare$Data$NotifyResp = function (a) {
	return {$: 9, a: a};
};
var $author$project$Api$notifyAliasUpload = F4(
	function (flags, aliasId, shareId, receive) {
		return $author$project$Util$Http$aliasPost(
			{
				eN: aliasId,
				g: $elm$http$Http$emptyBody,
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + ('/api/v2/alias/mail/notify/' + shareId)
			});
	});
var $author$project$Page$OpenShare$Update$trackUpload = F4(
	function (flags, aliasId, model, state) {
		var next = A2($author$project$Data$UploadDict$trackUpload, model.iO, state);
		var notifyCmd = $author$project$Data$UploadDict$allDone(next) ? A4(
			$author$project$Api$notifyAliasUpload,
			flags,
			aliasId,
			A2($elm$core$Maybe$withDefault, '', model.gn),
			$author$project$Page$OpenShare$Data$NotifyResp) : $elm$core$Platform$Cmd$none;
		var infoMsg = function () {
			var _v0 = state.ev;
			if (_v0.$ === 2) {
				var em = _v0.a;
				return A2($author$project$Api$Model$BasicResult$BasicResult, false, em);
			} else {
				return model.fi;
			}
		}();
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{fi: infoMsg, gC: false, iO: next}),
			notifyCmd);
	});
var $author$project$Page$OpenShare$Update$update = F4(
	function (aliasId, flags, msg, model) {
		switch (msg.$) {
			case 0:
				var lmsg = msg.a;
				var _v1 = A3($author$project$Comp$Dropzone2$update, model.iO.il, lmsg, model.e7);
				var m = _v1.a;
				var c = _v1.b;
				var fs = _v1.c;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							e7: m,
							fi: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
							iO: A2($author$project$Data$UploadDict$updateFiles, model.iO, fs)
						}),
					$elm$core$Platform$Cmd$batch(
						_List_fromArray(
							[
								A2($elm$core$Platform$Cmd$map, $author$project$Page$OpenShare$Data$DropzoneMsg, c)
							])));
			case 1:
				var lmsg = msg.a;
				var _v2 = A3($author$project$Comp$MarkdownInput$update, model.g7, lmsg, model.e4);
				var m = _v2.a;
				var txt = _v2.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							g7: txt,
							e4: m,
							fi: A2($author$project$Api$Model$BasicResult$BasicResult, true, '')
						}),
					$elm$core$Platform$Cmd$none);
			case 2:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							iO: A2($author$project$Data$UploadDict$updateFiles, model.iO, _List_Nil)
						}),
					$elm$core$Platform$Cmd$none);
			case 3:
				var valid = A3($author$project$Util$Share$validate, flags, $elm$core$Maybe$Nothing, model);
				return valid.iA ? _Utils_Tuple2(
					_Utils_update(
						model,
						{gD: true}),
					A4(
						$author$project$Api$createEmptyShareAlias,
						flags,
						aliasId,
						$author$project$Page$OpenShare$Update$makeProps(model),
						$author$project$Page$OpenShare$Data$CreateShareResp)) : _Utils_Tuple2(
					_Utils_update(
						model,
						{fi: valid}),
					$elm$core$Platform$Cmd$none);
			case 4:
				if (!msg.a.$) {
					var idres = msg.a.a;
					var uploadUrl = flags.b.c + ('/api/v2/alias/upload/' + (idres.hs + '/files/tus'));
					var _v3 = $elm$core$List$unzip(model.iO.il);
					var _native = _v3.a;
					var submit = _Utils_eq(_native, _List_Nil) ? $elm$core$Platform$Cmd$none : $author$project$Ports$submitFiles(
						$author$project$Data$UploadData$encode(
							A4(
								$author$project$Data$UploadData$UploadData,
								uploadUrl,
								idres.hs,
								_native,
								$elm$core$Maybe$Just(aliasId))));
					return idres.iA ? _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gn: $elm$core$Maybe$Just(idres.hs)
							}),
						submit) : _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fi: A2($author$project$Api$Model$BasicResult$BasicResult, false, idres.dU)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					if ((err.$ === 3) && (err.a === 403)) {
						return _Utils_Tuple2(
							model,
							$author$project$Page$goto(
								$author$project$Page$InfoPage(1)));
					} else {
						return _Utils_Tuple2(
							_Utils_update(
								model,
								{
									fi: A2(
										$author$project$Api$Model$BasicResult$BasicResult,
										false,
										$author$project$Util$Http$errorToString(err)),
									gD: false
								}),
							$elm$core$Platform$Cmd$none);
					}
				}
			case 5:
				var state = msg.a;
				return _Utils_eq(
					$elm$core$Maybe$Just(state.hs),
					model.gn) ? A4($author$project$Page$OpenShare$Update$trackUpload, flags, aliasId, model, state) : _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 6:
				var _v5 = model.gn;
				if (!_v5.$) {
					var id = _v5.a;
					return _Utils_Tuple2(
						model,
						model.gC ? $author$project$Ports$startUpload(id) : $author$project$Ports$stopUpload(id));
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 7:
				var err = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							gC: _Utils_eq(err, $elm$core$Maybe$Nothing)
						}),
					$elm$core$Platform$Cmd$none);
			case 8:
				return _Utils_Tuple2($author$project$Page$OpenShare$Data$emptyModel, $elm$core$Platform$Cmd$none);
			default:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
		}
	});
var $author$project$App$Update$updateOpenShare = F2(
	function (lmsg, model) {
		var aliasId = function () {
			var _v1 = model.f$;
			if (_v1.$ === 9) {
				var id = _v1.a;
				return id;
			} else {
				return '';
			}
		}();
		var _v0 = A4($author$project$Page$OpenShare$Update$update, aliasId, model.fg, lmsg, model.fY);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{fY: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$OpenShareMsg, lc));
	});
var $author$project$App$Data$RegisterMsg = function (a) {
	return {$: 5, a: a};
};
var $author$project$Page$Register$Data$SubmitResp = function (a) {
	return {$: 7, a: a};
};
var $author$project$Api$Model$Registration$encode = function (value) {
	return $elm$json$Json$Encode$object(
		_List_fromArray(
			[
				_Utils_Tuple2(
				'login',
				$elm$json$Json$Encode$string(value.dK)),
				_Utils_Tuple2(
				'password',
				$elm$json$Json$Encode$string(value.d4)),
				_Utils_Tuple2(
				'invite',
				A2(
					$elm$core$Basics$composeR,
					$elm$core$Maybe$map($elm$json$Json$Encode$string),
					$elm$core$Maybe$withDefault($elm$json$Json$Encode$null))(value.dF))
			]));
};
var $author$project$Api$register = F3(
	function (flags, reg, receive) {
		return $elm$http$Http$post(
			{
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$Registration$encode(reg)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$BasicResult$decoder),
				d: flags.b.c + '/api/v2/open/signup/register'
			});
	});
var $author$project$Page$Register$Update$validateForm = function (model) {
	return ((model.dK === '') || ((model.f1 === '') || (model.f2 === ''))) ? _List_fromArray(
		['All fields are required!']) : ((!_Utils_eq(model.f1, model.f2)) ? _List_fromArray(
		['The passwords do not match.']) : _List_Nil);
};
var $author$project$Page$Register$Update$update = F3(
	function (flags, msg, model) {
		switch (msg.$) {
			case 4:
				var _v1 = model.e9;
				if (!_v1.b) {
					var reg = {dF: model.dF, dK: model.dK, d4: model.f1};
					return _Utils_Tuple2(
						model,
						A3($author$project$Api$register, flags, reg, $author$project$Page$Register$Data$SubmitResp));
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 0:
				var str = msg.a;
				var m = _Utils_update(
					model,
					{dK: str});
				var err = $author$project$Page$Register$Update$validateForm(m);
				return _Utils_Tuple2(
					_Utils_update(
						m,
						{e9: err}),
					$elm$core$Platform$Cmd$none);
			case 1:
				var str = msg.a;
				var m = _Utils_update(
					model,
					{f1: str});
				var err = $author$project$Page$Register$Update$validateForm(m);
				return _Utils_Tuple2(
					_Utils_update(
						m,
						{e9: err}),
					$elm$core$Platform$Cmd$none);
			case 2:
				var str = msg.a;
				var m = _Utils_update(
					model,
					{f2: str});
				var err = $author$project$Page$Register$Update$validateForm(m);
				return _Utils_Tuple2(
					_Utils_update(
						m,
						{e9: err}),
					$elm$core$Platform$Cmd$none);
			case 3:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							dF: (str === '') ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(str)
						}),
					$elm$core$Platform$Cmd$none);
			case 5:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{gq: !model.gq}),
					$elm$core$Platform$Cmd$none);
			case 6:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{gr: !model.gr}),
					$elm$core$Platform$Cmd$none);
			case 7:
				if (!msg.a.$) {
					var r = msg.a.a;
					var m = $author$project$Page$Register$Data$emptyModel;
					var cmd = r.iA ? $author$project$Page$goto(
						$author$project$Page$LoginPage(
							_Utils_Tuple2($elm$core$Maybe$Nothing, false))) : $elm$core$Platform$Cmd$none;
					return _Utils_Tuple2(
						_Utils_update(
							m,
							{
								P: r.iA ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(r)
							}),
						cmd);
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			default:
				var lmsg = msg.a;
				var _v2 = A2($author$project$Comp$LanguageChoose$update, lmsg, model.fx);
				var lm = _v2.a;
				var ll = _v2.b;
				var cmd = function () {
					if (!ll.$) {
						var lang = ll.a;
						return $author$project$Ports$setLang(lang);
					} else {
						return $elm$core$Platform$Cmd$none;
					}
				}();
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{fx: lm}),
					cmd);
		}
	});
var $author$project$App$Update$updateRegister = F2(
	function (lmsg, model) {
		var _v0 = A3($author$project$Page$Register$Update$update, model.fg, lmsg, model.gb);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{gb: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$RegisterMsg, lc));
	});
var $author$project$App$Data$ShareMsg = function (a) {
	return {$: 10, a: a};
};
var $author$project$Page$Share$Data$CreateShareResp = function (a) {
	return {$: 8, a: a};
};
var $author$project$Page$Share$Data$DropzoneMsg = function (a) {
	return {$: 0, a: a};
};
var $author$project$Api$createEmptyShare = F3(
	function (flags, props, receive) {
		return $author$project$Util$Http$authPost(
			{
				f: $author$project$Api$getAccount(flags),
				g: $elm$http$Http$jsonBody(
					$author$project$Api$Model$ShareProperties$encode(props)),
				e: A2($elm$http$Http$expectJson, receive, $author$project$Api$Model$IdResult$decoder),
				d: flags.b.c + '/api/v2/sec/upload/new'
			});
	});
var $author$project$Page$Share$Data$makeProps = function (model) {
	return {
		c5: $elm$core$Maybe$Just(model.g7),
		dS: A2($elm$core$Maybe$withDefault, 10, model.dR),
		dX: model.Y,
		d4: model.Z,
		eF: $author$project$Data$ValidityValue$toMillis(model.ad)
	};
};
var $author$project$Page$Share$Update$trackUpload = F2(
	function (model, state) {
		var next = A2($author$project$Data$UploadDict$trackUpload, model.iO, state);
		var infoMsg = function () {
			var _v0 = state.ev;
			if (_v0.$ === 2) {
				var em = _v0.a;
				return A2($author$project$Api$Model$BasicResult$BasicResult, false, em);
			} else {
				return model.fi;
			}
		}();
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{fi: infoMsg, gC: false, iO: next}),
			$elm$core$Platform$Cmd$none);
	});
var $author$project$Comp$IntField$tooHigh = F2(
	function (model, n) {
		return A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$gt(n),
				model.cA));
	});
var $author$project$Comp$IntField$tooLow = F2(
	function (model, n) {
		return A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$lt(n),
				model.cB));
	});
var $author$project$Comp$IntField$update = F2(
	function (msg, model) {
		var tooLowError = function (texts) {
			return _Utils_ap(
				texts.hO,
				$elm$core$String$fromInt(
					A2($elm$core$Maybe$withDefault, 0, model.cB)));
		};
		var tooHighError = function (texts) {
			return _Utils_ap(
				texts.hP,
				$elm$core$String$fromInt(
					A2($elm$core$Maybe$withDefault, 0, model.cA)));
		};
		var str = msg;
		var m = _Utils_update(
			model,
			{cz: str});
		var _v1 = $elm$core$String$toInt(str);
		if (!_v1.$) {
			var n = _v1.a;
			return A2($author$project$Comp$IntField$tooLow, model, n) ? _Utils_Tuple2(
				_Utils_update(
					m,
					{
						M: $elm$core$Maybe$Just(tooLowError)
					}),
				$elm$core$Maybe$Nothing) : (A2($author$project$Comp$IntField$tooHigh, model, n) ? _Utils_Tuple2(
				_Utils_update(
					m,
					{
						M: $elm$core$Maybe$Just(tooHighError)
					}),
				$elm$core$Maybe$Nothing) : _Utils_Tuple2(
				_Utils_update(
					m,
					{M: $elm$core$Maybe$Nothing}),
				$elm$core$Maybe$Just(n)));
		} else {
			return _Utils_Tuple2(
				_Utils_update(
					m,
					{
						M: $elm$core$Maybe$Just(
							function (texts) {
								return texts.hU(str);
							})
					}),
				$elm$core$Maybe$Nothing);
		}
	});
var $author$project$Page$Share$Update$update = F3(
	function (flags, msg, model) {
		switch (msg.$) {
			case 0:
				var lmsg = msg.a;
				var _v1 = A3($author$project$Comp$Dropzone2$update, model.iO.il, lmsg, model.e7);
				var m = _v1.a;
				var c = _v1.b;
				var fs = _v1.c;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							e7: m,
							fi: A2($author$project$Api$Model$BasicResult$BasicResult, true, ''),
							iO: A2($author$project$Data$UploadDict$updateFiles, model.iO, fs)
						}),
					$elm$core$Platform$Cmd$batch(
						_List_fromArray(
							[
								A2($elm$core$Platform$Cmd$map, $author$project$Page$Share$Data$DropzoneMsg, c)
							])));
			case 1:
				var lmsg = msg.a;
				var _v2 = A2($author$project$Comp$ValidityField$update, lmsg, model.cp);
				var m = _v2.a;
				var sel = _v2.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							ad: A2($elm$core$Maybe$withDefault, model.ad, sel),
							cp: m
						}),
					$elm$core$Platform$Cmd$none);
			case 2:
				var lmsg = msg.a;
				var _v3 = A2($author$project$Comp$PasswordInput$update, lmsg, model.ci);
				var m = _v3.a;
				var pw = _v3.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{Z: pw, ci: m}),
					$elm$core$Platform$Cmd$none);
			case 3:
				var lmsg = msg.a;
				var _v4 = A2($author$project$Comp$IntField$update, lmsg, model.fI);
				var m = _v4.a;
				var v = _v4.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{dR: v, fI: m}),
					$elm$core$Platform$Cmd$none);
			case 4:
				var lmsg = msg.a;
				var _v5 = A3($author$project$Comp$MarkdownInput$update, model.g7, lmsg, model.e4);
				var m = _v5.a;
				var txt = _v5.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							g7: txt,
							e4: m,
							fi: A2($author$project$Api$Model$BasicResult$BasicResult, true, '')
						}),
					$elm$core$Platform$Cmd$none);
			case 5:
				var str = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							Y: $author$project$Util$Maybe$fromString(str)
						}),
					$elm$core$Platform$Cmd$none);
			case 6:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							iO: A2($author$project$Data$UploadDict$updateFiles, model.iO, _List_Nil)
						}),
					$elm$core$Platform$Cmd$none);
			case 7:
				var valid = A3($author$project$Util$Share$validate, flags, $elm$core$Maybe$Nothing, model);
				return valid.iA ? _Utils_Tuple2(
					_Utils_update(
						model,
						{gD: true}),
					A3(
						$author$project$Api$createEmptyShare,
						flags,
						$author$project$Page$Share$Data$makeProps(model),
						$author$project$Page$Share$Data$CreateShareResp)) : _Utils_Tuple2(
					_Utils_update(
						model,
						{fi: valid}),
					$elm$core$Platform$Cmd$none);
			case 8:
				if (!msg.a.$) {
					var idres = msg.a.a;
					var uploadUrl = flags.b.c + ('/api/v2/sec/upload/' + (idres.hs + '/files/tus'));
					var _v6 = $elm$core$List$unzip(model.iO.il);
					var _native = _v6.a;
					var submit = _Utils_eq(_native, _List_Nil) ? $elm$core$Platform$Cmd$none : $author$project$Ports$submitFiles(
						$author$project$Data$UploadData$encode(
							A4($author$project$Data$UploadData$UploadData, uploadUrl, idres.hs, _native, $elm$core$Maybe$Nothing)));
					return idres.iA ? _Utils_Tuple2(
						_Utils_update(
							model,
							{
								gn: $elm$core$Maybe$Just(idres.hs)
							}),
						submit) : _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fi: A2($author$project$Api$Model$BasicResult$BasicResult, false, idres.dU)
							}),
						$elm$core$Platform$Cmd$none);
				} else {
					var err = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{
								fi: A2(
									$author$project$Api$Model$BasicResult$BasicResult,
									false,
									$author$project$Util$Http$errorToString(err)),
								gD: false
							}),
						$elm$core$Platform$Cmd$none);
				}
			case 9:
				var state = msg.a;
				return _Utils_eq(
					$elm$core$Maybe$Just(state.hs),
					model.gn) ? A2($author$project$Page$Share$Update$trackUpload, model, state) : _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
			case 10:
				var _v7 = model.gn;
				if (!_v7.$) {
					var id = _v7.a;
					return _Utils_Tuple2(
						model,
						model.gC ? $author$project$Ports$startUpload(id) : $author$project$Ports$stopUpload(id));
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 11:
				var err = msg.a;
				var infoMsg = function () {
					if (!err.$) {
						var m = err.a;
						return A2($author$project$Api$Model$BasicResult$BasicResult, false, m);
					} else {
						return model.fi;
					}
				}();
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							fi: infoMsg,
							gC: _Utils_eq(err, $elm$core$Maybe$Nothing)
						}),
					$elm$core$Platform$Cmd$none);
			default:
				return _Utils_Tuple2(
					$author$project$Page$Share$Data$emptyModel(flags),
					$elm$core$Platform$Cmd$none);
		}
	});
var $author$project$App$Update$updateShare = F2(
	function (lmsg, model) {
		var _v0 = A3($author$project$Page$Share$Update$update, model.fg, lmsg, model.go);
		var lm = _v0.a;
		var lc = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{go: lm}),
			A2($elm$core$Platform$Cmd$map, $author$project$App$Data$ShareMsg, lc));
	});
var $author$project$Data$Flags$withoutAccount = function (flags) {
	return _Utils_update(
		flags,
		{f: $elm$core$Maybe$Nothing});
};
var $author$project$App$Update$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 26:
				var next = $author$project$Data$UiTheme$cycle(model.eC);
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{fN: false, eC: next}),
					$author$project$Ports$setUiTheme(next));
			case 3:
				var lm = msg.a;
				return A2($author$project$App$Update$updateHome, lm, model);
			case 4:
				var lm = msg.a;
				return A2($author$project$App$Update$updateLogin, lm, model);
			case 5:
				var lm = msg.a;
				return A2($author$project$App$Update$updateRegister, lm, model);
			case 6:
				var lm = msg.a;
				return A2($author$project$App$Update$updateNewInvite, lm, model);
			case 7:
				var lm = msg.a;
				return A2($author$project$App$Update$updateInfo, lm, model);
			case 12:
				var lm = msg.a;
				return A2($author$project$App$Update$updateAccount, lm, model);
			case 9:
				var lm = msg.a;
				return A2($author$project$App$Update$updateAlias, lm, model);
			case 8:
				var lm = msg.a;
				return A2($author$project$App$Update$updateUpload, lm, model);
			case 10:
				var lm = msg.a;
				return A2($author$project$App$Update$updateShare, lm, model);
			case 11:
				var lm = msg.a;
				return A2($author$project$App$Update$updateOpenShare, lm, model);
			case 13:
				var lm = msg.a;
				return A2($author$project$App$Update$updateSettings, lm, model);
			case 14:
				var lm = msg.a;
				return A2($author$project$App$Update$updateDetail, lm, model);
			case 15:
				var lm = msg.a;
				var initialView = function () {
					var _v1 = model.f$;
					if (_v1.$ === 12) {
						var iv = _v1.b;
						return $author$project$Data$InitialView$get(iv);
					} else {
						return $author$project$Data$InitialView$default;
					}
				}();
				return A3($author$project$App$Update$updateOpenDetail, initialView, lm, model);
			case 19:
				var p = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{f$: p}),
					$elm$core$Platform$Cmd$none);
			case 20:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							fy: model.fN ? model.fy : false,
							fN: !model.fN
						}),
					$elm$core$Platform$Cmd$none);
			case 22:
				var err = msg.a;
				return A2(
					$author$project$Util$Update$andThen1,
					_List_fromArray(
						[
							$author$project$App$Update$updateShare(
							$author$project$Page$Share$Data$UploadStopped(err)),
							$author$project$App$Update$updateOpenShare(
							$author$project$Page$OpenShare$Data$UploadStopped(err)),
							$author$project$App$Update$updateDetail(
							$author$project$Page$Detail$Data$UploadStopped(err))
						]),
					model);
			case 21:
				if (!msg.a.$) {
					var lmsg = msg.a.a;
					return A2(
						$author$project$Util$Update$andThen1,
						_List_fromArray(
							[
								$author$project$App$Update$updateShare(
								$author$project$Page$Share$Data$Uploading(lmsg)),
								$author$project$App$Update$updateOpenShare(
								$author$project$Page$OpenShare$Data$Uploading(lmsg)),
								$author$project$App$Update$updateDetail(
								$author$project$Page$Detail$Data$Uploading(lmsg))
							]),
						model);
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 2:
				if (!msg.a.$) {
					var info = msg.a.a;
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{eH: info}),
						$elm$core$Platform$Cmd$none);
				} else {
					return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
				}
			case 16:
				return _Utils_Tuple2(
					model,
					$elm$core$Platform$Cmd$batch(
						_List_fromArray(
							[
								A2($author$project$Api$logout, model.fg, $author$project$App$Data$LogoutResp),
								$author$project$Ports$removeAccount(0)
							])));
			case 17:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{fG: $author$project$Page$Login$Data$empty}),
					$author$project$Page$goto(
						$author$project$Page$LoginPage(
							_Utils_Tuple2($elm$core$Maybe$Nothing, false))));
			case 18:
				var res = msg.a;
				if (!res.$) {
					var lr = res.a;
					var newFlags = lr.iA ? A2($author$project$Data$Flags$withAccount, model.fg, lr) : $author$project$Data$Flags$withoutAccount(model.fg);
					var command = lr.iA ? A2($author$project$Api$refreshSession, newFlags, $author$project$App$Data$SessionCheckResp) : $elm$core$Platform$Cmd$batch(
						_List_fromArray(
							[
								$author$project$Ports$removeAccount(0),
								$author$project$Page$goto(
								$author$project$Page$loginPage(model.f$))
							]));
					return _Utils_Tuple2(
						_Utils_update(
							model,
							{fg: newFlags}),
						command);
				} else {
					return _Utils_Tuple2(
						model,
						$elm$core$Platform$Cmd$batch(
							_List_fromArray(
								[
									$author$project$Ports$removeAccount(0),
									$author$project$Page$goto(
									$author$project$Page$loginPage(model.f$))
								])));
				}
			case 0:
				var req = msg.a;
				if (!req.$) {
					var url = req.a;
					var urlStr = $elm$url$Url$toString(url);
					var isCurrent = A2(
						$elm$core$Maybe$withDefault,
						true,
						A2(
							$elm$core$Maybe$map,
							function (p) {
								return _Utils_eq(p, model.f$);
							},
							$author$project$Page$fromUrl(url)));
					var extern = !A2($elm$core$String$startsWith, model.fg.b.c + '/app', urlStr);
					return _Utils_Tuple2(
						model,
						extern ? $elm$browser$Browser$Navigation$load(urlStr) : (isCurrent ? $elm$core$Platform$Cmd$none : A2(
							$elm$browser$Browser$Navigation$pushUrl,
							model.dH,
							$elm$url$Url$toString(url))));
				} else {
					var url = req.a;
					return _Utils_Tuple2(
						model,
						$elm$browser$Browser$Navigation$load(url));
				}
			case 1:
				var url = msg.a;
				var page = A2(
					$elm$core$Maybe$withDefault,
					$author$project$Page$HomePage,
					$author$project$Page$fromUrl(url));
				var _v4 = A2($author$project$App$Update$initPage, model, page);
				var m = _v4.a;
				var c = _v4.b;
				return _Utils_Tuple2(
					_Utils_update(
						m,
						{f$: page}),
					c);
			case 23:
				var lang = msg.a;
				var flags = model.fg;
				var nf = _Utils_update(
					flags,
					{
						hB: $elm$core$Maybe$Just(lang)
					});
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{fg: nf}),
					$elm$core$Platform$Cmd$none);
			case 25:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							fy: !model.fy,
							fN: model.fy ? model.fN : false
						}),
					$elm$core$Platform$Cmd$none);
			default:
				var lang = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{fy: false}),
					$author$project$Ports$setLang(lang));
		}
	});
var $elm$html$Html$Attributes$stringProperty = F2(
	function (key, string) {
		return A2(
			_VirtualDom_property,
			key,
			$elm$json$Json$Encode$string(string));
	});
var $elm$html$Html$Attributes$class = $elm$html$Html$Attributes$stringProperty('className');
var $elm$html$Html$Attributes$classList = function (classes) {
	return $elm$html$Html$Attributes$class(
		A2(
			$elm$core$String$join,
			' ',
			A2(
				$elm$core$List$map,
				$elm$core$Tuple$first,
				A2($elm$core$List$filter, $elm$core$Tuple$second, classes))));
};
var $elm$html$Html$div = _VirtualDom_node('div');
var $elm$html$Html$a = _VirtualDom_node('a');
var $elm$html$Html$Attributes$href = function (url) {
	return A2(
		$elm$html$Html$Attributes$stringProperty,
		'href',
		_VirtualDom_noJavaScriptUri(url));
};
var $elm$html$Html$i = _VirtualDom_node('i');
var $author$project$Styles$link = ' text-blue-400 hover:text-blue-500 dark:text-sky-300 dark:hover:text-sky-200 cursor-pointer ';
var $elm$html$Html$span = _VirtualDom_node('span');
var $author$project$App$View$styleFooter = 'pt-1 text-xs items-center text-center markdown-preview my-0';
var $elm_explorations$markdown$Markdown$defaultOptions = {
	e$: $elm$core$Maybe$Nothing,
	ho: $elm$core$Maybe$Just(
		{gY: false, iC: false}),
	ig: true,
	is: false
};
var $elm_explorations$markdown$Markdown$toHtmlWith = _Markdown_toHtml;
var $elm_explorations$markdown$Markdown$toHtml = $elm_explorations$markdown$Markdown$toHtmlWith($elm_explorations$markdown$Markdown$defaultOptions);
var $author$project$App$View$footer = function (model) {
	var defaultFooter = A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class($author$project$App$View$styleFooter)
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$a,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$href('https://eikek.github.io/sharry'),
						$elm$html$Html$Attributes$class($author$project$Styles$link)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('ui github icon')
							]),
						_List_Nil),
						$elm$html$Html$text('Sharry ')
					])),
				A2(
				$elm$html$Html$span,
				_List_Nil,
				_List_fromArray(
					[
						$elm$html$Html$text(model.eH.eH),
						$elm$html$Html$text(' (#'),
						$elm$html$Html$text(
						A2($elm$core$String$left, 8, model.eH.dl)),
						$elm$html$Html$text(')')
					]))
			]));
	var customFooter = A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class($author$project$App$View$styleFooter)
			]),
		_List_fromArray(
			[
				A2($elm_explorations$markdown$Markdown$toHtml, _List_Nil, model.fg.b.dj)
			]));
	if (model.fg.b.dk) {
		var _v0 = model.fg.b.dj;
		if (_v0 === '') {
			return defaultFooter;
		} else {
			return customFooter;
		}
	} else {
		return A2(
			$elm$html$Html$span,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('hidden')
				]),
			_List_Nil);
	}
};
var $elm$html$Html$Attributes$id = $elm$html$Html$Attributes$stringProperty('id');
var $author$project$Page$isFixedHeight = function (page) {
	switch (page.$) {
		case 0:
			return true;
		case 1:
			return true;
		case 2:
			return true;
		default:
			return false;
	}
};
var $author$project$App$View$styleContent = 'flex flex-grow';
var $elm$virtual_dom$VirtualDom$map = _VirtualDom_map;
var $elm$html$Html$map = $elm$virtual_dom$VirtualDom$map;
var $author$project$Styles$content = 'container mx-auto px-2 overflow-y-auto scrollbar-main scrollbar-thin flex-grow';
var $author$project$Page$Account$Data$AccountFormMsg = function (a) {
	return {$: 5, a: a};
};
var $elm$html$Html$h1 = _VirtualDom_node('h1');
var $author$project$Styles$header1 = ' text-3xl mt-3 mb-5 font-semibold tracking-wide ';
var $author$project$Util$Html$noElement = A2(
	$elm$html$Html$span,
	_List_fromArray(
		[
			$elm$html$Html$Attributes$class('hidden')
		]),
	_List_Nil);
var $author$project$Styles$errorMessage = ' border border-red-600 bg-red-50 text-red-600 dark:border-orange-800 dark:bg-orange-300 dark:text-orange-800 px-2 py-2 rounded ';
var $author$project$Styles$successMessage = ' border border-green-600 bg-green-50 text-green-600 dark:border-lime-800 dark:bg-lime-300 dark:text-lime-800 px-4 py-2 rounded ';
var $author$project$Util$Html$resultMsgMaybe = function (mres) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$classList(
				_List_fromArray(
					[
						_Utils_Tuple2(
						' hidden',
						_Utils_eq(mres, $elm$core$Maybe$Nothing)),
						_Utils_Tuple2(
						$author$project$Styles$errorMessage,
						_Utils_eq(
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.iA;
								},
								mres),
							$elm$core$Maybe$Just(false))),
						_Utils_Tuple2(
						$author$project$Styles$successMessage,
						_Utils_eq(
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.iA;
								},
								mres),
							$elm$core$Maybe$Just(true)))
					]))
			]),
		_List_fromArray(
			[
				$elm$html$Html$text(
				A2(
					$elm$core$Maybe$withDefault,
					'',
					A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.dU;
						},
						mres)))
			]));
};
var $author$project$Util$Html$resultMsg = function (result) {
	return $author$project$Util$Html$resultMsgMaybe(
		$elm$core$Maybe$Just(result));
};
var $author$project$Comp$AccountForm$Cancel = {$: 5};
var $author$project$Comp$MenuBar$Checkbox = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$MenuBar$CustomButton = function (a) {
	return {$: 7, a: a};
};
var $author$project$Comp$AccountForm$DeleteCancel = {$: 9};
var $author$project$Comp$AccountForm$DeleteConfirm = {$: 8};
var $author$project$Comp$AccountForm$PasswordMsg = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$MenuBar$PrimaryButton = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$AccountForm$RequestDelete = {$: 7};
var $author$project$Comp$MenuBar$SecondaryButton = function (a) {
	return {$: 3, a: a};
};
var $author$project$Comp$AccountForm$SetEmail = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$AccountForm$SetLogin = function (a) {
	return {$: 0, a: a};
};
var $author$project$Comp$AccountForm$StateMsg = function (a) {
	return {$: 3, a: a};
};
var $author$project$Comp$AccountForm$Submit = {$: 6};
var $author$project$Comp$AccountForm$ToggleAdmin = {$: 4};
var $author$project$Comp$ConfirmModal$defaultSettings = F5(
	function (confirm, cancel, okLabel, cancelLabel, confirmMsg) {
		return {cV: cancel, cW: cancelLabel, c_: confirm, c$: okLabel, da: true, de: '', cx: 'text-2xl font-bold text-center w-full', dq: 'fa fa-exclamation-circle mr-3', dU: confirmMsg};
	});
var $author$project$Styles$deleteButton = ' rounded my-auto whitespace-nowrap border border-red-500 dark:border-lightred-500 text-red-500 dark:text-orange-500 text-center px-4 py-2 shadow-none focus:outline-none focus:ring focus:ring-opacity-75 hover:bg-red-600 hover:text-white dark:hover:text-white dark:hover:bg-orange-500 dark:hover:text-stone-900 ';
var $elm$html$Html$Attributes$boolProperty = F2(
	function (key, bool) {
		return A2(
			_VirtualDom_property,
			key,
			$elm$json$Json$Encode$bool(bool));
	});
var $elm$html$Html$Attributes$disabled = $elm$html$Html$Attributes$boolProperty('disabled');
var $elm$html$Html$form = _VirtualDom_node('form');
var $elm$html$Html$input = _VirtualDom_node('input');
var $author$project$Styles$inputErrorBorder = ' border-red-600 dark:border-orange-600 ';
var $author$project$Styles$inputLabel = ' text-sm font-semibold py-0.5 ';
var $author$project$Comp$Basic$inputRequired = A2(
	$elm$html$Html$span,
	_List_fromArray(
		[
			$elm$html$Html$Attributes$class('ml-1 text-red-700')
		]),
	_List_fromArray(
		[
			$elm$html$Html$text('*')
		]));
var $author$project$Comp$AccountForm$isIntern = function (model) {
	return A2(
		$elm$core$Maybe$withDefault,
		false,
		A2(
			$elm$core$Maybe$map,
			$elm$core$Basics$eq('intern'),
			A2(
				$elm$core$Maybe$map,
				function ($) {
					return $.eu;
				},
				model.V)));
};
var $author$project$Comp$AccountForm$isModify = function (model) {
	return !$author$project$Comp$AccountForm$isCreate(model);
};
var $elm$html$Html$label = _VirtualDom_node('label');
var $author$project$Data$DropdownStyle$dropdownItemStyle = 'transition-colors duration-200 items-center block px-4 py-2 text-normal ';
var $author$project$Styles$formFocusRing = ' focus:ring focus:ring-black focus:ring-opacity-50 focus:ring-offset-0 dark:focus:ring-stone-400 ';
var $author$project$Data$DropdownStyle$dropdownLinkStyle = 'py-2 px-4 w-full inline-flex items-center border rounded ' + $author$project$Styles$formFocusRing;
var $author$project$Data$DropdownStyle$dropdownMenuStyle = 'absolute left-0 max-h-44 w-full overflow-y-auto z-50 border shadow-lg transition duration-200 ';
var $author$project$Data$DropdownStyle$mainInputStyle = 'dark:text-stone-200 dark:bg-stone-800 dark:border-stone-500';
var $author$project$Data$DropdownStyle$mainItem = ' hover:bg-gray-200 dark:hover:bg-stone-700 dark:hover:text-stone-100';
var $author$project$Data$DropdownStyle$mainLink = ' bg-white border-gray-500 hover:border-gray-500 dark:bg-stone-800 dark:border-stone-500 dark:hover:border-stone-500';
var $author$project$Data$DropdownStyle$mainMenu = 'bg-white dark:bg-stone-800 dark:border-stone-700 dark:text-stone-300';
var $author$project$Data$DropdownStyle$mainStyle = {
	fu: $author$project$Data$DropdownStyle$mainInputStyle,
	fv: _Utils_ap($author$project$Data$DropdownStyle$dropdownItemStyle, $author$project$Data$DropdownStyle$mainItem),
	fw: 'bg-gray-200 dark:bg-stone-700',
	fC: _Utils_ap($author$project$Data$DropdownStyle$dropdownLinkStyle, $author$project$Data$DropdownStyle$mainLink),
	fJ: _Utils_ap($author$project$Data$DropdownStyle$dropdownMenuStyle, $author$project$Data$DropdownStyle$mainMenu),
	id: ''
};
var $elm$html$Html$Events$alwaysStop = function (x) {
	return _Utils_Tuple2(x, true);
};
var $elm$virtual_dom$VirtualDom$MayStopPropagation = function (a) {
	return {$: 1, a: a};
};
var $elm$virtual_dom$VirtualDom$on = _VirtualDom_on;
var $elm$html$Html$Events$stopPropagationOn = F2(
	function (event, decoder) {
		return A2(
			$elm$virtual_dom$VirtualDom$on,
			event,
			$elm$virtual_dom$VirtualDom$MayStopPropagation(decoder));
	});
var $elm$json$Json$Decode$at = F2(
	function (fields, decoder) {
		return A3($elm$core$List$foldr, $elm$json$Json$Decode$field, decoder, fields);
	});
var $elm$html$Html$Events$targetValue = A2(
	$elm$json$Json$Decode$at,
	_List_fromArray(
		['target', 'value']),
	$elm$json$Json$Decode$string);
var $elm$html$Html$Events$onInput = function (tagger) {
	return A2(
		$elm$html$Html$Events$stopPropagationOn,
		'input',
		A2(
			$elm$json$Json$Decode$map,
			$elm$html$Html$Events$alwaysStop,
			A2($elm$json$Json$Decode$map, tagger, $elm$html$Html$Events$targetValue)));
};
var $author$project$Styles$textInput = ' placeholder-gray-400 w-full dark:text-stone-200 dark:bg-stone-800 dark:border-stone-500 border-gray-400 rounded ' + $author$project$Styles$formFocusRing;
var $elm$html$Html$Attributes$type_ = $elm$html$Html$Attributes$stringProperty('type');
var $elm$html$Html$Attributes$value = $elm$html$Html$Attributes$stringProperty('value');
var $author$project$Styles$dimmer = ' absolute top-0 left-0 w-full h-full bg-black bg-opacity-90 dark:bg-stone-900 dark:bg-opacity-90 z-50 flex flex-col items-center justify-center px-4 md:px-8 py-2 ';
var $elm$virtual_dom$VirtualDom$Normal = function (a) {
	return {$: 0, a: a};
};
var $elm$html$Html$Events$on = F2(
	function (event, decoder) {
		return A2(
			$elm$virtual_dom$VirtualDom$on,
			event,
			$elm$virtual_dom$VirtualDom$Normal(decoder));
	});
var $elm$html$Html$Events$onClick = function (msg) {
	return A2(
		$elm$html$Html$Events$on,
		'click',
		$elm$json$Json$Decode$succeed(msg));
};
var $author$project$Styles$primaryButtonHover = ' hover:bg-blue-600 dark:hover:bg-orange-700 ';
var $author$project$Styles$primaryButtonMain = ' my-auto whitespace-nowrap bg-blue-500 border border-blue-500 dark:border-orange-800 dark:bg-orange-800 text-white text-center px-4 py-2 shadow-md focus:outline-none focus:ring focus:ring-opacity-75 ';
var $author$project$Styles$primaryButtonPlain = _Utils_ap($author$project$Styles$primaryButtonMain, $author$project$Styles$primaryButtonHover);
var $author$project$Styles$primaryButtonRounded = ' rounded ';
var $author$project$Styles$primaryButton = _Utils_ap($author$project$Styles$primaryButtonRounded, $author$project$Styles$primaryButtonPlain);
var $author$project$Styles$secondaryButtonHover = ' hover:bg-gray-400 dark:hover:bg-stone-300 ';
var $author$project$Styles$secondaryButtonPlain = ' my-auto whitespace-nowrap bg-gray-300 text-gray-800 dark:bg-stone-400 text-center px-4 py-2 shadow-md focus:outline-none focus:ring focus:ring-opacity-75 dark:text-gray-800 ';
var $author$project$Styles$secondaryButtonMain = ' rounded ' + $author$project$Styles$secondaryButtonPlain;
var $author$project$Styles$secondaryButton = _Utils_ap($author$project$Styles$secondaryButtonMain, $author$project$Styles$secondaryButtonHover);
var $author$project$Comp$ConfirmModal$view = function (settings) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class($author$project$Styles$dimmer),
				$elm$html$Html$Attributes$class(settings.de),
				$elm$html$Html$Attributes$classList(
				_List_fromArray(
					[
						_Utils_Tuple2('hidden', !settings.da)
					]))
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class(settings.cx)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class(settings.dq),
								$elm$html$Html$Attributes$class('text-gray-200 font-semibold'),
								$elm$html$Html$Attributes$classList(
								_List_fromArray(
									[
										_Utils_Tuple2('hidden', settings.cx === '')
									]))
							]),
						_List_Nil),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('text-gray-200 font-semibold')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(settings.dU)
							]))
					])),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('flex flex-row space-x-2 text-xs mt-2')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$a,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class($author$project$Styles$primaryButton + 'block font-semibold'),
								$elm$html$Html$Attributes$href('#'),
								$elm$html$Html$Events$onClick(settings.c_)
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(settings.c$)
							])),
						A2(
						$elm$html$Html$a,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class($author$project$Styles$secondaryButton + 'block font-semibold'),
								$elm$html$Html$Attributes$href('#'),
								$elm$html$Html$Events$onClick(settings.cV)
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(settings.cW)
							]))
					]))
			]));
};
var $elm$html$Html$Attributes$title = $elm$html$Html$Attributes$stringProperty('title');
var $author$project$Comp$MenuBar$makeButton = F2(
	function (btnType, model) {
		var _v0 = function () {
			var _v1 = model.dt;
			if (!_v1.$) {
				var cls = _v1.a;
				return _Utils_Tuple2(
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class(cls)
								]),
							_List_Nil)
						]),
					(model.hx === '') ? '' : 'ml-2');
			} else {
				return _Utils_Tuple2(_List_Nil, '');
			}
		}();
		var icon = _v0.a;
		var iconMargin = _v0.b;
		var label = (model.hx === '') ? _List_Nil : _List_fromArray(
			[
				A2(
				$elm$html$Html$span,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class(iconMargin + ' hidden sm:inline')
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(model.hx)
					]))
			]);
		return A2(
			$elm$html$Html$a,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(btnType),
					(model.hx === '') ? $elm$html$Html$Attributes$class('inline-flex items-center h-full py-0') : $elm$html$Html$Attributes$class(''),
					$elm$html$Html$Attributes$href('#'),
					$elm$html$Html$Events$onClick(model.cI),
					$elm$html$Html$Attributes$title(model.eA)
				]),
			_Utils_ap(icon, label));
	});
var $author$project$Styles$checkboxInput = ' checkbox w-5 h-5 md:w-4 md:h-4 text-black  dark:text-stone-600 dark:bg-stone-600 dark:border-stone-700' + $author$project$Styles$formFocusRing;
var $elm$html$Html$Attributes$checked = $elm$html$Html$Attributes$boolProperty('checked');
var $elm$html$Html$Attributes$for = $elm$html$Html$Attributes$stringProperty('htmlFor');
var $elm$html$Html$Events$targetChecked = A2(
	$elm$json$Json$Decode$at,
	_List_fromArray(
		['target', 'checked']),
	$elm$json$Json$Decode$bool);
var $elm$html$Html$Events$onCheck = function (tagger) {
	return A2(
		$elm$html$Html$Events$on,
		'change',
		A2($elm$json$Json$Decode$map, tagger, $elm$html$Html$Events$targetChecked));
};
var $author$project$Comp$MenuBar$makeCheckbox = function (model) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('')
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$label,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('inline-flex space-x-2 items-center'),
						$elm$html$Html$Attributes$for(model.hs)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$input,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$type_('checkbox'),
								$elm$html$Html$Events$onCheck(model.cI),
								$elm$html$Html$Attributes$checked(model.eG),
								$elm$html$Html$Attributes$class($author$project$Styles$checkboxInput),
								$elm$html$Html$Attributes$id(model.hs)
							]),
						_List_Nil),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('truncate')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(model.hx)
							]))
					]))
			]));
};
var $author$project$Comp$MenuBar$makeDropdown = function (model) {
	var menuStyle = 'absolute right-0 bg-white dark:bg-stone-800 border dark:border-stone-700 z-50 dark:text-stone-300 shadow-lg transition duration-200 min-w-max  ';
	var itemStyle = 'transition-colors duration-200 items-center block px-4 py-2 text-normal hover:bg-gray-200 dark:hover:bg-stone-700 dark:hover:text-stone-50';
	var menuItem = function (m) {
		return A2(
			$elm$html$Html$a,
			A2(
				$elm$core$List$cons,
				$elm$html$Html$Attributes$class(itemStyle),
				m.F),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(m.dt),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', m.dt === '')
								]))
						]),
					_List_Nil),
					A2(
					$elm$html$Html$span,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('ml-2'),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', m.hx === '')
								]))
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(m.hx)
						]))
				]));
	};
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('relative')
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$a,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$classList(model.fD),
						$elm$html$Html$Attributes$class('block'),
						$elm$html$Html$Attributes$href('#'),
						$elm$html$Html$Events$onClick(model.gy)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class(model.fE)
							]),
						_List_Nil)
					])),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class(menuStyle),
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2('hidden', !model.k)
							]))
					]),
				A2($elm$core$List$map, menuItem, model.dG))
			]));
};
var $author$project$Styles$inputIcon = 'absolute left-3 top-3 w-10 text-gray-400 dark:text-stone-400  ';
var $elm$html$Html$Attributes$placeholder = $elm$html$Html$Attributes$stringProperty('placeholder');
var $author$project$Comp$MenuBar$makeInput = function (model) {
	var _v0 = function () {
		var _v1 = model.dt;
		if (!_v1.$) {
			var cls = _v1.a;
			return _Utils_Tuple2(
				_List_fromArray(
					[
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$i,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class(cls)
									]),
								_List_Nil)
							]))
					]),
				'pl-10');
		} else {
			return _Utils_Tuple2(_List_Nil, '');
		}
	}();
	var icon = _v0.a;
	var iconPad = _v0.b;
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('relative pr-2')
			]),
		A2(
			$elm$core$List$cons,
			A2(
				$elm$html$Html$input,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$type_('text'),
						$elm$html$Html$Events$onInput(model.cI),
						$elm$html$Html$Attributes$value(model.eG),
						$elm$html$Html$Attributes$placeholder(model.h5),
						$elm$html$Html$Attributes$class(iconPad + (' pr-4 py-1 rounded' + $author$project$Styles$textInput))
					]),
				_List_Nil),
			icon));
};
var $author$project$Comp$MenuBar$makeLabel = function (model) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('flex items-center justify-center '),
				$elm$html$Html$Attributes$class(model.eV)
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$i,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class(model.dt),
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2('hidden', model.dt === '')
							]))
					]),
				_List_Nil),
				$elm$html$Html$text(model.hx)
			]));
};
var $author$project$Styles$secondaryBasicButtonHover = ' hover:bg-gray-600 hover:text-white dark:hover:text-white dark:hover:bg-stone-500 dark:hover:text-stone-100 ';
var $author$project$Styles$secondaryBasicButtonMain = ' my-auto whitespace-nowrap border-gray-500 dark:border-stone-500 text-gray-500 dark:text-stone-400 text-center shadow-none focus:outline-none focus:ring focus:ring-opacity-75 ';
var $author$project$Styles$secondaryBasicButtonPlain = _Utils_ap($author$project$Styles$secondaryBasicButtonMain, $author$project$Styles$secondaryBasicButtonHover);
var $author$project$Styles$secondaryBasicButtonRounded = ' rounded border px-4 py-2 ';
var $author$project$Styles$secondaryBasicButton = _Utils_ap($author$project$Styles$secondaryBasicButtonRounded, $author$project$Styles$secondaryBasicButtonPlain);
var $elm$core$String$replace = F3(
	function (before, after, string) {
		return A2(
			$elm$core$String$join,
			after,
			A2($elm$core$String$split, before, string));
	});
var $author$project$Styles$secondaryBasicButtonActive = ' bg-gray-600 text-white dark:text-white dark:bg-stone-500 dark:text-stone-100 ';
var $author$project$Styles$secondaryBasicButtonToggle = function (active) {
	var base = _Utils_ap(
		$author$project$Styles$secondaryBasicButtonRounded,
		A3($elm$core$String$replace, 'text-gray-500 dark:text-stone-400', '', $author$project$Styles$secondaryBasicButtonMain));
	return active ? _Utils_ap(base, $author$project$Styles$secondaryBasicButtonActive) : (base + ('text-gray-500 dark:text-stone-400' + $author$project$Styles$secondaryBasicButtonHover));
};
var $author$project$Comp$MenuBar$viewItem = function (item) {
	switch (item.$) {
		case 0:
			var model = item.a;
			return $author$project$Comp$MenuBar$makeInput(model);
		case 1:
			var model = item.a;
			return $author$project$Comp$MenuBar$makeCheckbox(model);
		case 2:
			var model = item.a;
			return A2(
				$author$project$Comp$MenuBar$makeButton,
				_List_fromArray(
					[
						_Utils_Tuple2($author$project$Styles$primaryButton, true)
					]),
				model);
		case 3:
			var model = item.a;
			return A2(
				$author$project$Comp$MenuBar$makeButton,
				_List_fromArray(
					[
						_Utils_Tuple2($author$project$Styles$secondaryButton, true)
					]),
				model);
		case 5:
			var model = item.a;
			return A2(
				$author$project$Comp$MenuBar$makeButton,
				_List_fromArray(
					[
						_Utils_Tuple2($author$project$Styles$deleteButton, true)
					]),
				model);
		case 6:
			var model = item.a;
			return A2(
				$author$project$Comp$MenuBar$makeButton,
				_List_fromArray(
					[
						_Utils_Tuple2($author$project$Styles$secondaryBasicButton, true)
					]),
				model);
		case 4:
			var model = item.a;
			return A2(
				$author$project$Comp$MenuBar$makeButton,
				_List_fromArray(
					[
						_Utils_Tuple2(
						$author$project$Styles$secondaryBasicButtonToggle(model.gO),
						true)
					]),
				model);
		case 7:
			var model = item.a;
			return A2($author$project$Comp$MenuBar$makeButton, model.hw, model);
		case 8:
			var model = item.a;
			return $author$project$Comp$MenuBar$makeLabel(model);
		case 9:
			var v = item.a;
			return v;
		default:
			var model = item.a;
			return $author$project$Comp$MenuBar$makeDropdown(model);
	}
};
var $author$project$Comp$MenuBar$view1 = F2(
	function (classes, mb) {
		var right = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex-grow flex-row flex justify-end space-x-2 h-10 w-full')
				]),
			A2($elm$core$List$map, $author$project$Comp$MenuBar$viewItem, mb.hg));
		var left = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-row items-center space-x-2 w-full')
				]),
			A2($elm$core$List$map, $author$project$Comp$MenuBar$viewItem, mb.it));
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class(mb.$8),
					$elm$html$Html$Attributes$class('flex flex-row space-y-1 sm:space-y-0 '),
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2('sticky top-0 z-40', mb.iw)
						])),
					$elm$html$Html$Attributes$class(classes)
				]),
			_List_fromArray(
				[left, right]));
	});
var $author$project$Comp$MenuBar$view = $author$project$Comp$MenuBar$view1('bg-white dark:bg-stone-800');
var $author$project$Comp$PasswordInput$SetPassword = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$PasswordInput$ToggleShow = function (a) {
	return {$: 0, a: a};
};
var $elm$html$Html$Attributes$autocomplete = function (bool) {
	return A2(
		$elm$html$Html$Attributes$stringProperty,
		'autocomplete',
		bool ? 'on' : 'off');
};
var $author$project$Styles$inputLeftIconLink = 'inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 rounded-r cursor-pointer ' + ('text-gray-400 dark:text-stone-400 ' + ('bg-gray-300 dark:bg-stone-700 ' + ('dark:border-stone-500 border-0 border-r border-t border-b border-gray-500 ' + 'hover:bg-gray-400 hover:text-gray-700 dark:hover:bg-stone-600')));
var $elm$html$Html$Attributes$name = $elm$html$Html$Attributes$stringProperty('name');
var $author$project$Comp$PasswordInput$view = F4(
	function (cfg, pw, isError, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('relative')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa'),
									model.ir ? $elm$html$Html$Attributes$class('fa-lock-open') : $elm$html$Html$Attributes$class('fa-lock')
								]),
							_List_Nil)
						])),
					A2(
					$elm$html$Html$input,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$type_(
							model.ir ? 'text' : 'password'),
							$elm$html$Html$Attributes$name('passw1'),
							$elm$html$Html$Attributes$autocomplete(false),
							$elm$html$Html$Events$onInput($author$project$Comp$PasswordInput$SetPassword),
							$elm$html$Html$Attributes$value(
							A2($elm$core$Maybe$withDefault, '', pw)),
							$elm$html$Html$Attributes$class('pl-10 pr-10 py-2 rounded' + $author$project$Styles$textInput),
							$elm$html$Html$Attributes$class(
							isError ? $author$project$Styles$inputErrorBorder : ''),
							$elm$html$Html$Attributes$placeholder(cfg.h5)
						]),
					_List_Nil),
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$inputLeftIconLink),
							$elm$html$Html$Attributes$class(
							isError ? $author$project$Styles$inputErrorBorder : ''),
							$elm$html$Html$Events$onClick(
							$author$project$Comp$PasswordInput$ToggleShow(pw)),
							$elm$html$Html$Attributes$href('#')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-eye')
								]),
							_List_Nil)
						]))
				]));
	});
var $author$project$Comp$FixedDropdown$KeyPress = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$FixedDropdown$SelectItem2 = function (a) {
	return {$: 0, a: a};
};
var $author$project$Util$Html$Code = function (a) {
	return {$: 20, a: a};
};
var $author$project$Util$Html$Comma = {$: 16};
var $author$project$Util$Html$Ctrl = {$: 18};
var $author$project$Util$Html$Down = {$: 1};
var $author$project$Util$Html$ESC = {$: 6};
var $author$project$Util$Html$Enter = {$: 4};
var $author$project$Util$Html$Left = {$: 2};
var $author$project$Util$Html$Letter_C = {$: 7};
var $author$project$Util$Html$Letter_H = {$: 10};
var $author$project$Util$Html$Letter_J = {$: 11};
var $author$project$Util$Html$Letter_K = {$: 12};
var $author$project$Util$Html$Letter_L = {$: 13};
var $author$project$Util$Html$Letter_N = {$: 8};
var $author$project$Util$Html$Letter_P = {$: 9};
var $author$project$Util$Html$Letter_U = {$: 14};
var $author$project$Util$Html$Point = {$: 15};
var $author$project$Util$Html$Right = {$: 3};
var $author$project$Util$Html$Shift = {$: 17};
var $author$project$Util$Html$Space = {$: 5};
var $author$project$Util$Html$Super = {$: 19};
var $author$project$Util$Html$Up = {$: 0};
var $author$project$Util$Html$intToKeyCode = function (code) {
	switch (code) {
		case 16:
			return $elm$core$Maybe$Just($author$project$Util$Html$Shift);
		case 17:
			return $elm$core$Maybe$Just($author$project$Util$Html$Ctrl);
		case 91:
			return $elm$core$Maybe$Just($author$project$Util$Html$Super);
		case 38:
			return $elm$core$Maybe$Just($author$project$Util$Html$Up);
		case 40:
			return $elm$core$Maybe$Just($author$project$Util$Html$Down);
		case 39:
			return $elm$core$Maybe$Just($author$project$Util$Html$Right);
		case 37:
			return $elm$core$Maybe$Just($author$project$Util$Html$Left);
		case 13:
			return $elm$core$Maybe$Just($author$project$Util$Html$Enter);
		case 32:
			return $elm$core$Maybe$Just($author$project$Util$Html$Space);
		case 27:
			return $elm$core$Maybe$Just($author$project$Util$Html$ESC);
		case 67:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_C);
		case 72:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_H);
		case 74:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_J);
		case 75:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_K);
		case 76:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_L);
		case 78:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_N);
		case 80:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_P);
		case 85:
			return $elm$core$Maybe$Just($author$project$Util$Html$Letter_U);
		case 188:
			return $elm$core$Maybe$Just($author$project$Util$Html$Comma);
		case 190:
			return $elm$core$Maybe$Just($author$project$Util$Html$Point);
		default:
			var n = code;
			return $elm$core$Maybe$Just(
				$author$project$Util$Html$Code(n));
	}
};
var $elm$html$Html$Events$keyCode = A2($elm$json$Json$Decode$field, 'keyCode', $elm$json$Json$Decode$int);
var $author$project$Util$Html$onKeyUp = function (tagger) {
	return A2(
		$elm$html$Html$Events$on,
		'keyup',
		A2($elm$json$Json$Decode$map, tagger, $elm$html$Html$Events$keyCode));
};
var $author$project$Util$Html$onKeyUpCode = function (tagger) {
	return $author$project$Util$Html$onKeyUp(
		A2($elm$core$Basics$composeR, $author$project$Util$Html$intToKeyCode, tagger));
};
var $elm$html$Html$Attributes$tabindex = function (n) {
	return A2(
		_VirtualDom_attribute,
		'tabIndex',
		$elm$core$String$fromInt(n));
};
var $author$project$Comp$FixedDropdown$viewStyled = F4(
	function (cfg, error, sel, model) {
		var iconItem = function (id) {
			return A2(
				$elm$html$Html$span,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2(
								'hidden',
								_Utils_eq(
									cfg.dt(id),
									$elm$core$Maybe$Nothing))
							])),
						$elm$html$Html$Attributes$class(
						A2(
							$elm$core$Maybe$withDefault,
							'',
							cfg.dt(id))),
						$elm$html$Html$Attributes$class('mr-2')
					]),
				_List_Nil);
		};
		var renderItem = function (item) {
			return A2(
				$elm$html$Html$a,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$href('#'),
						$elm$html$Html$Attributes$class(cfg.ix.fv),
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2(
								cfg.ix.fw,
								A2($author$project$Comp$FixedDropdown$isSelected, model, item)),
								_Utils_Tuple2(
								'font-semibold',
								_Utils_eq(
									$elm$core$Maybe$Just(item.hs),
									sel))
							])),
						$elm$html$Html$Events$onClick(
						$author$project$Comp$FixedDropdown$SelectItem2(item))
					]),
				_List_fromArray(
					[
						iconItem(item.hs),
						$elm$html$Html$text(
						cfg.g9(item.hs))
					]));
		};
		var selIcon = A2(
			$elm$core$Maybe$withDefault,
			A2(
				$elm$html$Html$span,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('hidden')
					]),
				_List_Nil),
			A2($elm$core$Maybe$map, iconItem, sel));
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('relative ' + cfg.ix.id),
					$author$project$Util$Html$onKeyUpCode($author$project$Comp$FixedDropdown$KeyPress)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(cfg.ix.fC),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2($author$project$Styles$inputErrorBorder, error)
								])),
							$elm$html$Html$Attributes$tabindex(0),
							$elm$html$Html$Events$onClick($author$project$Comp$FixedDropdown$ToggleMenu),
							$elm$html$Html$Attributes$href('#')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex-grow'),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'opacity-50',
											_Utils_eq(sel, $elm$core$Maybe$Nothing))
										]))
								]),
							_List_fromArray(
								[
									selIcon,
									$elm$html$Html$text(
									A2(
										$elm$core$Maybe$withDefault,
										cfg.ik,
										A2($elm$core$Maybe$map, cfg.g9, sel)))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('rounded cursor-pointer ml-2 absolute right-2')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-angle-down px-2')
										]),
									_List_Nil)
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(cfg.ix.fJ),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', !model.k)
								]))
						]),
					A2($elm$core$List$map, renderItem, model.h1))
				]));
	});
var $author$project$Comp$AccountForm$view = F2(
	function (texts, model) {
		var modalSettings = A5($author$project$Comp$ConfirmModal$defaultSettings, $author$project$Comp$AccountForm$DeleteConfirm, $author$project$Comp$AccountForm$DeleteCancel, texts.eK.g2, texts.eK.gZ, texts.eK.dU);
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-col relative')
				]),
			_List_fromArray(
				[
					$author$project$Comp$ConfirmModal$view(
					_Utils_update(
						modalSettings,
						{da: model.aR})),
					A2(
					$elm$html$Html$form,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dK),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$input,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$type_('text'),
											$elm$html$Html$Attributes$disabled(
											$author$project$Comp$AccountForm$isModify(model)),
											$elm$html$Html$Attributes$value(model.W),
											$author$project$Comp$AccountForm$isModify(model) ? $elm$html$Html$Attributes$class('disabled') : $elm$html$Html$Events$onInput($author$project$Comp$AccountForm$SetLogin),
											$elm$html$Html$Attributes$class($author$project$Styles$textInput),
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2(
													$author$project$Styles$inputErrorBorder,
													$elm$core$String$isEmpty(model.W))
												]))
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.ev),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Comp$AccountForm$StateMsg,
									A4(
										$author$project$Comp$FixedDropdown$viewStyled,
										{
											g9: $author$project$Data$AccountState$toString,
											dt: function (_v0) {
												return $elm$core$Maybe$Nothing;
											},
											ik: texts.hc.ii,
											ix: $author$project$Data$DropdownStyle$mainStyle
										},
										false,
										$elm$core$Maybe$Just(model.ab),
										model.cj))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									$author$project$Comp$MenuBar$viewItem(
									$author$project$Comp$MenuBar$Checkbox(
										{
											hs: 'is-admin',
											hx: texts.cK,
											cI: function (_v1) {
												return $author$project$Comp$AccountForm$ToggleAdmin;
											},
											eG: model.R
										}))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.c9)
										])),
									A2(
									$elm$html$Html$input,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$type_('text'),
											$elm$html$Html$Attributes$value(
											A2($elm$core$Maybe$withDefault, '', model.ag)),
											$elm$html$Html$Events$onInput($author$project$Comp$AccountForm$SetEmail),
											$elm$html$Html$Attributes$class($author$project$Styles$textInput)
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4'),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'hidden',
											!($author$project$Comp$AccountForm$isCreate(model) || $author$project$Comp$AccountForm$isIntern(model)))
										]))
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.d4),
											$author$project$Comp$AccountForm$isCreate(model) ? $author$project$Comp$Basic$inputRequired : A2(
											$elm$html$Html$span,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('hidden')
												]),
											_List_Nil)
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Comp$AccountForm$PasswordMsg,
									A4(
										$author$project$Comp$PasswordInput$view,
										{h5: ''},
										model.Z,
										$author$project$Comp$AccountForm$isCreate(model) && _Utils_eq(model.Z, $elm$core$Maybe$Nothing),
										model.ci))
								]))
						])),
					$author$project$Comp$MenuBar$view(
					{
						hg: _List_fromArray(
							[
								$author$project$Comp$MenuBar$CustomButton(
								{
									dt: $elm$core$Maybe$Just('fa fa-trash'),
									hw: _List_fromArray(
										[
											_Utils_Tuple2(
											'hidden',
											_Utils_eq(
												A2(
													$elm$core$Maybe$map,
													function ($) {
														return $.hs;
													},
													model.V),
												$elm$core$Maybe$Nothing)),
											_Utils_Tuple2($author$project$Styles$deleteButton, true)
										]),
									hx: texts.e0,
									cI: $author$project$Comp$AccountForm$RequestDelete,
									eA: texts.e0
								})
							]),
						$8: '',
						it: _List_fromArray(
							[
								$author$project$Comp$MenuBar$PrimaryButton(
								{
									dt: $elm$core$Maybe$Just('fa fa-save'),
									hx: texts.gt,
									cI: $author$project$Comp$AccountForm$Submit,
									eA: texts.gt
								}),
								$author$project$Comp$MenuBar$SecondaryButton(
								{
									dt: $elm$core$Maybe$Just('fa fa-arrow-left'),
									hx: texts.eP,
									cI: $author$project$Comp$AccountForm$Cancel,
									eA: texts.eP
								})
							]),
						iw: false
					})
				]));
	});
var $author$project$Page$Account$View$viewCreate = F2(
	function (texts, model) {
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$h1,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$header1)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('fa fa-users mr-2')
							]),
						_List_Nil),
						$elm$html$Html$text(texts.aL)
					])),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('mb-2')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$map,
						$author$project$Page$Account$Data$AccountFormMsg,
						A2($author$project$Comp$AccountForm$view, texts.au, model.fh))
					])),
				A2(
				$elm$core$Maybe$withDefault,
				$author$project$Util$Html$noElement,
				A2($elm$core$Maybe$map, $author$project$Util$Html$resultMsg, model.gg))
			]);
	});
var $author$project$Page$Account$Data$AccountTableMsg = function (a) {
	return {$: 4, a: a};
};
var $author$project$Page$Account$Data$InitNewAccount = {$: 8};
var $author$project$Page$Account$Data$SetQuery = function (a) {
	return {$: 3, a: a};
};
var $author$project$Comp$MenuBar$TextInput = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Account$View$searchArea = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$PrimaryButton(
						{
							dt: $elm$core$Maybe$Just('fa fa-plus'),
							hx: texts.be,
							cI: $author$project$Page$Account$Data$InitNewAccount,
							eA: texts.be
						})
					]),
				$8: 'mb-4',
				it: _List_fromArray(
					[
						$author$project$Comp$MenuBar$TextInput(
						{
							dt: $elm$core$Maybe$Just('fa fa-search'),
							h5: texts.ih,
							cI: $author$project$Page$Account$Data$SetQuery,
							eG: model.h7
						})
					]),
				iw: true
			});
	});
var $elm$html$Html$table = _VirtualDom_node('table');
var $author$project$Styles$tableMain = 'border-collapse table w-full dark:text-stone-300';
var $elm$html$Html$tbody = _VirtualDom_node('tbody');
var $elm$html$Html$th = _VirtualDom_node('th');
var $elm$html$Html$thead = _VirtualDom_node('thead');
var $elm$html$Html$tr = _VirtualDom_node('tr');
var $author$project$Comp$AccountTable$Select = $elm$core$Basics$identity;
var $author$project$Util$Html$checkboxChecked = A2(
	$elm$html$Html$i,
	_List_fromArray(
		[
			$elm$html$Html$Attributes$class('fa fa-check-square font-thin')
		]),
	_List_Nil);
var $author$project$Util$Html$checkboxUnchecked = A2(
	$elm$html$Html$i,
	_List_fromArray(
		[
			$elm$html$Html$Attributes$class('fa fa-minus-square font-thin')
		]),
	_List_Nil);
var $author$project$Util$Html$checkbox = function (flag) {
	return flag ? $author$project$Util$Html$checkboxChecked : $author$project$Util$Html$checkboxUnchecked;
};
var $author$project$Comp$Basic$genericLink = F4(
	function (responsive, icon, label, attrs) {
		return A2(
			$elm$html$Html$a,
			attrs,
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(icon),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', icon === ''),
									_Utils_Tuple2('py-1 ', true)
								]))
						]),
					_List_Nil),
					A2(
					$elm$html$Html$span,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('ml-2'),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', label === ''),
									_Utils_Tuple2('hidden sm:inline', responsive && (label !== ''))
								]))
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(label)
						]))
				]));
	});
var $author$project$Comp$Basic$linkLabel = function (model) {
	var styles = _List_fromArray(
		[
			$elm$html$Html$Attributes$class('label'),
			$elm$html$Html$Attributes$class('inline-block md:text-sm my-auto whitespace-nowrap'),
			$elm$html$Html$Attributes$class(model.ix.d5)
		]);
	var hover = _List_fromArray(
		[
			$elm$html$Html$Attributes$class(model.ix.ds)
		]);
	var attrs = model.t ? _Utils_ap(
		_List_fromArray(
			[
				$elm$html$Html$Attributes$href('#'),
				$elm$html$Html$Attributes$class('disabled')
			]),
		styles) : _Utils_ap(
		_List_fromArray(
			[
				$elm$html$Html$Events$onClick(model.x),
				$elm$html$Html$Attributes$href('#')
			]),
		_Utils_ap(styles, hover));
	return A4($author$project$Comp$Basic$genericLink, false, model.dt, model.hx, attrs);
};
var $author$project$Comp$Basic$editLinkLabel = F2(
	function (label, click) {
		return $author$project$Comp$Basic$linkLabel(
			{
				t: false,
				x: click,
				dt: 'fa fa-edit',
				hx: label,
				ix: {ds: 'hover:bg-blue-500 hover:text-gray-100 ' + 'dark:hover:bg-orange-500 dark:hover:text-stone-900', d5: 'border-blue-500 text-blue-500 ' + 'dark:border-orange-500 dark:text-orange-500'}
			});
	});
var $author$project$Styles$editLinkTableCellStyle = 'w-px whitespace-nowrap pr-2 md:pr-4 py-4 md:py-2';
var $elm$html$Html$td = _VirtualDom_node('td');
var $author$project$Comp$Basic$editLinkTableCell = F2(
	function (label, m) {
		return A2(
			$elm$html$Html$td,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$editLinkTableCellStyle)
				]),
			_List_fromArray(
				[
					A2($author$project$Comp$Basic$editLinkLabel, label, m)
				]));
	});
var $author$project$Comp$AccountTable$isSelected = F2(
	function (model, acc) {
		return A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$eq(acc.hs),
				A2(
					$elm$core$Maybe$map,
					function ($) {
						return $.hs;
					},
					model.cG)));
	});
var $author$project$Styles$tableRow = 'border-t dark:border-stone-600';
var $author$project$Comp$AccountTable$viewTableLine = F3(
	function (texts, model, acc) {
		return A2(
			$elm$html$Html$tr,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							'active',
							A2($author$project$Comp$AccountTable$isSelected, model, acc))
						])),
					$elm$html$Html$Attributes$class($author$project$Styles$tableRow)
				]),
			_List_fromArray(
				[
					A2($author$project$Comp$Basic$editLinkTableCell, texts.he, acc),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(acc.dK)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(acc.eu)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(acc.ev)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center hidden sm:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							$elm$core$String$fromInt(acc.el))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center')
						]),
					_List_fromArray(
						[
							$author$project$Util$Html$checkbox(acc.cK)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center hidden sm:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							$elm$core$String$fromInt(acc.dL))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							A2(
								$elm$core$Maybe$withDefault,
								'',
								A2($elm$core$Maybe$map, texts.eZ, acc.dJ)))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							texts.eZ(acc.c0))
						]))
				]));
	});
var $author$project$Comp$AccountTable$view = F3(
	function (texts, accounts, model) {
		return A2(
			$elm$html$Html$table,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$tableMain)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$thead,
					_List_Nil,
					_List_fromArray(
						[
							A2(
							$elm$html$Html$tr,
							_List_Nil,
							_List_fromArray(
								[
									A2($elm$html$Html$th, _List_Nil, _List_Nil),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dK)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.eu)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.ev)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center hidden sm:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.hY)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.cK)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center hidden sm:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.hX)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dJ)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.c0)
										]))
								]))
						])),
					A2(
					$elm$html$Html$tbody,
					_List_Nil,
					A2(
						$elm$core$List$map,
						A2($author$project$Comp$AccountTable$viewTableLine, texts, model),
						accounts))
				]));
	});
var $author$project$Page$Account$View$viewList = F2(
	function (texts, model) {
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$h1,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$header1)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('fa fa-users mr-2')
							]),
						_List_Nil),
						$elm$html$Html$text(texts.gN)
					])),
				A2($author$project$Page$Account$View$searchArea, texts, model),
				A2(
				$elm$html$Html$map,
				$author$project$Page$Account$Data$AccountTableMsg,
				A3($author$project$Comp$AccountTable$view, texts.av, model.gi, model.gw))
			]);
	});
var $author$project$Page$Account$View$viewModify = F3(
	function (texts, model, acc) {
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$h1,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$header1)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('fa fa-users mr-2')
							]),
						_List_Nil),
						$elm$html$Html$text(acc.dK),
						$elm$html$Html$text(' ('),
						$elm$html$Html$text(acc.eu),
						$elm$html$Html$text(')'),
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('text-sm opacity-70 font-mono')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(acc.hs)
							]))
					])),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('mb-2')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$map,
						$author$project$Page$Account$Data$AccountFormMsg,
						A2($author$project$Comp$AccountForm$view, texts.au, model.fh))
					])),
				A2(
				$elm$core$Maybe$withDefault,
				$author$project$Util$Html$noElement,
				A2($elm$core$Maybe$map, $author$project$Util$Html$resultMsg, model.gg))
			]);
	});
var $author$project$Page$Account$View$view = F3(
	function (id, texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content),
					$elm$html$Html$Attributes$class('flex flex-col')
				]),
			function () {
				var _v0 = model.cG;
				if (!_v0.$) {
					var acc = _v0.a;
					return A3($author$project$Page$Account$View$viewModify, texts, model, acc);
				} else {
					return _Utils_eq(
						id,
						$elm$core$Maybe$Just('new')) ? A2($author$project$Page$Account$View$viewCreate, texts, model) : A2($author$project$Page$Account$View$viewList, texts, model);
				}
			}());
	});
var $author$project$App$View$viewAccount = F3(
	function (id, texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$AccountMsg,
			A3($author$project$Page$Account$View$view, id, texts.f, model.eL));
	});
var $author$project$Page$Alias$Data$AliasFormMsg = function (a) {
	return {$: 5, a: a};
};
var $author$project$Comp$AliasForm$Cancel = {$: 4};
var $author$project$Comp$AliasForm$DeleteCancel = {$: 8};
var $author$project$Comp$AliasForm$DeleteConfirm = {$: 7};
var $author$project$Comp$AliasForm$MemberDropdownMsg = function (a) {
	return {$: 9, a: a};
};
var $author$project$Comp$AliasForm$RequestDelete = {$: 6};
var $author$project$Comp$AliasForm$SetId = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$AliasForm$SetName = function (a) {
	return {$: 0, a: a};
};
var $author$project$Comp$AliasForm$Submit = {$: 5};
var $author$project$Comp$AliasForm$ToggleEnabled = {$: 3};
var $author$project$Comp$AliasForm$ValidityMsg = function (a) {
	return {$: 2, a: a};
};
var $author$project$Styles$basicLabel = ' label border-gray-600 text-gray-600 dark:border-stone-300 dark:text-stone-300 ';
var $elm$html$Html$button = _VirtualDom_node('button');
var $author$project$Styles$header3 = ' text-xl mb-3 font-medium tracking-wide ';
var $author$project$Comp$ValidityField$ValidityMsg = $elm$core$Basics$identity;
var $elm$core$Basics$abs = function (n) {
	return (n < 0) ? (-n) : n;
};
var $author$project$Data$ValidityOptions$findMinimum = function (list) {
	if (!list.b) {
		return $elm$core$Maybe$Nothing;
	} else {
		var x = list.a;
		var xs = list.b;
		var getmin = F2(
			function (a, b) {
				return (_Utils_cmp(a.a, b.a) < 0) ? a : b;
			});
		return $elm$core$Maybe$Just(
			A3($elm$core$List$foldl, getmin, x, xs));
	}
};
var $elm$core$List$repeatHelp = F3(
	function (result, n, value) {
		repeatHelp:
		while (true) {
			if (n <= 0) {
				return result;
			} else {
				var $temp$result = A2($elm$core$List$cons, value, result),
					$temp$n = n - 1,
					$temp$value = value;
				result = $temp$result;
				n = $temp$n;
				value = $temp$value;
				continue repeatHelp;
			}
		}
	});
var $elm$core$List$repeat = F2(
	function (n, value) {
		return A3($elm$core$List$repeatHelp, _List_Nil, n, value);
	});
var $author$project$Data$ValidityValue$sub = F2(
	function (v1, v2) {
		return $author$project$Data$ValidityValue$toMillis(v1) - $author$project$Data$ValidityValue$toMillis(v2);
	});
var $author$project$Data$ValidityOptions$findValidityItem = F3(
	function (texts, flags, vv) {
		var ld = A2(
			$elm$core$List$repeat,
			$elm$core$List$length(
				$author$project$Data$ValidityOptions$allValidityOptions(texts)),
			vv);
		var diff = F2(
			function (t, a) {
				return _Utils_Tuple2(
					$elm$core$Basics$abs(
						A2($author$project$Data$ValidityValue$sub, t.b, a)),
					t);
			});
		var defaultValue = $author$project$Data$ValidityOptions$defaultValidity(flags);
		return A2(
			$elm$core$Maybe$withDefault,
			defaultValue,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Tuple$second,
				$author$project$Data$ValidityOptions$findMinimum(
					A3(
						$elm$core$List$map2,
						diff,
						$author$project$Data$ValidityOptions$allValidityOptions(texts),
						ld))));
	});
var $author$project$Comp$ValidityField$view = F4(
	function (texts, flags, validity, model) {
		var value = A3($author$project$Data$ValidityOptions$findValidityItem, texts, flags, validity).b;
		var dropdownCfg = {
			g9: function (vv) {
				return A3($author$project$Data$ValidityOptions$findValidityItem, texts, flags, vv).a;
			},
			dt: function (_v0) {
				return $elm$core$Maybe$Nothing;
			},
			ik: texts.hc.ii,
			ix: $author$project$Data$DropdownStyle$mainStyle
		};
		return A2(
			$elm$html$Html$map,
			$elm$core$Basics$identity,
			A4(
				$author$project$Comp$FixedDropdown$viewStyled,
				dropdownCfg,
				false,
				$elm$core$Maybe$Just(value),
				model));
	});
var $author$project$Comp$Dropdown$AddItem = function (a) {
	return {$: 3, a: a};
};
var $author$project$Comp$Dropdown$Filter = F2(
	function (a, b) {
		return {$: 5, a: a, b: b};
	});
var $author$project$Comp$Dropdown$KeyPress = function (a) {
	return {$: 7, a: a};
};
var $author$project$Comp$Dropdown$viewMultiple2 = F2(
	function (cfg, model) {
		var renderSelectMultiple = function (item) {
			return A2(
				$elm$html$Html$a,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class(
						cfg.hy(item.eG)),
						$elm$html$Html$Attributes$class('label font-medium inline-flex relative items-center hover:shadow-md mt-1 mr-1'),
						$elm$html$Html$Events$onClick(
						$author$project$Comp$Dropdown$RemoveItem2(item)),
						$elm$html$Html$Attributes$href('#')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('pl-4')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(
								A2(
									$elm$core$Basics$composeR,
									function ($) {
										return $.eG;
									},
									A2(
										$elm$core$Basics$composeR,
										cfg.hH,
										function ($) {
											return $.iD;
										}))(item))
							])),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('opacity-75 absolute left-2 my-auto')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$i,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('fa fa-times')
									]),
								_List_Nil)
							]))
					]));
		};
		var renderItem = function (item) {
			return A2(
				$elm$html$Html$a,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$href('#'),
						$elm$html$Html$Attributes$class(cfg.ix.fv),
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2(cfg.ix.fw, item.gO),
								_Utils_Tuple2('font-semibold', item.cG)
							])),
						$elm$html$Html$Events$onClick(
						$author$project$Comp$Dropdown$AddItem(item)),
						$author$project$Util$Html$onKeyUpCode($author$project$Comp$Dropdown$KeyPress)
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(
						A2(
							$elm$core$Basics$composeR,
							function ($) {
								return $.eG;
							},
							A2(
								$elm$core$Basics$composeR,
								cfg.hH,
								function ($) {
									return $.iD;
								}))(item)),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('text-gray-400 float-right')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(
								A2(
									$elm$core$Basics$composeR,
									function ($) {
										return $.eG;
									},
									A2(
										$elm$core$Basics$composeR,
										cfg.hH,
										function ($) {
											return $.gQ;
										}))(item))
							]))
					]));
		};
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('relative'),
					$author$project$Util$Html$onKeyUpCode($author$project$Comp$Dropdown$KeyPress)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(cfg.ix.fC),
							$elm$html$Html$Attributes$class('flex inline-flex flex-wrap items-center')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-row flex-wrap items-center mr-2 -mt-1'),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'hidden',
											$elm$core$List$isEmpty(model.cG))
										]))
								]),
							A2($elm$core$List$map, renderSelectMultiple, model.cG)),
							A2(
							$elm$html$Html$input,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$type_('text'),
									$elm$html$Html$Attributes$placeholder(cfg.h5),
									$elm$html$Html$Events$onInput(
									$author$project$Comp$Dropdown$Filter(
										A2(
											$elm$core$Basics$composeR,
											cfg.hH,
											function ($) {
												return $.iD;
											}))),
									$elm$html$Html$Attributes$value(model.a_),
									$elm$html$Html$Attributes$class('inline-flex w-16 border-0 px-0 focus:ring-0 h-6'),
									$elm$html$Html$Attributes$class(cfg.ix.fu)
								]),
							_List_Nil),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('block h-6 flex-grow'),
									$author$project$Util$Html$onKeyUpCode($author$project$Comp$Dropdown$KeyPress),
									$elm$html$Html$Events$onClick($author$project$Comp$Dropdown$ToggleMenu),
									$elm$html$Html$Attributes$href('#')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-angle-down px-2'),
											$elm$html$Html$Attributes$class('absolute right-2 rounded cursor-pointer ml-2 top-1/3')
										]),
									_List_Nil)
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(cfg.ix.fJ),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', !model.k)
								]))
						]),
					A2(
						$elm$core$List$map,
						renderItem,
						$author$project$Comp$Dropdown$getOptions(model)))
				]));
	});
var $author$project$Comp$Dropdown$viewSingle2 = F2(
	function (cfg, model) {
		var sel = $elm$core$List$head(model.cG);
		var renderItem = function (item) {
			return A2(
				$elm$html$Html$a,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$href('#'),
						$elm$html$Html$Attributes$class(cfg.ix.fv),
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2(cfg.ix.fw, item.gO),
								_Utils_Tuple2('font-semibold', item.cG)
							])),
						$elm$html$Html$Events$onClick(
						$author$project$Comp$Dropdown$AddItem(item)),
						$author$project$Util$Html$onKeyUpCode($author$project$Comp$Dropdown$KeyPress)
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(
						A2(
							$elm$core$Basics$composeR,
							function ($) {
								return $.eG;
							},
							A2(
								$elm$core$Basics$composeR,
								cfg.hH,
								function ($) {
									return $.iD;
								}))(item)),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('text-gray-400 float-right')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(
								A2(
									$elm$core$Basics$composeR,
									function ($) {
										return $.eG;
									},
									A2(
										$elm$core$Basics$composeR,
										cfg.hH,
										function ($) {
											return $.gQ;
										}))(item))
							]))
					]));
		};
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('relative '),
					$author$project$Util$Html$onKeyUpCode($author$project$Comp$Dropdown$KeyPress)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(cfg.ix.fC)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex-grow'),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'opacity-50',
											_Utils_eq(sel, $elm$core$Maybe$Nothing)),
											_Utils_Tuple2(
											'hidden',
											model.k && $author$project$Comp$Dropdown$isSearchable(model)),
											_Utils_Tuple2(
											'ml-4',
											!_Utils_eq(sel, $elm$core$Maybe$Nothing))
										])),
									$elm$html$Html$Attributes$tabindex(0),
									$author$project$Util$Html$onKeyUpCode($author$project$Comp$Dropdown$KeyPress),
									$elm$html$Html$Events$onClick($author$project$Comp$Dropdown$ToggleMenu),
									$elm$html$Html$Attributes$href('#')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(
									A2(
										$elm$core$Maybe$withDefault,
										cfg.h5,
										A2(
											$elm$core$Maybe$map,
											A2(
												$elm$core$Basics$composeR,
												function ($) {
													return $.eG;
												},
												A2(
													$elm$core$Basics$composeR,
													cfg.hH,
													function ($) {
														return $.iD;
													})),
											sel)))
								])),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('absolute left-3'),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'hidden',
											(model.k && $author$project$Comp$Dropdown$isSearchable(model)) || _Utils_eq(sel, $elm$core$Maybe$Nothing))
										])),
									$elm$html$Html$Attributes$class('hover:opacity-50'),
									$elm$html$Html$Attributes$href('#'),
									A2(
									$elm$core$Maybe$withDefault,
									$elm$html$Html$Attributes$class('hidden'),
									A2(
										$elm$core$Maybe$map,
										function (item) {
											return $elm$html$Html$Events$onClick(
												$author$project$Comp$Dropdown$RemoveItem2(item));
										},
										sel))
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-times')
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$input,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$type_('text'),
									$elm$html$Html$Attributes$placeholder(cfg.h5),
									$elm$html$Html$Events$onInput(
									$author$project$Comp$Dropdown$Filter(
										A2(
											$elm$core$Basics$composeR,
											cfg.hH,
											function ($) {
												return $.iD;
											}))),
									$elm$html$Html$Attributes$value(model.a_),
									$elm$html$Html$Attributes$class('inline-block border-0 px-0 w-full py-0 focus:ring-0 '),
									$elm$html$Html$Attributes$class(cfg.ix.fu),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'hidden',
											!(model.k && $author$project$Comp$Dropdown$isSearchable(model)))
										]))
								]),
							_List_Nil),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('rounded cursor-pointer ml-2 absolute right-2'),
									$author$project$Util$Html$onKeyUpCode($author$project$Comp$Dropdown$KeyPress),
									$elm$html$Html$Events$onClick($author$project$Comp$Dropdown$ToggleMenu),
									$elm$html$Html$Attributes$href('#')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-angle-down px-2')
										]),
									_List_Nil)
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(cfg.ix.fJ),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', !model.k)
								]))
						]),
					A2(
						$elm$core$List$map,
						renderItem,
						$author$project$Comp$Dropdown$getOptions(model)))
				]));
	});
var $author$project$Comp$Dropdown$view2 = F2(
	function (cfg, model) {
		return model.D ? A2($author$project$Comp$Dropdown$viewMultiple2, cfg, model) : A2($author$project$Comp$Dropdown$viewSingle2, cfg, model);
	});
var $author$project$Styles$warnMessageColors = ' border-yellow-800 bg-yellow-50 text-yellow-800 dark:border-amber-200 dark:bg-amber-800 dark:text-amber-200 ';
var $author$project$Styles$warnMessage = $author$project$Styles$warnMessageColors + ' border dark:bg-opacity-25 px-2 py-2 rounded ';
var $author$project$Comp$AliasForm$view = F3(
	function (flags, texts, model) {
		var modalSettings = A5($author$project$Comp$ConfirmModal$defaultSettings, $author$project$Comp$AliasForm$DeleteConfirm, $author$project$Comp$AliasForm$DeleteCancel, texts.eK.g2, texts.eK.gZ, texts.eK.dU);
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-col relative')
				]),
			_List_fromArray(
				[
					$author$project$Comp$ConfirmModal$view(
					_Utils_update(
						modalSettings,
						{da: model.aR})),
					A2(
					$elm$html$Html$form,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'hidden',
											$author$project$Comp$AliasForm$isCreate(model))
										])),
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel),
											$elm$html$Html$Attributes$for('alias-id')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.hs)
										])),
									A2(
									$elm$html$Html$input,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$type_('text'),
											$elm$html$Html$Attributes$id('alias-id'),
											$elm$html$Html$Events$onInput($author$project$Comp$AliasForm$SetId),
											$elm$html$Html$Attributes$value(
											A2($elm$core$Maybe$withDefault, '', model.a0)),
											$elm$html$Html$Attributes$class($author$project$Styles$textInput)
										]),
									_List_Nil),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2(
													'hidden',
													$author$project$Comp$AliasForm$isCreate(model))
												])),
											$elm$html$Html$Attributes$class($author$project$Styles$warnMessage),
											$elm$html$Html$Attributes$class('mt-2')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class($author$project$Styles$header3)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.hW)
												])),
											A2(
											$elm$html$Html$map,
											function (_v0) {
												return $author$project$Comp$AliasForm$Cancel;
											},
											texts.hV)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									$author$project$Comp$MenuBar$viewItem(
									$author$project$Comp$MenuBar$Checkbox(
										{
											hs: 'alias-enabled',
											hx: texts.da,
											cI: function (_v1) {
												return $author$project$Comp$AliasForm$ToggleEnabled;
											},
											eG: model.ah
										})),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-sm opacity-75')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text('If not enabled, uploads are not possible via this alias.')
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel),
											$elm$html$Html$Attributes$for('alias-name')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dX),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$input,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$type_('text'),
											$elm$html$Html$Attributes$value(model.Y),
											$elm$html$Html$Events$onInput($author$project$Comp$AliasForm$SetName),
											$elm$html$Html$Attributes$class($author$project$Styles$textInput),
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2(
													$author$project$Styles$inputErrorBorder,
													$elm$core$String$isEmpty(model.Y))
												])),
											$elm$html$Html$Attributes$id('alias-name')
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.eF),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Comp$AliasForm$ValidityMsg,
									A4($author$project$Comp$ValidityField$view, texts.ad, flags, model.ad, model.cp))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4'),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2('hidden', !flags.b.cM)
										]))
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dT)
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Comp$AliasForm$MemberDropdownMsg,
									A2(
										$author$project$Comp$Dropdown$view2,
										{
											hy: function (_v2) {
												return $author$project$Styles$basicLabel;
											},
											hH: function (m) {
												return {gQ: '', iD: m.dK};
											},
											h5: texts.ih,
											ix: $author$project$Data$DropdownStyle$mainStyle
										},
										model.S)),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-sm opacity-75')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.hK)
										]))
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('mb-2')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$button,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$type_('button'),
									$elm$html$Html$Attributes$class($author$project$Styles$primaryButton),
									$elm$html$Html$Attributes$class('mr-2'),
									$elm$html$Html$Events$onClick($author$project$Comp$AliasForm$Submit)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.gt)
								])),
							A2(
							$elm$html$Html$button,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$secondaryButton),
									$elm$html$Html$Attributes$type_('button'),
									$elm$html$Html$Events$onClick($author$project$Comp$AliasForm$Cancel)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.eP)
								])),
							A2(
							$elm$html$Html$button,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('float-right'),
									$elm$html$Html$Attributes$class($author$project$Styles$deleteButton),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'hidden',
											$author$project$Comp$AliasForm$isCreate(model))
										])),
									$elm$html$Html$Attributes$type_('button'),
									$elm$html$Html$Events$onClick($author$project$Comp$AliasForm$RequestDelete)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.e0)
								]))
						]))
				]));
	});
var $author$project$Page$Alias$View$viewCreate = F3(
	function (flags, texts, model) {
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$h1,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$header1)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('fa fa-upload mr-2')
							]),
						_List_Nil),
						$elm$html$Html$text(texts.aN)
					])),
				A2(
				$elm$html$Html$map,
				$author$project$Page$Alias$Data$AliasFormMsg,
				A3($author$project$Comp$AliasForm$view, flags, texts.ax, model.fh)),
				A2(
				$elm$core$Maybe$withDefault,
				$author$project$Util$Html$noElement,
				A2($elm$core$Maybe$map, $author$project$Util$Html$resultMsg, model.gg))
			]);
	});
var $author$project$Page$Alias$Data$AliasTableMsg = function (a) {
	return {$: 4, a: a};
};
var $author$project$Page$Alias$Data$InitNewAlias = {$: 10};
var $author$project$Page$Alias$Data$SetQuery = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$Alias$View$searchArea = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$PrimaryButton(
						{
							dt: $elm$core$Maybe$Just('fa fa-plus'),
							hx: texts.bf,
							cI: $author$project$Page$Alias$Data$InitNewAlias,
							eA: texts.bf
						})
					]),
				$8: 'mb-4',
				it: _List_fromArray(
					[
						$author$project$Comp$MenuBar$TextInput(
						{
							dt: $elm$core$Maybe$Just('fa fa-search'),
							h5: texts.ih,
							cI: $author$project$Page$Alias$Data$SetQuery,
							eG: model.h7
						})
					]),
				iw: true
			});
	});
var $author$project$Comp$AliasTable$Select = $elm$core$Basics$identity;
var $author$project$Data$ValidityOptions$findValidityItemMillis = F3(
	function (texts, flags, millis) {
		return A3(
			$author$project$Data$ValidityOptions$findValidityItem,
			texts,
			flags,
			$author$project$Data$ValidityValue$Millis(millis));
	});
var $author$project$Comp$AliasTable$isSelected = F2(
	function (model, alias_) {
		return A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$eq(alias_.hs),
				A2(
					$elm$core$Maybe$map,
					function ($) {
						return $.hs;
					},
					model.cG)));
	});
var $author$project$Comp$Basic$showLinkLabel = F2(
	function (label, click) {
		return $author$project$Comp$Basic$linkLabel(
			{
				t: false,
				x: click,
				dt: 'fa fa-eye',
				hx: label,
				ix: {ds: 'hover:bg-blue-500 hover:text-gray-100 ' + 'dark:hover:bg-orange-500 dark:hover:text-stone-900', d5: 'border-blue-500 text-blue-500 ' + 'dark:border-orange-500 dark:text-orange-500'}
			});
	});
var $author$project$Comp$Basic$showLinkTableCell = F2(
	function (label, m) {
		return A2(
			$elm$html$Html$td,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$editLinkTableCellStyle)
				]),
			_List_fromArray(
				[
					A2($author$project$Comp$Basic$showLinkLabel, label, m)
				]));
	});
var $author$project$Comp$AliasTable$viewTableLine = F4(
	function (flags, texts, model, alias_) {
		var isOwner = A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$eq(alias_.d3),
				A2(
					$elm$core$Maybe$map,
					function ($) {
						return $.eD;
					},
					flags.f)));
		return A2(
			$elm$html$Html$tr,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							'active',
							A2($author$project$Comp$AliasTable$isSelected, model, alias_))
						])),
					$elm$html$Html$Attributes$class($author$project$Styles$tableRow)
				]),
			_List_fromArray(
				[
					isOwner ? A2($author$project$Comp$Basic$editLinkTableCell, texts.he, alias_) : A2($author$project$Comp$Basic$showLinkTableCell, texts.ir, alias_),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center py-4 md:py-2')
						]),
					_List_fromArray(
						[
							$author$project$Util$Html$checkbox(alias_.da)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left py-4 md:py-2')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(alias_.dX)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left py-4 md:py-2 hidden md:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(alias_.d3)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left py-4 md:py-2 hidden md:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							A3($author$project$Data$ValidityOptions$findValidityItemMillis, texts.ad, flags, alias_.eF).a)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left py-4 md:py-2 hidden md:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							A2(
								$elm$core$String$join,
								', ',
								A2(
									$elm$core$List$map,
									function ($) {
										return $.dK;
									},
									alias_.dT.dG)))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left hidden md:table-cell md:py-2')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							texts.eZ(alias_.c0))
						]))
				]));
	});
var $author$project$Comp$AliasTable$view = F4(
	function (flags, texts, aliases, model) {
		return A2(
			$elm$html$Html$table,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$tableMain)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$thead,
					_List_Nil,
					_List_fromArray(
						[
							A2(
							$elm$html$Html$tr,
							_List_Nil,
							_List_fromArray(
								[
									A2($elm$html$Html$th, _List_Nil, _List_Nil),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center px-2 md:hidden')
										]),
									_List_fromArray(
										[
											$author$project$Util$Html$checkbox(true)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center px-2 hidden md:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.da)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dX)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left hidden md:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.d3)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left hidden md:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.eF)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left hidden md:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text('Member')
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left hidden md:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.c0)
										]))
								]))
						])),
					A2(
					$elm$html$Html$tbody,
					_List_Nil,
					A2(
						$elm$core$List$map,
						A3($author$project$Comp$AliasTable$viewTableLine, flags, texts, model),
						aliases))
				]));
	});
var $author$project$Page$Alias$View$viewList = F3(
	function (flags, texts, model) {
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$h1,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$header1)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('fa fa-dot-circle font-thin mr-2')
							]),
						_List_Nil),
						$elm$html$Html$text(texts.az)
					])),
				A2($author$project$Page$Alias$View$searchArea, texts, model),
				A2(
				$elm$html$Html$map,
				$author$project$Page$Alias$Data$AliasTableMsg,
				A4($author$project$Comp$AliasTable$view, flags, texts.aA, model.gi, model.gw))
			]);
	});
var $author$project$Styles$infoMessage = ' border border-blue-800 bg-blue-100 text-blue-800 dark:border-sky-200 dark:bg-sky-800 dark:text-sky-200 dark:bg-opacity-25 px-2 py-2 rounded ';
var $author$project$Styles$box = ' border dark:border-stone-500 bg-white dark:bg-stone-800 shadow-md ';
var $elm$html$Html$code = _VirtualDom_node('code');
var $author$project$Styles$header2 = ' text-2xl mb-3 font-medium tracking-wide ';
var $author$project$Styles$message = ' border border-gray-600 bg-gray-50 text-gray-600 ' + ('dark:border-stone-500 dark:bg-stone-700 dark:bg-opacity-80 dark:text-stone-400 ' + 'px-4 py-2 rounded ');
var $elm$html$Html$pre = _VirtualDom_node('pre');
var $author$project$Page$Alias$Data$InitMail = {$: 9};
var $elm$virtual_dom$VirtualDom$attribute = F2(
	function (key, value) {
		return A2(
			_VirtualDom_attribute,
			_VirtualDom_noOnOrFormAction(key),
			_VirtualDom_noJavaScriptOrHtmlUri(value));
	});
var $elm$html$Html$Attributes$attribute = $elm$virtual_dom$VirtualDom$attribute;
var $author$project$Styles$border = ' border dark:border-stone-600 ';
var $author$project$Comp$Basic$genericButton = function (model) {
	var attrs = model.t ? _Utils_ap(
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class(model.aE),
				$elm$html$Html$Attributes$class('disabled'),
				$elm$html$Html$Attributes$href('#')
			]),
		model.F) : _Utils_ap(
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class(model.aE),
				$elm$html$Html$Attributes$class(model.ce),
				model.x
			]),
		model.F);
	return A4($author$project$Comp$Basic$genericLink, model.O, model.dt, model.hx, attrs);
};
var $author$project$Comp$Basic$primaryButton = function (model) {
	return $author$project$Comp$Basic$genericButton(
		{
			ce: $author$project$Styles$primaryButtonHover,
			F: model.F,
			aE: _Utils_ap($author$project$Styles$primaryButtonMain, $author$project$Styles$primaryButtonRounded),
			t: model.t,
			x: model.x,
			dt: model.dt,
			hx: model.hx,
			O: model.O
		});
};
var $pablohirafuji$elm_qrcode$QRCode$Quartile = 2;
var $pablohirafuji$elm_qrcode$QRCode$QRCode = $elm$core$Basics$identity;
var $elm$core$Result$andThen = F2(
	function (callback, result) {
		if (!result.$) {
			var value = result.a;
			return callback(value);
		} else {
			var msg = result.a;
			return $elm$core$Result$Err(msg);
		}
	});
var $elm$core$Bitwise$and = _Bitwise_and;
var $elm$core$Bitwise$shiftRightZfBy = _Bitwise_shiftRightZfBy;
var $elm$core$Array$bitMask = 4294967295 >>> (32 - $elm$core$Array$shiftStep);
var $elm$core$Elm$JsArray$unsafeGet = _JsArray_unsafeGet;
var $elm$core$Array$getHelp = F3(
	function (shift, index, tree) {
		getHelp:
		while (true) {
			var pos = $elm$core$Array$bitMask & (index >>> shift);
			var _v0 = A2($elm$core$Elm$JsArray$unsafeGet, pos, tree);
			if (!_v0.$) {
				var subTree = _v0.a;
				var $temp$shift = shift - $elm$core$Array$shiftStep,
					$temp$index = index,
					$temp$tree = subTree;
				shift = $temp$shift;
				index = $temp$index;
				tree = $temp$tree;
				continue getHelp;
			} else {
				var values = _v0.a;
				return A2($elm$core$Elm$JsArray$unsafeGet, $elm$core$Array$bitMask & index, values);
			}
		}
	});
var $elm$core$Bitwise$shiftLeftBy = _Bitwise_shiftLeftBy;
var $elm$core$Array$tailIndex = function (len) {
	return (len >>> 5) << 5;
};
var $elm$core$Array$get = F2(
	function (index, _v0) {
		var len = _v0.a;
		var startShift = _v0.b;
		var tree = _v0.c;
		var tail = _v0.d;
		return ((index < 0) || (_Utils_cmp(index, len) > -1)) ? $elm$core$Maybe$Nothing : ((_Utils_cmp(
			index,
			$elm$core$Array$tailIndex(len)) > -1) ? $elm$core$Maybe$Just(
			A2($elm$core$Elm$JsArray$unsafeGet, $elm$core$Array$bitMask & index, tail)) : $elm$core$Maybe$Just(
			A3($elm$core$Array$getHelp, startShift, index, tree)));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex = F3(
	function (size, row, col) {
		return (size * row) + col;
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$isOccupy = F4(
	function (row, col, size, matrix) {
		var _v0 = A2(
			$elm$core$Array$get,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, row, col),
			matrix);
		if ((!_v0.$) && (!_v0.a.$)) {
			return true;
		} else {
			return false;
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$nextModule = function (placement) {
	var row = placement.ej;
	var col = placement.B;
	var isRight = placement.N;
	var isUp = placement.cf;
	return isRight ? _Utils_update(
		placement,
		{B: col - 1, N: false}) : (isUp ? _Utils_update(
		placement,
		{B: col + 1, N: true, ej: row - 1}) : _Utils_update(
		placement,
		{B: col + 1, N: true, ej: row + 1}));
};
var $elm$core$Bitwise$shiftRightBy = _Bitwise_shiftRightBy;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$bitToColor = F2(
	function (_byte, offset) {
		return (1 & (_byte >> (7 - offset))) === 1;
	});
var $elm$core$Elm$JsArray$unsafeSet = _JsArray_unsafeSet;
var $elm$core$Array$setHelp = F4(
	function (shift, index, value, tree) {
		var pos = $elm$core$Array$bitMask & (index >>> shift);
		var _v0 = A2($elm$core$Elm$JsArray$unsafeGet, pos, tree);
		if (!_v0.$) {
			var subTree = _v0.a;
			var newSub = A4($elm$core$Array$setHelp, shift - $elm$core$Array$shiftStep, index, value, subTree);
			return A3(
				$elm$core$Elm$JsArray$unsafeSet,
				pos,
				$elm$core$Array$SubTree(newSub),
				tree);
		} else {
			var values = _v0.a;
			var newLeaf = A3($elm$core$Elm$JsArray$unsafeSet, $elm$core$Array$bitMask & index, value, values);
			return A3(
				$elm$core$Elm$JsArray$unsafeSet,
				pos,
				$elm$core$Array$Leaf(newLeaf),
				tree);
		}
	});
var $elm$core$Array$set = F3(
	function (index, value, array) {
		var len = array.a;
		var startShift = array.b;
		var tree = array.c;
		var tail = array.d;
		return ((index < 0) || (_Utils_cmp(index, len) > -1)) ? array : ((_Utils_cmp(
			index,
			$elm$core$Array$tailIndex(len)) > -1) ? A4(
			$elm$core$Array$Array_elm_builtin,
			len,
			startShift,
			tree,
			A3($elm$core$Elm$JsArray$unsafeSet, $elm$core$Array$bitMask & index, value, tail)) : A4(
			$elm$core$Array$Array_elm_builtin,
			len,
			startShift,
			A4($elm$core$Array$setHelp, startShift, index, value, tree),
			tail));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setDataModule = F3(
	function (_v0, _byte, offset) {
		var size = _v0.en;
		var row = _v0.ej;
		var col = _v0.B;
		return A2(
			$elm$core$Array$set,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, row, col),
			$elm$core$Maybe$Just(
				_Utils_Tuple2(
					false,
					A2($pablohirafuji$elm_qrcode$QRCode$Matrix$bitToColor, _byte, offset))));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$addDataModule = F4(
	function (placement, bytes, offset, matrix) {
		addDataModule:
		while (true) {
			var size = placement.en;
			var row = placement.ej;
			var col = placement.B;
			if (!bytes.b) {
				return matrix;
			} else {
				var head = bytes.a;
				var tail = bytes.b;
				if (offset >= 8) {
					var $temp$placement = placement,
						$temp$bytes = tail,
						$temp$offset = 0,
						$temp$matrix = matrix;
					placement = $temp$placement;
					bytes = $temp$bytes;
					offset = $temp$offset;
					matrix = $temp$matrix;
					continue addDataModule;
				} else {
					if (col === 6) {
						var $temp$placement = _Utils_update(
							placement,
							{B: col - 1, N: true}),
							$temp$bytes = bytes,
							$temp$offset = offset,
							$temp$matrix = matrix;
						placement = $temp$placement;
						bytes = $temp$bytes;
						offset = $temp$offset;
						matrix = $temp$matrix;
						continue addDataModule;
					} else {
						if (row < 0) {
							var $temp$placement = _Utils_update(
								placement,
								{B: col - 2, N: true, cf: false, ej: 0}),
								$temp$bytes = bytes,
								$temp$offset = offset,
								$temp$matrix = matrix;
							placement = $temp$placement;
							bytes = $temp$bytes;
							offset = $temp$offset;
							matrix = $temp$matrix;
							continue addDataModule;
						} else {
							if (_Utils_cmp(row, size) > -1) {
								var $temp$placement = _Utils_update(
									placement,
									{B: col - 2, N: true, cf: true, ej: size - 1}),
									$temp$bytes = bytes,
									$temp$offset = offset,
									$temp$matrix = matrix;
								placement = $temp$placement;
								bytes = $temp$bytes;
								offset = $temp$offset;
								matrix = $temp$matrix;
								continue addDataModule;
							} else {
								if (A4($pablohirafuji$elm_qrcode$QRCode$Matrix$isOccupy, row, col, size, matrix)) {
									var $temp$placement = $pablohirafuji$elm_qrcode$QRCode$Matrix$nextModule(placement),
										$temp$bytes = bytes,
										$temp$offset = offset,
										$temp$matrix = matrix;
									placement = $temp$placement;
									bytes = $temp$bytes;
									offset = $temp$offset;
									matrix = $temp$matrix;
									continue addDataModule;
								} else {
									var $temp$placement = $pablohirafuji$elm_qrcode$QRCode$Matrix$nextModule(placement),
										$temp$bytes = bytes,
										$temp$offset = offset + 1,
										$temp$matrix = A4($pablohirafuji$elm_qrcode$QRCode$Matrix$setDataModule, placement, head, offset, matrix);
									placement = $temp$placement;
									bytes = $temp$bytes;
									offset = $temp$offset;
									matrix = $temp$matrix;
									continue addDataModule;
								}
							}
						}
					}
				}
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$initPlacement = function (size) {
	return {B: size + 1, N: true, cf: true, ej: size + 1, en: size};
};
var $pablohirafuji$elm_qrcode$QRCode$Matrix$addData = F3(
	function (size, bytes, matrix) {
		return A4(
			$pablohirafuji$elm_qrcode$QRCode$Matrix$addDataModule,
			$pablohirafuji$elm_qrcode$QRCode$Matrix$initPlacement(size),
			bytes,
			0,
			matrix);
	});
var $pablohirafuji$elm_qrcode$QRCode$Error$AlignmentPatternNotFound = {$: 0};
var $elm$core$Array$fromListHelp = F3(
	function (list, nodeList, nodeListSize) {
		fromListHelp:
		while (true) {
			var _v0 = A2($elm$core$Elm$JsArray$initializeFromList, $elm$core$Array$branchFactor, list);
			var jsArray = _v0.a;
			var remainingItems = _v0.b;
			if (_Utils_cmp(
				$elm$core$Elm$JsArray$length(jsArray),
				$elm$core$Array$branchFactor) < 0) {
				return A2(
					$elm$core$Array$builderToArray,
					true,
					{l: nodeList, h: nodeListSize, j: jsArray});
			} else {
				var $temp$list = remainingItems,
					$temp$nodeList = A2(
					$elm$core$List$cons,
					$elm$core$Array$Leaf(jsArray),
					nodeList),
					$temp$nodeListSize = nodeListSize + 1;
				list = $temp$list;
				nodeList = $temp$nodeList;
				nodeListSize = $temp$nodeListSize;
				continue fromListHelp;
			}
		}
	});
var $elm$core$Array$fromList = function (list) {
	if (!list.b) {
		return $elm$core$Array$empty;
	} else {
		return A3($elm$core$Array$fromListHelp, list, _List_Nil, 0);
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentPatternData = $elm$core$Array$fromList(
	_List_fromArray(
		[
			_List_Nil,
			_List_fromArray(
			[6, 18]),
			_List_fromArray(
			[6, 22]),
			_List_fromArray(
			[6, 26]),
			_List_fromArray(
			[6, 30]),
			_List_fromArray(
			[6, 34]),
			_List_fromArray(
			[6, 22, 38]),
			_List_fromArray(
			[6, 24, 42]),
			_List_fromArray(
			[6, 26, 46]),
			_List_fromArray(
			[6, 28, 50]),
			_List_fromArray(
			[6, 30, 54]),
			_List_fromArray(
			[6, 32, 58]),
			_List_fromArray(
			[6, 34, 62]),
			_List_fromArray(
			[6, 26, 46, 66]),
			_List_fromArray(
			[6, 26, 48, 70]),
			_List_fromArray(
			[6, 26, 50, 74]),
			_List_fromArray(
			[6, 30, 54, 78]),
			_List_fromArray(
			[6, 30, 56, 82]),
			_List_fromArray(
			[6, 30, 58, 86]),
			_List_fromArray(
			[6, 34, 62, 90]),
			_List_fromArray(
			[6, 28, 50, 72, 94]),
			_List_fromArray(
			[6, 26, 50, 74, 98]),
			_List_fromArray(
			[6, 30, 54, 78, 102]),
			_List_fromArray(
			[6, 28, 54, 80, 106]),
			_List_fromArray(
			[6, 32, 58, 84, 110]),
			_List_fromArray(
			[6, 30, 58, 86, 114]),
			_List_fromArray(
			[6, 34, 62, 90, 118]),
			_List_fromArray(
			[6, 26, 50, 74, 98, 122]),
			_List_fromArray(
			[6, 30, 54, 78, 102, 126]),
			_List_fromArray(
			[6, 26, 52, 78, 104, 130]),
			_List_fromArray(
			[6, 30, 56, 82, 108, 134]),
			_List_fromArray(
			[6, 34, 60, 86, 112, 138]),
			_List_fromArray(
			[6, 30, 58, 86, 114, 142]),
			_List_fromArray(
			[6, 34, 62, 90, 118, 146]),
			_List_fromArray(
			[6, 30, 54, 78, 102, 126, 150]),
			_List_fromArray(
			[6, 24, 50, 76, 102, 128, 154]),
			_List_fromArray(
			[6, 28, 54, 80, 106, 132, 158]),
			_List_fromArray(
			[6, 32, 58, 84, 110, 136, 162]),
			_List_fromArray(
			[6, 26, 54, 82, 110, 138, 166]),
			_List_fromArray(
			[6, 30, 58, 86, 114, 142, 170])
		]));
var $elm$core$Result$fromMaybe = F2(
	function (err, maybe) {
		if (!maybe.$) {
			var v = maybe.a;
			return $elm$core$Result$Ok(v);
		} else {
			return $elm$core$Result$Err(err);
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$getAreaCoord = F2(
	function (rows, cols) {
		return A3(
			$elm$core$List$foldl,
			F2(
				function (row, list) {
					return A3(
						$elm$core$List$foldl,
						F2(
							function (col, list_) {
								return A2(
									$elm$core$List$cons,
									_Utils_Tuple2(row, col),
									list_);
							}),
						list,
						cols);
				}),
			_List_Nil,
			rows);
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$isValidAlign = F2(
	function (size, _v0) {
		var row = _v0.a;
		var col = _v0.b;
		return ((row > 10) || ((10 < col) && (_Utils_cmp(col, size - 10) < 0))) && ((_Utils_cmp(row, size - 10) < 0) || (col > 10));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentRange = A2($elm$core$List$range, -2, 2);
var $pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentColor = F2(
	function (row, col) {
		return (_Utils_eq(row, -2) || ((row === 2) || (_Utils_eq(col, -2) || ((col === 2) || ((!row) && (!col)))))) ? $elm$core$Maybe$Just(
			_Utils_Tuple2(true, true)) : $elm$core$Maybe$Just(
			_Utils_Tuple2(true, false));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setAlignModule = F4(
	function (size, rowPos, colPos, _v0) {
		var row = _v0.a;
		var col = _v0.b;
		return A2(
			$elm$core$Array$set,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, row + rowPos, col + colPos),
			A2($pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentColor, row, col));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setAlignment = F3(
	function (size, _v0, matrix) {
		var row = _v0.a;
		var col = _v0.b;
		return A3(
			$elm$core$List$foldl,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$setAlignModule, size, row, col),
			matrix,
			A2($pablohirafuji$elm_qrcode$QRCode$Matrix$getAreaCoord, $pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentRange, $pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentRange));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setAlignments = F3(
	function (size, locations, matrix) {
		return A3(
			$elm$core$List$foldl,
			$pablohirafuji$elm_qrcode$QRCode$Matrix$setAlignment(size),
			matrix,
			A2(
				$elm$core$List$filter,
				$pablohirafuji$elm_qrcode$QRCode$Matrix$isValidAlign(size),
				A2($pablohirafuji$elm_qrcode$QRCode$Matrix$getAreaCoord, locations, locations)));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentPattern = F3(
	function (version, size, matrix) {
		return A2(
			$elm$core$Result$map,
			function (a) {
				return A3($pablohirafuji$elm_qrcode$QRCode$Matrix$setAlignments, size, a, matrix);
			},
			A2(
				$elm$core$Result$fromMaybe,
				$pablohirafuji$elm_qrcode$QRCode$Error$AlignmentPatternNotFound,
				A2($elm$core$Array$get, version - 1, $pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentPatternData)));
	});
var $elm$core$Basics$always = F2(
	function (a, _v0) {
		return a;
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$darkModule = F2(
	function (version, size) {
		return A2(
			$elm$core$Array$set,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, (4 * version) + 9, 8),
			$elm$core$Maybe$Just(
				_Utils_Tuple2(true, true)));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$finderRange = A2($elm$core$List$range, 0, 8);
var $pablohirafuji$elm_qrcode$QRCode$Matrix$finderColor = F2(
	function (row, col) {
		return ((1 <= row) && ((row <= 7) && ((col === 1) || (col === 7)))) || (((1 <= col) && ((col <= 7) && ((row === 1) || (row === 7)))) || ((3 <= row) && ((row <= 5) && ((3 <= col) && (col <= 5)))));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setFinder = F5(
	function (size, rowOffset, colOffset, _v0, matrix) {
		var row = _v0.a;
		var col = _v0.b;
		var finalRow = row + rowOffset;
		var finalCol = col + colOffset;
		return ((finalRow < 0) || ((finalCol < 0) || ((_Utils_cmp(finalRow, size) > -1) || (_Utils_cmp(finalCol, size) > -1)))) ? matrix : A3(
			$elm$core$Array$set,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, finalRow, finalCol),
			$elm$core$Maybe$Just(
				_Utils_Tuple2(
					true,
					A2($pablohirafuji$elm_qrcode$QRCode$Matrix$finderColor, row, col))),
			matrix);
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$finderPattern = F4(
	function (size, rowOffset, colOffset, matrix) {
		return A3(
			$elm$core$List$foldl,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$setFinder, size, rowOffset, colOffset),
			matrix,
			A2($pablohirafuji$elm_qrcode$QRCode$Matrix$getAreaCoord, $pablohirafuji$elm_qrcode$QRCode$Matrix$finderRange, $pablohirafuji$elm_qrcode$QRCode$Matrix$finderRange));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$applyMaskColor = F2(
	function (maybeModule, isChange) {
		if (isChange) {
			if ((!maybeModule.$) && (!maybeModule.a.a)) {
				var _v1 = maybeModule.a;
				var isDark = _v1.b;
				return $elm$core$Maybe$Just(
					_Utils_Tuple2(false, !isDark));
			} else {
				return maybeModule;
			}
		} else {
			return maybeModule;
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$getCoord = F2(
	function (size, index) {
		return _Utils_Tuple2(
			(index / size) | 0,
			A2($elm$core$Basics$modBy, size, index));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$applyMaskFunction = F4(
	function (_function, size, index, maybeModule) {
		return A2(
			$pablohirafuji$elm_qrcode$QRCode$Matrix$applyMaskColor,
			maybeModule,
			_function(
				A2($pablohirafuji$elm_qrcode$QRCode$Matrix$getCoord, size, index)));
	});
var $elm$core$Elm$JsArray$foldl = _JsArray_foldl;
var $elm$core$Elm$JsArray$indexedMap = _JsArray_indexedMap;
var $elm$core$Array$indexedMap = F2(
	function (func, _v0) {
		var len = _v0.a;
		var tree = _v0.c;
		var tail = _v0.d;
		var initialBuilder = {
			l: _List_Nil,
			h: 0,
			j: A3(
				$elm$core$Elm$JsArray$indexedMap,
				func,
				$elm$core$Array$tailIndex(len),
				tail)
		};
		var helper = F2(
			function (node, builder) {
				if (!node.$) {
					var subTree = node.a;
					return A3($elm$core$Elm$JsArray$foldl, helper, builder, subTree);
				} else {
					var leaf = node.a;
					var offset = builder.h * $elm$core$Array$branchFactor;
					var mappedLeaf = $elm$core$Array$Leaf(
						A3($elm$core$Elm$JsArray$indexedMap, func, offset, leaf));
					return {
						l: A2($elm$core$List$cons, mappedLeaf, builder.l),
						h: builder.h + 1,
						j: builder.j
					};
				}
			});
		return A2(
			$elm$core$Array$builderToArray,
			true,
			A3($elm$core$Elm$JsArray$foldl, helper, initialBuilder, tree));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$maskFunction = function (mask) {
	switch (mask) {
		case 0:
			return function (_v1) {
				var row = _v1.a;
				var col = _v1.b;
				return !A2($elm$core$Basics$modBy, 2, row + col);
			};
		case 1:
			return function (_v2) {
				var row = _v2.a;
				return !A2($elm$core$Basics$modBy, 2, row);
			};
		case 2:
			return function (_v3) {
				var col = _v3.b;
				return !A2($elm$core$Basics$modBy, 3, col);
			};
		case 3:
			return function (_v4) {
				var row = _v4.a;
				var col = _v4.b;
				return !A2($elm$core$Basics$modBy, 3, row + col);
			};
		case 4:
			return function (_v5) {
				var row = _v5.a;
				var col = _v5.b;
				return !A2(
					$elm$core$Basics$modBy,
					2,
					$elm$core$Basics$floor(row / 2) + $elm$core$Basics$floor(col / 3));
			};
		case 5:
			return function (_v6) {
				var row = _v6.a;
				var col = _v6.b;
				return !(A2($elm$core$Basics$modBy, 2, row * col) + A2($elm$core$Basics$modBy, 3, row * col));
			};
		case 6:
			return function (_v7) {
				var row = _v7.a;
				var col = _v7.b;
				return !A2(
					$elm$core$Basics$modBy,
					2,
					A2($elm$core$Basics$modBy, 2, row * col) + A2($elm$core$Basics$modBy, 3, row * col));
			};
		default:
			return function (_v8) {
				var row = _v8.a;
				var col = _v8.b;
				return !A2(
					$elm$core$Basics$modBy,
					2,
					A2($elm$core$Basics$modBy, 3, row * col) + A2($elm$core$Basics$modBy, 2, row + col));
			};
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Matrix$applyMask = F3(
	function (size, mask, matrix) {
		return A2(
			$elm$core$Array$indexedMap,
			A2(
				$pablohirafuji$elm_qrcode$QRCode$Matrix$applyMaskFunction,
				$pablohirafuji$elm_qrcode$QRCode$Matrix$maskFunction(mask),
				size),
			matrix);
	});
var $elm$core$List$drop = F2(
	function (n, list) {
		drop:
		while (true) {
			if (n <= 0) {
				return list;
			} else {
				if (!list.b) {
					return list;
				} else {
					var x = list.a;
					var xs = list.b;
					var $temp$n = n - 1,
						$temp$list = xs;
					n = $temp$n;
					list = $temp$list;
					continue drop;
				}
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$breakList = F3(
	function (width, list, acc) {
		breakList:
		while (true) {
			if (!list.b) {
				return $elm$core$List$reverse(acc);
			} else {
				var $temp$width = width,
					$temp$list = A2($elm$core$List$drop, width, list),
					$temp$acc = A2(
					$elm$core$List$cons,
					A2($elm$core$List$take, width, list),
					acc);
				width = $temp$width;
				list = $temp$list;
				acc = $temp$acc;
				continue breakList;
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$isDarkModule = A2(
	$elm$core$Basics$composeR,
	$elm$core$Maybe$map($elm$core$Tuple$second),
	$elm$core$Maybe$withDefault(false));
var $pablohirafuji$elm_qrcode$QRCode$Matrix$rule1Score_ = F2(
	function (simplifiedList, _v0) {
		rule1Score_:
		while (true) {
			var last = _v0.a;
			var partialScore = _v0.b;
			var score = _v0.c;
			if (!simplifiedList.b) {
				return (partialScore >= 5) ? ((score + partialScore) - 2) : score;
			} else {
				var head = simplifiedList.a;
				var tail = simplifiedList.b;
				if (_Utils_eq(last, head)) {
					var $temp$simplifiedList = tail,
						$temp$_v0 = _Utils_Tuple3(last, partialScore + 1, score);
					simplifiedList = $temp$simplifiedList;
					_v0 = $temp$_v0;
					continue rule1Score_;
				} else {
					if (partialScore >= 5) {
						var $temp$simplifiedList = tail,
							$temp$_v0 = _Utils_Tuple3(head, 0, (score + partialScore) - 2);
						simplifiedList = $temp$simplifiedList;
						_v0 = $temp$_v0;
						continue rule1Score_;
					} else {
						var $temp$simplifiedList = tail,
							$temp$_v0 = _Utils_Tuple3(head, 0, score);
						simplifiedList = $temp$simplifiedList;
						_v0 = $temp$_v0;
						continue rule1Score_;
					}
				}
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$rule1Score = A2(
	$elm$core$Basics$composeR,
	$elm$core$List$map(
		function (a) {
			return A2(
				$pablohirafuji$elm_qrcode$QRCode$Matrix$rule1Score_,
				a,
				_Utils_Tuple3(false, 0, 0));
		}),
	$elm$core$List$sum);
var $pablohirafuji$elm_qrcode$QRCode$Matrix$rule2Score_ = F4(
	function (row1, row2, maybeLast, score) {
		rule2Score_:
		while (true) {
			if (!row1.b) {
				return score;
			} else {
				var head = row1.a;
				var tail = row1.b;
				if (!row2.b) {
					return score;
				} else {
					var head2 = row2.a;
					var tail2 = row2.b;
					if (_Utils_eq(head, head2)) {
						if (_Utils_eq(
							$elm$core$Maybe$Just(head),
							maybeLast)) {
							var $temp$row1 = tail,
								$temp$row2 = tail2,
								$temp$maybeLast = $elm$core$Maybe$Just(head),
								$temp$score = score + 3;
							row1 = $temp$row1;
							row2 = $temp$row2;
							maybeLast = $temp$maybeLast;
							score = $temp$score;
							continue rule2Score_;
						} else {
							var $temp$row1 = tail,
								$temp$row2 = tail2,
								$temp$maybeLast = $elm$core$Maybe$Just(head),
								$temp$score = score;
							row1 = $temp$row1;
							row2 = $temp$row2;
							maybeLast = $temp$maybeLast;
							score = $temp$score;
							continue rule2Score_;
						}
					} else {
						var $temp$row1 = tail,
							$temp$row2 = tail2,
							$temp$maybeLast = $elm$core$Maybe$Nothing,
							$temp$score = score;
						row1 = $temp$row1;
						row2 = $temp$row2;
						maybeLast = $temp$maybeLast;
						score = $temp$score;
						continue rule2Score_;
					}
				}
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$rule2Score = F2(
	function (list, score) {
		rule2Score:
		while (true) {
			if (list.b && list.b.b) {
				var head1 = list.a;
				var _v1 = list.b;
				var head2 = _v1.a;
				var tail = _v1.b;
				var $temp$list = tail,
					$temp$score = score + A4($pablohirafuji$elm_qrcode$QRCode$Matrix$rule2Score_, head1, head2, $elm$core$Maybe$Nothing, 0);
				list = $temp$list;
				score = $temp$score;
				continue rule2Score;
			} else {
				return score;
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$rule3Score_ = F2(
	function (simplifiedList, score) {
		rule3Score_:
		while (true) {
			_v0$3:
			while (true) {
				if (!simplifiedList.b) {
					return score;
				} else {
					if (!simplifiedList.a) {
						if (((((((((((((((((((simplifiedList.b.b && (!simplifiedList.b.a)) && simplifiedList.b.b.b) && (!simplifiedList.b.b.a)) && simplifiedList.b.b.b.b) && (!simplifiedList.b.b.b.a)) && simplifiedList.b.b.b.b.b) && simplifiedList.b.b.b.b.a) && simplifiedList.b.b.b.b.b.b) && (!simplifiedList.b.b.b.b.b.a)) && simplifiedList.b.b.b.b.b.b.b) && simplifiedList.b.b.b.b.b.b.a) && simplifiedList.b.b.b.b.b.b.b.b) && simplifiedList.b.b.b.b.b.b.b.a) && simplifiedList.b.b.b.b.b.b.b.b.b) && simplifiedList.b.b.b.b.b.b.b.b.a) && simplifiedList.b.b.b.b.b.b.b.b.b.b) && (!simplifiedList.b.b.b.b.b.b.b.b.b.a)) && simplifiedList.b.b.b.b.b.b.b.b.b.b.b) && simplifiedList.b.b.b.b.b.b.b.b.b.b.a) {
							var _v1 = simplifiedList.b;
							var _v2 = _v1.b;
							var _v3 = _v2.b;
							var _v4 = _v3.b;
							var _v5 = _v4.b;
							var _v6 = _v5.b;
							var _v7 = _v6.b;
							var _v8 = _v7.b;
							var _v9 = _v8.b;
							var _v10 = _v9.b;
							var tail = _v10.b;
							var $temp$simplifiedList = tail,
								$temp$score = score + 40;
							simplifiedList = $temp$simplifiedList;
							score = $temp$score;
							continue rule3Score_;
						} else {
							break _v0$3;
						}
					} else {
						if (((((((((((((((((((simplifiedList.b.b && (!simplifiedList.b.a)) && simplifiedList.b.b.b) && simplifiedList.b.b.a) && simplifiedList.b.b.b.b) && simplifiedList.b.b.b.a) && simplifiedList.b.b.b.b.b) && simplifiedList.b.b.b.b.a) && simplifiedList.b.b.b.b.b.b) && (!simplifiedList.b.b.b.b.b.a)) && simplifiedList.b.b.b.b.b.b.b) && simplifiedList.b.b.b.b.b.b.a) && simplifiedList.b.b.b.b.b.b.b.b) && (!simplifiedList.b.b.b.b.b.b.b.a)) && simplifiedList.b.b.b.b.b.b.b.b.b) && (!simplifiedList.b.b.b.b.b.b.b.b.a)) && simplifiedList.b.b.b.b.b.b.b.b.b.b) && (!simplifiedList.b.b.b.b.b.b.b.b.b.a)) && simplifiedList.b.b.b.b.b.b.b.b.b.b.b) && (!simplifiedList.b.b.b.b.b.b.b.b.b.b.a)) {
							var _v11 = simplifiedList.b;
							var _v12 = _v11.b;
							var _v13 = _v12.b;
							var _v14 = _v13.b;
							var _v15 = _v14.b;
							var _v16 = _v15.b;
							var _v17 = _v16.b;
							var _v18 = _v17.b;
							var _v19 = _v18.b;
							var _v20 = _v19.b;
							var tail = _v20.b;
							var $temp$simplifiedList = tail,
								$temp$score = score + 40;
							simplifiedList = $temp$simplifiedList;
							score = $temp$score;
							continue rule3Score_;
						} else {
							break _v0$3;
						}
					}
				}
			}
			var head = simplifiedList.a;
			var tail = simplifiedList.b;
			var $temp$simplifiedList = tail,
				$temp$score = score;
			simplifiedList = $temp$simplifiedList;
			score = $temp$score;
			continue rule3Score_;
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$rule3Score = A2($elm$core$List$foldl, $pablohirafuji$elm_qrcode$QRCode$Matrix$rule3Score_, 0);
var $elm$core$Basics$min = F2(
	function (x, y) {
		return (_Utils_cmp(x, y) < 0) ? x : y;
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$rule4Score = F2(
	function (size, simplifiedList) {
		var moduleCount = size * size;
		var darkCount = $elm$core$List$length(
			A2($elm$core$List$filter, $elm$core$Basics$identity, simplifiedList));
		var darkPerc = $elm$core$Basics$round((100 * darkCount) / moduleCount);
		var remOf5 = darkPerc % 5;
		var nextMult5 = $elm$core$Basics$round(
			$elm$core$Basics$abs((darkPerc + (5 - remOf5)) - 50) / 5);
		var prevMult5 = $elm$core$Basics$round(
			$elm$core$Basics$abs((darkPerc - remOf5) - 50) / 5);
		return A2($elm$core$Basics$min, prevMult5, nextMult5) * 10;
	});
var $elm$core$List$tail = function (list) {
	if (list.b) {
		var x = list.a;
		var xs = list.b;
		return $elm$core$Maybe$Just(xs);
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Helpers$transpose = function (ll) {
	transpose:
	while (true) {
		if (!ll.b) {
			return _List_Nil;
		} else {
			if (!ll.a.b) {
				var xss = ll.b;
				var $temp$ll = xss;
				ll = $temp$ll;
				continue transpose;
			} else {
				var _v1 = ll.a;
				var x = _v1.a;
				var xs = _v1.b;
				var xss = ll.b;
				var tails = A2($elm$core$List$filterMap, $elm$core$List$tail, xss);
				var heads = A2($elm$core$List$filterMap, $elm$core$List$head, xss);
				return A2(
					$elm$core$List$cons,
					A2($elm$core$List$cons, x, heads),
					$pablohirafuji$elm_qrcode$QRCode$Helpers$transpose(
						A2($elm$core$List$cons, xs, tails)));
			}
		}
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Matrix$getMaskScore = F2(
	function (size, matrix) {
		var list = A2(
			$elm$core$List$map,
			$pablohirafuji$elm_qrcode$QRCode$Matrix$isDarkModule,
			$elm$core$Array$toList(matrix));
		var rowList = A3($pablohirafuji$elm_qrcode$QRCode$Matrix$breakList, size, list, _List_Nil);
		var transposedRowList = $pablohirafuji$elm_qrcode$QRCode$Helpers$transpose(rowList);
		return function (b) {
			return _Utils_Tuple2(rowList, b);
		}(
			A2($pablohirafuji$elm_qrcode$QRCode$Matrix$rule4Score, size, list) + ($pablohirafuji$elm_qrcode$QRCode$Matrix$rule3Score(transposedRowList) + ($pablohirafuji$elm_qrcode$QRCode$Matrix$rule3Score(rowList) + (A2($pablohirafuji$elm_qrcode$QRCode$Matrix$rule2Score, rowList, 0) + ($pablohirafuji$elm_qrcode$QRCode$Matrix$rule1Score(transposedRowList) + $pablohirafuji$elm_qrcode$QRCode$Matrix$rule1Score(rowList))))));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$ecLevelToInt = function (ecLevel) {
	switch (ecLevel) {
		case 0:
			return 1;
		case 1:
			return 0;
		case 2:
			return 3;
		default:
			return 2;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Matrix$getBCHDigit = function (_int) {
	var helper = F2(
		function (digit, int_) {
			helper:
			while (true) {
				if (!(!int_)) {
					var $temp$digit = digit + 1,
						$temp$int_ = int_ >>> 1;
					digit = $temp$digit;
					int_ = $temp$int_;
					continue helper;
				} else {
					return digit;
				}
			}
		});
	return A2(helper, 0, _int);
};
var $pablohirafuji$elm_qrcode$QRCode$Matrix$maskToInt = function (mask) {
	switch (mask) {
		case 0:
			return 0;
		case 1:
			return 1;
		case 2:
			return 2;
		case 3:
			return 3;
		case 4:
			return 4;
		case 5:
			return 5;
		case 6:
			return 6;
		default:
			return 7;
	}
};
var $elm$core$Bitwise$or = _Bitwise_or;
var $elm$core$Bitwise$xor = _Bitwise_xor;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$encodeFormatInfo = F2(
	function (ecLevel, mask) {
		var g15Mask = 21522;
		var g15Int = 1335;
		var g15Digit = $pablohirafuji$elm_qrcode$QRCode$Matrix$getBCHDigit(g15Int);
		var formatInfoInt = $pablohirafuji$elm_qrcode$QRCode$Matrix$maskToInt(mask) | ($pablohirafuji$elm_qrcode$QRCode$Matrix$ecLevelToInt(ecLevel) << 3);
		var helper = function (d_) {
			helper:
			while (true) {
				if (($pablohirafuji$elm_qrcode$QRCode$Matrix$getBCHDigit(d_) - g15Digit) >= 0) {
					var $temp$d_ = d_ ^ (g15Int << ($pablohirafuji$elm_qrcode$QRCode$Matrix$getBCHDigit(d_) - g15Digit));
					d_ = $temp$d_;
					continue helper;
				} else {
					return g15Mask ^ (d_ | (formatInfoInt << 10));
				}
			}
		};
		var d = formatInfoInt << 10;
		return helper(d);
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$formatInfoHorizontal = F2(
	function (size, count) {
		return (count < 8) ? _Utils_Tuple2(8, (size - count) - 1) : ((count < 9) ? _Utils_Tuple2(8, 15 - count) : _Utils_Tuple2(8, (15 - count) - 1));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$formatInfoVertical = F2(
	function (size, count) {
		return (count < 6) ? _Utils_Tuple2(count, 8) : ((count < 8) ? _Utils_Tuple2(count + 1, 8) : _Utils_Tuple2((size - 15) + count, 8));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatModule = F4(
	function (size, isBlack, row, col) {
		return A2(
			$elm$core$Array$set,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, row, col),
			$elm$core$Maybe$Just(
				_Utils_Tuple2(true, isBlack)));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatInfo_ = F4(
	function (size, isBlackFn, count, matrix) {
		setFormatInfo_:
		while (true) {
			if (count < 15) {
				var isBlack = isBlackFn(count);
				var _v0 = A2($pablohirafuji$elm_qrcode$QRCode$Matrix$formatInfoVertical, size, count);
				var x2 = _v0.a;
				var y2 = _v0.b;
				var _v1 = A2($pablohirafuji$elm_qrcode$QRCode$Matrix$formatInfoHorizontal, size, count);
				var x1 = _v1.a;
				var y1 = _v1.b;
				var $temp$size = size,
					$temp$isBlackFn = isBlackFn,
					$temp$count = count + 1,
					$temp$matrix = A5(
					$pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatModule,
					size,
					isBlack,
					x2,
					y2,
					A5($pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatModule, size, isBlack, x1, y1, matrix));
				size = $temp$size;
				isBlackFn = $temp$isBlackFn;
				count = $temp$count;
				matrix = $temp$matrix;
				continue setFormatInfo_;
			} else {
				return matrix;
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatInfo = F4(
	function (ecLevel, size, mask, matrix) {
		var isBlack = F2(
			function (bits_, count) {
				return (1 & (bits_ >> count)) === 1;
			});
		var bits = A2($pablohirafuji$elm_qrcode$QRCode$Matrix$encodeFormatInfo, ecLevel, mask);
		return A4(
			$pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatInfo_,
			size,
			isBlack(bits),
			0,
			matrix);
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$getBestMask_ = F5(
	function (ecLevel, size, matrix, mask, _v0) {
		var minSMatrix = _v0.a;
		var minScore = _v0.b;
		var maskedMatrix = A4(
			$pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatInfo,
			ecLevel,
			size,
			mask,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$applyMask, size, mask, matrix));
		var _v1 = A2($pablohirafuji$elm_qrcode$QRCode$Matrix$getMaskScore, size, maskedMatrix);
		var maskSMatrix = _v1.a;
		var maskScore = _v1.b;
		return ((_Utils_cmp(minScore, maskScore) < 0) && (!_Utils_eq(minScore, -1))) ? _Utils_Tuple2(minSMatrix, minScore) : _Utils_Tuple2(maskSMatrix, maskScore);
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern0 = 0;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern1 = 1;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern2 = 2;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern3 = 3;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern4 = 4;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern5 = 5;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern6 = 6;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$Pattern7 = 7;
var $pablohirafuji$elm_qrcode$QRCode$Matrix$patternList = _List_fromArray(
	[0, 1, 2, 3, 4, 5, 6, 7]);
var $pablohirafuji$elm_qrcode$QRCode$Matrix$getBestMask = F3(
	function (ecLevel, size, matrix) {
		return A3(
			$elm$core$List$foldl,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getBestMask_, ecLevel, size, matrix),
			_Utils_Tuple2(_List_Nil, -1),
			$pablohirafuji$elm_qrcode$QRCode$Matrix$patternList).a;
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$reserveFormatInfo = F2(
	function (size, matrix) {
		return A4(
			$pablohirafuji$elm_qrcode$QRCode$Matrix$setFormatInfo_,
			size,
			$elm$core$Basics$always(true),
			0,
			matrix);
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$encodeVersionInfo = function (version) {
	var g18Int = 7973;
	var g18Digit = $pablohirafuji$elm_qrcode$QRCode$Matrix$getBCHDigit(g18Int);
	var helper = function (d_) {
		helper:
		while (true) {
			if (($pablohirafuji$elm_qrcode$QRCode$Matrix$getBCHDigit(d_) - g18Digit) >= 0) {
				var $temp$d_ = d_ ^ (g18Int << ($pablohirafuji$elm_qrcode$QRCode$Matrix$getBCHDigit(d_) - g18Digit));
				d_ = $temp$d_;
				continue helper;
			} else {
				return d_ | (version << 12);
			}
		}
	};
	var d = version << 12;
	return helper(d);
};
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setVersionModule = F3(
	function (size, isBlack, _v0) {
		var row = _v0.a;
		var col = _v0.b;
		return A2(
			$elm$core$Array$set,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, row, col),
			$elm$core$Maybe$Just(
				_Utils_Tuple2(true, isBlack)));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setVersionInfo_ = F4(
	function (size, isBlackFn, count, matrix) {
		setVersionInfo_:
		while (true) {
			if (count < 18) {
				var topRight = _Utils_Tuple2(
					$elm$core$Basics$floor(count / 3),
					((A2($elm$core$Basics$modBy, 3, count) + size) - 8) - 3);
				var isBlack = isBlackFn(count);
				var bottomLeft = _Utils_Tuple2(
					((A2($elm$core$Basics$modBy, 3, count) + size) - 8) - 3,
					$elm$core$Basics$floor(count / 3));
				var $temp$size = size,
					$temp$isBlackFn = isBlackFn,
					$temp$count = count + 1,
					$temp$matrix = A4(
					$pablohirafuji$elm_qrcode$QRCode$Matrix$setVersionModule,
					size,
					isBlack,
					bottomLeft,
					A4($pablohirafuji$elm_qrcode$QRCode$Matrix$setVersionModule, size, isBlack, topRight, matrix));
				size = $temp$size;
				isBlackFn = $temp$isBlackFn;
				count = $temp$count;
				matrix = $temp$matrix;
				continue setVersionInfo_;
			} else {
				return matrix;
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setVersionInfo = F3(
	function (version, size, matrix) {
		if (version >= 7) {
			var isBlack = F2(
				function (bits_, count) {
					return (1 & (bits_ >> count)) === 1;
				});
			var bits = $pablohirafuji$elm_qrcode$QRCode$Matrix$encodeVersionInfo(version);
			return A4(
				$pablohirafuji$elm_qrcode$QRCode$Matrix$setVersionInfo_,
				size,
				isBlack(bits),
				0,
				matrix);
		} else {
			return matrix;
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$timingColor = F2(
	function (row, col) {
		return (!A2($elm$core$Basics$modBy, 2, row + col)) ? $elm$core$Maybe$Just(
			_Utils_Tuple2(true, true)) : $elm$core$Maybe$Just(
			_Utils_Tuple2(true, false));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$setTiming = F3(
	function (size, row, col) {
		return A2(
			$elm$core$Array$set,
			A3($pablohirafuji$elm_qrcode$QRCode$Matrix$getIndex, size, row, col),
			A2($pablohirafuji$elm_qrcode$QRCode$Matrix$timingColor, row, col));
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$timingPattern = F2(
	function (size, matrix) {
		var range = A2($elm$core$List$range, 8, size - 9);
		return A3(
			$elm$core$List$foldl,
			function (b) {
				return A3($pablohirafuji$elm_qrcode$QRCode$Matrix$setTiming, size, b, 6);
			},
			A3(
				$elm$core$List$foldl,
				A2($pablohirafuji$elm_qrcode$QRCode$Matrix$setTiming, size, 6),
				matrix,
				range),
			range);
	});
var $pablohirafuji$elm_qrcode$QRCode$Matrix$apply = function (_v0) {
	var ecLevel = _v0.a.e8;
	var groupInfo = _v0.a.hp;
	var bytes = _v0.b;
	var version = groupInfo.eH;
	var size = ((version - 1) * 4) + 21;
	return A2(
		$elm$core$Result$map,
		A2($pablohirafuji$elm_qrcode$QRCode$Matrix$getBestMask, ecLevel, size),
		A2(
			$elm$core$Result$map,
			A2($pablohirafuji$elm_qrcode$QRCode$Matrix$addData, size, bytes),
			A3(
				$pablohirafuji$elm_qrcode$QRCode$Matrix$alignmentPattern,
				version,
				size,
				A2(
					$pablohirafuji$elm_qrcode$QRCode$Matrix$timingPattern,
					size,
					A3(
						$pablohirafuji$elm_qrcode$QRCode$Matrix$darkModule,
						version,
						size,
						A3(
							$pablohirafuji$elm_qrcode$QRCode$Matrix$setVersionInfo,
							version,
							size,
							A2(
								$pablohirafuji$elm_qrcode$QRCode$Matrix$reserveFormatInfo,
								size,
								A4(
									$pablohirafuji$elm_qrcode$QRCode$Matrix$finderPattern,
									size,
									-1,
									size - 8,
									A4(
										$pablohirafuji$elm_qrcode$QRCode$Matrix$finderPattern,
										size,
										size - 8,
										-1,
										A4(
											$pablohirafuji$elm_qrcode$QRCode$Matrix$finderPattern,
											size,
											-1,
											-1,
											A2(
												$elm$core$Array$initialize,
												size * size,
												$elm$core$Basics$always($elm$core$Maybe$Nothing))))))))))));
};
var $pablohirafuji$elm_qrcode$QRCode$ECLevel$H = 3;
var $pablohirafuji$elm_qrcode$QRCode$ECLevel$L = 0;
var $pablohirafuji$elm_qrcode$QRCode$ECLevel$M = 1;
var $pablohirafuji$elm_qrcode$QRCode$ECLevel$Q = 2;
var $pablohirafuji$elm_qrcode$QRCode$convertEC = function (ec) {
	switch (ec) {
		case 0:
			return 0;
		case 1:
			return 1;
		case 2:
			return 2;
		default:
			return 3;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$AlignmentPatternNotFound = {$: 0};
var $pablohirafuji$elm_qrcode$QRCode$InputLengthOverflow = {$: 7};
var $pablohirafuji$elm_qrcode$QRCode$InvalidAlphanumericChar = {$: 2};
var $pablohirafuji$elm_qrcode$QRCode$InvalidNumericChar = {$: 1};
var $pablohirafuji$elm_qrcode$QRCode$InvalidUTF8Char = {$: 3};
var $pablohirafuji$elm_qrcode$QRCode$LogTableException = function (a) {
	return {$: 4, a: a};
};
var $pablohirafuji$elm_qrcode$QRCode$PolynomialModException = {$: 6};
var $pablohirafuji$elm_qrcode$QRCode$PolynomialMultiplyException = {$: 5};
var $pablohirafuji$elm_qrcode$QRCode$convertError = function (e) {
	switch (e.$) {
		case 0:
			return $pablohirafuji$elm_qrcode$QRCode$AlignmentPatternNotFound;
		case 1:
			return $pablohirafuji$elm_qrcode$QRCode$InvalidNumericChar;
		case 2:
			return $pablohirafuji$elm_qrcode$QRCode$InvalidAlphanumericChar;
		case 3:
			return $pablohirafuji$elm_qrcode$QRCode$InvalidUTF8Char;
		case 4:
			var n = e.a;
			return $pablohirafuji$elm_qrcode$QRCode$LogTableException(n);
		case 5:
			return $pablohirafuji$elm_qrcode$QRCode$PolynomialMultiplyException;
		case 6:
			return $pablohirafuji$elm_qrcode$QRCode$PolynomialModException;
		default:
			return $pablohirafuji$elm_qrcode$QRCode$InputLengthOverflow;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$firstFillerByte = 236;
var $pablohirafuji$elm_qrcode$QRCode$Encode$secondFillerByte = 17;
var $pablohirafuji$elm_qrcode$QRCode$Encode$addFiller = F2(
	function (capacity, bytes) {
		var fillerLength = ((capacity / 8) | 0) - $elm$core$List$length(bytes);
		var ns = $elm$core$List$concat(
			A2(
				$elm$core$List$repeat,
				(fillerLength / 2) | 0,
				_List_fromArray(
					[$pablohirafuji$elm_qrcode$QRCode$Encode$firstFillerByte, $pablohirafuji$elm_qrcode$QRCode$Encode$secondFillerByte])));
		return (!A2($elm$core$Basics$modBy, 2, fillerLength)) ? _Utils_ap(bytes, ns) : _Utils_ap(
			bytes,
			_Utils_ap(
				ns,
				_List_fromArray(
					[$pablohirafuji$elm_qrcode$QRCode$Encode$firstFillerByte])));
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$addTerminator = F3(
	function (capacity, bitsCount, bits) {
		return _Utils_ap(
			bits,
			_List_fromArray(
				[
					_Utils_Tuple2(
					0,
					A2($elm$core$Basics$min, 4, capacity - bitsCount))
				]));
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes3 = function (_v0) {
	bitsToBytes3:
	while (true) {
		var _v1 = _v0.a;
		var bits = _v1.a;
		var length = _v1.b;
		var bytes = _v0.b;
		if (length >= 8) {
			var remLength = length - 8;
			var remBits = bits & ((1 << remLength) - 1);
			var _byte = bits >> remLength;
			var $temp$_v0 = _Utils_Tuple2(
				_Utils_Tuple2(remBits, remLength),
				A2($elm$core$List$cons, _byte, bytes));
			_v0 = $temp$_v0;
			continue bitsToBytes3;
		} else {
			return _Utils_Tuple2(
				_Utils_Tuple2(bits, length),
				bytes);
		}
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes2 = F2(
	function (_v0, _v1) {
		var curBits = _v0.a;
		var curLength = _v0.b;
		var _v2 = _v1.a;
		var remBits = _v2.a;
		var remLength = _v2.b;
		var bytes = _v1.b;
		var lengthSum = curLength + remLength;
		var bitsSum = curBits | (remBits << curLength);
		return $pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes3(
			_Utils_Tuple2(
				_Utils_Tuple2(bitsSum, lengthSum),
				bytes));
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes1 = F2(
	function (bits, _v0) {
		bitsToBytes1:
		while (true) {
			var _v1 = _v0.a;
			var remBits = _v1.a;
			var remLength = _v1.b;
			var bytes = _v0.b;
			if (bits.b) {
				var head = bits.a;
				var tail = bits.b;
				var $temp$bits = tail,
					$temp$_v0 = A2(
					$pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes2,
					head,
					_Utils_Tuple2(
						_Utils_Tuple2(remBits, remLength),
						bytes));
				bits = $temp$bits;
				_v0 = $temp$_v0;
				continue bitsToBytes1;
			} else {
				return (!remLength) ? $elm$core$List$reverse(bytes) : $elm$core$List$reverse(
					A2($elm$core$List$cons, remBits << (8 - remLength), bytes));
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes = function (bits) {
	return A2(
		$pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes1,
		bits,
		_Utils_Tuple2(
			_Utils_Tuple2(0, 0),
			_List_Nil));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$UTF8 = 3;
var $pablohirafuji$elm_qrcode$QRCode$Encode$charCountIndicatorLength = F2(
	function (mode, version) {
		if (version <= 9) {
			switch (mode) {
				case 0:
					return 10;
				case 1:
					return 9;
				case 2:
					return 8;
				default:
					return 8;
			}
		} else {
			if (version <= 26) {
				switch (mode) {
					case 0:
						return 12;
					case 1:
						return 11;
					case 2:
						return 16;
					default:
						return 16;
				}
			} else {
				switch (mode) {
					case 0:
						return 14;
					case 1:
						return 13;
					case 2:
						return 16;
					default:
						return 16;
				}
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$charCountIndicator = F2(
	function (_v0, bits) {
		var groupInfo = _v0.hp;
		var inputStr = _v0.dE;
		var mode = _v0.cC;
		var length = A2($pablohirafuji$elm_qrcode$QRCode$Encode$charCountIndicatorLength, mode, groupInfo.eH);
		var charCount = (mode === 3) ? $elm$core$List$length(bits) : $elm$core$String$length(inputStr);
		return _Utils_Tuple2(charCount, length);
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$modeIndicator = function (mode) {
	switch (mode) {
		case 0:
			return 1;
		case 1:
			return 2;
		case 2:
			return 4;
		default:
			return 4;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$addInfoAndFinalBits = function (_v0) {
	var bits = _v0.a;
	var model = _v0.b;
	return _Utils_Tuple2(
		model,
		A2(
			$pablohirafuji$elm_qrcode$QRCode$Encode$addFiller,
			model.hp.cs,
			$pablohirafuji$elm_qrcode$QRCode$Encode$bitsToBytes(
				A3(
					$pablohirafuji$elm_qrcode$QRCode$Encode$addTerminator,
					model.hp.cs,
					model.cR,
					A2(
						$elm$core$List$cons,
						_Utils_Tuple2(
							$pablohirafuji$elm_qrcode$QRCode$Encode$modeIndicator(model.cC),
							4),
						A2(
							$elm$core$List$cons,
							A2($pablohirafuji$elm_qrcode$QRCode$Encode$charCountIndicator, model, bits),
							bits))))));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$concatTranspose = function (_v0) {
	var model = _v0.a;
	var dataBlocks = _v0.b;
	var ecBlocks = _v0.c;
	return _Utils_Tuple2(
		model,
		$elm$core$List$concat(
			_Utils_ap(
				$pablohirafuji$elm_qrcode$QRCode$Helpers$transpose(dataBlocks),
				$pablohirafuji$elm_qrcode$QRCode$Helpers$transpose(ecBlocks))));
};
var $elm_community$list_extra$List$Extra$greedyGroupsOfWithStep = F3(
	function (size, step, xs) {
		var xs_ = A2($elm$core$List$drop, step, xs);
		var okayXs = $elm$core$List$length(xs) > 0;
		var okayArgs = (size > 0) && (step > 0);
		return (okayArgs && okayXs) ? A2(
			$elm$core$List$cons,
			A2($elm$core$List$take, size, xs),
			A3($elm_community$list_extra$List$Extra$greedyGroupsOfWithStep, size, step, xs_)) : _List_Nil;
	});
var $elm_community$list_extra$List$Extra$greedyGroupsOf = F2(
	function (size, xs) {
		return A3($elm_community$list_extra$List$Extra$greedyGroupsOfWithStep, size, size, xs);
	});
var $elm$core$Result$map2 = F3(
	function (func, ra, rb) {
		if (ra.$ === 1) {
			var x = ra.a;
			return $elm$core$Result$Err(x);
		} else {
			var a = ra.a;
			if (rb.$ === 1) {
				var x = rb.a;
				return $elm$core$Result$Err(x);
			} else {
				var b = rb.a;
				return $elm$core$Result$Ok(
					A2(func, a, b));
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Error$InvalidAlphanumericChar = {$: 2};
var $elm$core$Dict$fromList = function (assocs) {
	return A3(
		$elm$core$List$foldl,
		F2(
			function (_v0, dict) {
				var key = _v0.a;
				var value = _v0.b;
				return A3($elm$core$Dict$insert, key, value, dict);
			}),
		$elm$core$Dict$empty,
		assocs);
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$alphanumericCodes = $elm$core$Dict$fromList(
	_List_fromArray(
		[
			_Utils_Tuple2('0', 0),
			_Utils_Tuple2('1', 1),
			_Utils_Tuple2('2', 2),
			_Utils_Tuple2('3', 3),
			_Utils_Tuple2('4', 4),
			_Utils_Tuple2('5', 5),
			_Utils_Tuple2('6', 6),
			_Utils_Tuple2('7', 7),
			_Utils_Tuple2('8', 8),
			_Utils_Tuple2('9', 9),
			_Utils_Tuple2('A', 10),
			_Utils_Tuple2('B', 11),
			_Utils_Tuple2('C', 12),
			_Utils_Tuple2('D', 13),
			_Utils_Tuple2('E', 14),
			_Utils_Tuple2('F', 15),
			_Utils_Tuple2('G', 16),
			_Utils_Tuple2('H', 17),
			_Utils_Tuple2('I', 18),
			_Utils_Tuple2('J', 19),
			_Utils_Tuple2('K', 20),
			_Utils_Tuple2('L', 21),
			_Utils_Tuple2('M', 22),
			_Utils_Tuple2('N', 23),
			_Utils_Tuple2('O', 24),
			_Utils_Tuple2('P', 25),
			_Utils_Tuple2('Q', 26),
			_Utils_Tuple2('R', 27),
			_Utils_Tuple2('S', 28),
			_Utils_Tuple2('T', 29),
			_Utils_Tuple2('U', 30),
			_Utils_Tuple2('V', 31),
			_Utils_Tuple2('W', 32),
			_Utils_Tuple2('X', 33),
			_Utils_Tuple2('Y', 34),
			_Utils_Tuple2('Z', 35),
			_Utils_Tuple2(' ', 36),
			_Utils_Tuple2('$', 37),
			_Utils_Tuple2('%', 38),
			_Utils_Tuple2('*', 39),
			_Utils_Tuple2('+', 40),
			_Utils_Tuple2('-', 41),
			_Utils_Tuple2('.', 42),
			_Utils_Tuple2('/', 43),
			_Utils_Tuple2(':', 44)
		]));
var $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$toAlphanumericCode = function (_char) {
	return A2(
		$elm$core$Result$fromMaybe,
		$pablohirafuji$elm_qrcode$QRCode$Error$InvalidAlphanumericChar,
		A2($elm$core$Dict$get, _char, $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$alphanumericCodes));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$toBinary = function (chars) {
	_v0$2:
	while (true) {
		if (chars.b) {
			if (chars.b.b) {
				if (!chars.b.b.b) {
					var firstChar = chars.a;
					var _v1 = chars.b;
					var secondChar = _v1.a;
					return A3(
						$elm$core$Result$map2,
						F2(
							function (firstCode, secondCode) {
								return _Utils_Tuple2((firstCode * 45) + secondCode, 11);
							}),
						$pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$toAlphanumericCode(firstChar),
						$pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$toAlphanumericCode(secondChar));
				} else {
					break _v0$2;
				}
			} else {
				var _char = chars.a;
				return A2(
					$elm$core$Result$map,
					function (a) {
						return _Utils_Tuple2(a, 6);
					},
					$pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$toAlphanumericCode(_char));
			}
		} else {
			break _v0$2;
		}
	}
	return $elm$core$Result$Err($pablohirafuji$elm_qrcode$QRCode$Error$InvalidAlphanumericChar);
};
var $elm$core$String$foldr = _String_foldr;
var $elm$core$String$toList = function (string) {
	return A3($elm$core$String$foldr, $elm$core$List$cons, _List_Nil, string);
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$encode = function (str) {
	return A3(
		$elm$core$List$foldr,
		$elm$core$Result$map2($elm$core$List$cons),
		$elm$core$Result$Ok(_List_Nil),
		A2(
			$elm$core$List$map,
			$pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$toBinary,
			A2(
				$elm_community$list_extra$List$Extra$greedyGroupsOf,
				2,
				$elm$core$String$toList(str))));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Byte$encode = function (str) {
	return $elm$core$Result$Ok(
		A2(
			$elm$core$List$map,
			function (a) {
				return _Utils_Tuple2(
					$elm$core$Char$toCode(a),
					8);
			},
			$elm$core$String$toList(str)));
};
var $pablohirafuji$elm_qrcode$QRCode$Error$InvalidNumericChar = {$: 1};
var $elm$core$String$fromList = _String_fromList;
var $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$numericLength = function (str) {
	var _v0 = $elm$core$String$length(str);
	switch (_v0) {
		case 1:
			return 4;
		case 2:
			return 7;
		default:
			return 10;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$encodeHelp = function (chars) {
	var str = $elm$core$String$fromList(chars);
	return A2(
		$elm$core$Result$fromMaybe,
		$pablohirafuji$elm_qrcode$QRCode$Error$InvalidNumericChar,
		A2(
			$elm$core$Maybe$map,
			function (a) {
				return _Utils_Tuple2(
					a,
					$pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$numericLength(str));
			},
			$elm$core$String$toInt(str)));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$encode = function (str) {
	return A3(
		$elm$core$List$foldr,
		$elm$core$Result$map2($elm$core$List$cons),
		$elm$core$Result$Ok(_List_Nil),
		A2(
			$elm$core$List$map,
			$pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$encodeHelp,
			A2(
				$elm_community$list_extra$List$Extra$greedyGroupsOf,
				3,
				$elm$core$String$toList(str))));
};
var $pablohirafuji$elm_qrcode$QRCode$Error$InvalidUTF8Char = {$: 3};
var $elm$bytes$Bytes$Encode$getWidth = function (builder) {
	switch (builder.$) {
		case 0:
			return 1;
		case 1:
			return 2;
		case 2:
			return 4;
		case 3:
			return 1;
		case 4:
			return 2;
		case 5:
			return 4;
		case 6:
			return 4;
		case 7:
			return 8;
		case 8:
			var w = builder.a;
			return w;
		case 9:
			var w = builder.a;
			return w;
		default:
			var bs = builder.a;
			return _Bytes_width(bs);
	}
};
var $elm$bytes$Bytes$LE = 0;
var $elm$bytes$Bytes$Encode$write = F3(
	function (builder, mb, offset) {
		switch (builder.$) {
			case 0:
				var n = builder.a;
				return A3(_Bytes_write_i8, mb, offset, n);
			case 1:
				var e = builder.a;
				var n = builder.b;
				return A4(_Bytes_write_i16, mb, offset, n, !e);
			case 2:
				var e = builder.a;
				var n = builder.b;
				return A4(_Bytes_write_i32, mb, offset, n, !e);
			case 3:
				var n = builder.a;
				return A3(_Bytes_write_u8, mb, offset, n);
			case 4:
				var e = builder.a;
				var n = builder.b;
				return A4(_Bytes_write_u16, mb, offset, n, !e);
			case 5:
				var e = builder.a;
				var n = builder.b;
				return A4(_Bytes_write_u32, mb, offset, n, !e);
			case 6:
				var e = builder.a;
				var n = builder.b;
				return A4(_Bytes_write_f32, mb, offset, n, !e);
			case 7:
				var e = builder.a;
				var n = builder.b;
				return A4(_Bytes_write_f64, mb, offset, n, !e);
			case 8:
				var bs = builder.b;
				return A3($elm$bytes$Bytes$Encode$writeSequence, bs, mb, offset);
			case 9:
				var s = builder.b;
				return A3(_Bytes_write_string, mb, offset, s);
			default:
				var bs = builder.a;
				return A3(_Bytes_write_bytes, mb, offset, bs);
		}
	});
var $elm$bytes$Bytes$Encode$writeSequence = F3(
	function (builders, mb, offset) {
		writeSequence:
		while (true) {
			if (!builders.b) {
				return offset;
			} else {
				var b = builders.a;
				var bs = builders.b;
				var $temp$builders = bs,
					$temp$mb = mb,
					$temp$offset = A3($elm$bytes$Bytes$Encode$write, b, mb, offset);
				builders = $temp$builders;
				mb = $temp$mb;
				offset = $temp$offset;
				continue writeSequence;
			}
		}
	});
var $elm$bytes$Bytes$Decode$decode = F2(
	function (_v0, bs) {
		var decoder = _v0;
		return A2(_Bytes_decode, decoder, bs);
	});
var $elm$bytes$Bytes$Encode$encode = _Bytes_encode;
var $elm$bytes$Bytes$Encode$getStringWidth = _Bytes_getStringWidth;
var $elm$bytes$Bytes$Decode$Decoder = $elm$core$Basics$identity;
var $elm$bytes$Bytes$Decode$loopHelp = F4(
	function (state, callback, bites, offset) {
		loopHelp:
		while (true) {
			var _v0 = callback(state);
			var decoder = _v0;
			var _v1 = A2(decoder, bites, offset);
			var newOffset = _v1.a;
			var step = _v1.b;
			if (!step.$) {
				var newState = step.a;
				var $temp$state = newState,
					$temp$callback = callback,
					$temp$bites = bites,
					$temp$offset = newOffset;
				state = $temp$state;
				callback = $temp$callback;
				bites = $temp$bites;
				offset = $temp$offset;
				continue loopHelp;
			} else {
				var result = step.a;
				return _Utils_Tuple2(newOffset, result);
			}
		}
	});
var $elm$bytes$Bytes$Decode$loop = F2(
	function (state, callback) {
		return A2($elm$bytes$Bytes$Decode$loopHelp, state, callback);
	});
var $elm$bytes$Bytes$Decode$Done = function (a) {
	return {$: 1, a: a};
};
var $elm$bytes$Bytes$Decode$Loop = function (a) {
	return {$: 0, a: a};
};
var $elm$bytes$Bytes$Decode$map = F2(
	function (func, _v0) {
		var decodeA = _v0;
		return F2(
			function (bites, offset) {
				var _v1 = A2(decodeA, bites, offset);
				var aOffset = _v1.a;
				var a = _v1.b;
				return _Utils_Tuple2(
					aOffset,
					func(a));
			});
	});
var $elm$bytes$Bytes$Decode$succeed = function (a) {
	return F2(
		function (_v0, offset) {
			return _Utils_Tuple2(offset, a);
		});
};
var $elm$bytes$Bytes$Decode$unsignedInt8 = _Bytes_read_u8;
var $pablohirafuji$elm_qrcode$QRCode$Encode$UTF8$step = function (_v0) {
	var n = _v0.a;
	var xs = _v0.b;
	return (n <= 0) ? $elm$bytes$Bytes$Decode$succeed(
		$elm$bytes$Bytes$Decode$Done(
			$elm$core$List$reverse(xs))) : A2(
		$elm$bytes$Bytes$Decode$map,
		function (x) {
			return $elm$bytes$Bytes$Decode$Loop(
				_Utils_Tuple2(
					n - 1,
					A2(
						$elm$core$List$cons,
						_Utils_Tuple2(x, 8),
						xs)));
		},
		$elm$bytes$Bytes$Decode$unsignedInt8);
};
var $elm$bytes$Bytes$Encode$Utf8 = F2(
	function (a, b) {
		return {$: 9, a: a, b: b};
	});
var $elm$bytes$Bytes$Encode$string = function (str) {
	return A2(
		$elm$bytes$Bytes$Encode$Utf8,
		_Bytes_getStringWidth(str),
		str);
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$UTF8$encode = function (str) {
	var utf8BytesWidth = $elm$bytes$Bytes$Encode$getStringWidth(str);
	var decoder = A2(
		$elm$bytes$Bytes$Decode$loop,
		_Utils_Tuple2(utf8BytesWidth, _List_Nil),
		$pablohirafuji$elm_qrcode$QRCode$Encode$UTF8$step);
	return A2(
		$elm$core$Result$fromMaybe,
		$pablohirafuji$elm_qrcode$QRCode$Error$InvalidUTF8Char,
		A2(
			$elm$bytes$Bytes$Decode$decode,
			decoder,
			$elm$bytes$Bytes$Encode$encode(
				$elm$bytes$Bytes$Encode$string(str))));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$encoder = function (mode) {
	switch (mode) {
		case 0:
			return $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$encode;
		case 1:
			return $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$encode;
		case 2:
			return $pablohirafuji$elm_qrcode$QRCode$Encode$Byte$encode;
		default:
			return $pablohirafuji$elm_qrcode$QRCode$Encode$UTF8$encode;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$expTable = $elm$core$Array$fromList(
	_List_fromArray(
		[1, 2, 4, 8, 16, 32, 64, 128, 29, 58, 116, 232, 205, 135, 19, 38, 76, 152, 45, 90, 180, 117, 234, 201, 143, 3, 6, 12, 24, 48, 96, 192, 157, 39, 78, 156, 37, 74, 148, 53, 106, 212, 181, 119, 238, 193, 159, 35, 70, 140, 5, 10, 20, 40, 80, 160, 93, 186, 105, 210, 185, 111, 222, 161, 95, 190, 97, 194, 153, 47, 94, 188, 101, 202, 137, 15, 30, 60, 120, 240, 253, 231, 211, 187, 107, 214, 177, 127, 254, 225, 223, 163, 91, 182, 113, 226, 217, 175, 67, 134, 17, 34, 68, 136, 13, 26, 52, 104, 208, 189, 103, 206, 129, 31, 62, 124, 248, 237, 199, 147, 59, 118, 236, 197, 151, 51, 102, 204, 133, 23, 46, 92, 184, 109, 218, 169, 79, 158, 33, 66, 132, 21, 42, 84, 168, 77, 154, 41, 82, 164, 85, 170, 73, 146, 57, 114, 228, 213, 183, 115, 230, 209, 191, 99, 198, 145, 63, 126, 252, 229, 215, 179, 123, 246, 241, 255, 227, 219, 171, 75, 150, 49, 98, 196, 149, 55, 110, 220, 165, 87, 174, 65, 130, 25, 50, 100, 200, 141, 7, 14, 28, 56, 112, 224, 221, 167, 83, 166, 81, 162, 89, 178, 121, 242, 249, 239, 195, 155, 43, 86, 172, 69, 138, 9, 18, 36, 72, 144, 61, 122, 244, 245, 247, 243, 251, 235, 203, 139, 11, 22, 44, 88, 176, 125, 250, 233, 207, 131, 27, 54, 108, 216, 173, 71, 142, 1]));
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getExp = function (index) {
	return A2(
		$elm$core$Maybe$withDefault,
		0,
		A2(
			$elm$core$Array$get,
			A2($elm$core$Basics$modBy, 255, index),
			$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$expTable));
};
var $pablohirafuji$elm_qrcode$QRCode$Error$PolynomialMultiplyException = {$: 5};
var $pablohirafuji$elm_qrcode$QRCode$Error$LogTableException = function (a) {
	return {$: 4, a: a};
};
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$logTable = $elm$core$Array$fromList(
	_List_fromArray(
		[0, 1, 25, 2, 50, 26, 198, 3, 223, 51, 238, 27, 104, 199, 75, 4, 100, 224, 14, 52, 141, 239, 129, 28, 193, 105, 248, 200, 8, 76, 113, 5, 138, 101, 47, 225, 36, 15, 33, 53, 147, 142, 218, 240, 18, 130, 69, 29, 181, 194, 125, 106, 39, 249, 185, 201, 154, 9, 120, 77, 228, 114, 166, 6, 191, 139, 98, 102, 221, 48, 253, 226, 152, 37, 179, 16, 145, 34, 136, 54, 208, 148, 206, 143, 150, 219, 189, 241, 210, 19, 92, 131, 56, 70, 64, 30, 66, 182, 163, 195, 72, 126, 110, 107, 58, 40, 84, 250, 133, 186, 61, 202, 94, 155, 159, 10, 21, 121, 43, 78, 212, 229, 172, 115, 243, 167, 87, 7, 112, 192, 247, 140, 128, 99, 13, 103, 74, 222, 237, 49, 197, 254, 24, 227, 165, 153, 119, 38, 184, 180, 124, 17, 68, 146, 217, 35, 32, 137, 46, 55, 63, 209, 91, 149, 188, 207, 205, 144, 135, 151, 178, 220, 252, 190, 97, 242, 86, 211, 171, 20, 42, 93, 158, 132, 60, 57, 83, 71, 109, 65, 162, 31, 45, 67, 216, 183, 123, 164, 118, 196, 23, 73, 236, 127, 12, 111, 246, 108, 161, 59, 82, 41, 157, 85, 170, 251, 96, 134, 177, 187, 204, 62, 90, 203, 89, 95, 176, 156, 169, 160, 81, 11, 245, 22, 235, 122, 117, 44, 215, 79, 174, 213, 233, 230, 231, 173, 232, 116, 214, 244, 234, 168, 80, 88, 175]));
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getLog = function (index) {
	return (index < 1) ? $elm$core$Result$Err(
		$pablohirafuji$elm_qrcode$QRCode$Error$LogTableException(index)) : A2(
		$elm$core$Result$fromMaybe,
		$pablohirafuji$elm_qrcode$QRCode$Error$LogTableException(index),
		A2($elm$core$Array$get, index - 1, $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$logTable));
};
var $elm$core$Array$length = function (_v0) {
	var len = _v0.a;
	return len;
};
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getOffset = function (_v0) {
	getOffset:
	while (true) {
		var num = _v0.a;
		var offset = _v0.b;
		if (num.b) {
			var head = num.a;
			var tail = num.b;
			if (!head) {
				var $temp$_v0 = _Utils_Tuple2(tail, offset + 1);
				_v0 = $temp$_v0;
				continue getOffset;
			} else {
				return offset;
			}
		} else {
			return offset;
		}
	}
};
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$newPolynomial = F2(
	function (num, shift) {
		var offset = $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getOffset(
			_Utils_Tuple2(num, 0));
		var numArray = $elm$core$Array$fromList(num);
		return A2(
			$elm$core$Array$initialize,
			($elm$core$List$length(num) - offset) + shift,
			function (index) {
				return A2(
					$elm$core$Maybe$withDefault,
					0,
					A2($elm$core$Array$get, index + offset, numArray));
			});
	});
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$multiply = F2(
	function (poly1, poly2) {
		var valuesArray = A2(
			$elm$core$List$indexedMap,
			F2(
				function (index1, value1) {
					return A2(
						$elm$core$List$indexedMap,
						F2(
							function (index2, value2) {
								return _Utils_Tuple3(index1 + index2, value1, value2);
							}),
						$elm$core$Array$toList(poly2));
				}),
			$elm$core$Array$toList(poly1));
		var process__ = F3(
			function (indexSum, num_, exp) {
				return A2(
					$elm$core$Result$fromMaybe,
					$pablohirafuji$elm_qrcode$QRCode$Error$PolynomialMultiplyException,
					A2(
						$elm$core$Maybe$map,
						$elm$core$Bitwise$xor(exp),
						A2($elm$core$Array$get, indexSum, num_)));
			});
		var process_ = F2(
			function (_v0, num_) {
				var indexSum = _v0.a;
				var value1 = _v0.b;
				var value2 = _v0.c;
				return A2(
					$elm$core$Result$map,
					function (r) {
						return A3($elm$core$Array$set, indexSum, r, num_);
					},
					A2(
						$elm$core$Result$andThen,
						A2(process__, indexSum, num_),
						A2(
							$elm$core$Result$map,
							$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getExp,
							A3(
								$elm$core$Result$map2,
								$elm$core$Basics$add,
								$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getLog(value1),
								$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getLog(value2)))));
			});
		var process = F2(
			function (args, numResult) {
				return A2(
					$elm$core$Result$andThen,
					process_(args),
					numResult);
			});
		var num = A2(
			$elm$core$Array$initialize,
			($elm$core$Array$length(poly1) + $elm$core$Array$length(poly2)) - 1,
			$elm$core$Basics$always(0));
		return A2(
			$elm$core$Result$map,
			function (a) {
				return A2($pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$newPolynomial, a, 0);
			},
			A2(
				$elm$core$Result$map,
				$elm$core$Array$toList,
				A3(
					$elm$core$List$foldl,
					process,
					$elm$core$Result$Ok(num),
					$elm$core$List$concat(valuesArray))));
	});
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getECPolynomial = function (ecLength) {
	var generate = F2(
		function (count, polyResult) {
			generate:
			while (true) {
				if (_Utils_cmp(count, ecLength) < 0) {
					var $temp$count = count + 1,
						$temp$polyResult = A2(
						$elm$core$Result$andThen,
						function (a) {
							return A2(
								$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$multiply,
								a,
								A2(
									$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$newPolynomial,
									_List_fromArray(
										[
											1,
											$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getExp(count)
										]),
									0));
						},
						polyResult);
					count = $temp$count;
					polyResult = $temp$polyResult;
					continue generate;
				} else {
					return polyResult;
				}
			}
		});
	return A2(
		generate,
		0,
		$elm$core$Result$Ok(
			A2(
				$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$newPolynomial,
				_List_fromArray(
					[1]),
				0)));
};
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get___ = F2(
	function (ecLength, modPoly) {
		return $elm$core$Array$toList(
			A2(
				$elm$core$Array$initialize,
				ecLength,
				function (index) {
					var modIndex = (index + $elm$core$Array$length(modPoly)) - ecLength;
					return (modIndex >= 0) ? A2(
						$elm$core$Maybe$withDefault,
						0,
						A2($elm$core$Array$get, modIndex, modPoly)) : 0;
				}));
	});
var $pablohirafuji$elm_qrcode$QRCode$Error$PolynomialModException = {$: 6};
var $elm$core$Array$foldl = F3(
	function (func, baseCase, _v0) {
		var tree = _v0.c;
		var tail = _v0.d;
		var helper = F2(
			function (node, acc) {
				if (!node.$) {
					var subTree = node.a;
					return A3($elm$core$Elm$JsArray$foldl, helper, acc, subTree);
				} else {
					var values = node.a;
					return A3($elm$core$Elm$JsArray$foldl, func, acc, values);
				}
			});
		return A3(
			$elm$core$Elm$JsArray$foldl,
			func,
			A3($elm$core$Elm$JsArray$foldl, helper, baseCase, tree),
			tail);
	});
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$mod = F2(
	function (poly1, poly2) {
		if (($elm$core$Array$length(poly1) - $elm$core$Array$length(poly2)) < 0) {
			return $elm$core$Result$Ok(poly1);
		} else {
			var helper_ = F3(
				function (index2, poly1_, exp) {
					return A2(
						$elm$core$Result$fromMaybe,
						$pablohirafuji$elm_qrcode$QRCode$Error$PolynomialModException,
						A2(
							$elm$core$Maybe$map,
							$elm$core$Bitwise$xor(exp),
							A2($elm$core$Array$get, index2, poly1_)));
				});
			var getHead = function (poly) {
				return A2(
					$elm$core$Result$andThen,
					$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getLog,
					A2(
						$elm$core$Result$fromMaybe,
						$pablohirafuji$elm_qrcode$QRCode$Error$PolynomialModException,
						A2($elm$core$Array$get, 0, poly)));
			};
			var ratio = A3(
				$elm$core$Result$map2,
				$elm$core$Basics$sub,
				getHead(poly1),
				getHead(poly2));
			var helper = F2(
				function (_v0, poly1_) {
					var index2 = _v0.a;
					var value2 = _v0.b;
					return A2(
						$elm$core$Result$map,
						function (r) {
							return A3($elm$core$Array$set, index2, r, poly1_);
						},
						A2(
							$elm$core$Result$andThen,
							A2(helper_, index2, poly1_),
							A2(
								$elm$core$Result$map,
								$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getExp,
								A3(
									$elm$core$Result$map2,
									$elm$core$Basics$add,
									ratio,
									$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getLog(value2)))));
				});
			var numFold = F2(
				function (args, poly1Result) {
					return A2(
						$elm$core$Result$andThen,
						helper(args),
						poly1Result);
				});
			var numResult = A3(
				$elm$core$Array$foldl,
				numFold,
				$elm$core$Result$Ok(poly1),
				A2(
					$elm$core$Array$indexedMap,
					F2(
						function (a, b) {
							return _Utils_Tuple2(a, b);
						}),
					poly2));
			return A2(
				$elm$core$Result$andThen,
				function (a) {
					return A2($pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$mod, a, poly2);
				},
				A2(
					$elm$core$Result$map,
					function (a) {
						return A2($pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$newPolynomial, a, 0);
					},
					A2($elm$core$Result$map, $elm$core$Array$toList, numResult)));
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get__ = F2(
	function (rsPoly, dataCodewords) {
		return A2(
			$elm$core$Result$map,
			$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get___(
				$elm$core$Array$length(rsPoly) - 1),
			A2(
				$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$mod,
				A2(
					$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$newPolynomial,
					dataCodewords,
					$elm$core$Array$length(rsPoly) - 1),
				rsPoly));
	});
var $pablohirafuji$elm_qrcode$QRCode$Helpers$listResult = F3(
	function (fun, listb, lista) {
		if (lista.b) {
			var head = lista.a;
			var tail = lista.b;
			return A2(
				$elm$core$Result$andThen,
				function (a) {
					return A3($pablohirafuji$elm_qrcode$QRCode$Helpers$listResult, fun, a, tail);
				},
				A2(
					$elm$core$Result$map,
					function (r) {
						return A2($elm$core$List$cons, r, listb);
					},
					fun(head)));
		} else {
			return $elm$core$Result$Ok(
				$elm$core$List$reverse(listb));
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get_ = F2(
	function (byteBlocks, rsPoly) {
		return A3(
			$pablohirafuji$elm_qrcode$QRCode$Helpers$listResult,
			$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get__(rsPoly),
			_List_Nil,
			byteBlocks);
	});
var $pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get = F2(
	function (ecPerBlock, byteBlocks) {
		return A2(
			$elm$core$Result$andThen,
			$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get_(byteBlocks),
			$pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$getECPolynomial(ecPerBlock));
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$getErrorCorrection = function (_v0) {
	var model = _v0.a;
	var dataBlocks = _v0.b;
	return A2(
		$elm$core$Result$map,
		function (c) {
			return _Utils_Tuple3(model, dataBlocks, c);
		},
		A2($pablohirafuji$elm_qrcode$QRCode$ErrorCorrection$get, model.hp.hd, dataBlocks));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric = 1;
var $pablohirafuji$elm_qrcode$QRCode$Encode$Byte = 2;
var $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric = 0;
var $elm$regex$Regex$Match = F4(
	function (match, index, number, submatches) {
		return {hu: index, hI: match, hZ: number, iy: submatches};
	});
var $elm$regex$Regex$contains = _Regex_contains;
var $elm$regex$Regex$fromStringWith = _Regex_fromStringWith;
var $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$onlyAlphanumeric = A2(
	$elm$regex$Regex$fromStringWith,
	{g_: false, hN: false},
	'^[0-9A-Z $%*+\\-.\\/:]+$');
var $pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$isValid = function (input) {
	return A2(
		$elm$core$Maybe$withDefault,
		false,
		A2(
			$elm$core$Maybe$map,
			function (r) {
				return A2($elm$regex$Regex$contains, r, input);
			},
			$pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$onlyAlphanumeric));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Byte$only8Bit = A2(
	$elm$regex$Regex$fromStringWith,
	{g_: false, hN: false},
	'^[\\u0000-\\u00ff]+$');
var $pablohirafuji$elm_qrcode$QRCode$Encode$Byte$isValid = function (input) {
	return A2(
		$elm$core$Maybe$withDefault,
		false,
		A2(
			$elm$core$Maybe$map,
			function (r) {
				return A2($elm$regex$Regex$contains, r, input);
			},
			$pablohirafuji$elm_qrcode$QRCode$Encode$Byte$only8Bit));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$onlyNumber = A2(
	$elm$regex$Regex$fromStringWith,
	{g_: false, hN: false},
	'^[0-9]+$');
var $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$isValid = function (input) {
	return A2(
		$elm$core$Maybe$withDefault,
		false,
		A2(
			$elm$core$Maybe$map,
			function (r) {
				return A2($elm$regex$Regex$contains, r, input);
			},
			$pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$onlyNumber));
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$selectMode = function (input) {
	return $pablohirafuji$elm_qrcode$QRCode$Encode$Numeric$isValid(input) ? 0 : ($pablohirafuji$elm_qrcode$QRCode$Encode$Alphanumeric$isValid(input) ? 1 : ($pablohirafuji$elm_qrcode$QRCode$Encode$Byte$isValid(input) ? 2 : 3));
};
var $pablohirafuji$elm_qrcode$QRCode$Error$InputLengthOverflow = {$: 7};
var $pablohirafuji$elm_qrcode$QRCode$Encode$filterCapacity = F3(
	function (mode, dataLength, _v0) {
		var version = _v0.eH;
		var capacity = _v0.cs;
		return _Utils_cmp(
			A2($pablohirafuji$elm_qrcode$QRCode$Encode$charCountIndicatorLength, mode, version) + dataLength,
			capacity) < 1;
	});
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$blockByteCapacity = function (_v0) {
	var blockCount = _v0.a;
	var bytePerBlock = _v0.b;
	return blockCount * bytePerBlock;
};
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$byteCapacity = F2(
	function (group1, maybeGroup2) {
		if (!maybeGroup2.$) {
			var block2 = maybeGroup2.a;
			return $pablohirafuji$elm_qrcode$QRCode$GroupInfo$blockByteCapacity(group1) + $pablohirafuji$elm_qrcode$QRCode$GroupInfo$blockByteCapacity(block2);
		} else {
			return $pablohirafuji$elm_qrcode$QRCode$GroupInfo$blockByteCapacity(group1);
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo = F4(
	function (version, ecPerBlock, group1, maybeGroup2) {
		return {
			cs: A2($pablohirafuji$elm_qrcode$QRCode$GroupInfo$byteCapacity, group1, maybeGroup2) * 8,
			hd: ecPerBlock,
			fj: group1,
			hJ: maybeGroup2,
			eH: version
		};
	});
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataH = _List_fromArray(
	[
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		1,
		17,
		_Utils_Tuple2(1, 9),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		2,
		28,
		_Utils_Tuple2(1, 16),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		3,
		22,
		_Utils_Tuple2(2, 13),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		4,
		16,
		_Utils_Tuple2(4, 9),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		5,
		22,
		_Utils_Tuple2(2, 11),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 12))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		6,
		28,
		_Utils_Tuple2(4, 15),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		7,
		26,
		_Utils_Tuple2(4, 13),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 14))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		8,
		26,
		_Utils_Tuple2(4, 14),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 15))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		9,
		24,
		_Utils_Tuple2(4, 12),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 13))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		10,
		28,
		_Utils_Tuple2(6, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		11,
		24,
		_Utils_Tuple2(3, 12),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(8, 13))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		12,
		28,
		_Utils_Tuple2(7, 14),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 15))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		13,
		22,
		_Utils_Tuple2(12, 11),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 12))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		14,
		24,
		_Utils_Tuple2(11, 12),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 13))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		15,
		24,
		_Utils_Tuple2(11, 12),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 13))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		16,
		30,
		_Utils_Tuple2(3, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(13, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		17,
		28,
		_Utils_Tuple2(2, 14),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(17, 15))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		18,
		28,
		_Utils_Tuple2(2, 14),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(19, 15))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		19,
		26,
		_Utils_Tuple2(9, 13),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(16, 14))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		20,
		28,
		_Utils_Tuple2(15, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(10, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		21,
		30,
		_Utils_Tuple2(19, 16),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(6, 17))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		22,
		24,
		_Utils_Tuple2(34, 13),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		23,
		30,
		_Utils_Tuple2(16, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		24,
		30,
		_Utils_Tuple2(30, 16),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 17))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		25,
		30,
		_Utils_Tuple2(22, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(13, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		26,
		30,
		_Utils_Tuple2(33, 16),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 17))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		27,
		30,
		_Utils_Tuple2(12, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(28, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		28,
		30,
		_Utils_Tuple2(11, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(31, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		29,
		30,
		_Utils_Tuple2(19, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(26, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		30,
		30,
		_Utils_Tuple2(23, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(25, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		31,
		30,
		_Utils_Tuple2(23, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(28, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		32,
		30,
		_Utils_Tuple2(19, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(35, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		33,
		30,
		_Utils_Tuple2(11, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(46, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		34,
		30,
		_Utils_Tuple2(59, 16),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 17))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		35,
		30,
		_Utils_Tuple2(22, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(41, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		36,
		30,
		_Utils_Tuple2(2, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(64, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		37,
		30,
		_Utils_Tuple2(24, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(46, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		38,
		30,
		_Utils_Tuple2(42, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(32, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		39,
		30,
		_Utils_Tuple2(10, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(67, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		40,
		30,
		_Utils_Tuple2(20, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(61, 16)))
	]);
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataL = _List_fromArray(
	[
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		1,
		7,
		_Utils_Tuple2(1, 19),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		2,
		10,
		_Utils_Tuple2(1, 34),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		3,
		15,
		_Utils_Tuple2(1, 55),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		4,
		20,
		_Utils_Tuple2(1, 80),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		5,
		26,
		_Utils_Tuple2(1, 108),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		6,
		18,
		_Utils_Tuple2(2, 68),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		7,
		20,
		_Utils_Tuple2(2, 78),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		8,
		24,
		_Utils_Tuple2(2, 97),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		9,
		30,
		_Utils_Tuple2(2, 116),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		10,
		18,
		_Utils_Tuple2(2, 68),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 69))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		11,
		20,
		_Utils_Tuple2(4, 81),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		12,
		24,
		_Utils_Tuple2(2, 92),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 93))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		13,
		26,
		_Utils_Tuple2(4, 107),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		14,
		30,
		_Utils_Tuple2(3, 115),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 116))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		15,
		22,
		_Utils_Tuple2(5, 87),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 88))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		16,
		24,
		_Utils_Tuple2(5, 98),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 99))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		17,
		28,
		_Utils_Tuple2(1, 107),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 108))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		18,
		30,
		_Utils_Tuple2(5, 120),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 121))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		19,
		28,
		_Utils_Tuple2(3, 113),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 114))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		20,
		28,
		_Utils_Tuple2(3, 107),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 108))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		21,
		28,
		_Utils_Tuple2(4, 116),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 117))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		22,
		28,
		_Utils_Tuple2(2, 111),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 112))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		23,
		30,
		_Utils_Tuple2(4, 121),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 122))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		24,
		30,
		_Utils_Tuple2(6, 117),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 118))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		25,
		26,
		_Utils_Tuple2(8, 106),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 107))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		26,
		28,
		_Utils_Tuple2(10, 114),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 115))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		27,
		30,
		_Utils_Tuple2(8, 122),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 123))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		28,
		30,
		_Utils_Tuple2(3, 117),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(10, 118))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		29,
		30,
		_Utils_Tuple2(7, 116),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 117))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		30,
		30,
		_Utils_Tuple2(5, 115),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(10, 116))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		31,
		30,
		_Utils_Tuple2(13, 115),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(3, 116))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		32,
		30,
		_Utils_Tuple2(17, 115),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		33,
		30,
		_Utils_Tuple2(17, 115),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 116))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		34,
		30,
		_Utils_Tuple2(13, 115),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(6, 116))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		35,
		30,
		_Utils_Tuple2(12, 121),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 122))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		36,
		30,
		_Utils_Tuple2(6, 121),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 122))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		37,
		30,
		_Utils_Tuple2(17, 122),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 123))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		38,
		30,
		_Utils_Tuple2(4, 122),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(18, 123))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		39,
		30,
		_Utils_Tuple2(20, 117),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 118))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		40,
		30,
		_Utils_Tuple2(19, 118),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(6, 119)))
	]);
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataM = _List_fromArray(
	[
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		1,
		10,
		_Utils_Tuple2(1, 16),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		2,
		16,
		_Utils_Tuple2(1, 28),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		3,
		26,
		_Utils_Tuple2(1, 44),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		4,
		18,
		_Utils_Tuple2(2, 32),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		5,
		24,
		_Utils_Tuple2(2, 43),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		6,
		16,
		_Utils_Tuple2(4, 27),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		7,
		18,
		_Utils_Tuple2(4, 31),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		8,
		22,
		_Utils_Tuple2(2, 38),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 39))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		9,
		22,
		_Utils_Tuple2(3, 36),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 37))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		10,
		26,
		_Utils_Tuple2(4, 43),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 44))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		11,
		30,
		_Utils_Tuple2(1, 50),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 51))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		12,
		22,
		_Utils_Tuple2(6, 36),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 37))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		13,
		22,
		_Utils_Tuple2(8, 37),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 38))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		14,
		24,
		_Utils_Tuple2(4, 40),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 41))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		15,
		24,
		_Utils_Tuple2(5, 41),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 42))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		16,
		28,
		_Utils_Tuple2(7, 45),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(3, 46))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		17,
		28,
		_Utils_Tuple2(10, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		18,
		26,
		_Utils_Tuple2(9, 43),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 44))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		19,
		26,
		_Utils_Tuple2(3, 44),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(11, 45))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		20,
		26,
		_Utils_Tuple2(3, 41),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(13, 42))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		21,
		26,
		_Utils_Tuple2(17, 42),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		22,
		28,
		_Utils_Tuple2(17, 46),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		23,
		28,
		_Utils_Tuple2(4, 47),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 48))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		24,
		28,
		_Utils_Tuple2(6, 45),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 46))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		25,
		28,
		_Utils_Tuple2(8, 47),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(13, 48))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		26,
		28,
		_Utils_Tuple2(19, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		27,
		28,
		_Utils_Tuple2(22, 45),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(3, 46))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		28,
		28,
		_Utils_Tuple2(3, 45),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(23, 46))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		29,
		28,
		_Utils_Tuple2(21, 45),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 46))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		30,
		28,
		_Utils_Tuple2(19, 47),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(10, 48))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		31,
		28,
		_Utils_Tuple2(2, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(29, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		32,
		28,
		_Utils_Tuple2(10, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(23, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		33,
		28,
		_Utils_Tuple2(14, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(21, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		34,
		28,
		_Utils_Tuple2(14, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(23, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		35,
		28,
		_Utils_Tuple2(12, 47),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(26, 48))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		36,
		28,
		_Utils_Tuple2(6, 47),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(34, 48))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		37,
		28,
		_Utils_Tuple2(29, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		38,
		28,
		_Utils_Tuple2(13, 46),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(32, 47))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		39,
		28,
		_Utils_Tuple2(40, 47),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 48))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		40,
		28,
		_Utils_Tuple2(18, 47),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(31, 48)))
	]);
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataQ = _List_fromArray(
	[
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		1,
		13,
		_Utils_Tuple2(1, 13),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		2,
		22,
		_Utils_Tuple2(1, 22),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		3,
		18,
		_Utils_Tuple2(2, 17),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		4,
		26,
		_Utils_Tuple2(2, 24),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		5,
		18,
		_Utils_Tuple2(2, 15),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 16))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		6,
		24,
		_Utils_Tuple2(4, 19),
		$elm$core$Maybe$Nothing),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		7,
		18,
		_Utils_Tuple2(2, 14),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 15))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		8,
		22,
		_Utils_Tuple2(4, 18),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 19))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		9,
		20,
		_Utils_Tuple2(4, 16),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 17))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		10,
		24,
		_Utils_Tuple2(6, 19),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 20))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		11,
		28,
		_Utils_Tuple2(4, 22),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 23))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		12,
		26,
		_Utils_Tuple2(4, 20),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(6, 21))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		13,
		24,
		_Utils_Tuple2(8, 20),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 21))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		14,
		20,
		_Utils_Tuple2(11, 16),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 17))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		15,
		30,
		_Utils_Tuple2(5, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		16,
		24,
		_Utils_Tuple2(15, 19),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(2, 20))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		17,
		28,
		_Utils_Tuple2(1, 22),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(15, 23))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		18,
		28,
		_Utils_Tuple2(17, 22),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 23))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		19,
		26,
		_Utils_Tuple2(17, 21),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(4, 22))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		20,
		30,
		_Utils_Tuple2(15, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(5, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		21,
		28,
		_Utils_Tuple2(17, 22),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(6, 23))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		22,
		30,
		_Utils_Tuple2(7, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(16, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		23,
		30,
		_Utils_Tuple2(11, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		24,
		30,
		_Utils_Tuple2(11, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(16, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		25,
		30,
		_Utils_Tuple2(7, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(22, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		26,
		28,
		_Utils_Tuple2(28, 22),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(6, 23))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		27,
		30,
		_Utils_Tuple2(8, 23),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(26, 24))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		28,
		30,
		_Utils_Tuple2(4, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(31, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		29,
		30,
		_Utils_Tuple2(1, 23),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(37, 24))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		30,
		30,
		_Utils_Tuple2(15, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(25, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		31,
		30,
		_Utils_Tuple2(42, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(1, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		32,
		30,
		_Utils_Tuple2(10, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(35, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		33,
		30,
		_Utils_Tuple2(29, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(19, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		34,
		30,
		_Utils_Tuple2(44, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(7, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		35,
		30,
		_Utils_Tuple2(39, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		36,
		30,
		_Utils_Tuple2(46, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(10, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		37,
		30,
		_Utils_Tuple2(49, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(10, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		38,
		30,
		_Utils_Tuple2(48, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(14, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		39,
		30,
		_Utils_Tuple2(43, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(22, 25))),
		A4(
		$pablohirafuji$elm_qrcode$QRCode$GroupInfo$newGroupInfo,
		40,
		30,
		_Utils_Tuple2(34, 24),
		$elm$core$Maybe$Just(
			_Utils_Tuple2(34, 25)))
	]);
var $pablohirafuji$elm_qrcode$QRCode$GroupInfo$getGroupData = function (ecLevel) {
	switch (ecLevel) {
		case 0:
			return $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataL;
		case 1:
			return $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataM;
		case 2:
			return $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataQ;
		default:
			return $pablohirafuji$elm_qrcode$QRCode$GroupInfo$dataH;
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$getVersion = F3(
	function (ecLevel, mode, dataLength) {
		return A2(
			$elm$core$Result$fromMaybe,
			$pablohirafuji$elm_qrcode$QRCode$Error$InputLengthOverflow,
			$elm$core$List$head(
				A2(
					$elm$core$List$sortBy,
					function ($) {
						return $.cs;
					},
					A2(
						$elm$core$List$filter,
						A2($pablohirafuji$elm_qrcode$QRCode$Encode$filterCapacity, mode, dataLength),
						$pablohirafuji$elm_qrcode$QRCode$GroupInfo$getGroupData(ecLevel)))));
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$versionToModel = F5(
	function (inputStr, ecLevel, mode, partialBitsCount, groupInfo) {
		return {
			cR: partialBitsCount + A2($pablohirafuji$elm_qrcode$QRCode$Encode$charCountIndicatorLength, mode, groupInfo.eH),
			e8: ecLevel,
			hp: groupInfo,
			dE: inputStr,
			cC: mode
		};
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$selectVersion = F4(
	function (inputStr, ecLevel, mode, encodedStr) {
		var partialBitsCount = 4 + A3(
			$elm$core$List$foldl,
			F2(
				function (a, b) {
					return a.b + b;
				}),
			0,
			encodedStr);
		return A2(
			$elm$core$Result$map,
			function (b) {
				return _Utils_Tuple2(encodedStr, b);
			},
			A2(
				$elm$core$Result$map,
				A4($pablohirafuji$elm_qrcode$QRCode$Encode$versionToModel, inputStr, ecLevel, mode, partialBitsCount),
				A3($pablohirafuji$elm_qrcode$QRCode$Encode$getVersion, ecLevel, mode, partialBitsCount)));
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$breakList = F3(
	function (checkFinish, _v0, _v1) {
		breakList:
		while (true) {
			var times = _v0.a;
			var itemCount = _v0.b;
			var byteList = _v1.a;
			var progress = _v1.b;
			if (times > 0) {
				var remainList = A2($elm$core$List$drop, itemCount, byteList);
				var block = A2($elm$core$List$take, itemCount, byteList);
				var $temp$checkFinish = checkFinish,
					$temp$_v0 = _Utils_Tuple2(times - 1, itemCount),
					$temp$_v1 = _Utils_Tuple2(
					remainList,
					A2($elm$core$List$cons, block, progress));
				checkFinish = $temp$checkFinish;
				_v0 = $temp$_v0;
				_v1 = $temp$_v1;
				continue breakList;
			} else {
				if (checkFinish && ($elm$core$List$length(byteList) > 0)) {
					return $elm$core$Result$Err($pablohirafuji$elm_qrcode$QRCode$Error$InputLengthOverflow);
				} else {
					return $elm$core$Result$Ok(
						_Utils_Tuple2(byteList, progress));
				}
			}
		}
	});
var $pablohirafuji$elm_qrcode$QRCode$Encode$toBlocks = function (_v0) {
	var model = _v0.a;
	var groupInfo = model.hp;
	var byteList = _v0.b;
	var _v1 = groupInfo.hJ;
	if (!_v1.$) {
		var group2 = _v1.a;
		return A2(
			$elm$core$Result$map,
			function (b) {
				return _Utils_Tuple2(model, b);
			},
			A2(
				$elm$core$Result$map,
				A2($elm$core$Basics$composeR, $elm$core$Tuple$second, $elm$core$List$reverse),
				A2(
					$elm$core$Result$andThen,
					A2($pablohirafuji$elm_qrcode$QRCode$Encode$breakList, true, group2),
					A3(
						$pablohirafuji$elm_qrcode$QRCode$Encode$breakList,
						false,
						groupInfo.fj,
						_Utils_Tuple2(byteList, _List_Nil)))));
	} else {
		return A2(
			$elm$core$Result$map,
			function (b) {
				return _Utils_Tuple2(model, b);
			},
			A2(
				$elm$core$Result$map,
				A2($elm$core$Basics$composeR, $elm$core$Tuple$second, $elm$core$List$reverse),
				A3(
					$pablohirafuji$elm_qrcode$QRCode$Encode$breakList,
					true,
					groupInfo.fj,
					_Utils_Tuple2(byteList, _List_Nil))));
	}
};
var $pablohirafuji$elm_qrcode$QRCode$Encode$encode = F2(
	function (inputStr, ecLevel) {
		var mode = $pablohirafuji$elm_qrcode$QRCode$Encode$selectMode(inputStr);
		return A2(
			$elm$core$Result$map,
			$pablohirafuji$elm_qrcode$QRCode$Encode$concatTranspose,
			A2(
				$elm$core$Result$andThen,
				$pablohirafuji$elm_qrcode$QRCode$Encode$getErrorCorrection,
				A2(
					$elm$core$Result$andThen,
					$pablohirafuji$elm_qrcode$QRCode$Encode$toBlocks,
					A2(
						$elm$core$Result$map,
						$pablohirafuji$elm_qrcode$QRCode$Encode$addInfoAndFinalBits,
						A2(
							$elm$core$Result$andThen,
							A3($pablohirafuji$elm_qrcode$QRCode$Encode$selectVersion, inputStr, ecLevel, mode),
							A2($pablohirafuji$elm_qrcode$QRCode$Encode$encoder, mode, inputStr))))));
	});
var $pablohirafuji$elm_qrcode$QRCode$fromStringWith = F2(
	function (ecLevel, input) {
		return A2(
			$elm$core$Result$mapError,
			$pablohirafuji$elm_qrcode$QRCode$convertError,
			A2(
				$elm$core$Result$andThen,
				function (_v0) {
					var encodeModel = _v0.a;
					var encodedData = _v0.b;
					return A2(
						$elm$core$Result$map,
						function (matrix) {
							return {ch: matrix, eH: encodeModel.hp.eH};
						},
						$pablohirafuji$elm_qrcode$QRCode$Matrix$apply(
							_Utils_Tuple2(encodeModel, encodedData)));
				},
				A2(
					$pablohirafuji$elm_qrcode$QRCode$Encode$encode,
					input,
					$pablohirafuji$elm_qrcode$QRCode$convertEC(ecLevel))));
	});
var $pablohirafuji$elm_qrcode$QRCode$fromString = $pablohirafuji$elm_qrcode$QRCode$fromStringWith(2);
var $pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize = 5;
var $pablohirafuji$elm_qrcode$QRCode$Render$Svg$appendLastRect = function (_v0) {
	var lastRect = _v0.a;
	var rowLines = _v0.b;
	return A2(
		$elm$core$List$cons,
		'h' + $elm$core$String$fromInt(lastRect.gH * $pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize),
		rowLines);
};
var $elm$core$String$concat = function (strings) {
	return A2($elm$core$String$join, '', strings);
};
var $elm$svg$Svg$Attributes$d = _VirtualDom_attribute('d');
var $elm$core$String$fromFloat = _String_fromNumber;
var $elm$svg$Svg$trustedNode = _VirtualDom_nodeNS('http://www.w3.org/2000/svg');
var $elm$svg$Svg$path = $elm$svg$Svg$trustedNode('path');
var $elm$svg$Svg$Attributes$shapeRendering = _VirtualDom_attribute('shape-rendering');
var $elm$svg$Svg$Attributes$stroke = _VirtualDom_attribute('stroke');
var $elm$svg$Svg$Attributes$strokeWidth = _VirtualDom_attribute('stroke-width');
var $elm$svg$Svg$Attributes$style = _VirtualDom_attribute('style');
var $elm$svg$Svg$svg = $elm$svg$Svg$trustedNode('svg');
var $pablohirafuji$elm_qrcode$QRCode$Render$Svg$toRowLines = F2(
	function (isDark, _v0) {
		var lastRect = _v0.a;
		var rowLines = _v0.b;
		return isDark ? ((!lastRect.aq) ? _Utils_Tuple2(
			_Utils_update(
				lastRect,
				{gH: lastRect.gH + 1}),
			rowLines) : _Utils_Tuple2(
			{aq: 0, gH: 1},
			A2(
				$elm$core$List$cons,
				$elm$core$String$concat(
					_List_fromArray(
						[
							(lastRect.gH > 0) ? ('h' + $elm$core$String$fromInt(lastRect.gH * $pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize)) : '',
							'm',
							$elm$core$String$fromInt(lastRect.aq * $pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize),
							' 0'
						])),
				rowLines))) : _Utils_Tuple2(
			_Utils_update(
				lastRect,
				{aq: lastRect.aq + 1}),
			rowLines);
	});
var $elm$svg$Svg$Attributes$transform = _VirtualDom_attribute('transform');
var $elm$svg$Svg$Attributes$viewBox = _VirtualDom_attribute('viewBox');
var $pablohirafuji$elm_qrcode$QRCode$Render$Svg$viewRow = F3(
	function (quietZoneSize, rowIndex, rowLines) {
		return A2(
			$elm$core$List$cons,
			'M0 ',
			A2(
				$elm$core$List$cons,
				$elm$core$String$fromInt(rowIndex * $pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize),
				rowLines));
	});
var $pablohirafuji$elm_qrcode$QRCode$Render$Svg$viewBase = F3(
	function (quietZoneSize, extraAttrs, matrix) {
		var quietZonePx = quietZoneSize * $pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize;
		var sizePx = $elm$core$String$fromInt(
			($elm$core$List$length(matrix) * $pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize) + (2 * quietZonePx));
		return A2(
			$elm$svg$Svg$svg,
			_Utils_ap(
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$viewBox('0 0 ' + (sizePx + (' ' + sizePx))),
						$elm$svg$Svg$Attributes$shapeRendering('crispEdges'),
						$elm$svg$Svg$Attributes$stroke('#000'),
						$elm$svg$Svg$Attributes$strokeWidth(
						$elm$core$String$fromInt($pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize) + 'px')
					]),
				extraAttrs),
			function (d) {
				return _List_fromArray(
					[
						A2(
						$elm$svg$Svg$path,
						_List_fromArray(
							[
								d,
								$elm$svg$Svg$Attributes$transform(
								'translate(' + ($elm$core$String$fromInt(quietZonePx) + (', ' + ($elm$core$String$fromFloat(quietZonePx + ($pablohirafuji$elm_qrcode$QRCode$Render$Svg$moduleSize / 2)) + ')')))),
								$elm$svg$Svg$Attributes$style('stroke-width: 5px')
							]),
						_List_Nil)
					]);
			}(
				$elm$svg$Svg$Attributes$d(
					$elm$core$String$concat(
						$elm$core$List$concat(
							A2(
								$elm$core$List$indexedMap,
								$pablohirafuji$elm_qrcode$QRCode$Render$Svg$viewRow(quietZoneSize),
								A2(
									$elm$core$List$map,
									A2(
										$elm$core$Basics$composeR,
										A2(
											$elm$core$List$foldl,
											$pablohirafuji$elm_qrcode$QRCode$Render$Svg$toRowLines,
											_Utils_Tuple2(
												{aq: 0, gH: 0},
												_List_Nil)),
										A2($elm$core$Basics$composeR, $pablohirafuji$elm_qrcode$QRCode$Render$Svg$appendLastRect, $elm$core$List$reverse)),
									matrix)))))));
	});
var $pablohirafuji$elm_qrcode$QRCode$Render$Svg$view = $pablohirafuji$elm_qrcode$QRCode$Render$Svg$viewBase(4);
var $pablohirafuji$elm_qrcode$QRCode$toSvg = F2(
	function (extraAttrs, _v0) {
		var matrix = _v0.ch;
		return A2($pablohirafuji$elm_qrcode$QRCode$Render$Svg$view, extraAttrs, matrix);
	});
var $author$project$Page$Alias$View$qrCodeView = F2(
	function (texts, message) {
		return A2(
			$elm$core$Result$withDefault,
			$elm$html$Html$text(texts.aZ),
			A2(
				$elm$core$Result$map,
				$pablohirafuji$elm_qrcode$QRCode$toSvg(_List_Nil),
				$pablohirafuji$elm_qrcode$QRCode$fromString(message)));
	});
var $author$project$Styles$styleQr = 'dark:bg-stone-400 bg-gray-50 mx-auto md:mx-0';
var $author$project$Page$Alias$View$shareInfo = F4(
	function (texts, flags, model, url) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-col md:flex-row py-2 h-full items-center justify-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('md:w-2/3')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-col items-center  space-y-2 py-2')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$primaryButton),
											$elm$html$Html$Attributes$id(
											A2($elm$core$String$dropLeft, 1, $author$project$Page$Alias$Data$clipboardData.b)),
											A2($elm$html$Html$Attributes$attribute, 'data-clipboard-target', '#alias-url'),
											$elm$html$Html$Attributes$href('#')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-copy mr-2')
												]),
											_List_Nil),
											$elm$html$Html$text(texts.aK)
										])),
									$author$project$Comp$Basic$primaryButton(
									{
										F: _List_fromArray(
											[
												$elm$html$Html$Attributes$href('#')
											]),
										t: !flags.b.dO,
										x: $elm$html$Html$Events$onClick($author$project$Page$Alias$Data$InitMail),
										dt: 'fa fa-envelope',
										hx: texts.bF,
										O: false
									})
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('md:w-1/3 ')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$border),
									$elm$html$Html$Attributes$class($author$project$Styles$styleQr)
								]),
							_List_fromArray(
								[
									A2($author$project$Page$Alias$View$qrCodeView, texts, url)
								]))
						]))
				]));
	});
var $author$project$Comp$MailSend$MailFormMsg = function (a) {
	return {$: 0, a: a};
};
var $author$project$Comp$Basic$loadingDimmer = function (cfg) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$classList(
				_List_fromArray(
					[
						_Utils_Tuple2('hidden', !cfg.gO)
					])),
				$elm$html$Html$Attributes$class($author$project$Styles$dimmer)
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('text-gray-200')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('fa fa-circle-notch animate-spin')
							]),
						_List_Nil),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('ml-2')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(cfg.hx)
							]))
					]))
			]));
};
var $author$project$Comp$MailForm$Cancel = {$: 3};
var $author$project$Comp$MailForm$Send = {$: 4};
var $author$project$Comp$MailForm$SetBody = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$MailForm$SetReceiver = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$MailForm$SetSubject = function (a) {
	return {$: 0, a: a};
};
var $author$project$Comp$Basic$secondaryButton = function (model) {
	return $author$project$Comp$Basic$genericButton(
		{ce: $author$project$Styles$secondaryButtonHover, F: model.F, aE: $author$project$Styles$secondaryButtonMain, t: model.t, x: model.x, dt: model.dt, hx: model.hx, O: model.O});
};
var $author$project$Styles$textAreaInput = 'block' + $author$project$Styles$textInput;
var $elm$html$Html$textarea = _VirtualDom_node('textarea');
var $author$project$Comp$MailForm$view = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-col')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('mb-4')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$label,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.h9),
									$author$project$Comp$Basic$inputRequired
								])),
							A2(
							$elm$html$Html$input,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$type_('text'),
									$elm$html$Html$Attributes$class($author$project$Styles$textInput),
									$elm$html$Html$Events$onInput($author$project$Comp$MailForm$SetReceiver),
									$elm$html$Html$Attributes$value(model.ao)
								]),
							_List_Nil),
							A2(
							$elm$html$Html$span,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('text-sm opacity-70')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.ip)
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('mb-4')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$label,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.ey),
									$author$project$Comp$Basic$inputRequired
								])),
							A2(
							$elm$html$Html$input,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$type_('text'),
									$elm$html$Html$Events$onInput($author$project$Comp$MailForm$SetSubject),
									$elm$html$Html$Attributes$value(model.ey),
									$elm$html$Html$Attributes$class($author$project$Styles$textInput)
								]),
							_List_Nil)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('mb-4')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$label,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.g),
									$author$project$Comp$Basic$inputRequired
								])),
							A2(
							$elm$html$Html$textarea,
							_List_fromArray(
								[
									$elm$html$Html$Events$onInput($author$project$Comp$MailForm$SetBody),
									$elm$html$Html$Attributes$class($author$project$Styles$textAreaInput),
									$elm$html$Html$Attributes$class('h-48'),
									$elm$html$Html$Attributes$value(model.g)
								]),
							_List_Nil)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-row space-x-2')
						]),
					_List_fromArray(
						[
							$author$project$Comp$Basic$primaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: $elm$core$String$isEmpty(model.ao) || ($elm$core$String$isEmpty(model.ey) || $elm$core$String$isEmpty(model.g)),
								x: $elm$html$Html$Events$onClick($author$project$Comp$MailForm$Send),
								dt: 'fa fa-paper-plane font-thin',
								hx: texts.im,
								O: false
							}),
							$author$project$Comp$Basic$secondaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: false,
								x: $elm$html$Html$Events$onClick($author$project$Comp$MailForm$Cancel),
								dt: '',
								hx: texts.cV,
								O: false
							})
						]))
				]));
	});
var $author$project$Comp$MailSend$view = F3(
	function (texts, classes, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(classes),
					$elm$html$Html$Attributes$class('relative')
				]),
			_List_fromArray(
				[
					$author$project$Comp$Basic$loadingDimmer(
					{
						gO: model.I.gO,
						hx: model.I.dU(texts)
					}),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2(
									'hidden',
									_Utils_eq(model.P, $elm$core$Maybe$Nothing)),
									_Utils_Tuple2(
									$author$project$Styles$errorMessage,
									A2(
										$elm$core$Maybe$withDefault,
										false,
										A2(
											$elm$core$Maybe$map,
											$elm$core$Basics$not,
											A2(
												$elm$core$Maybe$map,
												function ($) {
													return $.iA;
												},
												model.P))))
								]))
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							A2(
								$elm$core$Maybe$withDefault,
								'',
								A2(
									$elm$core$Maybe$map,
									function ($) {
										return $.dU;
									},
									model.P)))
						])),
					A2(
					$elm$html$Html$map,
					$author$project$Comp$MailSend$MailFormMsg,
					A2($author$project$Comp$MailForm$view, texts.X, model.X))
				]));
	});
var $author$project$Page$Alias$View$shareText = F4(
	function (texts, flags, model, alias_) {
		var url = _Utils_ap(
			flags.b.c,
			$author$project$Page$pageToString(
				$author$project$Page$OpenSharePage(alias_.hs)));
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('mt-4')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header2)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-share-alt mr-2')
								]),
							_List_Nil),
							$elm$html$Html$text(texts.bT)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$message)
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(texts.ay),
							A2(
							$elm$html$Html$pre,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('url')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$code,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$id('alias-url')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(url)
										]))
								])),
							$elm$html$Html$text(texts.bU)
						])),
					function () {
					var _v0 = model.X;
					if (!_v0.$) {
						var msm = _v0.a;
						return A2(
							$elm$html$Html$map,
							$author$project$Page$Alias$Data$MailFormMsg,
							A3(
								$author$project$Comp$MailSend$view,
								texts.ba,
								_List_fromArray(
									[
										_Utils_Tuple2('mt-2 px-2 py-2 ' + $author$project$Styles$box, true)
									]),
								msm));
					} else {
						return A4($author$project$Page$Alias$View$shareInfo, texts, flags, model, url);
					}
				}()
				]));
	});
var $author$project$Page$Alias$View$viewModify = F4(
	function (texts, flags, model, alias_) {
		var isOwner = A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$eq(alias_.d3),
				A2(
					$elm$core$Maybe$map,
					function ($) {
						return $.eD;
					},
					flags.f)));
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('flex flex-col')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$h1,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class($author$project$Styles$header1)
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$i,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('fa fa-upload mr-2')
									]),
								_List_Nil),
								$elm$html$Html$text(texts.gS),
								$elm$html$Html$text(alias_.dX),
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('text-sm opacity-75')
									]),
								_List_fromArray(
									[
										$elm$html$Html$text(texts.d3 + ':'),
										A2(
										$elm$html$Html$span,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class('ml-1')
											]),
										_List_fromArray(
											[
												$elm$html$Html$text(alias_.d3)
											]))
									]))
							])),
						isOwner ? A2(
						$elm$html$Html$map,
						$author$project$Page$Alias$Data$AliasFormMsg,
						A3($author$project$Comp$AliasForm$view, flags, texts.ax, model.fh)) : A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class($author$project$Styles$infoMessage)
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(texts.bm)
							])),
						A2(
						$elm$core$Maybe$withDefault,
						$author$project$Util$Html$noElement,
						A2($elm$core$Maybe$map, $author$project$Util$Html$resultMsg, model.gg)),
						A4($author$project$Page$Alias$View$shareText, texts, flags, model, alias_)
					]))
			]);
	});
var $author$project$Page$Alias$View$view = F4(
	function (texts, flags, id, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content),
					$elm$html$Html$Attributes$class('flex flex-col')
				]),
			function () {
				var _v0 = model.cG;
				if (!_v0.$) {
					var alias_ = _v0.a;
					return A4($author$project$Page$Alias$View$viewModify, texts, flags, model, alias_);
				} else {
					return _Utils_eq(
						id,
						$elm$core$Maybe$Just('new')) ? A3($author$project$Page$Alias$View$viewCreate, flags, texts, model) : A3($author$project$Page$Alias$View$viewList, flags, texts, model);
				}
			}());
	});
var $author$project$App$View$viewAlias = F3(
	function (id, texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$AliasMsg,
			A4($author$project$Page$Alias$View$view, texts.gS, model.fg, id, model.eO));
	});
var $author$project$Page$Detail$Data$QuitZoom = {$: 7};
var $author$project$Page$Detail$Data$SetZoom = function (a) {
	return {$: 8, a: a};
};
var $author$project$Page$Detail$View$deleteLoader = F2(
	function (texts, model) {
		return $author$project$Comp$Basic$loadingDimmer(
			{gO: model.e2 === 2, hx: texts.cb});
	});
var $author$project$Page$Detail$Data$DescEditMsg = function (a) {
	return {$: 14, a: a};
};
var $author$project$Page$Detail$Data$SaveDescription = {$: 15};
var $author$project$Page$Detail$Data$ToggleEditDesc = {$: 13};
var $author$project$Comp$MenuBar$CustomElement = function (a) {
	return {$: 9, a: a};
};
var $author$project$Comp$MarkdownInput$Preview = 1;
var $author$project$Comp$MarkdownInput$SetDisplay = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$MarkdownInput$Split = 2;
var $author$project$Comp$MenuBar$ToggleButton = function (a) {
	return {$: 4, a: a};
};
var $author$project$Comp$MarkdownInput$SetText = function (a) {
	return {$: 0, a: a};
};
var $author$project$Comp$MarkdownInput$editDisplay = function (txt) {
	return A2(
		$elm$html$Html$textarea,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class(
				A3($elm$core$String$replace, $author$project$Styles$formFocusRing, '', $author$project$Styles$textAreaInput)),
				$elm$html$Html$Attributes$class('w-full h-48 border-none min-h-full mt-1 focus:ring-0 focus:outline-none'),
				$elm$html$Html$Events$onInput($author$project$Comp$MarkdownInput$SetText)
			]),
		_List_fromArray(
			[
				$elm$html$Html$text(txt)
			]));
};
var $author$project$Comp$MarkdownInput$previewDisplay = function (txt) {
	return A2(
		$elm_explorations$markdown$Markdown$toHtml,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('markdown-preview max-h-96 overflow-y-auto')
			]),
		txt);
};
var $author$project$Comp$MarkdownInput$splitDisplay = function (txt) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('flex flex-col md:flex-row max-h-96 overflow-y-auto')
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('w-full md:w-1/2')
					]),
				_List_fromArray(
					[
						$author$project$Comp$MarkdownInput$editDisplay(txt)
					])),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('w-full md:w-1/2 border-t md:border-t-0 md:border-l pt-2 md:pl-1'),
						$elm$html$Html$Attributes$class('dark:border-stone-600')
					]),
				_List_fromArray(
					[
						$author$project$Comp$MarkdownInput$previewDisplay(txt)
					]))
			]));
};
var $author$project$Comp$MarkdownInput$view = F4(
	function (texts, classes, txt, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(classes)
				]),
			_List_fromArray(
				[
					$author$project$Comp$MenuBar$view(
					{
						hg: _List_fromArray(
							[
								$author$project$Comp$MenuBar$CustomElement(
								A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$link),
											$elm$html$Html$Attributes$class('my-auto'),
											$elm$html$Html$Attributes$href(model.cX)
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-question-circle mr-2')
												]),
											_List_Nil),
											$elm$html$Html$text(texts.iB)
										])))
							]),
						$8: 'text-xs',
						it: _List_fromArray(
							[
								$author$project$Comp$MenuBar$ToggleButton(
								{
									gO: !model.g9,
									dt: $elm$core$Maybe$Just('fa fa-edit'),
									hx: texts.he,
									cI: $author$project$Comp$MarkdownInput$SetDisplay(0),
									eA: texts.he
								}),
								$author$project$Comp$MenuBar$ToggleButton(
								{
									gO: model.g9 === 1,
									dt: $elm$core$Maybe$Just('fa fa-eye'),
									hx: texts.f6,
									cI: $author$project$Comp$MarkdownInput$SetDisplay(1),
									eA: texts.f6
								}),
								$author$project$Comp$MenuBar$ToggleButton(
								{
									gO: model.g9 === 2,
									dt: $elm$core$Maybe$Just('fa fa-columns'),
									hx: texts.gs,
									cI: $author$project$Comp$MarkdownInput$SetDisplay(2),
									eA: texts.gs
								})
							]),
						iw: false
					}),
					function () {
					var _v0 = model.g9;
					switch (_v0) {
						case 0:
							return $author$project$Comp$MarkdownInput$editDisplay(txt);
						case 1:
							return $author$project$Comp$MarkdownInput$previewDisplay(txt);
						default:
							return $author$project$Comp$MarkdownInput$splitDisplay(txt);
					}
				}()
				]));
	});
var $author$project$Page$Detail$View$descriptionView = F3(
	function (texts, model, desc) {
		var _v0 = model.e3;
		if (!_v0.$) {
			var _v1 = _v0.a;
			var dm = _v1.a;
			var str = _v1.b;
			return A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('flex flex-col mt-2 px-2 py-1'),
						$elm$html$Html$Attributes$class($author$project$Styles$box)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$map,
						$author$project$Page$Detail$Data$DescEditMsg,
						A4($author$project$Comp$MarkdownInput$view, texts.bb, _List_Nil, str, dm)),
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('flex flex-row py-2')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$a,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class($author$project$Styles$primaryButton),
										$elm$html$Html$Events$onClick($author$project$Page$Detail$Data$SaveDescription),
										$elm$html$Html$Attributes$class('mr-2'),
										$elm$html$Html$Attributes$href('#')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$i,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class('fa fa-save mr-2')
											]),
										_List_Nil),
										$elm$html$Html$text(texts.bC)
									])),
								A2(
								$elm$html$Html$a,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class($author$project$Styles$secondaryButton),
										$elm$html$Html$Events$onClick($author$project$Page$Detail$Data$ToggleEditDesc),
										$elm$html$Html$Attributes$href('#')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$i,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class('fa fa-times mr-2')
											]),
										_List_Nil),
										$elm$html$Html$text(texts.cV)
									]))
							]))
					]));
		} else {
			return A2(
				$elm_explorations$markdown$Markdown$toHtml,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('markdown-preview mt-4')
					]),
				desc);
		}
	});
var $author$project$Util$Size$B = 3;
var $author$project$Page$Detail$Data$ResetFileForm = {$: 24};
var $author$project$Page$Detail$Data$StartStopUpload = {$: 28};
var $author$project$Page$Detail$Data$SubmitFiles = {$: 25};
var $author$project$Page$Detail$Data$TopAddFiles = 3;
var $author$project$Util$Size$G = 0;
var $author$project$Util$Size$K = 2;
var $author$project$Util$Size$M = 1;
var $author$project$Util$Size$prettyNumber = function (n) {
	var parts = A2(
		$elm$core$String$split,
		'.',
		$elm$core$String$fromFloat(n));
	if ((parts.b && parts.b.b) && (!parts.b.b.b)) {
		var n0 = parts.a;
		var _v1 = parts.b;
		var d = _v1.a;
		return n0 + ('.' + A2($elm$core$String$left, 2, d));
	} else {
		return A2($elm$core$String$join, '.', parts);
	}
};
var $author$project$Util$Size$bytesReadable = F2(
	function (unit, n) {
		bytesReadable:
		while (true) {
			var num = $author$project$Util$Size$prettyNumber(n);
			var k = n / 1024;
			switch (unit) {
				case 0:
					return num + 'G';
				case 1:
					if (k > 1) {
						var $temp$unit = 0,
							$temp$n = k;
						unit = $temp$unit;
						n = $temp$n;
						continue bytesReadable;
					} else {
						return num + 'M';
					}
				case 2:
					if (k > 1) {
						var $temp$unit = 1,
							$temp$n = k;
						unit = $temp$unit;
						n = $temp$n;
						continue bytesReadable;
					} else {
						return num + 'K';
					}
				default:
					if (k > 1) {
						var $temp$unit = 2,
							$temp$n = k;
						unit = $temp$unit;
						n = $temp$n;
						continue bytesReadable;
					} else {
						return num + 'B';
					}
			}
		}
	});
var $author$project$Comp$Dropzone2$Done = {$: 0};
var $author$project$Comp$Dropzone2$Failed = {$: 1};
var $author$project$Comp$Dropzone2$Uploading = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$Dropzone2$Waiting = {$: 3};
var $author$project$Data$Percent$mkPercent = F2(
	function (c, t) {
		return (t <= 0) ? 100 : $elm$core$Basics$round((c / t) * 100);
	});
var $author$project$Data$UploadDict$allProgress = function (up) {
	var sizeOf = F2(
		function (index, file) {
			return A2(
				$elm$core$Maybe$withDefault,
				0,
				A2(
					$elm$core$Maybe$map,
					function (s) {
						switch (s.$) {
							case 0:
								return $elm$file$File$size(file);
							case 1:
								var n = s.a;
								return n;
							default:
								return $elm$file$File$size(file);
						}
					},
					A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.ev;
						},
						A2($elm$core$Dict$get, index, up.iO))));
		});
	var currsize = $elm$core$List$sum(
		A2(
			$elm$core$List$indexedMap,
			sizeOf,
			$elm$core$List$unzip(up.il).b));
	var allsize = $elm$core$List$sum(
		A2(
			$elm$core$List$map,
			$elm$file$File$size,
			$elm$core$List$unzip(up.il).b));
	return A2($author$project$Data$Percent$mkPercent, currsize, allsize);
};
var $author$project$Comp$Dropzone2$mkViewSettings = F2(
	function (active, uploads) {
		var getState = function (index) {
			return A2(
				$elm$core$Maybe$map,
				function ($) {
					return $.ev;
				},
				A2($elm$core$Dict$get, index, uploads.iO));
		};
		var fileState = function (index) {
			var _v0 = getState(index);
			if (!_v0.$) {
				switch (_v0.a.$) {
					case 0:
						var _v1 = _v0.a;
						return $author$project$Comp$Dropzone2$Done;
					case 1:
						var _v2 = _v0.a;
						var cur = _v2.a;
						var total = _v2.b;
						return $author$project$Comp$Dropzone2$Uploading(
							A2($author$project$Data$Percent$mkPercent, cur, total));
					default:
						return $author$project$Comp$Dropzone2$Failed;
				}
			} else {
				return $author$project$Comp$Dropzone2$Waiting;
			}
		};
		return {
			gO: active,
			cO: $author$project$Data$UploadDict$allProgress(uploads),
			df: fileState,
			dh: uploads.il
		};
	});
var $author$project$Comp$Dropzone2$DragEnter = {$: 0};
var $author$project$Comp$Dropzone2$DragLeave = {$: 1};
var $author$project$Comp$Dropzone2$GotFiles = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$Basic$horizontalDivider = function (settings) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('inline-flex items-center'),
				$elm$html$Html$Attributes$class(settings.iK)
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('h-px flex-grow'),
						$elm$html$Html$Attributes$class(settings.fB)
					]),
				_List_Nil),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('px-4 text-center')
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(settings.hx)
					])),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('h-px flex-grow'),
						$elm$html$Html$Attributes$class(settings.fB)
					]),
				_List_Nil)
			]));
};
var $elm$html$Html$Attributes$multiple = $elm$html$Html$Attributes$boolProperty('multiple');
var $author$project$Util$Html$hijack = function (msg) {
	return _Utils_Tuple2(msg, true);
};
var $elm$virtual_dom$VirtualDom$MayPreventDefault = function (a) {
	return {$: 2, a: a};
};
var $elm$html$Html$Events$preventDefaultOn = F2(
	function (event, decoder) {
		return A2(
			$elm$virtual_dom$VirtualDom$on,
			event,
			$elm$virtual_dom$VirtualDom$MayPreventDefault(decoder));
	});
var $author$project$Util$Html$hijackOn = F2(
	function (event, decoder) {
		return A2(
			$elm$html$Html$Events$preventDefaultOn,
			event,
			A2($elm$json$Json$Decode$map, $author$project$Util$Html$hijack, decoder));
	});
var $author$project$Util$Html$onDragEnter = function (m) {
	return A2(
		$author$project$Util$Html$hijackOn,
		'dragenter',
		$elm$json$Json$Decode$succeed(m));
};
var $author$project$Util$Html$onDragLeave = function (m) {
	return A2(
		$author$project$Util$Html$hijackOn,
		'dragleave',
		$elm$json$Json$Decode$succeed(m));
};
var $author$project$Util$Html$onDragOver = function (m) {
	return A2(
		$author$project$Util$Html$hijackOn,
		'dragover',
		$elm$json$Json$Decode$succeed(m));
};
var $author$project$Util$Html$attach = function (deca) {
	var mkTuple = function (v) {
		return A2(
			$elm$json$Json$Decode$map,
			$elm$core$Tuple$pair(v),
			deca);
	};
	return A2($elm$json$Json$Decode$andThen, mkTuple, $elm$json$Json$Decode$value);
};
var $elm$file$File$decoder = _File_decoder;
var $author$project$Util$Html$onDropFiles = function (tagger) {
	var dropDecoder = A2(
		$elm$json$Json$Decode$map,
		tagger,
		A2(
			$elm$json$Json$Decode$at,
			_List_fromArray(
				['dataTransfer', 'files']),
			$elm$json$Json$Decode$list(
				$author$project$Util$Html$attach($elm$file$File$decoder))));
	return A2($author$project$Util$Html$hijackOn, 'drop', dropDecoder);
};
var $author$project$Util$Html$onFiles = function (tomsg) {
	var decmsg = A2(
		$elm$json$Json$Decode$map,
		tomsg,
		A2(
			$elm$json$Json$Decode$at,
			_List_fromArray(
				['target', 'files']),
			$elm$json$Json$Decode$list(
				$author$project$Util$Html$attach($elm$file$File$decoder))));
	return A2($author$project$Util$Html$hijackOn, 'change', decmsg);
};
var $author$project$Styles$primaryBasicButtonHover = ' hover:bg-blue-600 hover:text-white dark:hover:text-white dark:hover:bg-orange-700 ';
var $author$project$Styles$primaryBasicButtonMain = ' rounded my-auto whitespace-nowrap border border-blue-500 dark:border-orange-700 text-blue-500 dark:text-orange-500 text-center px-4 py-2 shadow-md focus:outline-none focus:ring focus:ring-opacity-75 ';
var $author$project$Styles$primaryBasicButton = _Utils_ap($author$project$Styles$primaryBasicButtonMain, $author$project$Styles$primaryBasicButtonHover);
var $elm$virtual_dom$VirtualDom$style = _VirtualDom_style;
var $elm$html$Html$Attributes$style = $elm$virtual_dom$VirtualDom$style;
var $author$project$Comp$Progress$progress2 = F2(
	function (css, percent) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class(' w-full relative'),
					$elm$html$Html$Attributes$class(css.f0)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('transition-duration-300 bg-indigo-500 dark:bg-orange-500'),
							$elm$html$Html$Attributes$class('block text-xs text-center'),
							$elm$html$Html$Attributes$class(css.eS),
							A2(
							$elm$html$Html$Attributes$style,
							'width',
							$elm$core$String$fromInt(percent) + '%')
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('absolute left-1/2 top-0 font-semibold'),
							$elm$html$Html$Attributes$class(css.hx)
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							$elm$core$String$fromInt(percent)),
							$elm$html$Html$text('%')
						]))
				]));
	});
var $author$project$Comp$Dropzone2$DeleteFile = function (a) {
	return {$: 3, a: a};
};
var $author$project$Comp$Dropzone2$isUploading = function (state) {
	if (state.$ === 2) {
		return true;
	} else {
		return false;
	}
};
var $elm$file$File$name = _File_name;
var $author$project$Comp$Dropzone2$renderFile = F3(
	function (sett, index, file) {
		var size = A2(
			$author$project$Util$Size$bytesReadable,
			3,
			$elm$file$File$size(file));
		var name = $elm$file$File$name(file);
		var fileState = sett.df(index);
		var icon = function () {
			switch (fileState.$) {
				case 0:
					return 'fa fa-check text-green-500';
				case 3:
					return 'fa fa-file font-thin';
				case 2:
					return 'fa fa-spinner animate-spin';
				default:
					return 'fa fa-bolt text-red-500';
			}
		}();
		var percent = function () {
			if (fileState.$ === 2) {
				var p = fileState.a;
				return p;
			} else {
				return 0;
			}
		}();
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class(
					'file-' + $elm$core$String$fromInt(index)),
					A2(
					$elm$html$Html$Attributes$attribute,
					'data-index',
					$elm$core$String$fromInt(index)),
					$elm$html$Html$Attributes$class('flex flex-row items-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center py-4 w-6')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class(icon)
								]),
							_List_Nil)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex-grow mx-2')
						]),
					_List_fromArray(
						[
							$author$project$Comp$Dropzone2$isUploading(fileState) ? A2(
							$author$project$Comp$Progress$progress2,
							{eS: 'h-full rounded', hx: 'text-sm', f0: 'h-6 border dark:border-stone-600 rounded'},
							percent) : A2(
							$elm$html$Html$span,
							_List_Nil,
							_List_fromArray(
								[
									$elm$html$Html$text(name)
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-right')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$span,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('text-sm font-mono mr-2')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(size)
								])),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2('hidden', !sett.gO)
										])),
									$elm$html$Html$Attributes$class($author$project$Styles$deleteButton),
									$elm$html$Html$Attributes$class('text-xs'),
									$elm$html$Html$Attributes$href('#'),
									$elm$html$Html$Events$onClick(
									$author$project$Comp$Dropzone2$DeleteFile(index))
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-trash')
										]),
									_List_Nil)
								]))
						]))
				]));
	});
var $author$project$Comp$Dropzone2$view = F3(
	function (texts, sett, model) {
		var files = $elm$core$List$unzip(sett.dh).b;
		var allsize = A2(
			$author$project$Util$Size$bytesReadable,
			3,
			$elm$core$List$sum(
				A2($elm$core$List$map, $elm$file$File$size, files)));
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-col')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('bg-opacity-100 bg-indigo-100 dark:bg-orange-800', model.ds),
									_Utils_Tuple2('bg-indigo-100 bg-opacity-50 dark:bg-orange-900 dark:bg-opacity-50', !model.ds),
									_Utils_Tuple2('disabled', !sett.gO)
								])),
							$elm$html$Html$Attributes$class('flex flex-col justify-center items-center py-2 md:py-12 border-0 border-t-2 border-indigo-500 dark:border-orange-500 h-24 md:h-auto'),
							$author$project$Util$Html$onDragEnter($author$project$Comp$Dropzone2$DragEnter),
							$author$project$Util$Html$onDragOver($author$project$Comp$Dropzone2$DragEnter),
							$author$project$Util$Html$onDragLeave($author$project$Comp$Dropzone2$DragLeave),
							$author$project$Util$Html$onDropFiles($author$project$Comp$Dropzone2$GotFiles)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$header1),
									$elm$html$Html$Attributes$class('hidden md:inline-flex items-center')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-mouse-pointer')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-3')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.hb)
										]))
								])),
							function () {
							var _v0 = $elm$core$List$length(files);
							if (!_v0) {
								return A2($elm$html$Html$span, _List_Nil, _List_Nil);
							} else {
								var n = _v0;
								return A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('py-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(
											$elm$core$String$fromInt(n)),
											$elm$html$Html$text(texts.hl),
											$elm$html$Html$text(allsize),
											$elm$html$Html$text(')')
										]));
							}
						}(),
							$author$project$Comp$Basic$horizontalDivider(
							{hx: texts.h2, hz: 'px-4 bg-gray-200 bg-opacity-50', fB: 'bg-gray-300 dark:bg-stone-600', iK: 'w-2/3 mb-4 hidden md:inline-flex'}),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('py-1')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$primaryBasicButton)
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-folder-open mr-2')
												]),
											_List_Nil),
											$elm$html$Html$text(texts.ij),
											A2(
											$elm$html$Html$input,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$type_('file'),
													$elm$html$Html$Attributes$multiple(true),
													$elm$html$Html$Attributes$disabled(!sett.gO),
													$author$project$Util$Html$onFiles($author$project$Comp$Dropzone2$GotFiles),
													$elm$html$Html$Attributes$class('hidden')
												]),
											_List_Nil)
										]))
								]))
						])),
					_Utils_eq(files, _List_Nil) ? A2(
					$elm$html$Html$span,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('hidden')
						]),
					_List_Nil) : A2(
					$author$project$Comp$Progress$progress2,
					{eS: 'h-full', hx: 'hidden', f0: 'h-2'},
					sett.cO),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2(
									'hidden',
									_Utils_eq(files, _List_Nil))
								])),
							$elm$html$Html$Attributes$class('flex flex-col divide-y dark:divide-stone-600')
						]),
					A2(
						$elm$core$List$indexedMap,
						$author$project$Comp$Dropzone2$renderFile(sett),
						files))
				]));
	});
var $author$project$Page$Detail$View$dropzone = F3(
	function (texts, flags, model) {
		var viewSettings = A2($author$project$Comp$Dropzone2$mkViewSettings, !model.gD, model.iO);
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2('hidden', model.gz !== 3)
						])),
					$elm$html$Html$Attributes$class($author$project$Styles$box),
					$elm$html$Html$Attributes$class('flex flex-col mt-2 rounded px-2 py-2')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-row space-x-2')
						]),
					_List_fromArray(
						[
							$author$project$Comp$Basic$primaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: false,
								x: $elm$html$Html$Events$onClick($author$project$Page$Detail$Data$SubmitFiles),
								dt: 'fa fa-upload',
								hx: texts.gt,
								O: false
							}),
							$author$project$Comp$Basic$secondaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: false,
								x: $elm$html$Html$Events$onClick($author$project$Page$Detail$Data$ResetFileForm),
								dt: 'fa fa-undo',
								hx: texts.aI,
								O: true
							}),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-row flex-grow justify-end')
								]),
							_List_fromArray(
								[
									$author$project$Comp$Basic$secondaryButton(
									{
										F: _List_fromArray(
											[
												$elm$html$Html$Attributes$href('#')
											]),
										t: !model.gD,
										x: $elm$html$Html$Events$onClick($author$project$Page$Detail$Data$StartStopUpload),
										dt: model.gC ? 'fa fa-play' : 'fa fa-pause',
										hx: model.gC ? texts.bB : texts.bu,
										O: true
									})
								]))
						])),
					A2(
					$elm$html$Html$p,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('py-3')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							texts.b4(
								A2($author$project$Util$Size$bytesReadable, 3, flags.b.dP)))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2($author$project$Styles$errorMessage, true),
									_Utils_Tuple2('hidden', model.gA.iA)
								])),
							$elm$html$Html$Attributes$class('mb-2')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(model.gA.dU)
						])),
					A2(
					$elm$html$Html$map,
					$author$project$Page$Detail$Data$DropzoneMsg,
					A3($author$project$Comp$Dropzone2$view, texts.aV, viewSettings, model.aV))
				]));
	});
var $author$project$Page$Detail$Data$FileListMsg = function (a) {
	return {$: 5, a: a};
};
var $author$project$Comp$ShareFileList$Settings = F3(
	function (baseUrl, viewMode, _delete) {
		return {c: baseUrl, e0: _delete, gF: viewMode};
	});
var $author$project$Api$fileSecUrl = F3(
	function (flags, share, fid) {
		return flags.b.c + ('/api/v2/sec/share/' + (share + ('/file/' + fid)));
	});
var $author$project$Comp$ShareFileList$ReqDelete = function (a) {
	return {$: 2, a: a};
};
var $author$project$Comp$ShareFileList$Select = function (a) {
	return {$: 0, a: a};
};
var $elm$html$Html$Attributes$download = function (fileName) {
	return A2($elm$html$Html$Attributes$stringProperty, 'download', fileName);
};
var $author$project$Comp$ShareFileList$EmbedFile = function (a) {
	return {$: 1, a: a};
};
var $author$project$Comp$ShareFileList$fileIcon = function (file) {
	var mime = file.dW;
	return (!_Utils_eq(file.en, file.ex)) ? 'text-red-500 fa fa-bolt' : ((mime === 'application/pdf') ? 'fa fa-file-pdf font-thin' : ((mime === 'application/zip') ? 'fa fa-file-archive font-thin' : (A2($elm$core$String$startsWith, 'image/', mime) ? 'fa fa-file-image font-thin' : (A2($elm$core$String$startsWith, 'video/', mime) ? 'fa fa-file-video font-thin' : (A2($elm$core$String$startsWith, 'audio/', mime) ? 'fa fa-file-audio font-thin' : (A2($elm$core$String$startsWith, 'text/', mime) ? 'fa fa-file-alt font-thin' : 'fa fa-file font-thin'))))));
};
var $elm$html$Html$iframe = _VirtualDom_node('iframe');
var $elm$html$Html$img = _VirtualDom_node('img');
var $elm$core$Dict$member = F2(
	function (key, dict) {
		var _v0 = A2($elm$core$Dict$get, key, dict);
		if (!_v0.$) {
			return true;
		} else {
			return false;
		}
	});
var $elm$core$Set$member = F2(
	function (key, _v0) {
		var dict = _v0;
		return A2($elm$core$Dict$member, key, dict);
	});
var $elm$html$Html$Attributes$sandbox = $elm$html$Html$Attributes$stringProperty('sandbox');
var $elm$html$Html$Attributes$src = function (url) {
	return A2(
		$elm$html$Html$Attributes$stringProperty,
		'src',
		_VirtualDom_noJavaScriptOrHtmlUri(url));
};
var $author$project$Comp$ShareFileList$fileEmbed = F4(
	function (texts, settings, model, file) {
		var mime = file.dW;
		return (A2($author$project$Comp$ShareFileList$previewFor, $author$project$Comp$ShareFileList$previewDirect, mime) || A2($elm$core$Set$member, file.hs, model.aY)) ? A2(
			$elm$html$Html$iframe,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$src(
					_Utils_ap(settings.c, file.hs)),
					$elm$html$Html$Attributes$class('mx-auto min-h-preview dark:bg-stone-300 bg-gray-50'),
					(mime === 'application/pdf') ? $elm$html$Html$Attributes$sandbox('allow-scripts') : $elm$html$Html$Attributes$sandbox('')
				]),
			_List_Nil) : (A2($author$project$Comp$ShareFileList$previewFor, $author$project$Comp$ShareFileList$previewDeferred, mime) ? A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('min-h-preview flex flex-row items-center justify-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-3xl'),
							$elm$html$Html$Attributes$class($author$project$Styles$secondaryBasicButton),
							$elm$html$Html$Attributes$class('px-5 py-5 rounded-full'),
							$elm$html$Html$Events$onClick(
							$author$project$Comp$ShareFileList$EmbedFile(file)),
							$elm$html$Html$Attributes$href('#')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-play ')
								]),
							_List_Nil)
						]))
				])) : (A2($elm$core$String$startsWith, 'image/', mime) ? A2(
			$elm$html$Html$img,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$src(
					_Utils_ap(settings.c, file.hs)),
					$elm$html$Html$Attributes$class('mx-auto pt-1 max-h-52 ')
				]),
			_List_Nil) : A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('px-8 py-8 text-center flex flex-col items-center justify-center min-h-preview')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header3)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class(
									$author$project$Comp$ShareFileList$fileIcon(file)),
									$elm$html$Html$Attributes$class('mr-2')
								]),
							_List_Nil),
							$elm$html$Html$text(texts.h6)
						]))
				]))));
	});
var $author$project$Comp$ShareFileList$incompleteLabel = F2(
	function (texts, file) {
		var perc = $elm$core$Basics$round((file.ex / file.en) * 100);
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							'hidden',
							_Utils_eq(file.en, file.ex))
						])),
					$elm$html$Html$Attributes$class('border label text-sm inline-flex  ' + ('border-red-600 text-red-700 ' + 'dark:bg-red-500 dark:bg-opacity-30 dark:text-red-400 dark:border-red-400'))
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('fa fa-bolt dark:text-red-400 mr-2')
						]),
					_List_Nil),
					$elm$html$Html$text(
					_Utils_ap(
						texts.hj,
						_Utils_ap(
							$elm$core$String$fromInt(perc),
							texts.iL)))
				]));
	});
var $author$project$Comp$ShareFileList$DeleteCancel = {$: 4};
var $author$project$Comp$ShareFileList$DeleteConfirm = {$: 3};
var $author$project$Comp$ShareFileList$modalSettings = function (texts) {
	return A5($author$project$Comp$ConfirmModal$defaultSettings, $author$project$Comp$ShareFileList$DeleteConfirm, $author$project$Comp$ShareFileList$DeleteCancel, texts.eK.g2, texts.eK.gZ, texts.eK.dU);
};
var $author$project$Comp$ShareFileList$fileCard = F4(
	function (texts, settings, model, file) {
		var deleteModal_ = $author$project$Comp$ShareFileList$modalSettings(texts);
		var deleteModal = _Utils_update(
			deleteModal_,
			{
				da: _Utils_eq(
					model.aa,
					$elm$core$Maybe$Just(file)),
				de: 'rounded'
			});
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('relative hover:shadow-lg rounded flex flex-col break-words border border-gray-400 dark:border-stone-600 dark:hover:border-stone-500'),
					$elm$html$Html$Attributes$id(file.hs)
				]),
			_List_fromArray(
				[
					$author$project$Comp$ConfirmModal$view(deleteModal),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('overflow-hidden block bg-gray-50 dark:bg-stone-700 dark:bg-opacity-40  border-gray-400 dark:hover:border-stone-500 rounded-t max-h-52')
						]),
					_List_fromArray(
						[
							A4($author$project$Comp$ShareFileList$fileEmbed, texts, settings, model, file)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col flex-grow px-2 my-2')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('inline')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$title(texts.c7),
											$elm$html$Html$Attributes$download(file.dg),
											$elm$html$Html$Attributes$href(
											_Utils_ap(settings.c, file.hs)),
											$elm$html$Html$Attributes$class($author$project$Styles$link)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(file.dg)
										])),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-2')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text('('),
											$elm$html$Html$text(
											A2($author$project$Util$Size$bytesReadable, 3, file.en)),
											$elm$html$Html$text(')')
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mt-2 break-words ')
								]),
							_List_fromArray(
								[
									A2($author$project$Comp$ShareFileList$incompleteLabel, texts, file)
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col px-1 py-1')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-row space-x-1')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$secondaryBasicButton),
											$elm$html$Html$Attributes$title(texts.c7),
											$elm$html$Html$Attributes$download(file.dg),
											$elm$html$Html$Attributes$href(
											_Utils_ap(settings.c, file.hs))
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-download')
												]),
											_List_Nil)
										])),
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2(
													'invisible',
													!$author$project$Comp$ShareFileList$previewPossible(file.dW))
												])),
											$elm$html$Html$Attributes$class($author$project$Styles$secondaryBasicButton),
											$elm$html$Html$Attributes$title(texts.gE),
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Events$onClick(
											$author$project$Comp$ShareFileList$Select(file))
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-eye')
												]),
											_List_Nil)
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex-grow flex flex-row justify-end')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$a,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$classList(
													_List_fromArray(
														[
															_Utils_Tuple2('ui right floated basic red icon button', true),
															_Utils_Tuple2('invisible', !settings.e0)
														])),
													$elm$html$Html$Attributes$class($author$project$Styles$deleteButton),
													$elm$html$Html$Attributes$title(texts.e1),
													$elm$html$Html$Attributes$href('#'),
													$elm$html$Html$Events$onClick(
													$author$project$Comp$ShareFileList$ReqDelete(file))
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$i,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class('fa fa-trash')
														]),
													_List_Nil)
												]))
										]))
								]))
						]))
				]));
	});
var $author$project$Comp$ShareFileList$fileCards = F4(
	function (texts, settings, model, files) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 2xl:grid-cols-4 gap-2')
				]),
			A2(
				$elm$core$List$map,
				A3($author$project$Comp$ShareFileList$fileCard, texts, settings, model),
				files));
	});
var $author$project$Comp$ShareFileList$fileRow = F4(
	function (texts, _v0, _v1, file) {
		var baseUrl = _v0.c;
		var _delete = _v0.e0;
		return A2(
			$elm$html$Html$tr,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$id(file.hs),
					$elm$html$Html$Attributes$class($author$project$Styles$tableRow)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center py-2')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class(
									'text-2xl ' + $author$project$Comp$ShareFileList$fileIcon(file))
								]),
							_List_Nil)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left w-full px-3 break-all sm:break-words')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$title(texts.c7),
									$elm$html$Html$Attributes$download(file.dg),
									$elm$html$Html$Attributes$href(
									_Utils_ap(baseUrl, file.hs)),
									$elm$html$Html$Attributes$class($author$project$Styles$link)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(file.dg)
								])),
							A2(
							$elm$html$Html$span,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('text-sm font-mono')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(' ('),
									$elm$html$Html$text(
									A2($author$project$Util$Size$bytesReadable, 3, file.en)),
									$elm$html$Html$text(') ')
								])),
							A2($author$project$Comp$ShareFileList$incompleteLabel, texts, file)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('text-right flex flex-row justify-end space-x-1 items-center')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2(
													'hidden',
													!$author$project$Comp$ShareFileList$previewPossible(file.dW))
												])),
											$elm$html$Html$Attributes$class($author$project$Styles$secondaryBasicButton),
											$elm$html$Html$Attributes$class('text-xs'),
											$elm$html$Html$Attributes$title(texts.gE),
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Events$onClick(
											$author$project$Comp$ShareFileList$Select(file))
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-eye')
												]),
											_List_Nil)
										])),
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2('hidden', !_delete)
												])),
											$elm$html$Html$Attributes$class($author$project$Styles$deleteButton),
											$elm$html$Html$Attributes$class('text-xs'),
											$elm$html$Html$Attributes$title(texts.e1),
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Events$onClick(
											$author$project$Comp$ShareFileList$ReqDelete(file))
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-trash')
												]),
											_List_Nil)
										]))
								]))
						]))
				]));
	});
var $author$project$Comp$ShareFileList$fileTable = F4(
	function (texts, settings, model, files) {
		var yesNo = function () {
			var _v0 = model.aa;
			if (!_v0.$) {
				return $author$project$Comp$ConfirmModal$view(
					$author$project$Comp$ShareFileList$modalSettings(texts));
			} else {
				return A2($elm$html$Html$span, _List_Nil, _List_Nil);
			}
		}();
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('md:relative')
				]),
			_List_fromArray(
				[
					yesNo,
					A2(
					$elm$html$Html$table,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$tableMain)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$tbody,
							_List_Nil,
							A2(
								$elm$core$List$map,
								A3($author$project$Comp$ShareFileList$fileRow, texts, settings, model),
								files))
						]))
				]));
	});
var $author$project$Comp$ShareFileList$view = F4(
	function (texts, settings, files, model) {
		var _v0 = settings.gF;
		if (!_v0) {
			return A4($author$project$Comp$ShareFileList$fileTable, texts, settings, model, files);
		} else {
			return A4($author$project$Comp$ShareFileList$fileCards, texts, settings, model, files);
		}
	});
var $author$project$Page$Detail$View$fileList = F3(
	function (texts, flags, model) {
		var sorted = A2(
			$elm$core$List$sortBy,
			function ($) {
				return $.dg;
			},
			model.gm.dh);
		var sett = A3(
			$author$project$Comp$ShareFileList$Settings,
			A3($author$project$Api$fileSecUrl, flags, model.gm.hs, ''),
			model.fe,
			true);
		return A2(
			$elm$html$Html$map,
			$author$project$Page$Detail$Data$FileListMsg,
			A4($author$project$Comp$ShareFileList$view, texts.bK, sett, sorted, model.fd));
	});
var $author$project$Page$Detail$View$messageDiv = function (model) {
	return $author$project$Util$Html$resultMsgMaybe(model.dU);
};
var $author$project$Page$Detail$Data$SetFileView = function (a) {
	return {$: 6, a: a};
};
var $author$project$Page$Detail$View$middleMenu = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: !model.fe,
							dt: $elm$core$Maybe$Just('fa fa-list'),
							hx: '',
							cI: $author$project$Page$Detail$Data$SetFileView(0),
							eA: texts.a5
						}),
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: model.fe === 1,
							dt: $elm$core$Maybe$Just('fa fa-th'),
							hx: '',
							cI: $author$project$Page$Detail$Data$SetFileView(1),
							eA: texts.aF
						})
					]),
				$8: 'my-2',
				it: _List_Nil,
				iw: false
			});
	});
var $author$project$Page$Detail$Data$TopShare = 2;
var $author$project$Page$Detail$Data$InitMail = {$: 30};
var $author$project$Page$Detail$Data$SetShareUrlMode = function (a) {
	return {$: 33, a: a};
};
var $author$project$Data$InitialView$icon = function (iv) {
	switch (iv) {
		case 0:
			return 'fa fa-list';
		case 1:
			return 'fa fa-th';
		default:
			return 'fa fa-eye';
	}
};
var $author$project$Page$Detail$View$showUrlSwitch = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: A2(
					$elm$core$List$map,
					function (iv) {
						return $author$project$Comp$MenuBar$ToggleButton(
							{
								gO: _Utils_eq(model.gp, iv),
								dt: $elm$core$Maybe$Just(
									$author$project$Data$InitialView$icon(iv)),
								hx: texts.a2(iv),
								cI: $author$project$Page$Detail$Data$SetShareUrlMode(iv),
								eA: texts.a2(iv)
							});
					},
					$author$project$Data$InitialView$all),
				$8: 'py-1 text-xs',
				it: _List_Nil,
				iw: false
			});
	});
var $author$project$Page$Detail$View$shareLinkPublished = F3(
	function (texts, flags, model) {
		var share = model.gm;
		var qrCodeView = function (message) {
			return A2(
				$elm$core$Result$withDefault,
				$elm$html$Html$text(texts.aZ),
				A2(
					$elm$core$Result$map,
					$pablohirafuji$elm_qrcode$QRCode$toSvg(_List_Nil),
					$pablohirafuji$elm_qrcode$QRCode$fromString(message)));
		};
		var pid = A2(
			$elm$core$Maybe$withDefault,
			'',
			A2(
				$elm$core$Maybe$map,
				function ($) {
					return $.hs;
				},
				share.ea));
		var url = _Utils_ap(
			flags.b.c,
			$author$project$Page$pageToString(
				A2(
					$author$project$Page$OpenDetailPage,
					pid,
					$elm$core$Maybe$Just(
						$author$project$Data$InitialView$toInt(model.gp)))));
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_Nil,
				_List_fromArray(
					[
						$elm$html$Html$text(texts.bP),
						A2(
						$elm$html$Html$pre,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('text-center')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$code,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$id('share-url')
									]),
								_List_fromArray(
									[
										$elm$html$Html$text(url)
									]))
							])),
						$elm$html$Html$text(texts.bJ)
					])),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('flex flex-row space-x-2 items-center')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('flex-grow text-right')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(texts.a1)
							])),
						A2($author$project$Page$Detail$View$showUrlSwitch, texts, model)
					])),
				function () {
				var _v0 = model.X;
				if (!_v0.$) {
					var mf = _v0.a;
					return A2(
						$elm$html$Html$map,
						$author$project$Page$Detail$Data$MailFormMsg,
						A3($author$project$Comp$MailSend$view, texts.ba, _List_Nil, mf));
				} else {
					return A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('flex flex-col md:flex-row py-2 h-full items-center justify-center')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('md:w-2/3')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$div,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class('flex flex-col items-center  space-y-2 py-2')
											]),
										_List_fromArray(
											[
												A2(
												$elm$html$Html$a,
												_List_fromArray(
													[
														$elm$html$Html$Attributes$class($author$project$Styles$primaryButton),
														$elm$html$Html$Attributes$id(
														A2($elm$core$String$dropLeft, 1, $author$project$Page$Detail$Data$clipboardData.b)),
														$elm$html$Html$Attributes$href('#'),
														A2($elm$html$Html$Attributes$attribute, 'data-clipboard-target', '#share-url')
													]),
												_List_fromArray(
													[
														A2(
														$elm$html$Html$i,
														_List_fromArray(
															[
																$elm$html$Html$Attributes$class('fa fa-copy mr-2')
															]),
														_List_Nil),
														$elm$html$Html$text(texts.aK)
													])),
												$author$project$Comp$Basic$primaryButton(
												{
													F: _List_fromArray(
														[
															$elm$html$Html$Attributes$href('#')
														]),
													t: !flags.b.dO,
													x: $elm$html$Html$Events$onClick($author$project$Page$Detail$Data$InitMail),
													dt: 'fa fa-envelope',
													hx: texts.bF,
													O: false
												})
											]))
									])),
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('md:w-1/3')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$div,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class($author$project$Styles$styleQr)
											]),
										_List_fromArray(
											[
												qrCodeView(url)
											]))
									]))
							]));
				}
			}()
			]);
	});
var $author$project$Page$Detail$View$shareLink = F3(
	function (texts, flags, model) {
		var mydiv = F2(
			function (boxType, elements) {
				return A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col px-2 py-2 rounded mt-2'),
							$elm$html$Html$Attributes$class(boxType),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', model.gz !== 2)
								]))
						]),
					elements);
			});
		return _List_fromArray(
			[
				function () {
				var _v0 = $author$project$Page$Detail$Data$isPublished(model.gm);
				switch (_v0) {
					case 0:
						return A2(
							mydiv,
							$author$project$Styles$infoMessage,
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bO)
								]));
					case 1:
						return A2(
							mydiv,
							$author$project$Styles$box,
							A3($author$project$Page$Detail$View$shareLinkPublished, texts, flags, model));
					case 2:
						return A2(
							mydiv,
							$author$project$Styles$warnMessage,
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bM)
								]));
					default:
						return A2(
							mydiv,
							$author$project$Styles$warnMessage,
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bQ)
								]));
				}
			}()
			]);
	});
var $author$project$Page$Detail$Data$DeleteCancel = {$: 11};
var $author$project$Page$Detail$Data$DeleteConfirm = {$: 10};
var $author$project$Page$Detail$Data$MaxViews = 1;
var $author$project$Page$Detail$Data$Name = 0;
var $author$project$Page$Detail$Data$Password = 3;
var $author$project$Page$Detail$Data$PublishShare = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$Detail$Data$ReqEdit = function (a) {
	return {$: 16, a: a};
};
var $author$project$Page$Detail$Data$RequestDelete = {$: 9};
var $author$project$Page$Detail$Data$TopDetail = 1;
var $author$project$Page$Detail$Data$Validity = 2;
var $author$project$Page$Detail$View$property = F2(
	function (texts, rec) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('mb-3')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('font-semibold text-base')
						]),
					rec.s),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-sm ')
						]),
					_List_fromArray(
						[
							function () {
							var _v0 = rec.u;
							if (!_v0.$) {
								var msg = _v0.a;
								return A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$link),
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Attributes$title(texts.he),
											$elm$html$Html$Events$onClick(msg)
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-edit mr-2')
												]),
											_List_Nil)
										]));
							} else {
								return $elm$html$Html$text('');
							}
						}(),
							A2(
							$elm$html$Html$span,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('opacity-75')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(rec.hx)
								]))
						]))
				]));
	});
var $author$project$Page$Detail$Data$CancelEdit = {$: 22};
var $author$project$Page$Detail$Data$EditKey = function (a) {
	return {$: 32, a: a};
};
var $author$project$Page$Detail$Data$MaxViewMsg = function (a) {
	return {$: 18, a: a};
};
var $author$project$Page$Detail$Data$PasswordEditMsg = function (a) {
	return {$: 20, a: a};
};
var $author$project$Page$Detail$Data$SetName = function (a) {
	return {$: 17, a: a};
};
var $author$project$Page$Detail$Data$ValidityEditMsg = function (a) {
	return {$: 19, a: a};
};
var $elm$html$Html$Events$alwaysPreventDefault = function (msg) {
	return _Utils_Tuple2(msg, true);
};
var $elm$html$Html$Events$onSubmit = function (msg) {
	return A2(
		$elm$html$Html$Events$preventDefaultOn,
		'submit',
		A2(
			$elm$json$Json$Decode$map,
			$elm$html$Html$Events$alwaysPreventDefault,
			$elm$json$Json$Decode$succeed(msg)));
};
var $author$project$Comp$IntInput$SetValue = $elm$core$Basics$identity;
var $author$project$Comp$IntInput$view = F2(
	function (nval, model) {
		return A2(
			$elm$html$Html$input,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$type_('text'),
					$elm$html$Html$Attributes$value(
					A2(
						$elm$core$Maybe$withDefault,
						model.cz,
						A2($elm$core$Maybe$map, $elm$core$String$fromInt, nval))),
					$elm$html$Html$Events$onInput($elm$core$Basics$identity),
					$elm$html$Html$Attributes$class($author$project$Styles$textInput),
					model.ak ? $elm$html$Html$Attributes$class($author$project$Styles$inputErrorBorder) : $elm$html$Html$Attributes$class('')
				]),
			_List_Nil);
	});
var $author$project$Page$Detail$View$propertyEdit = F3(
	function (texts, flags, ef) {
		var saveButton = A2(
			$elm$html$Html$button,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$primaryButtonPlain),
					$elm$html$Html$Attributes$class('ml-2 rounded-l'),
					$elm$html$Html$Attributes$href('#'),
					$elm$html$Html$Events$onClick($author$project$Page$Detail$Data$SaveEdit),
					$elm$html$Html$Attributes$type_('submit')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('fa fa-check')
						]),
					_List_Nil)
				]));
		var cancelButton = A2(
			$elm$html$Html$a,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$secondaryButtonPlain),
					$elm$html$Html$Attributes$class($author$project$Styles$secondaryButtonHover),
					$elm$html$Html$Attributes$class('rounded-r'),
					$elm$html$Html$Attributes$href('#'),
					$elm$html$Html$Events$onClick($author$project$Page$Detail$Data$CancelEdit)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('fa fa-times')
						]),
					_List_Nil)
				]));
		switch (ef.$) {
			case 0:
				var v = ef.a;
				return _List_fromArray(
					[
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('flex flex-row'),
								$elm$html$Html$Events$onSubmit($author$project$Page$Detail$Data$SaveEdit)
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('flex-grow')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$input,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$type_('text'),
												$elm$html$Html$Attributes$placeholder(texts.dX),
												$elm$html$Html$Events$onInput($author$project$Page$Detail$Data$SetName),
												$elm$html$Html$Attributes$value(
												A2($elm$core$Maybe$withDefault, '', v)),
												$elm$html$Html$Attributes$class($author$project$Styles$textInput),
												$author$project$Util$Html$onKeyUpCode($author$project$Page$Detail$Data$EditKey)
											]),
										_List_Nil)
									])),
								saveButton,
								cancelButton
							]))
					]);
			case 1:
				var _v1 = ef.a;
				var im = _v1.a;
				var n = _v1.b;
				return _List_fromArray(
					[
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$classList(
								_List_fromArray(
									[
										_Utils_Tuple2(
										'error',
										_Utils_eq(n, $elm$core$Maybe$Nothing))
									])),
								$elm$html$Html$Attributes$class('flex flex-row')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('flex-grow')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$map,
										$author$project$Page$Detail$Data$MaxViewMsg,
										A2($author$project$Comp$IntInput$view, n, im))
									])),
								saveButton,
								cancelButton
							]))
					]);
			case 2:
				var _v2 = ef.a;
				var vm = _v2.a;
				var v = _v2.b;
				return _List_fromArray(
					[
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('flex flex-row')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('flex-grow text-base font-normal')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$map,
										$author$project$Page$Detail$Data$ValidityEditMsg,
										A4($author$project$Comp$ValidityField$view, texts.ad, flags, v, vm))
									])),
								saveButton,
								cancelButton
							]))
					]);
			default:
				var _v3 = ef.a;
				var pm = _v3.a;
				var p = _v3.b;
				return _List_fromArray(
					[
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('flex flex-row')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('flex-grow mr-2')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$map,
										$author$project$Page$Detail$Data$PasswordEditMsg,
										A4(
											$author$project$Comp$PasswordInput$view,
											{h5: ''},
											p,
											false,
											pm))
									])),
								saveButton,
								cancelButton
							]))
					]);
		}
	});
var $author$project$Styles$publishError = 'text-red-500 fa fa-bolt';
var $author$project$Styles$published = 'text-green-500 fa fa-circle';
var $author$project$Styles$unpublished = 'fa fa-circle font-thin';
var $author$project$Page$Detail$View$publishIconLabel = F2(
	function (texts, share) {
		var _v0 = $author$project$Page$Detail$Data$isPublished(share);
		switch (_v0) {
			case 0:
				return _Utils_Tuple2($author$project$Styles$unpublished, texts.bv);
			case 2:
				return _Utils_Tuple2($author$project$Styles$publishError, texts.b3);
			case 3:
				return _Utils_Tuple2($author$project$Styles$publishError, texts.b3);
			default:
				return _Utils_Tuple2($author$project$Styles$published, texts.b3);
		}
	});
var $author$project$Page$Detail$View$shareProps = F3(
	function (texts, flags, model) {
		var share = model.gm;
		var propertyDisplay = F2(
			function (icon, content) {
				return _List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class(icon),
								$elm$html$Html$Attributes$class('mr-2')
							]),
						_List_Nil),
						$elm$html$Html$text(content)
					]);
			});
		var deleteModal = A5($author$project$Comp$ConfirmModal$defaultSettings, $author$project$Page$Detail$Data$DeleteConfirm, $author$project$Page$Detail$Data$DeleteCancel, texts.eK.g2, texts.eK.gZ, texts.eK.dU);
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2('hidden', model.gz !== 1)
							])),
						$elm$html$Html$Attributes$class('flex flex-col mt-2 rounded pt-2 ' + $author$project$Styles$box)
					]),
				_List_fromArray(
					[
						$author$project$Comp$ConfirmModal$view(
						_Utils_update(
							deleteModal,
							{da: model.e2 === 1})),
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('flex flex-col md:flex-row')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('flex flex-col w-full md:w-1/2 px-2')
									]),
								_List_fromArray(
									[
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												$elm$core$Maybe$withDefault,
												A2(
													propertyDisplay,
													'fa fa-comment font-thin',
													A2($elm$core$Maybe$withDefault, '', share.dX)),
												A2(
													$elm$core$Maybe$map,
													A2($author$project$Page$Detail$View$propertyEdit, texts, flags),
													A2($author$project$Page$Detail$Data$isEdit, model, 0))),
											u: $elm$core$Maybe$Just(
												$author$project$Page$Detail$Data$ReqEdit(0)),
											hx: texts.dX
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												$elm$core$Maybe$withDefault,
												A2(
													propertyDisplay,
													'fa fa-hourglass-half',
													A3($author$project$Data$ValidityOptions$findValidityItemMillis, texts.ad, flags, share.eF).a),
												A2(
													$elm$core$Maybe$map,
													A2($author$project$Page$Detail$View$propertyEdit, texts, flags),
													A2($author$project$Page$Detail$Data$isEdit, model, 2))),
											u: $elm$core$Maybe$Just(
												$author$project$Page$Detail$Data$ReqEdit(2)),
											hx: texts.eF
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												$elm$core$Maybe$withDefault,
												A2(
													propertyDisplay,
													'fa fa-eye',
													$elm$core$String$fromInt(share.dS)),
												A2(
													$elm$core$Maybe$map,
													A2($author$project$Page$Detail$View$propertyEdit, texts, flags),
													A2($author$project$Page$Detail$Data$isEdit, model, 1))),
											u: $elm$core$Maybe$Just(
												$author$project$Page$Detail$Data$ReqEdit(1)),
											hx: texts.dS
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												$elm$core$Maybe$withDefault,
												A2(
													propertyDisplay,
													share.d4 ? 'fa fa-lock' : 'fa fa-unlock',
													share.d4 ? texts.br : texts.bp),
												A2(
													$elm$core$Maybe$map,
													A2($author$project$Page$Detail$View$propertyEdit, texts, flags),
													A2($author$project$Page$Detail$Data$isEdit, model, 3))),
											u: $elm$core$Maybe$Just(
												$author$project$Page$Detail$Data$ReqEdit(3)),
											hx: texts.d4
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												propertyDisplay,
												'fa fa-file',
												$elm$core$String$fromInt(
													$elm$core$List$length(model.gm.dh)) + ('/' + A2(
													$author$project$Util$Size$bytesReadable,
													3,
													$elm$core$List$sum(
														A2(
															$elm$core$List$map,
															function ($) {
																return $.en;
															},
															model.gm.dh))))),
											u: $elm$core$Maybe$Nothing,
											hx: texts.bR
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												propertyDisplay,
												'fa fa-calendar',
												texts.eZ(share.c0)),
											u: $elm$core$Maybe$Nothing,
											hx: texts.c0
										})
									])),
								A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('flex flex-col w-full md:w-1/2 px-2')
									]),
								_List_fromArray(
									[
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												propertyDisplay,
												'fa fa-dot-circle font-thin',
												A2($elm$core$Maybe$withDefault, '-', share.cN)),
											u: $elm$core$Maybe$Nothing,
											hx: texts.gR
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												propertyDisplay,
												A2($author$project$Page$Detail$View$publishIconLabel, texts, share).a,
												A2(
													$elm$core$Maybe$withDefault,
													'-',
													A2(
														$elm$core$Maybe$map,
														texts.eZ,
														A2(
															$elm$core$Maybe$map,
															function ($) {
																return $.d9;
															},
															share.ea)))),
											u: $elm$core$Maybe$Nothing,
											hx: texts.bx
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												propertyDisplay,
												'fa fa-hourglass',
												A2(
													$elm$core$Maybe$withDefault,
													'-',
													A2(
														$elm$core$Maybe$map,
														texts.eZ,
														A2(
															$elm$core$Maybe$map,
															function ($) {
																return $.eb;
															},
															share.ea)))),
											u: $elm$core$Maybe$Nothing,
											hx: texts.by
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												propertyDisplay,
												'fa fa-calendar font-thin',
												A2(
													$elm$core$Maybe$withDefault,
													'-',
													A2(
														$elm$core$Maybe$map,
														texts.eZ,
														A2(
															$elm$core$Maybe$andThen,
															function ($) {
																return $.dI;
															},
															share.ea)))),
											u: $elm$core$Maybe$Nothing,
											hx: texts.dI
										}),
										A2(
										$author$project$Page$Detail$View$property,
										texts,
										{
											s: A2(
												propertyDisplay,
												'fa fa-eye',
												A2(
													$elm$core$Maybe$withDefault,
													'-',
													A2(
														$elm$core$Maybe$map,
														$elm$core$String$fromInt,
														A2(
															$elm$core$Maybe$map,
															function ($) {
																return $.eI;
															},
															share.ea)))),
											u: $elm$core$Maybe$Nothing,
											hx: texts.eI
										})
									]))
							])),
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('h-px w-full'),
								$elm$html$Html$Attributes$class($author$project$Styles$border)
							]),
						_List_Nil),
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$classList(
								_List_fromArray(
									[
										_Utils_Tuple2('hidden', model.gz !== 1)
									])),
								$elm$html$Html$Attributes$class('flex flex-row px-2 py-2')
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$a,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$classList(
										_List_fromArray(
											[
												_Utils_Tuple2(
												'hidden',
												!(!$author$project$Page$Detail$Data$isPublished(share)))
											])),
										$elm$html$Html$Attributes$class('mr-2'),
										$elm$html$Html$Attributes$class($author$project$Styles$secondaryButton),
										$elm$html$Html$Events$onClick(
										$author$project$Page$Detail$Data$PublishShare(false)),
										$elm$html$Html$Attributes$href('#')
									]),
								_List_fromArray(
									[
										$elm$html$Html$text(texts.bw)
									])),
								A2(
								$elm$html$Html$a,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class($author$project$Styles$deleteButton),
										$elm$html$Html$Events$onClick($author$project$Page$Detail$Data$RequestDelete),
										$elm$html$Html$Attributes$href('#')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$i,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class('fa fa-trash mr-2')
											]),
										_List_Nil),
										$elm$html$Html$text(texts.e0)
									]))
							]))
					]))
			]);
	});
var $elm$core$String$lines = _String_lines;
var $author$project$Util$Share$splitDescription = F2(
	function (share, defaultHeader) {
		var fallback = A2(
			$elm$core$Maybe$withDefault,
			'# ' + defaultHeader,
			A2(
				$elm$core$Maybe$map,
				function (n) {
					return '# ' + n;
				},
				share.dX));
		var desc = A2(
			$elm$core$Maybe$withDefault,
			'',
			A2($elm$core$Maybe$map, $elm$core$String$trim, share.c5));
		var lines = $elm$core$String$lines(desc);
		if (!lines.b) {
			return _Utils_Tuple2(fallback, desc);
		} else {
			var first = lines.a;
			var rest = lines.b;
			return A2(
				$elm$core$String$startsWith,
				'#',
				$elm$core$String$trim(first)) ? _Utils_Tuple2(
				first,
				A2($elm$core$String$join, '\n', rest)) : _Utils_Tuple2(fallback, desc);
		}
	});
var $author$project$Comp$MenuBar$BasicButton = function (a) {
	return {$: 6, a: a};
};
var $author$project$Page$Detail$Data$SetTopMenu = function (a) {
	return {$: 2, a: a};
};
var $author$project$Page$Detail$View$topMenu = F2(
	function (texts, model) {
		var share = model.gm;
		var _v0 = A2($author$project$Page$Detail$View$publishIconLabel, texts, share);
		var publishIcon = _v0.a;
		var label = _v0.b;
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: !_Utils_eq(model.e3, $elm$core$Maybe$Nothing),
							dt: $elm$core$Maybe$Just('fa fa-edit'),
							hx: '',
							cI: $author$project$Page$Detail$Data$ToggleEditDesc,
							eA: texts.aW
						}),
						$author$project$Comp$MenuBar$BasicButton(
						{
							dt: $elm$core$Maybe$Just(publishIcon),
							hx: label,
							cI: $author$project$Page$Detail$Data$PublishShare(true),
							eA: ''
						})
					]),
				$8: 'mt-3',
				it: _List_fromArray(
					[
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: model.gz === 1,
							dt: $elm$core$Maybe$Just('fa fa-eye'),
							hx: texts.aT,
							cI: $author$project$Page$Detail$Data$SetTopMenu(1),
							eA: texts.aT
						}),
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: model.gz === 2,
							dt: $elm$core$Maybe$Just('fa fa-share-alt'),
							hx: texts.bN,
							cI: $author$project$Page$Detail$Data$SetTopMenu(2),
							eA: texts.bN
						}),
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: model.gz === 3,
							dt: $elm$core$Maybe$Just('fa fa-folder-plus'),
							hx: texts.aw,
							cI: $author$project$Page$Detail$Data$SetTopMenu(3),
							eA: texts.aw
						})
					]),
				iw: true
			});
	});
var $elm$html$Html$Attributes$autoplay = $elm$html$Html$Attributes$boolProperty('autoplay');
var $elm$html$Html$Attributes$controls = $elm$html$Html$Attributes$boolProperty('controls');
var $author$project$Comp$Zoom$isImage = function (file) {
	return A2($elm$core$String$startsWith, 'image/', file.dW);
};
var $author$project$Comp$Zoom$isPdf = function (file) {
	return 'application/pdf' === file.dW;
};
var $author$project$Comp$Zoom$isVideo = function (file) {
	return A2($elm$core$String$startsWith, 'video/', file.dW);
};
var $elm$html$Html$video = _VirtualDom_node('video');
var $author$project$Comp$Zoom$filePreview = F3(
	function (fileUrl, _v0, file) {
		var url = fileUrl(file.hs);
		return $author$project$Comp$Zoom$isImage(file) ? A2(
			$elm$html$Html$img,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$src(url),
					$elm$html$Html$Attributes$class('block max-h-full mx-auto')
				]),
			_List_Nil) : ($author$project$Comp$Zoom$isVideo(file) ? A2(
			$elm$html$Html$video,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$src(url),
					$elm$html$Html$Attributes$class('block max-h-full mx-auto'),
					$elm$html$Html$Attributes$controls(true),
					$elm$html$Html$Attributes$autoplay(false)
				]),
			_List_Nil) : ($author$project$Comp$Zoom$isPdf(file) ? A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('dark:bg-stone-300 bg-white')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$iframe,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$src(url),
							$elm$html$Html$Attributes$sandbox('allow-scripts'),
							$elm$html$Html$Attributes$class('w-full'),
							A2($elm$html$Html$Attributes$attribute, 'width', '100%'),
							A2($elm$html$Html$Attributes$attribute, 'height', '100%')
						]),
					_List_Nil)
				])) : A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('dark:bg-stone-300 bg-white')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$iframe,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$src(url),
							$elm$html$Html$Attributes$sandbox(''),
							$elm$html$Html$Attributes$class('w-full'),
							A2($elm$html$Html$Attributes$attribute, 'width', '100%'),
							A2($elm$html$Html$Attributes$attribute, 'height', '100%')
						]),
					_List_Nil)
				]))));
	});
var $author$project$Comp$Zoom$isText = function (file) {
	return A2($elm$core$String$startsWith, 'text/', file.dW);
};
var $author$project$Comp$Zoom$view = F4(
	function (fileUrl, model, onSelect, onQuit) {
		var sortedFiles = A2(
			$elm$core$List$sortBy,
			function ($) {
				return $.dg;
			},
			model.gm.dh);
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							'hidden',
							_Utils_eq(model.gM, $elm$core$Maybe$Nothing))
						])),
					$elm$html$Html$Attributes$class($author$project$Styles$dimmer)
				]),
			function () {
				var _v0 = model.gM;
				if (!_v0.$) {
					var file = _v0.a;
					var files = A2(
						$elm$core$List$filter,
						function (f) {
							return $author$project$Comp$ShareFileList$previewPossible(f.dW);
						},
						sortedFiles);
					var next = A2(
						$author$project$Util$List$findNext,
						function (e) {
							return _Utils_eq(e.hs, file.hs);
						},
						files);
					var prev = A2(
						$author$project$Util$List$findPrev,
						function (e) {
							return _Utils_eq(e.hs, file.hs);
						},
						files);
					return _List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-row items-center justify-end w-full md:w-11/12')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2(
													'disabled',
													_Utils_eq(prev, $elm$core$Maybe$Nothing))
												])),
											$elm$html$Html$Attributes$class($author$project$Styles$primaryButtonPlain),
											$elm$html$Html$Attributes$class('rounded-l'),
											$elm$html$Html$Events$onClick(
											onSelect(
												A2($elm$core$Maybe$withDefault, file, prev)))
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-arrow-left')
												]),
											_List_Nil)
										])),
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2('ui primary button', true),
													_Utils_Tuple2(
													'disabled',
													_Utils_eq(next, $elm$core$Maybe$Nothing))
												])),
											$elm$html$Html$Attributes$class($author$project$Styles$primaryButtonPlain),
											$elm$html$Html$Events$onClick(
											onSelect(
												A2($elm$core$Maybe$withDefault, file, next)))
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-arrow-right')
												]),
											_List_Nil)
										])),
									A2(
									$elm$html$Html$a,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Attributes$class($author$project$Styles$secondaryButtonPlain),
											$elm$html$Html$Attributes$class('rounded-r'),
											$elm$html$Html$Events$onClick(onQuit)
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$i,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('fa fa-times')
												]),
											_List_Nil)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('px-2 py-1 w-full md:w-11/12'),
									$elm$html$Html$Attributes$class($author$project$Styles$box)
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left text-sm font-mono')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(file.dg),
											$elm$html$Html$text(' ('),
											$elm$html$Html$text(
											A2($author$project$Util$Size$bytesReadable, 3, file.en)),
											$elm$html$Html$text(')')
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'',
											$author$project$Comp$Zoom$isPdf(file) || $author$project$Comp$Zoom$isText(file))
										])),
									$elm$html$Html$Attributes$class(' mx-auto flex flex-col bg-gray-800 dark:bg-stone-800 bg-opacity-90 h-screen-5/6 w-full md:w-11/12')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('h-full')
										]),
									_List_fromArray(
										[
											A3($author$project$Comp$Zoom$filePreview, fileUrl, model, file)
										]))
								]))
						]);
				} else {
					return _List_Nil;
				}
			}());
	});
var $author$project$Page$Detail$View$view = F3(
	function (texts, flags, model) {
		var _v0 = A2($author$project$Util$Share$splitDescription, model.gm, texts.cc);
		var head = _v0.a;
		var desc = _v0.b;
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content),
					$elm$html$Html$Attributes$class('mb-2')
				]),
			_Utils_ap(
				_List_fromArray(
					[
						A4(
						$author$project$Comp$Zoom$view,
						A2($author$project$Api$fileSecUrl, flags, model.gm.hs),
						model,
						$author$project$Page$Detail$Data$SetZoom,
						$author$project$Page$Detail$Data$QuitZoom),
						A2($author$project$Page$Detail$View$deleteLoader, texts, model),
						A2(
						$elm_explorations$markdown$Markdown$toHtml,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('markdown-preview')
							]),
						head),
						A2($author$project$Page$Detail$View$topMenu, texts, model)
					]),
				_Utils_ap(
					A3($author$project$Page$Detail$View$shareProps, texts, flags, model),
					_Utils_ap(
						A3($author$project$Page$Detail$View$shareLink, texts, flags, model),
						_List_fromArray(
							[
								A3($author$project$Page$Detail$View$dropzone, texts, flags, model),
								$author$project$Page$Detail$View$messageDiv(model),
								A3($author$project$Page$Detail$View$descriptionView, texts, model, desc),
								A2($author$project$Page$Detail$View$middleMenu, texts, model),
								A3($author$project$Page$Detail$View$fileList, texts, flags, model)
							])))));
	});
var $author$project$App$View$viewDetail = F3(
	function (_v0, texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$DetailMsg,
			A3($author$project$Page$Detail$View$view, texts.e5, model.fg, model.e6));
	});
var $author$project$Page$href = function (page) {
	return $elm$html$Html$Attributes$href(
		$author$project$Page$pageToString(page));
};
var $elm$html$Html$Attributes$target = $elm$html$Html$Attributes$stringProperty('target');
var $author$project$Page$Home$View$view = F2(
	function (texts, _v0) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('h-full md:h-5/6 flex flex-col justify-center items-center flex-grow flex')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('w-full px-4 py-4 mt-2 flex flex-col items-center'),
							$elm$html$Html$Attributes$class('md:w-2/3 md:mx-auto md:bg-gray-100 md:mt-8 md:px-8 md:py-8 md:shadow md:rounded-lg'),
							$elm$html$Html$Attributes$class('md:dark:bg-stone-700')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-col items-center text-4xl')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-share-alt')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('mt-2 w-full text-center')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.bL)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-col sm:flex-row justify-center w-full mt-8')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col sm:mr-2')
										]),
									_List_fromArray(
										[
											$author$project$Comp$Basic$primaryButton(
											{
												F: _List_fromArray(
													[
														$author$project$Page$href($author$project$Page$SharePage)
													]),
												t: false,
												x: $elm$html$Html$Attributes$class('text-xl sm:text-base'),
												dt: 'fa fa-upload',
												hx: texts.aP,
												O: false
											}),
											$author$project$Comp$Basic$secondaryButton(
											{
												F: _List_fromArray(
													[
														$author$project$Page$href($author$project$Page$UploadPage)
													]),
												t: false,
												x: $elm$html$Html$Attributes$class('mt-2 text-xl sm:text-base'),
												dt: 'fa fa-eye',
												hx: texts.ca,
												O: false
											})
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('mt-2 sm:mt-0 sm:ml-2 flex flex-col ')
										]),
									_List_fromArray(
										[
											$author$project$Comp$Basic$primaryButton(
											{
												F: _List_fromArray(
													[
														$author$project$Page$href(
														$author$project$Page$AliasPage(
															$elm$core$Maybe$Just('new')))
													]),
												t: false,
												x: $elm$html$Html$Attributes$class('text-xl sm:text-base'),
												dt: 'fa fa-dot-circle font-thin',
												hx: texts.aM,
												O: false
											}),
											$author$project$Comp$Basic$secondaryButton(
											{
												F: _List_fromArray(
													[
														$author$project$Page$href(
														$author$project$Page$AliasPage($elm$core$Maybe$Nothing))
													]),
												t: false,
												x: $elm$html$Html$Attributes$class('mt-2 text-xl sm:text-base'),
												dt: 'fa fa-eye',
												hx: texts.b9,
												O: false
											})
										]))
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-xs mt-2')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$link),
									$elm$html$Html$Attributes$href('https://eikek.github.io/sharry/doc/webapp'),
									$elm$html$Html$Attributes$target('_blank')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-external-link-alt mr-1')
										]),
									_List_Nil),
									$elm$html$Html$text(texts.aU)
								]))
						]))
				]));
	});
var $author$project$App$View$viewHome = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$HomeMsg,
			A2($author$project$Page$Home$View$view, texts.fm, model.fn));
	});
var $author$project$Page$Info$View$view = F2(
	function (msg, model) {
		var _v0 = A2($author$project$Util$List$get, model, msg);
		if (!_v0.$) {
			var m = _v0.a;
			return A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$content)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$h1,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class($author$project$Styles$header1)
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$i,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('fa fa-info-circle mr-2')
									]),
								_List_Nil),
								$elm$html$Html$text(m.$7)
							])),
						A2(
						$elm$html$Html$p,
						_List_Nil,
						_List_fromArray(
							[
								$elm$html$Html$text(m.iD)
							]))
					]));
		} else {
			return A2($elm$html$Html$div, _List_Nil, _List_Nil);
		}
	});
var $author$project$App$View$viewInfo = F2(
	function (msgnum, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$InfoMsg,
			A2($author$project$Page$Info$View$view, msgnum, model.ft));
	});
var $author$project$Page$Login$Data$Authenticate = {$: 2};
var $author$project$Page$Login$Data$SetPassword = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Login$Data$SetUsername = function (a) {
	return {$: 0, a: a};
};
var $elm$html$Html$Attributes$action = function (uri) {
	return A2(
		$elm$html$Html$Attributes$stringProperty,
		'action',
		_VirtualDom_noJavaScriptUri(uri));
};
var $elm$html$Html$Attributes$autofocus = $elm$html$Html$Attributes$boolProperty('autofocus');
var $author$project$Styles$boxMd = ' md:border dark:border-stone-500 bg-white dark:bg-stone-800 md:shadow-md ';
var $author$project$Page$Login$View$renderLangAndSignup = F2(
	function (texts, flags) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-row mt-6 items-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', flags.b.em === 'closed')
								])),
							$elm$html$Html$Attributes$class('flex flex-col flex-grow justify-end text-right text-sm opacity-75')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$span,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bl)
								])),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$link),
									$author$project$Page$href($author$project$Page$RegisterPage)
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-user-plus mr-1')
										]),
									_List_Nil),
									$elm$html$Html$text(texts.bX)
								]))
						]))
				]));
	});
var $author$project$Page$Login$View$renderOAuthButton = F3(
	function (texts, flags, item) {
		var url = A2($author$project$Api$oauthUrl, flags, item);
		var icon = A2($elm$core$Maybe$withDefault, 'fa fa-user', item.dt);
		return A2(
			$elm$html$Html$a,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$primaryBasicButton),
					$elm$html$Html$Attributes$class('mt-1'),
					$elm$html$Html$Attributes$href(url)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(icon)
						]),
					_List_Nil),
					A2(
					$elm$html$Html$span,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('ml-2')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(texts.b8 + (' ' + item.dX))
						]))
				]));
	});
var $author$project$Page$Login$View$renderOAuthButtons = F3(
	function (texts, flags, _v0) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('w-full mt-2')
				]),
			_List_fromArray(
				[
					flags.b.d$ ? A2($elm$html$Html$div, _List_Nil, _List_Nil) : $author$project$Comp$Basic$horizontalDivider(
					{hx: texts.h2, hz: 'px-4 bg-gray-200 bg-opacity-50', fB: 'bg-gray-300 dark:bg-slate-600', iK: 'w-full mb-4 hidden md:inline-flex'}),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-row space-x-2 flex-wrap items-center justify-center'),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('mt-2', flags.b.d$)
								]))
						]),
					A2(
						$elm$core$List$map,
						A2($author$project$Page$Login$View$renderOAuthButton, texts, flags),
						flags.b.d_))
				]));
	});
var $author$project$Page$Login$Data$AuthenticateProxy = {$: 3};
var $author$project$Page$Login$View$renderProxyAuthButton = F2(
	function (texts, flags) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-row space-x-2 flex-wrap items-center justify-center'),
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2('hidden', !flags.b.d7)
						]))
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$primaryBasicButton),
							$elm$html$Html$Attributes$class('mt-1'),
							$elm$html$Html$Attributes$href('#'),
							$elm$html$Html$Events$onClick($author$project$Page$Login$Data$AuthenticateProxy)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-right-to-bracket')
								]),
							_List_Nil),
							A2(
							$elm$html$Html$span,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('ml-2')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.a7)
								]))
						]))
				]));
	});
var $author$project$Page$Login$View$renderWelcome = function (flags) {
	var _v0 = flags.b.eJ;
	if (_v0 === '') {
		return A2(
			$elm$html$Html$span,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('hidden invisible')
				]),
			_List_Nil);
	} else {
		var msg = _v0;
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-col px-2 sm:px-4 md:px-6 lg:px-8 py-4 max-w-md')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('self-center')
						]),
					_List_fromArray(
						[
							A2($elm_explorations$markdown$Markdown$toHtml, _List_Nil, msg)
						]))
				]));
	}
};
var $author$project$Page$Login$View$resultMessage = F2(
	function (texts, model) {
		var _v0 = model.P;
		if (!_v0.$) {
			var r = _v0.a;
			return r.iA ? A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$successMessage),
						$elm$html$Html$Attributes$class('mt-2')
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(texts.a9)
					])) : A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$errorMessage),
						$elm$html$Html$Attributes$class('mt-2')
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(r.dU)
					]));
		} else {
			return A2($elm$html$Html$span, _List_Nil, _List_Nil);
		}
	});
var $author$project$Page$Login$View$view = F4(
	function (texts, flags, currentTheme, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$id('content'),
					$elm$html$Html$Attributes$class('h-full flex flex-col items-center justify-center w-full'),
					$elm$html$Html$Attributes$class($author$project$Styles$content)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col px-2 sm:px-4 py-4 rounded-md min-w-full md:min-w-0 md:w-96' + $author$project$Styles$boxMd)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('self-center')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$img,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('max-w-xs mx-auto max-h-20'),
											(!currentTheme) ? $elm$html$Html$Attributes$src(flags.b.dM) : $elm$html$Html$Attributes$src(flags.b.dN)
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$form,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$action('#'),
									$elm$html$Html$Events$onSubmit($author$project$Page$Login$Data$Authenticate),
									$elm$html$Html$Attributes$autocomplete(false),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2('hidden invisible', flags.b.dr)
										]))
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col mt-6')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$label,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$for('username'),
													$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.b6)
												])),
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('relative')
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$div,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa fa-user')
																]),
															_List_Nil)
														])),
													A2(
													$elm$html$Html$input,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$type_('text'),
															$elm$html$Html$Attributes$name('username'),
															$elm$html$Html$Attributes$autocomplete(false),
															$elm$html$Html$Events$onInput($author$project$Page$Login$Data$SetUsername),
															$elm$html$Html$Attributes$value(model.b6),
															$elm$html$Html$Attributes$autofocus(true),
															$elm$html$Html$Attributes$class('pl-10 pr-4 py-2 rounded-lg' + $author$project$Styles$textInput),
															$elm$html$Html$Attributes$placeholder(texts.a8)
														]),
													_List_Nil)
												]))
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col my-3')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$label,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$for('password'),
													$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.d4)
												])),
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('relative')
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$div,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa fa-lock')
																]),
															_List_Nil)
														])),
													A2(
													$elm$html$Html$input,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$type_('password'),
															$elm$html$Html$Attributes$autocomplete(false),
															$elm$html$Html$Events$onInput($author$project$Page$Login$Data$SetPassword),
															$elm$html$Html$Attributes$value(model.d4),
															$elm$html$Html$Attributes$class('pl-10 pr-4 py-2 rounded-lg' + $author$project$Styles$textInput),
															$elm$html$Html$Attributes$placeholder(texts.bq)
														]),
													_List_Nil)
												]))
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col my-3')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$button,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$type_('submit'),
													$elm$html$Html$Attributes$class($author$project$Styles$primaryButton)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.a7)
												]))
										]))
								])),
							$elm$core$List$isEmpty(flags.b.d_) ? A2($elm$html$Html$div, _List_Nil, _List_Nil) : A3($author$project$Page$Login$View$renderOAuthButtons, texts, flags, model),
							A2($author$project$Page$Login$View$renderProxyAuthButton, texts, flags),
							A2($author$project$Page$Login$View$resultMessage, texts, model),
							A2($author$project$Page$Login$View$renderLangAndSignup, texts, flags)
						])),
					$author$project$Page$Login$View$renderWelcome(flags)
				]));
	});
var $author$project$App$View$viewLogin = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$LoginMsg,
			A4($author$project$Page$Login$View$view, texts.dK, model.fg, model.eC, model.fG));
	});
var $author$project$Page$NewInvite$Data$GenerateInvite = {$: 1};
var $author$project$Page$NewInvite$Data$Reset = {$: 2};
var $author$project$Page$NewInvite$Data$SetPassword = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$NewInvite$View$inviteMessage = F2(
	function (texts, flags) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$message),
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2('hidden', flags.b.em !== 'invite')
						]))
				]),
			A2(
				$elm$core$List$map,
				$elm$html$Html$map(
					function (_v0) {
						return $author$project$Page$NewInvite$Data$Reset;
					}),
				texts.dU));
	});
var $author$project$Page$NewInvite$Data$isFailed = function (state) {
	if (state.$ === 1) {
		return true;
	} else {
		return false;
	}
};
var $author$project$Page$NewInvite$Data$isSuccess = function (state) {
	if (state.$ === 2) {
		return true;
	} else {
		return false;
	}
};
var $author$project$Page$NewInvite$View$resultMessage = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							$author$project$Styles$errorMessage,
							$author$project$Page$NewInvite$Data$isFailed(model.P)),
							_Utils_Tuple2(
							$author$project$Styles$successMessage,
							$author$project$Page$NewInvite$Data$isSuccess(model.P)),
							_Utils_Tuple2(
							'hidden',
							_Utils_eq(model.P, $author$project$Page$NewInvite$Data$Empty))
						]))
				]),
			_List_fromArray(
				[
					function () {
					var _v0 = model.P;
					switch (_v0.$) {
						case 1:
							var err = _v0.a;
							return $elm$html$Html$text(err);
						case 2:
							var r = _v0.a;
							return A2(
								$elm$html$Html$div,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('')
									]),
								_List_fromArray(
									[
										A2(
										$elm$html$Html$div,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class('text-xl mb-3')
											]),
										_List_fromArray(
											[
												$elm$html$Html$text(texts.iA),
												$elm$html$Html$text(', '),
												$elm$html$Html$text(texts.a4)
											])),
										A2($elm$html$Html$p, _List_Nil, _List_Nil),
										A2(
										$elm$html$Html$pre,
										_List_fromArray(
											[
												$elm$html$Html$Attributes$class('text-center font-mono mt-4')
											]),
										_List_fromArray(
											[
												$elm$html$Html$text(
												A2($elm$core$Maybe$withDefault, '', r.dH))
											]))
									]));
						default:
							return A2(
								$elm$html$Html$span,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('hidden')
									]),
								_List_Nil);
					}
				}()
				]));
	});
var $author$project$Page$NewInvite$View$view = F3(
	function (texts, flags, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$h1,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header1)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-pencil-alt mr-2')
								]),
							_List_Nil),
							$elm$html$Html$text(texts.aO)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('mb-4')
						]),
					_List_fromArray(
						[
							A2($author$project$Page$NewInvite$View$inviteMessage, texts, flags)
						])),
					A2(
					$elm$html$Html$form,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$action('#'),
							$elm$html$Html$Attributes$autocomplete(false),
							$elm$html$Html$Events$onSubmit($author$project$Page$NewInvite$Data$GenerateInvite)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-col')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$for('invitekey'),
											$elm$html$Html$Attributes$class('mb-1 text-xs sm:text-sm tracking-wide ')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.a4)
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('relative')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('inline-flex items-center justify-center'),
													$elm$html$Html$Attributes$class('absolute left-0 top-0 h-full w-10'),
													$elm$html$Html$Attributes$class('text-gray-400 dark:text-slate-400')
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$i,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class('fa fa-key')
														]),
													_List_Nil)
												])),
											A2(
											$elm$html$Html$input,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$type_('password'),
													$elm$html$Html$Attributes$name('invitekey'),
													$elm$html$Html$Attributes$autocomplete(false),
													$elm$html$Html$Events$onInput($author$project$Page$NewInvite$Data$SetPassword),
													$elm$html$Html$Attributes$value(model.d4),
													$elm$html$Html$Attributes$autofocus(true),
													$elm$html$Html$Attributes$class('pl-10 pr-4 py-2 rounded-lg' + $author$project$Styles$textInput)
												]),
											_List_Nil)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-col my-3')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-row space-x-2')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$button,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$type_('submit'),
													$elm$html$Html$Attributes$class($author$project$Styles$primaryButton)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.gt)
												])),
											A2(
											$elm$html$Html$a,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class($author$project$Styles$secondaryButton),
													$elm$html$Html$Attributes$href('#'),
													$elm$html$Html$Events$onClick($author$project$Page$NewInvite$Data$Reset)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.bA)
												]))
										]))
								])),
							A2($author$project$Page$NewInvite$View$resultMessage, texts, model)
						]))
				]));
	});
var $author$project$App$View$viewNewInvite = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$NewInviteMsg,
			A3($author$project$Page$NewInvite$View$view, texts.hS, model.fg, model.fO));
	});
var $author$project$Page$OpenDetail$View$descriptionView = F2(
	function (texts, model) {
		var _v0 = A2($author$project$Util$Share$splitDescription, model.gm, texts.cc);
		var title = _v0.a;
		var desc = _v0.b;
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('markdown-preview')
				]),
			_List_fromArray(
				[
					A2($elm_explorations$markdown$Markdown$toHtml, _List_Nil, title),
					A2($elm_explorations$markdown$Markdown$toHtml, _List_Nil, desc)
				]));
	});
var $author$project$Page$OpenDetail$Data$FileListMsg = function (a) {
	return {$: 2, a: a};
};
var $author$project$Api$fileOpenUrl = F3(
	function (flags, share, fid) {
		return flags.b.c + ('/api/v2/open/share/' + (share + ('/file/' + fid)));
	});
var $author$project$Page$OpenDetail$View$shareId = function (model) {
	return A2(
		$elm$core$Maybe$withDefault,
		'',
		A2(
			$elm$core$Maybe$map,
			function ($) {
				return $.hs;
			},
			model.gm.ea));
};
var $author$project$Page$OpenDetail$View$fileList = F3(
	function (texts, flags, model) {
		var sorted = A2(
			$elm$core$List$sortBy,
			function ($) {
				return $.dg;
			},
			model.gm.dh);
		var sett = A3(
			$author$project$Comp$ShareFileList$Settings,
			A3(
				$author$project$Api$fileOpenUrl,
				flags,
				$author$project$Page$OpenDetail$View$shareId(model),
				''),
			model.fe,
			false);
		return A2(
			$elm$html$Html$map,
			$author$project$Page$OpenDetail$Data$FileListMsg,
			A4($author$project$Comp$ShareFileList$view, texts.bK, sett, sorted, model.fd));
	});
var $author$project$Page$OpenDetail$View$messageDiv = function (model) {
	return $author$project$Util$Html$resultMsgMaybe(model.dU);
};
var $author$project$Page$OpenDetail$Data$SetFileView = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$OpenDetail$View$middleMenu = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: !model.fe,
							dt: $elm$core$Maybe$Just('fa fa-list'),
							hx: '',
							cI: $author$project$Page$OpenDetail$Data$SetFileView(0),
							eA: texts.a5
						}),
						$author$project$Comp$MenuBar$ToggleButton(
						{
							gO: model.fe === 1,
							dt: $elm$core$Maybe$Just('fa fa-th'),
							hx: '',
							cI: $author$project$Page$OpenDetail$Data$SetFileView(1),
							eA: texts.aF
						})
					]),
				$8: 'my-2',
				it: _List_Nil,
				iw: false
			});
	});
var $author$project$Page$OpenDetail$Data$PasswordMsg = function (a) {
	return {$: 6, a: a};
};
var $author$project$Page$OpenDetail$Data$SubmitPassword = {$: 7};
var $elm$html$Html$h2 = _VirtualDom_node('h2');
var $author$project$Page$OpenDetail$View$passwordDialog = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2('hidden', !model.d4.da)
						])),
					$elm$html$Html$Attributes$class($author$project$Styles$dimmer)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$form,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col space-y-2'),
							$elm$html$Html$Events$onSubmit($author$project$Page$OpenDetail$Data$SubmitPassword),
							$elm$html$Html$Attributes$action('#')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$h2,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$header1),
									$elm$html$Html$Attributes$class('text-gray-100 flex flex-col items-center justify-center space-y-1')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-lock mr-2')
										]),
									_List_Nil),
									$elm$html$Html$text(texts.bt)
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-row')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$map,
									$author$project$Page$OpenDetail$Data$PasswordMsg,
									A4(
										$author$project$Comp$PasswordInput$view,
										{h5: ''},
										model.d4.fc,
										false,
										model.d4.fL)),
									A2(
									$elm$html$Html$button,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$primaryButton),
											$elm$html$Html$Attributes$class('ml-2 block'),
											$elm$html$Html$Attributes$href('#'),
											$elm$html$Html$Attributes$type_('submit')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.gt)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2($author$project$Styles$errorMessage, true),
											_Utils_Tuple2('hidden', !model.d4.eQ)
										]))
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bo)
								]))
						]))
				]));
	});
var $author$project$Page$OpenDetail$Data$QuitZoom = {$: 4};
var $author$project$Page$OpenDetail$Data$SetZoom = function (a) {
	return {$: 5, a: a};
};
var $author$project$Page$OpenDetail$View$zoomView = F2(
	function (flags, model) {
		return A4(
			$author$project$Comp$Zoom$view,
			A2(
				$author$project$Api$fileOpenUrl,
				flags,
				$author$project$Page$OpenDetail$View$shareId(model)),
			model,
			$author$project$Page$OpenDetail$Data$SetZoom,
			$author$project$Page$OpenDetail$Data$QuitZoom);
	});
var $author$project$Page$OpenDetail$View$view = F3(
	function (texts, flags, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content),
					$elm$html$Html$Attributes$class('mb-3')
				]),
			_List_fromArray(
				[
					A2($author$project$Page$OpenDetail$View$zoomView, flags, model),
					A2($author$project$Page$OpenDetail$View$passwordDialog, texts, model),
					A2($author$project$Page$OpenDetail$View$descriptionView, texts, model),
					$author$project$Page$OpenDetail$View$messageDiv(model),
					A2($author$project$Page$OpenDetail$View$middleMenu, texts, model),
					A3($author$project$Page$OpenDetail$View$fileList, texts, flags, model)
				]));
	});
var $author$project$App$View$viewOpenDetail = F3(
	function (_v0, texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$OpenDetailMsg,
			A3($author$project$Page$OpenDetail$View$view, texts.e5, model.fg, model.fX));
	});
var $author$project$Page$OpenShare$Data$DescMsg = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$OpenShare$Data$ClearFiles = {$: 2};
var $author$project$Page$OpenShare$Data$StartStopUpload = {$: 6};
var $author$project$Page$OpenShare$Data$Submit = {$: 3};
var $author$project$Comp$Basic$secondaryBasicButton = function (model) {
	return $author$project$Comp$Basic$genericButton(
		{
			ce: $author$project$Styles$secondaryBasicButtonHover,
			F: model.F,
			aE: _Utils_ap($author$project$Styles$secondaryBasicButtonMain, $author$project$Styles$secondaryBasicButtonRounded),
			t: model.t,
			x: model.x,
			dt: model.dt,
			hx: model.hx,
			O: model.O
		});
};
var $author$project$Page$OpenShare$View$controls = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$CustomElement(
						$author$project$Comp$Basic$secondaryBasicButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: !model.gD,
								x: $elm$html$Html$Events$onClick($author$project$Page$OpenShare$Data$StartStopUpload),
								dt: model.gC ? 'fa fa-play sm:mr-2' : 'fa fa-pause sm:mr-2',
								hx: model.gC ? texts.bB : texts.bu,
								O: true
							}))
					]),
				$8: '',
				it: _List_fromArray(
					[
						$author$project$Comp$MenuBar$CustomElement(
						$author$project$Comp$Basic$primaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: model.gD,
								x: $elm$html$Html$Events$onClick($author$project$Page$OpenShare$Data$Submit),
								dt: 'fa fa-upload',
								hx: texts.gt,
								O: false
							})),
						$author$project$Comp$MenuBar$CustomElement(
						$author$project$Comp$Basic$secondaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: model.gD,
								x: $elm$html$Html$Events$onClick($author$project$Page$OpenShare$Data$ClearFiles),
								dt: 'fa fa-undo',
								hx: texts.aJ,
								O: true
							}))
					]),
				iw: true
			});
	});
var $author$project$Page$OpenShare$Data$ResetForm = {$: 8};
var $author$project$Page$OpenShare$View$doneMessageBox = F3(
	function (_v0, texts, _v1) {
		var err = _v0.b;
		var buttons = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-row space-x-2')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$primaryButton),
							$elm$html$Html$Attributes$href('#'),
							$elm$html$Html$Events$onClick($author$project$Page$OpenShare$Data$ResetForm)
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(texts.bH)
						]))
				]));
		var error = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$errorMessage),
					$elm$html$Html$Attributes$class('flex flex-row items-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('fa fa-meh text-2xl mr-2')
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$header2)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bZ)
								])),
							A2(
							$elm$html$Html$p,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-2')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.b_)
								])),
							buttons
						]))
				]));
		var success = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$successMessage),
					$elm$html$Html$Attributes$class('flex flex-row items-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('fa fa-check text-2xl mr-2')
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$header2)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.aB)
								])),
							buttons
						]))
				]));
		return (err > 0) ? error : success;
	});
var $author$project$Data$Flags$limitsMessage = F3(
	function (texts, flags, attr) {
		var size = A2($author$project$Util$Size$bytesReadable, 3, flags.b.dP);
		return A2(
			$elm$html$Html$div,
			attr,
			_List_fromArray(
				[
					$elm$html$Html$text(
					texts.iP(size))
				]));
	});
var $author$project$Page$OpenShare$View$mkViewSettings = function (model) {
	return A2($author$project$Comp$Dropzone2$mkViewSettings, !model.gD, model.iO);
};
var $author$project$Page$OpenShare$View$view = F4(
	function (texts, flags, _v0, model) {
		var counts = $author$project$Data$UploadDict$countDone(model.iO);
		var allDone = (!_Utils_eq(model.gn, $elm$core$Maybe$Nothing)) && _Utils_eq(
			counts.a + counts.b,
			$elm$core$List$length(model.iO.il));
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$h1,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header1)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-upload mr-2')
								]),
							_List_Nil),
							$elm$html$Html$text(texts.bG)
						])),
					allDone ? A3($author$project$Page$OpenShare$View$doneMessageBox, counts, texts, model) : A2($author$project$Page$OpenShare$View$controls, texts, model),
					A3(
					$author$project$Data$Flags$limitsMessage,
					texts,
					flags,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('py-2')
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$errorMessage),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', model.fi.iA && (counts.b <= 0))
								]))
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(model.fi.dU)
						])),
					A2(
					$elm$html$Html$map,
					$author$project$Page$OpenShare$Data$DropzoneMsg,
					A3(
						$author$project$Comp$Dropzone2$view,
						texts.aV,
						$author$project$Page$OpenShare$View$mkViewSettings(model),
						model.e7)),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('mb-4 mt-4')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$label,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.c5)
								])),
							A2(
							$elm$html$Html$map,
							$author$project$Page$OpenShare$Data$DescMsg,
							A4(
								$author$project$Comp$MarkdownInput$view,
								texts.bb,
								_List_fromArray(
									[
										_Utils_Tuple2($author$project$Styles$border + ' py-1 px-1', true)
									]),
								model.g7,
								model.e4))
						]))
				]));
	});
var $author$project$App$View$viewOpenShare = F3(
	function (id, texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$OpenShareMsg,
			A4($author$project$Page$OpenShare$View$view, texts.gm, model.fg, id, model.fY));
	});
var $author$project$Page$Register$Data$RegisterSubmit = {$: 4};
var $author$project$Page$Register$Data$SetInvite = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$Register$Data$SetLogin = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Register$Data$SetPass1 = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Register$Data$SetPass2 = function (a) {
	return {$: 2, a: a};
};
var $author$project$Page$Register$Data$ToggleShowPass1 = {$: 5};
var $author$project$Page$Register$Data$ToggleShowPass2 = {$: 6};
var $author$project$Page$Register$View$renderLangAndSignin = function (texts) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('flex flex-row mt-6 items-center')
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('flex flex-col flex-grow justify-end text-right text-sm opacity-75')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(texts.aD)
							])),
						A2(
						$elm$html$Html$a,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class($author$project$Styles$link),
								$author$project$Page$href(
								$author$project$Page$LoginPage(
									_Utils_Tuple2($elm$core$Maybe$Nothing, false)))
							]),
						_List_fromArray(
							[
								A2(
								$elm$html$Html$i,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class('fa fa-signin mr-1')
									]),
								_List_Nil),
								$elm$html$Html$text(texts.bV)
							]))
					]))
			]));
};
var $author$project$Page$Register$View$resultMessage = F2(
	function (texts, model) {
		var _v0 = model.P;
		if (!_v0.$) {
			var r = _v0.a;
			return r.iA ? A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$successMessage)
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(texts.bz)
					])) : A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$errorMessage)
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(r.dU)
					]));
		} else {
			return $elm$core$List$isEmpty(model.e9) ? A2(
				$elm$html$Html$span,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('hidden')
					]),
				_List_Nil) : A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$errorMessage)
					]),
				A2(
					$elm$core$List$map,
					function (s) {
						return A2(
							$elm$html$Html$div,
							_List_Nil,
							_List_fromArray(
								[
									$elm$html$Html$text(s)
								]));
					},
					model.e9));
		}
	});
var $author$project$Page$Register$View$view = F4(
	function (texts, flags, currentTheme, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$id('content'),
					$elm$html$Html$Attributes$class('h-full flex flex-col items-center justify-center w-full'),
					$elm$html$Html$Attributes$class($author$project$Styles$content)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col px-2 sm:px-4 py-4 rounded-md min-w-full md:min-w-0 md:w-96' + $author$project$Styles$boxMd)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('self-center')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$img,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('max-w-xs mx-auto max-h-20'),
											(!currentTheme) ? $elm$html$Html$Attributes$src(flags.b.dM) : $elm$html$Html$Attributes$src(flags.b.dN)
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('text-4xl font-serif italic tracking-wider font-bold self-center my-2')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bW)
								])),
							A2(
							$elm$html$Html$form,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('ui large error form raised segment'),
									$elm$html$Html$Events$onSubmit($author$project$Page$Register$Data$RegisterSubmit),
									$elm$html$Html$Attributes$autocomplete(false)
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col mt-6')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$label,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$for('username'),
													$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.b5),
													$author$project$Comp$Basic$inputRequired
												])),
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('relative')
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$div,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa fa-user')
																]),
															_List_Nil)
														])),
													A2(
													$elm$html$Html$input,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$type_('text'),
															$elm$html$Html$Attributes$name('collective'),
															$elm$html$Html$Attributes$autocomplete(false),
															$elm$html$Html$Events$onInput($author$project$Page$Register$Data$SetLogin),
															$elm$html$Html$Attributes$value(model.dK),
															$elm$html$Html$Attributes$autofocus(true),
															$elm$html$Html$Attributes$class('pl-10 pr-4 py-2 rounded-lg' + $author$project$Styles$textInput),
															$elm$html$Html$Attributes$placeholder(texts.b5)
														]),
													_List_Nil)
												]))
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col my-3')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$label,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$for('passw1'),
													$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.d4),
													$author$project$Comp$Basic$inputRequired
												])),
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('relative')
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$div,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa'),
																	model.gq ? $elm$html$Html$Attributes$class('fa-lock-open') : $elm$html$Html$Attributes$class('fa-lock')
																]),
															_List_Nil)
														])),
													A2(
													$elm$html$Html$input,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$type_(
															model.gq ? 'text' : 'password'),
															$elm$html$Html$Attributes$name('passw1'),
															$elm$html$Html$Attributes$autocomplete(false),
															$elm$html$Html$Events$onInput($author$project$Page$Register$Data$SetPass1),
															$elm$html$Html$Attributes$value(model.f1),
															$elm$html$Html$Attributes$class('pl-10 pr-10 py-2 rounded-lg' + $author$project$Styles$textInput),
															$elm$html$Html$Attributes$placeholder(texts.d4)
														]),
													_List_Nil),
													A2(
													$elm$html$Html$a,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputLeftIconLink),
															$elm$html$Html$Events$onClick($author$project$Page$Register$Data$ToggleShowPass1),
															$elm$html$Html$Attributes$href('#')
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa fa-eye')
																]),
															_List_Nil)
														]))
												]))
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col my-3')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$label,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$for('passw2'),
													$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.bs),
													$author$project$Comp$Basic$inputRequired
												])),
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('relative')
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$div,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa'),
																	model.gr ? $elm$html$Html$Attributes$class('fa-lock-open') : $elm$html$Html$Attributes$class('fa-lock')
																]),
															_List_Nil)
														])),
													A2(
													$elm$html$Html$input,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$type_(
															model.gr ? 'text' : 'password'),
															$elm$html$Html$Attributes$name('passw2'),
															$elm$html$Html$Attributes$autocomplete(false),
															$elm$html$Html$Events$onInput($author$project$Page$Register$Data$SetPass2),
															$elm$html$Html$Attributes$value(model.f2),
															$elm$html$Html$Attributes$class('pl-10 pr-10 py-2 rounded-lg' + $author$project$Styles$textInput),
															$elm$html$Html$Attributes$placeholder(texts.bs)
														]),
													_List_Nil),
													A2(
													$elm$html$Html$a,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputLeftIconLink),
															$elm$html$Html$Events$onClick($author$project$Page$Register$Data$ToggleShowPass2),
															$elm$html$Html$Attributes$href('#')
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa fa-eye')
																]),
															_List_Nil)
														]))
												]))
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col my-3'),
											$elm$html$Html$Attributes$classList(
											_List_fromArray(
												[
													_Utils_Tuple2('hidden', flags.b.em !== 'invite')
												]))
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$label,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$for('invitekey'),
													$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.a4),
													$author$project$Comp$Basic$inputRequired
												])),
											A2(
											$elm$html$Html$div,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$class('relative')
												]),
											_List_fromArray(
												[
													A2(
													$elm$html$Html$div,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$class($author$project$Styles$inputIcon)
														]),
													_List_fromArray(
														[
															A2(
															$elm$html$Html$i,
															_List_fromArray(
																[
																	$elm$html$Html$Attributes$class('fa fa-key')
																]),
															_List_Nil)
														])),
													A2(
													$elm$html$Html$input,
													_List_fromArray(
														[
															$elm$html$Html$Attributes$type_('text'),
															$elm$html$Html$Attributes$name('invitekey'),
															$elm$html$Html$Attributes$autocomplete(false),
															$elm$html$Html$Events$onInput($author$project$Page$Register$Data$SetInvite),
															$elm$html$Html$Attributes$value(
															A2($elm$core$Maybe$withDefault, '', model.dF)),
															$elm$html$Html$Attributes$class('pl-10 pr-4 py-2 rounded-lg' + $author$project$Styles$textInput),
															$elm$html$Html$Attributes$placeholder(texts.a4)
														]),
													_List_Nil)
												]))
										])),
									A2(
									$elm$html$Html$div,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('flex flex-col my-3')
										]),
									_List_fromArray(
										[
											A2(
											$elm$html$Html$button,
											_List_fromArray(
												[
													$elm$html$Html$Attributes$type_('submit'),
													$elm$html$Html$Attributes$class($author$project$Styles$primaryButton)
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(texts.b0)
												]))
										])),
									A2($author$project$Page$Register$View$resultMessage, texts, model),
									$author$project$Page$Register$View$renderLangAndSignin(texts)
								]))
						]))
				]));
	});
var $author$project$App$View$viewRegister = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$RegisterMsg,
			A4($author$project$Page$Register$View$view, texts.ia, model.fg, model.eC, model.gb));
	});
var $author$project$Page$Settings$View$banner = function (model) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$classList(
				_List_fromArray(
					[
						_Utils_Tuple2(
						'hidden',
						_Utils_eq(model.eR, $elm$core$Maybe$Nothing)),
						_Utils_Tuple2(
						$author$project$Styles$errorMessage,
						_Utils_eq(
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.iA;
								},
								model.eR),
							$elm$core$Maybe$Just(false))),
						_Utils_Tuple2(
						$author$project$Styles$successMessage,
						_Utils_eq(
							A2(
								$elm$core$Maybe$map,
								function ($) {
									return $.iA;
								},
								model.eR),
							$elm$core$Maybe$Just(true)))
					]))
			]),
		_List_fromArray(
			[
				$elm$html$Html$text(
				A2(
					$elm$core$Maybe$withDefault,
					'',
					A2(
						$elm$core$Maybe$map,
						function ($) {
							return $.iD;
						},
						model.eR)))
			]));
};
var $author$project$Page$Settings$Data$SetNewPassword1 = function (a) {
	return {$: 4, a: a};
};
var $author$project$Page$Settings$Data$SetNewPassword2 = function (a) {
	return {$: 5, a: a};
};
var $author$project$Page$Settings$Data$SetOldPassword = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$Settings$Data$SubmitPassword = {$: 6};
var $author$project$Page$Settings$View$changePasswordForm = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							'invisible',
							_Utils_eq(
								model.f3,
								$elm$core$Maybe$Just(false)))
						])),
					$elm$html$Html$Attributes$class('flex flex-col')
				]),
			_List_fromArray(
				[
					$author$project$Comp$Basic$loadingDimmer(
					{
						gO: _Utils_eq(model.f3, $elm$core$Maybe$Nothing),
						hx: ''
					}),
					A2(
					$elm$html$Html$h2,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header2)
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(texts.aH)
						])),
					A2(
					$elm$html$Html$form,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.aQ),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Page$Settings$Data$SetOldPassword,
									A4(
										$author$project$Comp$PasswordInput$view,
										{h5: ''},
										model.fV,
										false,
										model.fW))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dY),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Page$Settings$Data$SetNewPassword1,
									A4(
										$author$project$Comp$PasswordInput$view,
										{h5: ''},
										model.fP,
										false,
										model.fR))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.bj),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Page$Settings$Data$SetNewPassword2,
									A4(
										$author$project$Comp$PasswordInput$view,
										{h5: ''},
										model.fQ,
										false,
										model.fS))
								]))
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-row')
						]),
					_List_fromArray(
						[
							$author$project$Comp$MenuBar$viewItem(
							$author$project$Comp$MenuBar$PrimaryButton(
								{
									dt: $elm$core$Maybe$Just('fa fa-save'),
									hx: texts.gt,
									cI: $author$project$Page$Settings$Data$SubmitPassword,
									eA: texts.gt
								}))
						]))
				]));
	});
var $author$project$Page$Settings$Data$SetEmail = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Settings$Data$SubmitEmail = {$: 2};
var $author$project$Page$Settings$View$emailForm = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-col mb-2')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$h2,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header2)
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(texts.aG)
						])),
					A2(
					$elm$html$Html$form,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-2')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.bg)
										])),
									A2(
									$elm$html$Html$input,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$type_('text'),
											$elm$html$Html$Attributes$placeholder(texts.bh),
											$elm$html$Html$Events$onInput($author$project$Page$Settings$Data$SetEmail),
											$elm$html$Html$Attributes$value(
											A2($elm$core$Maybe$withDefault, '', model.ag)),
											$elm$html$Html$Attributes$class($author$project$Styles$textInput)
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-sm opacity-70')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.b1)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('flex flex-row')
								]),
							_List_fromArray(
								[
									$author$project$Comp$MenuBar$viewItem(
									$author$project$Comp$MenuBar$PrimaryButton(
										{
											dt: $elm$core$Maybe$Just('fa fa-save'),
											hx: texts.gt,
											cI: $author$project$Page$Settings$Data$SubmitEmail,
											eA: texts.gt
										}))
								]))
						]))
				]));
	});
var $author$project$Page$Settings$View$view = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content),
					$elm$html$Html$Attributes$class('flex flex-col')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$h1,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header1)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-cog mr-2')
								]),
							_List_Nil),
							$elm$html$Html$text(texts.bI)
						])),
					$author$project$Page$Settings$View$banner(model),
					A2($author$project$Page$Settings$View$emailForm, texts, model),
					A2($author$project$Page$Settings$View$changePasswordForm, texts, model)
				]));
	});
var $author$project$App$View$viewSettings = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$SettingsMsg,
			A2($author$project$Page$Settings$View$view, texts.gk, model.gl));
	});
var $author$project$Page$Share$Data$DescMsg = function (a) {
	return {$: 4, a: a};
};
var $author$project$Page$Share$Data$MaxViewMsg = function (a) {
	return {$: 3, a: a};
};
var $author$project$Page$Share$Data$PasswordMsg = function (a) {
	return {$: 2, a: a};
};
var $author$project$Page$Share$Data$SetName = function (a) {
	return {$: 5, a: a};
};
var $author$project$Page$Share$Data$ValidityMsg = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Share$Data$ClearFiles = {$: 6};
var $author$project$Page$Share$Data$StartStopUpload = {$: 10};
var $author$project$Page$Share$Data$Submit = {$: 7};
var $author$project$Page$Share$View$controls = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$CustomElement(
						$author$project$Comp$Basic$secondaryBasicButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: !model.gD,
								x: $elm$html$Html$Events$onClick($author$project$Page$Share$Data$StartStopUpload),
								dt: model.gC ? 'fa fa-play sm:mr-2' : 'fa fa-pause sm:mr-2',
								hx: model.gC ? texts.bB : texts.bu,
								O: true
							}))
					]),
				$8: '',
				it: _List_fromArray(
					[
						$author$project$Comp$MenuBar$CustomElement(
						$author$project$Comp$Basic$primaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: model.gD,
								x: $elm$html$Html$Events$onClick($author$project$Page$Share$Data$Submit),
								dt: 'fa fa-upload',
								hx: texts.gt,
								O: false
							})),
						$author$project$Comp$MenuBar$CustomElement(
						$author$project$Comp$Basic$secondaryButton(
							{
								F: _List_fromArray(
									[
										$elm$html$Html$Attributes$href('#')
									]),
								t: model.gD,
								x: $elm$html$Html$Events$onClick($author$project$Page$Share$Data$ClearFiles),
								dt: 'fa fa-undo',
								hx: texts.aJ,
								O: true
							}))
					]),
				iw: true
			});
	});
var $author$project$Page$Share$Data$ResetForm = {$: 12};
var $author$project$Page$Share$View$doneMessageBox = F3(
	function (_v0, texts, model) {
		var err = _v0.b;
		var buttons = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('flex flex-row space-x-2')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$primaryButton),
							$elm$html$Html$Attributes$href('#'),
							$elm$html$Html$Events$onClick($author$project$Page$Share$Data$ResetForm)
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(texts.bk)
						])),
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$secondaryButton),
							$author$project$Page$href(
							$author$project$Page$DetailPage(
								A2($elm$core$Maybe$withDefault, '', model.gn)))
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(texts.a$)
						]))
				]));
		var error = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$errorMessage),
					$elm$html$Html$Attributes$class('flex flex-row items-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('fa fa-meh text-2xl mr-2')
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$header2)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.bZ)
								])),
							A2(
							$elm$html$Html$p,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-2')
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.b_),
									$elm$html$Html$text(texts.b$)
								])),
							buttons
						]))
				]));
		var success = A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$successMessage),
					$elm$html$Html$Attributes$class('flex flex-row items-center')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$i,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('fa fa-check text-2xl mr-2')
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class($author$project$Styles$header2)
								]),
							_List_fromArray(
								[
									$elm$html$Html$text(texts.aB)
								])),
							buttons
						]))
				]));
		return (err > 0) ? error : success;
	});
var $author$project$Page$Share$View$mkViewSettings = function (model) {
	return A2($author$project$Comp$Dropzone2$mkViewSettings, !model.gD, model.iO);
};
var $author$project$Comp$IntField$SetValue = $elm$core$Basics$identity;
var $author$project$Comp$IntField$view = F4(
	function (nval, texts, labelText, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('mb-4')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$label,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(labelText)
						])),
					A2(
					$elm$html$Html$input,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$type_('text'),
							$elm$html$Html$Attributes$value(
							A2(
								$elm$core$Maybe$withDefault,
								model.cz,
								A2($elm$core$Maybe$map, $elm$core$String$fromInt, nval))),
							$elm$html$Html$Events$onInput($elm$core$Basics$identity),
							$elm$html$Html$Attributes$class($author$project$Styles$textInput),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2(
									$author$project$Styles$inputErrorBorder,
									!_Utils_eq(model.M, $elm$core$Maybe$Nothing))
								]))
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('text-red-500 label', true),
									_Utils_Tuple2(
									'hidden',
									_Utils_eq(model.M, $elm$core$Maybe$Nothing))
								]))
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							A2(
								$elm$core$Maybe$withDefault,
								'',
								A2(
									$elm$core$Maybe$map,
									function (f) {
										return f(texts);
									},
									model.M)))
						]))
				]));
	});
var $author$project$Page$Share$View$view = F3(
	function (texts, flags, model) {
		var counts = $author$project$Data$UploadDict$countDone(model.iO);
		var allDone = (!_Utils_eq(model.gn, $elm$core$Maybe$Nothing)) && _Utils_eq(
			counts.a + counts.b,
			$elm$core$List$length(model.iO.il));
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content),
					$elm$html$Html$Attributes$class('flex flex-col')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$h1,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$header1)
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-share-alt mr-2')
								]),
							_List_Nil),
							$elm$html$Html$text(texts.aP)
						])),
					allDone ? A3($author$project$Page$Share$View$doneMessageBox, counts, texts, model) : A2($author$project$Page$Share$View$controls, texts, model),
					A3(
					$author$project$Data$Flags$limitsMessage,
					texts,
					flags,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('py-2')
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$Styles$errorMessage),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', model.fi.iA && (counts.b <= 0))
								]))
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(model.fi.dU)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-col')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$map,
									$author$project$Page$Share$Data$DropzoneMsg,
									A3(
										$author$project$Comp$Dropzone2$view,
										texts.aV,
										$author$project$Page$Share$View$mkViewSettings(model),
										model.e7))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.c5)
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Page$Share$Data$DescMsg,
									A4(
										$author$project$Comp$MarkdownInput$view,
										texts.bb,
										_List_fromArray(
											[
												_Utils_Tuple2($author$project$Styles$border + ' py-1 px-1', true)
											]),
										model.g7,
										model.e4))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dX)
										])),
									A2(
									$elm$html$Html$input,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$type_('text'),
											$elm$html$Html$Attributes$placeholder(texts.bd),
											$elm$html$Html$Attributes$class($author$project$Styles$textInput),
											$elm$html$Html$Events$onInput($author$project$Page$Share$Data$SetName)
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.eF),
											$author$project$Comp$Basic$inputRequired
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Page$Share$Data$ValidityMsg,
									A4($author$project$Comp$ValidityField$view, texts.ad, flags, model.ad, model.cp))
								])),
							A2(
							$elm$html$Html$map,
							$author$project$Page$Share$Data$MaxViewMsg,
							A4($author$project$Comp$IntField$view, model.dR, texts.a3, texts.bc, model.fI)),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('mb-4')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$label,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$inputLabel)
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.d4)
										])),
									A2(
									$elm$html$Html$map,
									$author$project$Page$Share$Data$PasswordMsg,
									A4(
										$author$project$Comp$PasswordInput$view,
										{h5: ''},
										model.Z,
										false,
										model.ci))
								]))
						]))
				]));
	});
var $author$project$App$View$viewShare = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$ShareMsg,
			A3($author$project$Page$Share$View$view, texts.gm, model.fg, model.go));
	});
var $author$project$Page$Upload$Data$ShareTableMsg = function (a) {
	return {$: 0, a: a};
};
var $author$project$Page$Upload$Data$InitNewShare = {$: 4};
var $author$project$Page$Upload$Data$SetQuery = function (a) {
	return {$: 1, a: a};
};
var $author$project$Page$Upload$View$searchArea = F2(
	function (texts, model) {
		return $author$project$Comp$MenuBar$view(
			{
				hg: _List_fromArray(
					[
						$author$project$Comp$MenuBar$PrimaryButton(
						{
							dt: $elm$core$Maybe$Just('fa fa-plus'),
							hx: texts.bk,
							cI: $author$project$Page$Upload$Data$InitNewShare,
							eA: texts.bk
						})
					]),
				$8: 'mb-4',
				it: _List_fromArray(
					[
						$author$project$Comp$MenuBar$TextInput(
						{
							dt: $elm$core$Maybe$Just('fa fa-search'),
							h5: texts.bD,
							cI: $author$project$Page$Upload$Data$SetQuery,
							eG: model.h7
						})
					]),
				iw: true
			});
	});
var $author$project$Comp$ShareTable$Select = $elm$core$Basics$identity;
var $author$project$Comp$ShareTable$aliasLink = function (item) {
	return A2(
		$elm$html$Html$a,
		_List_fromArray(
			[
				$author$project$Page$href(
				$author$project$Page$AliasPage(
					$elm$core$Maybe$Just(item.hs))),
				$elm$html$Html$Attributes$class($author$project$Styles$link)
			]),
		_List_fromArray(
			[
				$elm$html$Html$text(item.dX)
			]));
};
var $author$project$Comp$ShareTable$isSelected = F2(
	function (model, item) {
		return A2(
			$elm$core$Maybe$withDefault,
			false,
			A2(
				$elm$core$Maybe$map,
				$elm$core$Basics$eq(item.hs),
				A2(
					$elm$core$Maybe$map,
					function ($) {
						return $.hs;
					},
					model.cG)));
	});
var $author$project$Comp$ShareTable$publishedState = function (item) {
	var _v0 = item.ec;
	if (!_v0.$) {
		var flag = _v0.a;
		return flag ? A2(
			$elm$html$Html$i,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$published)
				]),
			_List_Nil) : A2(
			$elm$html$Html$i,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$publishError)
				]),
			_List_Nil);
	} else {
		return A2(
			$elm$html$Html$i,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$unpublished)
				]),
			_List_Nil);
	}
};
var $author$project$Util$String$shorten = F2(
	function (max, str) {
		var len = (max / 2) | 0;
		var pref = A2($elm$core$String$left, len, str);
		var suff = A2($elm$core$String$right, len, str);
		return pref + ('…' + suff);
	});
var $author$project$Comp$ShareTable$viewTableLine = F3(
	function (texts, model, item) {
		return A2(
			$elm$html$Html$tr,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							'active',
							A2($author$project$Comp$ShareTable$isSelected, model, item))
						])),
					$elm$html$Html$Attributes$class($author$project$Styles$tableRow)
				]),
			_List_fromArray(
				[
					A2($author$project$Comp$Basic$editLinkTableCell, texts.h0, item),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							A2(
								$elm$core$Maybe$withDefault,
								A2($author$project$Util$String$shorten, 12, item.hs),
								item.dX))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-left hidden sm:table-cell')
						]),
					_List_fromArray(
						[
							A2(
							$elm$core$Maybe$withDefault,
							$elm$html$Html$text('-'),
							A2($elm$core$Maybe$map, $author$project$Comp$ShareTable$aliasLink, item.cL))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							$elm$core$String$fromInt(item.dS))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center')
						]),
					_List_fromArray(
						[
							$author$project$Comp$ShareTable$publishedState(item)
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							$elm$core$String$fromInt(item.dh))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							A2($author$project$Util$Size$bytesReadable, 3, item.en))
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(
							texts.eZ(item.c0))
						]))
				]));
	});
var $author$project$Comp$ShareTable$view = F3(
	function (texts, accounts, model) {
		return A2(
			$elm$html$Html$table,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$tableMain)
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$thead,
					_List_Nil,
					_List_fromArray(
						[
							A2(
							$elm$html$Html$tr,
							_List_Nil,
							_List_fromArray(
								[
									A2($elm$html$Html$th, _List_Nil, _List_Nil),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.hR)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-left hidden sm:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.gR)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.dS)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.ec)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.hQ)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.en)
										])),
									A2(
									$elm$html$Html$th,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('text-center hidden lg:table-cell')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.c0)
										]))
								]))
						])),
					A2(
					$elm$html$Html$tbody,
					_List_Nil,
					A2(
						$elm$core$List$map,
						A2($author$project$Comp$ShareTable$viewTableLine, texts, model),
						accounts))
				]));
	});
var $author$project$Page$Upload$View$viewList = F2(
	function (texts, model) {
		var count = $elm$core$List$length(model.gi);
		var allSize = A2(
			$author$project$Util$Size$bytesReadable,
			3,
			$elm$core$List$sum(
				A2(
					$elm$core$List$map,
					function ($) {
						return $.en;
					},
					model.gi)));
		return _List_fromArray(
			[
				A2(
				$elm$html$Html$h1,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class($author$project$Styles$header1)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('fa fa-share-alt mr-2')
							]),
						_List_Nil),
						$elm$html$Html$text(texts.cd),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('text-sm opacity-75 ml-1')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(
								'#' + ($elm$core$String$fromInt(count) + ('/' + allSize)))
							]))
					])),
				A2($author$project$Page$Upload$View$searchArea, texts, model),
				A2(
				$elm$html$Html$map,
				$author$project$Page$Upload$Data$ShareTableMsg,
				A3($author$project$Comp$ShareTable$view, texts.bS, model.gi, model.gw))
			]);
	});
var $author$project$Page$Upload$View$view = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$Styles$content)
				]),
			A2($author$project$Page$Upload$View$viewList, texts, model));
	});
var $author$project$App$View$viewUpload = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$map,
			$author$project$App$Data$UploadMsg,
			A2($author$project$Page$Upload$View$view, texts.iN, model.gB));
	});
var $author$project$App$View$mainContent = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$id('content'),
					$elm$html$Html$Attributes$class($author$project$App$View$styleContent)
				]),
			_List_fromArray(
				[
					function () {
					var _v0 = model.f$;
					switch (_v0.$) {
						case 0:
							return A2($author$project$App$View$viewHome, texts, model);
						case 1:
							return A2($author$project$App$View$viewLogin, texts, model);
						case 2:
							return A2($author$project$App$View$viewRegister, texts, model);
						case 3:
							return A2($author$project$App$View$viewNewInvite, texts, model);
						case 4:
							var n = _v0.a;
							return A2($author$project$App$View$viewInfo, n, model);
						case 5:
							var id = _v0.a;
							return A3($author$project$App$View$viewAccount, id, texts, model);
						case 6:
							var id = _v0.a;
							return A3($author$project$App$View$viewAlias, id, texts, model);
						case 7:
							return A2($author$project$App$View$viewUpload, texts, model);
						case 8:
							return A2($author$project$App$View$viewShare, texts, model);
						case 9:
							var id = _v0.a;
							return A3($author$project$App$View$viewOpenShare, id, texts, model);
						case 10:
							return A2($author$project$App$View$viewSettings, texts, model);
						case 11:
							var id = _v0.a;
							return A3($author$project$App$View$viewDetail, id, texts, model);
						default:
							var id = _v0.a;
							return A3($author$project$App$View$viewOpenDetail, id, texts, model);
					}
				}()
				]));
	});
var $author$project$App$View$styleMain = 'mt-12 flex flex-col w-full min-h-screen-12  bg-white dark:bg-stone-800 text-gray-800 dark:text-stone-300 antialiased';
var $author$project$App$Data$ToggleDarkMode = {$: 26};
var $author$project$App$View$dropdownLink = 'px-4 py-2 w-12 font-bold inline-flex h-full items-center hover:bg-indigo-200 dark:hover:bg-stone-800';
var $author$project$App$View$isAuthenticated = function (model) {
	var _v0 = model.fg.f;
	if (!_v0.$) {
		var acc = _v0.a;
		return acc.iA;
	} else {
		return false;
	}
};
var $author$project$App$View$headerNavItem = function (model) {
	return A2(
		$elm$html$Html$a,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class('inline-flex font-bold hover:bg-indigo-200 dark:hover:bg-stone-800 items-center px-4'),
				$author$project$App$View$isAuthenticated(model) ? $author$project$Page$href($author$project$Page$HomePage) : $author$project$Page$href(
				$author$project$Page$LoginPage(
					_Utils_Tuple2($elm$core$Maybe$Nothing, false)))
			]),
		_List_fromArray(
			[
				A2(
				$elm$html$Html$img,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('w-9 h-9 mr-2 block'),
						(!model.eC) ? $elm$html$Html$Attributes$src(model.fg.b.du) : $elm$html$Html$Attributes$src(model.fg.b.dv)
					]),
				_List_Nil),
				A2(
				$elm$html$Html$div,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('')
					]),
				_List_fromArray(
					[
						$elm$html$Html$text(model.fg.b.cP)
					]))
			]));
};
var $author$project$App$Data$SetLanguage = function (a) {
	return {$: 24, a: a};
};
var $author$project$App$Data$ToggleLangMenu = {$: 25};
var $author$project$App$View$dropdownItem = 'transition-colors duration-200 items-center block px-4 py-2 text-normal hover:bg-gray-200 dark:hover:bg-stone-700 dark:hover:text-stone-50';
var $author$project$App$View$dropdownMenu = ' absolute right-0 bg-white dark:bg-stone-800 border dark:border-stone-700 dark:text-stone-300 shadow-lg opacity-1 transition duration-200 min-w-max ';
var $author$project$App$View$languageMenu = F2(
	function (texts, model) {
		var langItem = function (lang) {
			var langMsg = $author$project$Messages$get(lang);
			return A2(
				$elm$html$Html$a,
				_List_fromArray(
					[
						$elm$html$Html$Attributes$classList(
						_List_fromArray(
							[
								_Utils_Tuple2($author$project$App$View$dropdownItem, true),
								_Utils_Tuple2(
								'bg-gray-200 dark:bg-stone-700',
								_Utils_eq(lang, texts.hA))
							])),
						$elm$html$Html$Events$onClick(
						$author$project$App$Data$SetLanguage(lang)),
						$elm$html$Html$Attributes$href('#')
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$i,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class(langMsg.ff)
							]),
						_List_Nil),
						A2(
						$elm$html$Html$span,
						_List_fromArray(
							[
								$elm$html$Html$Attributes$class('ml-2')
							]),
						_List_fromArray(
							[
								$elm$html$Html$text(langMsg.hx)
							]))
					]));
		};
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('relative'),
					$elm$html$Html$Attributes$classList(
					_List_fromArray(
						[
							_Utils_Tuple2(
							'hidden',
							$elm$core$List$length($author$project$Language$allLanguages) === 1)
						]))
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$App$View$dropdownLink),
							$elm$html$Html$Events$onClick($author$project$App$Data$ToggleLangMenu),
							$elm$html$Html$Attributes$href('#')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class(texts.ff)
								]),
							_List_Nil)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$App$View$dropdownMenu),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', !model.fy)
								]))
						]),
					A2($elm$core$List$map, langItem, $author$project$Language$allLanguages))
				]));
	});
var $elm$html$Html$nav = _VirtualDom_node('nav');
var $author$project$App$View$styleTopNav = 'top-0 fixed z-50 w-full flex flex-row justify-start shadow-sm h-12 bg-indigo-100 dark:bg-stone-900 text-gray-800 dark:text-stone-200 antialiased';
var $author$project$App$View$topMenuAnon = F2(
	function (texts, model) {
		return A2(
			$elm$html$Html$nav,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$id('top-nav'),
					$elm$html$Html$Attributes$class($author$project$App$View$styleTopNav)
				]),
			_List_fromArray(
				[
					$author$project$App$View$headerNavItem(model),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-grow justify-end')
						]),
					_List_fromArray(
						[
							A2($author$project$App$View$languageMenu, texts, model),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$href('#'),
									$elm$html$Html$Events$onClick($author$project$App$Data$ToggleDarkMode),
									$elm$html$Html$Attributes$class($author$project$App$View$dropdownLink)
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-adjust w-6')
										]),
									_List_Nil)
								]))
						]))
				]));
	});
var $author$project$App$Data$Logout = {$: 16};
var $author$project$App$Data$ToggleNavMenu = {$: 20};
var $elm$html$Html$hr = _VirtualDom_node('hr');
var $author$project$Data$Flags$isAutoRedirect = function (flags) {
	return $author$project$Data$Flags$isOAuthAutoRedirect(flags) || $author$project$Data$Flags$isProxyAutoRedirect(flags);
};
var $author$project$App$View$userMenu2 = F3(
	function (texts, model, acc) {
		var activeClass = function (page) {
			return $elm$html$Html$Attributes$classList(
				_List_fromArray(
					[
						_Utils_Tuple2(
						'bg-gray-200 dark:bg-stone-700',
						_Utils_eq(model.f$, page))
					]));
		};
		var pageLink = F2(
			function (page, content) {
				return A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$author$project$Page$href(page),
							activeClass(page),
							$elm$html$Html$Attributes$class($author$project$App$View$dropdownItem),
							$elm$html$Html$Events$onClick($author$project$App$Data$ToggleNavMenu)
						]),
					content);
			});
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('relative')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$a,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$App$View$dropdownLink),
							$elm$html$Html$Events$onClick($author$project$App$Data$ToggleNavMenu),
							$elm$html$Html$Attributes$href('#')
						]),
					_List_fromArray(
						[
							A2(
							$elm$html$Html$i,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('fa fa-bars w-6')
								]),
							_List_Nil)
						])),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class($author$project$App$View$dropdownMenu),
							$elm$html$Html$Attributes$classList(
							_List_fromArray(
								[
									_Utils_Tuple2('hidden', !model.fN)
								]))
						]),
					_List_fromArray(
						[
							A2(
							pageLink,
							$author$project$Page$HomePage,
							_List_fromArray(
								[
									A2(
									$elm$html$Html$img,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('h-6 w-6 mx-auto inline-block -ml-1'),
											(!model.eC) ? $elm$html$Html$Attributes$src(model.fg.b.du) : $elm$html$Html$Attributes$src(model.fg.b.dv)
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-2')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.E.fm)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('py-1')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$hr,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$border)
										]),
									_List_Nil)
								])),
							A2(
							pageLink,
							$author$project$Page$UploadPage,
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-upload w-6')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.E.el)
										]))
								])),
							A2(
							pageLink,
							$author$project$Page$AliasPage($elm$core$Maybe$Nothing),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-dot-circle font-thin w-6')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.E.gT)
										]))
								])),
							acc.cK ? A2(
							pageLink,
							$author$project$Page$AccountPage($elm$core$Maybe$Nothing),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-users w-6')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.E.gN)
										]))
								])) : A2(
							$elm$html$Html$span,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('hidden')
								]),
							_List_Nil),
							A2(
							pageLink,
							$author$project$Page$SettingsPage,
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-cog w-6')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.E.gk)
										]))
								])),
							(acc.cK && (model.fg.b.em === 'invite')) ? A2(
							pageLink,
							$author$project$Page$NewInvitePage,
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-key w-6')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.E.hT)
										]))
								])) : A2($elm$html$Html$span, _List_Nil, _List_Nil),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('py-1')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$hr,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$border)
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$href('#'),
									$elm$html$Html$Events$onClick($author$project$App$Data$ToggleDarkMode),
									$elm$html$Html$Attributes$class($author$project$App$View$dropdownItem)
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-adjust w-6')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(texts.E.hC)
										]))
								])),
							A2(
							$elm$html$Html$div,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$class('py-1')
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$hr,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class($author$project$Styles$border)
										]),
									_List_Nil)
								])),
							A2(
							$elm$html$Html$a,
							_List_fromArray(
								[
									$elm$html$Html$Attributes$href('#'),
									$elm$html$Html$Attributes$class($author$project$App$View$dropdownItem),
									$elm$html$Html$Attributes$classList(
									_List_fromArray(
										[
											_Utils_Tuple2(
											'disabled',
											$author$project$Data$Flags$isAutoRedirect(model.fg))
										])),
									$author$project$Data$Flags$isAutoRedirect(model.fg) ? $elm$html$Html$Attributes$class('') : $elm$html$Html$Events$onClick($author$project$App$Data$Logout),
									$author$project$Data$Flags$isAutoRedirect(model.fg) ? $elm$html$Html$Attributes$title(texts.E.hF) : $elm$html$Html$Attributes$title(texts.E.hG)
								]),
							_List_fromArray(
								[
									A2(
									$elm$html$Html$i,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('fa fa-sign-out-alt w-6')
										]),
									_List_Nil),
									A2(
									$elm$html$Html$span,
									_List_fromArray(
										[
											$elm$html$Html$Attributes$class('ml-1')
										]),
									_List_fromArray(
										[
											$elm$html$Html$text(
											texts.E.hE(acc.eD))
										]))
								]))
						]))
				]));
	});
var $author$project$App$View$topMenuUser = F3(
	function (account, texts, model) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class($author$project$App$View$styleTopNav)
				]),
			_List_fromArray(
				[
					$author$project$App$View$headerNavItem(model),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class('flex flex-grow justify-end')
						]),
					_List_fromArray(
						[
							A2($author$project$App$View$languageMenu, texts, model),
							A3($author$project$App$View$userMenu2, texts, model, account)
						]))
				]));
	});
var $author$project$App$View$topMenu = F2(
	function (texts, model) {
		var _v0 = model.fg.f;
		if (!_v0.$) {
			var acc = _v0.a;
			return acc.iA ? A3($author$project$App$View$topMenuUser, acc, texts, model) : A2($author$project$App$View$topMenuAnon, texts, model);
		} else {
			return A2($author$project$App$View$topMenuAnon, texts, model);
		}
	});
var $author$project$App$View$view = function (model) {
	var texts = $author$project$Messages$fromFlags(model.fg);
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$id('main'),
				$elm$html$Html$Attributes$class($author$project$App$View$styleMain),
				$elm$html$Html$Attributes$classList(
				_List_fromArray(
					[
						_Utils_Tuple2(
						'h-screen-12',
						$author$project$Page$isFixedHeight(model.f$))
					]))
			]),
		_List_fromArray(
			[
				A2($author$project$App$View$topMenu, texts, model),
				A2($author$project$App$View$mainContent, texts, model),
				$author$project$App$View$footer(model)
			]));
};
var $author$project$Main$viewDoc = function (model) {
	return {
		g: _List_fromArray(
			[
				$author$project$App$View$view(model)
			]),
		eA: model.fg.b.cP
	};
};
var $author$project$Main$main = $elm$browser$Browser$application(
	{hv: $author$project$Main$init, h_: $author$project$App$Data$NavChange, h$: $author$project$App$Data$NavRequest, iz: $author$project$Main$subscriptions, iM: $author$project$App$Update$update, iR: $author$project$Main$viewDoc});
_Platform_export({'Main':{'init':$author$project$Main$main(
	A2(
		$elm$json$Json$Decode$andThen,
		function (uiTheme) {
			return A2(
				$elm$json$Json$Decode$andThen,
				function (language) {
					return A2(
						$elm$json$Json$Decode$andThen,
						function (config) {
							return A2(
								$elm$json$Json$Decode$andThen,
								function (account) {
									return $elm$json$Json$Decode$succeed(
										{f: account, b: config, hB: language, eC: uiTheme});
								},
								A2(
									$elm$json$Json$Decode$field,
									'account',
									$elm$json$Json$Decode$oneOf(
										_List_fromArray(
											[
												$elm$json$Json$Decode$null($elm$core$Maybe$Nothing),
												A2(
												$elm$json$Json$Decode$map,
												$elm$core$Maybe$Just,
												A2(
													$elm$json$Json$Decode$andThen,
													function (validMs) {
														return A2(
															$elm$json$Json$Decode$andThen,
															function (user) {
																return A2(
																	$elm$json$Json$Decode$andThen,
																	function (token) {
																		return A2(
																			$elm$json$Json$Decode$andThen,
																			function (success) {
																				return A2(
																					$elm$json$Json$Decode$andThen,
																					function (message) {
																						return A2(
																							$elm$json$Json$Decode$andThen,
																							function (id) {
																								return A2(
																									$elm$json$Json$Decode$andThen,
																									function (admin) {
																										return $elm$json$Json$Decode$succeed(
																											{cK: admin, hs: id, dU: message, iA: success, eB: token, eD: user, eE: validMs});
																									},
																									A2($elm$json$Json$Decode$field, 'admin', $elm$json$Json$Decode$bool));
																							},
																							A2($elm$json$Json$Decode$field, 'id', $elm$json$Json$Decode$string));
																					},
																					A2($elm$json$Json$Decode$field, 'message', $elm$json$Json$Decode$string));
																			},
																			A2($elm$json$Json$Decode$field, 'success', $elm$json$Json$Decode$bool));
																	},
																	A2(
																		$elm$json$Json$Decode$field,
																		'token',
																		$elm$json$Json$Decode$oneOf(
																			_List_fromArray(
																				[
																					$elm$json$Json$Decode$null($elm$core$Maybe$Nothing),
																					A2($elm$json$Json$Decode$map, $elm$core$Maybe$Just, $elm$json$Json$Decode$string)
																				]))));
															},
															A2($elm$json$Json$Decode$field, 'user', $elm$json$Json$Decode$string));
													},
													A2($elm$json$Json$Decode$field, 'validMs', $elm$json$Json$Decode$int)))
											]))));
						},
						A2(
							$elm$json$Json$Decode$field,
							'config',
							A2(
								$elm$json$Json$Decode$andThen,
								function (welcomeMessage) {
									return A2(
										$elm$json$Json$Decode$andThen,
										function (signupMode) {
											return A2(
												$elm$json$Json$Decode$andThen,
												function (retryDelays) {
													return A2(
														$elm$json$Json$Decode$andThen,
														function (proxyOnly) {
															return A2(
																$elm$json$Json$Decode$andThen,
																function (proxyAuthEnabled) {
																	return A2(
																		$elm$json$Json$Decode$andThen,
																		function (oauthOnly) {
																			return A2(
																				$elm$json$Json$Decode$andThen,
																				function (oauthConfig) {
																					return A2(
																						$elm$json$Json$Decode$andThen,
																						function (oauthAutoRedirect) {
																							return A2(
																								$elm$json$Json$Decode$andThen,
																								function (maxValidity) {
																									return A2(
																										$elm$json$Json$Decode$andThen,
																										function (maxSize) {
																											return A2(
																												$elm$json$Json$Decode$andThen,
																												function (mailEnabled) {
																													return A2(
																														$elm$json$Json$Decode$andThen,
																														function (logoUrlDark) {
																															return A2(
																																$elm$json$Json$Decode$andThen,
																																function (logoUrl) {
																																	return A2(
																																		$elm$json$Json$Decode$andThen,
																																		function (initialTheme) {
																																			return A2(
																																				$elm$json$Json$Decode$andThen,
																																				function (initialPage) {
																																					return A2(
																																						$elm$json$Json$Decode$andThen,
																																						function (iconUrlDark) {
																																							return A2(
																																								$elm$json$Json$Decode$andThen,
																																								function (iconUrl) {
																																									return A2(
																																										$elm$json$Json$Decode$andThen,
																																										function (hideLoginForm) {
																																											return A2(
																																												$elm$json$Json$Decode$andThen,
																																												function (footerVisible) {
																																													return A2(
																																														$elm$json$Json$Decode$andThen,
																																														function (footerText) {
																																															return A2(
																																																$elm$json$Json$Decode$andThen,
																																																function (defaultValidity) {
																																																	return A2(
																																																		$elm$json$Json$Decode$andThen,
																																																		function (defaultLanguage) {
																																																			return A2(
																																																				$elm$json$Json$Decode$andThen,
																																																				function (chunkSize) {
																																																					return A2(
																																																						$elm$json$Json$Decode$andThen,
																																																						function (baseUrl) {
																																																							return A2(
																																																								$elm$json$Json$Decode$andThen,
																																																								function (authRefreshTime) {
																																																									return A2(
																																																										$elm$json$Json$Decode$andThen,
																																																										function (appName) {
																																																											return A2(
																																																												$elm$json$Json$Decode$andThen,
																																																												function (aliasMemberEnabled) {
																																																													return $elm$json$Json$Decode$succeed(
																																																														{cM: aliasMemberEnabled, cP: appName, gW: authRefreshTime, c: baseUrl, cZ: chunkSize, c3: defaultLanguage, c4: defaultValidity, dj: footerText, dk: footerVisible, dr: hideLoginForm, du: iconUrl, dv: iconUrlDark, dC: initialPage, dD: initialTheme, dM: logoUrl, dN: logoUrlDark, dO: mailEnabled, dP: maxSize, dQ: maxValidity, dZ: oauthAutoRedirect, d_: oauthConfig, d$: oauthOnly, d7: proxyAuthEnabled, d8: proxyOnly, eg: retryDelays, em: signupMode, eJ: welcomeMessage});
																																																												},
																																																												A2($elm$json$Json$Decode$field, 'aliasMemberEnabled', $elm$json$Json$Decode$bool));
																																																										},
																																																										A2($elm$json$Json$Decode$field, 'appName', $elm$json$Json$Decode$string));
																																																								},
																																																								A2($elm$json$Json$Decode$field, 'authRefreshTime', $elm$json$Json$Decode$int));
																																																						},
																																																						A2($elm$json$Json$Decode$field, 'baseUrl', $elm$json$Json$Decode$string));
																																																				},
																																																				A2($elm$json$Json$Decode$field, 'chunkSize', $elm$json$Json$Decode$int));
																																																		},
																																																		A2($elm$json$Json$Decode$field, 'defaultLanguage', $elm$json$Json$Decode$string));
																																																},
																																																A2($elm$json$Json$Decode$field, 'defaultValidity', $elm$json$Json$Decode$int));
																																														},
																																														A2($elm$json$Json$Decode$field, 'footerText', $elm$json$Json$Decode$string));
																																												},
																																												A2($elm$json$Json$Decode$field, 'footerVisible', $elm$json$Json$Decode$bool));
																																										},
																																										A2($elm$json$Json$Decode$field, 'hideLoginForm', $elm$json$Json$Decode$bool));
																																								},
																																								A2($elm$json$Json$Decode$field, 'iconUrl', $elm$json$Json$Decode$string));
																																						},
																																						A2($elm$json$Json$Decode$field, 'iconUrlDark', $elm$json$Json$Decode$string));
																																				},
																																				A2($elm$json$Json$Decode$field, 'initialPage', $elm$json$Json$Decode$string));
																																		},
																																		A2($elm$json$Json$Decode$field, 'initialTheme', $elm$json$Json$Decode$string));
																																},
																																A2($elm$json$Json$Decode$field, 'logoUrl', $elm$json$Json$Decode$string));
																														},
																														A2($elm$json$Json$Decode$field, 'logoUrlDark', $elm$json$Json$Decode$string));
																												},
																												A2($elm$json$Json$Decode$field, 'mailEnabled', $elm$json$Json$Decode$bool));
																										},
																										A2($elm$json$Json$Decode$field, 'maxSize', $elm$json$Json$Decode$int));
																								},
																								A2($elm$json$Json$Decode$field, 'maxValidity', $elm$json$Json$Decode$int));
																						},
																						A2($elm$json$Json$Decode$field, 'oauthAutoRedirect', $elm$json$Json$Decode$bool));
																				},
																				A2(
																					$elm$json$Json$Decode$field,
																					'oauthConfig',
																					$elm$json$Json$Decode$list(
																						A2(
																							$elm$json$Json$Decode$andThen,
																							function (name) {
																								return A2(
																									$elm$json$Json$Decode$andThen,
																									function (id) {
																										return A2(
																											$elm$json$Json$Decode$andThen,
																											function (icon) {
																												return $elm$json$Json$Decode$succeed(
																													{dt: icon, hs: id, dX: name});
																											},
																											A2(
																												$elm$json$Json$Decode$field,
																												'icon',
																												$elm$json$Json$Decode$oneOf(
																													_List_fromArray(
																														[
																															$elm$json$Json$Decode$null($elm$core$Maybe$Nothing),
																															A2($elm$json$Json$Decode$map, $elm$core$Maybe$Just, $elm$json$Json$Decode$string)
																														]))));
																									},
																									A2($elm$json$Json$Decode$field, 'id', $elm$json$Json$Decode$string));
																							},
																							A2($elm$json$Json$Decode$field, 'name', $elm$json$Json$Decode$string)))));
																		},
																		A2($elm$json$Json$Decode$field, 'oauthOnly', $elm$json$Json$Decode$bool));
																},
																A2($elm$json$Json$Decode$field, 'proxyAuthEnabled', $elm$json$Json$Decode$bool));
														},
														A2($elm$json$Json$Decode$field, 'proxyOnly', $elm$json$Json$Decode$bool));
												},
												A2(
													$elm$json$Json$Decode$field,
													'retryDelays',
													$elm$json$Json$Decode$list($elm$json$Json$Decode$int)));
										},
										A2($elm$json$Json$Decode$field, 'signupMode', $elm$json$Json$Decode$string));
								},
								A2($elm$json$Json$Decode$field, 'welcomeMessage', $elm$json$Json$Decode$string))));
				},
				A2(
					$elm$json$Json$Decode$field,
					'language',
					$elm$json$Json$Decode$oneOf(
						_List_fromArray(
							[
								$elm$json$Json$Decode$null($elm$core$Maybe$Nothing),
								A2($elm$json$Json$Decode$map, $elm$core$Maybe$Just, $elm$json$Json$Decode$string)
							]))));
		},
		A2(
			$elm$json$Json$Decode$field,
			'uiTheme',
			$elm$json$Json$Decode$oneOf(
				_List_fromArray(
					[
						$elm$json$Json$Decode$null($elm$core$Maybe$Nothing),
						A2($elm$json$Json$Decode$map, $elm$core$Maybe$Just, $elm$json$Json$Decode$string)
					])))))(0)}});}(this));